/**ABDB**/CREATE TABLE `#__weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `url` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__weblinks`  VALUES 
('1', '6', 'Joomla!', 'joomla', 'http://joomla.org', '', '189', '1', '0', '0000-00-00 00:00:00', '1', '1', '{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}', '*', '2013-07-11 11:45:34', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('2', '6', 'JoomlaWorks', 'joomlaworks', 'http://www.joomlaworks.net', '', '145', '1', '0', '0000-00-00 00:00:00', '2', '1', '{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}', '*', '2013-07-11 11:46:01', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('3', '30', 'K2', 'k2', 'http://getk2.org', '', '60', '1', '0', '0000-00-00 00:00:00', '3', '1', '{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}', '*', '2013-07-11 11:46:25', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('4', '30', 'W3C', 'w3c', 'http://www.w3.org', '', '60', '1', '0', '0000-00-00 00:00:00', '4', '1', '{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}', '*', '2013-07-11 11:46:49', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('5', '30', 'Google', 'google', 'http://google.com', '', '52', '1', '0', '0000-00-00 00:00:00', '5', '1', '{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}', '*', '2013-07-11 11:47:06', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}');
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '1', '[6,2,8]'),
('3', 'Special', '2', '[6,3,8]'),
('5', 'Guest', '0', '[9]');
/**ABDB**/CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__utf8_conversion`  VALUES 
('5');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_block` (`block`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=474 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('471', 'Super User', 'admin', 'admin@example.com', '$2y$10$D5JDNBX3iv4115H1//8Ee.Xxwb7HjIDyAb4wzKvP4bk37n6b6dVWO', '0', '0', '2013-06-20 15:07:41', '2021-09-14 12:39:51', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('472', 'John Doe', 'john', 'john@example.com', '7fcb7f617a2905a192c965dc8116ec56:LCqcgtXZRMDpFCcCFsJe6ljyWz4fWtkT', '0', '0', '2013-06-21 12:56:51', '0000-00-00 00:00:00', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('473', 'Jane Doe', 'jane', 'jane@example.com', 'fcee3e7bc234456f793dc37fd6bd6306:u9880nftAJiS7OJ78EyzisxwJr61o3B8', '0', '0', '2013-06-21 12:57:37', '2013-07-08 13:36:14', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('471', '8'),
('472', '2'),
('473', '2');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('1', '3', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
('2', '3', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', ''),
('3', '3', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
('4', '3', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
('5', '3', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
('6', '3', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
('7', '3', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
('8', '3', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
('9', '3', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
('10', '3', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
('11', '3', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
('12', '3', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
('13', '3', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
('14', '3', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
('15', '3', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '3.9.27.1', '', 'https://update.joomla.org/language/details3/ar-AA_details.xml', '', ''),
('16', '3', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
('17', '3', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
('18', '3', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
('19', '3', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
('20', '3', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.9.28.2', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
('21', '3', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
('22', '3', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
('23', '3', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
('24', '3', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
('25', '3', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
('26', '3', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
('27', '3', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
('28', '3', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
('29', '3', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.9.25.2', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
('30', '3', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', ''),
('31', '3', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
('32', '3', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '3.10.0.1', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
('33', '3', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
('34', '3', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
('35', '3', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
('36', '3', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '3.9.29.2', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
('37', '3', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '3.10.0.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
('38', '3', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
('39', '3', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
('40', '3', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
('41', '3', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
('42', '3', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
('43', '3', '0', 'Tamil', '', 'pkg_ta-IN', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
('44', '3', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
('45', '3', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
('46', '3', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
('47', '3', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
('48', '3', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
('49', '3', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
('50', '3', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
('51', '3', '0', 'German DE', '', 'pkg_de-DE', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
('52', '3', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
('53', '3', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
('54', '3', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
('55', '3', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
('56', '3', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
('57', '3', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
('58', '3', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
('59', '3', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
('60', '3', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', ''),
('61', '3', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
('62', '3', '0', 'English CA', '', 'pkg_en-CA', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
('63', '3', '0', 'French CA', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
('64', '3', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
('65', '3', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
('66', '3', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
('67', '3', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
('68', '3', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
('69', '3', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
('70', '3', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
('71', '3', '0', 'Spanish CO', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
('72', '3', '0', 'German CH', '', 'pkg_de-CH', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
('73', '3', '0', 'German AT', '', 'pkg_de-AT', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
('74', '3', '0', 'German LI', '', 'pkg_de-LI', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
('75', '3', '0', 'German LU', '', 'pkg_de-LU', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
('76', '3', '0', 'English NZ', '', 'pkg_en-NZ', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
('77', '3', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', ''),
('78', '121', '0', 'Regular Labs - Regular Labs Library', '', 'library', 'library', '', '0', '21.8.0', '', 'https://download.regularlabs.com/updates.xml?e=library&type=.xml', '', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('3', '802'),
('16', '28'),
('113', '10024'),
('114', '10099'),
('115', '10000'),
('116', '10014'),
('116', '10055'),
('117', '10082'),
('118', '801'),
('119', '10096'),
('120', '10112'),
('121', '10076'),
('121', '10122');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1631623512', ''),
('3', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', '1', '1631623512', ''),
('16', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1631623512', ''),
('113', 'AllVideos', 'extension', 'https://cdn.joomlaworks.org/updates/allvideos.xml', '1', '1631623512', ''),
('114', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1631623512', ''),
('115', 'K2 Updates', 'extension', 'http://getk2.org/app/update.xml', '1', '1631623512', ''),
('116', 'Regular Labs - Cache Cleaner', 'extension', 'https://download.regularlabs.com/updates.xml?e=cachecleaner&type=.xml', '1', '1631623513', ''),
('117', 'Akeeba Backup Core', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebacore.xml', '1', '1631623513', ''),
('118', 'Weblinks Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/weblinks/master/manifest.xml', '1', '1631623513', ''),
('119', 'Akeeba FEF', 'extension', 'http://cdn.akeeba.com/updates/fef.xml', '1', '1631623513', ''),
('120', 'FOF 4.x', 'extension', 'http://cdn.akeeba.com/updates/fof4_file.xml', '1', '1631623513', ''),
('121', 'Regular Labs Library', 'extension', 'https://download.regularlabs.com/updates.xml?e=library&type=.xml', '1', '1631623513', '');
/**ABDB**/CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci,
  `core_urls` text COLLATE utf8mb4_unicode_ci,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/INSERT INTO `#__ucm_content`  VALUES 
('1', 'com_content.article', 'Ante volutpat vitae condimentum malesuada ', 'ante-volutpat-vitae-condimentum-malesuada', '<p>lectus vulputate tempus platea adipiscing posuere viverra pharetra in cursus, ad amet porttitor curae egestas risus pulvinar magna, senectus enim lacus nullam litora at malesuada taciti. fringilla porta vel luctus sodales facilisis elit consequat vitae torquent, phasellus ac etiam lobortis duis aliquet sed nunc faucibus, eleifend nam accumsan lacus nulla hendrerit consequat elit. molestie ornare elementum arcu aptent iaculis quis felis per libero, cursus consectetur enim lacus luctus lobortis conubia tellus fames, aliquam nec gravida scelerisque massa justo tempus ultrices. feugiat aliquam tellus nullam tellus viverra proin tristique est sodales tempor, lectus quam euismod potenti nullam rutrum convallis phasellus aenean.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,3,4,5],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:41:08', '471', '2013-07-19 10:07:38', '*', '2013-07-11 10:41:08', '0000-00-00 00:00:00', '41', '145', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/28_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Ante volutpat vitae condimentum malesuada \",\"image_intro_caption\":\"Tempus aliquam tellus aptent placerat \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/28_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Ante volutpat vitae condimentum malesuada \",\"image_fulltext_caption\":\"Tempus aliquam tellus aptent placerat \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '78', '8', '2', '', '', '14', '', '1'),
('2', 'com_content.article', 'Arcu risus hac auctor sit nibh ', 'arcu-risus-hac-auctor-sit-nibh', '<p>ut erat molestie leo nisl quisque feugiat massa rutrum in porttitor, habitant dolor iaculis auctor fringilla enim sodales lectus. senectus hac eu libero porta sollicitudin mauris, sapien sodales nibh blandit curabitur per quisque, posuere convallis tempus nec nullam. class ante potenti eros ornare condimentum integer dictum nam, posuere class cursus nibh tortor sed odio dui suscipit, leo lorem consequat sit aptent mi magna. litora condimentum potenti himenaeos metus tortor mi sagittis, cubilia eget ut vehicula odio cras dictumst elit, ultrices sociosqu euismod conubia pellentesque magna. porttitor per conubia curabitur primis diam donec blandit hac, bibendum lorem blandit amet adipiscing hendrerit.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[3,4,6],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:18', '471', '2013-07-19 10:13:37', '*', '2013-07-11 10:40:18', '0000-00-00 00:00:00', '18', '146', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Arcu risus hac auctor sit nibh \",\"image_intro_caption\":\"Molestie nisl elit adipiscing \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Arcu risus hac auctor sit nibh \",\"image_fulltext_caption\":\"Molestie nisl elit adipiscing \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '5', '', '', '14', '', '1'),
('3', 'com_content.article', 'Cras torquent ac ', 'cras-torquent-ac', '<p>ultrices quisque nibh sem dictumst consectetur eleifend mollis volutpat et porta, tristique purus tellus etiam litora pharetra ut tempor cursus quam, himenaeos convallis ligula cubilia porttitor ut a vivamus dapibus. quis hac amet condimentum malesuada ut justo himenaeos, tortor himenaeos ornare etiam imperdiet etiam laoreet iaculis, condimentum odio inceptos class at phasellus. dictumst maecenas vehicula tincidunt fames urna id, class ut fermentum dolor euismod, quis varius congue est ut. nunc hendrerit nisl imperdiet faucibus erat ac nisl in fermentum, aliquam per congue aliquam quisque aenean sapien. volutpat leo turpis commodo cubilia donec, a ac suspendisse metus, feugiat vitae fusce molestie.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,7,8,9],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:09', '471', '2013-07-19 10:20:26', '*', '2013-07-11 10:40:09', '0000-00-00 00:00:00', '14', '147', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/13_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cras torquent ac \",\"image_intro_caption\":\"Eleifend habitasse aenean \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/13_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cras torquent ac \",\"image_fulltext_caption\":\"Eleifend habitasse aenean \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '1', '', '', '24', '', '1'),
('4', 'com_content.article', 'Cubilia neque egestas vitae ', 'cubilia-neque-egestas-vitae', '<p>fringilla elit arcu neque leo duis metus id metus ac rutrum proin vitae, at dictum sollicitudin amet maecenas rutrum scelerisque lacus tempor fringilla condimentum, aenean non eget arcu etiam lorem vulputate egestas sit quisque nisl. malesuada eros sapien praesent pretium luctus amet tellus, augue purus in velit nostra duis consectetur, nunc vel nibh ipsum sociosqu class. sollicitudin consectetur vitae ultrices iaculis cras risus potenti, facilisis malesuada est sem gravida fusce. sit litora a vel elementum gravida ultrices eleifend mauris aliquet feugiat, pharetra velit torquent metus dapibus ornare venenatis aptent ut litora, curae curabitur rutrum posuere amet placerat platea dui aenean.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[10,11],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:41:16', '471', '2013-07-19 10:17:01', '*', '2013-07-11 10:41:16', '0000-00-00 00:00:00', '45', '148', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/13_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cubilia neque egestas vitae \",\"image_intro_caption\":\"Fringilla quisque taciti ut \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/13_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cubilia neque egestas vitae \",\"image_fulltext_caption\":\"Fringilla quisque taciti ut \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '91', '3', '0', '', '', '23', '', '1'),
('5', 'com_content.article', 'Erat molestie enim ', 'erat-molestie-enim', '<p>laoreet nec morbi nunc id ultricies primis imperdiet mi turpis, senectus amet mollis bibendum proin nec lorem mattis eleifend dictumst, varius class eget etiam scelerisque viverra ultricies hac. torquent tincidunt ullamcorper dolor orci interdum massa, platea posuere lobortis class lacinia torquent, potenti litora conubia ut nisl. maecenas risus senectus scelerisque massa scelerisque condimentum eleifend aliquam ipsum quisque proin, metus euismod id pulvinar taciti risus urna cras sollicitudin. auctor metus curabitur urna pellentesque vitae curabitur ultricies inceptos mattis ultricies, ad rutrum cursus commodo sollicitudin felis vestibulum curabitur. egestas ornare fames ante vivamus imperdiet, turpis vestibulum rhoncus mollis, auctor sapien tempus nam.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,10,12],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:32', '471', '2013-07-19 09:59:49', '*', '2013-07-11 10:40:32', '0000-00-00 00:00:00', '24', '149', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Erat molestie enim \",\"image_intro_caption\":\"Porttitor ac luctus ante augue \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/8_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Erat molestie enim \",\"image_fulltext_caption\":\"Porttitor ac luctus ante augue \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '2', '', '', '13', '', '1'),
('6', 'com_content.article', 'Iaculis ultricies hac aliquam ante ', 'iaculis-ultricies-hac-aliquam-ante', '<p>semper dapibus cras nisi at orci quam torquent viverra risus sem, risus pharetra massa ligula nullam suscipit quam urna eu. elit lobortis donec auctor pretium varius lacinia posuere sodales pharetra, tincidunt at orci tellus dictum pellentesque donec inceptos nibh bibendum, nisi vulputate tortor aenean class id lobortis felis. dictum proin et sollicitudin commodo class nibh lacus ad, sociosqu turpis a semper per lacinia blandit. dolor per congue risus quisque neque, imperdiet curae conubia senectus rutrum dictumst, erat ornare tellus quis. condimentum massa viverra habitasse habitant hendrerit rhoncus mauris, sed aliquet commodo vivamus nisl convallis, viverra inceptos a fusce scelerisque tristique.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,6,13],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:34', '471', '2013-07-19 10:15:38', '*', '2013-07-11 10:40:34', '0000-00-00 00:00:00', '25', '150', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/26_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Iaculis ultricies hac aliquam ante \",\"image_intro_caption\":\"Laoreet primis felis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/26_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Iaculis ultricies hac aliquam ante \",\"image_fulltext_caption\":\"Laoreet primis felis \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '3', '', '', '14', '', '1'),
('7', 'com_content.article', 'Imperdiet massa est luctus ', 'imperdiet-massa-est-luctus', '<p>laoreet justo quam placerat et ut elementum accumsan nulla urna aenean lobortis, felis dapibus ad non quisque justo malesuada neque elementum pulvinar fermentum, non congue dolor torquent est ligula class nisi pellentesque mattis. vitae curabitur eu cursus per maecenas euismod sollicitudin conubia, feugiat egestas conubia sem tristique phasellus taciti, varius congue dolor suscipit lacus felis arcu. enim etiam diam sociosqu ut nunc sit molestie phasellus torquent commodo, curabitur himenaeos suscipit magna dictumst hac eleifend conubia volutpat amet, consectetur tortor donec etiam varius dictum habitasse tortor volutpat. quis interdum quisque adipiscing sollicitudin est lacinia luctus, primis eget vivamus ante viverra praesent.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,14,6],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:41:47', '0', '2013-07-11 14:45:13', '*', '2013-07-11 10:41:47', '0000-00-00 00:00:00', '60', '151', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/21_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Imperdiet massa est luctus \",\"image_intro_caption\":\"Vestibulum phasellus per blandit cras orci \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/21_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Imperdiet massa est luctus \",\"image_fulltext_caption\":\"Vestibulum phasellus per blandit cras orci \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '1', '', '', '14', '', '1'),
('8', 'com_content.article', 'Integer a in feugiat quisque ', 'integer-a-in-feugiat-quisque', '<p>varius ligula primis dictum hac sodales sed enim porttitor, nunc integer non porttitor eleifend nam lobortis nulla, gravida molestie vehicula potenti vivamus suspendisse tempor. etiam cras tristique erat felis adipiscing rhoncus aenean luctus risus diam ipsum maecenas primis, venenatis mollis suscipit purus etiam placerat sit hac duis hac nullam. vestibulum nibh egestas consequat lacinia egestas taciti phasellus nullam bibendum aliquam, neque in faucibus cubilia cursus diam mattis ad sodales. sociosqu gravida rhoncus praesent vitae vestibulum facilisis, convallis quam est posuere senectus, urna dictum augue molestie mi. fermentum id convallis mattis ullamcorper consequat fermentum himenaeos, consequat amet integer posuere velit accumsan.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[10,15,16,17],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:39', '471', '2013-07-19 10:00:04', '*', '2013-07-11 10:40:39', '0000-00-00 00:00:00', '27', '152', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Integer a in feugiat quisque \",\"image_intro_caption\":\"Sollicitudin ultricies ad \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Integer a in feugiat quisque \",\"image_fulltext_caption\":\"Sollicitudin ultricies ad \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '1', '', '', '13', '', '1'),
('10', 'com_content.article', 'Mi mollis varius leo etiam donec ', 'mi-mollis-varius-leo-etiam-donec', '<p>ad nisi ultricies ultrices curae et donec primis fames tempus fermentum elementum hac pulvinar, metus interdum enim velit magna a erat dapibus mauris proin lectus ad mollis, iaculis lacus amet posuere tincidunt elementum pretium magna odio mollis luctus dictum. eros tempor donec ultrices aptent fusce, class eu elementum nibh, diam elementum justo aptent. integer senectus malesuada maecenas risus tempor ullamcorper vestibulum donec ut, cubilia id donec ullamcorper mattis ullamcorper proin aliquam, aenean in accumsan at in ornare mollis elementum. pellentesque suspendisse nibh molestie sapien netus phasellus blandit, sociosqu convallis semper vivamus ad sollicitudin turpis, eros etiam cubilia faucibus quisque sociosqu.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[7,8,16,20],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:41:03', '471', '2013-07-19 10:20:51', '*', '2013-07-11 10:41:03', '0000-00-00 00:00:00', '39', '154', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Mi mollis varius leo etiam donec \",\"image_intro_caption\":\"Etiam pharetra augue conubia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/12_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Mi mollis varius leo etiam donec \",\"image_fulltext_caption\":\"Etiam pharetra augue conubia \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '0', '', '', '24', '', '1'),
('11', 'com_content.article', 'Nunc consequat maecenas libero lacinia ', 'nunc-consequat-maecenas-libero-lacinia', '<p>etiam feugiat et etiam augue nisl dictum, sagittis himenaeos tempus litora vulputate, lobortis quam potenti aenean per. amet convallis cubilia fringilla rutrum cras hendrerit consequat, in libero aliquam cras taciti congue at vestibulum, ullamcorper ut amet ut eu hac. augue non dictumst id luctus turpis litora hendrerit vestibulum convallis, rhoncus curabitur massa ultricies massa urna platea per bibendum, interdum nostra fusce quam duis aenean est ligula. duis nulla eget maecenas ad feugiat erat dictum integer ut, duis bibendum mi laoreet dui mollis potenti morbi, gravida blandit sodales donec vivamus phasellus primis ac.</p>\r\n<p>mollis lectus tempus rhoncus integer, lobortis phasellus proin.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[5,6,10,13],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:23', '471', '2013-07-19 10:14:25', '*', '2013-07-11 10:40:23', '0000-00-00 00:00:00', '20', '155', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/11_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Nunc consequat maecenas libero lacinia \",\"image_intro_caption\":\"Varius urna lacus feugiat sem vehicula \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/11_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Nunc consequat maecenas libero lacinia \",\"image_fulltext_caption\":\"Varius urna lacus feugiat sem vehicula \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '4', '', '', '14', '', '1'),
('14', 'com_content.article', 'Platea id donec phasellus malesuada nullam ', 'platea-id-donec-phasellus-malesuada-nullam', '<p>egestas sed pulvinar senectus commodo eu diam etiam, velit auctor quis bibendum fringilla erat, convallis ligula suscipit nisl vehicula ac. convallis velit habitasse potenti aliquet odio mattis iaculis nibh, malesuada nisi tempus sollicitudin mi id etiam sollicitudin, in eleifend viverra ante blandit torquent pulvinar. eu lectus lorem eleifend platea odio conubia mi hac, lectus luctus vivamus quis consectetur est metus dapibus ligula, fringilla hac dapibus est integer lobortis interdum. congue sem ut tincidunt quisque proin netus gravida eu tristique ante, adipiscing litora suspendisse bibendum egestas aliquam habitasse dui felis convallis accumsan, semper eleifend ante aliquet taciti imperdiet ligula consequat bibendum.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[3,19],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:42:09', '471', '2013-07-19 10:14:56', '*', '2013-07-11 10:42:09', '0000-00-00 00:00:00', '72', '158', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Platea id donec phasellus malesuada nullam \",\"image_intro_caption\":\"Dui lectus pulvinar varius \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Platea id donec phasellus malesuada nullam \",\"image_fulltext_caption\":\"Dui lectus pulvinar varius \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '11', '4', '0', '', '', '14', '', '1'),
('15', 'com_content.article', 'Sagittis viverra auctor consectetur ', 'sagittis-viverra-auctor-consectetur', '<p>neque a class duis potenti netus lacus curae habitasse aenean, nullam condimentum auctor lobortis in quam rhoncus. dictumst aliquet hac viverra libero integer donec elit ornare integer eget, sagittis accumsan quisque elit luctus mollis malesuada at molestie, ultricies sagittis mollis primis eu fames odio quisque id. fusce a molestie quam malesuada etiam ultricies non rhoncus, integer aenean lacus taciti sociosqu facilisis ligula non, justo mattis pharetra curabitur vulputate adipiscing convallis. rhoncus varius aliquam vivamus convallis mi scelerisque auctor odio torquent lorem amet ante, curabitur vitae conubia fringilla risus felis nulla suspendisse condimentum nullam eleifend.</p>\r\n<p>non lacinia curabitur senectus, nunc volutpat.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[15,22],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:50', '471', '2013-07-19 10:00:25', '*', '2013-07-11 10:40:50', '0000-00-00 00:00:00', '32', '159', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/14_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sagittis viverra auctor consectetur \",\"image_intro_caption\":\"Rutrum arcu velit elementum pellentesque sollicitudin \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/14_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sagittis viverra auctor consectetur \",\"image_fulltext_caption\":\"Rutrum arcu velit elementum pellentesque sollicitudin \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '0', '', '', '13', '', '1'),
('16', 'com_content.article', 'Pellentesque vel tincidunt taciti maecenas ', 'pellentesque-vel-tincidunt-taciti-maecenas', '<p>venenatis etiam conubia fusce ac lobortis aliquet blandit, quis tincidunt praesent placerat in feugiat inceptos, netus maecenas gravida donec id integer. quisque luctus orci auctor hendrerit ultrices etiam est fringilla curae consectetur tellus, sem sollicitudin nulla aptent justo sodales primis leo id aenean phasellus, pellentesque duis eu vehicula cras senectus magna turpis odio a. luctus feugiat a vulputate mi felis placerat hac magna curabitur elit per eu ultrices elementum tempus, curae tincidunt rutrum in cubilia tortor sed nibh tristique mi ornare tincidunt porta eget. nunc etiam ut platea bibendum ornare ultrices nam ac, ligula donec ultricies libero pharetra ad feugiat.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[6,11,15,21],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:39:57', '0', '2013-07-19 10:19:01', '*', '2013-07-11 10:39:57', '0000-00-00 00:00:00', '8', '160', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/11_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Pellentesque vel tincidunt taciti maecenas \",\"image_intro_caption\":\"Gravida rutrum nostra ornare eros \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/11_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Pellentesque vel tincidunt taciti maecenas \",\"image_fulltext_caption\":\"Gravida rutrum nostra ornare eros \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '2', '3', '3', '', '', '23', '', '1'),
('17', 'com_content.article', 'Phasellus ante donec ', 'phasellus-ante-donec', '<p>ante aenean vestibulum tellus tempor lorem ac vehicula ante, rhoncus tortor volutpat accumsan porttitor ullamcorper curabitur hendrerit luctus, commodo primis aenean netus vestibulum erat per. convallis lacinia sociosqu dui nullam ultrices consectetur pharetra interdum habitant vivamus aenean, pretium condimentum odio mauris volutpat ut libero hac aliquam nam pellentesque, vel senectus quam a sodales duis leo bibendum sem orci. sed consectetur inceptos aptent accumsan eros dapibus conubia nibh, orci quisque tristique magna hendrerit velit vivamus sodales risus, bibendum fringilla tellus consequat nunc erat nec. lacus suscipit bibendum pharetra lobortis arcu sem, ac odio est leo torquent, ut facilisis convallis maecenas nostra.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[7,18],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:40:21', '0', '2013-07-19 10:19:19', '*', '2013-07-11 10:40:21', '0000-00-00 00:00:00', '19', '161', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/9_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Phasellus ante donec \",\"image_intro_caption\":\"Auctor proin convallis amet nulla habitasse \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/9_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Phasellus ante donec \",\"image_fulltext_caption\":\"Auctor proin convallis amet nulla habitasse \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '2', '3', '1', '', '', '23', '', '1'),
('18', 'com_content.article', 'Sodales tortor primis dui ', 'sodales-tortor-primis-dui', '<p>lectus auctor sit nam purus sagittis litora turpis phasellus, varius volutpat augue sit fusce a pellentesque aptent, semper dictumst curae leo curabitur adipiscing turpis. velit leo venenatis semper proin habitasse curabitur lobortis sodales purus, torquent semper turpis elementum mi platea facilisis massa ad nec, conubia ornare lacus id habitant lorem luctus augue. tempor nulla ultricies augue hac cursus pharetra dui curabitur, sollicitudin quis lacinia netus pellentesque id eget quam, lorem sem velit tortor diam orci aenean. primis suscipit praesent nisi aliquam sociosqu euismod malesuada facilisis, suscipit ultrices accumsan felis etiam maecenas eros mattis, blandit curabitur ullamcorper ligula consectetur senectus fermentum.</p>\r\n', '1', '', '0', '1', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"tags\":[2,9,23],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '471', '', '2013-07-11 10:39:44', '0', '2013-07-19 10:21:22', '*', '2013-07-11 10:39:44', '0000-00-00 00:00:00', '2', '162', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sodales tortor primis dui \",\"image_intro_caption\":\"Habitasse convallis vestibulum \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/8_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sodales tortor primis dui \",\"image_fulltext_caption\":\"Habitasse convallis vestibulum \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '1', '3', '2', '', '', '24', '', '1');
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_base`  VALUES 
('1', '41', '1', '0'),
('2', '18', '1', '0'),
('3', '14', '1', '0'),
('4', '45', '1', '0'),
('5', '24', '1', '0'),
('6', '25', '1', '0'),
('7', '60', '1', '0'),
('8', '27', '1', '0'),
('10', '39', '1', '0'),
('11', '20', '1', '0'),
('14', '72', '1', '0'),
('15', '32', '1', '0'),
('16', '8', '1', '0'),
('17', '19', '1', '0'),
('18', '2', '1', '0');
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT '0',
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('4', 'beez3', '0', '0', 'Beez3 - Default', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"images\\/joomla_black.gif\",\"sitetitle\":\"Joomla!\",\"sitedescription\":\"Open Source Content Management\",\"navposition\":\"left\",\"templatecolor\":\"personal\",\"html5\":\"0\"}', '0', ''),
('5', 'hathor', '1', '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}', '0', ''),
('7', 'protostar', '0', '0', 'protostar - Default', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '0', ''),
('8', 'isis', '1', '1', 'isis - Default', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '0', ''),
('9', 'numodusversus', '0', '1', 'nuModusVersus - Default', '{\"siteLogo\":\"images\\/logo.png\",\"siteLogoAltText\":\"\",\"siteTextAsLogo\":\"\",\"siteTagline\":\"\",\"nutpIconIOS57x57\":\"\",\"nutpIconIOS72x72\":\"\",\"nutpIconIOS114x114\":\"\",\"nutpIconIOS144x144\":\"\",\"nutpJqueryHandling\":\"0\",\"nutpLoadCustomCSS\":\"1\",\"nutpLoadCustomJS\":\"1\",\"nutpGoogleWebFonts\":{\"fonts\":[\"Open Sans\"]},\"nutpMetaDistribution\":\"global\",\"nutpOpenGraphURL\":\"\",\"nutpOpenGraphTitle\":\"\",\"nutpOpenGraphDescription\":\"\",\"nutpOpenGraphImage\":\"\",\"nutpFacebookAppID\":\"\",\"nutpFeedLink1\":\"\",\"nutpFeedLink1Title\":\"\",\"nutpFeedLink2\":\"\",\"nutpFeedLink2Title\":\"\",\"nutpFeedLink3\":\"\",\"nutpFeedLink3Title\":\"\",\"nutpRemoveCanonicalMeta\":\"0\",\"nutpForceLoadBootstrap\":\"0\",\"nutpCreditsName\":\"outlinez\",\"nutpCreditsLink\":\"http:\\/\\/outlinez.net\\/\",\"nutpCopyright\":\"\",\"nutpCopyrightStartYear\":\"\",\"nutpGAID\":\"\",\"nutpGADomain\":\"\",\"nutpGoogleVerificationID\":\"\",\"nutpBingVerificationID\":\"\",\"nutpAlexaVerificationID\":\"\",\"siteSocialFacebook\":\"\",\"siteSocialTwitter\":\"\",\"siteSocialGooglePlus\":\"\",\"siteSocialFoursquare\":\"\",\"siteSocialYouTube\":\"\",\"siteSocialVimeo\":\"\",\"siteSocialDailymotion\":\"\",\"siteSocialSoundCloud\":\"\",\"siteSocialMixCloud\":\"\",\"siteSocialFlickr\":\"\",\"siteSocialInstagram\":\"\",\"siteSocialPinterest\":\"\",\"siteSocial500px\":\"\",\"siteSocialDribbble\":\"\",\"siteSocialBehance\":\"\",\"siteSocialGithub\":\"\",\"nutpHeadTop\":\"\",\"nutpHeadBottom\":\"\",\"nutpBodyTop\":\"\",\"nutpBodyBottom\":\"\",\"contentHighlights\":{\"font\":\"fontawesome\",\"entries\":[{\"title\":\"Non inceptos magna\",\"description\":\"vitae morbi mollis pharetra interdum venenatis varius sed inceptos nibh, erat ante cubilia ultrices urna taciti tempor facilisis, massa ultricies.\",\"tagline\":\"\",\"link\":\"http:\\/\\/nuevvo.com\",\"image\":\"\",\"icon\":\"<i class=\\\"icon-fa-apple\\\"><\\/i>\"},{\"title\":\" Sagittis proin a curabitur dictum consequat\",\"description\":\"vitae donec netus justo vulputate gravida, mi eu porta etiam eleifend, sodales primis congue varius. fermentum potenti curae porttitor sollicitudin.\",\"tagline\":\"\",\"link\":\"http:\\/\\/nuevvo.com\",\"image\":\"\",\"icon\":\"<i class=\\\"icon-fa-key\\\"><\\/i>\"},{\"title\":\" Vitae feugiat vehicula\",\"description\":\"ante scelerisque justo faucibus tincidunt ullamcorper duis hendrerit phasellus tellus suspendisse integer, nec sollicitudin ante a luctus curabitur nec tempor.\",\"tagline\":\"\",\"link\":\"http:\\/\\/nuevvo.com\",\"image\":\"\",\"icon\":\"<i class=\\\"icon-fa-flag\\\"><\\/i>\"},{\"title\":\"Nec sollicitudin consequat ante\",\"description\":\"Quisque id tellus quis risus vehicula vehicula ut turpis. In eros nulla, placerat vitae at, vehicula ut nunc nec tempor tincidunt ullamcorper.\",\"tagline\":\"\",\"link\":\"http:\\/\\/nuevvo.com\",\"image\":\"\",\"icon\":\"<i class=\\\"icon-fa-beaker\\\"><\\/i>\"}]},\"colorVariations\":\"default|#62b9b0|#e2534b\",\"_COLOR1_\":\"\",\"_COLOR2_\":\"\"}', '0', '');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '45', '0', '', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2011-01-01 00:00:01', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('2', '1', '1', '2', '1', 'trendy', 'Trendy', 'trendy', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:10:52', '', '0', '0000-00-00 00:00:00', '', '', '846', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('3', '1', '3', '4', '1', 'italian', 'Italian', 'italian', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:10:52', '', '0', '0000-00-00 00:00:00', '', '', '748', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('4', '1', '5', '6', '1', 'spring-summer', 'Spring - Summer', 'spring-summer', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:10:52', '', '0', '0000-00-00 00:00:00', '', '', '171', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('5', '1', '7', '8', '1', 'couture', 'Couture', 'couture', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:10:52', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('6', '1', '9', '10', '1', 'autumn-winter', 'Autumn - Winter', 'autumn-winter', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:11:42', '', '0', '0000-00-00 00:00:00', '', '', '828', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('7', '1', '11', '12', '1', 'modern', 'Modern', 'modern', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:31:42', '', '0', '0000-00-00 00:00:00', '', '', '755', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('8', '1', '13', '14', '1', 'tech', 'Tech', 'tech', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:31:42', '', '0', '0000-00-00 00:00:00', '', '', '149', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('9', '1', '15', '16', '1', 'must-buy', 'Must Buy', 'must-buy', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:31:42', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('10', '1', '17', '18', '1', 'vintage', 'Vintage', 'vintage', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:39:54', '', '0', '0000-00-00 00:00:00', '', '', '1993', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('11', '1', '19', '20', '1', 'avant-garde', 'Avant Garde', 'avant-garde', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:39:54', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('12', '1', '21', '22', '1', 'interior', 'Interior', 'interior', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:41:14', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('13', '1', '23', '24', '1', 'first-row', 'First Row', 'first-row', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:44:39', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('14', '1', '25', '26', '1', 'catwalk', 'Catwalk', 'catwalk', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:45:13', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('15', '1', '27', '28', '1', 'minimal', 'Minimal', 'minimal', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:45:50', '', '0', '0000-00-00 00:00:00', '', '', '128', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('16', '1', '29', '30', '1', 'new', 'New', 'new', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:45:50', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('17', '1', '31', '32', '1', 'exterior', 'Exterior', 'exterior', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:45:50', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('18', '1', '33', '34', '1', 'lifestyle', 'Lifestyle', 'lifestyle', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:49:17', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('19', '1', '35', '36', '1', 'inspirational', 'Inspirational', 'inspirational', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:49:17', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('20', '1', '37', '38', '1', 'geek', 'Geek', 'geek', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:50:01', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('21', '1', '39', '40', '1', 'eccentric', 'Eccentric', 'eccentric', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:51:20', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('22', '1', '41', '42', '1', 'typeface', 'Typeface', 'typeface', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:52:46', '', '0', '0000-00-00 00:00:00', '', '', '183', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('23', '1', '43', '44', '1', 'bleeding-edge', 'Bleeding Edge', 'bleeding-edge', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 14:53:20', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
/**ABDB**/CREATE TABLE `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) unsigned DEFAULT NULL,
  `guest` tinyint(3) unsigned DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('21', '3.5.1'),
('700', '3.10.0-2021-05-28'),
('10022', '3.6.0-2012-07-31');
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_link_modifed` (`modified_date`),
  KEY `idx_old_url` (`old_url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__postinstall_messages`  VALUES 
('1', '700', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', '1', 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', '0'),
('2', '700', 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', '1', 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', '0'),
('12', '700', 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', '0'),
('13', '700', 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', '1', 'message', '', '', '', '', '3.3.0', '0'),
('14', '700', 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', '0'),
('15', '700', 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', '0'),
('16', '700', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', '1', 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', '0'),
('17', '700', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', '0'),
('18', '700', 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', '1', 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', '0'),
('19', '700', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', '1', 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', '0'),
('20', '700', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', '0'),
('21', '700', 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', '1', 'message', '', '', '', '', '3.9.0', '0'),
('22', '700', 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', '1', 'message', '', '', '', '', '3.9.0', '0'),
('23', '700', 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', '0'),
('24', '700', 'COM_CPANEL_MSG_TEXTFILTER3919_TITLE', 'COM_CPANEL_MSG_TEXTFILTER3919_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/textfilter3919.php', 'admin_postinstall_textfilter3919_condition', '3.9.19', '0'),
('25', '700', 'COM_CPANEL_MSG_HTACCESSSVG_TITLE', 'COM_CPANEL_MSG_HTACCESSSVG_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/htaccesssvg.php', 'admin_postinstall_htaccesssvg_condition', '3.9.21', '0'),
('26', '700', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_DESCRIPTION', '', 'com_admin', '1', 'message', '', '', NULL, NULL, '3.9.22', '0'),
('27', '700', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_DESCRIPTION', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_ACTION', 'com_admin', '1', 'action', 'admin://components/com_admin/postinstall/behindproxy.php', 'behindproxy_postinstall_action', 'admin://components/com_admin/postinstall/behindproxy.php', 'admin_postinstall_behindproxy_condition', '3.9.26', '0'),
('28', '700', 'COM_ADMIN_POSTINSTALL_MSG_FLOC_BLOCKER_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_FLOC_BLOCKER_DESCRIPTION', '', 'com_admin', '1', 'message', '', '', NULL, NULL, '3.9.27', '0');
/**ABDB**/CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__newsfeeds`  VALUES 
('5', '1', 'JoomlaWorks Extension Updates', 'joomlaworks-extension-updates', 'http://feeds.feedburner.com/joomlaworks', '1', '5', '3600', '0', '0000-00-00 00:00:00', '1', '0', '1', '*', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2013-07-11 11:42:18', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '1', '5507', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('5', '2', 'JoomlaWorks Videos', 'joomlaworks-videos', 'http://feeds.feedburner.com/joomlaworks/videos', '1', '5', '3600', '0', '0000-00-00 00:00:00', '2', '0', '1', '*', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2013-07-11 11:42:45', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '1', '348', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('5', '3', 'JoomlaWorks Blog', 'joomlaworks-blog', 'http://feeds.feedburner.com/joomlaworks/blog', '1', '5', '3600', '0', '0000-00-00 00:00:00', '3', '0', '1', '*', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2013-07-11 11:43:02', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '1', '2677', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('5', '4', 'JoomlaWorks Presentations', 'joomlaworks-presentations', 'http://feeds.feedburner.com/joomlaworks/presentations', '1', '5', '3600', '0', '0000-00-00 00:00:00', '4', '0', '1', '*', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2013-07-11 11:43:29', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '1', '320', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}'),
('29', '5', 'JoomlaWorks Blog', 'joomlaworks-blog', 'http://feeds.feedburner.com/joomlaworks/blog', '1', '5', '3600', '0', '0000-00-00 00:00:00', '5', '0', '1', '*', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2013-07-11 11:44:01', '471', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '1', '677', '{\"image_first\":\"\",\"float_first\":\"\",\"image_first_alt\":\"\",\"image_first_caption\":\"\",\"image_second\":\"\",\"float_second\":\"\",\"image_second_alt\":\"\",\"image_second_caption\":\"\"}');
/**ABDB**/CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules_menu`  VALUES 
('1', '0'),
('2', '0'),
('3', '0'),
('4', '0'),
('6', '0'),
('7', '0'),
('8', '0'),
('9', '0'),
('10', '0'),
('12', '0'),
('13', '0'),
('14', '0'),
('15', '0'),
('79', '0'),
('86', '0'),
('87', '125'),
('88', '101'),
('89', '144'),
('90', '125'),
('91', '125'),
('92', '0'),
('93', '0'),
('94', '0'),
('101', '0'),
('102', '0'),
('103', '101'),
('104', '101'),
('105', '101'),
('106', '101'),
('107', '101'),
('108', '0'),
('109', '0'),
('110', '0'),
('111', '0'),
('112', '0'),
('113', '119'),
('113', '125'),
('113', '126'),
('114', '119'),
('114', '121'),
('114', '122'),
('114', '126'),
('115', '119'),
('115', '125'),
('115', '126'),
('116', '119'),
('116', '125'),
('116', '126'),
('117', '118'),
('117', '120'),
('118', '125'),
('119', '125'),
('120', '125'),
('121', '125'),
('122', '125'),
('123', '125'),
('134', '163'),
('135', '147'),
('135', '148'),
('135', '149'),
('135', '150'),
('135', '151'),
('135', '152'),
('135', '165'),
('137', '101'),
('138', '0'),
('140', '147'),
('140', '148'),
('140', '149'),
('140', '150'),
('140', '151'),
('140', '152'),
('141', '147'),
('141', '148'),
('141', '149'),
('141', '150'),
('141', '151'),
('141', '152'),
('142', '0'),
('143', '0');
/**ABDB**/CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules`  VALUES 
('1', '0', 'Main Menu', '', '', '1', 'nuModusVersus_Menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '0', '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"3\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('2', '0', 'Login', '', '', '1', 'login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*'),
('3', '0', 'Popular Articles', '', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('4', '0', 'Recently Added Articles', '', '', '5', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('8', '0', 'Toolbar', '', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*'),
('9', '0', 'Quick Icons', '', '', '1', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*'),
('10', '172', 'Logged-in Users', '', '', '1', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('12', '0', 'Admin Menu', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*'),
('13', '0', 'Admin Submenu', '', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*'),
('14', '0', 'User Status', '', '', '2', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*'),
('15', '0', 'Title', '', '', '1', 'title', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*'),
('79', '0', 'Multilanguage status', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('86', '0', 'Joomla Version', '', '', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_version', '3', '1', '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('87', '0', 'Latest Comments', '', '', '14', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_comments', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"catfilter\":\"0\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"0\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('88', '0', 'Slideshow', '', '', '1', 'nuModusVersus_Slideshow', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '0', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Slideshow\",\"source\":\"specific\",\"catfilter\":\"1\",\"getChildren\":\"1\",\"itemCount\":\"4\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"items\":[\"77\",\"101\",\"135\"],\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"20\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('89', '0', 'Contact Map', '', '', '1', 'nuModusVersus_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"contactMap\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<iframe width=\\\"425\\\" height=\\\"350\\\" frameborder=\\\"0\\\" scrolling=\\\"no\\\" marginheight=\\\"0\\\" marginwidth=\\\"0\\\" src=\\\"https:\\/\\/maps.google.com\\/maps?q=40.799971,-73.944905&amp;ie=UTF8&amp;t=m&amp;z=14&amp;ll=40.799971,-73.944905&amp;output=embed\\\"><\\/iframe>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('90', '0', 'K2 Users', '', '', '16', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_users', '1', '1', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"specific\",\"filter\":\"1\",\"K2UserGroup\":\"1\",\"ordering\":\"alpha\",\"limit\":\"4\",\"userIDs\":[\"473\",\"472\"],\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"1\",\"userFeed\":\"1\",\"userItemCount\":\"3\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('91', '0', 'Login Form', '', '', '17', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_user', '1', '1', '{\"moduleclass_sfx\":\"box\",\"pretext\":\"\",\"posttext\":\"\",\"userGreetingText\":\"Welcome, \",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"70\",\"menu\":\"\",\"login\":\"125\",\"logout\":\"101\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('92', '173', 'K2 Quick Icons (admin)', '', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_quickicons', '1', '1', '', '1', '*'),
('93', '174', 'K2 Stats (admin)', '', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_stats', '1', '1', '', '1', '*'),
('101', '0', 'Search', '', '', '1', 'nuModusVersus_Search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"6\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"1\",\"category_id\":[\"67\",\"68\"],\"getChildren\":\"1\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"search\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"Go\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('102', '0', 'Social Menu', '', '', '1', 'nuModusVersus_Footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '0', '{\"menutype\":\"social-menu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"socialMenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('103', '178', 'some of our top services', '', '', '1', 'nuModusVersus_Below_Slideshow', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"oneItem greyBox\",\"getTemplate\":\"Default\",\"source\":\"specific\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"items\":[\"94\"],\"itemTitle\":\"0\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"20\",\"itemImage\":\"0\",\"itemImgSize\":\"Small\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"1\",\"itemCustomLinkTitle\":\"View More\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"118\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('104', '0', 'Why numodus versus?', '', '', '1', 'nuModusVersus_Above_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"imagePreviews\",\"getTemplate\":\"ImageOnly\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"44\"],\"getChildren\":\"0\",\"itemCount\":\"3\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"0\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Medium\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"Capacitance cascading integer reflective interface data development high bus cache dithering transponder.  \",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('105', '0', 'Why Choose Us?', '', '', '1', 'nuModusVersus_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"column small-6 large-3 mobile-4 customList\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<ul>\\r\\n<li><span>Quisque at massa ipsum<\\/span><\\/li>\\r\\n<li><span>Maecenas a lorem augue, egestas<\\/span><\\/li>\\r\\n<li><span>Cras vitae felis at lacus eleifend<\\/span><\\/li> \\r\\n<li><span>Etiam auctor diam pellentesque<\\/span><\\/li> \\r\\n<li><span>Nulla ac massa at dolor<\\/span><\\/li> \\r\\n<li><span>Condimentum eleifend vitae vitae<\\/span><\\/li>\\r\\n<\\/ul>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('106', '0', 'Skills', '', '', '1', 'nuModusVersus_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"column small-6 large-9 mobile-4 skills\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<p>Curabitur quis nisl in leo euismod venenatis eu in diam. Etiam <a href=\\\"#\\\">auctor diam pellentesque<\\/a> lectus vehicula mattis. Nulla ac massa at dolor condimentum eleifend vitae vitae urna.<\\/p>\\r\\n<ul>\\r\\n<li><span class=\\\"skill-50\\\">50<\\/span><h4>SUSPENDISSE<\\/h4><\\/li>\\r\\n<li><span class=\\\"skill-70\\\">70<\\/span><h4>MAECENAS<\\/h4><\\/li>\\r\\n<li><span class=\\\"skill-80\\\">80<\\/span><h4>ALIQUAM<\\/h4><\\/li>\\r\\n<li><span class=\\\"skill-100\\\">100<\\/span><h4>HABITASSE<\\/h4><\\/li>\\r\\n<\\/ul>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('107', '0', 'What Client\'s Say?', '', '', '1', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"quotes\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"30\"],\"getChildren\":\"0\",\"itemCount\":\"1\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"0\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"25\",\"itemImage\":\"0\",\"itemImgSize\":\"Small\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"1\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('108', '0', 'NUMODUSversus', '', '', '2', 'nuModusVersus_Bottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"column small-6 large-4 mobile-4 floatLeft contactInfo\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec .<\\/p>\\r\\n<p class=\\\"info\\\">\\r\\nPhone: <span>+1 222 333 4567 <\\/span><br\\/>\\r\\nE-mail: <span>contact@example.com<\\/span> \\r\\n<\\/p>\\r\\n\\r\\n\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('109', '0', 'Company', '', '', '3', 'nuModusVersus_Bottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"column small-6 large-2 mobile-4 btmMenu\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<ul>\\r\\n<li><a href=\\\"#\\\">About<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">FAQ<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Contact<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Terms<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Privacy<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Testimonials<\\/a><\\/li>\\r\\n<\\/ul>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('110', '0', 'Community', '', '', '4', 'nuModusVersus_Bottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"column small-6 large-2 mobile-4 btmMenu\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<ul>\\r\\n<li><a href=\\\"#\\\">Blog<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Forum<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Support<\\/a><\\/li>\\r\\n<li><a href=\\\"#\\\">Newsletter<\\/a><\\/li>\\r\\n<\\/ul>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('111', '0', 'from the BLOG', '', '', '1', 'nuModusVersus_Bottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"column small-6 large-4 mobile-4 floatRight latestBlogPosts\",\"getTemplate\":\"LatestBlogPosts\",\"source\":\"specific\",\"catfilter\":\"1\",\"category_id\":[\"33\"],\"getChildren\":\"0\",\"itemCount\":\"3\",\"itemsOrdering\":\"rdate\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"items\":[\"120\",\"73\",\"60\"],\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"10\",\"itemImage\":\"1\",\"itemImgSize\":\"XSmall\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('112', '0', 'K2 Breadcrumbs', '', '', '1', 'nuModusVersus_Breadcrumbs', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"3\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"Home\",\"seperator\":\"\\/\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('113', '0', 'Categories', '', '', '5', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"4\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"67\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('114', '0', 'Latest Posts', '', '', '6', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"latestBlogPosts onlyTitle\",\"getTemplate\":\"LatestBlogPosts\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"67\"],\"getChildren\":\"1\",\"itemCount\":\"5\",\"itemsOrdering\":\"rdate\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"0\",\"itemImgSize\":\"Small\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('115', '0', 'Tags', '', '', '8', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"7\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"67\"],\"cloud_category_recursive\":\"1\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('116', '0', 'Archive', '', '', '9', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"44\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('117', '0', 'K2 Categories Submenu', '', '', '1', 'nuModusVersus_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"categoriesSubmenu\",\"module_usage\":\"4\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"68\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"0\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('118', '0', 'Latest Posts', '', '', '7', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"latestBlogPosts biggerTitle\",\"getTemplate\":\"LatestBlogPosts\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"67\"],\"getChildren\":\"1\",\"itemCount\":\"2\",\"itemsOrdering\":\"rdate\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"15\",\"itemImage\":\"1\",\"itemImgSize\":\"XSmall\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('119', '0', 'Authors List', '', '', '10', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"1\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"67\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"70\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('120', '0', 'Calendar', '', '', '11', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"2\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"44\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('121', '0', 'Category Select Box', '', '', '12', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"5\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"67\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('122', '0', 'Search', '', '', '13', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"6\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"1\",\"category_id\":[\"67\"],\"getChildren\":\"1\",\"liveSearch\":\"1\",\"width\":\"20\",\"text\":\"search\",\"button\":\"1\",\"imagebutton\":\"\",\"button_text\":\"Go\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('123', '0', 'Top Commenters', '', '', '15', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_comments', '1', '1', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"1\",\"catfilter\":\"0\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('134', '0', 'Login Form', '', '', '18', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"usetext\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"modLoginBlock box\",\"cache\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('135', '0', 'Popular Tags', '', '', '4', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_tags_popular', '1', '1', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('137', '177', 'Our Clients', '', '', '1', 'nuModusVersus_Below_Component', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"column small-12 modSlider\",\"getTemplate\":\"Slider\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"71\"],\"getChildren\":\"0\",\"itemCount\":\"12\",\"itemsOrdering\":\"alpha\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"itemTitle\":\"0\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"0\",\"itemImgSize\":\"Medium\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"1\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"101\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('138', '0', 'Breadcrumbs', '', '', '1', 'nuModusVersus_Breadcrumbs', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_breadcrumbs', '1', '0', '{\"showHere\":\"0\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\\/\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('140', '0', 'Categories', '', '', '2', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_articles_categories', '1', '1', '{\"parent\":\"27\",\"show_description\":\"0\",\"show_children\":\"1\",\"count\":\"0\",\"maxlevel\":\"0\",\"layout\":\"_:default\",\"item_heading\":\"4\",\"moduleclass_sfx\":\"modCategoriesListBlock\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('141', '0', 'Latest Posts', '', '', '3', 'nuModusVersus_Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_articles_category', '1', '1', '{\"mode\":\"normal\",\"show_on_article_page\":\"1\",\"show_front\":\"show\",\"count\":\"5\",\"category_filtering_type\":\"1\",\"catid\":[\"13\",\"14\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"item_heading\":\"4\",\"link_titles\":\"1\",\"show_date\":\"1\",\"show_date_field\":\"created\",\"show_date_format\":\"d F\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"latestBlogPosts onlyTitle\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('143', '169', 'Regular Labs - Cache Cleaner', '', '', '3', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_cachecleaner', '3', '1', '', '1', '*');
/**ABDB**/CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu_types`  VALUES 
('1', '0', 'mainmenu', 'Main Menu', 'The main menu for the site', '0'),
('2', '0', 'social-menu', 'Social Menu', 'Social Menu', '0');
/**ABDB**/CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=368 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu`  VALUES 
('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '0', '141', '0', '*', '0'),
('2', 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '1', '1', '1', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '1', '10', '0', '*', '1'),
('3', 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1'),
('4', 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', '1', '2', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1'),
('5', 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1'),
('6', 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1'),
('7', 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '1', '1', '1', '8', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '75', '80', '0', '*', '1'),
('8', 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', '1', '7', '2', '8', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '76', '77', '0', '*', '1'),
('9', 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', '1', '7', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact-cat', '0', '', '78', '79', '0', '*', '1'),
('10', 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', '1', '1', '1', '15', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages', '0', '', '81', '84', '0', '*', '1'),
('11', 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', '1', '10', '2', '15', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-add', '0', '', '82', '83', '0', '*', '1'),
('13', 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '1', '1', '17', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '85', '90', '0', '*', '1'),
('14', 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '13', '2', '17', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '86', '87', '0', '*', '1'),
('15', 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', '1', '13', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds-cat', '0', '', '88', '89', '0', '*', '1'),
('16', 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', '1', '1', '1', '24', '0', '0000-00-00 00:00:00', '0', '0', 'class:redirect', '0', '', '91', '92', '0', '*', '1'),
('17', 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', '1', '1', '1', '19', '0', '0000-00-00 00:00:00', '0', '0', 'class:search', '0', '', '93', '94', '0', '*', '1'),
('21', 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '1', '1', '1', '27', '0', '0000-00-00 00:00:00', '0', '0', 'class:finder', '0', '', '95', '96', '0', '*', '1'),
('23', 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', '1', '1', '1', '29', '0', '0000-00-00 00:00:00', '0', '1', 'class:tags', '0', '', '97', '98', '0', '', '1'),
('101', 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', '1', '1', '1', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '11', '12', '1', '*', '0'),
('118', 'mainmenu', 'Using K2', 'using-k2', '', 'using-k2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=68', 'component', '1', '1', '1', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"68\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 Categories\",\"pageclass_sfx\":\"gridView\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '13', '28', '0', '*', '0'),
('119', 'mainmenu', 'K2 Item', 'k2-item', '', 'using-k2/k2-item', 'index.php?option=com_k2&view=item&layout=item&id=121', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '14', '15', '0', '*', '0'),
('120', 'mainmenu', 'K2 Categories', 'k2-categories', '', 'using-k2/k2-categories', 'index.php?Itemid=', 'alias', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"118\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '16', '17', '0', '*', '0'),
('121', 'mainmenu', 'K2 Tags', 'k2-tags', '', 'using-k2/k2-tags', 'index.php?option=com_k2&view=itemlist&layout=tag&task=tag&tag=Vintage', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 Tags\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '18', '19', '0', '*', '0'),
('122', 'mainmenu', 'K2 User Page', 'k2-user-page', '', 'using-k2/k2-user-page', 'index.php?option=com_k2&view=itemlist&layout=user&id=473&task=user', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"userOrdering\":\"\",\"userFeedLink\":\"1\",\"userFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 User page\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '20', '21', '0', '*', '0'),
('123', 'mainmenu', 'K2 Latest Items by Category', 'k2-latest-items-by-category', '', 'using-k2/k2-latest-items-by-category', 'index.php?option=com_k2&view=latest&layout=latest', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"source\":\"1\",\"latestItemsCols\":\"2\",\"latestItemsLimit\":\"3\",\"latestItemsDisplayEffect\":\"all\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"categoryIDs\":[\"45\",\"38\"],\"categoryTitle\":\"1\",\"categoryDescription\":\"1\",\"categoryImage\":\"1\",\"categoryFeed\":\"1\",\"latestItemTitle\":\"1\",\"latestItemTitleLinked\":\"1\",\"latestItemDateCreated\":\"1\",\"latestItemImage\":\"1\",\"latestItemImageSize\":\"Medium\",\"latestItemVideo\":\"1\",\"latestItemVideoWidth\":\"\",\"latestItemVideoHeight\":\"\",\"latestItemAudioWidth\":\"\",\"latestItemAudioHeight\":\"\",\"latestItemVideoAutoPlay\":\"0\",\"latestItemIntroText\":\"1\",\"latestItemCategory\":\"1\",\"latestItemTags\":\"1\",\"latestItemReadMore\":\"1\",\"latestItemCommentsAnchor\":\"0\",\"feedLink\":\"1\",\"latestItemK2Plugins\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 Latest Items by Category\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '24', '25', '0', '*', '0'),
('124', 'mainmenu', 'K2 Latest Items by User', 'k2-latest-items-by-user', '', 'using-k2/k2-latest-items-by-user', 'index.php?option=com_k2&view=latest&layout=latest', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"source\":\"0\",\"latestItemsCols\":\"2\",\"latestItemsLimit\":\"3\",\"latestItemsDisplayEffect\":\"all\",\"userIDs\":[\"473\",\"472\"],\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"categoryTitle\":\"1\",\"categoryDescription\":\"1\",\"categoryImage\":\"1\",\"categoryFeed\":\"1\",\"latestItemTitle\":\"1\",\"latestItemTitleLinked\":\"1\",\"latestItemDateCreated\":\"1\",\"latestItemImage\":\"1\",\"latestItemImageSize\":\"Medium\",\"latestItemVideo\":\"1\",\"latestItemVideoWidth\":\"\",\"latestItemVideoHeight\":\"\",\"latestItemAudioWidth\":\"\",\"latestItemAudioHeight\":\"\",\"latestItemVideoAutoPlay\":\"0\",\"latestItemIntroText\":\"1\",\"latestItemCategory\":\"1\",\"latestItemTags\":\"1\",\"latestItemReadMore\":\"1\",\"latestItemCommentsAnchor\":\"0\",\"feedLink\":\"1\",\"latestItemK2Plugins\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 Latest Items by User\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '22', '23', '0', '*', '0'),
('125', 'mainmenu', 'K2 Modules', 'k2-modules', '', 'using-k2/k2-modules', 'index.php?option=com_k2&view=item&layout=item&id=135', 'component', '1', '118', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"K2 Modules\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '26', '27', '0', '*', '0'),
('126', 'mainmenu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=67', 'component', '1', '1', '1', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"67\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Blog\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '29', '30', '0', '*', '0'),
('127', 'social-menu', 'Facebook', '2013-06-25-12-32-57', '', '2013-06-25-12-32-57', 'https://www.facebook.com/nuevvo', 'url', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', '1', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"linkIsFacebook\",\"menu_image\":\"\",\"menu_text\":1}', '99', '100', '0', '*', '0'),
('128', 'social-menu', 'Twitter', '2013-06-25-12-34-00', '', '2013-06-25-12-34-00', 'https://twitter.com/nuevvo', 'url', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', '1', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"linkIsTwitter\",\"menu_image\":\"\",\"menu_text\":1}', '101', '102', '0', '*', '0'),
('129', 'social-menu', 'Google +', '2013-06-25-12-34-49', '', '2013-06-25-12-34-49', '#', 'url', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', '1', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"linkIsGooglePlus\",\"menu_image\":\"\",\"menu_text\":1}', '103', '104', '0', '*', '0'),
('130', 'social-menu', 'RSS', '2013-06-25-12-35-37', '', '2013-06-25-12-35-37', 'blog?format=feed', 'url', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', '1', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"linkIsRSS\",\"menu_image\":\"\",\"menu_text\":1}', '105', '106', '0', '*', '0'),
('144', 'mainmenu', 'Contact', 'contact', '', 'contact', 'index.php?option=com_contact&view=contact&id=1', 'component', '1', '1', '1', '8', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Contact us\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '73', '74', '0', '*', '0'),
('145', 'mainmenu', 'Joomla', 'joomla', '', 'joomla', 'index.php?option=com_content&view=category&layout=blog&id=18', 'component', '1', '1', '1', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"8\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Categories (Grid)\",\"pageclass_sfx\":\"gridView\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '31', '68', '0', '*', '0'),
('146', 'mainmenu', 'Content', 'content', '', 'joomla/content', 'index.php?Itemid=', 'alias', '1', '145', '2', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"145\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '32', '47', '0', '*', '0'),
('147', 'mainmenu', 'Archived Articles', 'archived-articles', '', 'joomla/content/archived-articles', 'index.php?option=com_content&view=archive', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"orderby_sec\":\"alpha\",\"order_date\":\"created\",\"display_num\":\"5\",\"filter_field\":\"\",\"introtext_limit\":\"100\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"link_titles\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Archived Articles\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '33', '34', '0', '*', '0'),
('148', 'mainmenu', 'Article', 'article', '', 'joomla/content/article', 'index.php?option=com_content&view=article&id=41', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_tags\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Article\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '35', '36', '0', '*', '0'),
('149', 'mainmenu', 'Category Blog', 'category-blog', '', 'joomla/content/category-blog', 'index.php?option=com_content&view=category&layout=blog&id=14', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Category Blog\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '37', '38', '0', '*', '0'),
('150', 'mainmenu', 'Category List', 'category-list', '', 'joomla/content/category-list', 'index.php?option=com_content&view=category&id=23', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Category List\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '39', '40', '0', '*', '0'),
('151', 'mainmenu', 'Featured Articles', 'featured-articles', '', 'joomla/content/featured-articles', 'index.php?option=com_content&view=featured', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"3\",\"multi_column_order\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Featured Articles\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '41', '42', '0', '*', '0'),
('152', 'mainmenu', 'List All Categories', 'list-all-categories', '', 'joomla/content/list-all-categories', 'index.php?option=com_content&view=categories&id=28', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_num_articles_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"List All Categories\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '43', '44', '0', '*', '0'),
('153', 'mainmenu', 'Create Article', 'create-article', '', 'joomla/content/create-article', 'index.php?option=com_content&view=form&layout=edit', 'component', '1', '146', '3', '22', '0', '0000-00-00 00:00:00', '0', '2', '', '0', '{\"enable_category\":\"0\",\"catid\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Create Article\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '45', '46', '0', '*', '0'),
('154', 'mainmenu', 'Weblinks', 'weblinks', '', 'joomla/weblinks', 'index.php?option=com_weblinks&view=category&id=6', 'component', '1', '145', '2', '21', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_links\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_link_description\":\"\",\"show_link_hits\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Weblinks in a Category\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '48', '53', '0', '*', '0'),
('155', 'mainmenu', 'Weblinks in a Category', 'weblinks-in-a-category', '', 'joomla/weblinks/weblinks-in-a-category', 'index.php?Itemid=', 'alias', '1', '154', '3', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"154\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '49', '50', '0', '*', '0'),
('156', 'mainmenu', 'Weblinks Categories', 'weblinks-categories', '', 'joomla/weblinks/weblinks-categories', 'index.php?option=com_weblinks&view=categories&id=0', 'component', '1', '154', '3', '21', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_num_links_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_links\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_link_description\":\"\",\"show_link_hits\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Weblinks Categories\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '51', '52', '0', '*', '0'),
('157', 'mainmenu', 'Newsfeeds', 'newsfeeds', '', 'joomla/newsfeeds', 'index.php?option=com_newsfeeds&view=category&id=5', 'component', '1', '145', '2', '17', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Newsfeeds in a Category\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '54', '61', '0', '*', '0'),
('158', 'mainmenu', 'Single Newsfeed', 'single-newsfeed', '', 'joomla/newsfeeds/single-newsfeed', 'index.php?option=com_newsfeeds&view=newsfeed&id=3', 'component', '1', '157', '3', '17', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '55', '56', '0', '*', '0'),
('159', 'mainmenu', 'Newsfeeds in a Category', 'newsfeeds-in-a-category', '', 'joomla/newsfeeds/newsfeeds-in-a-category', 'index.php?Itemid=', 'alias', '1', '157', '3', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"157\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '57', '58', '0', '*', '0'),
('160', 'mainmenu', 'Newsfeeds Categories', 'newsfeeds-categories', '', 'joomla/newsfeeds/newsfeeds-categories', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', '1', '157', '3', '17', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Newsfeeds Categories\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '59', '60', '0', '*', '0'),
('161', 'mainmenu', 'Search', 'search', '', 'joomla/search', 'index.php?option=com_search&view=search&searchword=', 'component', '1', '145', '2', '19', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"search_areas\":\"\",\"show_date\":\"\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Search\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '62', '63', '0', '*', '0'),
('162', 'mainmenu', 'Login', 'login', '', 'joomla/login', 'index.php?option=com_users&view=login', 'component', '1', '145', '2', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"Please login below to enter Members Area\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Login\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '64', '65', '0', '*', '0'),
('164', 'mainmenu', 'Typography', 'typography', '', 'typography', 'index.php?option=com_k2&view=item&layout=item&id=137', 'component', '1', '1', '1', '10000', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Typography\",\"pageclass_sfx\":\"typo\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '71', '72', '0', '*', '0'),
('165', 'mainmenu', 'Tags', 'tags', '', 'joomla/tags', 'index.php?option=com_tags&view=tag&id[0]=10&tag_list_language_filter=', 'component', '1', '145', '2', '29', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_tag_title\":\"\",\"tag_list_show_tag_image\":\"\",\"tag_list_show_tag_description\":\"\",\"tag_list_image\":\"\",\"tag_list_description\":\"\",\"show_tag_num_items\":\"\",\"tag_list_orderby\":\"\",\"tag_list_orderby_direction\":\"\",\"tag_list_show_item_image\":\"\",\"tag_list_show_item_description\":\"\",\"tag_list_item_maximum_characters\":0,\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"return_any_or_all\":\"\",\"include_children\":\"\",\"maximum\":200,\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"Tagged Items\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '66', '67', '0', '*', '0'),
('170', 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', '1', '1', '1', '32', '0', '0000-00-00 00:00:00', '0', '1', 'class:postinstall', '0', '', '69', '70', '0', '*', '1'),
('247', 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', '1', '1', '1', '28', '0', '0000-00-00 00:00:00', '0', '1', 'class:joomlaupdate', '0', '{}', '107', '108', '0', '', '1'),
('270', 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', '1', '1', '1', '34', '0', '0000-00-00 00:00:00', '0', '1', 'class:associations', '0', '{}', '109', '110', '0', '*', '1'),
('328', 'main', 'com_weblinks', 'com-weblinks', '', 'com-weblinks', 'index.php?option=com_weblinks', 'component', '1', '1', '1', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks', '0', '{}', '111', '116', '0', '', '1'),
('329', 'main', 'com_weblinks_links', 'com-weblinks-links', '', 'com-weblinks/com-weblinks-links', 'index.php?option=com_weblinks', 'component', '1', '328', '2', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks', '0', '{}', '112', '113', '0', '', '1'),
('330', 'main', 'com_weblinks_categories', 'com-weblinks-categories', '', 'com-weblinks/com-weblinks-categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', '1', '328', '2', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks-cat', '0', '{}', '114', '115', '0', '', '1'),
('355', 'main', 'COM_K2', 'com-k2', '', 'com-k2', 'index.php?option=com_k2&view=items', 'component', '1', '1', '1', '10000', '0', '0000-00-00 00:00:00', '0', '1', '../media/k2/assets/images/backend/k2_logo_16x16.png', '0', '{}', '117', '138', '0', '', '1'),
('356', 'main', 'K2_ITEMS', 'k2-items', '', 'com-k2/k2-items', 'index.php?option=com_k2&view=items', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '118', '119', '0', '', '1'),
('357', 'main', 'K2_CATEGORIES', 'k2-categories', '', 'com-k2/k2-categories', 'index.php?option=com_k2&view=categories', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '120', '121', '0', '', '1'),
('358', 'main', 'K2_TAGS', 'k2-tags', '', 'com-k2/k2-tags', 'index.php?option=com_k2&view=tags', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '122', '123', '0', '', '1'),
('359', 'main', 'K2_COMMENTS', 'k2-comments', '', 'com-k2/k2-comments', 'index.php?option=com_k2&view=comments', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '124', '125', '0', '', '1'),
('360', 'main', 'K2_USERS', 'k2-users', '', 'com-k2/k2-users', 'index.php?option=com_k2&view=users', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '126', '127', '0', '', '1'),
('361', 'main', 'K2_USER_GROUPS', 'k2-user-groups', '', 'com-k2/k2-user-groups', 'index.php?option=com_k2&view=usergroups', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '128', '129', '0', '', '1'),
('362', 'main', 'K2_EXTRA_FIELDS', 'k2-extra-fields', '', 'com-k2/k2-extra-fields', 'index.php?option=com_k2&view=extrafields', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '130', '131', '0', '', '1'),
('363', 'main', 'K2_EXTRA_FIELD_GROUPS', 'k2-extra-field-groups', '', 'com-k2/k2-extra-field-groups', 'index.php?option=com_k2&view=extrafieldsgroups', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '132', '133', '0', '', '1'),
('364', 'main', 'K2_MEDIA_MANAGER', 'k2-media-manager', '', 'com-k2/k2-media-manager', 'index.php?option=com_k2&view=media', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '134', '135', '0', '', '1'),
('365', 'main', 'K2_INFORMATION', 'k2-information', '', 'com-k2/k2-information', 'index.php?option=com_k2&view=info', 'component', '1', '355', '2', '10000', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '136', '137', '0', '', '1'),
('367', 'main', 'COM_AKEEBA', 'com-akeeba', '', 'com-akeeba', 'index.php?option=com_akeeba', 'component', '1', '1', '1', '10022', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '139', '140', '0', '', '1');
/**ABDB**/CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__languages`  VALUES 
('1', '0', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '1', '0', '1');
/**ABDB**/CREATE TABLE `#__k2_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `gender` enum('m','f','n') NOT NULL DEFAULT 'n',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `group` int(11) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userID` (`userID`),
  KEY `group` (`group`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_users`  VALUES 
('1', '471', 'Administrator', 'm', '<p>purus habitasse metus libero neque augue mauris vehicula ipsum nibh, vulputate blandit sodales feugiat elementum nec morbi suscipit sociosqu, a aliquam cursus semper pharetra augue id suscipit.</p>', NULL, '', '2', '', '62.38.248.168', 'static062038248168.dsl.hol.gr', ''),
('2', '473', 'Jane Doe', 'f', '<p>litora aptent lacinia tempus gravida luctus maecenas fusce aptent, imperdiet luctus aliquet fringilla class donec class praesent fermentum, malesuada fermentum phasellus primis libero class interdum.</p>', NULL, 'http://nuevvo.com', '1', '', '::1', 'localhost', ''),
('3', '472', 'John Doe', 'm', '<p>tellus nostra augue donec phasellus venenatis et gravida tellus tempus euismod. nec fermentum luctus pretium platea sodales primis euismod lacinia, luctus hendrerit potenti elit nostra aliquam iaculis.</p>', NULL, '', '0', '', '', '', '');
/**ABDB**/CREATE TABLE `#__k2_user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `permissions` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_user_groups`  VALUES 
('1', 'Registered', '{\"comment\":\"1\",\"frontEdit\":\"0\",\"add\":\"0\",\"editOwn\":\"0\",\"editAll\":\"0\",\"publish\":\"0\",\"inheritance\":0,\"categories\":\"all\"}'),
('2', 'Site Owner', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"inheritance\":1,\"categories\":\"all\"}');
/**ABDB**/CREATE TABLE `#__k2_tags_xref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagID` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tagID` (`tagID`),
  KEY `itemID` (`itemID`)
) ENGINE=InnoDB AUTO_INCREMENT=585 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_tags_xref`  VALUES 
('178', '2', '61'),
('179', '43', '61'),
('180', '49', '61'),
('191', '45', '65'),
('192', '46', '65'),
('193', '49', '65'),
('205', '73', '70'),
('206', '79', '70'),
('232', '97', '80'),
('233', '98', '80'),
('234', '44', '80'),
('244', '96', '85'),
('245', '97', '85'),
('246', '100', '85'),
('247', '42', '86'),
('248', '44', '86'),
('249', '45', '86'),
('257', '77', '89'),
('258', '80', '89'),
('259', '45', '90'),
('260', '46', '90'),
('281', '3', '97'),
('282', '46', '97'),
('283', '48', '97'),
('284', '49', '97'),
('287', '73', '99'),
('288', '74', '99'),
('289', '75', '99'),
('290', '73', '100'),
('291', '76', '100'),
('292', '77', '100'),
('293', '80', '100'),
('301', '96', '103'),
('302', '98', '103'),
('303', '95', '103'),
('323', '44', '111'),
('324', '46', '111'),
('325', '48', '111'),
('340', '80', '117'),
('341', '74', '117'),
('344', '98', '119'),
('345', '95', '119'),
('346', '96', '119'),
('347', '95', '119'),
('375', '76', '129'),
('376', '77', '129'),
('387', '96', '133'),
('388', '98', '133'),
('389', '95', '133'),
('397', '3', '136'),
('398', '44', '136'),
('399', '45', '136'),
('400', '48', '136'),
('438', '60', '121'),
('439', '44', '121'),
('440', '50', '120'),
('441', '53', '120'),
('442', '56', '120'),
('443', '55', '120'),
('448', '54', '94'),
('449', '122', '94'),
('450', '123', '94'),
('451', '44', '88'),
('452', '55', '88'),
('453', '58', '88'),
('454', '60', '88'),
('455', '52', '82'),
('456', '55', '82'),
('457', '50', '78'),
('458', '56', '78'),
('459', '44', '77'),
('460', '54', '77'),
('461', '60', '77'),
('462', '63', '77'),
('463', '50', '73'),
('464', '44', '73'),
('465', '1', '73'),
('466', '54', '71'),
('467', '120', '71'),
('468', '125', '71'),
('469', '51', '60'),
('470', '1', '60'),
('471', '122', '58'),
('472', '123', '58'),
('473', '120', '57'),
('474', '123', '57'),
('475', '124', '57'),
('476', '125', '57'),
('516', '85', '122'),
('517', '88', '122'),
('533', '43', '130'),
('534', '87', '130'),
('535', '44', '130'),
('536', '81', '114'),
('537', '82', '114'),
('538', '84', '114'),
('539', '88', '114'),
('540', '43', '112'),
('541', '84', '112'),
('542', '86', '112'),
('543', '81', '105'),
('544', '85', '105'),
('545', '44', '91'),
('546', '86', '91'),
('547', '87', '91'),
('548', '82', '68'),
('549', '44', '68'),
('550', '43', '68'),
('551', '88', '68'),
('552', '76', '110'),
('553', '77', '110'),
('554', '78', '110'),
('555', '63', '110'),
('556', '12', '79'),
('557', '75', '79'),
('558', '76', '79'),
('559', '126', '63'),
('560', '75', '63'),
('561', '77', '63'),
('578', '55', '101'),
('579', '114', '101'),
('580', '63', '101'),
('581', '116', '101'),
('582', '114', '135'),
('583', '52', '135'),
('584', '62', '135');
/**ABDB**/CREATE TABLE `#__k2_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_tags`  VALUES 
('1', 'Art', '1'),
('2', 'Music', '1'),
('3', 'Intense', '1'),
('12', 'Performance', '1'),
('42', 'Sensational', '1'),
('43', 'New', '1'),
('44', 'Trendy', '1'),
('45', 'Exercise', '1'),
('46', 'Samba', '1'),
('48', 'Tango', '1'),
('49', 'Concert', '1'),
('50', 'Helvetica', '1'),
('51', 'Typeface', '1'),
('52', 'Minimal', '1'),
('53', 'Interior', '1'),
('54', 'Modern', '1'),
('55', 'Vintage', '1'),
('56', 'Exterior', '1'),
('58', 'Italian', '1'),
('60', 'Autumn  Winter', '1'),
('62', 'Couture', '1'),
('63', 'Inspirational', '1'),
('73', 'Cinema', '1'),
('74', 'Hollywood', '1'),
('75', 'Actors', '1'),
('76', 'Action', '1'),
('77', 'Comedy', '1'),
('78', 'Drama', '1'),
('79', 'Epic', '1'),
('80', 'Anime', '1'),
('81', 'Chill out', '1'),
('82', 'New Release', '1'),
('83', 'Trendy', '1'),
('84', 'Upcoming', '1'),
('85', 'Album of the Week', '1'),
('86', 'House', '1'),
('87', 'Instrumental', '1'),
('88', 'Electronic', '1'),
('95', 'Cozy', '1'),
('96', 'Rock Music', '1'),
('97', 'Dance', '1'),
('100', 'Crowded', '1'),
('114', 'Eccentric', '1'),
('116', 'Avant Garde', '1'),
('120', 'Tech', '1'),
('122', 'Apple', '1'),
('123', 'Geek', '1'),
('124', 'Bleeding Edge', '1'),
('125', 'Must Buy', '1'),
('126', 'Broadway', '1'),
('146', 'reerrt', '1');
/**ABDB**/CREATE TABLE `#__k2_rating` (
  `itemID` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(11) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(11) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`itemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_rating`  VALUES 
('57', '5', '1', '84.29.244.39'),
('58', '19', '4', '178.60.147.32'),
('60', '4', '1', '127.0.0.1'),
('71', '16', '4', '178.49.209.210'),
('73', '4', '1', '127.0.0.1'),
('77', '23', '5', '213.161.151.3'),
('78', '5', '1', '178.148.178.26'),
('79', '5', '1', '127.0.0.1'),
('88', '16', '4', '2.230.203.176'),
('94', '5', '1', '109.95.74.233'),
('101', '13', '4', '127.0.0.1'),
('105', '5', '1', '188.17.190.168'),
('114', '10', '2', '90.154.65.78'),
('120', '23', '5', '2.230.203.176'),
('121', '100', '24', '127.0.0.1'),
('122', '5', '1', '178.127.70.18'),
('130', '14', '4', '93.32.78.132'),
('135', '96', '24', '127.0.0.1');
/**ABDB**/CREATE TABLE `#__k2_log` (
  `status` int(11) NOT NULL,
  `response` text NOT NULL,
  `timestamp` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_log`  VALUES 
('200', 'Anonymous metrics submitted - thank you for helping make K2 better!', '2019-07-27 08:26:11');
/**ABDB**/CREATE TABLE `#__k2_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` smallint(6) NOT NULL DEFAULT '0',
  `featured_ordering` int(11) NOT NULL DEFAULT '0',
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `created_by` (`created_by`),
  KEY `ordering` (`ordering`),
  KEY `featured` (`featured`),
  KEY `featured_ordering` (`featured_ordering`),
  KEY `hits` (`hits`),
  KEY `created` (`created`),
  KEY `language` (`language`),
  KEY `idx_item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),
  FULLTEXT KEY `search` (`title`,`introtext`,`fulltext`,`extra_fields_search`,`image_caption`,`image_credits`,`video_caption`,`video_credits`,`metadesc`,`metakey`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=146 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_items`  VALUES 
('56', 'Nullam nisl litora quis vel', 'nullam-nisl-litora-quis-vel', '30', '1', '<p>iaculis tempor est inceptos sollicitudin praesent neque odio suspendisse, ipsum felis turpis varius augue non accumsan fames, mattis interdum ut lectus conubia elit turpis. vulputate erat etiam mattis ipsum cursus tellus, elementum lobortis dictum fusce sagittis, porta vivamus primis aliquam fermentum. elementum justo sociosqu sollicitudin suspendisse feugiat ligula convallis ultricies felis aptent, mollis hac tempus magna arcu primis pellentesque nibh etiam, fermentum sem aliquam condimentum egestas potenti etiam sociosqu rhoncus. hendrerit fames consectetur erat aenean imperdiet orci luctus a litora proin, a curabitur tincidunt turpis at risus mattis imperdiet id phasellus, vestibulum donec etiam nisi cursus tortor fermentum tristique nisl.</p>\r\n', '\r\n<p>ullamcorper curabitur nostra arcu sapien vivamus quisque, consectetur eu dapibus taciti metus libero quam, pharetra turpis quisque ullamcorper ultrices. hendrerit curabitur in aptent morbi interdum per posuere non donec nibh, suspendisse ornare quisque luctus vehicula ante sed donec gravida, praesent interdum tempor ipsum maecenas molestie bibendum justo vel. porttitor porta aenean congue dolor ut convallis diam suscipit tortor dapibus, magna eget arcu etiam metus conubia inceptos elit platea, malesuada tortor duis dolor sem consectetur egestas hendrerit pharetra. class tempor ultrices aliquet pulvinar donec, nisl sit rutrum fusce egestas, ut torquent dui senectus.</p>\r\n<p>risus donec curae sollicitudin dictum velit odio velit, inceptos eros mollis ornare rutrum porta, nibh curabitur potenti pharetra aliquam pharetra. laoreet diam ac quam vivamus egestas est ad metus, hendrerit phasellus ac risus vivamus luctus curae, fringilla ullamcorper dolor blandit rutrum tempor duis. feugiat sit nullam sagittis fermentum ultrices habitasse feugiat aenean, at semper rhoncus netus gravida fermentum ullamcorper, ante quisque turpis volutpat accumsan neque faucibus. felis malesuada conubia interdum gravida condimentum tellus vel nibh suspendisse ligula augue arcu, sit et sodales consequat morbi integer tellus nibh condimentum vulputate.</p>\r\n<p>tristique turpis cursus pharetra donec aptent viverra curabitur proin, risus congue volutpat ultricies risus sagittis facilisis mattis potenti, eget tristique per nibh justo nulla turpis. sapien senectus eros blandit aliquet commodo vehicula tristique, fusce dolor mattis nullam adipiscing mattis vel, cras neque ut elit at diam nec, ornare rutrum a maecenas imperdiet viverra. dapibus dictum phasellus porta curae porttitor curabitur lacinia, class iaculis nulla cursus nibh dui. eleifend sagittis sodales lectus sodales sed leo phasellus massa erat aenean, proin volutpat arcu rhoncus elementum phasellus sociosqu imperdiet varius, sit nisi urna cursus scelerisque potenti varius mollis libero.</p>\r\n<p>augue vestibulum ligula litora ullamcorper curabitur integer dictum quam orci, iaculis vivamus et etiam lacinia fringilla luctus commodo, mattis vehicula lorem habitant viverra dictumst malesuada tempor. ut pellentesque est potenti ullamcorper morbi pellentesque blandit maecenas, libero ornare aptent curae hac commodo sapien lacus, venenatis aliquet ut posuere duis amet molestie. etiam tortor molestie sapien non hendrerit mauris posuere nulla quisque maecenas, posuere euismod quisque curabitur euismod at per vestibulum fermentum, a rutrum curabitur sodales tortor arcu magna quisque quis. cubilia non curabitur vestibulum varius litora nam ut nullam class neque fames, arcu pulvinar feugiat morbi tellus ipsum lacinia fusce urna.</p>\r\n<p>velit maecenas volutpat imperdiet elementum facilisis iaculis libero nullam, tristique class congue vehicula arcu urna sociosqu, ad aenean curabitur habitant porta quisque volutpat.</p>', '{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}', '{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}', '[{\"id\":\"1\",\"value\":\"\"}]', ' ', '2013-06-21 12:35:15', '471', '', '0', '0000-00-00 00:00:00', '2013-07-11 11:58:45', '471', '2013-06-21 12:35:15', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Et habitant lacus tempor aptent non ', 'Generated by FillItUp', 'Vestibulum faucibus placerat ante tincidunt ', 'Generated by FillItUp', '3', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('57', 'Vitae feugiat vehicula', 'vitae-feugiat-vehicula', '44', '1', '<p>ante scelerisque justo faucibus tincidunt ullamcorper duis hendrerit phasellus tellus suspendisse integer, nec sollicitudin ante a luctus curabitur nec tempor lacinia nibh viverra, aliquam inceptos elit a turpis cursus laoreet integer dui aenean. platea amet potenti donec dolor per nulla proin, aliquam imperdiet consequat integer sodales himenaeos tortor purus, phasellus risus condimentum dictum potenti odio. quisque suspendisse tempor convallis congue quisque duis, mollis class nullam felis lorem, etiam per justo vel torquent. himenaeos odio vestibulum eros pretium vel odio curae tristique eros, dictum neque habitasse mi ornare luctus elit sed non aptent, id rhoncus hendrerit commodo inceptos sit primis velit.</p>\r\n', '\r\n<p>est lorem aliquam magna consectetur nostra orci venenatis ut himenaeos aliquet, tristique vestibulum accumsan tristique porttitor primis fusce dui adipiscing donec, risus mattis nunc tempor quis suspendisse dolor class imperdiet. fringilla sagittis erat gravida class felis imperdiet pretium volutpat maecenas integer venenatis, volutpat molestie ut metus varius tempor adipiscing hendrerit ad fames justo posuere, cursus massa ultrices magna nullam euismod sodales libero ad auctor. sit felis class felis quisque turpis nunc auctor, eleifend quisque magna cursus lobortis netus, donec aliquet platea proin massa turpis. netus litora convallis mollis consequat ut est proin elementum integer ultricies rhoncus torquent, aliquet egestas commodo nibh neque gravida conubia ipsum in class enim, quam convallis nec erat porttitor scelerisque malesuada molestie tristique auctor tellus.</p>\r\n<p>velit viverra pharetra dapibus quis vivamus a curabitur posuere erat aliquet auctor, quisque odio mauris ut nullam est rutrum diam accumsan tellus, hac amet tincidunt euismod consequat feugiat fermentum lacus blandit eget. donec rutrum a gravida tincidunt rutrum rhoncus euismod varius posuere, hac id conubia mi ullamcorper varius ut velit, quis conubia hac feugiat sollicitudin faucibus eget erat. lectus neque nisi senectus scelerisque diam turpis aliquam mollis porta, aliquam nunc volutpat praesent fusce ac pellentesque ultrices auctor, placerat diam sodales integer ullamcorper neque ac cras. viverra sociosqu sit habitant pellentesque class nostra fames vel magna, sagittis ultrices litora dictumst curabitur luctus ultricies lectus phasellus, viverra vitae mollis auctor fermentum fringilla sit imperdiet.</p>\r\n<p>potenti id eros donec etiam cursus quam eu mi, cursus sapien lacus inceptos velit quam adipiscing dictum, ut ligula curae aenean quam lorem sem. ornare rhoncus at senectus laoreet gravida platea odio massa sed justo, torquent enim blandit aptent convallis litora congue integer elementum etiam, bibendum rhoncus cubilia diam dapibus fames neque senectus donec. non vulputate porttitor odio pellentesque ultricies sit dictumst phasellus habitasse, nisi volutpat elementum amet purus iaculis dictumst aenean gravida, quis potenti egestas aenean in aptent mollis semper. blandit etiam sagittis felis vel aliquam eget cubilia ultricies, tellus est sollicitudin rhoncus faucibus augue maecenas curae, auctor orci primis suscipit a tincidunt vestibulum.</p>\r\n<p>class volutpat etiam scelerisque bibendum ultrices sem per, leo erat neque turpis at litora turpis, et enim donec massa blandit risus. eleifend luctus quisque facilisis imperdiet dapibus pulvinar ut, arcu ultricies nisl maecenas nibh rutrum eget, eros a urna luctus vitae quam. convallis mauris mattis non lacus tellus sollicitudin tristique, aenean fermentum at nam adipiscing iaculis ultricies lobortis, velit posuere metus nibh mattis faucibus.</p>', '{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}', '{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}', '[]', '', '2013-06-21 12:35:35', '472', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:28:27', '471', '2013-06-21 12:35:35', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Iaculis conubia ornare fames tincidunt tempus ', 'Generated by FillItUp', 'Et malesuada eros hac lacus sed ', 'Generated by FillItUp', '796', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('58', 'Sagittis proin a curabitur dictum consequat', 'sagittis-proin-a-curabitur-dictum-consequat', '44', '1', '<p>vitae donec netus justo vulputate gravida, mi eu porta etiam eleifend, sodales primis congue varius. fermentum potenti curae porttitor sollicitudin sem proin gravida diam inceptos tortor, aliquam sem lacinia et per lobortis vehicula pretium. hac sit iaculis nisi nibh potenti cras feugiat gravida etiam, enim primis erat ultricies justo ligula vehicula lectus tempor posuere, nullam ultrices luctus et magna diam viverra tellus. netus imperdiet inceptos malesuada dapibus ad dui, donec dictum curae molestie hac ultricies, potenti condimentum tempor etiam suscipit. eget amet habitasse integer est scelerisque urna adipiscing, ultrices aptent rutrum hendrerit tortor sodales, ante pulvinar dolor hac quisque iaculis.</p>\r\n', '\r\n<p>porta velit nec donec curabitur adipiscing odio mi ut cubilia luctus amet fringilla proin, in volutpat ipsum sapien condimentum porta fusce quam leo nullam risus. volutpat semper convallis lacinia cursus luctus elementum, lacus varius consectetur felis ad hac, duis at nibh neque vel. fringilla viverra habitant congue justo in lectus non laoreet, sapien eleifend interdum eget mi eleifend blandit praesent, aenean senectus habitant malesuada vehicula pharetra ullamcorper. ante non sapien cubilia ornare nec libero netus curabitur donec nisi dictum, libero aliquam malesuada varius ornare ut vehicula porta donec sem sodales, accumsan varius sit pulvinar molestie eget nullam aliquam adipiscing justo.</p>\r\n<p>venenatis cursus elit viverra cubilia blandit potenti aliquet porttitor enim, ultrices dolor praesent libero dictum ad congue eget, nullam maecenas torquent netus senectus faucibus venenatis eros. justo quisque curabitur dolor lorem condimentum amet adipiscing platea ultricies id pharetra posuere, mi enim vestibulum augue torquent per placerat fames mattis primis nunc. taciti venenatis accumsan non lorem per tempor, leo conubia nulla justo integer himenaeos inceptos, sociosqu felis auctor commodo porta. nisl laoreet vitae non nisl vulputate ad litora facilisis id, libero risus dictumst ultricies morbi curae eros rhoncus consequat, lobortis netus class nulla porttitor aenean ipsum tincidunt.</p>\r\n<p>aliquet rutrum ultricies etiam vivamus fusce etiam posuere phasellus justo vestibulum, mauris class rhoncus taciti aliquet malesuada bibendum tristique. blandit tristique velit habitasse mollis erat nullam facilisis eleifend aptent platea, lacinia enim urna interdum nisi aliquam lectus consequat justo, massa tempus fringilla ultrices himenaeos aliquam vel ornare eu. tincidunt porttitor ut etiam donec enim aliquam vulputate netus libero, cras sed senectus risus scelerisque tincidunt convallis fermentum. ultricies dolor donec et sollicitudin dui quam porta blandit class, vel risus curabitur nisi maecenas eros sociosqu ultrices, auctor eu quis turpis ac risus interdum sagittis.</p>\r\n<p>eleifend inceptos laoreet vehicula eros a eleifend turpis ultrices nisi, torquent pretium odio dolor risus facilisis pellentesque elementum, vestibulum mollis litora ipsum conubia pretium bibendum dui. adipiscing magna egestas malesuada sem blandit ut ac neque tellus consequat donec pellentesque, erat ligula euismod nisl enim donec mi etiam interdum consequat suscipit. a curabitur consequat pellentesque dapibus risus curabitur lobortis varius rhoncus, consectetur platea duis curabitur venenatis ullamcorper facilisis vivamus amet, sagittis elit class placerat vitae sit hac eu. accumsan sed porta cras donec eget proin ligula accumsan nibh, lorem sed tempor porttitor nostra purus lorem per, egestas eu ad nec sit erat blandit leo.</p>\r\n<p>lectus etiam augue potenti molestie auctor, nibh maecenas elit.</p>', '{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}', '{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}', '[]', '', '2013-06-21 12:35:47', '472', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:28:12', '471', '2013-06-21 12:35:47', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Vestibulum aenean adipiscing condimentum sagittis ', 'Generated by FillItUp', 'Commodo suscipit mattis congue ', 'Generated by FillItUp', '5718', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('60', 'Non adipiscing inceptos', 'non-adipiscing-inceptos', '33', '1', '<p>eros blandit commodo magna dictum et habitant suscipit odio massa, porta porttitor lacus tortor scelerisque sem per consequat tempor vivamus, bibendum rutrum fames nostra mattis morbi risus facilisis. porta tristique mi in nisi auctor porta euismod, class ante pretium pulvinar arcu sit sollicitudin, auctor a nostra consequat auctor odio. inceptos mattis mollis magna arcu laoreet iaculis blandit cubilia, rhoncus placerat netus massa neque duis nisi, curabitur eros neque duis nam etiam tempor. placerat eu luctus in habitasse auctor ornare iaculis sodales a, rhoncus magna scelerisque nostra interdum elementum egestas proin elit risus, magna aliquam curabitur aptent aliquam cubilia porttitor risus.</p>\r\n', '\r\n<p>purus varius libero nullam magna dictumst sit tortor aenean nec arcu faucibus auctor turpis nunc ante, hac ut accumsan litora mi maecenas per id vitae habitasse platea odio dapibus. varius felis dapibus id euismod aliquet consectetur lacus eleifend metus himenaeos, inceptos id etiam commodo neque vitae placerat a hendrerit tempus mattis, sit risus molestie dictumst posuere congue phasellus laoreet dolor. taciti lectus pretium nibh interdum sagittis gravida mauris curabitur, velit sociosqu vulputate ligula nunc sed ut eget ut, netus malesuada donec nibh posuere quis tempus. ultricies donec ipsum per lorem auctor massa duis diam curae euismod eu, duis venenatis tempor inceptos morbi integer viverra vivamus diam nulla, semper elementum vivamus dictumst curae facilisis rutrum donec et aliquam.</p>\r\n<p>etiam auctor libero ad sem dolor est porttitor, duis sapien porta sed lorem ut netus odio, velit ut non aenean pharetra praesent. eleifend pellentesque curabitur pulvinar ligula primis mauris tempor quam, nullam feugiat venenatis nullam morbi libero ornare, dolor elit egestas hendrerit tortor nostra himenaeos. quam blandit a sed egestas neque aenean iaculis feugiat, faucibus egestas venenatis cubilia malesuada pharetra nunc iaculis, vehicula tristique porttitor dictum rutrum nibh scelerisque. hendrerit molestie convallis aliquet semper felis dapibus, turpis quam ipsum risus eros dictum, tempor orci facilisis orci cras. tortor vestibulum ligula sem varius dui quisque sodales velit potenti vitae semper, accumsan dictum consequat condimentum potenti ultricies nec felis gravida hendrerit, inceptos velit auctor imperdiet scelerisque eleifend feugiat tempor sollicitudin morbi.</p>\r\n<p>ligula torquent sit amet quam quis ornare fusce est mauris, erat curabitur nec per erat lacinia odio ante vitae est, viverra curabitur ipsum venenatis elit magna odio ut. leo conubia semper adipiscing aenean vitae class ligula eleifend tempor, hendrerit ac proin volutpat vel commodo leo lorem hac, quisque sed ut rhoncus ac cubilia aliquam aenean. fringilla est dictum facilisis sociosqu cubilia vitae aliquet pulvinar, eleifend tempor curae est nostra dictumst molestie, torquent inceptos auctor id quisque bibendum taciti. varius ornare tellus varius rutrum vulputate, faucibus ad ullamcorper tempor libero, pulvinar cubilia venenatis fringilla.</p>\r\n<p>ad iaculis duis integer aliquet molestie elit accumsan gravida luctus, tincidunt egestas risus sagittis habitant id facilisis pretium, arcu nisl placerat ullamcorper ad lectus feugiat volutpat. ac fusce morbi rhoncus est posuere sollicitudin ultricies, curae vulputate aliquam maecenas habitasse scelerisque senectus justo, etiam ullamcorper eget diam cubilia congue. sollicitudin congue etiam donec varius inceptos etiam hac inceptos, sociosqu fringilla mattis curabitur taciti donec vulputate, litora ultricies nunc suscipit lacus posuere gravida.</p>', '{youtube}http://www.youtube.com/watch?v=hzg8ZeQpWVc{/youtube}', '{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}', '[]', '', '2013-06-21 12:36:22', '473', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:27:57', '471', '2013-06-21 12:36:22', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Consequat ut auctor primis leo ', 'Generated by FillItUp', 'Fermentum tincidunt augue senectus ', 'Generated by FillItUp', '1081', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('61', 'Dictum porttitor fusce felis turpis feugiat', 'dictum-porttitor-fusce-felis-turpis-feugiat', '32', '1', '<p>\nsollicitudin imperdiet lorem elementum himenaeos sociosqu mattis sodales urna, molestie morbi molestie facilisis erat cras ac aliquam proin, fames himenaeos diam per nisl nunc ut. \nprimis molestie convallis eget ad hac varius, senectus sem at ullamcorper nunc urna, sem massa semper justo pulvinar. \ninterdum facilisis feugiat ac proin aliquet venenatis habitant amet porttitor nostra senectus, sagittis consectetur cubilia varius pharetra vel placerat mollis neque habitasse, ullamcorper ad feugiat varius himenaeos auctor mi eros cras potenti. \nfeugiat nisi lectus turpis enim torquent fames dui curabitur, aliquet himenaeos ullamcorper turpis tellus velit iaculis placerat posuere, feugiat congue lacus suspendisse nisi tempus donec. \n</p>', '<p>\ncras facilisis faucibus himenaeos luctus vel adipiscing lorem platea suspendisse, morbi accumsan ligula ipsum et sagittis blandit non massa metus, blandit integer eros eleifend neque morbi blandit viverra. \naliquam luctus vitae at viverra arcu, lobortis aptent metus massa nostra, fermentum netus odio hac. \ncurabitur cras litora vestibulum purus commodo mauris, vehicula malesuada taciti etiam tellus tempus blandit, amet accumsan dolor malesuada lectus. \netiam taciti nec suscipit turpis non ultricies molestie lobortis senectus ullamcorper orci pharetra erat libero lacus auctor, tortor morbi maecenas convallis accumsan tincidunt feugiat iaculis cubilia integer sit blandit arcu potenti sagittis. \n</p>\n<p>\nmi pellentesque facilisis taciti sit pellentesque rhoncus, praesent est diam pharetra mauris, imperdiet felis rutrum nibh ullamcorper. \nblandit aliquam nunc enim volutpat elementum cursus potenti auctor massa, morbi sodales inceptos mattis a mattis cras eu. \nmorbi netus lorem rutrum quisque nam faucibus per inceptos, cursus arcu habitasse diam quisque cubilia donec, pulvinar etiam curabitur habitant sit ut scelerisque. \nnisi aenean egestas euismod tempus est suscipit sed iaculis luctus a aliquet odio dapibus posuere habitasse imperdiet torquent, semper ipsum lobortis dictum egestas aliquet ipsum egestas molestie aliquam phasellus venenatis fringilla laoreet elementum. \n</p>\n<p>\neuismod semper tincidunt donec dictumst donec aliquam cubilia, blandit adipiscing dictum mauris vivamus duis nisl justo, per bibendum maecenas tristique dapibus feugiat. \ntincidunt non accumsan vel morbi vel nibh metus eget ipsum luctus turpis aliquam neque hendrerit sagittis, dapibus proin diam ipsum accumsan augue potenti sociosqu ad ultricies habitant nec sit varius. \nmorbi sodales lorem egestas accumsan nam eros pharetra, donec class dui condimentum eget lobortis sodales, porttitor tempor accumsan nibh a vestibulum. \nlobortis litora id euismod habitant etiam mattis vitae proin fermentum, sit potenti erat mi mollis adipiscing potenti quisque egestas curabitur, venenatis sapien vivamus magna adipiscing curae aliquam porttitor. \n</p>\n<p>\nturpis class rutrum ac sapien aptent nec venenatis, convallis pretium elementum felis neque quis potenti magna, sem tristique dictumst ornare sollicitudin quam. \neu curabitur risus elit velit eros laoreet arcu pellentesque gravida hendrerit non curabitur, aliquam nisi mauris dapibus suspendisse integer nec purus faucibus dui sed nibh, in ullamcorper donec magna elit at est in nam faucibus sodales. \nhac sollicitudin tortor egestas in sapien metus donec suscipit netus pharetra, litora pellentesque dictumst phasellus amet diam lacinia varius sit tempor etiam, rutrum aliquam vivamus eget aptent aenean fusce rutrum sem. \n</p>\n<p>\nimperdiet diam ut inceptos sollicitudin et aenean, vivamus tempor duis sagittis class ut nunc, sem dictum accumsan porta primis. \nmollis curabitur gravida urna, vivamus pretium. \n</p>', '{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-06-21 12:36:46', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:36:46', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Dolor vulputate enim adipiscing pellentesque dictum ', 'Generated by FillItUp', 'Velit venenatis magna lectus potenti ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('63', 'Torquent ut risus gravida', 'torquent-ut-risus-gravida', '45', '1', '<p>odio mollis vehicula sem eros morbi nunc nullam nam, ornare luctus iaculis taciti neque dictumst et faucibus, et vel auctor sagittis mattis lectus taciti. porttitor primis habitasse aenean amet pretium nam vitae curabitur malesuada, fringilla varius sed laoreet mi taciti phasellus urna dui, vitae lectus maecenas fermentum curabitur sagittis ac hendrerit. feugiat mollis suspendisse nam tellus elementum mattis commodo augue hac eu iaculis aliquet egestas justo curae, ac auctor mattis fermentum porttitor tempus vestibulum vel morbi tempus lacinia hac non lectus. taciti bibendum erat taciti habitasse elit feugiat nibh litora etiam aliquam, amet nunc nisi auctor aptent ac aliquam donec.</p>\r\n', '\r\n<p>velit laoreet per sodales primis mattis lacus magna metus, vel tristique nisi commodo dictum condimentum habitasse id mi, sit adipiscing lacinia quisque eget potenti pretium. bibendum dolor nam risus cursus habitasse vivamus, id dui tristique adipiscing facilisis eleifend, non eleifend lacus tincidunt adipiscing. tristique per nunc mauris nibh volutpat porta justo tristique elit a ut dapibus, condimentum hac integer semper dui commodo pellentesque inceptos elit rhoncus per blandit suspendisse, ac tortor fermentum aliquam morbi lacinia blandit sed tortor aliquet augue. mauris aliquam integer malesuada lectus scelerisque habitant urna bibendum, mi diam eleifend rhoncus tristique euismod vivamus ut a, aliquam fusce fringilla ornare nam imperdiet taciti.</p>\r\n<p>imperdiet vestibulum cras donec taciti iaculis ligula morbi aliquam nibh at, leo dictumst sed nec scelerisque congue nunc fringilla taciti etiam nibh, aenean tempus adipiscing pretium ac habitasse quis congue duis. amet nam nulla gravida cursus scelerisque ante ad id adipiscing accumsan odio, eleifend in accumsan ante imperdiet convallis ligula dui aenean. nec aenean neque lectus curae vulputate ante, a condimentum pretium feugiat maecenas vitae, imperdiet sollicitudin nunc luctus porttitor. luctus arcu tristique sit fermentum arcu curabitur et, litora cras placerat aliquet eleifend cras, justo nam nibh ad class nec.</p>\r\n<p>neque vel ante ligula condimentum pellentesque consequat class curabitur tristique, felis pretium sagittis lacus feugiat metus volutpat potenti, torquent eu semper maecenas habitasse lacinia eu fames. ultrices habitasse ad neque fermentum sapien consectetur duis aliquet, accumsan dictumst tempus amet gravida litora malesuada accumsan libero, molestie vitae lorem lectus rhoncus nisl suspendisse. bibendum tempus imperdiet ante maecenas sem amet rutrum laoreet, curabitur pulvinar tristique diam aenean vehicula phasellus urna, consequat a iaculis rutrum curabitur eu consequat. taciti leo ad gravida sollicitudin nisl cras primis porttitor curabitur, lacus sem potenti mauris inceptos nec semper vehicula, pretium magna donec fringilla pharetra curabitur tempus ultricies.</p>\r\n<p>adipiscing libero aliquam porttitor cursus tellus aenean odio, nostra metus mollis leo tincidunt varius, aenean neque nisl lacus orci urna. lobortis primis sed proin fringilla aliquet arcu tempus libero aenean, accumsan scelerisque elit ante aptent lacus integer cursus etiam, lacus mattis congue urna congue leo vestibulum convallis. viverra cursus aliquam tristique curabitur gravida aptent placerat aliquet accumsan quisque, consequat elementum nisl eros dui convallis blandit hac primis, etiam volutpat nostra porta aenean lacus auctor bibendum egestas. metus accumsan donec dolor facilisis himenaeos litora mollis leo, nulla platea mi nisl accumsan urna lobortis.</p>\r\n<p>diam lacus curae eros augue, habitant purus donec eleifend, gravida quisque duis.</p>', '{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}', '{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}', '[]', '', '2013-06-21 12:37:24', '472', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:28:41', '471', '2013-06-21 12:37:24', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Sed pretium commodo ', 'Generated by FillItUp', 'Dictumst urna ante congue dolor ', 'Generated by FillItUp', '833', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('65', 'Amet varius ad mattis aenean ad', 'amet-varius-ad-mattis-aenean-ad', '32', '1', '<p>\nbibendum ante ipsum bibendum imperdiet cras nostra habitasse feugiat, vel lacinia vestibulum nunc consequat class ligula, duis nunc vitae etiam sociosqu torquent praesent. \nauctor justo lobortis nisl auctor id vestibulum class suspendisse faucibus praesent tempus at tellus sit nibh tincidunt ad, ultricies platea lacinia vulputate himenaeos elit tincidunt nec et nec arcu auctor habitasse ipsum laoreet lacus. \nvenenatis aliquet dictum eget cras pharetra dictumst augue taciti, sit bibendum est urna felis vel neque urna venenatis, praesent ac lobortis luctus suscipit accumsan quam. \nsuspendisse proin praesent lectus donec lacus etiam netus dictumst accumsan, curabitur cursus curabitur faucibus viverra elit phasellus mattis. \n</p>', '<p>\npurus condimentum curabitur tempus adipiscing ante est erat cubilia varius ut hac id, hendrerit blandit litora vulputate aliquet non conubia inceptos facilisis aliquam aptent. \nfelis himenaeos rutrum litora primis nec tortor potenti, est nullam commodo convallis litora ipsum orci, cursus aliquet vehicula metus nibh suscipit. \nleo convallis nulla sodales volutpat porta mi fusce sit velit, facilisis adipiscing quisque felis etiam vestibulum donec curae odio, augue senectus purus maecenas habitasse metus et semper. \nplacerat adipiscing tristique suspendisse arcu auctor scelerisque elit, potenti congue vitae placerat varius et habitasse, inceptos morbi amet tempus justo magna, egestas condimentum in eros ad leo. \n</p>\n<p>\nadipiscing enim mauris cursus elementum orci sem et faucibus massa, placerat commodo ante sed senectus netus auctor malesuada, sagittis dolor id inceptos accumsan vestibulum egestas non. \nelementum donec pulvinar phasellus ad netus fermentum urna conubia, magna praesent aliquam lectus eu diam integer venenatis metus, augue felis venenatis mauris potenti mattis risus. \nvarius platea iaculis consequat purus phasellus praesent id, habitant ultrices ut ornare facilisis ligula amet, mi tortor massa velit eleifend primis. \nneque consectetur aenean tortor class euismod diam consectetur, vestibulum neque etiam curabitur adipiscing ante potenti dui, per dictum iaculis donec curae viverra. \n</p>\n<p>\ntincidunt fusce tempor lacus rutrum praesent neque ligula mi, vulputate tincidunt suspendisse leo egestas dolor aliquet massa neque, elit mollis libero in metus nulla ad. \nvivamus nullam sapien accumsan fames habitant, molestie habitant diam erat, viverra accumsan nostra suspendisse. \nfaucibus mollis massa sociosqu odio mi venenatis class in nibh justo imperdiet nostra phasellus turpis, augue sagittis aliquam sollicitudin aenean duis hac amet commodo cubilia aenean fermentum. \nquisque mattis vehicula aenean ad eu non amet vehicula tristique, senectus fringilla congue viverra vehicula consectetur tortor tellus, porta ultricies ornare aenean id mi porttitor vel. \n</p>\n<p>\nposuere est suscipit magna ultricies erat leo nostra, per urna tristique placerat litora libero non mollis, dolor vestibulum cubilia molestie sit nibh. \nvitae tellus ad blandit tempor purus malesuada lacus, est blandit taciti donec ut curabitur, convallis lorem inceptos pellentesque mattis mi. \negestas netus hac sociosqu nulla inceptos porta sagittis fringilla lacus dolor ac ultrices proin habitant fusce, nisl lobortis gravida rutrum quis diam pulvinar platea aenean vulputate diam torquent sem. \nmassa imperdiet diam praesent ornare arcu eros torquent interdum, senectus molestie dictum sed iaculis tristique faucibus aenean, cursus mattis egestas erat eleifend leo himenaeos. \n</p>\n<p>\ncondimentum nullam ultricies scelerisque lectus curabitur mollis metus nisl senectus eget, sapien metus condimentum phasellus rhoncus enim commodo vulputate vivamus. \n</p>', '{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}', '{gallery}http://www.flickr.com/photos/dance_photographer/sets/72157624625077098{/gallery}', NULL, '', '2013-06-21 12:38:13', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:38:13', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Aenean fringilla quis ultricies ', 'Generated by FillItUp', 'Litora fames condimentum eros diam ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('68', 'Hendrerit tellus egestas venenatis', 'hendrerit-tellus-egestas-venenatis', '38', '1', '<p>cras sociosqu porttitor aenean convallis massa netus taciti dictumst, congue velit cubilia sodales consectetur et ipsum quis curabitur, commodo curabitur eleifend pulvinar lobortis massa dictum. ante duis imperdiet facilisis turpis accumsan class quam ut enim varius habitasse gravida ornare, aliquet varius risus gravida lorem in facilisis taciti sagittis semper accumsan. luctus tortor felis aliquam ullamcorper etiam porttitor non hac curabitur, commodo sociosqu ut hendrerit quisque elementum turpis vestibulum, dolor platea magna eros senectus leo elit condimentum. ligula congue dolor lacinia purus magna hac ad vestibulum, morbi iaculis etiam curabitur primis curabitur aenean dictum, odio dolor quisque per ut quisque laoreet.</p>\r\n', '\r\n<p>pretium sit porttitor taciti morbi suspendisse habitasse lectus torquent pretium, ultricies sem sapien scelerisque nisi malesuada litora. at ullamcorper suspendisse vel class netus justo, donec pellentesque facilisis sit sem et, pretium felis faucibus vulputate varius. dapibus congue platea libero sem mollis placerat rutrum magna aenean adipiscing, risus venenatis senectus cras donec risus sociosqu aptent tellus. donec pellentesque semper lobortis convallis consequat aenean, elementum risus arcu primis praesent, ultrices aliquam fames curae cubilia. pellentesque posuere class elit habitasse vel libero sit lacus bibendum nostra lectus felis, vel cubilia nunc enim mi aliquam orci morbi interdum himenaeos sapien varius, magna cursus praesent molestie varius facilisis ut iaculis tortor scelerisque dictum.</p>\r\n<p>vestibulum erat integer quisque non nisi bibendum sit, eleifend ad quam aenean enim fames, feugiat id varius inceptos class ut. sit praesent pellentesque aenean convallis rhoncus lacus nullam pellentesque quis, lobortis congue aliquet rhoncus ullamcorper suspendisse varius non etiam mauris, lectus cubilia fringilla commodo vehicula mattis egestas neque. quam cubilia duis dictum lacinia amet suscipit mauris aliquet, eleifend rutrum nullam conubia consectetur cras laoreet libero, amet aenean quisque vel facilisis aenean pellentesque. nec feugiat morbi et laoreet nam ultricies fames, nostra egestas curabitur cubilia massa amet sodales pharetra, netus donec mollis mattis libero ornare.</p>\r\n<p>senectus orci nibh mattis ut lacinia fringilla aliquet, est adipiscing varius curae nisi ut, hac a diam rutrum potenti ultricies. odio aenean tempus varius laoreet elementum accumsan etiam viverra interdum cras quisque, himenaeos pharetra condimentum maecenas eleifend bibendum imperdiet luctus a. odio aliquam cubilia donec facilisis scelerisque cras mauris a pretium, blandit habitasse ad maecenas aptent in sapien facilisis condimentum lacus, pulvinar urna porta bibendum tellus ad enim class. turpis curabitur tristique taciti eu duis adipiscing viverra, phasellus velit vitae suscipit tincidunt phasellus accumsan himenaeos, potenti habitasse ut tristique facilisis risus.</p>\r\n<p>magna felis lobortis semper pretium iaculis praesent non euismod per potenti laoreet habitasse turpis, pretium nibh duis dolor congue dolor lectus duis at condimentum tellus aliquam. per accumsan aliquam augue ante justo elit arcu rhoncus leo, sapien leo felis sem nunc eu justo lobortis, erat tortor litora nibh dolor morbi eu torquent. id etiam mattis varius augue semper egestas ullamcorper, quis lectus sollicitudin aliquet laoreet fames nisi, consectetur velit nec a senectus vulputate. molestie sed justo tristique congue sodales consequat massa condimentum suspendisse, adipiscing metus feugiat suspendisse consequat sapien fusce curabitur aenean cubilia, urna sagittis diam neque vehicula rhoncus vehicula vestibulum.</p>\r\n<p>cras urna varius mollis, aenean torquent.</p>', '{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}', '{gallery}http://www.flickr.com/photos/harshlight/sets/72157625091598606{/gallery}', '[]', '', '2013-06-21 12:39:05', '473', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:27:53', '471', '2013-06-21 12:39:05', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Purus volutpat ut accumsan ', 'Generated by FillItUp', 'Porttitor commodo ipsum taciti tincidunt ', 'Generated by FillItUp', '870', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('70', 'Convallis inceptos curae eget fusce', 'convallis-inceptos-curae-eget-fusce', '37', '1', '<p>\nodio at faucibus vitae suscipit convallis aliquet tristique praesent nibh, sodales potenti curabitur commodo ad eleifend lobortis nulla, conubia ullamcorper aenean lobortis facilisis maecenas suscipit ut. \nlitora nostra tempor dictum ipsum rhoncus cras etiam tincidunt hendrerit senectus convallis scelerisque bibendum gravida iaculis, pharetra semper velit conubia blandit est nec litora integer nam eget habitasse congue ipsum. \nlorem commodo felis himenaeos class sagittis etiam facilisis dapibus donec at integer phasellus nam rutrum egestas libero ullamcorper dictumst vehicula, ante convallis mollis dictumst dui eu lorem at taciti eget vivamus rhoncus dictum molestie dictum arcu scelerisque. \n</p>\n<p>\nfames phasellus hac placerat fusce, sodales tortor. \n</p>', '<p>\nmetus per lorem erat senectus massa donec aptent nulla enim cubilia, varius donec tellus sapien etiam potenti iaculis aenean. \nper et nullam eu ullamcorper consectetur nostra ipsum pellentesque fusce orci, vulputate sed tempus cubilia bibendum donec aptent sagittis blandit ornare, eget arcu euismod velit donec lobortis pretium vivamus erat. \nhendrerit primis netus himenaeos phasellus netus velit senectus amet magna imperdiet ad inceptos adipiscing, id ad dictumst vehicula nec hac aliquam faucibus eleifend venenatis nunc integer. \nproin urna tempus praesent maecenas at tempus platea himenaeos, ac est ligula at velit venenatis cursus quis turpis, ullamcorper maecenas molestie suscipit dui rhoncus nunc. \n</p>\n<p>\nhimenaeos pulvinar semper vitae ullamcorper sagittis adipiscing platea pellentesque dictumst inceptos, bibendum suscipit quam phasellus praesent ipsum libero ultrices sit, habitasse nullam condimentum molestie iaculis quisque nunc tortor diam. \nnostra proin ante vehicula donec nostra rutrum nibh, torquent suspendisse tellus tristique sociosqu euismod, eleifend nisi dictum inceptos magna integer. \npellentesque potenti eget hendrerit luctus eleifend donec tristique taciti ad, venenatis condimentum bibendum urna sapien nibh libero auctor nec, donec conubia habitant ac arcu sociosqu vehicula condimentum. \nac integer nisi torquent est ligula ad aliquam erat, semper tempus pulvinar vel aenean congue dolor imperdiet tortor, luctus ac sodales class felis quis blandit. \n</p>\n<p>\nsemper ut justo nam class dictumst diam dictumst sem a, dapibus cras arcu senectus diam nostra tincidunt placerat platea, primis convallis massa vivamus viverra metus nulla nullam. \niaculis ultrices odio nostra class felis metus quam, nullam per ac scelerisque pulvinar sapien, fermentum porttitor mauris quisque aptent porttitor. \nimperdiet nunc massa vehicula lacus felis eu risus dui tristique augue euismod, viverra turpis dui praesent eu nibh massa non suscipit cras, et ullamcorper vel nibh curabitur dapibus condimentum lacus facilisis integer. \nmorbi cras non in ligula vivamus, curabitur pulvinar potenti vitae a porttitor, adipiscing litora proin ante. \n</p>\n<p>\nvarius turpis urna fames phasellus feugiat suscipit ante praesent, hendrerit proin lobortis et nostra porta ut cubilia, nisi rhoncus litora pellentesque augue ligula quam. \nsemper suscipit dolor morbi mauris curabitur posuere sociosqu, aenean eleifend dolor rhoncus euismod nulla litora himenaeos, placerat fames nulla egestas himenaeos ullamcorper. \nhabitant vitae varius etiam scelerisque taciti neque non rhoncus volutpat, class adipiscing dui lacus faucibus libero condimentum et at, varius neque ipsum class cursus netus turpis faucibus. \nvulputate lectus potenti tempus sociosqu ut praesent dui aenean mollis nullam, venenatis mauris vehicula elit auctor vivamus non porttitor eget ad turpis, dictumst iaculis posuere pharetra ad nunc adipiscing nisi at. \n</p>', '{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}', '{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}', NULL, '', '2013-06-21 12:39:30', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:39:30', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Fermentum nisl blandit ', 'Generated by FillItUp', 'Diam fringilla laoreet ac semper mauris ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('71', 'Ante euismod massa in', 'ante-euismod-massa-in', '44', '1', '<p>nulla nisi ad lacus dolor augue nisl cubilia ut varius felis habitant, sapien mauris turpis in vehicula torquent aliquam orci vestibulum est. rutrum sapien nec dapibus conubia felis nibh eleifend vehicula amet, quisque facilisis nulla ante non nam fringilla nulla, ligula inceptos cubilia condimentum sem cras netus vivamus. curabitur ornare dapibus curabitur ut class quisque senectus ut, curae enim pretium quisque proin ligula venenatis taciti augue, ipsum consectetur hac iaculis platea facilisis inceptos. sociosqu pellentesque phasellus sodales lacus sagittis netus aliquet consequat primis, risus lacinia eu tempor et sollicitudin molestie curabitur vitae, feugiat fringilla dictumst mauris euismod sagittis mollis sollicitudin.</p>\r\n', '\r\n<p>sociosqu blandit platea arcu mattis libero rutrum felis sem, senectus in habitant id feugiat malesuada lorem condimentum, porta fames lorem non volutpat metus fusce. eget magna molestie vel fringilla morbi aliquam senectus condimentum cursus donec, ad ultrices magna mi proin litora tortor nec malesuada aptent, duis volutpat pellentesque elementum dolor integer mollis turpis ultrices. et purus etiam conubia dui ut pulvinar, convallis eu duis praesent phasellus, accumsan enim sit porta taciti. quam mauris varius turpis vehicula commodo justo viverra suscipit sociosqu senectus, non inceptos quam lacinia interdum conubia rhoncus et ut in facilisis, adipiscing pulvinar taciti congue accumsan praesent suscipit ut habitant.</p>\r\n<p>mollis suspendisse rhoncus nam arcu habitasse enim, mi eget hendrerit justo sodales lacinia malesuada, pellentesque massa ad nisl molestie. et est suscipit curae magna duis luctus et facilisis, massa porttitor etiam porttitor vel scelerisque ornare interdum litora, donec turpis ipsum viverra orci lectus faucibus. metus ultrices suscipit varius feugiat nibh laoreet molestie scelerisque, a tellus egestas a conubia nam enim, venenatis elit fames leo porta velit lacus. cubilia enim donec orci ultricies aenean morbi magna, conubia velit laoreet egestas vitae libero purus cubilia, conubia ipsum habitant varius curae pharetra.</p>\r\n<p>maecenas rhoncus metus facilisis fames scelerisque rutrum litora ut elementum, curabitur suscipit volutpat enim varius viverra ornare himenaeos felis, aptent maecenas suspendisse ornare bibendum luctus rhoncus convallis. cursus feugiat donec a auctor hac cursus pretium, eleifend inceptos venenatis mauris eget scelerisque, nec suspendisse quis dui nullam facilisis. suspendisse accumsan lobortis vehicula maecenas orci, euismod sagittis fringilla venenatis, phasellus velit proin suscipit. enim curabitur quisque himenaeos quam quis suscipit aptent odio, porttitor fusce eget lacus diam ultricies pellentesque, auctor tempor pretium posuere nostra leo gravida. habitasse et dictum placerat class fringilla curae senectus sed volutpat, euismod taciti habitasse eros semper accumsan ad maecenas euismod, turpis proin habitant viverra scelerisque conubia nisi in.</p>\r\n<p>congue quisque luctus phasellus venenatis ac eu egestas mollis quam primis placerat, id etiam fusce et vel facilisis eleifend molestie placerat velit, odio at maecenas nibh tristique facilisis arcu libero id posuere. dapibus sollicitudin curabitur mi porta mauris netus potenti suspendisse, quisque habitant urna fringilla placerat proin nunc, pulvinar luctus aliquet nec duis senectus pellentesque. tempor diam fermentum senectus rutrum turpis, interdum dictum habitant cubilia, imperdiet iaculis augue sit. duis mattis augue suscipit bibendum taciti fusce orci proin, conubia torquent venenatis hac tellus facilisis amet nostra, augue sit varius per dictum enim ligula.</p>\r\n<p>blandit torquent purus per, mollis.</p>', '{youtube}http://www.youtube.com/watch?v=saMhNUmPaJ4{/youtube}', '{gallery}http://www.flickr.com/photos/9255261@N07/sets/72157605611183371/with/4306905525/{/gallery}', '[]', '', '2013-06-21 12:39:45', '472', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:27:20', '471', '2013-06-21 12:39:45', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Sed litora pulvinar ', 'Generated by FillItUp', 'Suspendisse auctor placerat platea ', 'Generated by FillItUp', '3764', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('73', 'Interdum vitae class malesuada ac', 'interdum-vitae-class-malesuada-ac', '33', '1', '<p>aliquam lorem aenean ac platea lacinia habitant sit elementum molestie ornare rutrum sit, massa venenatis faucibus id tellus nisl luctus eget lectus eleifend. fusce porta arcu nunc accumsan fermentum id ante, aptent sem est quisque donec suscipit pulvinar, etiam tincidunt euismod massa senectus adipiscing. rutrum conubia fames lacinia aliquam risus placerat dapibus accumsan, fringilla at class sodales sapien venenatis tristique duis, placerat ac ultricies etiam porta urna ultrices. litora hendrerit fusce ac fames duis justo leo commodo mollis, non nec morbi orci arcu malesuada orci lacus justo consequat, odio praesent nulla convallis at nisl placerat tellus.</p>\r\n<p>enim proin est, suspendisse.</p>\r\n', '\r\n<p>nisi nam dictum augue eu ornare fusce etiam semper arcu congue ipsum, sed suspendisse vulputate aliquet sociosqu mi sociosqu senectus phasellus senectus augue, mollis gravida habitasse id augue nostra ligula congue aliquam pulvinar. risus sagittis accumsan sollicitudin etiam sit nibh aenean nullam ultrices pellentesque, felis curae torquent pretium ac tristique eu inceptos donec tortor fringilla, eu luctus magna orci luctus habitasse a sit urna. augue euismod eros id fames at fermentum neque cursus, non aliquam habitant primis ac curabitur duis nunc donec, est sagittis ultricies porttitor habitant fermentum nullam.</p>\r\n<p>pulvinar aenean cras dolor fringilla sagittis erat curabitur adipiscing viverra fusce, elementum faucibus ultricies ipsum velit mauris facilisis interdum lectus, class pellentesque dapibus euismod lorem non phasellus nec vehicula. egestas per vivamus velit inceptos ad eu vehicula nulla sociosqu sit urna, ac ullamcorper taciti maecenas orci quisque egestas urna nulla. malesuada porta ad inceptos proin metus ligula tincidunt aenean fusce, donec dictumst egestas sollicitudin consequat venenatis sagittis consequat id, magna velit lacinia ullamcorper non class vestibulum lectus. libero lectus duis aptent volutpat donec eleifend mi sollicitudin eget iaculis, ullamcorper netus dui in leo habitant nec iaculis vestibulum, feugiat arcu tempor sapien curabitur commodo tristique vehicula eget.</p>\r\n<p>pellentesque condimentum tellus inceptos fames taciti molestie nullam iaculis, massa arcu curae suscipit condimentum volutpat tincidunt, tempus facilisis elit varius venenatis odio aliquam. himenaeos libero velit aliquet nisl aliquam fusce commodo suscipit, orci aenean donec taciti curae justo est lectus, vehicula platea mollis a orci quisque ut. proin curae taciti curae neque semper posuere justo metus rutrum dictum tristique lobortis dictumst pulvinar, massa curae lobortis volutpat curae integer cras eget egestas sociosqu facilisis in quisque. velit donec curabitur ullamcorper imperdiet habitasse phasellus lectus cras justo, senectus sed dictum convallis molestie turpis id porta, quisque porta magna rhoncus curae ut felis lacus.</p>\r\n<p>eros nisi curae inceptos venenatis vulputate volutpat nisl hac a tempor, non pharetra convallis habitasse pharetra porta ante ut molestie, urna aenean libero metus luctus consequat pulvinar convallis potenti. tincidunt porta ligula lacinia metus cras, himenaeos erat nam auctor ultrices netus, scelerisque blandit ut inceptos. commodo ante auctor nunc vivamus class viverra lobortis venenatis, habitant viverra porttitor primis aenean cursus congue sodales, aenean tincidunt condimentum felis pretium vestibulum hendrerit. litora aliquet a pellentesque dolor sem adipiscing sed, in facilisis donec himenaeos viverra luctus metus consectetur, tortor purus consectetur consequat nullam euismod scelerisque, lorem cubilia pretium donec ante vivamus.</p>\r\n<p>pretium faucibus elit blandit, eros condimentum.</p>', '{youtube}http://www.youtube.com/watch?v=hzg8ZeQpWVc{/youtube}', '{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}', '[]', '', '2013-06-21 12:40:22', '473', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:27:03', '471', '2013-06-21 12:40:22', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Sem ornare donec taciti erat ', 'Generated by FillItUp', 'Arcu taciti dolor malesuada imperdiet ', 'Generated by FillItUp', '1053', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('77', 'In porttitor auctor nostra', 'in-porttitor-auctor-nostra', '43', '1', '<p>eu facilisis morbi maecenas blandit augue libero convallis, class tempus venenatis fusce inceptos nunc aptent quis, congue nec cursus vestibulum himenaeos placerat. tempor vel justo eu lectus nisl ullamcorper aliquam non feugiat malesuada blandit eu, hac justo faucibus urna dolor sagittis aenean sodales tristique vehicula quisque elementum, pellentesque ullamcorper habitasse et at proin posuere lectus diam habitant vestibulum. consectetur tristique luctus consectetur cursus lacus gravida dictum, sed ullamcorper dolor orci habitasse vitae phasellus vel, cras platea volutpat aenean phasellus lectus. ultricies aenean faucibus at mauris commodo gravida ultrices, quisque fames aenean eros nisi cubilia, aenean malesuada tempus nulla dictumst scelerisque.</p>\r\n', '\r\n<p>malesuada est consectetur tempor vehicula scelerisque tempus vestibulum curae aenean, accumsan nisl iaculis diam quis justo augue proin donec nunc, libero scelerisque pretium ligula nunc primis quisque elementum. lobortis auctor erat fringilla nam varius justo posuere hac fusce, vel lorem molestie phasellus in pellentesque vivamus volutpat at eleifend, sem sociosqu interdum ipsum orci euismod lorem commodo. mi feugiat ipsum mattis hac nostra imperdiet etiam commodo sem netus, hendrerit eget magna tincidunt curabitur sagittis etiam urna laoreet curabitur, vivamus ac varius mollis convallis faucibus consequat proin ad. fames auctor mauris arcu mattis dui malesuada in risus purus, himenaeos lacus sapien etiam cubilia quisque fringilla viverra aliquam, elit erat adipiscing integer vestibulum fames dolor vulputate.</p>\r\n<p>porta pellentesque luctus feugiat neque feugiat venenatis primis tempor massa sollicitudin eu, senectus turpis blandit iaculis aliquam vitae praesent pellentesque lectus non, arcu egestas lacus auctor torquent lectus himenaeos facilisis curabitur cursus. egestas fames potenti suscipit pulvinar cubilia eleifend cubilia sapien malesuada ligula, fusce et ornare in urna nisl urna pharetra torquent taciti, amet nisi posuere rhoncus sodales fusce leo lobortis nunc. eu lorem ante morbi volutpat platea neque iaculis hac, viverra sapien luctus turpis a orci vivamus vulputate, elementum pretium habitasse placerat vestibulum ligula mauris. neque elementum vivamus cubilia semper maecenas nullam scelerisque maecenas blandit nec, aliquam lacus ultricies risus posuere neque vehicula primis amet mollis, nibh auctor non at integer vitae condimentum potenti tincidunt.</p>\r\n<p>vestibulum felis potenti vulputate maecenas condimentum vulputate varius ad fermentum rutrum porttitor neque ligula morbi tincidunt, curabitur senectus eros ullamcorper bibendum erat habitant sapien felis curabitur convallis venenatis primis. massa urna quam rhoncus praesent est tristique eros vivamus venenatis, felis dictumst rutrum tellus suscipit vulputate sem vivamus, dictum sem eros tristique consectetur urna suscipit lobortis. lacinia curabitur nulla molestie adipiscing donec in ut feugiat odio integer nullam, porttitor potenti urna dui iaculis diam himenaeos scelerisque dui convallis, molestie libero faucibus egestas platea duis aliquam justo ornare himenaeos. sagittis mauris lectus tincidunt augue quis non, ipsum ultricies dapibus vivamus diam ac vehicula, viverra accumsan integer duis ultrices suspendisse, etiam non vehicula donec amet.</p>\r\n<p>tempus risus congue eros massa senectus iaculis sagittis, vehicula porttitor eros pretium pulvinar vitae, praesent nostra consectetur at vulputate conubia. dictumst praesent sem class nec id, elit sit vivamus fringilla est risus, accumsan cursus ligula at. maecenas euismod vel fusce neque interdum et mauris elit, a sapien tempus nibh diam risus mattis, venenatis phasellus aliquam egestas lacinia sem eget.</p>', '{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}', '{gallery}http://www.flickr.com/photos/greentable/sets/72157603227466774/with/2720397126/{/gallery}', '[]', '', '2013-06-21 12:41:48', '473', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:26:48', '471', '2013-06-21 12:41:48', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Egestas aenean eleifend accumsan faucibus accumsan ', 'Generated by FillItUp', 'Conubia adipiscing tellus aliquam turpis volutpat ', 'Generated by FillItUp', '2608', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('78', 'Sagittis faucibus dapibus', 'sagittis-faucibus-dapibus', '33', '1', '<p>non tempor magna himenaeos ligula senectus eleifend gravida curabitur bibendum, velit odio himenaeos velit risus eget faucibus rhoncus rutrum, in taciti maecenas cubilia mollis viverra convallis dui. senectus torquent volutpat pellentesque luctus curabitur feugiat libero, morbi fermentum sollicitudin pharetra at quisque pretium volutpat, dapibus nostra hac luctus platea posuere. morbi ad donec senectus mi neque enim aliquet neque nam, nunc fringilla tempor sollicitudin lacus tortor taciti nostra ipsum, sit libero tellus sapien pretium fusce primis urna. molestie senectus sociosqu imperdiet semper lorem aliquet quam facilisis torquent ad donec aptent, senectus hac ligula pellentesque imperdiet senectus massa sit conubia sit purus.</p>\r\n', '\r\n<p>fermentum dictum est quisque feugiat ut ipsum sapien sollicitudin, purus blandit enim accumsan senectus non ut class aliquam, sagittis dictum convallis ipsum nunc augue ullamcorper. nulla sed ut faucibus vivamus euismod sollicitudin aliquam, congue varius habitasse donec augue fames, conubia fusce vehicula etiam hac lobortis. eros felis lacus vehicula ultricies et duis tristique cursus, et ut inceptos aenean eget placerat hac vehicula elit, aliquet adipiscing morbi hac non sagittis vestibulum. semper lorem ut eu a malesuada class, vehicula nisl nibh id rhoncus egestas, morbi lacus primis eros conubia.</p>\r\n<p>convallis iaculis ut id aliquet elit lacus aenean convallis nullam convallis, suspendisse aenean enim morbi dictum facilisis a nulla lacus, commodo tincidunt curae interdum etiam eget odio etiam pellentesque. viverra hendrerit taciti vulputate hac adipiscing congue dolor commodo pulvinar ornare, eget rhoncus velit torquent ac sociosqu pellentesque sed viverra, velit aliquet nibh dapibus praesent at mauris dictumst congue. ante hac in fusce congue non lobortis ullamcorper viverra, habitant potenti ut hac fringilla dictumst nunc, nullam malesuada morbi pharetra vehicula commodo euismod. donec vulputate eleifend molestie torquent luctus posuere dolor, aliquam taciti a torquent ut faucibus eros purus, cursus aptent conubia magna lobortis blandit.</p>\r\n<p>tortor netus class lacinia commodo libero cursus tincidunt eros, imperdiet nullam mi eget etiam lorem euismod nunc, metus neque odio pulvinar tortor nullam fringilla. faucibus praesent morbi massa curabitur eu litora per himenaeos, nam nisl himenaeos conubia consectetur sed. tellus nostra urna vitae sapien nisi praesent eu eleifend dui, placerat congue in donec fringilla faucibus cursus interdum litora feugiat, metus potenti mauris ut ullamcorper curabitur hendrerit leo. gravida aliquam odio ligula fermentum nibh tempor ultricies id commodo metus proin sed, nunc platea odio phasellus pulvinar fringilla nisi morbi risus quisque.</p>\r\n<p>himenaeos gravida quis dui consectetur vel sed sociosqu nisl bibendum, tortor vehicula vitae himenaeos proin suspendisse dapibus amet justo class, interdum nec sociosqu quis convallis scelerisque class a. venenatis ornare vulputate purus leo ullamcorper velit pretium, conubia donec rhoncus auctor ante aptent lacinia pulvinar, phasellus molestie primis erat sem condimentum. vestibulum ad nostra lectus vestibulum per duis dolor, volutpat sit tortor pellentesque facilisis aenean, litora class augue tellus maecenas quam. class ac metus platea ultricies cras pharetra, facilisis netus phasellus etiam iaculis euismod conubia, suspendisse pellentesque platea odio sapien.</p>\r\n<p>turpis dapibus nibh est felis volutpat turpis neque duis conubia rhoncus, elementum lectus curabitur hendrerit ligula tempor vestibulum aptent habitasse viverra, semper sodales donec auctor conubia justo nisl hendrerit ut.</p>', '{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}', '{gallery}http://www.flickr.com/photos/cottonblue/sets/72157604378940701/with/3207798737/{/gallery}', '[]', '', '2013-06-21 12:42:00', '473', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:25:49', '471', '2013-06-21 12:42:00', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Aenean euismod class dictumst lacus bibendum ', 'Generated by FillItUp', 'Aptent mollis curabitur habitant ', 'Generated by FillItUp', '814', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('79', 'Diam a placerat non', 'diam-a-placerat-non', '45', '1', '<p>imperdiet senectus quam ad curae aptent justo aenean per curabitur porta, vehicula sociosqu tristique tempus taciti suspendisse sociosqu turpis scelerisque ultrices, curabitur eleifend morbi aptent diam erat in urna libero. volutpat porta etiam platea sodales bibendum sodales rhoncus, himenaeos suspendisse litora placerat augue sapien, facilisis bibendum porta pellentesque netus turpis. risus pulvinar posuere sit sollicitudin aptent lorem netus molestie quisque, aliquet sed aenean rutrum senectus fermentum tellus quam ut molestie, suscipit quisque neque curabitur vestibulum venenatis in rutrum. luctus aenean venenatis mollis tellus torquent ac auctor, tellus ut quam non nullam mauris rutrum himenaeos, eros curabitur nunc vulputate taciti fames.</p>\r\n', '\r\n<p>faucibus porttitor nisl egestas pharetra accumsan ut vitae habitant nostra, ad aenean potenti etiam sodales senectus orci blandit tellus, fames in libero venenatis mollis posuere lacinia nisl. est laoreet nibh nostra ultrices auctor ipsum aptent interdum pellentesque lectus, arcu mattis nibh nisl accumsan diam imperdiet sapien auctor condimentum, sociosqu elementum nibh blandit potenti rhoncus pretium dictumst volutpat. ligula porttitor viverra inceptos urna aliquam cubilia donec nisl ligula ut ullamcorper, vel tempus nisl fermentum ultrices leo sapien egestas conubia quisque, proin morbi auctor donec auctor enim quisque eu enim tortor.</p>\r\n<p>eleifend id phasellus sapien mattis aptent non metus molestie neque nullam inceptos, dictum fringilla consequat dolor sem phasellus elementum torquent nostra ultrices, sit mollis lobortis nibh aenean egestas vitae curabitur vestibulum aptent. quisque commodo erat interdum quisque venenatis donec dui molestie feugiat, aliquam cubilia aliquam eget hendrerit blandit nunc ut vehicula, porttitor curae vivamus viverra class aenean curabitur et. sed eros pharetra lectus platea facilisis dictumst adipiscing aptent habitasse, conubia porta hendrerit aenean aptent elementum fringilla cursus sagittis, justo nisl pellentesque arcu etiam consectetur proin aliquam. fermentum iaculis donec hac sodales gravida, rutrum aenean quam pulvinar.</p>\r\n<p>faucibus erat vivamus bibendum duis convallis mattis platea semper condimentum duis habitasse, velit libero fringilla dolor netus ornare elit sit quisque. sapien aptent tincidunt laoreet tincidunt egestas velit lectus lacus sapien ornare congue dolor, aliquet tellus duis malesuada tristique nulla vulputate mattis leo egestas lacus facilisis felis, fames netus luctus cubilia rutrum porttitor sapien luctus egestas molestie erat. justo porttitor pellentesque porta mollis sem donec senectus, eu pharetra nullam venenatis sed porttitor suspendisse ut, eget neque quis et in habitasse. primis velit hendrerit feugiat sed vestibulum, facilisis leo vestibulum platea vestibulum vitae, ornare porttitor fringilla auctor.</p>\r\n<p>habitasse hac duis luctus velit mi suscipit primis ut facilisis consectetur et hendrerit commodo interdum, sit vel commodo vehicula libero taciti sed euismod ornare lobortis conubia mi urna. ultricies blandit lacus eu viverra phasellus taciti quisque, lacus ultricies hac lorem facilisis lacinia metus aenean, cubilia blandit non viverra eros tortor. taciti ornare integer quam ullamcorper hendrerit facilisis vivamus eleifend, accumsan ornare vitae cras varius feugiat ligula, vulputate pulvinar morbi aenean pulvinar sit aenean. odio quisque pulvinar adipiscing aliquam nulla aliquam etiam curae viverra imperdiet, mattis curabitur velit vulputate a ad dictumst etiam tristique, praesent sagittis quis netus interdum odio inceptos molestie ornare.</p>\r\n<p>tellus ut vel semper sit bibendum vehicula eros vulputate dui, dictum nisi tortor leo metus risus bibendum.</p>', '{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}', '{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}', '[]', '', '2013-06-21 12:42:12', '472', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:28:30', '471', '2013-06-21 12:42:12', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Hendrerit erat semper ', 'Generated by FillItUp', 'Integer massa fames ', 'Generated by FillItUp', '927', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('80', 'Vivamus aliquet ac morbi sit pellentesque', 'vivamus-aliquet-ac-morbi-sit-pellentesque', '40', '1', '<p>\nsenectus a est quisque a commodo nibh tristique rhoncus aptent habitant, congue magna sagittis commodo class nisl laoreet morbi quis tempor viverra, sapien eros urna habitant proin porta tristique diam viverra. \ndictumst ornare a commodo varius etiam sociosqu hac inceptos, sit fermentum fames integer faucibus malesuada erat leo, vitae mollis litora aliquet ad sociosqu inceptos. \ncurabitur est vel curabitur conubia curae posuere sed tempus facilisis lorem, nisl nunc sapien amet tortor faucibus proin integer risus in himenaeos, mauris egestas consequat fusce nullam in pulvinar integer fames. \nlibero malesuada donec imperdiet auctor vitae mattis non, donec porttitor nulla purus phasellus euismod. \n</p>', '<p>\nnam nulla tempus quisque arcu quisque varius nisi, purus lorem praesent ultrices felis elementum, egestas massa orci tempor egestas ultricies. \nbibendum fames facilisis nullam torquent potenti dolor augue integer fames netus dui amet, habitant est erat diam eget vehicula imperdiet euismod etiam placerat. \naliquam condimentum ullamcorper nulla diam amet habitant venenatis aliquam nisi, mi egestas facilisis dolor mattis habitasse ut et rhoncus ut, condimentum senectus ultrices nunc risus augue commodo sagittis. \nhendrerit urna dui diam nulla a quisque eget aenean habitasse, at elementum neque auctor semper netus ullamcorper cras per, porta mauris accumsan potenti nisi phasellus potenti volutpat. \n</p>\n<p>\nultrices metus per ultricies interdum fames nisi non quam sagittis, amet quis at imperdiet et interdum senectus ultricies sit, elit imperdiet praesent per integer etiam senectus aliquam. \ntorquent bibendum nullam mattis nisl mattis, convallis luctus egestas platea porttitor, adipiscing lorem morbi varius. \nlitora et fringilla augue quis adipiscing eleifend sit non velit orci, ligula auctor aliquam etiam conubia curabitur est nec erat morbi, auctor et non praesent tristique mattis in porttitor eros. \nnulla eleifend venenatis libero velit convallis orci molestie ultricies, eget quisque sodales mi facilisis nam quis urna, enim inceptos porttitor hendrerit enim venenatis platea. \n</p>\n<p>\nvulputate at viverra ut pellentesque ultrices bibendum quisque facilisis enim morbi aliquam arcu a bibendum, vulputate nunc orci enim consectetur diam conubia litora pretium lacinia congue dolor. \nsenectus conubia morbi quisque ut facilisis, cubilia volutpat magna pellentesque vivamus ultrices, non blandit in congue. \nlectus magna arcu fusce cursus velit tellus justo leo fermentum, convallis litora fringilla lacus aliquet lacinia euismod nunc viverra egestas, inceptos semper in ac cras id nisi tellus. \ncurae vivamus nec porta tellus etiam class habitasse condimentum, posuere aenean orci donec dictumst consectetur libero vulputate enim, proin litora torquent sociosqu tristique elementum morbi. \n</p>\n<p>\nmassa sociosqu porta pellentesque bibendum ut nostra sit senectus condimentum, eros urna aliquet vivamus varius platea odio et, tincidunt torquent iaculis taciti augue commodo id habitant. \ndictumst mauris ut dapibus in consectetur massa fusce arcu leo, luctus neque risus sollicitudin vulputate per blandit venenatis fermentum bibendum, etiam tincidunt felis erat arcu amet est elit. \npotenti placerat inceptos platea ultrices elit bibendum ultrices eu, ligula eget senectus aenean volutpat class volutpat. \nat mollis dictum sollicitudin primis praesent vivamus, nisl ultrices cursus ornare aliquam ullamcorper est, hendrerit cursus accumsan donec integer turpis, arcu proin lectus torquent mi. \n</p>\n<p>\nplatea ac eros fermentum sed euismod arcu tincidunt rhoncus, habitasse in elit turpis nisi iaculis. \n</p>', '{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}', NULL, '', '2013-06-21 12:42:24', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:42:24', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Nunc eget curae leo ', 'Generated by FillItUp', 'Vestibulum curabitur purus elit ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('82', 'Consectetur feugiat eget risus', 'consectetur-feugiat-eget-risus', '33', '1', '<p>nisl praesent iaculis quam proin libero velit vehicula nulla sociosqu viverra placerat torquent, et proin ullamcorper at sollicitudin molestie iaculis ac tellus imperdiet. diam id velit conubia commodo luctus sapien aenean per ipsum, mollis curabitur nullam quisque justo aenean rhoncus orci mauris eget, mattis eu gravida nunc condimentum quisque mauris volutpat. pharetra sollicitudin potenti rutrum pellentesque inceptos conubia lectus massa cras elit imperdiet taciti urna, vestibulum lacinia potenti ad imperdiet interdum integer nullam ornare cubilia sit fermentum. convallis malesuada sem ut torquent vulputate iaculis aliquam tristique, quisque feugiat pulvinar molestie non semper sagittis, duis odio sed volutpat molestie tempus conubia.</p>\r\n', '\r\n<p>curae sed hendrerit consequat lectus amet in, elementum scelerisque commodo maecenas tellus vivamus convallis, conubia quisque aliquet suspendisse leo. convallis viverra lacinia suspendisse at ultricies diam luctus, dolor ullamcorper rhoncus fames mattis consequat mattis, pellentesque quam ligula enim condimentum scelerisque. lacinia euismod eros dui quisque curabitur vitae malesuada cubilia tempus habitasse, platea congue dolor mattis aliquet leo curabitur vitae. consectetur aenean dui donec morbi senectus maecenas vestibulum libero, volutpat nisl odio porta vulputate aliquam per nullam, dolor dapibus dictum consectetur curabitur tempor euismod. blandit in gravida risus varius fames lacus cras conubia amet, nec gravida sit nec class egestas vitae pulvinar, ac quisque blandit elementum convallis nam felis donec.</p>\r\n<p>pharetra maecenas purus pulvinar cursus class quisque duis dolor per gravida, ipsum consequat ut neque ultricies viverra ultrices a quam id, non facilisis sapien platea etiam enim mauris mollis donec. vitae eu dictumst fames odio ornare urna, proin justo sapien hendrerit sagittis proin pharetra, pellentesque sit odio velit cras. conubia placerat sem etiam turpis magna nec eget cursus, torquent quis aliquam sagittis taciti per habitasse sagittis libero, felis per nam torquent scelerisque nostra aenean. sit inceptos magna malesuada sem est porttitor, hac lacinia risus pellentesque sapien suscipit porta, ultrices id accumsan tellus aenean.</p>\r\n<p>congue augue porttitor sodales tincidunt quam morbi mauris torquent semper sociosqu, pharetra venenatis quisque arcu aptent urna luctus elit at, tellus pharetra posuere elit platea eget ut amet leo. donec nisl quis mi sapien porta curae sit sollicitudin, pulvinar dapibus pretium ut eu dictum et, velit tincidunt eleifend risus euismod nostra laoreet. elit varius ac turpis elementum faucibus gravida tortor dapibus habitant eleifend ad augue, vestibulum ut ullamcorper nostra tempor risus potenti massa augue potenti id suscipit fermentum, non aliquam rhoncus aenean fusce in leo sociosqu class non platea.</p>\r\n<p>turpis ut at conubia curabitur scelerisque tempor commodo condimentum viverra, nostra magna ante iaculis vivamus id sollicitudin vel cubilia, cursus vestibulum etiam imperdiet neque eleifend dapibus tristique. curabitur vitae sollicitudin aenean eleifend urna aenean maecenas habitant libero fames, odio aliquam suspendisse consectetur sodales nec interdum tempor class, inceptos aenean tortor condimentum urna sagittis platea quam pulvinar. eros aliquam diam ut accumsan et tortor pharetra urna, ut primis dictumst sociosqu luctus eros phasellus, viverra posuere tortor est dolor nec aptent. quisque inceptos id nulla massa luctus adipiscing, scelerisque hac pretium potenti vitae per, donec vulputate netus bibendum lobortis.</p>\r\n<p>hac sodales aenean tortor egestas neque nunc, lectus litora fames aliquam iaculis.</p>', '{youtube}http://www.youtube.com/watch?v=hzg8ZeQpWVc{/youtube}', '{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}', '[]', '', '2013-06-21 12:42:47', '472', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:25:23', '471', '2013-06-21 12:42:47', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', 'Phasellus magna quis massa ', 'Generated by FillItUp', 'Molestie pharetra tortor in tempor sem ', 'Generated by FillItUp', '857', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('85', 'Sed litora massa nulla', 'sed-litora-massa-nulla', '40', '1', '<p>\npulvinar blandit orci ac pellentesque fames platea odio per nullam consequat, tincidunt enim nullam sit aenean dapibus metus varius turpis vestibulum, congue varius lectus egestas urna fermentum taciti dui eu. \nhac convallis maecenas hendrerit orci ut sed egestas massa ut scelerisque pellentesque, cursus tristique egestas vivamus ornare etiam class id urna facilisis. \ninterdum etiam eros pretium hendrerit etiam purus commodo maecenas elementum ad, nunc aptent himenaeos praesent habitasse ut taciti mauris cubilia ad, elit enim habitant curae ad accumsan praesent porta ligula. \ncurae mattis amet at inceptos orci habitasse hendrerit fermentum commodo, tempus potenti neque ornare leo senectus gravida sed. \n</p>', '<p>\nturpis nec aliquam facilisis rhoncus morbi diam interdum, facilisis proin pellentesque donec cubilia morbi venenatis adipiscing, per lectus himenaeos lacinia ad non. \nsagittis ipsum a nullam aliquam habitasse iaculis sociosqu nullam per vestibulum pretium, augue pulvinar hac netus sit duis luctus bibendum scelerisque lacinia. \npretium accumsan eu fusce proin lacinia nullam sapien quisque, libero augue magna donec class mauris lectus, fames nunc rhoncus sapien taciti aenean metus. \nnunc lacus rhoncus sem vel est placerat risus et neque etiam, duis blandit et ligula molestie potenti elementum quam senectus sodales, fames id scelerisque dictumst sagittis eget hendrerit sagittis dapibus. \n</p>\n<p>\negestas elementum sed duis aenean habitant netus arcu sapien dui euismod taciti inceptos tortor hac, vulputate dapibus ante interdum dapibus platea nisl cubilia senectus pharetra per praesent. \narcu dui pretium malesuada ultrices suscipit ligula senectus per lectus, pulvinar curae luctus curae libero pellentesque sollicitudin rutrum molestie nisl, maecenas fermentum mollis arcu posuere ultricies molestie auctor. \nmorbi vitae taciti quisque tincidunt ac venenatis sed, non viverra mauris praesent est vitae etiam, tristique ut elit aliquam quis nunc. \ncurabitur tincidunt curabitur eleifend primis sed primis lectus condimentum cursus rutrum, curae pretium vestibulum lacinia nec aliquam praesent vivamus nisi, aenean praesent purus a ligula morbi adipiscing hac purus. \n</p>\n<p>\nrisus dolor gravida duis ipsum mi mollis taciti nostra hendrerit, netus cursus aliquam bibendum semper nulla quis libero. \nullamcorper gravida platea scelerisque fringilla facilisis, nostra massa nunc a luctus, lectus interdum dictum lacinia. \nclass auctor faucibus congue gravida nisi semper mollis vehicula conubia neque nunc posuere, nunc himenaeos at fermentum donec sed amet tempor potenti leo. \nnetus conubia litora quisque turpis nec a adipiscing suspendisse dictumst, sed interdum nunc ipsum litora semper sem etiam, tincidunt sed ante euismod leo lacus hendrerit urna. \nfames adipiscing class velit ut pharetra odio, litora integer nostra iaculis amet, lacus velit auctor donec ac. \n</p>\n<p>\nconvallis torquent enim conubia dui enim euismod donec, mollis nisl dolor fusce lobortis elit leo interdum, duis consectetur tortor posuere orci himenaeos. \nac consectetur ligula tempus dapibus aliquet sodales faucibus bibendum eros nam, ante odio tellus donec ultrices augue maecenas nullam vestibulum, nisi est litora ac quam nisi aenean dictumst nisl. \nsenectus curabitur accumsan varius feugiat sed odio vulputate taciti fringilla, sociosqu hac nam placerat tempor turpis quis sed, scelerisque rhoncus porttitor sollicitudin per aliquet lorem sem. \ncubilia habitant vehicula molestie rhoncus consectetur varius duis, odio eu nulla sodales facilisis taciti habitasse tortor, suspendisse etiam nibh porttitor euismod adipiscing. \n</p>', '{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-06-21 12:43:31', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:43:31', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Lectus tempor bibendum primis laoreet ', 'Generated by FillItUp', 'Sed metus inceptos a praesent ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('86', 'Viverra varius dictumst vel himenaeos dictum', 'viverra-varius-dictumst-vel-himenaeos-dictum', '32', '1', '<p>\naliquam neque volutpat donec ut primis accumsan quisque senectus cursus tortor, in etiam ligula potenti consectetur convallis aenean felis accumsan, felis vitae torquent dapibus vestibulum aenean donec curabitur velit. \nin vivamus luctus habitant curae dictumst sed sodales, nibh mi feugiat consequat aliquam non, fames cras integer etiam facilisis feugiat. \nlectus integer vivamus luctus venenatis ultricies morbi viverra proin diam vitae, ut diam mauris facilisis rutrum dolor aenean maecenas volutpat litora, quisque quam vehicula magna justo torquent praesent mauris integer. \nvehicula class vehicula etiam hendrerit vehicula himenaeos pretium, vestibulum molestie fermentum quisque bibendum fames id, sit ante mollis habitasse odio torquent. \n</p>', '<p>\nconubia pretium porta mauris senectus cursus nostra tincidunt ultricies convallis, iaculis ante sodales egestas est hendrerit mattis cras rutrum, platea fermentum hendrerit odio a auctor tellus lacus. \nauctor per dolor morbi donec nostra amet ac nostra elit ut posuere odio, pellentesque posuere faucibus lobortis iaculis fusce fames habitasse varius molestie etiam urna, sollicitudin lobortis a mattis aliquam erat nisl ultricies dui vel id. \nblandit ornare vitae duis taciti porttitor fusce, molestie nec lorem taciti porta torquent vestibulum, etiam nisl aliquet eleifend hac. \npulvinar faucibus congue lacinia urna felis eros augue nullam ut, sollicitudin nibh velit tempus urna egestas nullam habitant, porta donec quis lacinia semper quam ornare volutpat. \n</p>\n<p>\nphasellus sagittis rhoncus aenean felis ipsum diam turpis sociosqu, porttitor interdum netus nibh non accumsan lectus habitant rhoncus, porttitor lacinia fermentum tincidunt maecenas a phasellus. \nmauris ante pulvinar nulla interdum enim pharetra senectus ut vitae nisl phasellus, blandit aenean nibh fermentum aptent elementum pulvinar quisque ligula. \nquis lorem dolor fermentum ultrices lobortis laoreet, sagittis ante libero etiam himenaeos potenti, elementum ipsum hac tortor potenti. \nante etiam torquent libero fames etiam tincidunt porttitor magna curabitur, proin class tincidunt mauris ad maecenas facilisis. \nhabitant tortor sit facilisis primis purus nulla est quisque, quis adipiscing scelerisque ante fringilla convallis orci felis porttitor, eu scelerisque per et habitant ad nisi. \n</p>\n<p>\nnibh facilisis lacinia sapien porta nam senectus curabitur aliquet inceptos volutpat sed, dictum non purus massa ante tellus sociosqu euismod suscipit sem. \nimperdiet ornare lorem congue leo eleifend enim ut habitant aliquam turpis phasellus, lobortis taciti suscipit odio pretium adipiscing praesent tortor morbi sodales porta, tempus hac pretium blandit sem tellus facilisis mollis orci mattis. \nvolutpat malesuada euismod gravida auctor senectus leo integer tempor inceptos hendrerit, cursus tristique viverra cubilia primis phasellus blandit bibendum condimentum aliquam donec, pulvinar ligula congue fermentum pharetra consectetur ornare sapien inceptos. \nvolutpat curabitur fermentum per etiam eleifend leo donec vulputate, consequat aptent eros ac amet interdum curabitur, vulputate sollicitudin magna est platea orci netus. \n</p>\n<p>\nligula himenaeos potenti rhoncus vitae aptent taciti pellentesque aenean mattis facilisis sem proin elementum, justo cursus est vivamus molestie sapien eu lobortis cursus netus molestie. \nporta aliquam viverra praesent morbi suscipit dui ligula imperdiet aptent laoreet rutrum arcu, ligula nisl euismod justo sem hendrerit consequat maecenas quisque porttitor mollis nam, fringilla integer tempor mollis pretium cubilia duis hac primis conubia at. \nlectus tempor enim dictumst curabitur nostra et mollis dictum, curabitur pellentesque lobortis malesuada habitant lacus consectetur. \n</p>', '{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-06-21 12:44:02', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:44:02', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Senectus odio nibh odio ligula ', 'Generated by FillItUp', 'Etiam vestibulum congue ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('88', 'Conubia eleifend magna sagittis', 'conubia-eleifend-magna-sagittis', '34', '1', '<p>euismod sagittis felis sollicitudin tortor et inceptos consequat lectus elementum, in vehicula pharetra hendrerit proin pulvinar mi. tempor nostra aliquet ornare lacinia netus laoreet proin eu malesuada, feugiat aenean sit massa mattis aliquam nibh hac, elementum massa a eu etiam tellus quam tempus. nec vehicula ut ultrices condimentum ornare est pellentesque luctus condimentum convallis litora nullam purus volutpat, in nisl in convallis velit molestie elementum rutrum eros arcu fermentum ultrices. velit pellentesque molestie nulla sed amet nam semper fermentum maecenas auctor, at pellentesque auctor fusce urna scelerisque nibh elit dapibus aliquam, vulputate dictumst inceptos cursus amet urna orci semper pretium.</p>\r\n', '\r\n<p>nunc egestas purus eget sodales mollis, augue himenaeos egestas ultricies primis posuere, hendrerit cras dui habitant. auctor vestibulum nisi aliquet tortor etiam bibendum venenatis, tempor euismod facilisis praesent condimentum tortor at diam, rutrum commodo ipsum non porttitor at. dictumst volutpat nostra vitae sit cubilia in lectus suscipit, fusce mattis ut metus varius elementum fermentum volutpat nulla, eleifend ad ante potenti sit habitant dictumst. cursus donec metus in ante praesent aliquet laoreet, nam hac odio habitant semper risus fames, fringilla aliquet donec ultrices tempus libero. placerat hendrerit imperdiet a dictum fringilla vitae in justo tellus, ut eleifend lacinia felis sollicitudin quisque cubilia ante pharetra dolor, arcu per velit condimentum risus cras elit platea.</p>\r\n<p>inceptos vel eget malesuada nunc justo lectus ante eget nam, nulla etiam quis sociosqu lectus hendrerit tempus tempor, id senectus consectetur dapibus himenaeos maecenas nam nec. etiam pretium integer ultrices molestie risus taciti cubilia et feugiat cubilia rhoncus bibendum risus tempor hendrerit curabitur, magna sem bibendum urna proin quisque tristique scelerisque class a curabitur amet neque vehicula. dui justo maecenas inceptos tincidunt curae sodales suscipit a, dolor turpis ultrices a consectetur sociosqu neque, tincidunt netus cursus congue dolor dictum curabitur. amet ad cursus bibendum vitae vulputate lorem libero nam auctor dapibus odio nec dictum habitasse leo, sit torquent blandit bibendum commodo neque integer himenaeos ipsum posuere rutrum class laoreet.</p>\r\n<p>odio lectus ultricies fermentum feugiat sodales donec leo netus pulvinar, mattis inceptos proin risus turpis imperdiet aptent posuere, taciti eu semper gravida viverra donec per iaculis. ligula rhoncus condimentum cras phasellus senectus libero suscipit enim ultrices tristique vel auctor, torquent rutrum cras nullam sem hendrerit mi fringilla lacinia lacus sem, morbi turpis eleifend tellus quis interdum sociosqu ultrices faucibus pharetra tellus. habitasse etiam donec sit ad commodo quis curabitur amet pretium hac, placerat consequat dolor curae sagittis est nulla eu imperdiet, aenean mi curabitur dolor pharetra nullam tortor aenean dapibus.</p>\r\n<p>feugiat integer inceptos integer accumsan imperdiet habitant, cras massa ultrices duis quis augue a, erat quam pretium porta ipsum. sodales eleifend consequat nulla mi maecenas auctor ultricies, molestie etiam congue dictumst mauris porta malesuada, arcu sit pharetra eu iaculis quis. non bibendum ac integer eget rutrum cras purus dictumst, pharetra enim lacinia vivamus nullam duis lobortis odio, aptent malesuada sit ipsum pulvinar class auctor. lacinia lectus cras neque morbi consectetur non metus lorem, auctor eget ligula molestie dolor sem class nibh etiam, venenatis morbi potenti dui consequat condimentum blandit.</p>', '{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}', '{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}', '[]', '', '2013-06-21 12:44:34', '473', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:25:03', '471', '2013-06-21 12:44:34', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Neque imperdiet bibendum consequat ', 'Generated by FillItUp', 'Phasellus erat torquent suspendisse tempor curabitur ', 'Generated by FillItUp', '1064', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('89', 'Non per ad habitant massa', 'non-per-ad-habitant-massa', '37', '1', '<p>\nurna nec scelerisque conubia magna mi, egestas conubia tempus non conubia sodales, sagittis platea phasellus elementum. \ntortor non neque ipsum lobortis accumsan imperdiet non aliquam lacus sapien, nullam aenean nunc sapien auctor diam ac enim. \nurna nec viverra facilisis sagittis vitae eros ligula taciti habitasse, mauris neque vel lacinia ad inceptos sem facilisis malesuada habitant, mauris nunc torquent lorem nostra maecenas quisque imperdiet. \nconsequat eu torquent malesuada non ut donec a dictumst rhoncus commodo, est sollicitudin lacus erat duis sed eros leo metus. \net nullam erat auctor metus neque ut a suspendisse aliquam, massa facilisis suscipit elit suspendisse enim nulla. \n</p>', '<p>\nprimis consectetur eros proin fusce euismod non scelerisque aliquam accumsan aliquam feugiat, orci diam et dictumst amet posuere arcu nulla amet dolor. \nluctus in maecenas fringilla tristique tempus vitae neque mattis orci risus, scelerisque tincidunt pretium odio pellentesque diam nisi suscipit aenean, sociosqu taciti lectus vulputate ut lorem per faucibus aenean. \naliquam metus etiam libero duis proin mollis eros elit, purus nec erat sodales etiam vestibulum semper donec pellentesque, tincidunt maecenas fames scelerisque vel nullam vestibulum. \nmetus per dapibus litora eu imperdiet primis potenti lacus, cras eleifend donec id duis nullam iaculis himenaeos nulla, porta ullamcorper pulvinar feugiat molestie conubia ullamcorper. \n</p>\n<p>\ndiam varius ante tellus facilisis posuere fusce vivamus himenaeos libero, pellentesque per ad elit malesuada sit potenti pretium ullamcorper sit, praesent dictum praesent euismod augue ac cubilia ultrices. \nposuere consectetur ornare pretium aenean in etiam class neque cursus elit hendrerit, convallis amet vestibulum ullamcorper nam aliquet rutrum egestas sit senectus congue nec, cursus curabitur conubia euismod quis integer malesuada enim vitae porta. \norci dui purus per placerat, tristique ut sollicitudin nullam, aliquet aliquam consequat. \nvel iaculis suspendisse velit conubia habitant volutpat etiam, mauris netus at nunc quis velit, varius elementum id accumsan tellus nisi. \n</p>\n<p>\nfusce magna pellentesque phasellus iaculis a congue duis taciti blandit sociosqu libero, massa id sapien integer egestas class lacus mollis luctus morbi, eros taciti posuere eleifend primis vulputate quam lorem nullam dictumst. \naenean mauris lobortis etiam rhoncus sollicitudin aenean fringilla eget, purus volutpat phasellus aliquet imperdiet litora orci metus mauris, aliquet in conubia ullamcorper sociosqu id proin. \nnisi id eleifend litora ac torquent purus ac cras aenean, accumsan pulvinar magna egestas himenaeos vitae nibh pretium nisl libero, sollicitudin odio ornare class ac feugiat elementum habitant. \nrutrum feugiat rutrum senectus per mollis, eu nostra aenean vivamus tincidunt, ligula mi interdum fermentum. \n</p>\n<p>\nscelerisque donec mi dapibus porttitor eros felis inceptos diam vehicula, etiam eu vivamus diam mattis ac fames volutpat congue, tristique viverra mollis felis conubia bibendum etiam rhoncus. \nmorbi dui orci at lacinia hendrerit at quisque accumsan euismod, erat mollis varius netus at elit nisi faucibus torquent, tortor non senectus fusce sem imperdiet libero iaculis. \nnulla etiam massa tempor urna congue adipiscing facilisis consequat suscipit etiam eros donec blandit dictumst blandit per class, porta mattis primis ullamcorper mattis justo tristique hendrerit vehicula consectetur sapien nisi curabitur arcu diam. \nquisque ultricies egestas netus vehicula leo litora sit elit mollis, justo phasellus est a luctus convallis placerat ultrices. \n</p>', '{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}', '{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}', NULL, '', '2013-06-21 12:44:55', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:44:55', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Donec vel tristique semper metus magna ', 'Generated by FillItUp', 'Tempor ut netus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('90', 'Fermentum eget hendrerit pellentesque', 'fermentum-eget-hendrerit-pellentesque', '32', '1', '<p>\nrhoncus ipsum aliquet lacinia dapibus vitae accumsan massa netus risus, volutpat condimentum tempus sem imperdiet auctor cras ante nisi donec, sapien ut sem imperdiet eros placerat phasellus vehicula. \nconvallis scelerisque ante lorem malesuada molestie arcu aptent sed duis pulvinar, tellus scelerisque hendrerit viverra conubia sed auctor in tristique massa, vulputate dictumst ut neque dictumst phasellus eleifend molestie sit. \nnulla suspendisse commodo bibendum luctus diam class egestas, fames platea nullam eleifend tristique mollis magna sit, purus feugiat non curabitur feugiat rutrum. \nvenenatis elementum nullam id tellus platea faucibus libero, faucibus ornare luctus cras tristique vehicula, sapien congue at curae suspendisse potenti. \n</p>', '<p>\nauctor sapien aenean donec dictumst lorem inceptos, mauris dictumst eleifend cursus accumsan ut, eu bibendum tortor lectus justo. \ntorquent ac hac dictum ultrices turpis nam lobortis euismod, id libero sodales malesuada inceptos phasellus erat dictum, elementum eros iaculis sociosqu mauris class felis. \na pharetra eu sit curabitur integer a mauris habitasse, ornare tempus congue ante aptent sodales a, turpis vulputate curabitur cras blandit litora at. \ntristique leo quisque hendrerit ornare habitant aptent aenean potenti neque tortor, pulvinar risus orci elementum pharetra tincidunt etiam gravida molestie, interdum felis enim velit hac ipsum ornare metus quis. \n</p>\n<p>\ndui donec dolor sodales class fusce justo nullam, non inceptos urna netus dictumst molestie sed, elit leo magna facilisis lobortis senectus. \nelementum vel risus eget egestas malesuada massa pretium quis aliquam sem, eros aptent aliquam nibh ullamcorper gravida fusce aenean posuere cursus, habitant taciti orci turpis sagittis eget sit senectus lorem. \nipsum aliquam vivamus ornare sem nisl leo class justo, himenaeos volutpat venenatis id vivamus urna consequat habitasse, senectus pharetra euismod inceptos velit etiam venenatis. \nneque sed odio eros platea ac etiam egestas nulla sagittis, aliquam nisl cras volutpat vehicula viverra ut amet, molestie dapibus felis commodo cursus fermentum orci nostra. \n</p>\n<p>\neros tincidunt ut diam nisl ad iaculis nulla rhoncus vitae, magna convallis euismod maecenas curabitur suscipit fermentum vehicula, potenti consectetur vehicula mauris mi curabitur convallis torquent. \nquis inceptos nec conubia urna habitasse consectetur lectus, accumsan porta inceptos metus ornare sagittis a porta, ligula vehicula volutpat aliquam primis quisque. \ninceptos justo elementum pulvinar sollicitudin vehicula nisl euismod laoreet augue vestibulum, vel quisque feugiat litora rhoncus enim conubia nisi aenean, ac lobortis platea nullam suspendisse ac iaculis malesuada proin. \netiam aptent tortor ultricies est sapien nunc sagittis placerat, habitasse ligula vel nostra iaculis placerat aliquam, sociosqu ipsum faucibus fringilla risus tellus imperdiet. \n</p>\n<p>\nvarius eu pellentesque gravida dictum placerat morbi orci venenatis turpis, commodo mattis at laoreet nisl sociosqu non tincidunt, lorem nulla arcu nisl sapien aptent vulputate consectetur. \niaculis adipiscing velit rutrum purus est tristique lectus, id justo mi curabitur congue adipiscing, taciti aliquet duis etiam augue aliquam. \nlacus amet proin nibh aenean et tristique lacus id senectus platea, turpis dapibus habitant at consequat eget libero nisl ornare varius, dolor cubilia phasellus egestas metus purus turpis nibh et. \ndonec felis eu et at litora posuere venenatis vehicula accumsan ligula nullam, semper curae suspendisse dictumst pellentesque curae venenatis congue inceptos. \n</p>\n<p>\narcu rutrum aptent habitant, nisl sodales, lorem convallis. \n</p>', '{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-06-21 12:45:18', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:45:18', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', 'Etiam himenaeos odio aptent venenatis ', 'Generated by FillItUp', 'Malesuada libero lacus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('91', 'Ligula id nunc libero risus', 'ligula-id-nunc-libero-risus', '38', '1', '<p>porta nibh nisi accumsan taciti urna id cras phasellus habitant laoreet fermentum ante nam ipsum, venenatis dui facilisis himenaeos tristique ultrices fermentum non quisque rhoncus ultricies habitasse. lacus proin lorem ante neque luctus sollicitudin odio ad imperdiet aliquam adipiscing, elementum cursus inceptos suspendisse metus rutrum et cubilia viverra feugiat, odio habitant inceptos enim tempus ac tellus lectus luctus tristique. fames metus nunc sagittis nisl tortor turpis dictum eros vivamus, potenti aenean gravida aptent ullamcorper venenatis tempus ultrices vivamus varius, pulvinar ad odio orci vivamus posuere nec semper. justo viverra pretium ornare donec, nostra vestibulum eleifend mauris interdum, integer conubia maecenas.</p>\r\n', '\r\n<p>risus quis semper vivamus augue feugiat suscipit sed blandit cursus viverra aptent placerat platea eu pretium purus per augue massa, mollis diam sem gravida vehicula aenean curabitur maecenas congue dictum gravida sit etiam ullamcorper quam ad facilisis lectus. accumsan sagittis class sapien dictum taciti arcu ultricies lacus, velit convallis platea vehicula placerat sit varius fringilla lorem, sem praesent vehicula tortor turpis inceptos mauris. curabitur sapien tellus varius torquent aliquam per tempor, aptent curae pretium a mattis congue, eros pharetra nec dictum cras amet. hac massa blandit quis ante est, lacinia etiam turpis in volutpat sem, justo inceptos rhoncus ultricies.</p>\r\n<p>massa nibh lectus curae netus platea senectus varius habitant sociosqu justo vulputate, semper vehicula magna et ut pretium mi diam aenean fusce, auctor potenti euismod suspendisse vivamus nulla praesent consequat mattis bibendum. dictumst aptent duis et fermentum metus curabitur interdum odio, duis erat vestibulum himenaeos nisl semper dictumst turpis, fringilla at primis arcu sollicitudin tortor vestibulum. metus fames luctus consequat posuere curabitur bibendum quisque, tortor ac est magna ullamcorper sollicitudin, dolor maecenas lectus ligula imperdiet cras. tristique dolor lacinia tincidunt ultricies mattis massa tincidunt vulputate habitant id commodo posuere, dictumst scelerisque ipsum nisl curabitur vehicula aptent duis aptent habitasse id, sociosqu rutrum quisque non senectus eu id quisque aliquet auctor risus.</p>\r\n<p>litora tellus vel id class aliquam mollis diam, vulputate elementum velit at fringilla sociosqu taciti, urna curabitur odio molestie rutrum etiam. auctor et sapien enim nec et pulvinar blandit sapien ipsum euismod integer porta lacinia, porttitor litora id mollis congue curabitur quis luctus viverra rhoncus taciti. tellus aliquam ligula dictum blandit a elit venenatis convallis justo dictum cursus, et non egestas a metus accumsan blandit nibh consequat platea. lectus ullamcorper enim cras sapien nec neque porttitor neque velit sit, sagittis risus semper vestibulum proin nisi sed vel pharetra curae, purus vehicula quam conubia tellus posuere odio erat lacus.</p>\r\n<p>magna tellus lobortis aptent dictum eget, pulvinar dui lacinia iaculis pharetra, eget enim mattis vestibulum. ligula condimentum sagittis rhoncus class ligula dapibus volutpat et, pulvinar urna praesent proin fusce blandit id, sapien hendrerit aenean lacinia in lacinia lectus. mollis placerat aliquam facilisis orci litora tellus taciti euismod nunc aliquet, conubia quisque duis mollis congue dui purus odio volutpat dapibus, mattis etiam congue hendrerit potenti lectus class tristique porttitor. congue faucibus purus mattis ullamcorper aptent ultrices cursus hac, quisque varius donec sagittis rhoncus velit pretium cubilia, tellus interdum ultricies nullam eu magna sapien.</p>', '{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}', '{gallery}http://www.flickr.com/photos/photos-de-danyel/sets/72157623234681159/with/4333369054/{/gallery}', '[]', '', '2013-06-21 12:45:52', '473', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:26:52', '471', '2013-06-21 12:45:52', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Iaculis duis ut netus lectus fermentum ', 'Generated by FillItUp', 'Posuere scelerisque fames non ipsum ', 'Generated by FillItUp', '897', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('94', 'Non inceptos magna', 'non-inceptos-magna', '44', '1', '<p>vitae morbi mollis pharetra interdum venenatis varius sed inceptos nibh, erat ante cubilia ultrices urna taciti tempor facilisis, massa ultricies tristique feugiat eleifend ligula lorem molestie. primis neque facilisis scelerisque ullamcorper ut consequat id turpis elementum, sed a ornare porta tellus posuere orci commodo ultrices ultricies, erat vulputate a quam eu suspendisse fermentum turpis. massa venenatis nam facilisis in per dolor, non interdum ullamcorper convallis potenti, nibh sociosqu metus duis praesent. mollis ultricies cursus eros metus odio elementum magna neque, elementum quisque conubia vestibulum faucibus massa pellentesque, sociosqu nisl faucibus cubilia hendrerit porta aenean.</p>\r\n<p>ultricies tristique donec nunc, aliquam potenti.</p>\r\n', '\r\n<p>malesuada scelerisque posuere tellus netus curabitur himenaeos aenean, tempor quis pellentesque maecenas faucibus sagittis amet, sem aliquam habitant fringilla lacus augue. litora gravida fames quisque diam suscipit blandit porta ipsum, ornare suscipit ut conubia ac feugiat molestie pretium turpis, sed fusce eget eleifend ante dictumst netus. neque sociosqu porttitor lacus placerat tristique ipsum at ac conubia, ut ornare feugiat auctor ut quisque etiam habitant, scelerisque metus pretium odio arcu convallis fusce varius. et morbi inceptos amet himenaeos torquent pretium sodales sit aliquam dolor, luctus risus porttitor porta quisque enim lorem blandit commodo, facilisis rutrum vel lectus amet augue netus risus nullam.</p>\r\n<p>semper venenatis sodales in ligula scelerisque accumsan interdum habitant, dapibus fermentum elementum massa nisl mollis porta habitasse, est fermentum aenean enim gravida himenaeos curabitur. mi tempus volutpat lobortis diam sem habitant at morbi aptent, diam curabitur fusce neque varius tempus sed commodo, congue pretium quis lectus facilisis egestas dui augue. et leo ad mattis nisi proin, sagittis maecenas feugiat massa quisque elit, cursus aenean per sapien. pulvinar etiam auctor cubilia nunc feugiat turpis conubia lectus conubia, ut cursus laoreet at eget velit porttitor molestie, pharetra massa blandit tempus bibendum sollicitudin habitasse sed.</p>\r\n<p>congue ad id placerat ligula gravida luctus ut odio fusce dictum ad, fusce ut tellus hendrerit libero congue ultricies rhoncus lorem integer, aenean curabitur vel vitae ullamcorper odio suspendisse fringilla ultricies ullamcorper. interdum commodo cursus senectus lobortis ullamcorper nec at vivamus proin aptent, potenti fringilla porta donec justo velit nunc blandit purus praesent, feugiat tristique hac ut consequat dui mauris auctor dui. curabitur amet donec et sapien tellus aliquet ante, velit lectus varius cras dictum turpis, ut nibh eu netus suspendisse sociosqu. non maecenas suscipit erat faucibus luctus quis dictumst viverra, donec sociosqu varius est eu commodo dui, etiam euismod aenean litora praesent pharetra habitasse.</p>\r\n<p>nullam hac sociosqu proin fusce auctor id sed in gravida vitae at, sem nulla convallis netus ipsum non luctus aliquam aenean metus, pretium curabitur vestibulum duis luctus commodo venenatis sodales morbi nibh. auctor aliquet quisque senectus elit volutpat augue bibendum vivamus in aliquam, porttitor arcu ac tellus ante pulvinar nam magna ipsum feugiat aenean, elementum tristique suspendisse cubilia erat sit odio lacus eget. ornare nulla sem ut molestie vehicula eget, justo nisi aenean justo sed purus scelerisque, ipsum aenean et nulla habitasse ipsum, odio ornare interdum placerat rhoncus.</p>\r\n<p>rutrum netus ad platea congue interdum aptent turpis, quam cursus posuere placerat elit potenti.</p>', '{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}', '{gallery}http://www.flickr.com/photos/9255261@N07/sets/72157605611183371/with/4306905525/{/gallery}', '[]', '', '2013-06-21 12:46:53', '472', '', '0', '0000-00-00 00:00:00', '2013-07-03 10:24:46', '471', '2013-06-21 12:46:53', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', 'Consequat faucibus magna lorem ', 'Generated by FillItUp', 'Viverra sed est ante conubia ', 'Generated by FillItUp', '3133', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('96', 'Molestie senectus accumsan tempus', 'molestie-senectus-accumsan-tempus', '30', '1', '<p>velit ornare quisque suscipit sociosqu litora nostra etiam condimentum felis eu sem egestas a, orci felis conubia viverra cras aliquet fringilla eros rhoncus leo nisi sodales. rutrum elementum varius scelerisque urna ipsum tellus sed lacinia rhoncus duis congue pretium, etiam nostra ornare pretium proin fames cras eros vestibulum gravida. fringilla ligula fusce orci tristique faucibus bibendum suscipit dolor litora condimentum amet morbi, ante elementum elit sociosqu velit vel orci lectus tristique class. bibendum imperdiet hac mi suspendisse suscipit phasellus gravida metus maecenas, justo etiam posuere sed pellentesque velit elementum rutrum sem lectus, hac posuere lectus sagittis accumsan consequat eros aenean.</p>\r\n', '\r\n<p>primis dapibus lorem nec fusce conubia litora magna auctor, ornare conubia suscipit eros pharetra quis cras nunc, nullam pharetra curabitur dui elit euismod ultrices. sit phasellus ut tellus fames felis erat pretium condimentum venenatis, a tempor ut etiam aliquam taciti mi at, adipiscing massa erat neque sociosqu proin placerat tincidunt. est nibh vulputate sagittis amet risus libero senectus diam sem at cras curae egestas lacinia, lacus imperdiet pellentesque fermentum pulvinar fermentum semper facilisis conubia quam a eget. dictumst imperdiet lorem urna enim cubilia dolor, interdum himenaeos enim condimentum nulla aliquet sagittis, primis interdum sit donec eros.</p>\r\n<p>congue maecenas lacus porta ultrices curabitur suspendisse ligula, pellentesque habitant himenaeos donec urna pellentesque, bibendum curabitur cursus euismod volutpat ipsum. etiam sociosqu ultrices tellus taciti nisi integer tincidunt lectus egestas, metus accumsan sollicitudin class cras vestibulum mollis a, id aenean vitae dolor semper ultricies egestas mi. sociosqu iaculis dictumst nisi pellentesque nisi ante id ornare vivamus tempor, feugiat justo tempus in lobortis suspendisse orci facilisis convallis elementum euismod, mauris aliquet nullam at tempor proin integer quisque curae. suspendisse himenaeos lobortis posuere hendrerit etiam torquent ad class dolor netus pulvinar, lacinia purus lectus non sem ut eleifend lobortis cubilia tincidunt, fermentum tellus curabitur neque hac torquent fusce justo donec sodales.</p>\r\n<p>sagittis erat tortor lorem curae est mollis class imperdiet per ultricies vestibulum, porttitor eu dictum inceptos per suscipit lacus placerat ad massa. ut viverra id a rutrum fermentum congue eu sollicitudin, ac lobortis dapibus curabitur dictumst taciti hendrerit phasellus, non porta netus donec nostra luctus sodales. vehicula mollis erat dictum interdum velit primis tempus, ante curae aptent eleifend hac tempus et quam, aenean quisque tellus id placerat nunc. sed morbi dictumst suspendisse condimentum tempus volutpat quisque tempor, eleifend congue dolor quis phasellus sociosqu placerat quisque, dapibus libero lectus metus praesent imperdiet sapien varius, habitasse proin mi erat et varius diam.</p>\r\n<p>vitae in aenean amet nulla tincidunt quisque, massa venenatis facilisis imperdiet cursus platea, praesent nunc proin neque ad. laoreet velit habitant feugiat bibendum maecenas amet libero fusce fames augue morbi, nisl molestie inceptos condimentum commodo justo ipsum pretium dolor. litora condimentum interdum erat faucibus velit orci netus fames tincidunt, primis id varius metus litora sagittis donec tincidunt iaculis ad, cubilia varius cubilia gravida class suspendisse etiam laoreet. tortor malesuada felis sit elementum quam adipiscing auctor elementum velit, pellentesque consectetur odio metus elementum commodo proin netus sit ad, adipiscing aenean erat volutpat massa sagittis velit ad.</p>', '{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}', '{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}', '[{\"id\":\"1\",\"value\":\"\"}]', ' ', '2013-06-21 12:47:16', '471', '', '0', '0000-00-00 00:00:00', '2013-07-11 11:58:32', '471', '2013-06-21 12:47:16', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Sollicitudin laoreet nostra morbi odio ', 'Generated by FillItUp', 'A netus mollis ', 'Generated by FillItUp', '4', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('97', 'Nec ornare lorem vivamus tellus dapibus', 'nec-ornare-lorem-vivamus-tellus-dapibus', '32', '1', '<p>\neuismod rutrum nullam blandit dictumst nisi elementum nisi consequat ultrices ut luctus habitasse, enim accumsan duis donec class eros fringilla suscipit feugiat lorem feugiat, lacinia vestibulum fusce magna ligula litora ut neque mauris vitae at. \nvivamus donec morbi phasellus eleifend donec mi turpis, imperdiet felis metus nostra id ipsum, ultricies tincidunt vel mi convallis pharetra. \nvolutpat taciti urna condimentum laoreet vehicula quis ultricies odio vulputate arcu cubilia orci libero ut sagittis, curabitur aptent nec pretium consequat at felis porttitor ornare senectus urna consequat porttitor adipiscing. \ndonec litora tellus litora proin aenean, quis dapibus bibendum consectetur mi, condimentum elementum nostra orci. \n</p>', '<p>\ncubilia volutpat rhoncus lacinia amet habitant porta curae laoreet fames, gravida quam aenean fusce vitae sit taciti suscipit viverra, platea laoreet lacinia interdum molestie metus diam morbi. \nlorem proin consectetur vulputate etiam euismod nulla tortor cubilia platea convallis dui nec phasellus, eleifend felis lobortis nulla enim semper platea habitant luctus nec curabitur lorem. \nsemper non semper non id integer phasellus euismod vulputate sociosqu id tellus ut interdum, tristique mi laoreet lacus luctus faucibus senectus venenatis erat praesent senectus. \nadipiscing sociosqu platea molestie ultrices pretium at posuere ad posuere accumsan, nullam facilisis nam aliquam faucibus tellus lacinia aenean consectetur bibendum, magna pharetra sollicitudin commodo posuere et cubilia vivamus vehicula. \n</p>\n<p>\norci erat sem nisl malesuada at platea auctor, cras auctor donec ut consequat scelerisque molestie, ornare tempus cursus accumsan a convallis. \ncondimentum eget arcu ornare magna egestas gravida sollicitudin ante sodales quisque ut, augue eu etiam scelerisque dolor fames nulla ullamcorper et. \nnostra ultrices justo nibh rutrum purus nec ut dictumst vivamus consectetur, per quisque metus ipsum integer cubilia magna luctus mollis, nostra odio felis nec erat class primis scelerisque tellus. \nmattis sem curabitur id ut praesent malesuada metus eget tempor, vulputate fermentum inceptos etiam volutpat ullamcorper ipsum metus vitae, sem donec nibh amet ultrices accumsan ligula per. \n</p>\n<p>\nturpis luctus praesent quam primis eget id phasellus luctus, vitae a vehicula fringilla platea molestie quisque, class praesent id nisl conubia ligula inceptos. \nhendrerit nec habitant pulvinar class cras cubilia quisque aliquam habitant, augue nam magna ipsum auctor fringilla consectetur praesent, inceptos arcu conubia lacus euismod vel dapibus porta. \nconvallis a semper nec mollis rhoncus, ligula vel convallis urna suspendisse ac, ornare tortor justo habitant. \nrisus turpis duis dui dictumst aliquam nec, nam nostra aenean mollis ipsum pretium dolor, sagittis facilisis convallis cras enim. \ncondimentum porta aliquet iaculis curabitur orci aptent taciti ultricies donec nulla, amet platea rhoncus donec vel at pretium dictumst ut, enim imperdiet sit lacus sapien aptent molestie urna risus. \n</p>\n<p>\nsagittis congue primis lorem fringilla vel taciti ipsum amet curabitur tincidunt, sed ligula nunc class ultrices vestibulum varius aptent consequat, cras dictumst volutpat eleifend phasellus lacus vulputate mi hendrerit. \nleo suscipit molestie metus odio placerat libero per aptent porta dictum, sagittis torquent lacinia integer sagittis interdum eget erat accumsan, malesuada bibendum sodales inceptos pellentesque nisl platea enim blandit. \nturpis mauris integer quisque mattis sagittis pretium metus ultrices, donec etiam ultricies ut pretium quisque ac, interdum fermentum semper habitasse quisque elit non. \n</p>', '{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-06-21 12:47:28', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:47:28', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', 'Duis erat potenti odio auctor fringilla ', 'Generated by FillItUp', 'Platea cras pretium aenean curabitur per ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('99', 'Lacinia eros per suspendisse nec', 'lacinia-eros-per-suspendisse-nec', '37', '1', '<p>\njusto senectus ultricies aliquam dictum quisque fames scelerisque porttitor sagittis, ad amet cursus donec ultricies tempor aenean dolor a platea, aenean sodales eu aliquam posuere est mauris primis. \norci sapien pellentesque lectus interdum non laoreet rhoncus hendrerit, sem euismod semper porta nullam placerat fusce lobortis, curae metus leo bibendum nulla ipsum inceptos. \nplatea libero suscipit hendrerit eu pretium, urna blandit pretium leo proin quisque, ac feugiat pretium maecenas. \nvestibulum sagittis nullam suspendisse quisque tellus vivamus netus felis hendrerit convallis phasellus, sagittis accumsan himenaeos vivamus habitant curae feugiat odio metus eros, commodo eros vivamus dapibus viverra faucibus justo magna potenti et. \n</p>', '<p>\nquisque turpis volutpat integer auctor risus ullamcorper mollis mauris, dictumst neque felis eu quisque nunc orci faucibus lacus, vehicula tempor commodo proin mattis mi bibendum. \nadipiscing porttitor lacinia lorem justo augue neque nulla curabitur, augue iaculis vivamus dui tortor ultricies vivamus leo felis, himenaeos sodales tempus proin sagittis iaculis massa. \nconubia ad quis curabitur egestas pellentesque eu, id tempor tortor non pharetra congue nibh, ornare neque fusce ultrices viverra. \nmorbi faucibus rutrum arcu praesent lectus non ultrices nisi, platea eget quisque aliquet euismod mattis quis potenti, sodales rhoncus etiam mauris accumsan mattis curae. \n</p>\n<p>\ngravida tincidunt curabitur risus hac tempor donec phasellus etiam odio integer, placerat habitasse tincidunt sapien sed donec molestie placerat integer rutrum, vitae bibendum integer vitae feugiat metus sollicitudin enim auctor. \nvenenatis bibendum quisque habitant aliquam malesuada praesent purus semper feugiat, dictum ultrices tortor dui mollis libero sodales sed senectus, risus eu ac auctor viverra vel nulla mattis. \naliquam mauris egestas dolor integer ut ac enim, quisque nisl suscipit volutpat habitant elementum quis, ante vehicula ipsum nam euismod lorem. \nrhoncus praesent egestas vehicula donec nunc feugiat velit ac lacinia, ultrices vulputate scelerisque sem condimentum ut accumsan etiam himenaeos, volutpat donec sapien nullam per ullamcorper tristique dictum. \n</p>\n<p>\nneque varius dictum ante amet lacinia fames aenean id faucibus potenti, id at nostra tempus quisque iaculis libero donec sem, euismod primis vestibulum eros laoreet pharetra non aliquet dictum. \nlorem senectus sollicitudin scelerisque aenean class ultricies amet gravida egestas, ligula pharetra habitasse aenean vivamus convallis eu lorem pharetra, quis vivamus erat eu ligula suspendisse risus lorem. \nelementum euismod orci ipsum sem massa tempor sem augue aliquam, nunc tincidunt litora proin laoreet tortor fermentum senectus augue, ut aliquam at primis inceptos senectus consequat fringilla. \nbibendum cubilia tortor magna integer sapien imperdiet elit dictumst proin integer curae netus aenean, arcu nam mollis fringilla sit scelerisque quisque curae lacus curae phasellus. \n</p>\n<p>\nvarius himenaeos integer scelerisque placerat tincidunt ut non vivamus, bibendum taciti praesent proin augue donec himenaeos taciti elit, a blandit lectus condimentum pulvinar habitant platea. \neuismod scelerisque aptent nibh platea tempus orci duis aptent ante, facilisis nam enim vitae platea pretium conubia vitae sapien tellus, magna per integer pharetra suscipit eu consectetur nam. \nnon ut ad convallis neque dictumst magna sed congue dolor curabitur, litora ut lacus non nisi a feugiat elementum habitasse enim habitant, himenaeos eget scelerisque vestibulum iaculis augue molestie fermentum aliquet. \nvehicula dui et neque risus in, curae nibh feugiat at. \n</p>', '{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}', '{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}', NULL, '', '2013-06-21 12:48:02', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:48:02', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Rhoncus commodo mattis nunc ', 'Generated by FillItUp', 'Auctor et cubilia ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('100', 'Enim donec commodo fermentum id ut', 'enim-donec-commodo-fermentum-id-ut', '37', '1', '<p>\ncurabitur cursus ipsum ut primis tellus faucibus sollicitudin, tempor cras rutrum turpis a ad dapibus risus, laoreet lacinia integer venenatis lectus torquent. \nvestibulum duis suscipit interdum pharetra dapibus justo nulla ac duis convallis turpis maecenas faucibus cras massa himenaeos, dapibus scelerisque ad turpis arcu id dapibus aenean felis arcu litora vestibulum tincidunt lectus lacus. \nultrices nec justo taciti quisque tristique porttitor per viverra nulla odio, sed molestie metus platea vitae vestibulum est hac conubia egestas, eleifend ad ante elementum aptent mattis pretium proin consectetur. \nauctor aenean pharetra vitae morbi convallis, mi integer non posuere maecenas ac, dictumst nam potenti feugiat. \n</p>', '<p>\nmolestie eget mollis viverra dui nostra ut quam neque, euismod tellus accumsan habitasse primis dolor interdum ullamcorper, elit senectus sem feugiat mi risus nec. \nelementum molestie sem tempus nec etiam sodales accumsan sociosqu senectus, primis semper vehicula integer feugiat malesuada dapibus tempus, lacus viverra donec netus donec porta posuere curabitur. \ndictumst ultrices turpis nisl purus morbi porta bibendum lacus eget primis, sollicitudin tempus nam etiam aptent suscipit proin sapien litora torquent, ligula aliquam lorem arcu consequat volutpat sociosqu per iaculis. \nquisque vitae taciti tortor ullamcorper praesent aliquet, habitant suscipit curabitur dui eleifend diam enim, mi dui lorem inceptos turpis rhoncus, elementum malesuada aenean vulputate habitant. \n</p>\n<p>\ntincidunt sagittis molestie senectus sollicitudin sapien tempus auctor eleifend euismod varius odio nam aliquam, feugiat augue lacinia libero suscipit etiam luctus cursus iaculis vestibulum nisi mauris. \ntristique interdum metus aenean habitasse venenatis massa nunc sociosqu, cras volutpat sed turpis quis class. \nhabitasse quam turpis eleifend risus aptent congue iaculis integer, nisl rhoncus feugiat scelerisque curae lobortis suscipit donec, platea aliquet tortor sodales varius molestie elit. \nsuscipit tempor massa ultricies sit sed pellentesque quam cursus, augue volutpat ultrices lorem etiam taciti laoreet ornare, vehicula etiam nunc augue blandit sociosqu purus. \n</p>\n<p>\nquis bibendum eleifend diam fringilla scelerisque urna scelerisque ornare dapibus nisl sodales risus, pulvinar a himenaeos gravida luctus sagittis eu lobortis ligula varius malesuada. \netiam lobortis donec morbi ultrices interdum iaculis nam ullamcorper, nunc augue ultricies hendrerit aliquet fringilla dui ullamcorper, eget imperdiet felis platea non pharetra duis. \nconvallis senectus velit tristique vitae cras nulla urna tempor, augue litora velit semper lorem placerat accumsan curae gravida, sapien duis ac mauris morbi iaculis interdum. \nper ante leo ac et purus eleifend fusce fames primis nunc aenean viverra lobortis nulla, primis consectetur pretium suspendisse est aliquam varius neque ultricies litora ullamcorper lacinia. \n</p>\n<p>\ndolor tellus aptent netus fermentum magna sollicitudin quisque, vel pellentesque in dolor netus. \nsuspendisse pretium consectetur erat ut nisi gravida tempus, nunc porta ante molestie diam dictumst quis ligula, nulla cras nunc blandit molestie suspendisse. \nsed tempor ligula fusce orci mollis potenti duis, euismod nec hendrerit luctus at viverra arcu curabitur, commodo curae posuere commodo aptent tellus. \nrhoncus turpis inceptos turpis lacus morbi sollicitudin felis venenatis ac, nisi vulputate congue morbi mattis ornare maecenas ornare aliquam himenaeos, integer aliquam donec tempus odio vivamus accumsan tortor. \npraesent ut felis conubia quis odio feugiat nam lorem quam conubia congue, dolor netus dolor integer pulvinar ultrices eget ultrices lorem. \n</p>', '{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}', '{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}', NULL, '', '2013-06-21 12:48:15', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:48:15', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', 'Erat non sagittis ', 'Generated by FillItUp', 'Nulla bibendum netus primis curae ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('101', 'Curae nisi praesent nisl', 'curae-nisi-praesent-nisl', '43', '1', '<p>habitant scelerisque elementum placerat aptent condimentum phasellus ac pulvinar facilisis fames elit praesent donec velit, porta condimentum enim metus tristique bibendum himenaeos a nunc interdum himenaeos habitant. litora eleifend sodales luctus ut suscipit laoreet vestibulum, netus donec aliquam ad himenaeos sodales nulla fringilla, praesent nibh iaculis phasellus donec velit. commodo iaculis nunc condimentum id non orci consequat ac, placerat aenean metus ipsum pulvinar praesent purus, bibendum augue tortor pretium eros arcu pellentesque. fringilla inceptos est ad neque nam tellus aptent ultricies laoreet risus id accumsan placerat consectetur, semper quisque himenaeos etiam dui in mattis elementum etiam habitant enim luctus class.</p>\r\n', '\r\n<p>sociosqu justo quis dapibus venenatis augue aliquam per habitant, nulla amet torquent etiam mollis platea molestie morbi, nibh orci placerat justo feugiat id amet. habitasse netus dui purus et dictumst metus nec integer laoreet malesuada, aenean ut quam duis eu amet justo aliquam pulvinar, massa sed lectus aenean cursus phasellus curae molestie nulla. nostra vestibulum vulputate potenti sed donec class risus turpis, aenean gravida quam fringilla ante potenti aliquam etiam id, volutpat maecenas scelerisque feugiat nostra odio eget. porttitor dictumst metus ut fermentum nec integer gravida eu, vitae risus fames dui vestibulum ante aliquet, commodo suspendisse consequat conubia habitasse consectetur ut.</p>\r\n<p>sagittis eu eros pharetra ut nullam lacinia euismod sollicitudin fermentum tristique vitae duis, lectus himenaeos donec non duis cubilia vitae mauris ac urna libero, aliquam ullamcorper netus potenti aptent erat viverra hendrerit curabitur aliquet ultricies. a ipsum cursus aenean pharetra hendrerit proin purus morbi, inceptos eu euismod proin magna blandit nibh, aliquam senectus egestas bibendum ligula amet venenatis. semper nunc pretium accumsan semper eros malesuada cras elementum dapibus, mi quis etiam integer donec metus sociosqu diam vivamus pharetra, sapien torquent sollicitudin nisl varius aliquet sollicitudin porttitor. mattis condimentum gravida suscipit gravida tempor curabitur sit, ultrices consectetur hendrerit neque quis nullam, aliquet orci leo ipsum tortor sagittis.</p>\r\n<p>per vehicula pellentesque quam feugiat eros, condimentum cras et integer viverra dui, congue varius suscipit est. accumsan posuere ut quisque tristique nibh ornare id venenatis, ipsum ante accumsan est scelerisque magna at netus, proin orci ad posuere fermentum inceptos malesuada. ad proin suscipit nisl mi orci ipsum ultricies diam, odio dictumst dui quam nullam senectus cras feugiat lacinia, vitae erat sit sodales duis eget vehicula. vitae viverra venenatis felis aenean etiam magna posuere congue, interdum fermentum posuere torquent elementum lacus purus faucibus pulvinar, etiam enim dui tincidunt sollicitudin venenatis litora.</p>\r\n<p>nostra donec dui in litora cras a netus ac venenatis egestas semper posuere, blandit consectetur ullamcorper tristique maecenas pretium auctor suscipit posuere vitae. purus habitasse metus libero neque augue mauris vehicula ipsum nibh, vulputate blandit sodales feugiat elementum nec morbi suscipit sociosqu, a aliquam cursus semper pharetra augue id suscipit. tempor auctor quam phasellus egestas nibh luctus suscipit semper quisque, quam urna nibh varius ornare est integer lectus, ullamcorper magna sodales auctor diam sagittis urna commodo. netus molestie fusce tempor libero aliquam elementum diam mollis quam tellus habitant, per semper lacus blandit nostra egestas molestie neque eget.</p>\r\n<p>nostra phasellus quisque vehicula, purus ac.</p>', '{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}', '', '[]', '', '2013-06-21 12:48:27', '472', '', '0', '0000-00-00 00:00:00', '2013-07-23 12:07:45', '471', '2013-06-21 12:48:27', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Per aenean mauris sagittis tincidunt ', 'Generated by FillItUp', 'Lacinia inceptos fusce mi ad augue ', 'Generated by FillItUp', '2710', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('103', 'Justo ullamcorper pharetra donec', 'justo-ullamcorper-pharetra-donec', '40', '1', '<p>\ncurabitur massa himenaeos blandit in nisi laoreet non vehicula, risus varius faucibus aptent adipiscing conubia lacus. \nporttitor vivamus lobortis donec curabitur tortor pellentesque eros etiam suscipit fringilla, non diam hac nunc volutpat posuere nullam vitae ultricies, eget adipiscing egestas eleifend quisque porttitor hac aenean vulputate. \netiam quisque accumsan auctor cursus proin nullam dictumst integer conubia magna primis, sem congue primis metus fames mi imperdiet in porta turpis, donec etiam quis magna risus curabitur at conubia pellentesque pretium. \nlibero risus eleifend blandit ultrices quis luctus nisi sagittis, mattis orci suspendisse arcu elementum massa dui, felis platea amet condimentum ut orci lacinia. \n</p>', '<p>\nturpis enim erat etiam adipiscing duis magna curae convallis, quisque enim imperdiet arcu tempus etiam cubilia accumsan, curae accumsan at in sit potenti iaculis. \nbibendum dictum aenean praesent aliquam commodo cursus nisi malesuada, faucibus vulputate porta taciti tristique fermentum etiam, morbi scelerisque curabitur risus eu congue placerat senectus, convallis tincidunt habitant quis etiam eros. \net nisi praesent molestie dapibus suspendisse mauris sed conubia elit urna aliquet, praesent lorem facilisis malesuada ac arcu viverra non etiam donec bibendum, curabitur duis etiam lacinia maecenas amet aliquet condimentum lacus ipsum. \nmi mauris amet porta posuere habitasse senectus aenean consequat eget consectetur, dapibus morbi porta sed aenean aliquam molestie integer ad, non pulvinar litora ante imperdiet lectus tempus gravida ultricies. \n</p>\n<p>\nerat praesent hendrerit conubia sagittis cursus auctor inceptos commodo proin risus, rutrum fusce ante tempor leo dapibus habitasse neque dui. \nporttitor suscipit eget dictum fringilla sodales potenti ut metus netus ut aptent ut orci netus class sit, adipiscing taciti sagittis dui etiam ullamcorper tristique lorem semper velit rutrum amet laoreet ac dapibus. \nultrices gravida scelerisque urna potenti ligula est suscipit platea, ullamcorper ante posuere tincidunt phasellus velit magna, ornare mauris class ipsum tristique morbi dolor. \nnisl himenaeos quis mollis nam libero hendrerit malesuada hendrerit, elit fringilla pretium praesent pellentesque curae dui. \n</p>\n<p>\niaculis libero egestas ac interdum ante pretium ante, eros at curae risus ultricies massa, torquent nullam dictum morbi neque ad. \nvelit imperdiet sed orci class sem vitae a in hendrerit, orci hac scelerisque tortor curae lectus proin in posuere, libero in ultrices per aliquam posuere aliquam rutrum. \npharetra torquent aenean dui aliquet fringilla mauris urna, nunc aliquam congue dolor tellus bibendum, vitae non massa id habitant dui. \nmagna urna blandit etiam vel pulvinar rutrum sociosqu nisl mauris luctus nam proin phasellus non, vitae rhoncus tellus neque feugiat sagittis mollis proin nunc himenaeos torquent eget. \n</p>\n<p>\nturpis commodo posuere fermentum odio volutpat senectus hendrerit tortor dui, eros enim convallis posuere cubilia tristique phasellus at, neque aptent primis pellentesque elit cursus facilisis hendrerit. \nquam enim euismod commodo donec proin varius scelerisque aenean per nisl, sem habitasse lobortis pulvinar ultrices mollis sagittis felis pulvinar, ut cursus torquent erat malesuada ligula auctor commodo habitasse. \nhendrerit gravida volutpat in conubia lacus condimentum quis adipiscing, tempor iaculis nam mattis augue auctor tempus consequat, urna tellus nibh vulputate gravida ornare orci. \nmagna cursus tempor quisque lorem libero per vitae in nulla suscipit, sit facilisis urna nisi lobortis facilisis congue curabitur lectus. \n</p>', '{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-06-21 12:48:50', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:48:50', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Suspendisse curabitur conubia urna conubia elementum ', 'Generated by FillItUp', 'Porttitor platea pretium lectus mi mauris ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'),
('105', 'Aenean nulla feugiat luctus', 'aenean-nulla-feugiat-luctus', '38', '1', '<p>taciti praesent ut hac massa quam quis fringilla eget quisque dui, purus quis lobortis quis per lacus hac quam felis est, amet integer conubia placerat luctus porttitor himenaeos euismod tortor. nec sed quisque pretium semper dolor amet aliquam etiam tincidunt sed mi molestie, convallis mattis dui quam habitasse volutpat odio torquent morbi tempus risus. elit amet feugiat sem nostra consectetur praesent, ante est mi sagittis egestas quam maecenas, lectus ligula massa fermentum in. lacus lacinia condimentum posuere cubilia quis risus nostra dui massa, conubia per pellentesque quis donec porttitor justo scelerisque dui, conubia dictumst condimentum urna augue tristique volutpat congue.</p>\r\n', '\r\n<p>auctor quam fringilla odio tortor platea praesent cras himenaeos rutrum diam, varius facilisis libero sollicitudin senectus habitant aenean suscipit posuere, placerat quisque malesuada in gravida congue euismod suscipit imperdiet. fusce morbi cursus pharetra diam morbi ligula himenaeos morbi, nibh id et est justo amet quisque faucibus, iaculis quis primis et nostra orci placerat. scelerisque porta neque rhoncus fames in nibh ultricies phasellus vestibulum, leo erat dictum rutrum hac dictum metus porta magna, egestas imperdiet morbi himenaeos vitae enim molestie mollis. neque torquent elementum himenaeos non netus elementum euismod netus gravida, class et nibh lacus taciti lorem turpis varius diam, nisl potenti justo eu egestas consectetur elit morbi.</p>\r\n<p>interdum habitant rutrum nunc curae proin gravida accumsan ad tortor egestas primis, curae facilisis bibendum taciti nostra habitant phasellus imperdiet luctus. cras lorem egestas conubia rutrum diam malesuada pulvinar aenean ut, iaculis aptent potenti sem tempus duis libero gravida lacus, aliquet ut semper magna volutpat turpis porttitor suspendisse. class consectetur semper rhoncus auctor sed nulla aliquam sodales volutpat, etiam molestie adipiscing sed vivamus enim ultricies luctus amet, gravida phasellus ad dictumst pellentesque cras dapibus faucibus. vestibulum aliquam donec suscipit integer rhoncus nunc gravida curae, maecenas rhoncus tellus pharetra dapibus sodales tempus, at purus cubilia urna interdum accumsan tempus.</p>\r\n<p>justo sapien scelerisque lectus gravida nostra dapibus rutrum porttitor ultricies, litora justo pulvinar praesent magna sollicitudin orci tempor, amet elementum primis consequat lectus sit laoreet etiam. nisl ullamcorper sit laoreet felis sodales placerat iaculis integer mattis aliquam donec, metus sollicitudin aptent platea habitant placerat aliquam aenean porta velit cubilia, rutrum aliquet urna tincidunt nullam ac hac elit turpis molestie. at lectus mattis volutpat mi placerat aliquam dolor in eleifend, purus eget consectetur inceptos justo elementum pretium feugiat magna, sed aliquam etiam nunc suscipit quis fermentum aliquam. cursus augue vitae imperdiet est curabitur quam est adipiscing laoreet suspendisse, accumsan per lectus maecenas scelerisque lacinia consequat est lobortis.</p>\r\n<p>orci justo purus semper lectus id pretium luctus purus sapien habitant commodo, mi etiam taciti purus vehicula aliquam habitant interdum justo quisque. donec accumsan urna ligula venenatis etiam luctus malesuada vehicula per elementum, eu sociosqu eu ante tempor mollis pharetra sollicitudin duis rutrum, consequat aliquet bibendum erat curabitur gravida sed curabitur maecenas. convallis est aliquam venenatis sit id porttitor lobortis, aenean eget tristique fusce sagittis dolor nam ipsum, pharetra feugiat fringilla donec vivamus id. nullam integer sodales purus sed ullamcorper, condimentum aliquet volutpat turpis cursus, enim diam aptent metus.</p>', '{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}', '{gallery}http://www.flickr.com/photos/photos-de-danyel/sets/72157623234681159/with/4333369054/{/gallery}', '[]', '', '2013-06-21 12:49:15', '472', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:26:29', '471', '2013-06-21 12:49:15', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Porttitor primis taciti viverra justo placerat ', 'Generated by FillItUp', 'Urna porta ipsum etiam sodales ', 'Generated by FillItUp', '907', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('110', 'Praesent commodo risus', 'praesent-commodo-risus', '45', '1', '<p>nec morbi curabitur blandit inceptos primis praesent purus, ac imperdiet convallis accumsan felis aliquet habitasse, lacus nostra accumsan morbi feugiat morbi. vulputate morbi turpis nostra egestas venenatis pellentesque inceptos ultrices viverra dapibus amet aenean, vehicula ultricies ad consectetur fusce vitae aliquet pellentesque vestibulum convallis interdum, sollicitudin potenti volutpat curae porta facilisis posuere vitae hac molestie massa. ultrices ligula vulputate placerat habitant porttitor aenean elementum at morbi, malesuada nisi posuere sapien fusce odio sodales feugiat, hac eu adipiscing primis faucibus lacinia amet leo. non consequat sociosqu sed accumsan felis inceptos, adipiscing taciti phasellus quisque commodo molestie, in libero pretium bibendum maecenas.</p>\r\n', '\r\n<p>ad bibendum hac aliquet posuere fringilla lobortis feugiat habitant, litora ante nec nostra platea dapibus elit, aenean tristique augue nisl per vel iaculis. eleifend primis sapien dictumst laoreet quisque id maecenas aenean nam rhoncus cras tincidunt ac consequat nam, nisi ut ultricies amet mi cursus curabitur risus lacinia sit cras non nisi cras. egestas augue velit suspendisse tristique sapien ut leo auctor consectetur massa dui faucibus semper, lobortis enim lorem dictumst eu interdum lectus netus vel mi quis platea. himenaeos aptent rhoncus enim luctus purus ornare nec habitasse tempus, platea massa dolor ante varius luctus convallis interdum.</p>\r\n<p>pellentesque sollicitudin vitae senectus vulputate auctor conubia aliquet laoreet, luctus orci ornare elit sodales quisque massa porttitor, id nisi lorem viverra sem platea mi. suscipit felis mauris hendrerit aenean faucibus ad a quis ullamcorper, nostra class litora pretium praesent litora tortor maecenas nam, sodales potenti dolor adipiscing morbi tristique commodo posuere. aenean pellentesque risus at arcu habitasse fringilla vel ad torquent, suspendisse quis lacus pretium pellentesque risus quis purus, pharetra euismod leo magna hendrerit pharetra nulla malesuada. viverra lectus fusce at fermentum tristique lacinia ac erat, lectus nibh taciti quisque mattis suscipit litora, ultrices luctus conubia phasellus augue diam quis.</p>\r\n<p>risus dapibus condimentum sociosqu nostra habitant ornare nec, nibh ante lorem fermentum a congue aptent ut, nullam tellus sit nostra habitasse vehicula. erat potenti etiam risus varius amet tempor facilisis hac, ullamcorper ad dictum enim nisl mi dolor suspendisse, tortor urna potenti hac risus sagittis luctus. diam sit massa posuere ac aliquam justo magna lacinia elementum justo nisi, leo congue sapien elit dictum nullam habitasse aenean molestie accumsan. nibh lorem quis dolor porttitor ornare in, nunc pellentesque curabitur morbi commodo varius, purus ipsum augue lorem tellus. erat est habitasse sem donec fermentum quam cras amet, ligula odio ante nam vehicula phasellus taciti, nostra consequat aptent taciti vestibulum sed euismod.</p>\r\n<p>sollicitudin leo nostra diam nostra urna ut vitae curabitur felis eros nibh pellentesque rutrum, tortor himenaeos cras quisque iaculis facilisis mauris nisi amet curae torquent. sapien mollis neque velit quis ad tempus hac maecenas viverra, nibh convallis nisl vulputate sed cursus orci porta, etiam enim felis rutrum quisque tincidunt sociosqu cubilia. lacinia phasellus primis aenean mollis vitae aenean fringilla placerat sed, nostra fames morbi metus convallis class convallis vel primis neque, quis sodales quisque vestibulum tristique porttitor netus quam. faucibus consequat sed risus aliquam vivamus, molestie facilisis quam porttitor laoreet, varius imperdiet accumsan mauris.</p>', '{youtube}http://www.youtube.com/watch?v=vugB9semEA8{/youtube}', '{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}', '[]', '', '2013-06-21 12:50:31', '473', '', '0', '0000-00-00 00:00:00', '2013-07-19 10:28:14', '471', '2013-06-21 12:50:31', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Aenean aliquam enim suspendisse ', 'Generated by FillItUp', 'Hendrerit fermentum ullamcorper ', 'Generated by FillItUp', '1131', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('111', 'Habitasse habitant amet mattis potenti lobortis', 'habitasse-habitant-amet-mattis-potenti-lobortis', '32', '1', '<p>\ndictum vivamus eget sagittis suscipit et sociosqu aenean congue viverra adipiscing, rutrum cras torquent maecenas molestie ultrices hac conubia aliquam, potenti posuere aenean faucibus himenaeos nam platea posuere risus. \nbibendum lorem ultricies tempus quis enim curae cursus euismod sapien semper, convallis quisque ut interdum fringilla hendrerit iaculis lacus. \npellentesque aliquam proin ad auctor quis elit sodales quisque felis nisi, malesuada etiam platea netus nostra litora felis viverra vulputate in, dictumst facilisis quam commodo imperdiet metus hendrerit interdum egestas. \nclass lobortis nam praesent curabitur quisque cursus imperdiet elementum ad ullamcorper adipiscing, integer pellentesque ac etiam hac enim leo sollicitudin consequat cras. \n</p>', '<p>\nmagna vivamus posuere orci nec faucibus etiam, eros phasellus arcu et donec neque, vitae libero euismod pellentesque facilisis. \nfames vitae aliquet quisque augue ut quisque at litora hendrerit quis, tincidunt nisi facilisis adipiscing est risus consectetur posuere risus vulputate consectetur, ultricies class est nulla etiam erat ut fringilla sit. \nsed vulputate sociosqu convallis conubia at, rhoncus ornare lectus nullam iaculis, primis enim accumsan auctor. \nligula maecenas nec eu suspendisse consequat orci himenaeos posuere, proin lobortis sagittis fames ultricies phasellus quam litora vitae, vulputate donec eros dapibus est platea ipsum. \n</p>\n<p>\ninceptos curae condimentum elit suspendisse ante convallis vestibulum augue suscipit imperdiet, felis sociosqu magna erat sociosqu netus sed enim mollis litora, tellus malesuada sapien dapibus nisi sit integer sollicitudin eget. \naliquam cubilia felis inceptos rhoncus aenean diam turpis fusce pulvinar, fringilla morbi faucibus sollicitudin non lectus dolor semper, mollis magna quam dapibus imperdiet nulla velit sollicitudin. \nrhoncus tempor libero fermentum sed laoreet blandit convallis senectus potenti, fringilla nunc nibh varius sollicitudin bibendum vivamus elementum, fermentum nam aliquam est euismod cubilia duis tincidunt. \nproin elementum nulla suscipit in mollis mauris purus ultricies commodo, vulputate pulvinar nullam accumsan quis ut nec enim, ultricies fermentum dui etiam purus ornare leo elit. \n</p>\n<p>\norci pellentesque porttitor taciti nisi orci nec ullamcorper fermentum, ante vitae tristique convallis mollis viverra enim, elementum arcu eleifend sagittis semper vivamus nam. \netiam sit eleifend non sollicitudin himenaeos netus sociosqu, ultricies quisque accumsan libero metus sed cursus, enim volutpat ut aenean duis eleifend. \ncubilia posuere vitae maecenas risus litora, curabitur lorem massa feugiat aptent aliquet, ipsum gravida nam est. \nmolestie sapien magna tortor justo tempus donec, tellus nec phasellus integer dui, neque sollicitudin fusce nibh torquent. \nlacinia ultrices tortor volutpat aliquam erat nibh netus aenean faucibus ullamcorper, vehicula bibendum aliquet est etiam hendrerit massa velit aenean pellentesque, orci tellus consectetur donec ut cubilia ultricies etiam curabitur. \n</p>\n<p>\ncubilia tortor pretium conubia fames sem curabitur magna litora eget aenean, arcu et vel accumsan vel etiam dui lacus etiam, amet sodales integer aenean suspendisse nibh curae commodo morbi. \ntortor consequat odio tellus nisl eros posuere torquent pretium ornare risus, ut netus urna quam tortor rhoncus venenatis dictumst pharetra, ligula libero est at molestie quam suspendisse ac enim. \nrisus imperdiet ornare consequat lorem turpis tellus nam felis, velit inceptos faucibus non lacus at ullamcorper elementum lobortis, mollis varius a cursus sapien rhoncus fames. \nerat feugiat mauris dictumst augue, condimentum metus suspendisse nisl lectus, non morbi etiam. \n</p>', '{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-06-21 12:50:47', '471', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-06-21 12:50:47', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', 'Eros molestie rhoncus fermentum est ', 'Generated by FillItUp', 'Nec nullam venenatis ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*');
