// =========================================================
// jq-innerfade.js
// Datum: 2006-09-01
// Firma: Medienfreunde Hofmann & Baldes GbR
// Autor: Torsten Baldes
// Mail: t.baldes@medienfreunde.com
// Web: http://medienfreunde.com
// based on the work of Matt Oakes http://portfolio.gizone.co.uk/applications/slideshow/
// =========================================================
$.fn.innerfade = function(options) {
	return this.each(function(){
		var settings = {
			speed: 'normal',
			timeout: 2000,
			type: 'sequence',
			containerheight: 'auto'
		}
		//Stop IE flicker
		if ($.browser.msie == true) {
			document.execCommand('BackgroundImageCache', false, true);
		}
		//Stop IE flicker
		if(options)
			$.extend(settings, options);
		var elements = $(this).children().get();
		if (elements.length > 1) {
			$(this).parent().css('position', 'relative');
			$(this).css('height', settings.containerheight);
			for ( var i = 0; i < elements.length; i++ ) {
				$(elements[i]).css('z-index', elements.length - i).css('position', 'absolute');
				$(elements[i]).hide();
			}	
			if ( settings.type == 'sequence' ) {
				setTimeout(function(){
					$.innerfade.next(elements, settings, 1, 0);
				}, settings.timeout);
				$(elements[0]).show();
			}
			else if ( settings.type == 'random' ) {
				setTimeout(function(){
					do { current = Math.floor ( Math.random ( ) * ( elements.length ) ); } while ( current == 0 )
					$.innerfade.next(elements, settings, current, 0);
				}, settings.timeout);
				$(elements[0]).show();
			}
			else {
				alert('type must either be \'sequence\' or \'random\'');
			}
		}
	});
};
$.innerfade = function() {}
$.innerfade.next = function (elements, settings, current, last) {
	$(elements[last]).fadeOut(settings.speed);
	$(elements[current]).fadeIn(settings.speed);
	if ( settings.type == 'sequence' ) {
		if ( ( current + 1 ) < elements.length ) {
			current = current + 1;
			last = current - 1;
		}
		else {
			current = 0;
			last = elements.length - 1;
		}
	}
	else if ( settings.type == 'random' ) {
		last = current;
		while (	current == last ) {
			current = Math.floor ( Math.random ( ) * ( elements.length ) );
		}
	}
	else {
		alert('type must either be \'sequence\' or \'random\'');
	}
	setTimeout((function(){$.innerfade.next(elements, settings, current, last);}), settings.timeout);
}