<?php
/*
// JoomlaWorks "Custom Code" Module for Joomla! 1.5.x - Version 1.0
// License: http://www.gnu.org/copyleft/gpl.html
// Authors: JoomlaWorks
// Copyright (c) 2006 - 2008 JoomlaWorks (www.joomlaworks.gr)
// Project page at http://www.joomlaworks.gr - Demos at http://demo.joomlaworks.gr
// Support forum at http://forum.joomlaworks.gr
// ***Last update: November 19th, 2008***
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

// Module Parameters
$moduleclass_sfx	= $params->get('moduleclass_sfx','');
$addcustomcode		= $params->get('addcustomcode','');
$parsePhp			= $params->get('parsePhp',0);
$parsePlugins		= $params->get('parsePlugins',0);



// Class to write php code in external file
if (!class_exists('jwCustomCode')) {
	class jwCustomCode {
		function parsePHPviaFile($codeToWrite) {
			$temp_dir = JPATH_SITE.DS.'modules'.DS.'mod_jw_cc'.DS.'temp';
			$tmpfname = tempnam($temp_dir,"tmp");
			if ($handle = @fopen($tmpfname, "w")) {
				fwrite($handle, $codeToWrite, strlen($codeToWrite));
				fclose($handle);
				
				//include_once($tmpfname);
				ob_start();
				include_once($tmpfname);
				$tempFileContents = ob_get_contents();
				ob_end_clean();
				
				return $tempFileContents;			
				
				unlink($tmpfname);
			} else {
				return '<div class="message">Could not open temporary file for writing. Please create a folder called modules/mod_jw_cc/temp and make it writable (755 or 777)!</div>';
			}
		}
	}
}

// Parse mixed PHP
if($parsePhp) {
	$html = jwCustomCode::parsePHPviaFile($addcustomcode);
} else {
	$html = $addcustomcode;
}

// Parse plugins
if ($parsePlugins) {
	$stdObject = new stdClass();
	$stdObject->text = $html;
	JPluginHelper::importPlugin ('content','');
	$dispatcher =& JDispatcher::getInstance();
	$dispatcher->trigger('onPrepareContent', array (&$stdObject, &$params));
	$html = $stdObject->text;
} else {
	$html = preg_replace("#{(.*?)}(.*?){(.*?)}#s","", $html);
}

// Output
echo '
<!-- JoomlaWorks "Custom Code" Module (v1.0) starts here -->
<div class="jwcc_'.$moduleclass_sfx.'">
'.$html.'
</div>
<!-- JoomlaWorks "Custom Code" Module (v1.0) ends here -->
';

?>