<?php
/*
// JoomlaWorks "Custom Code" Module for Joomla! 1.5.x - Version 1.1
// Copyright (c) 2006 - 2010 JoomlaWorks, a business unit of Nuevvo Webware Ltd.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: November 4th, 2010***
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

// Module Parameters
$moduleclass_sfx	= $params->get('moduleclass_sfx','');
$addcustomcode		= $params->get('addcustomcode','');
$parsePhp					= $params->get('parsePhp',0);
$parsePlugins			= $params->get('parsePlugins',0);

// Class to write php code in external file
if(!class_exists('jwCustomCode')) {
	class jwCustomCode {
		function parsePHPviaFile($codeToWrite) {
		
			// Check if the cache folder exists
			$cacheFolderPath = JPATH_SITE.DS.'cache'.DS.'mod_jw_cc';
			if(file_exists($cacheFolderPath) && is_dir($cacheFolderPath)){
				// all OK
			} else {
				mkdir($cacheFolderPath);
			}
			$tmpfname = tempnam($cacheFolderPath,"tmp");
			if ($handle = @fopen($tmpfname, "w")) {
				fwrite($handle, $codeToWrite, strlen($codeToWrite));
				fclose($handle);

				ob_start();
				include_once($tmpfname);
				$tempFileContents = ob_get_contents();
				ob_end_clean();
				
				unlink($tmpfname);
				
				return $tempFileContents;			

			} else {
				return '<div class="message">Could not open temporary file for writing. Please make sure your Joomla! /cache folder is writable (permissions 755 or 777)!</div>';
			}
		}
	}
}

// Parse mixed PHP
if($parsePhp) {
	$html = jwCustomCode::parsePHPviaFile($addcustomcode);
} else {
	$html = $addcustomcode;
}

// Parse plugins
if($parsePlugins) {
	$stdObject = new stdClass();
	$stdObject->text = $html;
	JPluginHelper::importPlugin('content');
	$dispatcher =& JDispatcher::getInstance();
	$dispatcher->trigger('onPrepareContent', array(&$stdObject, &$params));
	$html = $stdObject->text;
} else {
	$html = preg_replace("#{(.*?)}(.*?){(.*?)}#s","", $html);
}

?>

<!-- JoomlaWorks "Custom Code" Module (v1.1) starts here -->
<div class="jwcc<?php if($moduleclass_sfx) echo ' '.$moduleclass_sfx; ?>">
	<?php echo $html; ?>
</div>
<!-- JoomlaWorks "Custom Code" Module (v1.1) ends here -->
