<?php
/*
// JoomlaWorks "Latest Tweets" Module for Joomla! 1.5.x - Version 1.1
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: November 4th, 2009***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// JoomlaWorks reference parameters
$mod_name               = "mod_jw_latesttweets";
$mod_copyrights_start   = "\n\n<!-- JoomlaWorks \"Latest Tweets\" Module (v1.1) starts here -->\n";
$mod_copyrights_end     = "\n<!-- JoomlaWorks \"Latest Tweets\" Module (v1.1) ends here -->\n\n";

// API
jimport('joomla.filesystem.file');
$mainframe	= &JFactory::getApplication();
$document 	= &JFactory::getDocument();

// Assign paths
$sitePath 	= JPATH_SITE;
$siteUrl  	= substr(JURI::base(), 0, -1);

// Module parameters
$moduleclass_sfx 	= $params->get('moduleclass_sfx','');
$ltCSSStyling			= (int) $params->get('ltCSSStyling',1);
$ltTimeout				= (int) $params->get('ltTimeout',2) * 1000;
$ltUsername 			= strtolower(trim($params->get('ltUsername','JoomlaWorks')));
$ltCount			 		= (int) $params->get('ltCount',5);

// Output some Twitter API stuff to the document's head
$headScripts = "
<script type=\"text/javascript\">
	//<![CDATA[
	function twitterCallbackId".$module->id."(twitters) {

	  var statusHTML = [];
	  for (var i=0; i<twitters.length; i++){
	    var username = twitters[i].user.screen_name;
	    var status = twitters[i].text.replace(/((https?|s?ftp|ssh)\:\/\/[^\"\s\<\>]*[^.,;'\">\:\s\<\>\)\]\!])/g, function(url) {
	      return '<a href=\"'+url+'\">'+url+'</a>';
	    }).replace(/\B@([_a-z0-9]+)/ig, function(reply) {
	      return  reply.charAt(0)+'<a href=\"http://twitter.com/'+reply.substring(1)+'\">'+reply.substring(1)+'</a>';
	    });
	    
	    if(i%2==1) var liClass = 'Even'; else var liClass = 'Odd';
	    
	    var liOutput = '\
		    <li class=\"lt'+liClass+'\">\
			    <span class=\"ltUserStatus\">'+status+'</span>\
			    <br />\
			    <a class=\"ltStatusTimestamp\" href=\"http://twitter.com/'+username+'/statuses/'+twitters[i].id+'\">\
			    	'+relative_time(twitters[i].created_at)+'\
			    </a>\
		    </li>\
	    ';
	    
	    statusHTML.push(liOutput);
	  }
	  
	  setTimeout(function(){document.getElementById('ltUpdateId".$module->id."').innerHTML = statusHTML.join('');},".$ltTimeout.");
	}
	
	function relative_time(time_value) {
	  var values = time_value.split(\" \");
	  time_value = values[1] + \" \" + values[2] + \", \" + values[5] + \" \" + values[3];
	  var parsed_date = Date.parse(time_value);
	  var relative_to = (arguments.length > 1) ? arguments[1] : new Date();
	  var delta = parseInt((relative_to.getTime() - parsed_date) / 1000);
	  delta = delta + (relative_to.getTimezoneOffset() * 60);
	
	  if (delta < 60) {
	    return '".JText::_('less than a minute ago')."';
	  } else if(delta < 120) {
	    return 'about a minute ago';
	  } else if(delta < (60*60)) {
	    return (parseInt(delta / 60)).toString() + ' ".JText::_('minutes ago')."';
	  } else if(delta < (120*60)) {
	    return 'about an hour ago';
	  } else if(delta < (24*60*60)) {
	    return 'about ' + (parseInt(delta / 3600)).toString() + ' ".JText::_('hours ago')."';
	  } else if(delta < (48*60*60)) {
	    return '1 day ago';
	  } else {
	    return (parseInt(delta / 86400)).toString() + ' ".JText::_('days ago')."';
	  }
	}
	//]]>
</script>
<script type=\"text/javascript\">
	//<![CDATA[
	window.addEvent('domready', function() {
	  var twitterJson = 'http://twitter.com/statuses/user_timeline/".$ltUsername.".json?callback=twitterCallbackId".$module->id."&count=".$ltCount."';
		var twitterScript = document.createElement('script');
		twitterScript.setAttribute('charset','utf-8');
		twitterScript.setAttribute('type','text/javascript');
		twitterScript.setAttribute('src',twitterJson);
		var b = document.getElementsByTagName('body')[0];
		b.appendChild(twitterScript);
	});
	//]]>
</script>
";

$document->addCustomTag($mod_copyrights_start.$headScripts.$mod_copyrights_end);

// Append CSS to the document's head
if($ltCSSStyling) $document->addStyleSheet($siteUrl.'/modules/mod_jw_latesttweets/tmpl/css/style.css');

// Output content with template
echo $mod_copyrights_start;
require(JModuleHelper::getLayoutPath($mod_name,'default'));
echo $mod_copyrights_end;
