<?php
/**
 * @version		1.2
 * @package		Latest Tweets (module) for Joomla! 1.5
 * @author    JoomlaWorks - http://www.joomlaworks.gr
 * @copyright	Copyright (c) 2006 - 2011 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// JoomlaWorks reference parameters
$mod_name               = "mod_jw_latesttweets";
$mod_copyrights_start   = "\n\n<!-- JoomlaWorks \"Latest Tweets\" Module (v1.2) starts here -->\n";
$mod_copyrights_end     = "\n<!-- JoomlaWorks \"Latest Tweets\" Module (v1.2) ends here -->\n\n";

// API
jimport('joomla.filesystem.file');
$mainframe	= &JFactory::getApplication();
$document		= &JFactory::getDocument();

// Assign paths
$sitePath		= JPATH_SITE;
$siteUrl  	= substr(JURI::base(), 0, -1);

// Module parameters
$moduleclass_sfx 	= $params->get('moduleclass_sfx','');
$ltCSSStyling			= (int) $params->get('ltCSSStyling',1);
$ltTimeout				= (int) $params->get('ltTimeout',2) * 1000;
$ltUsername 			= strtolower(trim($params->get('ltUsername','JoomlaWorks')));
$ltCount			 		= (int) $params->get('ltCount',5);

// Output some Twitter API stuff to the document's head
$headScripts = "
	//<![CDATA[
	/* JoomlaWorks \"Latest Tweets\" Module (v1.2) */
	
	function twitterCallbackId".$module->id."(tweets) {
	
	  var statusHTML = [];
	  
	  for(var i=0; i<tweets.length; i++) {
	    var username = tweets[i].user.screen_name;
	    var status = tweets[i].text.replace(/((https?|s?ftp|ssh)\:\/\/[^\"\s\<\>]*[^.,;'\">\:\s\<\>\)\]\!])/g, function(url) {
	      return '<a target=\"_blank\" href=\"'+url+'\">'+url+'</a>';
	    }).replace(/\B[@＠]([a-zA-Z0-9_]{1,20})/g, function(reply) {
	      return '<a target=\"_blank\" href=\"http://twitter.com/'+reply.substring(1)+'\">@'+reply.substring(1)+'</a>';
	    }).replace(/(^|\s+)#(\w+)/gi, ' <a target=\"_blank\" href=\"http://twitter.com/search?q=%23$2\">&#035;$2</a>');
	    
	    if(status.substr(0,1)==' ') status = status.substring(1);
	    
	    if(i%2==1) var liClass = 'Even'; else var liClass = 'Odd';
	    
	    var liOutput = '\
		    <li class=\"lt'+liClass+'\">\
			    <span class=\"ltUserStatus\">'+status+'</span>\
			    <br />\
			    <a target=\"_blank\" class=\"ltStatusTimestamp\" href=\"http://twitter.com/'+username+'/status/'+tweets[i].id_str+'\">\
			    	'+relative_time(tweets[i].created_at)+'\
			    </a>\
		    </li>\
	    ';
	    
	    statusHTML.push(liOutput);
	  }
	  
	  setTimeout(function(){document.getElementById('ltUpdateId".$module->id."').innerHTML = statusHTML.join('');},".$ltTimeout.");
	}
	
	function relative_time(time_value) {
	  var values = time_value.split(\" \");
	  time_value = values[1] + \" \" + values[2] + \", \" + values[5] + \" \" + values[3];
	  var parsed_date = Date.parse(time_value);
	  var relative_to = (arguments.length > 1) ? arguments[1] : new Date();
	  var delta = parseInt((relative_to.getTime() - parsed_date) / 1000);
	  delta = delta + (relative_to.getTimezoneOffset() * 60);
	
	  if (delta < 60) {
	    return '".JText::_('less than a minute ago')."';
	  } else if(delta < 120) {
	    return 'about a minute ago';
	  } else if(delta < (60*60)) {
	    return (parseInt(delta / 60)).toString() + ' ".JText::_('minutes ago')."';
	  } else if(delta < (120*60)) {
	    return 'about an hour ago';
	  } else if(delta < (24*60*60)) {
	    return 'about ' + (parseInt(delta / 3600)).toString() + ' ".JText::_('hours ago')."';
	  } else if(delta < (48*60*60)) {
	    return '1 day ago';
	  } else {
	    return (parseInt(delta / 86400)).toString() + ' ".JText::_('days ago')."';
	  }
	}
	
	window.addEvent('domready', function() {
		var twitterScript = document.createElement('script');
		twitterScript.setAttribute('charset','utf-8');
		twitterScript.setAttribute('type','text/javascript');
		twitterScript.setAttribute('src','http://twitter.com/statuses/user_timeline.json?screen_name=".$ltUsername."&count=".$ltCount."&callback=twitterCallbackId".$module->id."');
		var b = document.getElementsByTagName('body')[0];
		b.appendChild(twitterScript);
	});
	//]]>
";

// Append JS to the document's head
$document->addScriptDeclaration($headScripts);

// Append CSS to the document's head
if($ltCSSStyling) $document->addStyleSheet($siteUrl.'/modules/mod_jw_latesttweets/tmpl/css/style.css');

// Output content with template
echo $mod_copyrights_start;
require(JModuleHelper::getLayoutPath($mod_name,'default'));
echo $mod_copyrights_end;
