<?php
/*
// JoomlaWorks "Pro Joomla! Network" Module for Joomla! 1.5.x - Version 2.0
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: October 28th, 2009***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class ProJoomlaNetwork {
		
	// Read Members XML file
	function readMembersFile($membersXML,$cacheTime=6,$extensionName='mod_projoomlanetwork'){

		jimport('joomla.filesystem.file');
		
		$site_absolutepath = JPATH_SITE;
		
		// Assign some names
		$ds = (strtoupper(substr(PHP_OS,0,3)=='WIN')) ? '\\' : '/';
		$cacheFolderPath = $site_absolutepath.$ds.'cache'.$ds.$extensionName;
		$membersXMLFile = $cacheFolderPath.$ds.'members.xml';

		// Check cache folder
		$cacheTime = $cacheTime*60*60; // Cache time in hours
		if(file_exists($cacheFolderPath) && is_dir($cacheFolderPath)){
			// all OK
		} else {
			mkdir($cacheFolderPath);
		}
		if(file_exists($membersXMLFile) && is_readable($membersXMLFile) && (filemtime($membersXMLFile)+($cacheTime)) > time()){
			// XML file is cached locally
		} else {
			$fetchXML = @ ProJoomlaNetwork::readFile($membersXML);
			JFile::write($membersXMLFile,$fetchXML);
		}
		
		return $membersXMLFile;
	}
		
	// Read remote file
	function readFile($url,$extensionName='mod_projoomlanetwork'){
	
		jimport('joomla.filesystem.file');
		
		// Check cache folder
		$cacheFolderPath = JPATH_SITE.DS.'cache'.DS.$extensionName;
		if(file_exists($cacheFolderPath) && is_dir($cacheFolderPath)){
			// all OK
		} else {
			mkdir($cacheFolderPath);
		}
		
		// Get file
		if(substr($url,0,4)=="http"){
			// remote file
			if(ini_get('allow_url_fopen')){
			
				// file_get_contents
				$result = JFile::read($url);
				
			} elseif(in_array('curl',get_loaded_extensions())) {
			
				// cURL
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_HEADER, false);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				$chOutput = curl_exec($ch);
				curl_close($ch);
				$tmpFile = $cacheFolderPath.DS.'curl_tmp_'.substr(md5($url),0,10);
				JFile::write($tmpFile,$chOutput);
				$result = JFile::read($tmpFile);
			
			} else {
			
				// fsockopen
				$readURL = parse_url($url);
				$relativePath = (isset($readURL['query'])) ? $readURL['path']."?".$readURL['query'] : $readURL['path'];
				
				$fp = fsockopen($readURL['host'], 80, $errno, $errstr, 5);
				if (!$fp) {
					$result = "";
				} else {
					$out = "GET ".$relativePath." HTTP/1.1\r\n";
					$out .= "Host: ".$readURL['host']."\r\n";
					$out .= "Connection: Close\r\n\r\n";
					fwrite($fp, $out);
					$header = '';
					$body = '';
					do { $header .= fgets($fp,128); } while (strpos($header,"\r\n\r\n")=== false); // get the header data
					while (!feof($fp)) $body .= fgets($fp,128); // get the actual content
					fclose($fp);
					$tmpFile = $cacheFolderPath.DS.'fsockopen_tmp_'.substr(md5($url),0,10);
					JFile::write($tmpFile,$body);
					$result = JFile::read($tmpFile);
				}
			
			}
		} else {
			// local file
			$result = JFile::read($url);
		}

		return $result;
	}

} // end class
