<?php
/*
// JoomlaWorks "ArtBannersXTD" Component for Joomla! 1.0.x & Mambo 4.5.x/4.6.x - Version 1.0
// License: http://www.gnu.org/copyleft/gpl.html - Based on ArtBanners by Aprisobal/Perigoso Studio
// Copyright (c) 2006 - 2008 JoomlaWorks (Komrade LLC) - www.joomlaworks.gr
// Project page at http://www.joomlaworks.gr - Demos at http://demo.joomlaworks.gr
// Support forum at http://forum.joomlaworks.gr
// ***Last update: March 2nd, 2008***
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//
// Classes and helper functions to the banner system
//
class mosArtBannerClient extends mosDBTable
{
	var $cid				= null;
	var $name				= "";
	var $contact			= "";
	var $email				= "";
	var $extrainfo			= "";
	var $checked_out		= 0;
	var $checked_out_time	= 0;

	function mosArtBannerClient( &$db )
	{
		$this->mosDBTable( '#__artbannersxtd_clients', 'cid', $db );
	}

	function check()
	{
		// check for valid client name
		if (trim($this->name == ""))
		{
			$this->_error = _ABANA_CL_MSNF;
			return false;
		}

		// check for valid client contact
		if (trim($this->contact == ""))
		{
			$this->_error = _ABANA_CL_MSCF;
			return false;
		}

		// check for valid client email
		if ((trim($this->email == "")) || (preg_match("/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $this->email )==false))
		{
			$this->_error = _ABANA_CL_MSEF;
			return false;
		}

		return true;
	}
}

class mosArtBanner extends mosDBTable
{
	var $id			= null;	// int(11) NOT NULL PRIMARY auto_increment,
  	var $cid		= null;	// int(11) NOT NULL default '0',
  	var $tid		= null;	// int(11) NOT NULL default '0',
	var $type		= "";	// varchar(10) NOT NULL default 'banner',
	var $name		= "";	// varchar(50) NOT NULL default '',
	var $imp_total		= 0;	// int(11) NOT NULL default '0',
	var $imp_made		= 0;	// int(11) NOT NULL default '0',
	var $clicks		= 0;	// int(11) NOT NULL default '0',
	var $image_url		= "";	// varchar(100) NOT NULL default '',
	var $click_url		= "";	//  varchar(200) NOT NULL default '',
	var $last_show		= null;	// datetime default NULL,
	var $msec		= null;	// int(11) NOT NULL,
	var $state		= 0;	// tinyint(1) NOT NULL default '0',
	var $default		= 0;	// tinyint(1) NOT NULL default '0',
	var $checked_out	= 0;	// tinyint(1) NOT NULL default '0',
	var $checked_out_time	= 0;	// time default NULL,
	var $publish_up 	= null;
  	var $publish_down 	= null;
  	var $reccurtype 	= null;
  	var $reccurday 		= null;
  	var $reccurweekdays 	= null;
  	var $custom_banner_code	= "";	// text,
  	var $access		= 0;	// int(11) NOT NULL default '0',
    var $target     = "self"; 
	var $border_value     = 0;
	var $border_style = "solid";
	var $border_color = "green";
	 
	function mosArtBanner( &$db )
	{
		$this->mosDBTable( '#__artbannersxtd', 'id', $db );
	}
	
	function setDate() {
		$this->set("last_show",date("Y-m-d H:i:s"));	
	}

	function clicks() {
		$this->_db->setQuery( "UPDATE #__artbannersxtd SET clicks=(clicks+1) WHERE id='$this->id'" );
		$this->_db->query();
	}

	function check()
	{
		// check for valid client id
		if (is_null($this->cid) || $this->cid == 0)
		{
			$this->_error = _ABANA_BN_MSC;
			return false;
		}
		
		// check for valid category id
		if (is_null($this->tid) || $this->tid == 0)
		{
			$this->_error = _ABANA_BN_MSCA;
			return false;
		}
		
		if (trim($this->name) == "")
		{
			$this->_error = _ABANA_BN_MSNB;
			return false;
		}

		if (trim($this->image_url) == "")
		{
			$this->_error = _ABANA_BN_MSIB;
			return false;
		}
		if (trim($this->click_url) == "" && trim($this->custom_banner_code) == "")
		{
			$this->_error = _ABANA_BN_MSUB;
			return false;
		}

		return true;
	}
}

/**
* Category database table class
*/
class mosArtCategory extends mosDBTable {
/** @var int Primary key */
	var $id=null;
/** @var string The full name for the Category*/
	var $name=null;
/** @var string */
	var $description=null;
/** @var boolean */
	var $published=null;
/** @var boolean */
	var $checked_out=null;
/** @var time */
	var $checked_out_time=null;

/**
* @param database A database connector object
*/
	function mosArtCategory( &$db ) {
		$this->mosDBTable( '#__artbannersxtd_categories', 'id', $db );
	}
// overloaded check function
	function check() {
		// check for valid name
		if (trim( $this->name ) == '') {
			$this->_error = _ABANA_YCMHAN;
			return false;
		}
		// check for existing name
		$this->_db->setQuery( "SELECT id FROM #__artbannersxtd_categories "
			. "\nWHERE name='".$this->name."'"
		);

		$xid = intval( $this->_db->loadResult() );
		if ($xid && $xid != intval( $this->id )) {
			$this->_error = _ABANA_TIACAWTHPTA;
			return false;
		}
		return true;
	}
}

class mosArtBannersXTDDate {
	var $year=null;
	var $month=null;
	var $day=null;
	var $hour=null;
	var $minute=null;
	var $second=null;

	function mosArtBannersXTDDate( $datetime ) {
		if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})[ ]([0-9]{2}):([0-9]{2}):([0-9]{2})",$datetime,$regs)) {
			$this->year   = $regs[1];
			$this->month  = $regs[2];
			$this->day    = $regs[3];
			$this->hour   = $regs[4];
			$this->minute = $regs[5];
			$this->second = $regs[6];
		} else {
			$this->year   = 0;
			$this->month  = 1;
			$this->day    = 1;
			$this->hour   = 0;
			$this->minute = 0;
			$this->second = 0;
		}
	}
}

?>