<?php
/*
// JoomlaWorks "ArtBannersXTD" Component for Joomla! 1.0.x & Mambo 4.5.x/4.6.x - Version 1.0
// License: http://www.gnu.org/copyleft/gpl.html - Based on ArtBanners by Aprisobal/Perigoso Studio
// Copyright (c) 2006 - 2008 JoomlaWorks (Komrade LLC) - www.joomlaworks.gr
// Project page at http://www.joomlaworks.gr - Demos at http://demo.joomlaworks.gr
// Support forum at http://forum.joomlaworks.gr
// ***Last update: March 2nd, 2008***
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

if (file_exists($mosConfig_absolute_path.'/administrator/components/com_artbannersxtd/language/'.$mosConfig_lang.'.php')) {
	include_once ($mosConfig_absolute_path.'/administrator/components/com_artbannersxtd/language/'.$mosConfig_lang.'.php');
} else {
	include_once ($mosConfig_absolute_path.'/administrator/components/com_artbannersxtd/language/english.php');
}

$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

// Output
HTML_JWArtBannersXTD::showHeader();
HTML_JWArtBannersXTD::showNavBar();

switch ($task) {
	// OTHER EVENTS	
	case "information":
		showInformation();
		break;
	
	// CATEGORY EVENTS	
	case "newcategory":
		editCategory( 0 );
		break;

	case "editcategory":
		editCategory( intval( $cid[0] ) );
		break;

	case "savecategory":
		saveCategory();
		break;

	case "removecategory":
		removeCategories( $cid );
		break;

	case "publishcategory":
		publishCategories( $id, $cid, 1 );
		break;

	case "unpublishcategory":
		publishCategories( $id, $cid, 0 );
		break;

	case "cancelcategory":
		cancelCategory();
		break;

	case "categories":
		showCategories();
		break;
	
	// CLIENT EVENTS
	case "newclient":
		editBannerClient( 0, $option );
		break;

	case "editclient":
		editBannerClient( $cid[0], $option );
		break;

	case "saveclient":
		saveBannerClient( $option );
		break;

	case "removeclients":
		removeBannerClients( $cid, $option );
		break;

	case "cancelclient":
		cancelEditClient( $option );
		break;

	case "clients":
		viewBannerClients( $option );
		break;

	// BANNER EVENTS
	case "new":
		editBanner( null, $option);
		break;

	case "cancel":
		cancelEditBanner( $option );
		break;

	case "save":
		saveBanner( $option);
		break;

	case "edit":
		editBanner( $cid[0], $option);
		break;

	case "saveUploadNew":
		if ($extractFiles == 1) {
			$userfile_name=$userfile['name'];
			$userfile2=$userfile['tmp_name'];
		} else {
			$userfile2 = $userfile;
		}
		saveUploadNew($userfile2, $userfile_name);
	break;

	case "remove":
		removeBanner( $cid, $option);
		break;

	case "publish":
		publishBanner( $cid,1,$option);
		break;

	case "unpublish":
		publishBanner( $cid, 0, $option);
		break;

	default:
		viewBanners( $option);
		break;
}

HTML_JWArtBannersXTD::showFooter();

function viewBanners( $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}bannerslimitstart", 'limitstart', 0 );
	$catid = $mainframe->getUserStateFromRequest( "category{$option}id", 'catid', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__artbannersxtd" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );
	
	if ($catid > 0) {
		$where = "WHERE a.tid='$catid'";
	} else {
		$where = "";	
	}
	
	$query = "SELECT a.*, u.name AS editor, c.name as category FROM #__artbannersxtd AS a"
	. "\nLEFT JOIN #__users AS u ON u.id = a.checked_out"
	. "\nLEFT JOIN #__artbannersxtd_categories AS c ON c.id = a.tid"
	. "\n$where"
	. "\nORDER BY c.name, a.name"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit";
	$database->setQuery( $query );

	if(!$result = $database->query()) {
		echo $database->stderr();
		return false;
	}
	$rows = $database->loadObjectList();
	
	// get list of categories
	$categories[] = mosHTML::makeOption( '-1', _ABANA_ALLCAT );
	$database->setQuery( "SELECT id AS value, name AS text FROM #__artbannersxtd_categories ORDER BY name" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	$clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
	'value', 'text', $catid );
	
	HTML_banners::showBanners( $rows, $clist, $pageNav, $option );
}

function editBanner( $bannerid, $option ) {
	global $database;
	global $mainframe;
	global $my;

	$row = new mosArtBanner($database);
	$row->load( $bannerid );

	// Build Client select list
	$sql	= "SELECT cid as value, name as text FROM #__artbannersxtd_clients";
	$database->setQuery($sql);
	if (!$database->query()) {
		echo $database->stderr();
		return false;
	}

	$clientlist[] = mosHTML::makeOption( '0', _ABANA_SELECT_CLIENT );
	$clientlist = array_merge( $clientlist, $database->loadObjectList() );
	$clist = mosHTML::selectList( $clientlist, 'cid', 'class="inputbox" size="1"','value', 'text', $row->cid);
	
	// Build Categories select list
	$sql	= "SELECT id as value, name as text FROM #__artbannersxtd_categories";
	$database->setQuery($sql);
	if (!$database->query()) {
		echo $database->stderr();
		return false;
	}

	$categorylist[] = mosHTML::makeOption( '0', _ABANA_SELECT_CATEGORY );
	$categorylist = array_merge( $categorylist, $database->loadObjectList() );
	$tlist = mosHTML::selectList( $categorylist, 'tid', 'class="inputbox" size="1"','value', 'text', $row->tid);

	// Imagelist
	// get list of images
	$imgFiles = mosReadDirectory( $mainframe->getCfg( 'absolute_path' ) . "/"._ABXTD_DEFIMGFOLDER );
	$images = array();
	foreach ($imgFiles as $file) {
		if (eregi( "bmp|gif|jpg|png|swf", $file )) {
			$images[] = mosHTML::makeOption( $file );
		}
	}

	$ilist = mosHTML::selectList( $images, 'image_url', "class=\"inputbox\" size=\"1\" onchange=\"changeDisplayImage();\"" , 'value', 'text', $row->image_url );
	
	// get list of groups
	$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
	$groups = $database->loadObjectList();

	// build the html select list
	$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"', 'value', 'text', intval( $row->access ) );

	// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', _ABANA_NO );
	$yesno[] = mosHTML::makeOption( '1', _ABANA_YES );
	
	if ($bannerid) {
		$row->checkout( $my->id );
		if (trim( $row->publish_down ) == "0000-00-00 00:00:00") {
			$row->publish_down = _ABANA_NEVER;
		}
		$event_up = new mosArtBannersXTDDate( $row->publish_up );	        
	        $row->publish_up_date = sprintf( "%04d-%02d-%02d",$event_up->year,$event_up->month,$event_up->day);
	        $row->publish_up_hour = $event_up->hour;
	        $row->publish_up_minute = $event_up->minute;
	     
	        $event_down = new mosArtBannersXTDDate( $row->publish_down );	        
	        $row->publish_down_date = sprintf( "%04d-%02d-%02d",$event_down->year,$event_down->month,$event_down->day);
	        $row->publish_down_hour = $event_down->hour;
	        $row->publish_down_minute = $event_down->minute;
	         		
	} else {
		$row->state = 0;		
		$row->publish_up_date = date( "Y-m-d" );
                $row->publish_down_date = _ABANA_NEVER;
		$row->publish_up_hour = "00";
                $row->publish_up_minute = "00";
                $row->publish_down_hour = "00";
		$row->publish_down_minute = "00";
	}

	HTML_banners::bannerForm( $row, $clist, $tlist, $ilist, $glist, $option );
}

function saveBanner( $option ) {
	global $database, $my;
	
	$_publish_up_date = trim( mosGetParam( $_POST, '_publish_up_date', '0000-00-00' ) );
	$_publish_up_hour= trim( mosGetParam( $_POST, '_publish_up_hour', '00' ) );
	$_publish_up_minute = trim( mosGetParam( $_POST, '_publish_up_minute', '00' ) );
	$_publish_down_date = trim( mosGetParam( $_POST, '_publish_down_date', '0000-00-00' ) );
	$_publish_down_hour= trim( mosGetParam( $_POST, '_publish_down_hour', '00' ) );
	$_publish_down_minute = trim( mosGetParam( $_POST, '_publish_down_minute', '00' ) );      
	$reccurweekdays = mosGetParam( $_POST, 'reccurweekdays', '' );
		
	$row = new mosArtBanner($database);

	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (trim( $row->publish_down ) == "0000-00-00" || trim( $row->publish_down ) == _ABANA_NEVER) {
		$row->publish_down = "0000-00-00 00:00:00";
	}
	
	// assemble the starting time
	if (intval( $_publish_up_date )) {
	    	$dt = "$_publish_up_date $_publish_up_hour:$_publish_up_minute:00";
	} else {
		$dt = date( "Y-m-d 00:00:00" );
	}
	$row->publish_up = strftime( "%Y-%m-%d %H:%M:%S", strtotime( $dt ) );
		
	// assemble the finishing time
	if (intval( $_publish_down_date)) {
	    	$dt = "$_publish_down_date $_publish_down_hour:$_publish_down_minute:00";
	} else {
		$dt = date( "0000-00-00 00:00:00" );
	}
	$row->publish_down = strftime( "%Y-%m-%d %H:%M:%S", strtotime( $dt ) );
	
	if ($row->publish_down < $row->publish_up) {
		$row->publish_down = "0000-00-00 00:00:00";
	}
	
	if ($row->publish_up <> $row->publish_down) {
		$row->reccurtype = intval( $row->reccurtype );                      
	} else {
		$row->reccurtype = 0;                      
	}
        
    // Reccur week days		
	if (!$reccurweekdays) {		
		$row->reccurweekdays = "";
	} else {
		$row->reccurweekdays = implode( ',', $reccurweekdays );
	}

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	$catid = ($_REQUEST['catid']>0)?"&catid=".$_REQUEST['catid']:"";
	mosRedirect( "index2.php?option=$option".$catid );
}

function cancelEditBanner( $option ) {
	global $database;
	$row = new mosArtBanner($database);
	$row->bind( $_POST );
	$row->checkin();
	$catid = ($_REQUEST['catid']>0)?"&catid=".$_REQUEST['catid']:"";
	mosRedirect( "index2.php?option=$option".$catid );
}

function saveUploadNew( $userfile, $userfile_name ) {
	if ((strcasecmp(substr($userfile_name,-4),".gif"))
	&& (strcasecmp(substr($userfile_name,-4),".jpg"))
	&& (strcasecmp(substr($userfile_name,-4),".swf"))) {

		$incorrectType = 1;
		echo "<script> alert('"._ABANA_YCOUGJ."'); window.history.go(-1);</script>\n";
	}

	if ($incorrectType != 1) {
		$base_Dir = "../"._ABXTD_DEFIMGFOLDER."/";

		if (!move_uploaded_file( $userfile, $base_Dir.$userfile_name )) {
			echo sprintf(_ABANA_FAILED_TO_COPY,$userfile_name);
		} else {
			echo "<script> window.opener.document.adminForm.image_url.options[0].text='$userfile_name'; window.opener.document.adminForm.image_url.options[0].value='$userfile_name';</script>";
			echo "<script> window.opener.document.adminForm.image_url.options[selectedIndex]='$userfile_name';</script>";
			echo "<script> window.opener.document.imagelib.src='../"._ABXTD_DEFIMGFOLDER."/$userfile_name';</script>";
			echo "<script> window.opener.document.image_url.focus;</script>";
			echo "<script> window.close(); </script>";
		}
	}
}

function publishBanner( $cid, $publish=1 ,$option )
{
	global $database, $my;
	
	if (!is_array( $cid ) || count( $cid ) < 1) {
		$action = $publish ? _ABANA_L_PUBLISH : _ABANA_L_UNPUBLISH;
		echo "<script> alert('".sprintf(_ABANA_SELECT_ITEM_TO,$action)."'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__artbannersxtd SET state='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosArtBanner( $database );
		$row->checkin( $cid[0] );
	}
	
	$catid = ($_REQUEST['catid']>0)?"&catid=".$_REQUEST['catid']:"";
	mosRedirect( "index2.php?option=$option".$catid );

}

function removeBanner( $cid, $option ) {
	global $database;
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__artbannersxtd WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}
	$catid = ($_REQUEST['catid']>0)?"&catid=".$_REQUEST['catid']:"";
	mosRedirect( "index2.php?option=$option".$catid );
}

function buildReccurTypeSelect($reccurtype, $args) {
    	$recur[] = mosHTML::makeOption( '0', _ABANA_BAN_ALLDAYS );
    	$recur[] = mosHTML::makeOption( '1', _ABANA_BAN_EACHWEEK );
    	//$recur[] = mosHTML::makeOption( '2', _ABANA_BAN_EACHWEEKPAIR );
    	//$recur[] = mosHTML::makeOption( '3', _ABANA_BAN_EACHWEEKIMPAIR );
    	//$recur[] = mosHTML::makeOption( '4', _ABANA_BAN_EACHMONTH );
    	//$recur[] = mosHTML::makeOption( '5', _ABANA_BAN_EACHYEAR );
    	//$recur[] = mosHTML::makeOption( '6', _ABANA_BAN_ONLYDAYS);
    	$tosend = mosHTML::selectList( $recur, 'reccurtype', $args, 'value', 'text', $reccurtype );
    	echo $tosend;		        
}

function buildWeekDaysCheck($reccurweekdays, $args) {
    	$day_name = array(
    			"<span style=\"color:red;\">"._ABANA_BAN_SUN."</span>",
    			_ABANA_BAN_MON,
    			_ABANA_BAN_TUE,
    			_ABANA_BAN_WED,
    			_ABANA_BAN_THU,
    			_ABANA_BAN_FRI,
    			_ABANA_BAN_SAT
    			);    
    	//$weekrepeatdays = array();
    	$tosend = "";
    	if (empty($reccurweekdays)){
        	$split = array();
        	$countsplit = 0;
    	} else {
        	$split = explode(",", $reccurweekdays);
        	$countsplit = count($split);
    	}		
        
    	for($a=0; $a<7; $a++) {   
    		$checked = "";     	    	
        	for ($x = 0; $x < $countsplit; $x++) {	    
	     	if ($split[$x] == $a) {
		    	$checked = "CHECKED";		
	     	}
        	}    	    	              
        	$tosend .= "<input type='checkbox' id='cb_wd".$a."' name='reccurweekdays[]' value='".$a."' ".$args." ".$checked."/>".$day_name[$a]."\n";     
    	}
    	echo $tosend;		        
}

function getLongDayName($daynb) { 
    	if ($daynb == "0") {
        	$dayname = "<span style=\"color:red;\">"._ABANA_BAN_SUNDAY."</span>";
    	} elseif ($daynb == "1") {
        	$dayname = _ABANA_BAN_MONDAY;
    	} elseif ($daynb == "2") {
        	$dayname = _ABANA_BAN_TUESDAY;
    	} elseif ($daynb == "3") {
        	$dayname = _ABANA_BAN_WEDNESDAY;
	} elseif ($daynb == "4") {
        	$dayname = _ABANA_BAN_THURSDAY;
    	} elseif ($daynb == "5") {
        	$dayname = _ABANA_BAN_FRIDAY;
    	} elseif ($daynb == "6") {
        	$dayname = _ABANA_BAN_SATURDAY;
    	}
    	return $dayname;
}


function getShortDayName($daynb) { 
    	if ($daynb == "0") {
        	$dayname = "<span style=\"color:red;\">"._ABANA_BAN_SUN."</span>";
    	} elseif ($daynb == "1") {
        	$dayname = _ABANA_BAN_MON;
    	} elseif ($daynb == "2") {
        	$dayname = _ABANA_BAN_TUE;
    	} elseif ($daynb == "3") {
        	$dayname = _ABANA_BAN_WED;
	} elseif ($daynb == "4") {
        	$dayname = _ABANA_BAN_THU;
    	} elseif ($daynb == "5") {
        	$dayname = _ABANA_BAN_FRI;
    	} elseif ($daynb == "6") {
        	$dayname = _ABANA_BAN_SAT;
    	}
    	return $dayname;
}

// ---------- BANNER CLIENTS ----------

function viewBannerClients( $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}clientslimitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__artbannersxtd_clients" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$sql = "SELECT a.*, count(b.id) AS id, u.name AS editor"
	. "\nFROM #__artbannersxtd_clients AS a"
	. "\nLEFT JOIN #__artbannersxtd AS b ON a.cid = b.cid"
	. "\nLEFT JOIN #__users AS u ON u.id = a.checked_out"
	. "\nGROUP BY a.cid"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit";
	$database->setQuery($sql);

	if(!$result = $database->query()) {
		echo $database->stderr();
		return false;
	}
	$rows = $database->loadObjectList();

	HTML_bannerClient::showClients( $rows, $pageNav, $option );
}

function editBannerClient( $clientid, $option ) {
	global $database, $my;
	$row = new mosArtBannerClient($database);
	$row->load($clientid);

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=$option&task=listclients",
		sprintf(_ABANA_CICBEBAA,$row->title) );
	}

	if ($clientid) {
		// do stuff for existing record
		$row->checkout( $my->id );
	} else {
		// do stuff for new record
		$row->published = 0;
		$row->approved = 0;
	}

	HTML_bannerClient::bannerClientForm( $row, $option );
}

function saveBannerClient( $option ) {
	global $database;

	$row = new mosArtBannerClient( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	mosRedirect( "index2.php?option=$option&task=clients" );
}

function cancelEditClient( $option ) {
	global $database;
	$row = new mosArtBannerClient( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option&task=clients" );
}

function removeBannerClients( $cid, $option ) {
	global $database;

	for ($i = 0; $i < count($cid); $i++) {
		$query = "SELECT COUNT(id) FROM #__artbannersxtd WHERE cid='".$cid[$i]."'";
		$database->setQuery($query);

		if(($count = $database->loadResult()) == null) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}

		if ($count != 0) {
			mosRedirect( "index2.php?option=$option&task=clients",
			_ABANA_CDCATTATHABSR );
		} else {
			/*
			$query="DELETE FROM #__bannerfinish WHERE `cid`='".$cid[$i]."'";
			$database->setQuery($query);
			$database->query();

			$query="DELETE FROM #__artbannersxtd_clients WHERE `cid`='".$cid[$i]."'";
			$database->setQuery($query);
			$database->query();*/
		}
	}
	mosRedirect("index2.php?option=$option&task=clients");
}

// BANNER CATEGORIES

/**
* Compiles a list of com_artbannersxtd for a section
* @param string The name of the category section
* @param string The name of the current user
*/
function showCategories() {
	global $database, $my, $mainframe, $option;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}categorieslimitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__artbannersxtd_categories" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once( "includes/pageNavigation.php" );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$database->setQuery( "SELECT c.*, u.name AS editor, COUNT(DISTINCT b.id) AS banners"
	. "\nFROM #__artbannersxtd_categories AS c"
	. "\nLEFT JOIN #__users AS u ON u.id = c.checked_out"
	. "\nLEFT JOIN #__artbannersxtd AS b ON b.tid = c.id"
	. "\nGROUP BY c.id"
	. "\nORDER BY c.name"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit"
	);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	HTML_bannerCategory::show( $rows, $my->id, $pageNav );
}

/**
* Compiles information to add or edit a category
* @param string The name of the category section
* @param integer The unique id of the category to edit (0 if new)
* @param string The name of the current user
*/
function editCategory( $uid=0 ) {
	global $database, $my;
	global $mosConfig_absolute_path, $mosConfig_live_site;

	$row = new mosArtCategory( $database );
	// load the row from the db table
	$row->load( $uid );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=com_artbannersxtd&task=categories",
		sprintf(_ABANA_TCICBEBAA, $row->title) );
	}

	if ($uid) {
		$row->checkout( $my->id );
	}

	HTML_bannerCategory::edit( $row );
}

/**
* Saves the catefory after an edit form submit
* @param string The name of the category section
*/
function saveCategory() {
	global $database;

	$row = new mosArtCategory( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder();

	mosRedirect( "index2.php?option=com_artbannersxtd&task=categories" );
}
/**
* Deletes one or more com_artbannersxtd from the artbannersxtd_categories table
* @param array An array of unique category id numbers
*/
function removeCategories( $cid ) {
	global $database;

	if (count( $cid ) < 1) {
		echo "<script> alert('"._ABANA_SACTD."'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	
	$database->setQuery( "SELECT c.id, c.name"
	. "\nFROM #__artbannersxtd_categories AS c"
	. "\nWHERE c.id IN ($cids)"
	. "\nGROUP BY c.id"
	);

	if (!($rows = $database->loadObjectList())) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	}

	$err = array();
	$cid = array();
	foreach ($rows as $row) {
		if ($row->numcat == 0) {
			$cid[] = $row->id;
		} else {
			$err[] = $row->name;
		}
	}

	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__artbannersxtd_categories WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	if (count( $err )) {
		$cids = implode( "\', \'", $err );
		mosRedirect( "index2.php?option=com_artbannersxtd&task=categories"
			. "&mosmsg=".urlencode(sprintf(_ABANA_CCBRATCR, $cids))
		);
	}

	mosRedirect( "index2.php?option=com_artbannersxtd&task=categories" );
}

/**
* Publishes or Unpublishes one or more artbannersxtd_categories
* @param integer A unique category id (passed from an edit form)
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
*/
function publishCategories( $categoryid=null, $cid=null, $publish=1 ) {
	global $database, $my;

	if (!is_array( $cid )) {
		$cid = array();
	}
	if ($categoryid) {
		$cid[] = $categoryid;
	}

	if (count( $cid ) < 1) {
		$action = $publish ? _ABANA_SACT_PUB : _ABANA_SACT_UNPUB;
		echo "<script> alert('".sprintf(_ABANA_SACT, $action)."'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__artbannersxtd_categories SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosArtCategory( $database );
		$row->checkin( $cid[0] );
	}

	mosRedirect( "index2.php?option=com_artbannersxtd&task=categories" );
}

/**
* Cancels an edit operation
*/
function cancelCategory() {
	global $database;
	$row = new mosArtCategory( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=com_artbannersxtd&task=categories" );
}

// OTHER	

function showInformation() {
	HTML_bannersOther::showInformation();
}
?>