<?php
/*
// "AllVideos" Plugin by JoomlaWorks for Joomla! 1.0.x - Version 2.5.2
// Copyright (c) 2006 - 2008 JoomlaWorks, a Komrade LLC company. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// *** Last update: August 3rd, 2008 ***
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

// Trigger the plugin
$_MAMBOTS->registerFunction( "onPrepareContent" , "jwAllVideos" );

function jwAllVideos( $published, &$row, &$params, $page=0 ) {

	// JoomlaWorks reference parameters
	$plg_name				= "jw_allvideos";
	$plg_tag				= "";
	$plg_copyrights_start	= "\n\n<!-- JoomlaWorks \"AllVideos\" Plugin (v2.5.2) starts here -->\n";
	$plg_copyrights_end		= "\n<!-- JoomlaWorks \"AllVideos\" Plugin (v2.5.2) ends here -->\n\n";

	// Globals
	global $database, $_MAMBOTS, $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_lang, $mainframe, $option, $task, $Itemid, $my, $_VERSION;
	
	// Includes
	include($mosConfig_absolute_path."/mambots/content/jw_allvideos/jw_allvideos_sources.php");
	
	// simple performance check to determine whether plugin should process further
	if (preg_match('/(?:'.implode(array_keys($tagReplace),'|').')/i',$row->text)==false) {
		return true;
	}

	// check if a parameters query has previously been processed
	if ( !isset($_MAMBOTS->_content_mambot_params[$plg_name]) ) {
		// load plugin params info
		$query = "SELECT params"
		. "\n FROM #__mambots"
		. "\n WHERE element = '$plg_name'"
		. "\n AND folder = 'content'"
		;
		$database->setQuery( $query );
		$database->loadObject($mambot);

		// save query to class variable
		$_MAMBOTS->_content_mambot_params[$plg_name] = $mambot;
	}

	// pull query data from class variable
	$mambot = $_MAMBOTS->_content_mambot_params[$plg_name];
	
	// Parameters
	$pluginParams = new mosParameters( $mambot->params );

	// general
	$av_template			= $pluginParams->def('av_template','default');
	$av_compressjs			= $pluginParams->def('av_compressjs',0);
	$av_useinmodules		= $pluginParams->def('av_useinmodules',0);
	// video
	$vfolder 				= $pluginParams->def('video_folder','images/stories/videos');
	$vwidth 				= $pluginParams->def('vwidth',400);
	$vheight 				= $pluginParams->def('vheight',300);
	// audio
	$afolder 				= $pluginParams->def('audio_folder','images/stories/audio');
	$awidth 				= $pluginParams->def('awidth',300);
	$aheight 				= $pluginParams->def('aheight',20);
	// global
	$autoplay 				= ($pluginParams->def('autoplay',0)) ? 'true' : 'false';
	$transparency 			= $pluginParams->def('video_transparency','transparent');
	$background 			= $pluginParams->def('video_bg','');
	// FLV playback
	$av_flvcontroller 		= $pluginParams->def('av_flvcontroller','bottom');
	
	if($av_flvcontroller == "over"){
		$av_flvcontroller = "&controlbar=over";
	} else {
		$av_flvcontroller = "";
	}
	
	// check whether plugin has been unpublished
	if (!$published) {
	
		foreach ($tagReplace as $plg_tag => $value) {
			$regex = "#{".$plg_tag."}(.*?){/".$plg_tag."}#s";
			$row->text = preg_replace( $regex, "", $row->text );
		}
		return true;
		
	} else {
	
		// add CSS/JS to the head
		static $loadJWAVcss;
		if(!$loadJWAVcss) {
			$loadJWAVcss=1;
			if($av_useinmodules){
			$jwavhead = '
	<script language="javascript" type="text/javascript">
	<!--
	var jwAllVideosCSS = \'<\' + \'style type="text/css" media="all">\'
	+ \'@import "'.$mosConfig_live_site.'/mambots/content/jw_allvideos/templates/'.$av_template.'/template_css.css";\'
	+ \'</\' + \'style>\';
	document.write(jwAllVideosCSS);
	-->
	</script>
			';			
			} else {
			$jwavhead = '
	<style type="text/css" media="all">
		@import "'.$mosConfig_live_site.'/mambots/content/jw_allvideos/templates/'.$av_template.'/template_css.css";
	</style>
			';			
			}
			if($av_compressjs){
			$jwavhead .= '
	<script type="text/javascript" src="'.$mosConfig_live_site.'/mambots/content/jw_allvideos/players/jw_allvideos_scripts.php"></script>
			';
			} else {
			$jwavhead .= '
	<script type="text/javascript" src="'.$mosConfig_live_site.'/mambots/content/jw_allvideos/players/silverlight.js"></script>
	<script type="text/javascript" src="'.$mosConfig_live_site.'/mambots/content/jw_allvideos/players/wmvplayer.js"></script>
	<script type="text/javascript" src="'.$mosConfig_live_site.'/mambots/content/jw_allvideos/players/AC_QuickTime.js"></script>
			';
			}
			// cache/module check
			if($mainframe->getCfg('caching') && ($option=='com_frontpage' || $option=='')) {
				echo $plg_copyrights_start.$jwavhead.$plg_copyrights_end;
			} elseif ($av_useinmodules){
				echo $plg_copyrights_start.$jwavhead.$plg_copyrights_end;
			} else {
				$mainframe->addCustomHeadTag($plg_copyrights_start.$jwavhead.$plg_copyrights_end);
			}
		}	
	
	}

	// START ALLVIDEOS LOOP	
	foreach ($tagReplace as $plg_tag => $value) {
		// expression to search for
		$regex = "#{".$plg_tag."}(.*?){/".$plg_tag."}#s";			
		// process tags
		if (preg_match_all($regex, $row->text, $matches, PREG_PATTERN_ORDER) > 0) {
			// start the replace loop
			foreach ($matches[0] as $key => $match) {
			
				$tagcontent 	= preg_replace("/{.+?}/", "", $match);
				$tagparams 		= explode('|',$tagcontent);
				$tagsource 		= $tagparams[0];
				$final_vwidth 	= (@$tagparams[1]) ? $tagparams[1] : $vwidth;
				$final_vheight 	= (@$tagparams[2]) ? $tagparams[2] : $vheight;
								
				// replacements
				$findAVparams = array(
					"{AVSOURCE}",
					"{VFOLDER}",
					"{VWIDTH}",
					"{VHEIGHT}",
					"{AFOLDER}",
					"{AWIDTH}",
					"{AHEIGHT}",		
					"{AUTOPLAY}",
					"{TRANSPARENCY}",
					"{BACKGROUND}",
					"{CONTROLBAR}",
				);
				
				// special treatment
				if($plg_tag=="yahoo"){
					$tagsourceyahoo = explode('/',$tagsource);
					$tagsource = 'id='.$tagsourceyahoo[1].'&amp;vid='.$tagsourceyahoo[0];
				}
				if($plg_tag=="youku"){
					$tagsource = substr($tagsource,3);
				}				
				
				$replaceAVparams = array(
					$tagsource,
					$vfolder,
					$final_vwidth,
					$final_vheight,
					$afolder,
					$awidth,
					$aheight,
					$autoplay,
					$transparency,
					$background,
					$av_flvcontroller,
				);
				
				// wrap HTML around players
				$wrapstart = $plg_copyrights_start.'<span class="allvideos">';
				$wrapend = '</span>'.$plg_copyrights_end;

				$plg_html = ampReplace($wrapstart.str_replace($findAVparams, $replaceAVparams, $tagReplace[$plg_tag]).$wrapend);
								
				// Do the replace
				$row->text = preg_replace("#{".$plg_tag."}".preg_quote($tagcontent)."{/".$plg_tag."}#s", $plg_html, $row->text);

			} // end foreach

		} // end if
	
	} // END ALLVIDEOS LOOP	

} // END FUNCTION

?>