<?php 
/*
// "Disqus" Plugin by JoomlaWorks for Joomla! 1.5.x - Version 1.1
// Copyright (c) 2006 - 2008 JoomlaWorks, a Komrade LLC company.
// License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
// More info at http://www.joomlaworks.gr
// Designed and developed by JoomlaWorks
// ***Last update: June 26th, 2008***
*/

// no direct access 
defined('_JEXEC') or die('Restricted access'); 

require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
 
$mainframe->registerEvent( 'onBeforeDisplayContent', 'plgJWDisqus_onBeforeDisplayContent'); 
$mainframe->registerEvent( 'onAfterDisplayContent', 'plgJWDisqus_onAfterDisplayContent'); 

/** just before content is output, returns output to be displayed */ 
function plgJWDisqus_onBeforeDisplayContent( &$row, &$params, $limitstart ){

	global $mainframe;
	$db			=& JFactory::getDBO();
	$user		=& JFactory::getUser();
	$userId		= (int) $user->get('id');       
	$aid		= $user->get('aid', 0);
	$mosConfig_absolute_path = JPATH_SITE;
	$mosConfig_live_site = JURI :: base();
	if(substr($mosConfig_live_site, -1)=="/") { $mosConfig_live_site = substr($mosConfig_live_site, 0, -1); }

	if($_REQUEST['view']=='article'){
		return '
		<div class="disqus_jumptocomments">
			<a href="'.$_SERVER['REQUEST_URI'].'#disqus_thread">View Comments</a>
		</div>
		';
	}
	
}

/** just after content is output, returns output to be displayed */ 
function plgJWDisqus_onAfterDisplayContent( &$row, &$params, $limitstart ){

	global $mainframe;
	$db			=& JFactory::getDBO();
	$user		=& JFactory::getUser();
	$userId		= (int) $user->get('id');       
	$aid		= $user->get('aid', 0);
	
	$mosConfig_absolute_path = JPATH_SITE;
	$mosConfig_live_site = JURI :: base();
	if(substr($mosConfig_live_site, -1)=="/") { $mosConfig_live_site = substr($mosConfig_live_site, 0, -1); }
	
	
	// Get plugin params
	$plugin =& JPluginHelper::getPlugin('content', 'jw_disqus');
	$pluginParams = new JParameter( $plugin->params );	
	$disqus_user = $pluginParams->def('disqus_user','');
	$disqus_showfront = $pluginParams->def('disqus_showfront',1);
	$disqus_showcss = $pluginParams->def('disqus_showcss',1);
	$disqus_template = $pluginParams->def('disqus_template','default');
	
	// Get the page/component configuration and article parameters
	$row->params = clone($params);
	$aparams = new JParameter($row->attribs);

	// Merge article parameters into the page configuration
	$row->params->merge($aparams);

	// Build the link and text of the readmore button
	if (($row->params->get('show_readmore') && @ $row->readmore) || $row->params->get('link_titles')){
		// checks if the item is a public or registered/special item
		if ($row->access <= $user->get('aid', 0)){

			$row->readmore_link = JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid));
			$row->readmore_register = false;
		} else {
			$row->readmore_link = JRoute::_("index.php?option=com_user&task=register");
			$row->readmore_register = true;
		}
	}
	
	// CSS
	$headIncludes = "
<!-- JoomlaWorks \"Disqus\" Plugin (v1.1) starts here -->
<style type=\"text/css\" media=\"all\">
	@import \"{$mosConfig_live_site}/plugins/content/jw_disqus/templates/{$disqus_template}/template.css\";
</style>
<!-- JoomlaWorks \"Disqus\" Plugin (v1.1) starts here -->
	";
	if($disqus_showcss){
		plgAddToHeadOnce($headIncludes);
	}
	
	$counterscript = '
	<script type="text/javascript">
		//<![CDATA[
		(function() {
			var links = document.getElementsByTagName(\'a\');
			var query = \'?\';
			for(var i = 0; i < links.length; i++) {
				if(links[i].href.indexOf(\'#disqus_thread\') >= 0) {
					query += \'url\' + i + \'=\' + encodeURIComponent(links[i].href) + \'&\';
				}
			}
			document.write(\'<\' + \'script type="text/javascript" src="http://disqus.com/forums/'.$disqus_user.'/get_num_replies.js\' + query + \'"></\' + \'script>\');
		})();
		//]]>
	</script>
	';

	// OUTPUT
	if($_REQUEST['view']=='article'){
	
		return '
		<div id="disqus_thread"></div>
		<script type="text/javascript" src="http://disqus.com/forums/'.$disqus_user.'/embed.js"></script>
		<noscript>
			<a href="http://'.$disqus_user.'.disqus.com/?url=ref">View the forum thread.</a>
		</noscript>
		<div class="disqus_credits"><a href="http://disqus.com" class="dsq-brlink">blog comments powered by <span class="logo-disqus">Disqus</span></a></div>
		';
		
	} elseif(isset($row->readmore_link) && $disqus_showfront) {

		return '
		<div class="disqus_readmore">
			<a href="'.$row->readmore_link.'#disqus_thread">View Comments</a>
		</div>
		';

	}

}



/* ------------ Additional functions ------------ */

function plgAddToHeadOnce($plg_head){
	global $mainframe;
	static $plgJSandCSS;
	if(!$plgJSandCSS) {
		$plgJSandCSS=1;
		$mainframe->addCustomHeadTag($plg_head);
	}
}

?>