<?php
/*
// JoomlaWorks "Extended Cache" Plugin for Joomla! 1.5.x - Version 1.1
// Copyright (c) 2006 - 2010 JoomlaWorks, a business unit of Nuevvo Webware Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// *** Last update: May 24th, 2010 ***
*/

/* TO DO
- use list of excluded components



*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');

class plgSystemJw_extendedcache extends JPlugin {

	// Reference parameters
	var $pluginName 						= 'jw_extendedcache';
  var $pluginCopyrightsStart  = "\n\n<!-- JoomlaWorks \"Extended Cache\" Plugin (v1.1) starts here -->\n";
  var $pluginCopyrightsEnd    = "\n<!-- JoomlaWorks \"Extended Cache\" Plugin (v1.1) ends here -->\n\n";
  
	var $_cache = null;

	function plgSystemJw_extendedcache(& $subject, $config){
		parent::__construct($subject, $config);
	
		// Set the language in the class
		$config =& JFactory::getConfig();
		$options = array(
			'cachebase' => JPATH_BASE.DS.'cache',
			'defaultgroup' => 'page',
			'lifetime' => $this->params->get('cachetime', 15) * 60,
			'browsercache' => $this->params->get('browsercache', false),
			'caching' => false,
			'language' => $config->getValue('config.language', 'en-GB')
		);
	
		jimport('joomla.cache.cache');
		$this->_cache =& JCache::getInstance( 'page', $options );
	}

	// Converting the site URL to fit to the HTTP request
	function onAfterInitialise(){
	
		// API
		$mainframe = &JFactory::getApplication();
		$user = &JFactory::getUser();
		global $_PROFILER;
		
		// Requests
		$option = JRequest::getCmd('option');
		$view = JRequest::getCmd('view');

		// Admin/debug etc. check
		if($mainframe->isAdmin() || JDEBUG || count($mainframe->getMessageQueue()) ) {
			return;
		}

		if (!$user->get('aid') && $_SERVER['REQUEST_METHOD'] == 'GET' && JRequest::getCmd('option')!='com_contact') {
			$this->_cache->setCaching(true);
		}

		$data = $this->_cache->get();

		if($data !== false){
			// the following code searches for a token in the cached page and replaces it with the proper token.
			$token	= JUtility::getToken();
			$search = '#<input type="hidden" name="[0-9a-f]{32}" value="1" />#';
			$replacement = '<input type="hidden" name="'.$token.'" value="1" />';
			$data = preg_replace( $search, $replacement, $data );
			$data = $this->cdnReplacements($data)."\n<!-- CDN replacements (onAfterInitialise) -->";
			JResponse::setBody($data);
			echo JResponse::toString($mainframe->getCfg('gzip'));

			if(JDEBUG){
				$_PROFILER->mark('afterCache');
				echo implode('',$_PROFILER->getBuffer());
			}

			$mainframe->close();
		}
	}

	function onAfterRender(){
	
		// API
		$mainframe = &JFactory::getApplication();
		$user = &JFactory::getUser();
		
		// Requests
		$option = JRequest::getCmd('option');
		$view = JRequest::getCmd('view');
		$task = JRequest::getCmd('task');
		$itemid = JRequest::getInt('Itemid');
		
		// Components that should not be cached
		$noCacheComponents = array(
			'com_user',
			'com_contact',
		);

		// Admin check
		if($mainframe->isAdmin() || JDEBUG) {
			return;
		}
		
		// Prepare output
		$buffer = JResponse::getBody();
		$buffer = $this->cdnReplacements($buffer);
		if(JRequest::getCmd('format')!='csv') $buffer .= "\n <!-- CDN replacements  (onAfterRender) -->";
		JResponse::setBody($buffer);

		// We need to check again here, because auto-login plugins have not been fired before the first aid check
		if($user->get('aid') && in_array($option,$noCacheComponents)) {
			// do nothing
		} else {
			$this->_cache->store();
		}
		
	}
	
	function cdnReplacements($data){

		// API
    $mainframe= &JFactory::getApplication();
		$document = &JFactory::getDocument();
				
		// Assign paths
    $sitePath = JPATH_SITE;
    $siteUrl  = substr(JURI::root(), 0, -1);
    
		// Requests
		$option = JRequest::getCmd('option');
		$view = JRequest::getCmd('view');
		$task = JRequest::getCmd('task');
        
    // Parameters
		$plugin =& JPluginHelper::getPlugin('system',$this->pluginName);
		$pluginParams = new JParameter( $plugin->params );

		/* Selections */
		$originDomain	= $pluginParams->get('originDomain');
		$cdnDomain		= $pluginParams->get('cdnDomain');
		
		if(substr($cdnDomain,0,4)=='www.') $cleanDomain = str_replace('www.','',$cdnDomain);

		/* Replacement arrays */
		$originReplacements = array(
			'http://'.$cleanDomain,
			'"/'.$cleanDomain.'/',
			'http://'.$originDomain,
			'"http://'.$originDomain,
			'http%3A%2F%2F'.$originDomain,
			'http%3A%2F%2F'.$cdnDomain.'%2F'.$cleanDomain,
		);
		
		$cdnReplacements = array(
			'http://'.$cdnDomain,
			'"/',
			'http://'.$cdnDomain,
			'"http://'.$cdnDomain,
			'http%3A%2F%2F'.$cdnDomain,
			'http%3A%2F%2F'.$cdnDomain,
		);
		
		$replace = str_replace($originReplacements,$cdnReplacements,$data);
		
		return $replace;

	}
	
} // Class end
