<?php
/**
 * @version		1.0
 * @package		JSON Feeds
 * @author    JoomlaWorks http://www.joomlaworks.gr
 * @copyright	Copyright (c) 2006 - 2011 JoomlaWorks, a business unit of Nuevvo Webware Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');

class plgSystemJw_jsonfeeds extends JPlugin {

	// Reference parameters
	var $plgName 						= 'jw_jsonfeeds';
  var $plgCopyrightsStart	= "\n\n<!-- JoomlaWorks \"JSON Feeds\" Plugin (v1.0) starts here -->\n";
  var $plgCopyrightsEnd		= "\n<!-- JoomlaWorks \"JSON Feeds\" Plugin (v1.0) ends here -->\n\n";

  function plgSystemJw_jsonfeeds(&$subject, $config) {
    parent::__construct($subject, $config);
  }
  
  function onAfterDispatch() {
  	
		// API
    $mainframe= &JFactory::getApplication();
		$document = &JFactory::getDocument();
		
		// Make sure we are in a frontend feed formatted request & debugging is off
		if($document->getType() == 'feed' || $mainframe->isAdmin() || JDEBUG) return;

    // Check if plugin is enabled
    if(JPluginHelper::isEnabled('system',$this->plgName)==false) return;
    
    // Parameters
		$plugin =& JPluginHelper::getPlugin('system',$this->plgName);
		$pluginParams = new JParameter( $plugin->params );
		$secretWord		= $pluginParams->get('secretWord','');
		
		// Determine the JSON feed URL
		if(!$secretWord && count($document->_links)){
			$uri =& JURI::getInstance();
			if($mainframe->getCfg('sef')==1){
				$getCurrentURL = $uri->_path.'?format=feed&amp;export=json';
			} else {
				if(substr($uri->_uri,-1,1)=='/' || substr($uri->_uri,-4,4)=='.php'){
					$getCurrentURL = $uri->_path.'?format=feed&amp;export=json';
				} else {
					$getCurrentURL = JFilterOutput::ampReplace($uri->_path).'&amp;format=feed&amp;export=json';
				}
			}
						
			// Create the <link> elements
			$jsonPseudoHeadLink = '<link href="'.$getCurrentURL.'" rel="alternate" type="application/rss+xml" title="JSON feed for '.$document->title.'"';
			$jsonHeadLink = '<link href="'.$getCurrentURL.'" rel="alternate" type="application/json" title="JSON feed for '.$document->title.'"';
			
			// Output
			array_push($document->_links,$jsonPseudoHeadLink);
			array_push($document->_links,$jsonHeadLink);

		}
  	
  }

	function onAfterRender() {

		// API
    $mainframe= &JFactory::getApplication();
		$document = &JFactory::getDocument();

		// Make sure we are in a frontend feed formatted request & debugging is off
		if($document->getType() != 'feed' || $mainframe->isAdmin() || JDEBUG) return;

    // Check if plugin is enabled
    if(JPluginHelper::isEnabled('system',$this->plgName)==false) return;

		// Load the plugin language file the proper way
		JPlugin::loadLanguage('plg_system_'.$this->plgName, JPATH_ADMINISTRATOR);

		// Requests
		$format	= JRequest::getCmd('format');
		$export	= JRequest::getCmd('export');
		$secret	= JRequest::getCmd('secret');

    // Parameters
		$plugin =& JPluginHelper::getPlugin('system',$this->plgName);
		$pluginParams = new JParameter( $plugin->params );

		$cbFunction					= $pluginParams->get('cbFunction','');
		$useHourlyTimestamp = $pluginParams->get('useHourlyTimestamp',1);
		$maxAge							= (int) $pluginParams->get('maxAge','');
		$secretWord					= $pluginParams->get('secretWord','');

		// Output
		if($format=='feed' && $export=='json' && $secret==$secretWord){
			$uri =& JURI::getInstance();
			$feedUrl = $uri->_uri;
			if($useHourlyTimestamp){
				$feedUrl.= '?t='.date('YmdH');
			}

			$yqlUrl = 'http://query.yahooapis.com/v1/public/yql?q='.urlencode('SELECT * FROM feed WHERE url="'.$feedUrl.'"').'&format=json';
			if($maxAge){
				$yqlUrl .= '&_maxage='.$maxAge;
			}
			$yqlUrl .= '&callback='.urlencode($cbFunction);

			header('Location: '.$yqlUrl);
			exit;
		}

	}

} // Class end
