<?php
/**
 * @version		1.0
 * @package		Tidy
 * @author    JoomlaWorks http://www.joomlaworks.gr
 * @copyright	Copyright (c) 2006 - 2011 JoomlaWorks, a business unit of Nuevvo Webware Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');

class plgSystemJw_tidy extends JPlugin {

	// Reference parameters
	var $plgName 						= 'jw_tidy';
  var $plgCopyrightsStart	= "\n\n<!-- JoomlaWorks \"Tidy\" Plugin (v1.0) starts here -->\n";
  var $plgCopyrightsEnd		= "\n<!-- JoomlaWorks \"Tidy\" Plugin (v1.0) ends here -->\n\n";

  function plgSystemJw_tidy(&$subject, $config) {
    parent::__construct($subject, $config);
  }

	function onAfterInitialise(){

		// API
    $mainframe= &JFactory::getApplication();

		// Run the check only in the frontend or when debugging is on
		if($mainframe->isAdmin() || JDEBUG) return;
		    
		if(!class_exists('tidy')){
			JError::raiseNotice('',JText::_("The Tidy system plugin cannot be executed because your server's PHP version is either old or Tidy is not compiled into PHP. You should disable the plugin."));
			return;
		}
	}

	function onAfterRender() {
	
		// Check if Tidy is compiled with PHP
		if(!class_exists('tidy')) return;
	
		// API
    $mainframe= &JFactory::getApplication();
		$document = &JFactory::getDocument();

		// Make sure we are in a frontend HTML formatted request & debugging is off
		if($document->getType() != 'html' || $mainframe->isAdmin() || JDEBUG) return;

    // Check if plugin is enabled
    if(JPluginHelper::isEnabled('system',$this->plgName)==false) return;

		// Load the plugin language file the proper way
		JPlugin::loadLanguage('plg_system_'.$this->plgName, JPATH_ADMINISTRATOR);

    // Parameters
		$plugin =& JPluginHelper::getPlugin('system',$this->plgName);
		$pluginParams = new JParameter( $plugin->params );

		$indent 				= $pluginParams->get('indent',1);
		$wrap 					= (int) $pluginParams->get('wrap',0);
		$altText 				= $pluginParams->get('altText','Image');
		$hideComments 	= $pluginParams->get('hideComments',0);
		$cdataIndent 		= $pluginParams->get('cdataIndent',0);
		$breakBeforeBr 	= $pluginParams->get('breakBeforeBr',1);

		// Specify Tidy configuration
		$tidyConfig = array(
			'output-xhtml'		=> true,
			'doctype'					=> 'transitional',
			'indent'					=> $indent,
			'indent-spaces'		=> 4,
			'wrap'						=> $wrap,
			'alt-text'				=> $altText,
			'hide-comments' 	=> $hideComments,
			'indent-cdata'		=> $cdataIndent,
			'break-before-br' => $breakBeforeBr
		);
	
		// Output
		$buffer = JResponse::getBody();
		$tidy = new tidy;
		$tidy->parseString($buffer, $tidyConfig, 'utf8');
		$tidy->cleanRepair();
		$tidy = $tidy."\n<!-- JoomlaWorks \"Tidy\" Plugin (v1.0) -->";

		JResponse::setBody($tidy);

	}

} // Class end
