<?php 
/*
// JoomlaWorks "UberPageBreak" Plugin for Joomla! 1.5.x - Version 1.0
// Copyright (c) 2006 - 2010 JoomlaWorks, a business unit of Nuevvo Webware Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: June 25th, 2010***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.plugin.plugin' );

class plgContentUberPageBreak extends JPlugin {

  // JoomlaWorks reference parameters
	var $plg_name								= "UberPageBreak";
	var $plg_copyrights_start		= "\n\n<!-- JoomlaWorks \"UberPageBreak\" Plugin (v1.0) starts here -->\n";
	var $plg_copyrights_end			= "\n<!-- JoomlaWorks \"UberPageBreak\" Plugin (v1.0) ends here -->\n\n";
		
	function plgContentUberPageBreak( &$subject, $params ){
		parent::__construct( $subject, $params );
	}
	
	function onPrepareContent( &$row, &$params, $page=0 ){
		
		// API
    $mainframe	= &JFactory::getApplication();
		$document 	= &JFactory::getDocument();
		$db					= &JFactory::getDBO();
		
		// Requests
		$option 		= JRequest::getCmd('option');
		$view 			= JRequest::getCmd('view');
		$layout 		= JRequest::getCmd('layout');
		$itemid 		= JRequest::getInt('Itemid');
		$print   		= JRequest::getBool('print');
		$limitstart = JRequest::getInt('limitstart',0);
		$showall 		= JRequest::getInt('showall',0);
		if(!$page) $page = 0;
				
		// Assign paths
    $sitePath = JPATH_SITE;
    $siteUrl  = substr(JURI::root(), 0, -1);
    
    // Check if plugin is enabled
    if(JPluginHelper::isEnabled('content',$this->plg_name)==false) return;
    
		// Load the plugin language file the proper way
		JPlugin::loadLanguage('plg_content_'.$this->plg_name, JPATH_ADMINISTRATOR);

		// Simple performance checks to determine whether plugin should process further
	  if(strpos($row->text,'class="system-pagebreak')===false && strpos($row->text,'class=\'system-pagebreak')===false){
	  	return true;
	  }
	  
	  // Expression to search for
		$regex = '#<hr([^>]*?)class=(\"|\')system-pagebreak(\"|\')([^>]*?)\/*>#iU';
			  
		if($params->get('intro_only') || $params->get('popup') || ($view!= 'article' && $view!='item')){
			$row->text = preg_replace($regex,'',$row->text);
			return;
		}
		
		// For K2
		if($option=='com_k2'){
			if(!empty($row->fulltext)){
				$row->text = $row->fulltext;
			} else {
				$row->text = $row->introtext;
			}
		}
		
		// Clear pagebreak tags on print page
		if(JRequest::getInt('print')){
			$row->text = preg_replace($regex,'<br />',$row->text);
			return;
		}
		


		// ----------------------------------- Get plugin parameters -----------------------------------
		
		// Get Plugin info
		$plugin =& JPluginHelper::getPlugin('content',$this->plg_name);
		$pluginParams = new JParameter( $plugin->params );
		
		$pluginTemplate = $pluginParams->get('pluginTemplate','Default'); // to add to XML: Default or Tabs incl. on-the-fly MVC

		$ubpPageTitle		= $pluginParams->get('ubpPageTitle',1);
		$ubpTOC 				= $pluginParams->get('ubpTOC',1);
		$ubpNavigation 	= $pluginParams->get('ubpNavigation',1);
		$ubpAllPagesLink= $pluginParams->get('ubpAllPagesLink',1);
		$ubpPageCounter = $pluginParams->get('ubpPageCounter',1);

		// Includes
		require_once(dirname(__FILE__).DS.$this->plg_name.DS.'includes'.DS.'helper.php');



		// ----------------------------------- Head includes -----------------------------------
		$pluginCSS 		= UberPageBreakHelper::getTemplatePath($this->plg_name,'css/template.css',$pluginTemplate);
		$pluginCSS 		= $pluginCSS->http;
		$headIncludes = '
<style type="text/css" media="all">
	@import "'.$pluginCSS.'";
</style>
		';



		// ----------------------------------- Prepare the output -----------------------------------
		
		// Find all instances of plugin and put in $matches
		$matches = array();
		preg_match_all($regex, $row->text, $matches, PREG_SET_ORDER);

		// Split the text around the plugin
		$text = preg_split($regex, $row->text);
	
		// Count the number of pages
		$n = count($text);

		// We have found at least one plugin instance, therefore at least 2 pages
		if($n > 1){
		
			$output = new JObject;
			
			// TOC header title
			$output->headerTitle = $row->title;
			
			// Set the page title
			if($ubpPageTitle && $page){
				$page_text = $page + 1;
				if($page && @$matches[$page-1][2]){
					$attrs = JUtility::parseAttributes($matches[$page-1][0]);
					if(@$attrs['title']){
						$row->title = $row->title.' - '.$attrs['title'];
					} else {
						$thispage = $page + 1;
						$row->title = $row->title.' - '.JText::_( 'Page' ).' '.$thispage;
					}
				}
			}
			
			// TOC header link
			$output->headerLink = JRoute::_('&showall=&limitstart=');
			
			// TOC header active class
			$output->headerActiveClass = ($limitstart === 0 && $showall === 0) ? true : false;
			
			$i = 2;
			foreach($matches as $key=>$match){
			
				$key = $key + 1;
				
				$output->links[$key] = new JObject;
			
				// TOC page link
				$output->links[$key]->pagelink = JRoute::_('&showall=&limitstart='.($i-1));
				
				// TOC page title
				if(@$match[0]){
					$attrs2 = JUtility::parseAttributes($match[0]);
					if(@$attrs2['alt']){
						$title = stripslashes($attrs2['alt']);
					} elseif(@$attrs2['title']) {
						$title = stripslashes($attrs2['title']);
					} else {
						$title = JText::sprintf('Page #',$i);
					}
				} else {
					$title = JText::sprintf('Page #',$i);
				}
				$output->links[$key]->title = $title;
				
				// TOC page active & odd/even classes
				$output->links[$key]->linkActiveClass = ($limitstart == $i-1) ? true : false;
				$output->links[$key]->linkOddOrEvenClass = ($key%2) ? 'odd' : 'even';
				
				$i++;
			}
			
			// TOC footer link
			$output->footerLink = JRoute::_('&showall=1&limitstart=');
			
			// TOC footer active class
			$output->footerActiveClass = ($showall == 1) ? true : false;

			// Article text - we clean it up from the plugin tags on each created page
			$output->text[$page] = str_replace("<hr id=\"\"system-readmore\"\" />", "", $text[$page]);
						
			// Page navigation
			jimport('joomla.html.pagination');
			$pageNavigation = new JPagination($n, $page, 1);
		
			// Page counter
			$output->pageCounter = $pageNavigation->getPagesCounter();

			// Page navigation links
			$output->navPageLinks = $pageNavigation->getPagesLinks();

			// Prev/Next navigation links
			if($page<$n-1 && !$showall){
				$page_next = $page + 1;
				$output->navNextLink = JRoute::_('&limitstart='.$page_next);
				$output->navNextText = JText::_('Next').' '.JText::_('&gt;&gt;');
			} else {
				$output->navNextLink = '';
				$output->navNextText = JText::_('Next');
			}
		
			if($page>0 && !$showall){
				$page_prev = ($page - 1 == 0) ? "" : $page - 1;
				$output->navPrevLink = JRoute::_('&limitstart='.$page_prev);
				$output->navPrevText = JText::_('&lt;&lt;').' '.JText::_('Prev');
			} else {
				$output->navPrevLink = '';
				$output->navPrevText = JText::_('Prev');
			}
			
			
			
			// ----------------------------------- Render the output -----------------------------------

			// Load the head includes
			//UberPageBreakHelper::loadHeadIncludes($this->plg_copyrights_start.$headIncludes.$this->plg_copyrights_end);
			//$document->addCustomTag($this->plg_copyrights_start.$headIncludes.$this->plg_copyrights_end);
			$document->addStyleSheet($pluginCSS);

			// Set the "all pages" output
			if($showall && $ubpAllPagesLink){
				$page = 1;
				$output->pageText = preg_replace($regex,'<br />', $row->text);
			} else {
				$output->pageText = $output->text[$page];
			}
			
			// Fetch the template
			ob_start();
			$getTemplatePath = UberPageBreakHelper::getTemplatePath($this->plg_name,'default.php',$pluginTemplate);
			$getTemplatePath = $getTemplatePath->file;
			include($getTemplatePath);
			$getTemplate = $this->plg_copyrights_start.ob_get_contents().$this->plg_copyrights_end;
			ob_end_clean();
			
			// Do the replace
			if($option=='com_k2'){
				if(!empty($row->fulltext)){
					$row->text = $row->introtext.'{K2Splitter}'.$getTemplate;
				} else {
					$row->text = $getTemplate;
				}
			} else {
				$row->text = $getTemplate;
			}
			
		}

	}

} // End class



/**
* LEGEND: Page break plugin
*
* <b>Usage:</b>
* <code><hr class="system-pagebreak" /></code>
* <code><hr class="system-pagebreak" title="The page title" /></code>
* or
* <code><hr class="system-pagebreak" alt="The first page" /></code>
* or
* <code><hr class="system-pagebreak" title="The page title" alt="The first page" /></code>
* or
* <code><hr class="system-pagebreak" alt="The first page" title="The page title" /></code>
*
*/
