<?php 
/*
// JoomlaWorks "UberPageBreak" Plugin for Joomla! 1.5.x - Version 1.0
// Copyright (c) 2006 - 2010 JoomlaWorks, a business unit of Nuevvo Webware Ltd. All rights reserved.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: June 25th, 2010***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class UberPageBreakHelper {

	// Load Includes
	function loadHeadIncludes($headIncludes){
		global $loadPageBreakForK2Includes;
		$document = &JFactory::getDocument();
		if(!$loadPageBreakForK2Includes){
			$loadPageBreakForK2Includes=1;
			$document->addCustomTag($headIncludes);
		}
	}
	
	// Load Module Position
	function loadModulePosition( $position, $style='' ){
		$document	= &JFactory::getDocument();
		$renderer	= $document->loadRenderer('module');
		$params		= array('style'=>$style);
	
		$contents = '';
		foreach (JModuleHelper::getModules($position) as $mod){
			$contents .= $renderer->render($mod, $params);
		}
		return $contents;
	}
	
	// Word Limiter
	function wordLimiter($str,$limit=100,$end_char='&#8230;'){
		if (trim($str) == '') return $str;
		$str = strip_tags($str);
		preg_match('/\s*(?:\S*\s*){'. (int) $limit .'}/', $str, $matches);
		if (strlen($matches[0]) == strlen($str)) $end_char = '';
		return rtrim($matches[0]).$end_char;
	}

	// Path overrides
	function getTemplatePath($pluginName,$file,$tmpl){
		$mainframe= &JFactory::getApplication();
		$p = new JObject;
		if(file_exists(JPATH_SITE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.$pluginName.DS.$tmpl.DS.str_replace('/',DS,$file))){
			$p->file = JPATH_SITE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.$pluginName.DS.$tmpl.DS.$file;
			$p->http = JURI::base()."templates/".$mainframe->getTemplate()."/html/{$pluginName}/{$tmpl}/{$file}";
		} else {
			$p->file = JPATH_SITE.DS.'plugins'.DS.'content'.DS.$pluginName.DS.'tmpl'.DS.$tmpl.DS.$file;
			$p->http = JURI::base()."plugins/content/{$pluginName}/tmpl/{$tmpl}/{$file}";
		}
		return $p;
	}

} // end class
