<?php
/**
 * @version		1.0
 * @package		IAKI - Import As K2 Image (K2 plugin)
 * @author    JoomlaWorks - http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2012 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

// Load the K2 Plugin API
JLoader::register('K2Plugin', JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'lib'.DS.'k2plugin.php');

// Initiate class to hold plugin events
class plgK2Jw_iaki extends K2Plugin {

	// Some params
	var $pluginName = 'jw_iaki';
	var $pluginNameHumanReadable = 'IAKI (Import As K2 Image)';

	function plgK2Jw_iaki( & $subject, $params) {
		parent::__construct($subject, $params);
	}

	function onK2PrepareContent( &$item, &$params, $limitstart) {
		$mainframe = &JFactory::getApplication();

		// Get the K2 plugin params (the stuff you see when you edit the plugin in the plugin manager)
		$plugin = &JPluginHelper::getPlugin('k2', $this->pluginName);
		$pluginParams = new JParameter($plugin->params);

		$limitK2ItemId					= (int) $pluginParams->get('limitK2ItemId');
		$sourceImageFolder			= $pluginParams->get('sourceImageFolder');
		$destImageFolder				= $pluginParams->get('destImageFolder');

		// Includes
		require_once(dirname(__FILE__).DS.$this->pluginName.DS.'includes'.DS.'helper.php');

		// Output
		if($item->id<=$limitK2ItemId){
			$getFirstImage = JWIakiHelper::getFirstImage($item->text);

			// Replace the entire path if needed
			if($sourceImageFolder && $destImageFolder){
				$getFirstImageSrc = str_replace($sourceImageFolder,$destImageFolder,$getFirstImage['src']);
			} else {
				$getFirstImageSrc = $getFirstImage['src'];
			}

			// Assign image path to K2 image object
			$item->imageXSmall = $item->imageSmall = $item->imageMedium = $item->imageLarge = $item->imageXLarge = $item->imageGeneric = $getFirstImageSrc;

			// Strip the content from the actual <img /> tag
			$item->text = str_replace($getFirstImage['tag'],'',$item->text);
		}

	}

} // END CLASS
