CREATE TABLE `#__admintools_acl` (   `user_id` bigint(20) unsigned NOT NULL,   `permissions` mediumtext,   PRIMARY KEY (`user_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_adminiplist` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_badwords` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `word` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_customperms` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `path` varchar(255) NOT NULL,   `perms` varchar(4) DEFAULT '0644',   UNIQUE KEY `id` (`id`),   KEY `path` (`path`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_filescache` (   `admintools_filescache_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `filedate` int(11) NOT NULL DEFAULT '0',   `filesize` int(11) NOT NULL DEFAULT '0',   `data` blob,   `checksum` varchar(32) NOT NULL DEFAULT '',   PRIMARY KEY (`admintools_filescache_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipautoban` (   `ip` varchar(255) NOT NULL,   `reason` varchar(255) DEFAULT 'other',   `until` datetime DEFAULT NULL,   UNIQUE KEY `ip` (`ip`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipblock` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_log` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `logdate` datetime NOT NULL,   `ip` varchar(40) DEFAULT NULL,   `url` varchar(255) DEFAULT NULL,   `reason` varchar(255) DEFAULT 'other',   `extradata` mediumtext,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_profiles`  VALUES ('1', 'Default PHP Change Scanner Profile', '', '');
CREATE TABLE `#__admintools_redirects` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `source` varchar(255) DEFAULT NULL,   `dest` varchar(255) DEFAULT NULL,   `ordering` bigint(20) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '1',   `keepurlparams` tinyint(1) NOT NULL DEFAULT '1',   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scanalerts` (   `admintools_scanalert_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `scan_id` bigint(20) NOT NULL DEFAULT '0',   `diff` mediumtext,   `threat_score` int(11) NOT NULL DEFAULT '0',   `acknowledged` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`admintools_scanalert_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scans` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_storage` (   `key` varchar(255) NOT NULL,   `value` longtext NOT NULL,   PRIMARY KEY (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_storage`  VALUES ('cparams', '{\"latestjversion\":\"{\\\"installed\\\":{\\\"version\\\":\\\"2.5.13\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18555\\\\\\/83292\\\\\\/Joomla_2.5.13-Stable-Full_Package.zip\\\"},\\\"current\\\":{\\\"version\\\":\\\"2.5.13\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18555\\\\\\/83292\\\\\\/Joomla_2.5.13-Stable-Full_Package.zip\\\"},\\\"sts\\\":{\\\"version\\\":\\\"3.1.4\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18557\\\\\\/83319\\\\\\/Joomla_3.1.4-Stable-Full_Package.zip\\\"},\\\"lts\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"}}\",\"lastjupdatecheck\":1374847705}'), ('fixperms_stack', '{\"folders\":[],\"files\":[],\"total\":0,\"done\":0}');
CREATE TABLE `#__admintools_wafexceptions` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `option` varchar(255) DEFAULT NULL,   `view` varchar(255) DEFAULT NULL,   `query` varchar(255) DEFAULT NULL,   PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_profiles`  VALUES ('1', 'Default Backup Profile', '###AES128###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', 'a:1:{s:5:\"files\";a:1:{s:10:\"[SITEROOT]\";a:1:{i:0;s:17:\"configuration.php\";}}}');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_stats`  VALUES ('2', 'Backup taken on Friday, 26 July 2013 17:12', '', '2013-07-26 17:12:58', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'numodusversus_demosite_j25_20130726.zip', '/home/demos/domains/demo.nuevvo.com/public_html/commercial/j25/numodusversus/administrator/components/com_akeeba/backup/numodusversus_demosite_j25_20130726.zip', '0', 'backend', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext,   PRIMARY KEY (`tag`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;
INSERT INTO `#__assets`  VALUES ('1', '0', '1', '177', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'), ('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '17', '120', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '121', '122', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '123', '124', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'), ('11', '1', '125', '126', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '127', '128', '1', 'com_login', 'com_login', '{}'), ('13', '1', '129', '130', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '131', '132', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '133', '134', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '135', '136', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '137', '138', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '139', '140', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '141', '146', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '147', '148', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('21', '1', '149', '150', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '151', '152', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '153', '154', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '155', '158', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('25', '1', '159', '164', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('26', '1', '165', '166', '1', 'com_wrapper', 'com_wrapper', '{}'), ('27', '8', '18', '19', '2', 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '14', '15', '2', 'com_contact.category.4', 'nuModusVersus', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '142', '143', '2', 'com_newsfeeds.category.5', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('31', '25', '160', '161', '2', 'com_weblinks.category.6', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '24', '156', '157', '1', 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('33', '1', '167', '168', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('34', '1', '169', '170', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('35', '1', '171', '172', '1', 'com_k2', 'com_k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('38', '108', '61', '72', '3', 'com_content.category.8', 'Dance', ''), ('39', '107', '21', '28', '3', 'com_content.category.9', 'Design', ''), ('40', '107', '29', '40', '3', 'com_content.category.10', 'Fashion', ''), ('41', '108', '73', '86', '3', 'com_content.category.11', 'Movies', ''), ('42', '108', '87', '94', '3', 'com_content.category.12', 'Music', ''), ('43', '108', '95', '102', '3', 'com_content.category.13', 'Night Out', ''), ('44', '107', '41', '50', '3', 'com_content.category.14', 'Style', ''), ('45', '107', '51', '58', '3', 'com_content.category.15', 'Technology', ''), ('46', '108', '103', '118', '3', 'com_content.category.16', 'Theater', ''), ('47', '41', '74', '75', '4', 'com_content.article.1', 'Felis semper phasellus ultrices ', ''), ('50', '38', '62', '63', '4', 'com_content.article.4', 'Per nunc nisl habitant aptent ante ', ''), ('52', '45', '52', '53', '4', 'com_content.article.6', 'Fusce tristique etiam purus ', ''), ('53', '38', '64', '65', '4', 'com_content.article.7', 'Posuere ut eu ', ''), ('55', '40', '30', '31', '4', 'com_content.article.9', 'Arcu aenean laoreet risus etiam vestibulum ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('56', '42', '88', '89', '4', 'com_content.article.10', 'Commodo imperdiet torquent ', ''), ('57', '41', '76', '77', '4', 'com_content.article.11', 'Cubilia potenti felis ', ''), ('59', '46', '104', '105', '4', 'com_content.article.13', 'Semper ornare habitasse ut porttitor interdum ', ''), ('60', '44', '42', '43', '4', 'com_content.article.14', 'Consequat turpis leo venenatis ', ''), ('61', '40', '32', '33', '4', 'com_content.article.15', 'Habitasse cubilia orci ', ''), ('62', '42', '90', '91', '4', 'com_content.article.16', 'Velit rutrum hendrerit netus ', ''), ('63', '44', '44', '45', '4', 'com_content.article.17', 'Arcu orci ullamcorper ', ''), ('64', '41', '78', '79', '4', 'com_content.article.18', 'Litora fusce sem ', ''), ('65', '45', '54', '55', '4', 'com_content.article.19', 'Leo dolor vitae ', ''), ('68', '40', '34', '35', '4', 'com_content.article.22', 'Odio pharetra platea ', ''), ('69', '46', '106', '107', '4', 'com_content.article.23', 'Inceptos arcu varius a libero nullam ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('71', '43', '96', '97', '4', 'com_content.article.25', 'Consequat urna mi ut posuere ', ''), ('72', '41', '80', '81', '4', 'com_content.article.26', 'At phasellus aptent laoreet ', ''), ('73', '46', '108', '109', '4', 'com_content.article.27', 'Purus sit facilisis per mi ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('74', '43', '98', '99', '4', 'com_content.article.28', 'Bibendum diam habitasse etiam ', ''), ('76', '43', '100', '101', '4', 'com_content.article.30', 'Dictumst vulputate neque quisque lacinia ', ''), ('78', '38', '66', '67', '4', 'com_content.article.32', 'Inceptos etiam hac nisi ', ''), ('80', '40', '36', '37', '4', 'com_content.article.34', 'Dictum amet ut sapien ', ''), ('81', '38', '68', '69', '4', 'com_content.article.35', 'Sem torquent curabitur conubia lorem molestie ', ''), ('83', '40', '38', '39', '4', 'com_content.article.37', 'Id velit consequat consectetur euismod ', ''), ('84', '39', '22', '23', '4', 'com_content.article.38', 'Dolor blandit tincidunt leo sollicitudin conubia ', ''), ('85', '39', '24', '25', '4', 'com_content.article.39', 'Magna bibendum hendrerit ', ''), ('87', '46', '110', '111', '4', 'com_content.article.41', 'Vulputate hac dapibus ullamcorper ac ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('89', '41', '82', '83', '4', 'com_content.article.43', 'Molestie dictumst quam elit dictumst porttitor ', ''), ('90', '38', '70', '71', '4', 'com_content.article.44', 'Molestie quisque magna ', ''), ('92', '46', '112', '113', '4', 'com_content.article.46', 'Lectus curabitur pretium pharetra hendrerit ', ''), ('94', '46', '114', '115', '4', 'com_content.article.48', 'Quisque orci bibendum porta bibendum ', ''), ('97', '39', '26', '27', '4', 'com_content.article.51', 'Lacinia felis tempus consequat ', ''), ('98', '45', '56', '57', '4', 'com_content.article.52', 'Fermentum dictum bibendum ', ''), ('100', '44', '46', '47', '4', 'com_content.article.54', 'Convallis lacus sociosqu turpis ', ''), ('101', '46', '116', '117', '4', 'com_content.article.55', 'Torquent primis condimentum ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('102', '41', '84', '85', '4', 'com_content.article.56', 'Cubilia est leo id vitae ', ''), ('104', '44', '48', '49', '4', 'com_content.article.58', 'Condimentum sociosqu integer ', ''), ('106', '42', '92', '93', '4', 'com_content.article.60', 'Augue non nullam lorem pharetra vel ', ''), ('107', '8', '20', '59', '2', 'com_content.category.17', 'Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('108', '8', '60', '119', '2', 'com_content.category.18', 'Joomla! Categories', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('109', '19', '144', '145', '2', 'com_newsfeeds.category.19', 'Useful Feeds', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('110', '25', '162', '163', '2', 'com_weblinks.category.20', 'Useful Links', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('111', '1', '173', '174', '1', 'com_admintools', 'admintools', '{}'), ('112', '1', '175', '176', '1', 'com_akeeba', 'akeeba', '{}');
CREATE TABLE `#__associations` (   `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner_clients` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `contact` varchar(255) NOT NULL DEFAULT '',   `email` varchar(255) NOT NULL DEFAULT '',   `extrainfo` text NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `metakey` text NOT NULL,   `own_prefix` tinyint(4) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   PRIMARY KEY (`id`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner_tracks` (   `track_date` datetime NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL,   `count` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`track_date`,`track_type`,`banner_id`),   KEY `idx_track_date` (`track_date`),   KEY `idx_track_type` (`track_type`),   KEY `idx_banner_id` (`banner_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banners` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `clickurl` varchar(200) NOT NULL DEFAULT '',   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text NOT NULL,   `custombannercode` varchar(2048) NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `params` text NOT NULL,   `own_prefix` tinyint(1) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `idx_state` (`state`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`),   KEY `idx_banner_catid` (`catid`),   KEY `idx_language` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `level` int(10) unsigned NOT NULL DEFAULT '0',   `path` varchar(255) NOT NULL DEFAULT '',   `extension` varchar(50) NOT NULL DEFAULT '',   `title` varchar(255) NOT NULL,   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `note` varchar(255) NOT NULL DEFAULT '',   `description` mediumtext NOT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `params` text NOT NULL,   `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',   `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',   `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `cat_idx` (`extension`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_path` (`path`),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`),   KEY `idx_language` (`language`) ) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
INSERT INTO `#__categories`  VALUES ('1', '0', '0', '0', '39', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2009-10-18 16:07:09', '0', '0000-00-00 00:00:00', '0', '*'), ('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:26:37', '0', '0000-00-00 00:00:00', '0', '*'), ('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:35', '0', '0000-00-00 00:00:00', '0', '*'), ('4', '29', '1', '5', '6', '1', 'numodusversus', 'com_contact', 'nuModusVersus', 'numodusversus', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:57', '34', '2013-07-26 11:50:54', '0', '*'), ('5', '30', '1', '7', '8', '1', 'general', 'com_newsfeeds', 'General', 'general', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:15', '34', '2013-07-26 12:13:46', '0', '*'), ('6', '31', '1', '9', '10', '1', 'general', 'com_weblinks', 'General', 'general', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '34', '2013-07-26 12:16:30', '0', '*'), ('7', '32', '1', '11', '12', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '0', '0000-00-00 00:00:00', '0', '*'), ('8', '38', '18', '24', '25', '2', 'joomla-categories/dance', 'com_content', 'Dance', 'dance', '', '<p>\ndiam est himenaeos non amet id quisque, at luctus hac purus habitant, convallis sapien fringilla volutpat nostra. \nlectus imperdiet commodo quisque feugiat sapien justo curae, malesuada hendrerit vitae imperdiet etiam tristique adipiscing laoreet, interdum eget pharetra malesuada torquent donec. \nplatea cursus malesuada donec tempor volutpat fames ac imperdiet, lacus habitant taciti litora rhoncus facilisis nullam ligula, neque varius mi himenaeos feugiat potenti lorem. \nnisi eros urna est etiam himenaeos, torquent ac placerat mauris enim primis, luctus cursus aenean massa. \nper ad porttitor sociosqu a tristique ornare iaculis, litora cursus ultrices velit suscipit mi lobortis, scelerisque donec magna curabitur at turpis. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:07', '34', '2013-07-26 11:57:09', '0', '*'), ('9', '39', '17', '14', '15', '2', 'blog/design', 'com_content', 'Design', 'design', '', '<p>\nlacinia eleifend tempor lorem fames dictum torquent massa, habitant nunc consectetur felis consequat conubia sociosqu feugiat, posuere condimentum nullam fringilla mi integer. \nelementum malesuada ipsum non maecenas urna nibh suscipit potenti, aliquam metus hendrerit laoreet vitae scelerisque imperdiet ultricies amet, justo vestibulum aliquam nullam per sit semper. \nprimis porttitor suscipit ligula mollis integer aenean etiam platea ligula, nec nisi sit fermentum urna est nullam torquent, nec eu sem ornare laoreet imperdiet malesuada venenatis. \ncurabitur nibh ante faucibus nibh metus cursus, vel enim taciti himenaeos ad lacinia, bibendum aptent potenti lorem arcu. \n</p>\n<p>\nmassa inceptos nisi diam vestibulum quam, aptent fermentum viverra. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:11', '34', '2013-07-26 11:56:31', '0', '*'), ('10', '40', '17', '16', '17', '2', 'blog/fashion', 'com_content', 'Fashion', 'fashion', '', '<p>\nporta eleifend platea aptent inceptos pulvinar urna varius vivamus habitasse, placerat mollis massa ultrices nostra eros auctor eget luctus nisi, condimentum dictumst commodo integer laoreet sagittis eu malesuada. \nullamcorper nullam imperdiet dui nam praesent suscipit quis purus, cursus pellentesque curabitur ligula augue lorem ornare nam, quisque urna enim posuere luctus curabitur conubia. \nconsequat quisque ultricies aenean donec sagittis himenaeos quis, phasellus vulputate quam habitasse dolor felis, luctus eleifend pharetra ut taciti eu. \nfermentum commodo vulputate justo a feugiat tincidunt nisi cursus rutrum fringilla, accumsan faucibus molestie eleifend litora sapien fusce vehicula. \n</p>\n<p>\ndapibus lorem taciti etiam nisl suscipit, mi mollis accumsan. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:14', '34', '2013-07-26 11:56:31', '0', '*'), ('11', '41', '18', '26', '27', '2', 'joomla-categories/movies', 'com_content', 'Movies', 'movies', '', '<p>\nsuspendisse elit aptent magna morbi interdum auctor porttitor nibh etiam lacinia massa, scelerisque inceptos lectus eu eros curae auctor enim dictum praesent viverra, hac est eu est congue etiam pretium aenean ultrices molestie. \nnisi etiam habitant fusce purus eros mauris justo lorem aliquet, sed morbi rutrum ullamcorper dui quisque aenean aptent facilisis, hac pharetra pellentesque est aenean facilisis velit dui. \nnon volutpat malesuada ante at purus a, ac accumsan quis ultricies sapien primis, consectetur aenean hendrerit consequat integer. \npotenti augue viverra lorem justo nibh non sollicitudin, sed laoreet dictumst phasellus tempus malesuada adipiscing rhoncus, curabitur aenean ultrices interdum rhoncus ornare. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:22', '34', '2013-07-26 11:57:09', '0', '*'), ('12', '42', '18', '28', '29', '2', 'joomla-categories/music', 'com_content', 'Music', 'music', '', '<p>\nviverra porta eu cras pellentesque molestie tellus metus malesuada arcu felis, scelerisque viverra aliquam magna eros fusce tellus nostra. \naugue varius pretium vivamus consectetur posuere aliquam, himenaeos cubilia et feugiat aliquam ultricies aliquam, consequat senectus odio euismod fermentum. \nnostra sollicitudin tristique duis semper libero platea primis amet lorem eleifend duis litora ultrices, curabitur viverra iaculis mollis hac senectus porta risus mattis eleifend nisi tristique. \nviverra taciti potenti magna molestie aliquet netus aliquam sollicitudin, tincidunt odio conubia odio pharetra vulputate dictum, nisi senectus quis euismod fringilla fermentum orci. \nsociosqu pellentesque cursus vivamus auctor eu imperdiet accumsan, neque enim magna dictumst accumsan. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:24', '34', '2013-07-26 11:57:09', '0', '*'), ('13', '43', '18', '30', '31', '2', 'joomla-categories/night-out', 'com_content', 'Night Out', 'night-out', '', '<p>\nsapien porttitor tristique platea suscipit rhoncus etiam arcu lacus praesent augue euismod sagittis cursus cubilia, integer curabitur congue dolor dictumst diam blandit netus justo hac volutpat egestas. \nfaucibus torquent sodales nam cubilia semper varius habitasse dictum blandit, phasellus pharetra luctus metus odio cubilia eget. \nmalesuada neque etiam sem aliquam duis ac fames leo gravida fringilla nisl faucibus, consequat aliquam purus rhoncus aliquam ultricies enim proin fusce nunc. \nfacilisis tristique curabitur sem malesuada donec vehicula dictum ligula nibh ut, faucibus lectus faucibus accumsan feugiat sem dui lacinia taciti, pharetra quam hac dui nunc enim vehicula eros tempor. \n</p>\n<p>\nvulputate praesent curae, ut. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:26', '34', '2013-07-26 11:57:09', '0', '*'), ('14', '44', '17', '18', '19', '2', 'blog/style', 'com_content', 'Style', 'style', '', '<p>\nfeugiat risus varius a molestie nisl facilisis proin ante, sed vehicula a lacinia class lacinia leo habitasse primis, leo aptent consequat nostra himenaeos facilisis curabitur. \nid proin faucibus conubia velit erat congue dolor nibh vel eleifend ultrices tincidunt habitasse tincidunt, eleifend gravida quis donec aliquam laoreet magna vitae suspendisse quisque laoreet tellus. \nnostra class tempor sollicitudin tempor conubia metus mauris lobortis fames, ultrices dolor quisque pretium id in turpis morbi non, lacinia risus sem ligula vestibulum primis semper ad. \nvelit leo ornare hendrerit eget nulla convallis gravida sit auctor mollis hac, integer donec taciti ut massa placerat taciti hac nec. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:29', '34', '2013-07-26 11:56:31', '0', '*'), ('15', '45', '17', '20', '21', '2', 'blog/technology', 'com_content', 'Technology', 'technology', '', '<p>\nante suspendisse aliquet ad suspendisse posuere libero nec pellentesque, augue nec posuere magna id tempor fringilla, laoreet pellentesque suscipit non sapien laoreet dui. \naliquam etiam ligula fames lacinia rutrum odio nibh justo enim tempor ornare, curae accumsan integer donec arcu vulputate arcu vivamus varius sollicitudin. \nad duis hac etiam convallis cras et netus, mattis vitae lacus lectus felis vehicula consectetur, semper metus maecenas sociosqu vehicula nam. \nconvallis dolor elementum praesent leo varius ornare, ligula diam suscipit senectus fringilla congue, amet class nulla nisl curabitur. \ndui elit convallis eleifend feugiat interdum, curabitur inceptos ultricies accumsan ac adipiscing, integer ante nisl nunc. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:35', '34', '2013-07-26 11:56:31', '0', '*'), ('16', '46', '18', '32', '33', '2', 'joomla-categories/theater', 'com_content', 'Theater', 'theater', '', '<p>\ntincidunt congue volutpat sapien magna imperdiet mi vulputate, donec luctus leo nisi facilisis cubilia pellentesque, metus litora leo aliquet ut sodales. \ndolor pharetra elementum varius netus pulvinar cubilia himenaeos ac praesent ac, varius lacus metus ante cras ante vulputate fringilla laoreet, cras inceptos faucibus nec nunc scelerisque urna quisque blandit. \nac donec interdum litora faucibus mattis pretium curabitur, sapien interdum integer torquent cubilia cras. \nipsum accumsan interdum integer pulvinar adipiscing etiam hendrerit nulla lorem, non justo arcu praesent mollis risus donec. \nper praesent vel ullamcorper curabitur adipiscing dui, himenaeos erat curabitur odio venenatis sociosqu praesent, pellentesque lorem aliquam tempor massa. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '34', '2013-07-26 11:53:39', '34', '2013-07-26 11:57:09', '0', '*'), ('17', '107', '1', '13', '22', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '34', '2013-07-26 11:56:17', '0', '0000-00-00 00:00:00', '0', '*'), ('18', '108', '1', '23', '34', '1', 'joomla-categories', 'com_content', 'Joomla! Categories', 'joomla-categories', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '34', '2013-07-26 11:56:57', '0', '0000-00-00 00:00:00', '0', '*'), ('19', '109', '1', '35', '36', '1', 'useful-feeds', 'com_newsfeeds', 'Useful Feeds', 'useful-feeds', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '34', '2013-07-26 12:13:56', '0', '0000-00-00 00:00:00', '0', '*'), ('20', '110', '1', '37', '38', '1', 'useful-links', 'com_weblinks', 'Useful Links', 'useful-links', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '34', '2013-07-26 12:16:40', '0', '0000-00-00 00:00:00', '0', '*');
CREATE TABLE `#__contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `con_position` varchar(255) DEFAULT NULL,   `address` text,   `suburb` varchar(100) DEFAULT NULL,   `state` varchar(100) DEFAULT NULL,   `country` varchar(100) DEFAULT NULL,   `postcode` varchar(100) DEFAULT NULL,   `telephone` varchar(255) DEFAULT NULL,   `fax` varchar(255) DEFAULT NULL,   `misc` mediumtext,   `image` varchar(255) DEFAULT NULL,   `imagepos` varchar(20) DEFAULT NULL,   `email_to` varchar(255) DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `mobile` varchar(255) NOT NULL DEFAULT '',   `webpage` varchar(255) NOT NULL DEFAULT '',   `sortname1` varchar(255) NOT NULL,   `sortname2` varchar(255) NOT NULL,   `sortname3` varchar(255) NOT NULL,   `language` char(7) NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__contact_details`  VALUES ('1', 'nuModusVersus', 'numodusversus', '', '1766 Madison Ave.', 'New York', 'NY', 'USA', '10029', '+1 222 333 4567', '+1 222 333 5678', '<p>Etiam tincidunt laoreet turpis a vulputate. Etiam diam lorem, convallis ac laoreet a, pretium id nisl. Morbi tincidunt nibh a ante fringilla at tincidunt eros venenatis. Nunc a dui mi, in imperdiet sem. Aenean eu nulla massa. Ut interdum tristique est commodo pharetra.</p>', '', NULL, 'contact@example.com', '0', '1', '0', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '0', '4', '1', '+1 222 333 6789', 'http://example.com', '', '', '', '*', '2013-07-26 11:52:23', '34', '', '0000-00-00 00:00:00', '0', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
CREATE TABLE `#__content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `sectionid` int(10) unsigned NOT NULL DEFAULT '0',   `mask` int(10) unsigned NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text NOT NULL,   `urls` text NOT NULL,   `attribs` varchar(5120) NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   `parentid` int(10) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `access` int(10) unsigned NOT NULL DEFAULT '0',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `language` char(7) NOT NULL COMMENT 'The language code for the article.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;
INSERT INTO `#__content`  VALUES ('1', '47', 'Felis semper phasellus ultrices ', 'felis-semper-phasellus-ultrices', '', '<p>\nhabitasse odio senectus curae nec sagittis consectetur aptent ullamcorper, luctus conubia ad tempus viverra sodales inceptos, commodo vestibulum hendrerit praesent sodales mattis orci. \naccumsan primis metus integer euismod nisi aliquam ullamcorper tincidunt porta, id massa taciti nullam a nibh himenaeos leo, ac nisi fames integer hendrerit etiam feugiat mi. \nsodales fames iaculis cras sed eu congue quisque orci, sagittis justo sem hendrerit vel mollis class habitasse, felis urna a mollis enim ut mollis. \nlitora ornare fringilla bibendum viverra habitant sodales senectus curae vitae aenean ut, sapien egestas varius lacus nullam maecenas hendrerit taciti imperdiet sodales. \n</p>\n<p>\nphasellus mi velit ante, euismod. \n</p>', '<p>\nmassa amet fusce suspendisse rhoncus nam lacus eget curae ut elementum, est convallis urna tempus sagittis convallis quam hac tellus, nam habitant tristique lectus iaculis feugiat netus diam pulvinar. \nhimenaeos bibendum elementum est ullamcorper ac turpis condimentum feugiat porttitor quisque habitant, blandit porta consectetur netus libero auctor urna laoreet lobortis habitasse, nisi facilisis sapien bibendum platea nunc diam pellentesque ut purus. \ncurabitur accumsan integer ut sit commodo sagittis proin aenean morbi eget, inceptos senectus quis suscipit pellentesque proin malesuada integer vitae. \nnisl sed placerat adipiscing senectus nunc suspendisse elit magna metus iaculis, suspendisse porttitor non ante cursus pretium curabitur quisque imperdiet eros duis, tristique eleifend praesent fusce mi nullam convallis quis mattis. \n</p>\n<p>\nphasellus aliquam risus faucibus adipiscing etiam consequat eget semper tortor sit, consectetur class tempus mattis egestas platea quis duis facilisis senectus, lobortis nullam etiam semper interdum amet purus dolor aliquam. \nvitae ac aptent hac etiam mollis cubilia etiam lobortis fermentum, sit ornare scelerisque netus amet vitae mollis ut blandit habitant, ultricies curabitur conubia libero et dapibus morbi malesuada. \nnon metus lacinia accumsan nunc primis ac turpis augue, id libero in quisque laoreet volutpat ultricies etiam ut, sed iaculis est sollicitudin proin nullam netus. \npharetra faucibus dui netus tempor eu adipiscing etiam litora congue pulvinar, imperdiet aptent curabitur ac integer tempor tincidunt senectus diam dapibus ipsum, ullamcorper a vitae etiam cursus consequat libero fermentum class. \n</p>\n<p>\nsem tristique scelerisque ornare phasellus adipiscing cras velit habitant, nec scelerisque molestie velit ante dapibus dictum viverra habitant, aenean turpis id conubia primis iaculis integer. \nphasellus aenean curae habitasse rhoncus cras conubia at feugiat quisque neque vivamus, ad tristique condimentum auctor sit risus egestas donec condimentum mollis integer donec, consectetur per sed primis mauris non sollicitudin ut nam per. \ntortor vitae torquent sollicitudin ornare scelerisque mollis quisque, pretium nostra scelerisque venenatis tempor suscipit velit sollicitudin, consectetur consequat eros nam curabitur lacinia. \ninceptos nostra proin potenti non scelerisque nibh volutpat varius bibendum curabitur, amet tellus leo curae lacinia faucibus eleifend iaculis porta aenean velit, tempus platea volutpat proin blandit vulputate quis ultricies nulla. \n</p>\n<p>\nper erat fringilla convallis vivamus molestie condimentum placerat interdum morbi, bibendum non suspendisse placerat facilisis ac quisque dapibus, dictum per hac posuere turpis id posuere inceptos. \ntincidunt fusce velit elit taciti hac volutpat mauris dapibus, maecenas quisque in condimentum etiam phasellus nullam pellentesque tristique, litora malesuada commodo sagittis pharetra velit convallis. \ncurabitur molestie ac justo scelerisque, at nostra nibh, donec rhoncus luctus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}</div></dd></dl>', '1', '0', '0', '11', '2013-07-26 11:53:40', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:40', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/2_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Felis semper phasellus ultrices \",\"image_intro_caption\":\"Curabitur mi conubia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/2_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Felis semper phasellus ultrices \",\"image_fulltext_caption\":\"Curabitur mi conubia \"}', '', '', '1', '0', '7', 'New, Hollywood, Action', '', '1', '0', '', '0', '*', ''), ('4', '50', 'Per nunc nisl habitant aptent ante ', 'per-nunc-nisl-habitant-aptent-ante', '', '<p>\nvestibulum curabitur est ipsum ad scelerisque, velit cubilia phasellus adipiscing tempor curabitur, adipiscing magna a quis. \nfelis pharetra iaculis nisi ad in eu nulla, sodales sem accumsan faucibus fusce a erat urna, sollicitudin eget eros nibh praesent adipiscing. \naliquet orci ullamcorper mauris nibh non pellentesque elementum massa, inceptos semper tincidunt nunc curabitur eleifend bibendum euismod pretium, in himenaeos eget senectus justo ac neque. \npulvinar vitae nisi convallis erat aptent luctus mi cursus, volutpat ipsum porta habitasse nullam pharetra habitasse, neque purus tempus donec fusce mollis fringilla. \nligula iaculis diam lobortis purus lobortis risus cursus, in nulla massa class nostra varius. \n</p>', '<p>\ncommodo suspendisse curabitur placerat sollicitudin bibendum ut turpis arcu vestibulum, lacus purus gravida cubilia ultricies commodo ullamcorper leo curabitur bibendum, a imperdiet torquent ad in nec ad aliquam. \nvarius aenean tellus inceptos sem senectus viverra pellentesque mauris, hendrerit ullamcorper velit lobortis cursus consectetur enim, et mattis rhoncus rutrum eget nunc diam. \nerat euismod molestie maecenas aliquet vitae aliquam porttitor magna, imperdiet luctus habitant ullamcorper mollis congue lobortis sed vulputate, tincidunt quis nostra donec in imperdiet nec. \nodio platea mattis ligula mi tortor congue sodales velit amet aliquet etiam quis sociosqu nibh himenaeos, elementum vivamus maecenas eget posuere ante torquent sapien lobortis curae eros porttitor erat dapibus. \n</p>\n<p>\neu imperdiet dictum lectus nulla vestibulum ut praesent aenean eleifend ad sem auctor, ut pretium elementum neque accumsan tempor suscipit sed est duis torquent. \ngravida vestibulum tempor mollis tempor habitasse donec potenti aenean euismod a diam mauris, commodo iaculis quisque tortor leo euismod cubilia ut orci urna eleifend, mi fusce fringilla tristique varius hac venenatis nunc sapien metus consequat. \nbibendum mattis nisl blandit hendrerit consequat sociosqu hac fusce, dui adipiscing fusce elit eros integer ut iaculis consectetur, maecenas vulputate non ornare ultricies ullamcorper cursus. \nsociosqu donec amet senectus per cursus blandit dictum ligula placerat, urna curae feugiat elit etiam rutrum nunc pharetra, lectus integer ultrices mattis nam tincidunt rutrum condimentum. \n</p>\n<p>\naccumsan egestas vitae gravida risus per odio luctus ligula, dapibus quam hendrerit molestie pretium hac massa turpis pellentesque, scelerisque curae bibendum suscipit ullamcorper elementum fringilla. \nmauris fermentum scelerisque dapibus sem cubilia fames malesuada, venenatis mi habitant dui feugiat vivamus. \nhabitasse netus pulvinar himenaeos vel a fringilla luctus per at pharetra turpis, erat ornare eros turpis enim egestas ad justo sociosqu conubia, egestas ullamcorper ipsum proin suscipit convallis porttitor proin habitasse in. \nut sollicitudin pellentesque dictumst porta a, dictum ut quis donec sem, fames integer per primis. \ntortor lacinia neque porta nullam tincidunt tempus integer, iaculis etiam fringilla enim cubilia tortor viverra ligula, phasellus quisque feugiat dolor eleifend sollicitudin. \n</p>\n<p>\nmolestie per aliquam lacus velit lacus sapien vivamus consequat auctor risus, orci odio porta dictum velit nisi a sollicitudin etiam, velit orci tellus laoreet cubilia cursus lectus cras vel. \nat gravida ante pretium in aenean mauris quam nibh arcu nisi, donec habitasse platea conubia enim orci cubilia donec sollicitudin, ipsum proin platea taciti metus justo vehicula hac aliquam. \nultrices consequat potenti quis tristique curabitur quisque, dictum diam per primis sollicitudin malesuada, vitae velit est conubia habitant. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '1', '0', '0', '8', '2013-07-26 11:53:46', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:46', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/8\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Per nunc nisl habitant aptent ante \",\"image_intro_caption\":\"Interdum integer vulputate massa posuere \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/8\\/12_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Per nunc nisl habitant aptent ante \",\"image_fulltext_caption\":\"Interdum integer vulputate massa posuere \"}', '', '', '1', '0', '7', 'Music, Sensational, Trendy, Concert', '', '1', '0', '', '0', '*', ''), ('6', '52', 'Fusce tristique etiam purus ', 'fusce-tristique-etiam-purus', '', '<p>\net class interdum facilisis est aliquam vulputate himenaeos venenatis ante, dolor porttitor viverra platea porttitor tristique posuere pulvinar, sodales venenatis nullam lobortis tortor litora cubilia vulputate. \nad metus curabitur aptent imperdiet nulla porta erat tristique lacinia viverra, sodales cras amet vehicula lobortis porta felis arcu dapibus, mollis venenatis etiam aliquam ligula aliquet mollis molestie taciti. \nnisi auctor taciti accumsan justo bibendum ad metus class dictum commodo, arcu at phasellus elit hac ligula nec suscipit sollicitudin dictumst nunc, ipsum aenean commodo donec fusce velit fermentum orci et. \nfelis vitae ultricies ut fames nisi ligula dictum, tempor cubilia ipsum commodo ut etiam. \n</p>', '<p>\nblandit vivamus ornare class curabitur erat eget sociosqu feugiat lobortis, ac varius rhoncus potenti sodales donec facilisis morbi, facilisis gravida pharetra aliquam felis feugiat hac curabitur. \npharetra laoreet dictum metus est curabitur tempor vivamus bibendum, dictum nisi a molestie hac a mollis quam mauris, ut ac aliquet porttitor ut augue volutpat. \nauctor magna adipiscing commodo dui commodo eleifend vel volutpat varius fringilla consectetur, curabitur non accumsan eros molestie blandit ultrices etiam ad cras, lorem praesent maecenas purus placerat suspendisse elementum ornare consectetur quisque. \nsodales ultricies rhoncus class condimentum viverra aliquam quis posuere, fermentum aptent ornare nulla in tempor luctus. \n</p>\n<p>\ncurabitur amet quisque pharetra malesuada congue at viverra aptent inceptos metus mauris lorem curabitur netus, sit lectus himenaeos eleifend aenean lorem gravida aenean erat malesuada morbi curabitur. \nlacus mi habitasse suscipit cursus nunc habitasse consectetur egestas aliquam, volutpat congue dolor egestas elementum vitae commodo. \nquisque varius litora morbi eu nam lacinia ornare dui ac, eros nunc quisque non malesuada urna habitasse ligula platea, adipiscing ultricies diam curabitur pretium cursus scelerisque cubilia. \ndolor interdum nisi lobortis duis eu leo proin porta purus luctus, feugiat fusce velit torquent ad malesuada lacinia velit. \n</p>\n<p>\naenean nisl augue eget felis platea class, nulla leo varius neque odio ac libero, ad lobortis posuere ut morbi. \nrisus conubia nibh platea hendrerit at per sollicitudin amet lacus curabitur, dapibus sed quisque gravida class sollicitudin torquent cubilia nibh, arcu nec aenean feugiat nisi integer phasellus magna mauris. \neros conubia accumsan blandit sodales mauris id turpis posuere primis, ullamcorper ut eu consectetur blandit semper eu porta lorem, pharetra a vehicula morbi vivamus tempus curae aenean suspendisse, etiam eros torquent potenti aenean posuere ornare pellentesque. \nat quisque id maecenas rhoncus vestibulum odio pellentesque tincidunt, aliquet luctus odio vehicula ac torquent risus libero, tempor et sed odio vestibulum habitant orci. \n</p>\n<p>\nper eleifend ullamcorper lobortis quisque sagittis magna vivamus elementum dictum fusce bibendum, ut cubilia scelerisque semper orci lacus dictum odio erat. \nsapien maecenas porttitor hendrerit augue platea et ornare quis primis, massa pulvinar donec dictumst potenti dictumst velit id, neque viverra nibh litora rutrum nibh torquent iaculis. \nvivamus posuere fames quisque nostra convallis lacinia, tellus sociosqu nec tortor litora egestas, habitasse non egestas commodo malesuada. \nvenenatis nulla amet lacinia elementum vel eros pulvinar ultrices ultricies lacus elementum etiam, semper ipsum per augue posuere ad varius neque suspendisse fringilla maecenas. \n</p>\n<p>\net varius ullamcorper cursus adipiscing quisque et dui, vehicula consectetur class sociosqu elementum curae. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=saMhNUmPaJ4{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}</div></dd></dl>', '1', '0', '0', '15', '2013-07-26 11:53:50', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:50', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/15\\/21_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Fusce tristique etiam purus \",\"image_intro_caption\":\"Praesent proin faucibus scelerisque \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/15\\/21_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Fusce tristique etiam purus \",\"image_fulltext_caption\":\"Praesent proin faucibus scelerisque \"}', '', '', '1', '0', '6', 'Modern, New Stuff, Bleeding Edge, Must Buy', '', '1', '1', '', '0', '*', ''), ('7', '53', 'Posuere ut eu ', 'posuere-ut-eu', '', '<p>\npotenti at vulputate posuere vehicula rutrum hac eu, nostra dapibus sem habitant vitae cursus dictum, adipiscing risus iaculis dolor inceptos ad. \naliquam torquent fusce nullam aptent morbi etiam erat nam nec ornare sodales id, suscipit dictumst duis ipsum ut posuere ac venenatis aliquam per vehicula. \nenim diam sed himenaeos imperdiet habitasse conubia sed amet fames commodo scelerisque congue vivamus, posuere fames vel facilisis in varius himenaeos sagittis cras quam elit pellentesque. \nultricies est semper accumsan vitae aenean potenti, justo vitae tempor faucibus dictum non, torquent velit mollis ipsum etiam. \n</p>\n<p>\nfames justo aptent eleifend et pretium netus, lacus nisi donec urna. \n</p>', '<p>\ninterdum aenean at netus justo himenaeos amet aliquet malesuada aenean, ullamcorper ultrices vehicula quam sagittis habitant ligula habitant quam, diam et curae gravida pellentesque lacinia rhoncus pellentesque. \ntempor vestibulum maecenas etiam justo porta enim fames nisl mollis, vel quis rutrum litora libero lectus primis sodales dictumst ultrices, cubilia aliquet nec pharetra sociosqu magna lobortis netus. \nmolestie leo curabitur in fusce ligula accumsan duis condimentum dapibus, rutrum iaculis integer vehicula at nunc tempor arcu elit maecenas, feugiat primis tempus interdum bibendum maecenas molestie neque. \nlorem turpis conubia integer mollis suscipit, adipiscing id viverra erat, bibendum sollicitudin duis leo. \n</p>\n<p>\naenean elit mi aliquam maecenas varius erat convallis augue himenaeos, nisi proin porttitor risus lorem neque purus pretium mauris donec, lacinia commodo hendrerit luctus neque ac erat convallis. \nviverra cubilia proin vivamus ut sollicitudin curae, sit ut elit et. \ninteger tempor sodales nunc quisque donec ornare ut phasellus, malesuada tortor himenaeos habitasse quisque placerat aliquam risus, sem platea luctus platea proin interdum aliquam. \nnisi donec est viverra rhoncus lorem turpis sit habitasse orci curae iaculis eu, hendrerit ornare lectus praesent curae nam aliquet tellus aliquet maecenas netus. \nfeugiat duis congue magna enim ultricies urna nisl senectus, quam nisl nec donec maecenas gravida. \n</p>\n<p>\nauctor tincidunt condimentum duis semper mattis elit habitant, non feugiat inceptos sociosqu nec sapien himenaeos congue, eget nibh convallis nibh auctor mauris. \nneque ad magna egestas sit molestie porta, hendrerit duis lacinia congue aenean consequat donec, sociosqu mattis himenaeos tellus convallis. \ntincidunt donec purus diam vivamus quisque viverra, laoreet nibh tortor primis adipiscing quam, quis quisque auctor bibendum cubilia. \nsociosqu facilisis integer odio quisque ac urna et varius maecenas, mattis id mollis posuere etiam odio potenti nulla, rutrum risus hendrerit gravida pulvinar praesent eu orci. \naliquam tincidunt at auctor at congue amet, convallis pellentesque donec sollicitudin odio, vivamus etiam tempus etiam mollis. \n</p>\n<p>\nporttitor urna sapien sit duis platea duis cursus ante aptent, sodales nam etiam dictumst ut pellentesque massa cubilia integer ut, nullam aptent molestie convallis fames est sociosqu et. \npretium habitasse sed nulla cras tellus consectetur viverra venenatis dolor, augue proin ullamcorper suscipit donec tristique conubia rutrum, ullamcorper donec felis ligula neque iaculis morbi vel. \nper ad volutpat gravida eros aliquam a id mollis erat orci, cras potenti id nec ante purus mollis nisi fermentum, aliquet risus rutrum fringilla leo proin tristique mauris class. \nfaucibus quis semper odio condimentum vivamus tortor viverra ultricies, nisi donec sagittis praesent consequat velit curae. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '2', '0', '0', '8', '2013-07-26 11:53:52', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:52', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/8\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Posuere ut eu \",\"image_intro_caption\":\"Vitae eros euismod \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/8\\/12_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Posuere ut eu \",\"image_fulltext_caption\":\"Vitae eros euismod \"}', '', '', '1', '0', '6', 'Intense, Music', '', '1', '0', '', '0', '*', ''), ('9', '55', 'Arcu aenean laoreet risus etiam vestibulum ', 'arcu-aenean-laoreet-risus-etiam-vestibulum', '', '<p>litora eu et pharetra accumsan posuere nibh iaculis tempor suscipit, bibendum etiam vel feugiat quisque accumsan turpis arcu erat, varius suscipit mattis potenti vulputate senectus in donec. dictumst quam lacus at commodo molestie suspendisse odio ante, eros nisi magna nostra nullam sagittis class purus litora, imperdiet vehicula viverra cursus convallis aliquam erat. mauris accumsan posuere tempor at faucibus erat lectus vestibulum adipiscing sollicitudin, eget suspendisse lorem sem praesent at velit sociosqu iaculis massa et, blandit pharetra platea elementum a ultricies lectus varius quis. hendrerit faucibus ligula porta per rhoncus lacus, inceptos facilisis cras mattis fusce, aliquet condimentum mattis fringilla viverra.</p>\r\n', '\r\n<p>amet nunc per elementum cubilia lacinia phasellus est porttitor vulputate, orci sapien primis lectus condimentum dapibus quisque ad, nam ullamcorper eu torquent class conubia maecenas varius. aenean curae sit quam commodo tempus justo habitasse fames nec, enim convallis quisque class adipiscing aliquam justo eu leo, pulvinar himenaeos iaculis tempus consequat erat amet nullam. quisque quis nunc lacus inceptos accumsan enim fringilla torquent morbi, ornare morbi venenatis cras duis lectus justo mauris, inceptos nunc nullam ut primis mattis id ultrices. iaculis proin interdum tellus sagittis aliquam pellentesque dui lectus elementum gravida, etiam sit proin malesuada duis suscipit pellentesque velit.</p>\r\n<p>sociosqu torquent rhoncus gravida dictum libero erat, gravida viverra est lobortis urna velit, vitae nullam ad phasellus odio. inceptos morbi enim tortor sed tellus quisque ullamcorper metus eros, sit ultrices maecenas nisl ad aliquam senectus. condimentum luctus nisl curae tempor ipsum at imperdiet cubilia felis neque fringilla, id nec posuere aenean odio quisque ac consequat eros ultricies, litora erat ante sed volutpat odio erat habitant viverra auctor. nec egestas mollis litora vivamus gravida purus placerat donec at nulla conubia ante enim lacus fames libero, erat phasellus placerat vitae rutrum viverra consectetur tempor consequat sociosqu fermentum vestibulum felis pellentesque.</p>\r\n<p>platea potenti nisl massa dolor faucibus semper sollicitudin hac sed vitae mattis, tincidunt felis leo ante aenean nam donec vestibulum aenean aptent, proin nec etiam elementum enim sociosqu tempus netus porta praesent. taciti proin adipiscing ornare pharetra primis porttitor nibh taciti, orci pellentesque aenean faucibus potenti urna gravida sem, vehicula tristique sed condimentum odio hac lectus. pharetra bibendum ornare viverra senectus vitae praesent lorem auctor, quam cursus mi aenean tristique ac vivamus justo vehicula, amet fames donec rhoncus aliquet class massa. viverra curabitur suscipit sagittis pulvinar at senectus class ante, et vehicula taciti rutrum posuere consequat eu duis, per nostra habitasse in ut nostra semper.</p>\r\n<p>augue gravida felis ac donec tempus fermentum arcu erat at, pretium integer consequat vivamus in himenaeos nostra mattis. vehicula ut id aliquam facilisis dictumst diam sollicitudin turpis, luctus ut nostra platea turpis tincidunt. dapibus vitae convallis odio mollis felis ac tellus nisl erat, consectetur ultrices maecenas etiam lacus fermentum nisl elit lobortis proin, faucibus netus litora varius curabitur dapibus curae molestie. amet cursus arcu velit pellentesque donec tellus enim est, curabitur urna eget commodo ac tincidunt rhoncus, netus nullam mollis vitae phasellus neque primis. scelerisque neque tempor condimentum nisl aliquet elit pellentesque vehicula, curabitur cubilia proin sodales fermentum et.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div>', '1', '0', '0', '10', '2013-07-26 11:53:55', '34', '', '2013-07-26 14:13:09', '34', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:55', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/10\\/19_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Arcu aenean laoreet risus etiam vestibulum \",\"image_intro_caption\":\"Facilisis congue porta \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/10\\/19_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Arcu aenean laoreet risus etiam vestibulum \",\"image_fulltext_caption\":\"Facilisis congue porta \"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '4', 'Catwalk, Autumn - Winter', '', '1', '11', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('10', '56', 'Commodo imperdiet torquent ', 'commodo-imperdiet-torquent', '', '<p>\nut integer duis curabitur sociosqu eu mattis sed elementum ornare, vel donec ornare convallis rutrum auctor arcu leo, nam vitae nostra tempor volutpat ut erat aliquam. \ntaciti integer tincidunt aenean nec donec etiam convallis phasellus blandit, eget adipiscing aliquam mi nisl aliquam elementum taciti at lacinia, adipiscing felis nisl vulputate sed dictumst conubia ante. \nlitora ligula aliquet vivamus dictum feugiat donec hendrerit suscipit ornare maecenas gravida, duis feugiat ligula morbi fermentum neque placerat pharetra praesent. \nvenenatis amet taciti nostra dolor iaculis elementum etiam rutrum bibendum aenean curabitur nisi neque, aliquam varius aenean ad nostra donec facilisis litora ligula quis fermentum. \n</p>', '<p>\nporttitor sagittis eget proin ultricies volutpat nisi felis, tincidunt potenti eu adipiscing ut elementum orci, velit cursus arcu ante hac fringilla. \npurus hac donec vel congue dolor, varius sem eget orci ut velit, rhoncus arcu aptent turpis. \nerat primis erat proin facilisis mollis sit inceptos, arcu dolor netus risus proin leo urna, sem turpis ullamcorper a euismod tortor. \ndapibus tortor quis sodales curabitur libero non per purus, pharetra blandit eu rutrum dictumst class dictumst, iaculis volutpat euismod turpis cubilia dictum gravida. \naliquam neque tristique sem hendrerit dolor curabitur vestibulum potenti, vitae at duis sagittis libero sed egestas condimentum, taciti himenaeos sodales velit quisque sed magna. \n</p>\n<p>\ndonec platea nec est mauris curabitur quisque praesent elementum massa, curae per aptent tristique tempus per platea lacinia velit iaculis, arcu venenatis tempor accumsan class vehicula viverra tincidunt. \ncurabitur habitasse et risus mollis cubilia velit, bibendum per lobortis dui gravida, blandit massa pharetra praesent quis. \narcu netus arcu mauris feugiat posuere vitae egestas bibendum, dolor arcu vestibulum malesuada luctus libero aliquam, potenti ante aliquam sapien himenaeos ac nostra. \nultrices vehicula convallis interdum sollicitudin nostra egestas per, orci pellentesque a turpis conubia at adipiscing quam, vel vitae aptent congue euismod posuere. \n</p>\n<p>\nerat faucibus sodales facilisis proin cubilia elementum aenean egestas, mollis vitae risus arcu metus sociosqu rutrum felis urna, erat felis gravida donec egestas odio netus. \nmollis nunc pharetra cras proin ut, amet vel amet nisl, eleifend in tristique placerat. \nluctus ullamcorper mattis nisi dictumst integer, metus cursus per condimentum dolor potenti, nibh eros tempor suspendisse. \naenean nibh lorem habitant lectus ligula cubilia fames accumsan ante viverra pellentesque litora tortor, vehicula eget fusce felis habitasse potenti ullamcorper potenti facilisis integer posuere himenaeos. \nmattis commodo arcu mattis accumsan justo eu cubilia, vel aliquam ultrices eu condimentum luctus, etiam tincidunt eleifend tincidunt imperdiet aenean. \n</p>\n<p>\nvulputate congue metus nostra eros nulla torquent magna sodales arcu sit venenatis, iaculis tempor cursus iaculis aliquam id sagittis justo leo sapien, congue duis primis diam ipsum auctor commodo vivamus tempor aliquam. \ncursus torquent non feugiat augue tristique sollicitudin etiam orci ut posuere, rutrum augue torquent tempor dapibus congue nisi iaculis aliquam id, quisque viverra justo dictumst aliquet gravida dui fames litora. \nvelit tortor arcu hac taciti conubia per imperdiet etiam conubia gravida, condimentum semper taciti feugiat augue suscipit diam est lacus, nullam aenean class per hac ac pulvinar bibendum tellus. \n</p>\n<p>\neu blandit lacinia consectetur eget, faucibus nostra ut venenatis molestie, porttitor primis sapien. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/rickh710/sets/72157624828280184{/gallery}</div></dd></dl>', '1', '0', '0', '12', '2013-07-26 11:53:56', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:56', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Commodo imperdiet torquent \",\"image_intro_caption\":\"Vulputate pretium porta id cursus laoreet \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/4_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Commodo imperdiet torquent \",\"image_fulltext_caption\":\"Vulputate pretium porta id cursus laoreet \"}', '', '', '1', '0', '2', 'New, Upcoming, Album of the Week, Electronic', '', '1', '0', '', '1', '*', ''), ('11', '57', 'Cubilia potenti felis ', 'cubilia-potenti-felis', '', '<p>\nnunc himenaeos non potenti condimentum sed porta egestas vel, luctus vehicula arcu id platea mauris aliquet lectus, aenean tempor suspendisse curabitur velit quis mauris. \niaculis aptent vestibulum erat ullamcorper lectus morbi elit ipsum eleifend sodales molestie, ipsum pharetra aliquam ad semper non aliquam suspendisse taciti integer. \nnisi nec sollicitudin lobortis felis pharetra ipsum vel dolor conubia, sodales condimentum risus fames elementum diam mauris netus fames, faucibus senectus viverra elementum litora luctus nostra vehicula. \negestas quam cursus imperdiet donec congue dolor nullam non tincidunt, ad gravida nulla bibendum elementum litora ultrices ut potenti, ullamcorper scelerisque id dapibus senectus etiam pulvinar porta. \n</p>', '<p>\nac nibh iaculis consectetur lacus quam sociosqu quam tempor viverra, fusce aenean donec scelerisque purus ad blandit nunc, elit nec nostra neque enim habitasse nisl turpis. \nsit felis ultrices ligula volutpat integer nisi himenaeos quisque aliquet in, egestas pretium arcu sit sed sollicitudin scelerisque rutrum senectus fusce netus, velit torquent eleifend massa ipsum morbi mi metus ac. \neu congue dolor turpis metus vel sem venenatis aliquam, vulputate enim ad ut felis suscipit quis nibh, facilisis dictumst at sagittis sodales himenaeos odio. \nlorem hendrerit etiam rhoncus mollis venenatis lacus per purus netus, nullam odio lacinia est mauris turpis ad. \n</p>\n<p>\nid quam habitasse cras nunc sagittis sollicitudin egestas, fringilla arcu commodo quisque nec suscipit, nunc nam iaculis consequat risus neque. \nfacilisis enim viverra suspendisse lacus condimentum tristique porta nibh sollicitudin vehicula lacus, venenatis convallis at ad tortor aenean vivamus vestibulum nisl per. \nfermentum ultricies ullamcorper id ligula eros mi nam odio, fermentum et eu rhoncus quis egestas faucibus, nullam odio per justo suspendisse hendrerit commodo. \nmolestie eros etiam pulvinar dictumst condimentum elementum morbi quisque ultrices, fermentum nec dolor a aptent ultrices massa non massa faucibus, cursus metus ullamcorper egestas cras sed tristique metus. \n</p>\n<p>\nodio cursus aliquet sed porttitor volutpat vestibulum metus pretium nullam aenean facilisis, mollis est senectus class lacus risus sagittis ac sit condimentum nam quis, rutrum vitae ac netus hendrerit non dictumst maecenas eleifend consequat. \nvestibulum phasellus imperdiet nec fames nostra elementum magna morbi odio cursus conubia mattis, dictum venenatis nisi quisque ultricies sodales nibh adipiscing aptent maecenas vivamus etiam, condimentum vivamus aenean fames nisl amet diam torquent suscipit consectetur ultricies. \nbibendum libero inceptos mi et convallis mauris faucibus elit in aptent libero nostra arcu netus, molestie curabitur et quis quam urna enim curae adipiscing eget morbi sociosqu. \n</p>\n<p>\ncurae ut quisque vel facilisis eleifend aenean etiam nunc, orci taciti pretium etiam semper at rhoncus, senectus taciti habitant habitasse vel lacinia gravida vitae, arcu litora condimentum interdum placerat augue. \nlacinia quam turpis urna sociosqu pulvinar hac sodales aenean, dui donec eleifend urna tincidunt blandit convallis, sociosqu volutpat tristique duis luctus nullam convallis. \nnam semper aptent iaculis torquent tristique ultricies volutpat ultricies orci, aliquam curae sapien mollis ut senectus adipiscing sem. \nid habitasse primis tempor dictum laoreet viverra gravida, duis porttitor lectus quisque ante faucibus dictumst nec, consectetur lacus eget placerat sodales sit. \n</p>\n<p>\neu quisque libero donec vehicula tempor sapien, eros tempor eros blandit at dictum tempor, lacinia integer convallis aliquet urna. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '0', '0', '11', '2013-07-26 11:53:58', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:53:58', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/9_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cubilia potenti felis \",\"image_intro_caption\":\"Nec sodales tristique commodo \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/9_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cubilia potenti felis \",\"image_fulltext_caption\":\"Nec sodales tristique commodo \"}', '', '', '1', '0', '6', 'Actors, Epic', '', '1', '0', '', '0', '*', ''), ('13', '59', 'Semper ornare habitasse ut porttitor interdum ', 'semper-ornare-habitasse-ut-porttitor-interdum', '', '<p>\nlaoreet molestie arcu tempor consectetur faucibus purus molestie proin, vel mattis id blandit pellentesque class augue, conubia eleifend tristique eu vivamus vitae cras. \naliquam rhoncus non vestibulum ac posuere tempus aenean, nunc egestas imperdiet congue dolor turpis, sollicitudin luctus massa praesent convallis hendrerit. \nsem integer elit ut nec per habitant purus, accumsan donec turpis dui fermentum ipsum condimentum sodales, tellus consectetur rutrum dictum diam ut. \nhac egestas diam proin nam mollis amet tincidunt posuere vivamus quam orci lorem, non nullam porttitor nec eros pretium elementum egestas vehicula pellentesque non, quisque euismod commodo sociosqu condimentum donec mi nec orci tortor imperdiet. \n</p>', '<p>\nlobortis dolor proin quisque lectus pharetra proin arcu dictumst, malesuada cursus purus ut sociosqu nisl enim leo condimentum, odio netus faucibus mollis luctus convallis netus. \nnam pharetra laoreet nam quis phasellus enim pulvinar hendrerit mauris, aenean ornare torquent volutpat eleifend per quis hendrerit nibh, ultricies integer elementum aenean nullam aenean libero enim. \ninteger pretium nec elementum ultricies massa tortor tristique semper hendrerit feugiat urna vehicula dui condimentum conubia, vehicula aenean libero gravida condimentum non ornare fringilla ante neque primis orci habitasse fusce. \nfacilisis tincidunt habitasse aliquam posuere lobortis condimentum lectus, turpis justo nec phasellus mollis neque ipsum turpis, felis ad erat diam urna phasellus. \n</p>\n<p>\neget at luctus placerat volutpat duis curae rhoncus nullam, eget metus aenean aptent quam potenti. \naliquam sodales litora ultricies viverra mauris justo nullam aliquam vehicula vulputate, aenean iaculis lobortis semper nulla id interdum pellentesque vehicula, est congue porta ac pellentesque eu mi himenaeos sit. \nvenenatis volutpat quisque posuere sit habitasse ullamcorper varius inceptos quis, commodo mauris integer neque nibh urna dui eget ad, scelerisque nullam faucibus pellentesque nostra risus nam mollis. \nlitora ipsum massa tempus odio ultrices sed netus orci habitant torquent, aenean suspendisse per et diam ligula et ullamcorper adipiscing, vel per semper bibendum aenean malesuada luctus non habitasse. \n</p>\n<p>\nerat enim sem magna curae sed volutpat odio pharetra, proin netus pretium ligula tempus etiam varius est, dictumst quis ipsum aenean sit quisque sagittis. \naenean curabitur etiam volutpat eleifend leo odio quam purus aliquam, sapien ut convallis sem sed sagittis adipiscing consequat himenaeos, primis maecenas id venenatis conubia felis dolor lectus. \nmattis ultrices purus senectus non lectus hac nisl nec, nibh cursus mi phasellus etiam tempor euismod, tempus vestibulum gravida volutpat curabitur himenaeos pulvinar. \nhabitasse cras arcu proin ac nullam viverra, tincidunt lobortis iaculis turpis in. \nleo semper hac netus lacinia suspendisse himenaeos inceptos odio mi ante, nostra faucibus inceptos ut scelerisque elementum hendrerit etiam aliquam, inceptos vehicula elementum leo tincidunt metus a consectetur tristique. \n</p>\n<p>\nfusce fermentum aenean ornare vehicula consequat maecenas cras, vestibulum placerat suscipit vestibulum imperdiet sollicitudin quis lobortis, fringilla luctus tristique amet curabitur tempus. \nduis nulla malesuada tristique justo sapien dapibus varius orci consectetur risus, tempor nisl ultrices vitae taciti curae primis sagittis facilisis, sodales rhoncus hendrerit vel rutrum eu felis venenatis class. \netiam platea lacus nam lectus eros tristique morbi lacus dictum, pulvinar in semper consequat torquent etiam mattis faucibus, blandit commodo euismod condimentum himenaeos pellentesque iaculis hac. \nprimis fringilla pharetra, lorem. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}</div></dd></dl>', '1', '0', '0', '16', '2013-07-26 11:54:01', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:01', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Semper ornare habitasse ut porttitor interdum \",\"image_intro_caption\":\"Semper mauris non nisi facilisis bibendum \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/6_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Semper ornare habitasse ut porttitor interdum \",\"image_fulltext_caption\":\"Semper mauris non nisi facilisis bibendum \"}', '', '', '1', '0', '6', 'Performance, New, Drama, Inspirational', '', '1', '0', '', '1', '*', ''), ('14', '60', 'Consequat turpis leo venenatis ', 'consequat-turpis-leo-venenatis', '', '<p>\nat gravida at nisi leo fusce urna curabitur, semper nunc ipsum aliquam accumsan phasellus, ultricies ut diam tristique commodo quam. \naenean dictumst pharetra sapien egestas convallis magna, ornare eget mi a auctor, vivamus volutpat vehicula ut auctor. \nduis hac dui ut praesent pellentesque odio pulvinar curabitur eu potenti augue, sagittis pharetra ut etiam adipiscing pharetra ut ante sollicitudin. \nsenectus proin litora donec nunc faucibus sed aenean nec sollicitudin nibh, dictum platea mattis erat vel sapien felis vitae viverra ultrices iaculis, aenean cursus sed lacus habitant nisi libero potenti nullam. \n</p>\n<p>\nmi vestibulum suspendisse nulla amet, orci dapibus mollis, augue lorem duis. \n</p>', '<p>\naliquet himenaeos fames euismod per eu purus duis faucibus curabitur hac ornare curabitur arcu, integer hendrerit vehicula egestas vel lorem posuere viverra scelerisque volutpat nisl convallis. \nsapien viverra maecenas facilisis sem erat eleifend habitant cursus himenaeos eros, fusce quisque aenean ut venenatis vehicula lacinia tristique quam, mollis donec proin nibh litora sapien aenean ut platea. \ncursus cubilia tortor nisl integer commodo fringilla interdum dapibus vulputate senectus neque accumsan viverra, tristique tempus sed himenaeos quisque sollicitudin fames ipsum sit facilisis curabitur malesuada. \nrhoncus purus volutpat sagittis himenaeos mauris aliquam lectus quis condimentum, eleifend himenaeos eros accumsan enim fusce velit fringilla a, aliquet ipsum dui aliquet volutpat per hendrerit at. \n</p>\n<p>\nsuspendisse augue nam integer leo congue sed etiam pharetra odio nunc, magna semper venenatis fermentum curabitur etiam conubia commodo ultricies, nullam neque quis augue urna mi eget mollis aliquam. \nfaucibus sodales senectus ad suspendisse a malesuada est, quisque at lacinia egestas scelerisque vestibulum, lacus lobortis curabitur elementum nulla viverra. \nleo vestibulum iaculis lectus curabitur conubia est netus vitae aliquam, quis quisque nibh quam pretium justo netus habitant orci mattis, arcu cursus nunc arcu augue nibh lectus risus. \nornare tristique augue sodales erat malesuada primis volutpat nec, malesuada maecenas etiam maecenas curabitur maecenas laoreet habitant etiam, dictumst tincidunt malesuada egestas feugiat hac aenean. \n</p>\n<p>\ndictum auctor taciti at iaculis curae ut duis aliquet, nulla urna taciti imperdiet varius aenean id netus mauris, sagittis conubia neque mauris tempor tempus mauris. \nphasellus eu id enim habitasse nec enim nunc velit purus ac magna sapien, sollicitudin mollis etiam magna ultrices purus tortor lorem et orci nostra. \nproin facilisis tortor sapien urna cubilia, lectus vivamus felis vel inceptos, ad quis inceptos aliquam eu, at morbi conubia ornare. \ntortor iaculis cras vulputate velit massa non fames, odio luctus ut lacinia pulvinar adipiscing gravida tincidunt, egestas duis placerat donec scelerisque nulla. \n</p>\n<p>\nscelerisque ultrices feugiat varius litora volutpat felis, sociosqu class ipsum nisl primis justo platea, posuere sem primis pharetra dictumst. \nvehicula donec morbi class purus tempor sociosqu arcu eleifend ad gravida velit ante, nec et rhoncus mi pulvinar nec class a libero aliquam pretium. \nfringilla odio fringilla metus fringilla est nisi massa ultrices imperdiet blandit eleifend phasellus suspendisse, vehicula quam etiam euismod hac nam nisi magna aptent hac placerat cursus. \naliquam posuere curabitur augue nunc ultrices purus orci, pulvinar venenatis conubia ut quam ut maecenas, vehicula diam rutrum ad dolor cubilia. \n</p>\n<p>\neuismod bibendum torquent rutrum platea elit, dictum varius hac. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/greentable/sets/72157603227466774/with/2720397126/{/gallery}</div></dd></dl>', '1', '0', '0', '14', '2013-07-26 11:54:03', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:03', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Consequat turpis leo venenatis \",\"image_intro_caption\":\"Porttitor mattis potenti \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/8_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Consequat turpis leo venenatis \",\"image_fulltext_caption\":\"Porttitor mattis potenti \"}', '', '', '1', '0', '6', 'Eccentric, Minimal, Autumn - Winter, Lifestyle', '', '1', '0', '', '0', '*', ''), ('15', '61', 'Habitasse cubilia orci ', 'habitasse-cubilia-orci', '', '<p>\ndiam blandit et inceptos aliquam nibh at nisi tortor felis fermentum, ullamcorper porta phasellus senectus sollicitudin vestibulum torquent ac facilisis neque, blandit mi semper tortor volutpat vulputate tristique enim eu. \nquisque proin habitasse class fusce tristique taciti augue, id nulla donec tincidunt rhoncus class, ultricies conubia nisl ac aliquam cubilia. \nposuere dolor sed ornare arcu tortor ultrices, a quisque aliquam a bibendum, tincidunt sollicitudin at sollicitudin bibendum. \nodio condimentum porta turpis habitasse nisi duis ante viverra integer, ut consectetur aliquet convallis est porttitor at. \ntorquent ultricies per cursus potenti ut potenti dapibus pulvinar, vehicula consequat cras per sed facilisis est. \n</p>', '<p>\naugue inceptos varius consectetur malesuada habitasse praesent nibh, condimentum feugiat volutpat iaculis aenean imperdiet euismod urna, ut sed cras erat tellus litora. \nnisi arcu quisque inceptos cursus posuere vivamus enim nec cras, luctus tortor dictumst tellus sem tellus sodales elit netus, iaculis egestas pellentesque in phasellus imperdiet vulputate at. \nvestibulum orci curae ultricies etiam himenaeos condimentum habitant quisque massa, maecenas feugiat orci eget urna dolor ultrices neque, nec class cras sodales mi taciti nostra nibh. \net taciti vulputate elementum cursus consectetur scelerisque nullam phasellus aliquam euismod torquent facilisis dapibus cubilia, facilisis mollis curabitur congue morbi a porttitor porta est netus metus porttitor. \n</p>\n<p>\nmolestie vehicula maecenas iaculis ad enim cras posuere quis, condimentum conubia tortor vitae ornare diam ut in, sit nam leo himenaeos leo nostra cursus. \ncras curabitur tincidunt ultrices per tortor curae sem amet, risus eu ipsum ullamcorper vel sit nulla lobortis quisque, mauris class curae quis etiam rutrum ligula. \ngravida curabitur class tincidunt volutpat accumsan odio ullamcorper commodo sapien semper, diam aenean netus curabitur netus vivamus bibendum commodo bibendum congue volutpat, ante lobortis conubia libero ac iaculis porttitor magna turpis. \nenim faucibus sed euismod senectus magna arcu pharetra curae nostra, iaculis eros fames feugiat non dictum odio adipiscing vestibulum integer, justo curae venenatis lacinia at pharetra magna dictum. \n</p>\n<p>\nlobortis metus euismod lobortis ante vehicula primis velit ligula imperdiet sagittis aliquet porttitor, senectus malesuada ante fringilla ipsum euismod vel purus potenti pharetra. \nlaoreet nulla suscipit condimentum ipsum euismod at habitasse aptent lacinia, nibh habitant donec aenean dictum nisi risus eros eget, cursus curabitur volutpat dapibus velit cras molestie sollicitudin. \nmauris rhoncus cursus augue nam nulla varius in nibh nullam, curabitur leo duis risus potenti quam semper netus etiam ultricies, donec blandit feugiat ultricies fames quisque libero habitant. \ndiam lacus diam class litora quisque vulputate ultricies tincidunt, ultrices blandit pellentesque dictumst sit urna imperdiet morbi dapibus, molestie potenti habitant convallis ut elit commodo. \n</p>\n<p>\nac phasellus arcu tristique donec sagittis mauris libero sapien pharetra consectetur, nulla morbi nullam massa varius fames nulla maecenas justo nostra, suscipit non ut ultrices suspendisse senectus et sapien quis. \nenim velit tempor nunc nam inceptos sodales primis pellentesque morbi conubia, tempus egestas elit est aenean libero venenatis pulvinar gravida senectus, vehicula volutpat ultricies id at odio morbi aliquet nisi. \nenim phasellus volutpat orci eu ultricies vehicula arcu, bibendum tempor imperdiet ultricies ut vivamus molestie rhoncus, fusce inceptos malesuada egestas ut morbi. \nadipiscing magna massa quisque, proin. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/satorarepo/sets/72157600213034911/with/7241770212/{/gallery}</div></dd></dl>', '1', '0', '0', '10', '2013-07-26 11:54:05', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:05', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/10\\/26_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Habitasse cubilia orci \",\"image_intro_caption\":\"Posuere et massa elit id sociosqu \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/10\\/26_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Habitasse cubilia orci \",\"image_fulltext_caption\":\"Posuere et massa elit id sociosqu \"}', '', '', '1', '0', '3', 'First Row, Vintage, Autumn - Winter', '', '1', '0', '', '0', '*', ''), ('16', '62', 'Velit rutrum hendrerit netus ', 'velit-rutrum-hendrerit-netus', '', '<p>\nnisl per commodo venenatis commodo netus nibh ut nibh cursus vehicula lacus, ante consectetur primis nullam porttitor eleifend condimentum volutpat odio elit, lectus accumsan duis vestibulum in condimentum risus dolor quis leo. \nsuspendisse quam ligula lobortis justo orci ad consectetur est class ultricies, laoreet vestibulum vivamus adipiscing mollis malesuada egestas sit ad arcu, etiam cursus ut aliquam morbi egestas per quam mauris. \nsuspendisse tristique sed amet leo tempus aliquam et libero consectetur, donec amet maecenas porta habitasse rutrum leo rhoncus, consequat mollis fusce facilisis integer dapibus duis sagittis. \n</p>\n<p>\nadipiscing nam rhoncus id sem vel elementum, suspendisse taciti ac sit ultricies. \n</p>', '<p>\neget per sodales aptent scelerisque phasellus nec vulputate fames pellentesque, habitasse laoreet dictumst risus egestas platea adipiscing augue consequat felis, vehicula at augue pharetra porta varius platea eu. \nenim pharetra gravida est convallis arcu vel mattis feugiat, aenean sagittis etiam amet congue dolor primis pellentesque lacus, proin quis netus malesuada volutpat maecenas sapien. \nfelis enim porttitor aenean lacus himenaeos ullamcorper iaculis phasellus libero, bibendum cursus lacinia vel erat adipiscing primis ad, etiam senectus ultrices felis varius dolor ultrices feugiat. \nnostra congue curabitur fusce quisque tincidunt cursus erat, vivamus ullamcorper imperdiet accumsan elementum sem at, pellentesque odio orci magna torquent vivamus. \n</p>\n<p>\nsollicitudin ligula sem amet aliquam imperdiet varius molestie, luctus duis sollicitudin primis convallis tempus imperdiet quisque, etiam ornare nullam facilisis vel tincidunt. \nlacus lobortis congue fames sit torquent vestibulum dapibus suscipit nullam curabitur sollicitudin sociosqu curabitur aenean, sapien accumsan aliquam ac mollis senectus turpis lectus bibendum inceptos eget aliquam. \nhimenaeos neque lacus curabitur quisque mi quam aliquam per eros viverra sodales, magna nibh nec bibendum imperdiet sem facilisis ut ad iaculis ipsum, rutrum sed libero magna nostra odio condimentum tristique vehicula himenaeos. \naliquam per nostra quisque posuere fusce nisl eu habitasse morbi, arcu vel vivamus a blandit nibh duis elementum sagittis quisque, suscipit fringilla tempus fringilla ipsum fames quam erat. \n</p>\n<p>\nornare leo dui eget porttitor netus sodales, donec taciti auctor praesent aptent, aliquam in dictum ligula nisl. \nlorem himenaeos mi ultrices sociosqu consectetur varius tempor rutrum, eu arcu dolor massa bibendum aenean velit, ornare sit euismod imperdiet id imperdiet cubilia. \nadipiscing nullam purus phasellus congue nam arcu per etiam donec, primis dolor fames mauris eu phasellus consequat urna faucibus, nullam sed magna suspendisse mauris laoreet ultricies faucibus. \nblandit ad accumsan donec leo conubia morbi auctor feugiat porta, varius dictum ipsum eros erat interdum phasellus donec, sollicitudin leo interdum torquent quisque duis est laoreet. \n</p>\n<p>\nmassa aliquam neque dolor taciti rhoncus ultricies torquent odio nisi, pellentesque dolor fusce turpis fringilla euismod ut nunc, sagittis litora aptent donec litora eget molestie at. \nquisque tortor justo integer sem pharetra dictum auctor leo, id duis pellentesque phasellus integer etiam massa, rutrum tincidunt fames vitae mollis aliquam in. \ninterdum rutrum elit euismod et pharetra dictum malesuada, donec mattis amet at bibendum eget commodo in, velit posuere aliquet morbi iaculis erat. \ngravida fames proin fusce aenean dapibus turpis purus est eros, venenatis tristique inceptos amet placerat at ultrices dictum, orci rutrum porttitor vehicula bibendum sollicitudin potenti semper. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/harshlight/sets/72157625091598606{/gallery}</div></dd></dl>', '1', '0', '0', '12', '2013-07-26 11:54:07', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:07', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Velit rutrum hendrerit netus \",\"image_intro_caption\":\"Nunc quam rutrum primis aliquam \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/12_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Velit rutrum hendrerit netus \",\"image_fulltext_caption\":\"Nunc quam rutrum primis aliquam \"}', '', '', '1', '0', '1', 'Chill out, New Release, Trandy, House', '', '1', '0', '', '1', '*', ''), ('17', '63', 'Arcu orci ullamcorper ', 'arcu-orci-ullamcorper', '', '<p>\ndolor rutrum dictum rutrum rhoncus pulvinar platea, nostra imperdiet aliquam risus quisque, himenaeos congue luctus facilisis arcu. \nquam etiam sociosqu nam ipsum luctus feugiat sollicitudin eu faucibus ac in, nunc aenean eget augue dapibus litora lorem diam cursus et. \nmassa integer quam pharetra sodales maecenas at fames sit, posuere adipiscing vel venenatis posuere augue habitasse tincidunt feugiat, turpis molestie class mattis eleifend mollis est. \ncondimentum tempor aliquet volutpat varius quisque maecenas scelerisque erat dui justo, lacinia dapibus donec purus in fames aliquam class enim. \nfeugiat tellus nisl sed tellus lobortis, bibendum suspendisse pellentesque a metus condimentum, viverra auctor hendrerit mattis. \n</p>', '<p>\ntempor pulvinar a et lobortis congue dolor nulla ligula velit, phasellus nam aliquet auctor ac aliquam quisque litora, phasellus commodo etiam consequat netus laoreet elementum condimentum. \nelementum felis nostra senectus ultricies blandit at mauris hac vel dictumst est vehicula iaculis, commodo leo metus bibendum volutpat ante velit pellentesque accumsan turpis praesent lorem, varius donec inceptos donec mi ut ante cras nostra lacus tellus torquent. \ncras id primis donec etiam class urna varius auctor taciti praesent, interdum ligula mauris odio massa dictum diam tellus etiam. \ntortor nostra lacinia sociosqu orci imperdiet massa neque curabitur, quis maecenas et ac in pulvinar fermentum primis porta, blandit dictum habitasse netus leo pretium habitant. \n</p>\n<p>\nrhoncus diam nostra aptent tincidunt dolor cursus semper class ultrices morbi dictumst in, scelerisque id senectus rhoncus maecenas nam tincidunt egestas odio fusce massa, nostra lacus curabitur suspendisse ut vel ultricies urna maecenas senectus vivamus. \ncondimentum fames ante rutrum leo netus convallis eros rutrum, lacus aptent conubia enim inceptos venenatis etiam porttitor, congue justo nulla ante nostra velit nostra. \nhabitasse facilisis blandit eget ultrices iaculis dictumst cubilia lectus convallis curabitur, ipsum consequat posuere ac enim in egestas ligula. \nullamcorper in ut leo proin vehicula donec primis, potenti in suscipit ut ligula sapien et, aptent at pulvinar cursus integer accumsan. \n</p>\n<p>\nconubia accumsan cras aliquam lectus tempus eleifend venenatis nam hendrerit, leo hac massa volutpat ligula fames blandit neque, eu cubilia lectus ornare donec lacus urna congue. \nquisque potenti maecenas nulla netus mattis neque mattis, vehicula mi ac conubia aliquam nec faucibus semper, rutrum viverra vestibulum lobortis vulputate feugiat. \ncras felis morbi curabitur euismod justo suscipit ante, quisque integer nisi ipsum leo odio donec, primis potenti erat ultrices in euismod. \neros potenti eu fringilla risus mattis quisque egestas feugiat tortor per, nunc curabitur hac facilisis nullam pharetra purus arcu egestas gravida, diam conubia aenean vehicula risus urna feugiat viverra vivamus. \n</p>\n<p>\nat convallis volutpat augue morbi netus amet fames dictum euismod sit magna aliquet tellus, ornare porttitor rutrum nostra placerat donec inceptos id fermentum quam eleifend. \npellentesque nibh curae vitae convallis malesuada nisl, class vestibulum augue lacus nec. \nturpis blandit potenti eget quisque duis dolor per duis, imperdiet cursus suspendisse commodo condimentum ultricies dictum nisi ligula, habitasse lacus conubia eros aliquam vestibulum habitasse. \nscelerisque placerat sapien inceptos neque lectus ipsum vitae, per sem morbi congue vivamus nisi ullamcorper, inceptos vulputate volutpat pretium nunc nam. \nfeugiat semper nostra fusce purus accumsan, himenaeos sapien leo porta. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/greentable/sets/72157603227466774/with/2720397126/{/gallery}</div></dd></dl>', '1', '0', '0', '14', '2013-07-26 11:54:09', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:09', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/7_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Arcu orci ullamcorper \",\"image_intro_caption\":\"Per donec sit \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/7_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Arcu orci ullamcorper \",\"image_fulltext_caption\":\"Per donec sit \"}', '', '', '1', '0', '5', 'Modern, Minimal, Inspirational, Avant Garde', '', '1', '0', '', '0', '*', ''), ('18', '64', 'Litora fusce sem ', 'litora-fusce-sem', '', '<p>\ninteger lacus mollis tincidunt velit morbi taciti eget id sagittis, molestie dui aliquam aliquet quis scelerisque tortor lacus aliquet, per taciti scelerisque eros praesent aptent himenaeos aliquam. \naccumsan posuere eleifend amet sodales sagittis metus erat, curae fusce a tellus litora adipiscing malesuada luctus, auctor proin accumsan tempus orci in. \nenim id tellus senectus mattis donec conubia augue ac viverra, ac urna litora augue etiam integer nostra nam netus aenean, posuere tempus lectus dapibus sed ligula vivamus odio. \nmassa duis senectus sed odio placerat dapibus porta amet nec porttitor nec lacus, tincidunt senectus interdum pharetra id urna consectetur accumsan suspendisse semper. \n</p>', '<p>\neuismod hac per pulvinar ligula habitasse nostra odio sapien diam massa posuere nisi, augue aenean consequat tristique sem consectetur cubilia nullam porttitor fusce scelerisque. \naptent sodales vivamus vehicula senectus nullam sit interdum lorem adipiscing aptent ultricies sagittis condimentum egestas tristique quisque, potenti tincidunt gravida risus maecenas cubilia tempus et sit blandit pharetra conubia phasellus faucibus congue. \nsagittis erat vulputate venenatis ornare nullam aliquam bibendum quisque magna malesuada auctor, sapien et platea tempor pellentesque suspendisse sit et fusce eleifend, scelerisque iaculis posuere tincidunt lobortis eu felis donec habitasse sodales. \n</p>\n<p>\nprimis interdum id dictum per aenean lorem proin, egestas in vehicula mattis malesuada donec curabitur lorem, lacinia egestas iaculis interdum nec venenatis. \nadipiscing nam laoreet varius porta accumsan primis fermentum a molestie, morbi eleifend faucibus felis pharetra metus consequat molestie, dui iaculis hendrerit ipsum purus fusce praesent auctor. \nquis ultrices tempor primis venenatis justo suscipit feugiat ut, tincidunt platea nisi donec massa rutrum proin, blandit purus magna varius class habitasse neque. \nmollis vel sociosqu consequat augue platea malesuada tempor senectus, tempor sem porttitor nunc non elementum varius enim, euismod elit venenatis id taciti porta quisque. \n</p>\n<p>\ncubilia purus aliquet praesent curabitur pretium iaculis mollis class, quam tortor nibh aptent nibh viverra donec, quis hac lectus consectetur accumsan at fermentum. \nconsequat nulla augue class euismod ultricies blandit porta curabitur, pulvinar ligula tempus mi blandit ut curabitur ac fringilla, libero praesent aliquam aliquet turpis sociosqu ut. \ncommodo posuere interdum turpis potenti lacus mattis, leo tempor senectus lectus justo per nullam, sagittis sit ut duis sodales. \nfames et viverra porta et elit scelerisque integer tempus semper, lobortis quisque lobortis eleifend laoreet tristique cubilia posuere porta risus, class etiam ultricies quam augue iaculis aliquam litora. \n</p>\n<p>\nsodales fames adipiscing habitasse luctus netus ultricies convallis nisi, nisl molestie etiam nec primis tempor dui tellus varius, sapien lectus porta convallis enim cubilia accumsan. \nquis ante cubilia etiam aenean blandit id dui ligula, quisque ullamcorper class malesuada adipiscing faucibus egestas tellus class, congue ut ac aliquet placerat tortor enim. \ntellus donec feugiat amet taciti sed nisl nulla cras iaculis, potenti duis dictumst fames mi eget justo id, duis lectus risus class viverra dapibus sapien tellus. \nconvallis eleifend porta eleifend urna tempus urna eleifend viverra vitae aliquam, molestie bibendum imperdiet ac sociosqu luctus ultrices justo viverra, pellentesque class interdum massa leo dui etiam ut habitasse. \n</p>\n<p>\ngravida aliquam a facilisis cursus cubilia amet, aliquam odio aenean odio arcu, etiam massa ut scelerisque leo. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '0', '0', '11', '2013-07-26 11:54:10', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:10', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Litora fusce sem \",\"image_intro_caption\":\"Inceptos faucibus ante varius mollis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/6_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Litora fusce sem \",\"image_fulltext_caption\":\"Inceptos faucibus ante varius mollis \"}', '', '', '1', '0', '5', 'New, Action', '', '1', '0', '', '0', '*', ''), ('19', '65', 'Leo dolor vitae ', 'leo-dolor-vitae', '', '<p>\ntempus diam condimentum hac suscipit rhoncus primis, id erat dictum in mi commodo, aptent purus aenean nulla quam. \naenean praesent cras tortor posuere magna euismod ipsum facilisis neque, dolor sodales donec dolor lacinia facilisis netus amet commodo, porttitor convallis per cursus vivamus nostra dapibus iaculis. \nat porta nam vel sodales conubia iaculis mi curabitur ultricies, congue potenti luctus maecenas condimentum conubia potenti metus, aptent suscipit ut fames rhoncus in vehicula aenean. \naliquam maecenas lectus metus vel nostra congue tempor arcu dictumst dolor, sem rhoncus consectetur inceptos rhoncus ipsum ad mi suspendisse, tristique posuere mattis aliquam faucibus vivamus per tortor per. \n</p>', '<p>\nnon aenean et blandit curabitur maecenas risus, odio ligula quam vitae mauris ullamcorper enim, curae suscipit ut metus pulvinar. \nurna tincidunt facilisis elit fusce cursus venenatis aenean felis elementum ut, venenatis amet tempus porta proin semper faucibus suscipit congue, gravida proin congue dolor quis tempus amet pulvinar donec. \netiam orci augue purus primis tortor porta ipsum mattis varius, facilisis mattis in ultrices litora tincidunt aptent metus accumsan, sem tortor inceptos aptent molestie quam ornare sollicitudin. \neu hac turpis ad orci metus nullam, id sociosqu pulvinar porttitor in, enim ultrices class est consequat. \n</p>\n<p>\nplacerat auctor lacus semper varius vestibulum conubia sem urna, sollicitudin aliquam diam nam cursus at class litora, habitant nunc fames feugiat ut velit suscipit. \nduis est suscipit ligula taciti class aliquet taciti sapien pretium aptent, elit viverra libero ornare dolor congue hendrerit ipsum tellus accumsan, nam vehicula donec metus aliquam neque taciti mi donec. \ntellus metus nibh ut amet fringilla luctus justo libero, volutpat etiam scelerisque potenti arcu odio non primis, dolor erat senectus molestie class orci conubia. \nlorem etiam tempus ullamcorper quis ipsum, diam ultrices et faucibus bibendum, consequat inceptos ipsum vitae. \n</p>\n<p>\nvulputate habitasse mauris netus mi egestas habitasse mollis placerat, nibh magna rhoncus tristique donec metus maecenas, porta commodo erat vivamus ultrices scelerisque laoreet. \ntempus a nulla vehicula dictum odio nisi elit justo maecenas, convallis quisque tempor venenatis pulvinar tincidunt pulvinar est, massa hendrerit eleifend suspendisse taciti fames torquent luctus. \ncurabitur elit dapibus ornare venenatis ligula curabitur ut morbi auctor bibendum ultricies justo curae, lectus a mattis leo curae porttitor habitasse rhoncus ante fermentum velit iaculis, maecenas tempus fames eu sed elit mauris etiam tincidunt varius cras consequat. \nmolestie lectus aptent vel tempus odio aliquam maecenas ultrices id per, nulla ornare consequat suspendisse semper enim molestie sagittis gravida inceptos turpis, nisl ut praesent eros est per id semper tellus. \n</p>\n<p>\nest id sem tortor fringilla class tortor egestas et ut accumsan a etiam porta facilisis aliquam vehicula, luctus facilisis lacinia arcu tellus facilisis ornare ultrices malesuada curabitur aenean tristique arcu aliquam. \nconubia aptent fringilla egestas ad aenean massa aenean iaculis sed, sagittis rhoncus phasellus ac ipsum vel rutrum nulla, dictum suspendisse dictum bibendum primis accumsan sem suscipit. \ncubilia taciti a egestas inceptos volutpat varius convallis aenean, donec nec lorem cras risus mollis fringilla condimentum tincidunt, auctor himenaeos cursus egestas dapibus hac faucibus. \ncongue dolor phasellus lobortis ante imperdiet congue velit venenatis, ad habitasse vulputate ultricies sit ut. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=saMhNUmPaJ4{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}</div></dd></dl>', '1', '0', '0', '15', '2013-07-26 11:54:12', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:12', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/15\\/20_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Leo dolor vitae \",\"image_intro_caption\":\"Senectus tortor donec urna \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/15\\/20_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Leo dolor vitae \",\"image_fulltext_caption\":\"Senectus tortor donec urna \"}', '', '', '1', '0', '4', 'Tech, Trendy, Apple', '', '1', '1', '', '0', '*', ''), ('22', '68', 'Odio pharetra platea ', 'odio-pharetra-platea', '', '<p>\nsapien aliquam fames velit etiam phasellus nisi quis, ligula faucibus semper duis nisi eu porttitor, litora felis per facilisis rhoncus neque. \nlobortis eu semper feugiat tempus vulputate metus at leo, aliquet donec vel mi dapibus lorem congue dolor commodo, varius fusce libero curabitur eu etiam eleifend. \naptent commodo sem rhoncus non ad himenaeos inceptos aenean non, euismod nulla donec torquent eleifend donec dictum. \neros tempor iaculis molestie rhoncus mi amet ultrices porttitor, ad sociosqu donec sem netus porttitor convallis, amet risus aliquet lacinia fermentum sociosqu adipiscing. \nsodales consectetur ad diam ut nisi, tincidunt nisi quis pellentesque, class felis purus donec. \n</p>', '<p>\nut tempor fermentum suscipit aenean vulputate fermentum malesuada iaculis, in aenean commodo egestas sed pellentesque semper, odio sagittis hac felis cubilia nisl nec. \nblandit ornare rutrum fusce id nisi nec tempus aenean auctor congue dolor, fermentum urna purus feugiat pellentesque quis rhoncus aliquam nisi integer tincidunt, cubilia eget litora interdum quisque tempus varius himenaeos nunc imperdiet. \namet dapibus auctor sagittis conubia fames donec sociosqu lacus, adipiscing ante gravida curabitur leo erat pretium, tristique mollis hac metus himenaeos donec convallis. \nlaoreet amet erat hendrerit venenatis egestas sapien imperdiet, platea varius malesuada viverra fermentum conubia ad, donec placerat ultrices interdum convallis dictumst, tincidunt eu class varius volutpat imperdiet. \n</p>\n<p>\naccumsan mattis sapien turpis eget fringilla ad et interdum rhoncus quam luctus sem, inceptos placerat turpis donec maecenas fames diam id vitae augue nostra. \njusto nostra ut pulvinar justo eros fermentum quisque class varius molestie platea ipsum, massa integer quisque sed primis nullam nam auctor inceptos ac imperdiet. \nin varius fusce justo quis nulla semper, nisl quisque curae diam pretium risus, cubilia pulvinar facilisis purus tortor. \nelit tristique porttitor donec molestie primis donec purus torquent lorem aliquam adipiscing luctus quisque sollicitudin, integer porta cras ante volutpat pellentesque varius tristique felis fusce et ligula. \n</p>\n<p>\nenim vitae egestas mollis pharetra nibh posuere odio ut sodales nulla, aliquam vivamus bibendum morbi eleifend nibh id est vehicula, accumsan elementum pretium consequat donec fusce at facilisis fusce. \nnec hac taciti in ullamcorper id magna, turpis dui sociosqu quisque per platea, urna per lobortis turpis ornare. \nfringilla tellus nibh eros accumsan ipsum maecenas fermentum enim sollicitudin elementum porttitor maecenas quisque, fames vehicula ante consectetur volutpat integer pharetra facilisis ullamcorper at luctus dolor nibh, porta non lobortis vivamus dui cubilia mattis inceptos tempor aliquam neque hac. \ngravida aenean commodo pharetra aliquet integer arcu viverra et, lacus cursus proin praesent ligula pellentesque accumsan, platea aliquet habitasse curabitur potenti quis posuere. \n</p>\n<p>\nullamcorper bibendum turpis sit tellus faucibus sapien vitae congue, platea quisque odio praesent bibendum torquent varius ornare, class rhoncus curae gravida habitant felis nam. \naptent varius massa iaculis risus conubia euismod ornare dictum lacus nisl, cras class conubia nibh taciti orci ligula pharetra senectus, sodales condimentum ut sodales aliquet urna maecenas lacinia urna. \nmi pretium fusce hendrerit aliquam curabitur elit diam vitae donec curabitur, vehicula consectetur consequat urna quisque quis litora quis aliquam curabitur etiam, ornare turpis interdum sagittis ante nec malesuada eros sagittis. \nnisi dapibus tincidunt netus sollicitudin, habitasse consequat commodo. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div></dd></dl>', '1', '0', '0', '10', '2013-07-26 11:54:18', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:18', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/10\\/2_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Odio pharetra platea \",\"image_intro_caption\":\"Mollis imperdiet sociosqu praesent \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/10\\/2_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Odio pharetra platea \",\"image_fulltext_caption\":\"Mollis imperdiet sociosqu praesent \"}', '', '', '1', '0', '2', 'Trendy, Vintage, Italian, Coutoure', '', '1', '0', '', '0', '*', ''), ('23', '69', 'Inceptos arcu varius a libero nullam ', 'inceptos-arcu-varius-a-libero-nullam', '', '<p>vivamus dapibus justo amet purus molestie purus placerat mauris, leo adipiscing conubia himenaeos proin tincidunt malesuada, magna nisl nullam malesuada sed semper eros. pharetra interdum sollicitudin quam porta facilisis tincidunt ac scelerisque semper, iaculis vivamus habitant gravida cras tincidunt ante mattis, morbi elit quam euismod adipiscing dictumst habitasse per. curabitur sit class nostra dictum lectus dolor pellentesque, scelerisque mi turpis pulvinar inceptos molestie phasellus lobortis, facilisis tortor sit integer ipsum blandit. phasellus aliquam ante hendrerit vitae proin orci, non consequat dictumst at congue feugiat, iaculis lacinia justo aliquam a platea, risus ante in arcu quisque.</p>\r\n<p>viverra sed commodo fusce, taciti.</p>\r\n', '\r\n<p>laoreet vitae senectus lobortis pulvinar egestas varius adipiscing aliquam viverra gravida nibh nullam ut, varius risus faucibus quisque litora vivamus sagittis nulla euismod dapibus imperdiet fusce. viverra diam condimentum auctor praesent ac arcu sodales aenean pulvinar vel, cursus molestie eu tempor cursus quisque metus arcu justo, consectetur congue dolor quam placerat ipsum nibh vivamus scelerisque. aenean ligula tellus donec vivamus fringilla rutrum taciti sagittis, quisque et auctor semper senectus ornare torquent est, in litora gravida metus at accumsan per. etiam scelerisque habitant suspendisse diam eu curae dui nibh ante, nec adipiscing neque platea proin est rhoncus curabitur.</p>\r\n<p>nostra bibendum scelerisque lectus primis habitant vivamus mattis hendrerit, duis sollicitudin cursus egestas inceptos luctus eros, aliquam rhoncus maecenas viverra per etiam auctor. per lorem leo nulla id laoreet arcu integer, velit praesent in fusce sed pulvinar phasellus, himenaeos inceptos mollis eu lorem tortor. turpis eget accumsan metus turpis nulla ultricies class pulvinar, interdum consequat quam hac proin tellus diam ut, ipsum semper rutrum metus duis sit cras. urna habitasse metus consequat eleifend ligula sociosqu, viverra adipiscing consequat class urna, massa taciti primis conubia lacus. mollis himenaeos massa tempus pulvinar aliquet posuere in, ipsum suscipit mollis volutpat nec ut sociosqu turpis, elementum sodales nostra commodo placerat nec.</p>\r\n<p>blandit pulvinar ultricies nec imperdiet enim sed habitasse potenti vivamus aenean, est congue vel morbi class tempus sagittis justo cras. libero consequat in mattis lorem mauris in senectus, lacinia euismod vestibulum placerat torquent integer nisl, luctus potenti vivamus quis donec quisque. molestie lorem accumsan at nulla ultricies quisque scelerisque integer, quisque augue consectetur morbi auctor magna. est rhoncus vulputate semper sed consequat vivamus nisl velit cras, taciti sed consectetur sed nam netus sodales orci congue platea, sociosqu eget litora eu netus blandit lacinia ipsum. fermentum mollis quis suscipit feugiat suscipit sit scelerisque curabitur porta augue, magna porttitor ultricies vestibulum etiam curae ultrices curabitur nisi, mi purus netus lacinia facilisis ligula velit tempus sit.</p>\r\n<p>sollicitudin ac feugiat etiam vulputate suspendisse ornare tortor iaculis ac, placerat nullam suscipit blandit praesent dictumst semper hendrerit nibh, ultricies varius aptent scelerisque suscipit erat eu aenean. eu egestas lectus tortor malesuada amet duis tempor a, hendrerit himenaeos fringilla quam massa placerat feugiat justo ac, rutrum luctus placerat etiam leo varius eu. semper aliquam odio amet quam lorem sed, etiam porttitor viverra vitae platea ac, odio nostra potenti tincidunt interdum. primis ligula potenti libero arcu neque arcu dictumst, lacinia habitant vel nullam erat.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=vugB9semEA8{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div>\r\n</dd></dl>', '1', '0', '0', '16', '2013-07-26 11:54:20', '34', '', '2013-07-26 14:03:47', '34', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:20', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/5_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Inceptos arcu varius a libero nullam \",\"image_intro_caption\":\"Aenean ut vel sit sollicitudin \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/5_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Inceptos arcu varius a libero nullam \",\"image_fulltext_caption\":\"Aenean ut vel sit sollicitudin \"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', '5', 'Actors, Epic', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('25', '71', 'Consequat urna mi ut posuere ', 'consequat-urna-mi-ut-posuere', '', '<p>\nultrices iaculis gravida justo accumsan interdum fames lectus dui fermentum tortor consequat fringilla est gravida, eleifend ultrices gravida ultrices quis nec elementum interdum mi in aenean rhoncus. \ndapibus fames donec congue integer neque rutrum sapien consectetur, eleifend et adipiscing interdum laoreet curabitur et lorem arcu, luctus ut habitasse adipiscing erat aptent sit. \neuismod tincidunt aliquet etiam phasellus malesuada dolor conubia porta, condimentum egestas vehicula cras platea sem mi aliquam quisque, massa purus neque eleifend facilisis quam nisl. \neros volutpat odio sollicitudin mattis curabitur commodo mollis per, primis habitant sodales turpis risus justo mattis, gravida fames gravida amet luctus facilisis purus. \n</p>', '<p>\nsodales dictumst hac aliquam rhoncus senectus sociosqu nunc magna dui hendrerit eu sem curabitur etiam nunc euismod, vel at elementum vitae consectetur venenatis lorem sapien vivamus lorem vivamus maecenas praesent suscipit. \nvenenatis imperdiet phasellus faucibus pharetra netus molestie imperdiet placerat netus, aenean donec quisque faucibus tortor augue lacus cubilia non, vulputate magna convallis gravida tristique orci nec volutpat. \ncras per ultrices mollis praesent arcu pharetra pulvinar vehicula cursus vivamus, cubilia primis semper per facilisis laoreet leo posuere justo nulla et, integer eleifend urna integer neque etiam volutpat dui suscipit. \n</p>\n<p>\nvarius fames sed mattis congue condimentum aliquam faucibus aptent, varius eget mi venenatis sociosqu litora sem magna vel, lacinia ut faucibus nec vivamus dui vitae. \naliquet quis condimentum class dictumst tortor lacinia potenti faucibus hac, cras nunc molestie orci sociosqu venenatis tincidunt non pellentesque, litora semper ornare nunc duis quisque odio potenti. \ntorquent donec nulla dapibus massa mi litora placerat sociosqu litora, class arcu duis mattis malesuada litora ultrices ante, neque rhoncus conubia porttitor dolor a integer litora. \nultrices maecenas vitae malesuada duis elementum blandit semper id mattis felis, malesuada semper etiam congue sociosqu etiam vehicula posuere etiam. \n</p>\n<p>\ncurae pharetra malesuada arcu ullamcorper primis laoreet quisque fames lacus ornare, metus tortor ut platea nisl maecenas sodales lacinia bibendum, integer taciti in nisi sollicitudin sapien cubilia magna nisi. \net nec consequat sit aliquet cras netus malesuada, etiam ornare etiam magna pulvinar nulla a quisque, maecenas mollis ultrices accumsan nec dapibus. \nnulla erat sit tristique iaculis malesuada maecenas nec commodo leo phasellus egestas lacinia lobortis, vitae turpis dui vitae placerat curae aenean tellus ullamcorper sodales turpis. \nlobortis nulla at viverra sodales posuere primis augue aptent fringilla tortor dolor tristique lobortis, faucibus in feugiat nibh donec iaculis dolor vivamus cubilia posuere nostra. \n</p>\n<p>\nquisque cubilia convallis est curabitur velit ut adipiscing neque, nullam donec ullamcorper tempor velit etiam aenean, erat suscipit habitant erat torquent auctor congue. \nper quisque amet torquent consectetur dapibus eros morbi nulla ac vestibulum, nisi elementum risus est ultrices sit ipsum pellentesque molestie platea nunc, quis conubia aptent orci rutrum mattis velit ornare urna. \nvelit at lorem aptent mauris eu pulvinar malesuada pharetra sagittis class, aliquam commodo volutpat quam egestas nam vivamus eros vel ad tristique, integer pretium augue vestibulum ligula platea nisi nam convallis. \nconubia magna congue quis tincidunt sociosqu feugiat nulla gravida pretium, mattis sem semper habitasse blandit aliquet lectus leo duis, venenatis ullamcorper ipsum pellentesque nulla proin consequat eros. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}</div></dd></dl>', '1', '0', '0', '13', '2013-07-26 11:54:24', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:24', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Consequat urna mi ut posuere \",\"image_intro_caption\":\"Convallis lobortis duis pulvinar \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Consequat urna mi ut posuere \",\"image_fulltext_caption\":\"Convallis lobortis duis pulvinar \"}', '', '', '1', '0', '5', 'Rock Music, Dinner, Restaurant, Cozy', '', '1', '0', '', '0', '*', ''), ('26', '72', 'At phasellus aptent laoreet ', 'at-phasellus-aptent-laoreet', '', '<p>\namet leo molestie nostra consequat viverra et primis dictum elementum, ultrices iaculis senectus metus laoreet odio habitant scelerisque, nam suscipit pretium inceptos et sem aptent vulputate. \nleo habitant sapien aptent lacinia praesent varius ut, malesuada porta netus quisque netus fringilla curabitur, erat eget interdum ad curabitur justo. \nadipiscing donec suspendisse himenaeos metus suspendisse pellentesque dictum arcu massa vel luctus aptent, aliquam aptent mollis donec aliquet elit posuere lectus dui diam id, turpis volutpat malesuada mattis ullamcorper netus neque sociosqu ante etiam tincidunt. \nleo interdum primis odio donec eros lobortis, dictumst et curae class iaculis ut, elementum consectetur augue tellus tempor. \n</p>', '<p>\nsodales phasellus et lacinia auctor varius lobortis aliquam at fames condimentum ad habitant, id porta aliquet nibh himenaeos quis integer morbi blandit magna ultrices. \nsapien lacinia porta taciti diam sed tempus cursus fermentum mollis, ut taciti duis tempor curabitur non habitasse vel eros bibendum, euismod volutpat curabitur venenatis taciti nostra conubia leo. \nsuspendisse vulputate aliquam habitant suspendisse sit a nisl duis, mollis tempor nisl volutpat egestas in aliquam at, enim eros tellus phasellus per litora eros. \nsagittis proin auctor nostra ante maecenas donec non aliquam ultricies, vehicula massa varius eget sapien molestie rhoncus conubia consectetur metus, diam eget malesuada condimentum id amet vivamus turpis. \n</p>\n<p>\nultricies in posuere taciti morbi ipsum lectus, dictumst amet eros etiam. \ninteger scelerisque taciti dictumst nulla malesuada duis eget fringilla felis mattis, ultrices curabitur gravida curabitur nostra ante elit potenti porta, mauris hendrerit vestibulum urna pharetra tristique consectetur fringilla sed. \nmalesuada nulla dictum sit hac non etiam suspendisse taciti, consequat semper ipsum ut sociosqu iaculis aliquet elementum class, nam ipsum lobortis curabitur rutrum libero netus. \nin taciti class tellus eros malesuada felis aenean pulvinar dolor, a id aliquam neque vivamus euismod sed fames dolor, iaculis sit vel enim ut phasellus aenean imperdiet. \n</p>\n<p>\nlectus est lacus class sem urna aliquam ut ornare neque, justo metus est augue nam etiam lorem ligula, etiam ullamcorper semper potenti nisl mi ornare imperdiet. \nvehicula commodo platea donec id, taciti venenatis eros in hendrerit, morbi tincidunt pulvinar. \npharetra himenaeos sed morbi erat curae class, tempor phasellus adipiscing ultricies quisque, consectetur est cubilia ligula laoreet. \nplacerat dictum cras eu condimentum justo ut consectetur odio suspendisse, pulvinar cubilia curae integer imperdiet pharetra vulputate duis. \npulvinar libero sapien imperdiet luctus vivamus habitant enim ad euismod, pulvinar in pellentesque bibendum vivamus ad nostra est, tempus libero praesent sodales malesuada urna fringilla eget. \n</p>\n<p>\neros porttitor viverra lobortis pulvinar habitasse cubilia aenean odio class at, primis habitasse arcu aliquam volutpat condimentum et pulvinar pretium ultrices, sapien per morbi taciti posuere ultricies neque massa conubia. \ndiam scelerisque aenean euismod rhoncus gravida primis libero varius rutrum vulputate vitae libero, aliquam ullamcorper aliquam sapien eros etiam nibh diam ultricies pretium pharetra ante risus, posuere etiam diam laoreet curabitur tortor quisque ultrices nibh massa sociosqu. \nfacilisis per feugiat magna suscipit varius praesent morbi luctus cursus phasellus, ut malesuada aenean per nunc dictum curae rutrum accumsan. \nporta ultrices sodales massa quam ac justo, diam eleifend malesuada torquent nulla, urna etiam feugiat semper nisi. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '0', '0', '11', '2013-07-26 11:54:26', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:26', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"At phasellus aptent laoreet \",\"image_intro_caption\":\"Accumsan quisque mollis id primis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/8_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"At phasellus aptent laoreet \",\"image_fulltext_caption\":\"Accumsan quisque mollis id primis \"}', '', '', '1', '0', '4', 'Comedy, Drama, Epic, Anime', '', '1', '0', '', '0', '*', ''), ('27', '73', 'Purus sit facilisis per mi ', 'purus-sit-facilisis-per-mi', '', '<p>elementum ullamcorper risus viverra venenatis himenaeos nisl fames ipsum, rhoncus molestie eget euismod per est donec quisque fames, posuere tempus vulputate dui ac aenean orci sociosqu, imperdiet leo phasellus integer nec aenean lorem. suscipit sagittis donec dapibus magna pretium a conubia eu, laoreet et sociosqu suscipit conubia condimentum massa, gravida augue facilisis condimentum purus sed pharetra. fames ipsum faucibus porttitor nunc magna ipsum etiam elementum quis faucibus, pellentesque consectetur donec nostra ipsum dapibus eleifend quisque habitant dictumst, vestibulum curabitur elementum sociosqu ipsum vulputate sit varius quam. id phasellus lectus malesuada elit nisl ante eu, praesent vestibulum nostra curabitur habitant ante.</p>\r\n', '\r\n<p>sit praesent turpis litora inceptos libero maecenas, tellus id libero fringilla potenti interdum, cubilia habitant litora leo amet. platea duis suspendisse quis commodo in libero eros cubilia dictumst enim fames, arcu nullam cubilia sagittis euismod elit ante posuere sodales. sem vestibulum aptent habitant tellus mi libero luctus, fermentum feugiat donec ornare augue donec sit, egestas risus cubilia platea inceptos phasellus. dictum nulla id commodo morbi nullam condimentum pretium, morbi malesuada ut fusce volutpat tortor curabitur hendrerit, in vehicula nullam nunc mi dictumst. sem tellus integer suscipit class magna sociosqu mollis elementum vitae cursus libero eleifend, lacus scelerisque pharetra lobortis cras posuere proin cubilia quisque diam.</p>\r\n<p>curabitur ut nostra sit facilisis dapibus nisi massa ut interdum, est habitant non potenti quisque magna erat viverra ornare aliquam, tellus sociosqu donec dui leo rhoncus arcu ut. lacinia ad aliquet sagittis pharetra ac senectus morbi mollis conubia primis bibendum, tincidunt vehicula a neque est et pellentesque placerat elit. scelerisque dictumst egestas ut rhoncus placerat diam semper, nullam massa euismod ut sapien amet aliquam, felis nam arcu dapibus luctus mauris. erat fusce nisl adipiscing odio sed malesuada feugiat dui a netus inceptos proin praesent ac, sociosqu pellentesque dictumst augue nullam tempus tortor aliquam cursus leo erat aliquam.</p>\r\n<p>ut hac massa ligula tempor donec nibh risus sit condimentum iaculis, viverra amet posuere eget semper purus conubia platea sodales. vulputate litora aliquam felis platea habitant viverra metus luctus sodales sem praesent neque elit curabitur tincidunt enim, hac amet class felis consequat et nullam hac ultrices ultricies etiam egestas ornare ultrices porttitor. orci platea potenti interdum quis non luctus neque rhoncus semper fames, curae netus lacinia molestie class dictum aptent accumsan ultrices risus eleifend, pretium vulputate enim fermentum quam lacus pulvinar non ornare. adipiscing semper integer sapien magna vel pulvinar dapibus donec, curabitur ac curabitur ut enim praesent mattis nunc placerat, ad per hac scelerisque ornare ut conubia.</p>\r\n<p>etiam vivamus posuere mattis pulvinar turpis vehicula dui sollicitudin erat a, cubilia pretium ut ornare class ac et eros purus erat imperdiet, facilisis auctor etiam erat vel laoreet potenti himenaeos nibh. eget dui vitae feugiat felis eget curabitur varius potenti, pulvinar commodo consequat rhoncus dictumst eleifend non aliquam, venenatis rhoncus morbi amet mi sociosqu torquent. blandit euismod felis orci viverra posuere habitasse arcu litora diam aenean, pharetra ipsum quam erat praesent adipiscing eu habitant torquent nunc, ac enim maecenas dui viverra etiam sociosqu arcu rhoncus. diam ac tempus cubilia, mollis.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div>\r\n</dd></dl>', '1', '0', '0', '16', '2013-07-26 11:54:29', '34', '', '2013-07-26 14:03:26', '34', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:29', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Purus sit facilisis per mi \",\"image_intro_caption\":\"Lacinia phasellus a sagittis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/4_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Purus sit facilisis per mi \",\"image_fulltext_caption\":\"Lacinia phasellus a sagittis \"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '4', 'Performance, Actors, Drama, Epic', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('28', '74', 'Bibendum diam habitasse etiam ', 'bibendum-diam-habitasse-etiam', '', '<p>\ndictumst turpis libero sollicitudin pellentesque diam duis quam, rutrum at nec nam duis aenean, etiam dictumst rutrum praesent augue habitasse. \ntincidunt auctor ante nisi vel aenean conubia molestie odio, fusce vivamus tortor ante scelerisque dui duis ut curabitur, lobortis nec morbi sapien diam curae ipsum. \ncondimentum non pellentesque diam fermentum etiam lacus vitae nisl, rutrum eleifend maecenas ullamcorper ipsum pretium integer, class vitae curabitur himenaeos posuere aenean felis. \nmolestie maecenas viverra amet pulvinar nisl arcu donec suscipit gravida aenean et curabitur, purus ac pellentesque imperdiet aptent aliquet fusce sollicitudin torquent adipiscing. \n</p>\n<p>\ntaciti duis eget aliquam accumsan posuere, luctus tempor magna. \n</p>', '<p>\ntorquent cubilia class eros ut quisque est nunc vitae, quis cubilia rhoncus fringilla inceptos netus etiam, pretium nam commodo ornare leo scelerisque lacinia. \nligula consectetur aliquet eu sapien porta augue est, aenean class nulla maecenas cubilia ullamcorper aliquet eu, sagittis habitasse convallis hac sit curabitur. \nvolutpat phasellus ligula habitasse lacinia porttitor feugiat augue cursus, rutrum varius ad lorem metus curae placerat, ante interdum luctus ullamcorper malesuada metus gravida. \nhendrerit leo congue auctor luctus nisi aptent luctus lectus, aliquet etiam praesent tincidunt aenean ipsum netus vestibulum tortor, fames arcu habitasse iaculis lobortis nullam orci. \n</p>\n<p>\ncras aliquam bibendum sodales velit platea phasellus ornare tortor, tincidunt laoreet ad sociosqu senectus suspendisse ut inceptos, volutpat nulla pretium hendrerit netus ullamcorper placerat. \ncurabitur donec pulvinar curabitur lacus a, auctor ad commodo neque orci nam, aenean a class aliquet. \nvestibulum amet curabitur nibh augue habitasse arcu scelerisque condimentum, sit aptent senectus elementum nostra mollis dapibus, per tortor egestas arcu quam scelerisque pulvinar. \nscelerisque tempus odio metus maecenas curae nostra rutrum venenatis ullamcorper risus nam, rutrum pulvinar potenti vivamus torquent a eu purus leo. \nsemper dapibus torquent suspendisse consequat vitae primis dolor egestas placerat ornare, primis curae molestie himenaeos mollis conubia tortor pretium maecenas aliquet, primis mi sagittis himenaeos morbi est sit elementum quam. \n</p>\n<p>\nbibendum ut quisque faucibus suscipit cursus aliquet hendrerit praesent malesuada, viverra aptent purus vestibulum primis urna vitae ac. \nvitae morbi feugiat dapibus dictum malesuada faucibus etiam platea mattis lorem inceptos, et aliquet nisi feugiat lectus amet consequat laoreet urna magna tempus curabitur, in aptent odio suspendisse phasellus vivamus mauris pulvinar metus volutpat. \nnostra proin conubia donec fermentum augue platea facilisis aptent primis, ad torquent inceptos habitasse posuere donec imperdiet elementum auctor, turpis proin sapien molestie nulla velit nullam congue. \ndolor eu suscipit quisque hendrerit tristique mollis donec, dapibus pulvinar venenatis integer etiam tristique, faucibus ornare quis aliquam hendrerit felis. \n</p>\n<p>\nfames aliquet semper nec potenti convallis taciti nullam, nulla quisque velit fringilla class urna dapibus praesent, phasellus viverra sagittis tempor fames phasellus. \nsit habitant donec lacus interdum viverra inceptos sed maecenas praesent platea, nisl fusce luctus augue maecenas condimentum habitasse habitant ad et blandit, nec quisque hendrerit augue lorem morbi ac sociosqu varius. \nposuere interdum nec tempor consectetur viverra ullamcorper praesent porta, vehicula duis inceptos eu facilisis habitasse varius, at sem himenaeos venenatis mollis dapibus ut. \nmetus potenti hac blandit class sit tempus, vestibulum sed aliquam eros ullamcorper pretium, aptent integer accumsan nisi taciti. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}</div></dd></dl>', '1', '0', '0', '13', '2013-07-26 11:54:30', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:30', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/5_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Bibendum diam habitasse etiam \",\"image_intro_caption\":\"Neque justo etiam lobortis pulvinar pellentesque \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/5_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Bibendum diam habitasse etiam \",\"image_fulltext_caption\":\"Neque justo etiam lobortis pulvinar pellentesque \"}', '', '', '1', '0', '4', 'Trendy, Crowded, Cozy', '', '1', '0', '', '0', '*', ''), ('30', '76', 'Dictumst vulputate neque quisque lacinia ', 'dictumst-vulputate-neque-quisque-lacinia', '', '<p>\nduis libero accumsan viverra nostra pharetra auctor interdum auctor quisque, velit lobortis fermentum arcu justo tristique ultricies lorem congue dolor, torquent quis lorem cursus platea condimentum porttitor senectus. \nsem ipsum cursus torquent rhoncus aliquam quis class nulla dictum luctus ornare, fames lobortis ultrices ut fringilla curabitur nullam volutpat hac. \nlacus viverra nulla tristique nullam morbi etiam integer phasellus ipsum senectus, suscipit cursus purus commodo torquent suscipit vel mattis maecenas. \nsit nullam mollis lacus curae turpis vitae amet, aenean turpis erat nam hac consequat, amet rutrum laoreet dictumst ullamcorper donec. \n</p>\n<p>\ncongue posuere vehicula leo orci etiam netus, sagittis fames fringilla fusce. \n</p>', '<p>\nodio curae venenatis sem platea iaculis vivamus maecenas vehicula faucibus, ornare donec massa ut sollicitudin volutpat odio vivamus nostra egestas, rutrum torquent sit sociosqu interdum maecenas praesent cursus. \ntorquent fames pharetra purus sed duis dictumst tempor aliquet vivamus ullamcorper placerat, senectus nibh proin eget pulvinar eu turpis quis consequat senectus. \niaculis quis litora pellentesque sapien ultrices integer massa, porttitor velit curae senectus malesuada pellentesque mauris dapibus, praesent tristique tellus id nibh aliquam. \nmollis iaculis quisque nullam eros urna phasellus cursus, nisl etiam aliquam euismod nisi nulla, ac sem sagittis fermentum massa sodales. \n</p>\n<p>\nquam fermentum maecenas ipsum ultricies congue urna erat vitae massa, congue laoreet gravida eget donec porttitor et nisi, congue accumsan cubilia potenti donec aptent ligula justo. \nfelis non quam maecenas velit torquent curabitur aliquet aliquam duis, justo tellus scelerisque convallis malesuada ante aliquet netus ut, mi lobortis aliquam euismod tempus bibendum mollis aliquam. \ndolor ligula quam pellentesque risus, vitae metus primis ante non, nullam proin feugiat. \nmaecenas vestibulum faucibus ligula laoreet convallis dui risus augue quam praesent, eu ad sit molestie varius viverra per consectetur volutpat a neque, gravida accumsan a commodo malesuada et magna aenean sollicitudin. \n</p>\n<p>\nvehicula torquent adipiscing vehicula pellentesque luctus tortor duis, sagittis tristique mattis quisque leo cras, gravida etiam semper est ipsum morbi. \nprimis mattis donec dapibus suspendisse ut ligula cubilia scelerisque tempus elit per fringilla quisque, viverra pellentesque magna volutpat pharetra lorem hac eros leo potenti risus class magna nisl, sit vestibulum condimentum at aptent vestibulum sollicitudin pharetra convallis euismod convallis aptent. \nultricies rutrum praesent curabitur ut purus morbi ad quisque rutrum feugiat primis, congue viverra tempus orci neque at mollis malesuada aenean sapien, elit curae venenatis erat aliquet ad fames pharetra quis est. \n</p>\n<p>\nnec pellentesque ac praesent pretium tellus ut proin nostra ipsum tempus, primis conubia turpis etiam elementum sociosqu volutpat augue vel fringilla, nam hac aliquam placerat donec arcu ad varius feugiat. \nconsequat ut quis cursus rutrum laoreet vulputate vestibulum potenti in, libero dapibus aenean facilisis volutpat hac ornare eleifend, cubilia adipiscing risus semper potenti sagittis mollis dapibus. \nturpis molestie felis turpis accumsan cursus curae arcu at sed, aenean hendrerit viverra leo tincidunt euismod eros quisque elementum venenatis, platea duis velit libero congue aptent nam sit. \npulvinar dapibus vivamus nisi malesuada lectus facilisis laoreet tristique, vel hac class massa duis rutrum in vitae, augue habitasse netus etiam lectus vitae hac. \n</p>\n<p>\njusto convallis non volutpat sodales metus cras, curabitur himenaeos hendrerit dapibus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}</div></dd></dl>', '1', '0', '0', '13', '2013-07-26 11:54:34', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:34', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/7_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Dictumst vulputate neque quisque lacinia \",\"image_intro_caption\":\"Inceptos sapien pulvinar nisi \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/7_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Dictumst vulputate neque quisque lacinia \",\"image_fulltext_caption\":\"Inceptos sapien pulvinar nisi \"}', '', '', '1', '0', '3', 'Dance, Dinner, Restaurant, Cozy', '', '1', '0', '', '0', '*', ''), ('32', '78', 'Inceptos etiam hac nisi ', 'inceptos-etiam-hac-nisi', '', '<p>\ncurae integer habitant volutpat dictumst porta nisl sed, a aliquet praesent placerat primis turpis accumsan malesuada, mattis ut molestie ut ornare placerat. \nnec vel tristique laoreet non elementum quam varius urna diam, aenean vivamus tellus iaculis sociosqu aenean hendrerit pulvinar nullam non, lacinia interdum leo id ullamcorper platea lobortis integer. \nconvallis venenatis gravida aliquam curae adipiscing torquent viverra dui ipsum fames, aptent ut nulla dictum etiam accumsan velit volutpat. \nfringilla purus pellentesque pharetra curae quam dictum et vivamus vestibulum curabitur, egestas dui convallis luctus interdum ut nunc ligula. \n</p>\n<p>\nnec odio molestie nullam nisl, maecenas tempor taciti aliquam, eget ligula tempus. \n</p>', '<p>\npretium eget fermentum convallis dictumst cubilia viverra augue, ac per nam quis sit aliquam justo a, maecenas facilisis suscipit at inceptos taciti. \ndolor nostra vehicula curae mauris curabitur placerat arcu risus, mollis sem amet sollicitudin sagittis risus litora pretium, platea pretium est suscipit quis lectus erat. \nrhoncus fames euismod id etiam purus sagittis faucibus aenean, tincidunt vivamus erat in sapien senectus convallis vel eget, dictum lobortis inceptos posuere tellus urna lectus. \nid nibh amet lectus nisi nunc malesuada accumsan, urna feugiat felis hendrerit ipsum turpis orci quis, interdum pellentesque laoreet urna mauris egestas. \n</p>\n<p>\ncommodo pretium iaculis tortor elit odio eget etiam condimentum laoreet egestas, torquent curae ante ut mi gravida habitasse lacinia et dui adipiscing, nunc adipiscing nisl cubilia eros nunc morbi nec ligula. \nnostra ad velit malesuada orci massa hendrerit fermentum, ligula non integer non cursus congue dolor, suscipit congue volutpat auctor vivamus nisi. \npraesent curabitur quam consequat sociosqu purus accumsan velit, vitae commodo gravida placerat euismod vitae, fames vivamus a platea ornare morbi. \nmaecenas rhoncus phasellus leo porttitor ligula aliquam cursus aenean, rhoncus hendrerit vel mattis litora diam. \neuismod aliquet cras aptent curabitur luctus tempus urna sem placerat porta luctus netus, dictum per neque gravida ad consequat himenaeos risus senectus lacinia faucibus, curabitur gravida lorem vehicula potenti nullam aliquam tortor hendrerit enim commodo. \n</p>\n<p>\nac semper dictum fusce dictumst lobortis mollis vehicula leo, nam accumsan leo fermentum elementum dictumst mi ornare elementum, curabitur justo nibh in consequat mattis hac. \nvelit neque nullam pulvinar ad risus quisque blandit dictum nulla dolor velit potenti, egestas fames placerat odio netus faucibus eleifend tellus fringilla urna hendrerit sapien diam, quam taciti metus dictumst nisi aenean placerat aliquet ac porta vel. \nvenenatis hendrerit a dapibus mauris mollis fringilla amet ante, vivamus est aptent suscipit taciti ad quisque posuere, libero risus libero a sollicitudin vivamus commodo. \naccumsan ultrices taciti venenatis non duis torquent, orci pulvinar adipiscing ullamcorper tristique, semper nisl justo interdum vel. \n</p>\n<p>\nbibendum curae elementum proin nulla gravida curabitur diam euismod nunc nostra vehicula, ornare vel nostra quam pellentesque sociosqu aliquam aenean quis neque leo litora, vestibulum luctus vitae mi malesuada ultrices nisl quis curae nibh. \ngravida luctus dui amet ac venenatis volutpat tincidunt netus dictumst, id felis lorem justo vitae interdum diam aliquet, massa ullamcorper urna fusce bibendum rutrum elementum quam. \nsed lacus potenti nec fermentum donec sapien conubia egestas primis porttitor fames, euismod nam auctor arcu fermentum viverra himenaeos hendrerit himenaeos justo. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dance_photographer/sets/72157624625077098{/gallery}</div></dd></dl>', '1', '0', '0', '8', '2013-07-26 11:54:37', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:37', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/8\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Inceptos etiam hac nisi \",\"image_intro_caption\":\"Eu ut semper eleifend nostra curae \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/8\\/3_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Inceptos etiam hac nisi \",\"image_fulltext_caption\":\"Eu ut semper eleifend nostra curae \"}', '', '', '1', '0', '4', 'Sensational, New, Samba, Tango', '', '1', '0', '', '0', '*', ''), ('34', '80', 'Dictum amet ut sapien ', 'dictum-amet-ut-sapien', '', '<p>\nauctor ante integer turpis sit habitant eleifend nunc, arcu lorem vitae pellentesque viverra. \npellentesque mauris molestie ut ad consectetur dui molestie egestas imperdiet, lacus sagittis lacus aenean etiam ligula facilisis habitasse, et magna lorem est tempus per sapien nisi. \nelit volutpat semper praesent cursus sem, venenatis aptent nunc rutrum tempor quisque, purus dui turpis lacus. \nurna metus ultricies proin enim nec lectus mattis vulputate ornare, iaculis himenaeos nisl pulvinar cursus primis pulvinar ut sit, donec pulvinar tristique porttitor blandit fames auctor maecenas. \nlaoreet proin etiam molestie donec suspendisse tincidunt, quisque arcu libero duis aliquet orci, nunc fusce taciti donec faucibus. \n</p>', '<p>\nrisus vel sapien commodo potenti blandit dapibus vel litora, mauris ultrices amet quisque libero adipiscing tempus tristique eleifend, ante viverra amet ut a suscipit nam. \naliquam nisi luctus praesent turpis molestie lectus proin feugiat orci, curae habitant auctor eros eleifend dictumst ut urna dapibus volutpat, blandit consectetur enim bibendum id risus massa dapibus. \nnullam molestie commodo vitae congue nibh facilisis morbi, faucibus imperdiet at mauris varius viverra sit hendrerit, tortor fusce dui vitae suspendisse amet. \nplatea fusce eleifend molestie vitae odio consequat nullam, bibendum torquent egestas lacinia cras orci quisque accumsan, tempor placerat purus suscipit luctus rhoncus. \n</p>\n<p>\nvenenatis feugiat consequat leo sem viverra placerat faucibus amet mauris, platea eleifend amet mollis consequat magna netus nisl feugiat, fermentum molestie eget litora etiam dictum tempor senectus. \narcu etiam nisl augue praesent taciti neque ullamcorper himenaeos, tellus augue curabitur ut felis fringilla hendrerit litora, senectus malesuada posuere himenaeos tempus duis eros. \naliquet neque aliquam auctor tellus et vehicula, arcu adipiscing nec facilisis torquent, et cras inceptos lacus et. \nnisl netus dui felis sociosqu volutpat etiam curae aliquam id pellentesque eleifend augue aenean ac, a nisl consequat curae quis sit lobortis aenean ligula erat litora ultrices. \n</p>\n<p>\naenean ullamcorper tempor etiam diam quisque enim litora volutpat dictumst iaculis gravida, malesuada nam rutrum eu potenti quis sociosqu sodales dolor consequat, dolor turpis risus magna imperdiet gravida tortor sed iaculis consectetur. \nsem aenean venenatis aptent sem massa volutpat hac enim, pharetra risus inceptos aliquet urna lobortis aenean. \naugue eu leo purus tellus semper per sociosqu mauris diam cubilia, orci eleifend est turpis tortor massa ut faucibus semper, ante purus bibendum turpis potenti sodales semper inceptos mi. \nprimis viverra pharetra euismod risus curabitur sed placerat a ipsum sit, vitae odio ut quam neque sodales sagittis sit sodales odio, commodo cubilia suscipit platea aliquam himenaeos dictumst per purus. \n</p>\n<p>\nfermentum risus consectetur porta fermentum mollis nec, massa lectus id himenaeos lobortis cursus, proin lacinia faucibus lacus nisl facilisis, nisl facilisis gravida mattis commodo. \nlobortis gravida iaculis aenean dictumst arcu feugiat justo libero, vestibulum turpis congue maecenas morbi mollis lacinia donec mattis, condimentum augue aptent ut turpis bibendum feugiat. \nluctus semper sollicitudin arcu ac quis consectetur purus commodo vestibulum dictum blandit, eget hac ante nisl morbi class lorem habitant conubia ultricies, porta pharetra nec lectus pretium integer dolor faucibus mattis placerat. \namet egestas integer libero lacus aliquet lorem vitae auctor dictum eleifend, curae consectetur lectus posuere ac dictum rutrum pretium lobortis. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div></dd></dl>', '1', '0', '0', '10', '2013-07-26 11:54:40', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:40', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/10\\/17_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Dictum amet ut sapien \",\"image_intro_caption\":\"In etiam purus \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/10\\/17_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Dictum amet ut sapien \",\"image_fulltext_caption\":\"In etiam purus \"}', '', '', '1', '0', '1', 'Catwalk, Autumn - Winter, Coutoure', '', '1', '0', '', '0', '*', ''), ('35', '81', 'Sem torquent curabitur conubia lorem molestie ', 'sem-torquent-curabitur-conubia-lorem-molestie', '', '<p>\nsenectus malesuada donec diam tempor in eu nam dui turpis, augue vestibulum commodo hendrerit magna molestie class aptent class, lacinia enim interdum condimentum est ultricies non quis. \nposuere phasellus sed aptent aenean a hendrerit senectus lacus, ullamcorper sagittis varius auctor a fames sem, augue nostra gravida lobortis lacinia tempus dictumst. \nauctor donec aliquam metus proin etiam rutrum duis dictum donec, urna sem porttitor libero nec quis elit pulvinar consectetur, taciti et inceptos habitant interdum nibh pellentesque suscipit. \nimperdiet interdum integer nam arcu laoreet aenean dapibus conubia, enim suspendisse nisl laoreet eros aliquet cursus, nulla curae massa justo hac enim elementum. \n</p>', '<p>\nerat id nibh pulvinar lorem eu placerat libero inceptos, placerat inceptos feugiat vulputate elementum libero potenti dolor, proin pulvinar senectus ultricies tempor sit nec. \neuismod urna faucibus vivamus molestie pulvinar maecenas ultrices hendrerit senectus, ad aliquam neque nisl donec sit enim vel sollicitudin, litora sit aliquam lacinia est ligula habitasse etiam. \njusto placerat id ultricies potenti massa dui leo ac, eget accumsan torquent luctus venenatis varius rhoncus a, curabitur arcu est magna ornare libero potenti. \nimperdiet dapibus litora potenti et tincidunt accumsan tempor fringilla morbi aliquam, torquent mi et vivamus justo urna eu donec. \n</p>\n<p>\nmalesuada pretium potenti tortor quisque hendrerit eget ad quisque, etiam elementum augue dictumst tortor lectus ante litora, etiam massa commodo posuere quisque fringilla nulla. \nauctor massa libero nisi sed malesuada massa nibh, netus eleifend dictum mi laoreet faucibus diam metus, pharetra adipiscing curae lacinia sociosqu inceptos. \nmi viverra primis euismod himenaeos vestibulum nunc at phasellus, accumsan ullamcorper id justo ipsum eleifend integer euismod, libero varius semper dui orci ultrices mi. \nac aenean quisque nunc habitant taciti elit lectus vestibulum mauris, porta aenean vehicula nisi rhoncus in aliquam sociosqu laoreet, elementum a taciti purus curabitur ornare libero dolor. \n</p>\n<p>\nlacinia euismod maecenas duis euismod mattis mollis, gravida nisl turpis vitae habitasse ornare, felis mollis per suspendisse venenatis. \nsem laoreet scelerisque bibendum maecenas id eros congue dolor suscipit cras, donec nisi dictum quis varius curae ut eros porttitor tempus, volutpat eleifend primis ullamcorper elementum tempor egestas integer cubilia. \nauctor egestas curabitur vehicula mollis fermentum elit nec vestibulum eros justo, erat egestas nisl sociosqu praesent sociosqu ipsum aliquam nullam, dolor posuere vel lacus cubilia quis ligula mauris malesuada. \neuismod mattis non lobortis curae taciti sociosqu, donec accumsan tellus turpis nisl nunc, magna aenean venenatis dui hac. \n</p>\n<p>\nphasellus adipiscing mattis justo mollis lorem felis nibh, egestas phasellus lobortis suspendisse rhoncus nibh hendrerit urna, justo per posuere justo varius blandit. \ndonec blandit eros venenatis ut himenaeos lobortis elit sodales pulvinar arcu, ut gravida lectus urna mollis ut himenaeos phasellus lacus leo imperdiet, auctor vulputate curabitur eu amet erat lorem cras ante. \ncurabitur urna aenean posuere etiam netus molestie suspendisse nostra magna pharetra hendrerit, lorem mollis venenatis torquent accumsan orci imperdiet accumsan rhoncus. \nsed primis semper ante augue elit facilisis duis consectetur et, euismod class tellus aliquam malesuada nec ornare aenean. \n</p>\n<p>\nmi orci sociosqu litora commodo vestibulum velit elementum, libero cubilia arcu lectus convallis arcu rutrum placerat, justo cursus consectetur potenti condimentum tellus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dance_photographer/sets/72157624625077098{/gallery}</div></dd></dl>', '2', '0', '0', '8', '2013-07-26 11:54:42', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:42', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/8\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sem torquent curabitur conubia lorem molestie \",\"image_intro_caption\":\"Tristique fringilla lectus curae pretium \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/8\\/6_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sem torquent curabitur conubia lorem molestie \",\"image_fulltext_caption\":\"Tristique fringilla lectus curae pretium \"}', '', '', '1', '0', '3', 'New, Exercise, Samba', '', '1', '0', '', '0', '*', ''), ('37', '83', 'Id velit consequat consectetur euismod ', 'id-velit-consequat-consectetur-euismod', '', '<p>\naugue egestas dui porta luctus egestas risus lobortis ultrices, massa quam ac inceptos nunc ut nulla, feugiat cursus eleifend ligula quisque sit ut. \nvel rutrum curabitur integer aliquam mauris quis aenean tristique vitae, adipiscing libero hac sodales viverra torquent posuere platea iaculis, ut sagittis massa varius inceptos arcu netus habitasse. \nporta auctor eros venenatis pharetra inceptos eros maecenas, ac ut lorem volutpat vel ultricies, laoreet non elementum lectus fusce risus. \nin fames metus ut mollis lectus vivamus interdum massa phasellus sociosqu, tristique placerat litora imperdiet fames mattis phasellus potenti quis nisl, porta eros mi ornare arcu nibh sagittis venenatis accumsan. \n</p>', '<p>\nclass arcu magna rutrum himenaeos consectetur non in phasellus aliquet quam, convallis ultrices fringilla interdum a etiam massa nulla ac, ultricies suscipit curabitur ipsum in mi gravida eros at. \npulvinar massa dapibus congue curabitur lectus eget rutrum, litora magna justo quisque aliquet posuere, imperdiet volutpat praesent vehicula ullamcorper eget. \npulvinar aptent leo malesuada tellus etiam curabitur porta gravida rutrum pulvinar lacinia, vestibulum pellentesque amet posuere habitasse at erat egestas molestie condimentum. \nvehicula egestas dolor netus ante vehicula curae, ligula sodales maecenas etiam hac lectus fermentum, augue mi laoreet consectetur sodales. \n</p>\n<p>\nultrices dictum dictumst aliquam ligula orci fermentum vivamus ullamcorper eleifend tempor, at interdum rhoncus per auctor tellus amet sodales himenaeos. \nlorem tempor faucibus vulputate elit tempus integer potenti porttitor pretium, phasellus sagittis taciti quis augue metus mauris quisque praesent pretium, tincidunt lectus tortor convallis phasellus quisque elementum nunc. \nbibendum aliquam sem turpis fames sagittis a hac nostra, pretium eget fusce arcu scelerisque dictum luctus nulla purus, luctus consectetur odio sodales molestie torquent faucibus. \nquis varius habitasse himenaeos quisque porttitor primis fames senectus, nisl nisi fusce ac consequat ullamcorper sed amet hac, dui ultrices quis volutpat risus volutpat inceptos. \n</p>\n<p>\ndapibus hac ultrices sodales phasellus lacinia metus commodo nostra sapien, nec eu venenatis elit ad odio pharetra sapien pretium ultrices, laoreet imperdiet laoreet quisque cubilia quisque nulla lorem. \nullamcorper conubia elementum phasellus gravida nulla ultricies id, erat quisque leo sapien a volutpat, aliquam rutrum at placerat senectus placerat. \nlitora turpis volutpat odio et consectetur aliquam netus curabitur torquent felis, cursus mollis vitae aliquam ornare torquent maecenas vestibulum litora. \neleifend ultricies bibendum himenaeos torquent inceptos odio rhoncus, phasellus eu ante porttitor suspendisse ut nec morbi, vel justo suscipit per nibh malesuada. \n</p>\n<p>\nmi fermentum sociosqu curabitur molestie est quis ante tempor, turpis libero hendrerit enim ante nam hendrerit vulputate, pellentesque praesent faucibus laoreet nisi vehicula curabitur. \naccumsan nec varius suscipit sagittis lobortis, lectus pellentesque pulvinar nibh quisque, in sed per vulputate. \nscelerisque dictumst fermentum vivamus interdum viverra nullam laoreet elementum non odio sollicitudin, dapibus donec ullamcorper et platea erat odio posuere per cubilia. \ndui venenatis lectus quis phasellus interdum et turpis ut donec cursus, mollis varius tellus tristique ornare integer neque sollicitudin posuere, faucibus mauris phasellus auctor luctus tempor sed quam posuere. \n</p>\n<p>\nat egestas condimentum gravida tempor curae gravida eget ligula, hac feugiat metus accumsan nunc varius metus netus eget, ut mattis facilisis elementum velit consectetur dictumst. \nconvallis mi amet cursus vivamus, cubilia arcu. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/satorarepo/sets/72157600213034911/with/7241770212/{/gallery}</div></dd></dl>', '1', '0', '0', '10', '2013-07-26 11:54:46', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:46', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/10\\/23_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Id velit consequat consectetur euismod \",\"image_intro_caption\":\"Tincidunt imperdiet dui platea consectetur \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/10\\/23_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Id velit consequat consectetur euismod \",\"image_fulltext_caption\":\"Tincidunt imperdiet dui platea consectetur \"}', '', '', '1', '0', '0', 'Italian, Coutoure', '', '1', '0', '', '0', '*', '');
INSERT INTO `#__content` VALUES ('38', '84', 'Dolor blandit tincidunt leo sollicitudin conubia ', 'dolor-blandit-tincidunt-leo-sollicitudin-conubia', '', '<p>\nconsequat commodo eleifend pellentesque ante commodo volutpat bibendum molestie vestibulum, nostra pharetra posuere vitae sit adipiscing taciti porttitor eget, porttitor nam arcu phasellus mattis sapien maecenas eget. \negestas duis lobortis est tellus nostra ante turpis posuere egestas, aenean habitant enim proin donec vulputate quisque sapien mattis, euismod est massa neque pharetra id at nulla. \neu interdum aenean donec lacus vivamus fames suspendisse purus quis donec, condimentum diam auctor aenean facilisis himenaeos nisi massa tellus potenti, bibendum auctor tellus fermentum gravida ipsum vitae senectus curae. \nlibero sit ac dictumst molestie erat, scelerisque amet integer viverra fringilla dictum, porttitor senectus sollicitudin praesent. \n</p>', '<p>\nturpis mi velit placerat hendrerit sed himenaeos aliquam suspendisse ipsum fringilla commodo sociosqu ipsum posuere, varius lacus posuere tortor mi dolor iaculis volutpat luctus conubia dictum lacus. \nligula sagittis duis semper aliquam lectus amet sapien, interdum commodo nam adipiscing nam justo aliquet cras, ultrices lacinia tincidunt risus platea quisque. \nsemper et ipsum vestibulum sociosqu duis interdum lectus suscipit pharetra sollicitudin, tempus habitant blandit malesuada consequat mollis eleifend at pretium augue aliquet, viverra vehicula aenean duis suscipit ullamcorper quisque maecenas id. \ntincidunt vehicula vulputate sapien quisque diam cubilia mollis, eros diam nisi inceptos litora auctor iaculis velit, scelerisque libero interdum egestas vehicula augue. \n</p>\n<p>\njusto malesuada at primis et ante, gravida cursus sociosqu maecenas a, aptent ut maecenas odio. \npellentesque hendrerit quisque fames mi mattis gravida magna justo aptent vitae integer inceptos gravida amet potenti lectus consectetur, accumsan quam malesuada aenean congue dolor tempor vel platea ante purus primis elit quisque dapibus. \nsociosqu pharetra etiam nec fringilla sodales fusce purus erat est, blandit in enim vehicula consequat habitant sed lobortis. \narcu duis erat ligula nullam sollicitudin hac curabitur mattis, eros mollis conubia nostra inceptos primis condimentum risus, lorem consequat auctor porttitor aliquet ultricies cubilia. \n</p>\n<p>\nfelis curabitur ullamcorper sagittis vulputate commodo volutpat convallis odio venenatis, viverra adipiscing luctus placerat arcu congue eu semper, lectus ac sociosqu netus hendrerit ante gravida etiam. \nproin pellentesque in senectus ullamcorper quisque sollicitudin urna convallis eleifend pretium purus proin, luctus cras purus dolor consequat dictum cursus leo convallis fringilla elementum. \nnisl nostra inceptos luctus curabitur egestas quisque imperdiet vivamus sagittis, fermentum sodales placerat lacinia posuere eros enim justo, accumsan sagittis dictum tempor malesuada suscipit sagittis metus. \neleifend iaculis euismod augue fringilla primis proin egestas netus vulputate, condimentum quisque vel commodo odio suspendisse pellentesque ad vivamus mi, conubia eros placerat scelerisque posuere quisque taciti elementum. \n</p>\n<p>\nposuere lacus ultricies praesent potenti nullam mollis et interdum suscipit, vivamus etiam senectus condimentum mollis consequat cursus metus euismod, dolor integer ultricies lacinia curabitur suscipit curabitur sodales. \naugue tempor senectus facilisis orci himenaeos accumsan etiam turpis litora magna massa, orci integer nisl curabitur nisl turpis ante nam aptent. \nurna tempus felis diam sit convallis, ut viverra phasellus inceptos elementum, maecenas viverra elementum facilisis. \nsapien et quis diam aliquet diam malesuada sodales ut porta ornare lectus, class aenean urna accumsan risus quam fames mauris facilisis dui eros iaculis, metus potenti convallis ornare malesuada aenean himenaeos at ut congue. \n</p>\n<p>\nposuere non gravida ut imperdiet, duis lacus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/cottonblue/sets/72157604378940701/with/3207798737/{/gallery}</div></dd></dl>', '1', '0', '0', '9', '2013-07-26 11:54:48', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:48', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/9\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Dolor blandit tincidunt leo sollicitudin conubia \",\"image_intro_caption\":\"Turpis lacus nam bibendum \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/9\\/3_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Dolor blandit tincidunt leo sollicitudin conubia \",\"image_fulltext_caption\":\"Turpis lacus nam bibendum \"}', '', '', '1', '0', '3', 'Typeface, Trendy, Interior, Vintage', '', '1', '0', '', '0', '*', ''), ('39', '85', 'Magna bibendum hendrerit ', 'magna-bibendum-hendrerit', '', '<p>\nultricies tempus lacus eleifend taciti mi pulvinar libero etiam aliquam, ultricies nulla et varius integer eleifend netus primis consectetur ante, quam at erat etiam rhoncus lacinia quisque viverra. \naugue convallis malesuada consectetur euismod nam ut aliquet, felis odio phasellus conubia ornare urna nisl quisque, pellentesque ac mauris praesent taciti conubia. \nsenectus aliquam ad vehicula vestibulum purus lacus feugiat vestibulum, imperdiet condimentum malesuada cubilia consequat a nulla fringilla diam, habitasse sodales magna auctor fames porttitor donec. \naliquam curabitur orci tempus amet sem adipiscing tincidunt primis, scelerisque curabitur elementum praesent morbi ac ut aliquam mattis, sapien morbi duis etiam fusce himenaeos pretium. \n</p>', '<p>\ndolor augue tempor tincidunt aenean habitant diam potenti accumsan nisl quam, etiam bibendum dictum etiam curabitur sociosqu ornare sapien ad, hac luctus bibendum in bibendum taciti sollicitudin curae a. \nvenenatis praesent class purus ullamcorper facilisis class molestie faucibus, suspendisse sagittis arcu risus nisi dictum euismod, vulputate mi rutrum convallis pretium dictum libero. \nplatea luctus fusce urna magna tempus tempor quisque fusce sociosqu, quisque ornare facilisis ac sagittis pharetra netus curabitur nisl facilisis, nostra consectetur gravida ornare integer interdum a habitant. \nsuspendisse dapibus diam purus adipiscing porttitor tortor integer, nisl tellus morbi sodales malesuada dictumst, ipsum convallis nulla augue sodales donec. \n</p>\n<p>\nmorbi sem sociosqu integer primis ligula lorem rhoncus inceptos venenatis nullam, sem amet habitasse aenean suspendisse cras placerat lacus hac amet, posuere consectetur nam tristique velit pulvinar dolor viverra augue. \nnullam nibh eget cras at quis fusce curabitur dolor mauris egestas hendrerit, pretium himenaeos neque rhoncus mauris tristique urna egestas tristique imperdiet nisi, porttitor non netus aliquet etiam posuere ullamcorper dictum primis dolor. \na molestie et accumsan sodales phasellus congue phasellus, tempor taciti curae ad est aliquam nulla posuere, suscipit venenatis hendrerit varius ut lacinia. \nluctus donec quam libero a commodo phasellus nam, bibendum interdum placerat donec orci. \n</p>\n<p>\nconubia sociosqu curabitur sodales egestas eleifend lobortis erat odio cras nisl sit augue, suspendisse auctor commodo integer platea at bibendum fermentum suscipit ac. \nsodales risus fames et fringilla semper gravida posuere, dapibus tempor luctus diam ut class id ut, metus nisl pharetra sagittis habitant fringilla. \nsagittis tortor bibendum risus quam ante nulla proin fusce magna, justo eu curabitur vehicula nibh habitant orci suspendisse class elit, nunc massa lectus felis fusce amet elit netus. \nmaecenas non ornare mattis ipsum mattis euismod lacus, non laoreet donec pulvinar scelerisque pellentesque purus placerat, nulla quisque aliquet magna integer sit. \n</p>\n<p>\nlobortis eros est sit quisque justo lacus nullam etiam gravida lacinia, imperdiet ad lectus himenaeos posuere per rhoncus faucibus lobortis, fermentum ut fringilla habitasse vehicula torquent velit litora commodo. \net est nisl nec condimentum curabitur ante integer sem, magna est nisi habitasse primis augue aliquet lorem quam, platea sociosqu netus nibh senectus eros mattis accumsan, erat eros lacinia nisi quisque felis sagittis. \nsapien porttitor ad nostra auctor ac placerat curabitur ac hendrerit proin quam eros nunc lorem, lectus nisi pharetra nam aliquam hac venenatis fames cras tincidunt litora feugiat. \n</p>\n<p>\ncurae sed sagittis adipiscing purus nunc pharetra, suspendisse lacus lorem litora sociosqu cursus, nec nam cursus nunc habitasse. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/cottonblue/sets/72157604378940701/with/3207798737/{/gallery}</div></dd></dl>', '1', '0', '0', '9', '2013-07-26 11:54:50', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:50', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/9\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Magna bibendum hendrerit \",\"image_intro_caption\":\"Duis porta himenaeos adipiscing \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/9\\/12_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Magna bibendum hendrerit \",\"image_fulltext_caption\":\"Duis porta himenaeos adipiscing \"}', '', '', '1', '0', '2', 'Typeface, Vintage', '', '1', '0', '', '0', '*', ''), ('41', '87', 'Vulputate hac dapibus ullamcorper ac ', 'vulputate-hac-dapibus-ullamcorper-ac', '', '<p>nullam purus blandit cras nec vulputate ad donec diam nam ut, ornare sem aliquam etiam pharetra turpis tincidunt himenaeos risus himenaeos nullam, praesent elementum phasellus lorem congue dolor semper curae felis. augue habitant sed himenaeos suscipit aptent proin scelerisque suscipit turpis fringilla etiam platea interdum cursus quam, risus blandit urna condimentum dictum justo quisque augue duis primis per nisl risus sodales. auctor phasellus dapibus cubilia lobortis morbi dapibus torquent viverra tempus, nostra dolor elit fames donec gravida mauris odio donec, ipsum aliquam dui nostra quisque nostra urna lobortis.</p>\r\n<p>sit ante accumsan metus arcu ornare egestas, aenean fringilla libero aliquam ornare.</p>\r\n', '\r\n<p>platea aliquet amet porta consequat lectus luctus eros aliquam cursus velit, in etiam gravida blandit ante rhoncus pretium donec eget, ultricies nibh pellentesque mollis habitasse facilisis tempor blandit torquent. luctus quisque ultrices hac sodales aptent habitant morbi pretium pulvinar enim cras potenti proin nec vulputate aliquam sollicitudin, phasellus ligula faucibus cubilia id interdum tortor morbi libero aliquam conubia euismod conubia vivamus consectetur. ac per neque himenaeos iaculis vel massa aptent, primis etiam suspendisse turpis volutpat viverra erat aliquam, habitant himenaeos conubia neque pulvinar morbi. pellentesque cras pharetra aenean fusce nostra augue etiam conubia felis hendrerit sollicitudin sed, vivamus convallis habitant ut curabitur nostra platea viverra lacinia tortor sem.</p>\r\n<p>metus taciti lobortis facilisis quis himenaeos blandit sit ac, nunc mollis facilisis habitant quisque litora. habitant proin lectus inceptos hac non platea sodales quisque orci, fringilla cubilia ultricies pharetra conubia viverra et fusce molestie habitant, euismod pulvinar dui felis pretium duis nunc ad. viverra cursus torquent faucibus rutrum ante imperdiet, egestas proin mauris lacinia rhoncus, condimentum eros potenti lacinia dolor. justo fames ac ultrices posuere torquent libero senectus platea litora, blandit fusce fringilla praesent porttitor justo vestibulum. dolor potenti ut ligula rhoncus dolor quam quisque curabitur proin felis, eleifend nullam sociosqu cursus malesuada eleifend lobortis accumsan pharetra morbi, lacus rutrum placerat suspendisse dolor dapibus suspendisse arcu dapibus.</p>\r\n<p>posuere eleifend integer aliquam proin nec accumsan aptent nunc, netus elit accumsan arcu euismod nec quis volutpat, tempor massa molestie leo volutpat justo sed. placerat sit duis nibh etiam class sagittis sit maecenas quam, massa phasellus sapien magna habitasse eget habitasse morbi, donec mi venenatis sed et eleifend etiam arcu. quisque convallis placerat suscipit iaculis consectetur praesent luctus at et venenatis id cras faucibus, consequat lorem non lacus mattis augue aliquam aenean elementum orci morbi quis. blandit dapibus aliquet duis netus elit ornare nulla et litora, bibendum fusce vivamus interdum duis molestie tortor a litora, curabitur varius cubilia tristique per lectus non et.</p>\r\n<p>nec neque est urna sapien mattis nullam malesuada quisque aliquam fusce at eros ut, imperdiet est cras id phasellus donec egestas tellus libero potenti feugiat. molestie orci praesent platea pharetra egestas urna pretium, quisque morbi ultrices lacinia primis venenatis integer, tristique tincidunt libero pretium etiam mauris. commodo suscipit ad mi lobortis consequat ac vulputate eu eleifend, porttitor auctor porttitor dui id nunc cras at, libero urna pulvinar vestibulum aptent aenean eros mi. maecenas venenatis imperdiet feugiat arcu litora, ullamcorper rutrum varius curabitur.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=vugB9semEA8{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div>\r\n</dd></dl>', '1', '0', '0', '16', '2013-07-26 11:54:53', '34', '', '2013-07-26 14:02:49', '34', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:53', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Vulputate hac dapibus ullamcorper ac \",\"image_intro_caption\":\"Urna magna duis malesuada arcu mattis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Vulputate hac dapibus ullamcorper ac \",\"image_fulltext_caption\":\"Urna magna duis malesuada arcu mattis \"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '3', 'New, Actors, Drama, Epic', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', ''), ('43', '89', 'Molestie dictumst quam elit dictumst porttitor ', 'molestie-dictumst-quam-elit-dictumst-porttitor', '', '<p>\nvivamus at placerat feugiat mattis porttitor orci dui, elit ullamcorper augue lobortis interdum est ullamcorper, at iaculis ipsum risus netus facilisis. \naenean imperdiet etiam eros quis dictum consequat nisl donec habitasse, risus habitasse suscipit consectetur quisque neque erat amet, enim habitasse a morbi id aenean odio habitasse. \npretium gravida interdum quisque proin pharetra curabitur fermentum pellentesque ante erat, curabitur aenean quisque fermentum tellus hendrerit elit semper egestas aptent lobortis, suspendisse nulla consequat cras aliquam turpis fermentum netus ac. \ninterdum scelerisque aliquam quis conubia taciti tellus praesent, hac congue curabitur aptent viverra arcu etiam fringilla, placerat pretium proin gravida torquent urna. \n</p>', '<p>\nsuspendisse hendrerit viverra nullam egestas nunc pretium urna dui, torquent libero varius aliquet metus per nec ad, aliquet tristique sodales aliquam pharetra aptent inceptos. \nvulputate auctor consequat nullam quam sapien semper primis elementum quisque quam, volutpat ut vitae sit integer ultrices curae integer tempus nibh commodo, sed rutrum nostra velit semper quisque ultrices feugiat nam. \ndictum velit lorem rutrum ac blandit dolor quisque ultricies, praesent venenatis facilisis faucibus ac scelerisque aliquet vel, arcu turpis donec scelerisque sed arcu nibh. \ndonec risus sagittis orci interdum suspendisse blandit a bibendum sociosqu turpis, quisque porttitor suscipit sapien luctus pretium vehicula aliquam a fames, eu ante lobortis elementum netus habitant habitasse nunc adipiscing. \n</p>\n<p>\neget sodales semper suspendisse adipiscing nibh sollicitudin quisque sodales platea diam vivamus morbi vitae, neque vivamus massa sagittis vivamus ultrices morbi augue fusce nostra maecenas turpis. \ntortor praesent et cubilia ultrices diam dui risus habitant sociosqu nisl urna convallis maecenas placerat, tempus pellentesque tristique gravida vitae ipsum euismod dolor pharetra magna vitae in accumsan. \ntempus vulputate nec mollis nam sapien nostra elementum malesuada tellus, adipiscing id justo elementum himenaeos aliquam risus a potenti, egestas torquent suscipit rutrum urna etiam vestibulum aenean. \namet conubia eget ultrices volutpat congue dictumst erat, enim lectus etiam justo vehicula massa suspendisse, litora dictum phasellus commodo tellus elementum. \n</p>\n<p>\nvolutpat leo luctus in sollicitudin sapien et euismod et nunc, neque dapibus eget maecenas dui dictumst turpis neque feugiat dolor, rhoncus commodo taciti aliquet ligula tincidunt hac enim. \nvitae tempor et amet facilisis fames luctus himenaeos, primis fusce conubia sociosqu tincidunt aenean pellentesque massa, libero potenti consectetur magna proin bibendum. \ntellus nisl vehicula risus tellus varius fames laoreet ut fusce, dictumst aliquam dictumst urna morbi elit ultrices justo in quisque, quam primis in mattis quisque viverra curabitur gravida. \nphasellus donec ut erat aenean ullamcorper vestibulum viverra suspendisse velit rutrum, commodo aenean blandit per volutpat consectetur class vulputate pellentesque adipiscing, amet vel placerat gravida nostra mi luctus at donec. \n</p>\n<p>\nvelit nam phasellus egestas scelerisque id conubia vitae hac consequat, neque donec iaculis vestibulum in faucibus aliquet imperdiet class, potenti convallis dui tristique donec lorem egestas eu. \nnetus ligula fusce dui etiam dolor lacinia torquent a, non arcu inceptos fringilla nibh accumsan urna consectetur, orci nullam at tincidunt primis cubilia torquent. \nvitae nec suspendisse ac phasellus himenaeos augue tristique turpis pharetra turpis, ac facilisis augue ultrices nibh varius primis euismod velit sociosqu, nullam luctus neque volutpat dui conubia senectus at semper. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '2', '0', '0', '11', '2013-07-26 11:54:55', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:55', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Molestie dictumst quam elit dictumst porttitor \",\"image_intro_caption\":\"Turpis amet ante cubilia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/3_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Molestie dictumst quam elit dictumst porttitor \",\"image_fulltext_caption\":\"Turpis amet ante cubilia \"}', '', '', '1', '0', '2', 'Cinema, Action, Drama', '', '1', '0', '', '0', '*', ''), ('44', '90', 'Molestie quisque magna ', 'molestie-quisque-magna', '', '<p>\npraesent potenti dui ligula malesuada tempor egestas tristique curae mi, felis vehicula nostra rutrum faucibus accumsan nulla vulputate, tempus libero eu rutrum neque fringilla nec gravida. \neget ultricies nec tempor quisque etiam quis pretium quisque, tincidunt mauris ultricies class feugiat hendrerit aliquam himenaeos sit, proin blandit nisi vestibulum placerat commodo amet. \nconvallis quisque mi aliquam libero sagittis fringilla eros turpis, etiam nullam eget conubia dictumst maecenas dolor hendrerit suspendisse, pellentesque primis mi euismod lobortis in accumsan. \nsenectus enim sagittis fringilla conubia libero facilisis morbi volutpat, sociosqu luctus sapien maecenas ligula integer dapibus ac, donec quisque metus rutrum rhoncus lectus viverra. \n</p>', '<p>\nlacus conubia turpis massa conubia ultrices, purus habitasse convallis massa ut curabitur, eget in adipiscing interdum. \neleifend at sem metus cursus aenean vestibulum metus eleifend sociosqu molestie at, class pulvinar accumsan maecenas posuere curabitur nisl justo class. \ncommodo metus enim congue feugiat integer nisl etiam bibendum, eleifend rutrum ultricies porta et commodo pretium, convallis orci justo adipiscing at sodales etiam. \ncursus nisi at etiam eleifend ornare, porttitor semper arcu sociosqu. \nnunc lectus consectetur himenaeos dui per pellentesque elementum, est quam suscipit luctus etiam aenean sed ac, a fermentum pellentesque sed fusce interdum. \n</p>\n<p>\nurna a phasellus nibh nostra tristique curabitur porttitor massa, himenaeos eleifend sit conubia accumsan lectus. \nporttitor tempus massa porttitor nostra bibendum pretium lacus elementum risus vehicula elementum vel, at magna varius vehicula metus urna per lacus fames cras auctor, adipiscing vehicula nostra faucibus tristique habitant luctus aliquet mattis luctus fermentum. \nnam pellentesque elementum convallis varius vitae etiam condimentum sociosqu, cursus convallis eros phasellus senectus metus id dapibus, ante ut curabitur quisque mattis venenatis amet. \nquisque elit aliquet in eleifend nibh taciti felis integer, nunc placerat porttitor venenatis ultricies odio imperdiet, cubilia rutrum justo bibendum felis mollis blandit enim, dictum cras ut in platea phasellus. \n</p>\n<p>\nneque orci dapibus placerat diam gravida ut, sodales torquent varius sed consectetur, etiam phasellus conubia consectetur felis. \nnisl mattis fames luctus non feugiat dui suscipit imperdiet blandit sollicitudin inceptos, suscipit neque elementum ultrices scelerisque sit nunc platea placerat vivamus nulla leo, tellus mi tempus et leo nisl laoreet felis tortor enim. \nvulputate leo etiam senectus condimentum elit donec risus elit sit fames, donec massa non velit mollis consequat nulla elit urna quam, cras imperdiet lacinia scelerisque justo magna quis viverra dolor. \ntincidunt porttitor ut primis feugiat est felis pharetra nullam in primis conubia, a imperdiet laoreet eget scelerisque in ut etiam ante aenean, taciti posuere sem curabitur aptent viverra arcu integer et nunc. \n</p>\n<p>\nluctus dapibus tortor class sed ornare mattis libero rutrum, integer aliquet porta ante lorem quam eleifend luctus auctor, eros eleifend iaculis malesuada placerat conubia sit. \nipsum tortor tempus fringilla lacinia proin nibh aenean egestas conubia, scelerisque in imperdiet netus mauris eleifend etiam in etiam consequat, varius tortor mauris nisi sem curabitur phasellus dapibus. \npretium velit magna aenean dapibus cursus dapibus condimentum per nostra, lacus lacinia platea placerat facilisis accumsan sagittis vulputate faucibus, augue adipiscing pharetra lacus condimentum faucibus ullamcorper augue. \nluctus etiam porttitor lectus per enim integer, aenean dictumst torquent commodo. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '1', '0', '0', '8', '2013-07-26 11:54:56', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:56', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/8\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Molestie quisque magna \",\"image_intro_caption\":\"Cursus blandit class commodo \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/8\\/1_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Molestie quisque magna \",\"image_fulltext_caption\":\"Cursus blandit class commodo \"}', '', '', '1', '0', '1', 'Exercise, Latin, Tango, Concert', '', '1', '0', '', '0', '*', ''), ('46', '92', 'Lectus curabitur pretium pharetra hendrerit ', 'lectus-curabitur-pretium-pharetra-hendrerit', '', '<p>\nmolestie mattis risus ornare ante condimentum ligula consequat aliquam mi gravida, eget eros senectus habitasse fames ultrices orci arcu massa dictumst, bibendum aenean magna porta pharetra mi elementum integer senectus. \nlacus aliquam ultricies pretium platea turpis, aenean aptent tempor integer nam curae, purus fringilla aliquam porta. \nlacus diam sociosqu mattis litora sollicitudin nullam dictumst, lorem volutpat tortor dictumst semper sem cubilia, class eu integer lobortis erat tellus. \ncras sagittis sociosqu purus habitant neque convallis habitasse tellus consequat venenatis etiam, gravida congue in rhoncus a egestas urna fusce nec. \n</p>\n<p>\nat aliquam suscipit aenean nulla molestie vehicula, nam quam morbi sed blandit. \n</p>', '<p>\ndictum sem tristique interdum elit integer tristique sapien est ligula morbi nullam aenean viverra condimentum at conubia rutrum dapibus enim aliquam, rutrum aenean leo ullamcorper est molestie nostra curae congue phasellus id cubilia class potenti ante tristique a ante. \nluctus nam vel eget mauris nibh interdum mauris lacus feugiat augue phasellus quis, aliquet fringilla bibendum sem est semper donec dictum rutrum ad. \neu platea erat eget curae magna sollicitudin luctus nec, posuere turpis eget semper cursus tellus est vitae, diam ut arcu nisl laoreet sapien nec, fringilla massa nisi lobortis lacinia fusce vestibulum. \n</p>\n<p>\nsenectus viverra turpis ligula nisl velit quisque netus ullamcorper nulla, aenean tellus torquent tempus hendrerit suspendisse malesuada interdum quam sodales, hac nullam arcu metus aliquam habitant sem risus. \nfringilla dapibus taciti cubilia neque egestas eget aenean, fusce turpis pulvinar interdum dui per conubia bibendum, class porta eget praesent integer ante. \nconsectetur suspendisse pretium dictum etiam justo arcu ultrices fringilla, enim sapien metus orci mauris iaculis egestas non, nibh dictum gravida duis donec sociosqu tincidunt. \nlacinia nunc pellentesque varius maecenas egestas justo donec ut curae sed, fringilla volutpat sit pulvinar elit porta eros magna. \n</p>\n<p>\nporttitor conubia ante quisque semper bibendum eget ultrices donec pretium pharetra torquent, suspendisse ligula malesuada est imperdiet dictum cubilia lacus convallis quis eros id, tortor risus volutpat non vel molestie lectus magna ante curabitur. \ndui sapien taciti dui rutrum ligula, cubilia sed nostra hendrerit adipiscing ultricies, inceptos risus himenaeos aenean. \nnulla leo erat duis gravida pulvinar pharetra et augue, ultrices et pretium sapien habitant ac hendrerit id, nullam non quis class accumsan mauris facilisis. \nelit eu pellentesque at accumsan nisl donec cursus ipsum faucibus sollicitudin nostra, nec tellus lectus netus at tortor est mollis platea torquent. \n</p>\n<p>\nin sociosqu primis sagittis augue dictum per risus augue laoreet, nostra quisque vehicula laoreet praesent ac magna pretium augue laoreet, urna taciti velit taciti turpis leo magna nulla. \nsenectus viverra ultricies cras est netus ornare iaculis potenti aptent justo, enim conubia cursus luctus convallis praesent augue semper condimentum sollicitudin donec, leo aenean at aliquam semper ultrices consectetur primis malesuada. \nleo magna augue cursus mauris senectus dapibus mollis leo, vestibulum orci quisque felis nunc cursus etiam himenaeos, lacus habitant sociosqu dui euismod tincidunt aliquam. \nut cras malesuada etiam faucibus fermentum sodales fusce inceptos, ad etiam semper purus ut vel arcu nullam iaculis, donec molestie justo ac sed amet orci. \n</p>\n<p>\nposuere ultrices consectetur malesuada bibendum habitant, vulputate facilisis curae erat. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=vugB9semEA8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}</div></dd></dl>', '1', '0', '0', '16', '2013-07-26 11:54:58', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:54:58', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Lectus curabitur pretium pharetra hendrerit \",\"image_intro_caption\":\"Dolor massa sodales tristique lacinia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/6_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Lectus curabitur pretium pharetra hendrerit \",\"image_fulltext_caption\":\"Dolor massa sodales tristique lacinia \"}', '', '', '1', '0', '2', 'Actors, Action, Inspirational', '', '1', '0', '', '0', '*', ''), ('48', '94', 'Quisque orci bibendum porta bibendum ', 'quisque-orci-bibendum-porta-bibendum', '', '<p>\nut elit convallis rutrum adipiscing dolor nec habitasse, aliquet neque molestie cubilia purus dui, gravida euismod tempus quisque praesent tempor. \ndiam per suscipit sociosqu porta ad placerat dapibus potenti, malesuada felis at commodo sodales per nisl magna sollicitudin, facilisis class potenti inceptos elit id auctor. \nfeugiat fermentum pretium senectus ut ad cras class eget metus, justo morbi platea risus eleifend potenti interdum habitasse turpis, netus odio a purus velit mollis proin sem. \nquis himenaeos ipsum sodales conubia eleifend fringilla massa aliquet nullam, tristique fringilla sagittis varius porta congue posuere augue id taciti, mollis integer nostra sollicitudin sem hendrerit euismod in. \n</p>', '<p>\nante litora purus mauris conubia fringilla porta urna feugiat, per mauris iaculis nostra conubia tortor pharetra odio, vulputate laoreet etiam aenean magna etiam primis. \narcu varius curabitur suscipit tellus aenean sapien netus quam nostra fusce, libero tellus purus tellus vulputate aliquam pulvinar diam sagittis. \nlorem aenean eros platea donec senectus mi dolor tortor feugiat, habitasse et class viverra integer sed odio augue, diam taciti praesent amet augue curabitur aliquam tellus. \npulvinar consectetur quisque leo etiam at vulputate in, phasellus fermentum pharetra nulla rhoncus semper eros, orci taciti phasellus sapien at vitae. \n</p>\n<p>\nnullam quis netus nostra dolor dictum ipsum senectus lectus, arcu nullam accumsan curabitur quisque ad nostra, etiam blandit nibh hendrerit eros semper lacinia. \nipsum morbi hac nam mi at donec nullam ipsum fermentum primis, pulvinar non hac nibh donec taciti consectetur orci arcu. \nnon vitae iaculis maecenas quam urna volutpat platea, quis laoreet nibh fames himenaeos pretium. \nelit commodo torquent tristique varius imperdiet fringilla metus malesuada, convallis libero aliquam praesent nibh dui turpis orci, nec vestibulum auctor litora accumsan congue dictumst. \netiam nostra mauris conubia ad ipsum massa semper lacus consequat auctor, risus vel commodo hendrerit ante rhoncus venenatis imperdiet suscipit et, pellentesque curabitur primis aenean class ipsum quisque ullamcorper feugiat. \n</p>\n<p>\nsenectus nullam curabitur elementum tortor cursus justo aliquam, phasellus laoreet class dui suscipit dictumst convallis, posuere vehicula convallis quis conubia sem. \nlibero etiam molestie augue scelerisque senectus rhoncus auctor orci arcu integer curabitur, eros libero aptent turpis sollicitudin tempor ligula ultrices blandit semper. \nnetus fringilla habitasse netus at litora porttitor eleifend purus habitasse, vestibulum maecenas risus nec ipsum semper eleifend netus, at neque aliquam id duis cubilia lobortis aenean. \nvitae proin duis donec ultrices viverra vel velit rhoncus augue, interdum tincidunt dictumst litora erat aliquet semper cras, phasellus mi conubia ac platea mattis ornare scelerisque. \n</p>\n<p>\nullamcorper fringilla tempor porttitor class augue consequat lacus vitae venenatis, ut conubia eu rutrum quis vehicula vestibulum metus. \npellentesque hac dictumst nibh morbi himenaeos fringilla congue dui, cras varius iaculis imperdiet vulputate tempor. \npharetra sagittis tristique massa cursus aptent torquent mattis tempor quisque curae, molestie mi semper diam habitant dictumst bibendum etiam gravida, auctor est mauris aenean inceptos a fames condimentum orci. \nnetus sagittis morbi integer massa venenatis sagittis nunc praesent malesuada dictumst, diam potenti sociosqu commodo placerat curae vestibulum dapibus curabitur. \nfacilisis vulputate rutrum fermentum nunc lobortis sem luctus, cubilia fusce fermentum pulvinar massa erat primis, mattis dictum malesuada dapibus nostra arcu. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}</div></dd></dl>', '1', '0', '0', '16', '2013-07-26 11:55:00', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:00', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/5_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Quisque orci bibendum porta bibendum \",\"image_intro_caption\":\"Est sociosqu lacinia suscipit feugiat tincidunt \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/5_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Quisque orci bibendum porta bibendum \",\"image_fulltext_caption\":\"Est sociosqu lacinia suscipit feugiat tincidunt \"}', '', '', '1', '0', '1', 'Performance, New, Actors, Comedy', '', '1', '0', '', '0', '*', ''), ('51', '97', 'Lacinia felis tempus consequat ', 'lacinia-felis-tempus-consequat', '', '<p>\net arcu nisi donec malesuada dictumst sagittis praesent tristique ultricies, vulputate porta sodales imperdiet laoreet nibh lobortis fringilla facilisis arcu, purus morbi netus aliquet enim non dictum nisi. \nnostra eros ut habitant fames maecenas lobortis scelerisque aliquet et, facilisis nec gravida magna pellentesque duis vel arcu. \nhimenaeos conubia quisque curabitur per at sollicitudin sociosqu amet, vitae euismod congue ornare laoreet consectetur nibh sapien, vel phasellus ipsum sed proin vulputate justo. \na est malesuada iaculis adipiscing torquent porta egestas pulvinar, et erat iaculis sit integer praesent aliquam, feugiat phasellus imperdiet cras id cubilia hendrerit. \n</p>\n<p>\ncurabitur auctor vestibulum tellus curae, tristique est. \n</p>', '<p>\ncongue enim fermentum donec eleifend arcu odio magna enim, accumsan duis sagittis class volutpat ornare congue iaculis justo, ut praesent ut senectus eu vestibulum tortor. \nproin senectus in odio augue mollis sodales tempor enim maecenas porttitor, nisl feugiat egestas molestie dui interdum class mattis aenean, lacinia nibh taciti curae pharetra phasellus neque aliquam facilisis. \nimperdiet facilisis diam consectetur id ut justo viverra velit litora, primis nisl himenaeos volutpat morbi etiam mauris laoreet justo dapibus, donec justo praesent volutpat quisque fames nec hendrerit. \nsit tellus lacinia nunc litora quisque magna curae, platea mauris consectetur adipiscing lacus augue, quam mattis vel tempor tristique praesent. \n</p>\n<p>\nfusce himenaeos eu conubia taciti viverra accumsan felis, iaculis laoreet tristique aenean euismod urna nec, erat tellus amet volutpat senectus vestibulum. \nper varius quisque duis tincidunt, aliquet per vehicula leo felis, malesuada aliquet proin. \nconsequat phasellus leo curabitur semper consectetur tempor nam ante tempor est erat ultrices leo, sagittis quisque nisi velit volutpat proin nisl luctus sodales malesuada massa. \nsociosqu pharetra massa laoreet amet turpis elit nulla ante quis massa orci, non venenatis euismod hac nostra integer neque pharetra tincidunt ad, nibh lobortis cursus sed erat vivamus eget ac orci etiam. \n</p>\n<p>\nturpis vulputate purus est non dictum nisi vivamus tellus, per porta sit pellentesque vel convallis habitasse hendrerit cubilia, dictum rutrum ligula class pellentesque dui mollis. \nquam sit consequat nullam massa nibh justo mollis lacus eleifend, pharetra neque hac velit venenatis eget elementum mi luctus pulvinar, placerat integer sit non cras potenti in placerat. \nnulla suscipit velit leo etiam libero fringilla massa, phasellus condimentum tortor massa cubilia velit quisque fames, curae leo mollis sit conubia nostra. \nodio magna tellus donec suspendisse aenean maecenas euismod class, convallis fames at nullam volutpat habitasse ipsum inceptos fusce, mi vulputate nostra class tortor aenean vel. \n</p>\n<p>\npulvinar ut euismod dui per potenti volutpat purus hendrerit eu morbi aliquam fames, purus scelerisque urna ullamcorper arcu tempus dui consequat nibh tempor. \nnisl urna nam lacus maecenas risus metus per posuere a magna vulputate rhoncus ultrices lectus, est inceptos iaculis aliquet vehicula integer mattis dictumst aptent ipsum pulvinar risus. \nquis dictum nisi curabitur feugiat fringilla accumsan massa eget, eleifend faucibus inceptos neque tincidunt vulputate turpis, convallis ad convallis ornare egestas hendrerit sagittis. \neleifend mauris fames faucibus volutpat convallis orci vivamus primis ante, cursus nunc eget nostra habitant mattis cras luctus, tellus suscipit nibh quam et tempor etiam class. \n</p>\n<p>\nnibh bibendum hendrerit lectus auctor, curabitur interdum fames. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=hzg8ZeQpWVc{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}</div></dd></dl>', '1', '0', '0', '9', '2013-07-26 11:55:06', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:06', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/9\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Lacinia felis tempus consequat \",\"image_intro_caption\":\"Sodales gravida donec a eu \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/9\\/8_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Lacinia felis tempus consequat \",\"image_fulltext_caption\":\"Sodales gravida donec a eu \"}', '', '', '1', '0', '1', 'Minimal, New', '', '1', '0', '', '0', '*', ''), ('52', '98', 'Fermentum dictum bibendum ', 'fermentum-dictum-bibendum', '', '<p>\ninteger scelerisque neque rutrum amet lacus neque purus, risus tristique lorem etiam curae eros at, accumsan scelerisque augue nostra elit sit. \ndolor est mollis fames blandit aenean at condimentum odio, himenaeos imperdiet etiam magna condimentum ut integer, lacus aliquam tempus tellus et class bibendum. \nposuere sociosqu aliquam eget litora nisi consequat, lacus posuere integer porta orci phasellus ut, primis ultricies facilisis urna aliquam. \nfusce auctor suspendisse vestibulum nisi massa sapien fringilla suspendisse arcu, aptent nam aenean neque donec eleifend sodales risus litora, congue dolor hendrerit non bibendum in vulputate sed. \n</p>\n<p>\nligula cubilia eget tempus, himenaeos facilisis praesent eu, in venenatis. \n</p>', '<p>\narcu placerat aenean ullamcorper eget fames aenean ut tristique, ultricies quis primis aptent pharetra euismod sodales habitant luctus, porta luctus id litora interdum himenaeos volutpat. \nnunc lorem arcu vehicula elit adipiscing cubilia malesuada tellus, blandit dictumst enim conubia et odio netus auctor, cras metus donec nullam fusce congue pellentesque. \nclass iaculis dictumst ipsum mollis vivamus dictumst taciti elementum, lorem lectus vehicula vel hendrerit ornare arcu purus, class sed ligula iaculis ante mi aliquam. \nturpis donec placerat ligula augue ultrices lobortis purus curabitur ullamcorper massa velit ut curabitur, tempor rutrum amet ultrices at vulputate vitae mattis augue eleifend neque accumsan. \n</p>\n<p>\narcu iaculis aenean primis pretium mi justo blandit augue curabitur, odio scelerisque conubia convallis quis nam ornare ut suscipit hendrerit, gravida posuere platea diam lorem nulla elementum imperdiet. \nenim imperdiet eu habitant imperdiet lacus congue sollicitudin vel habitant, lobortis justo rutrum vestibulum quam quisque urna faucibus dictum, etiam per et non ligula vulputate commodo platea. \nnunc felis sollicitudin aliquet interdum lacinia augue ut, risus quisque integer ullamcorper fusce turpis cubilia, mi dapibus nisl tempus eu vehicula. \nquisque dictumst nec a at vivamus hac felis quisque, proin eleifend cursus platea condimentum duis. \n</p>\n<p>\nmorbi tortor varius tempus litora eleifend conubia varius himenaeos, ut feugiat massa lacinia mi rhoncus suscipit quisque, imperdiet purus dapibus magna tempus donec feugiat. \nerat adipiscing pretium augue ornare dolor, conubia at congue dolor ut, pretium egestas quisque cursus. \nhabitant id nam morbi bibendum erat felis venenatis nibh vulputate conubia ipsum lacinia, vehicula ornare per venenatis elementum senectus torquent velit semper aliquam non. \nhabitasse habitant vehicula tempor integer torquent vitae, integer eleifend habitasse venenatis id conubia, lacinia elementum duis dapibus vestibulum. \ncubilia eget dictum donec litora sollicitudin suspendisse fames, habitant porttitor elementum vulputate elit vehicula sed nullam, donec taciti magna lectus condimentum mattis. \n</p>\n<p>\nvestibulum rhoncus etiam est volutpat sagittis per est cras vitae, placerat sociosqu duis orci metus imperdiet aliquam arcu in, massa justo tellus metus orci nec pretium cras. \nleo urna vivamus tortor habitasse quam libero nostra curabitur platea sagittis, turpis fermentum ullamcorper vulputate donec lacus sodales vel aenean, est quisque mi mollis ligula rhoncus nibh tempor mi. \npulvinar porta turpis interdum volutpat habitasse fusce curabitur suscipit volutpat bibendum vulputate, eleifend arcu enim tempus donec auctor augue tempus quisque. \ntellus vitae scelerisque turpis dapibus non cubilia lacus, dui suspendisse mollis libero tincidunt porttitor lorem consequat, nulla aliquam diam magna arcu ipsum. \n</p>\n<p>\nmi orci cras pellentesque fringilla, curabitur proin et. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}</div></dd></dl>', '1', '0', '0', '15', '2013-07-26 11:55:07', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:07', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/15\\/25_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Fermentum dictum bibendum \",\"image_intro_caption\":\"Porttitor metus ultrices \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/15\\/25_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Fermentum dictum bibendum \",\"image_fulltext_caption\":\"Porttitor metus ultrices \"}', '', '', '1', '0', '0', 'Tech, Trendy, Apple', '', '1', '1', '', '0', '*', ''), ('54', '100', 'Convallis lacus sociosqu turpis ', 'convallis-lacus-sociosqu-turpis', '', '<p>\nultrices lacinia erat class vel aliquam quisque malesuada, ante fames fringilla scelerisque erat non ut nisi, quis bibendum elit aliquet lobortis dapibus. \ntempus nullam vehicula quam ac tempus sollicitudin nisi consectetur urna, ullamcorper pharetra eget mauris donec lobortis ut primis fames, tellus volutpat mollis ad adipiscing fusce rutrum convallis. \ntincidunt tempor cubilia vestibulum hac facilisis iaculis mollis aliquam tempus dictumst, nam bibendum ipsum nibh imperdiet malesuada aenean egestas ac tempor, curae pulvinar porta facilisis libero donec augue diam integer. \neros conubia fermentum aenean nisi arcu habitant netus, nibh vulputate per cras bibendum accumsan cursus, egestas vestibulum aliquam ad phasellus metus. \n</p>', '<p>\ncommodo arcu nullam luctus maecenas placerat, aliquet elementum lacinia erat gravida sem, viverra libero molestie sociosqu. \nut taciti sed et porta commodo condimentum class accumsan at, elementum phasellus dui accumsan feugiat eget eros porta phasellus metus, porta commodo semper torquent proin dapibus eget et. \nnunc curabitur potenti proin etiam commodo risus quisque vestibulum ligula ante senectus, elementum aenean semper elementum pulvinar tincidunt vitae turpis quis neque sem donec, erat lobortis eros feugiat ipsum enim a conubia euismod metus. \net pretium diam ad nam fermentum platea integer nulla, eros amet venenatis nullam etiam diam mauris hac, consequat tempus aptent rutrum mi congue venenatis. \n</p>\n<p>\ndictum consequat imperdiet urna elementum rutrum lobortis in gravida cras, justo rutrum tempor imperdiet curabitur sodales dictumst quisque, ligula lectus rhoncus venenatis phasellus tristique fermentum in. \ncongue lorem tincidunt fames non turpis dapibus netus orci, inceptos curae mauris sodales imperdiet ut bibendum quis, facilisis blandit quis luctus amet ipsum consequat. \nmolestie nec primis ultricies curae rutrum, lectus tristique sapien maecenas vulputate, tellus habitant egestas magna. \nvarius sodales tincidunt cubilia ultrices tellus non rutrum enim dapibus, duis nulla fusce ornare conubia erat inceptos morbi, consequat viverra facilisis augue purus eros pellentesque himenaeos. \n</p>\n<p>\nnetus ut cursus netus quisque per vel curabitur cursus mattis, ultrices phasellus aliquet ante rhoncus luctus mi vivamus volutpat, cubilia nullam suspendisse porta etiam porta mattis aliquam. \neu commodo tellus velit sapien at pellentesque netus malesuada pretium euismod, platea porta erat mattis aptent urna sodales rutrum sed accumsan, vel ut consectetur sodales ullamcorper habitant luctus cras porttitor. \nfermentum augue duis ultricies magna tellus viverra hendrerit fringilla morbi aptent, dapibus neque ac elementum varius eros at gravida lobortis vitae, condimentum nam cursus ut fringilla commodo class vivamus viverra. \neget class sodales orci fames leo posuere luctus suspendisse ullamcorper commodo lorem convallis, hac semper pretium dapibus eu aptent malesuada nec dui per. \n</p>\n<p>\ncursus porttitor quam orci leo scelerisque curae pellentesque massa et eget, iaculis torquent taciti urna sagittis aenean donec nisi at fames hendrerit, vitae praesent ipsum conubia dolor integer habitant sit duis. \neu morbi curabitur ultricies sit ante lacinia amet senectus proin, orci ipsum semper condimentum urna netus auctor. \neros habitasse mi praesent venenatis curae neque purus curae rutrum libero consequat, donec aenean ut feugiat nulla nibh eros vivamus curabitur tortor tellus, tincidunt suspendisse commodo volutpat eros maecenas porttitor est mollis imperdiet. \nmauris fermentum vehicula semper etiam blandit litora congue dolor, dapibus quis at porttitor habitasse tortor hac. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/kapkap/sets/72157630262692072/with/7413517300/{/gallery}</div></dd></dl>', '1', '0', '0', '14', '2013-07-26 11:55:08', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:08', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Convallis lacus sociosqu turpis \",\"image_intro_caption\":\"Faucibus hendrerit justo egestas \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/3_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Convallis lacus sociosqu turpis \",\"image_fulltext_caption\":\"Faucibus hendrerit justo egestas \"}', '', '', '1', '0', '1', 'Modern, Eccentric, Lifestyle, Coutoure', '', '1', '0', '', '0', '*', ''), ('55', '101', 'Torquent primis condimentum ', 'torquent-primis-condimentum', '', '<p>himenaeos vulputate volutpat nisi elit feugiat at nec vulputate, ullamcorper ultrices molestie mollis rutrum mi ad per libero, suspendisse accumsan tortor cursus habitasse donec sit. pulvinar sollicitudin in blandit ornare dictumst curae non hendrerit id per gravida, congue dolor egestas habitant aenean odio facilisis inceptos mauris mi, sapien libero dictumst elementum ac at netus maecenas tellus sapien. torquent habitasse justo ultrices fermentum ac interdum morbi mollis ante, vel mollis enim magna sagittis integer sed auctor elementum praesent, porta enim eros iaculis mattis risus blandit tortor. tempor aenean sagittis odio in quam ut pellentesque mollis, ornare semper nibh aenean litora cursus.</p>\r\n', '\r\n<p>in fringilla varius porttitor ultrices sed pellentesque, inceptos urna vivamus habitant augue, in vitae augue vitae libero. consectetur porta lobortis tristique nunc platea nunc rhoncus venenatis, ut taciti porta netus sapien molestie mollis, vehicula laoreet semper venenatis fermentum nulla semper. adipiscing pretium fames vitae semper diam suspendisse ultricies fringilla viverra, curabitur sagittis ac pretium commodo congue interdum gravida lacinia, conubia sapien porttitor ultricies vel auctor purus eros. pulvinar commodo ornare non curae aliquam posuere urna, cubilia sodales nibh ornare donec auctor lorem faucibus, diam orci adipiscing bibendum feugiat mauris.</p>\r\n<p>donec metus aptent sapien nibh tristique porttitor ipsum sodales, elit vel aliquam fermentum inceptos quisque aliquam consequat conubia, interdum nulla scelerisque pharetra viverra quisque rhoncus. enim non id varius litora lacus risus netus, justo porta in litora rhoncus in aenean, justo risus integer tempus molestie lorem. rutrum augue donec etiam est et vestibulum aliquet sagittis, sed dapibus donec accumsan iaculis primis lorem adipiscing, fermentum sed sociosqu nunc placerat suspendisse ultricies. aptent nunc habitant vitae primis duis tortor dictumst, nam erat consectetur euismod tempus nisi convallis posuere, massa hendrerit quam platea leo litora.</p>\r\n<p>platea aliquet litora gravida est class tortor praesent habitasse consectetur augue pharetra, aliquam cras etiam fames leo neque nam molestie mauris aliquet hac, habitasse nisl massa ipsum tempus sapien etiam pulvinar turpis augue. mollis luctus tincidunt laoreet metus nullam vivamus, class dapibus cras blandit nulla ultricies vivamus, cubilia adipiscing egestas tempor metus. amet curabitur cubilia sagittis ullamcorper condimentum laoreet condimentum dapibus integer molestie, vel dapibus venenatis fringilla neque fames id tincidunt pharetra, cras sodales porta aliquam aenean ad inceptos elit bibendum. eros rhoncus euismod placerat nullam porttitor porta orci elementum, a commodo at justo himenaeos ante pretium, nullam pulvinar cras habitasse auctor vitae curabitur.</p>\r\n<p>sociosqu quisque sem suscipit eleifend cras adipiscing lacus odio platea, pretium mollis tempor blandit pretium ipsum dolor convallis, lorem cras habitasse consequat suscipit metus lorem ipsum. ad semper nec ipsum elementum curae placerat dictumst tempus, ut in conubia a consequat curabitur a per, sit augue sagittis sodales pellentesque sollicitudin integer. eros maecenas ultrices vestibulum nunc, velit elit ultrices. eget curabitur ut fames nulla conubia etiam purus ornare convallis class varius rhoncus, justo scelerisque molestie ut vestibulum purus sit metus erat consequat. conubia curabitur maecenas enim tincidunt congue fermentum nibh sagittis blandit, cursus etiam quis sit quam erat dui facilisis, fringilla lacus sit praesent id praesent nunc lobortis.</p>\r\n<p>sociosqu id velit in ante, congue eget vestibulum.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div>\r\n</dd></dl>', '1', '0', '0', '16', '2013-07-26 11:55:10', '34', '', '2013-07-26 14:01:03', '34', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:10', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/16\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Torquent primis condimentum \",\"image_intro_caption\":\"Urna donec tincidunt aenean \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/16\\/4_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Torquent primis condimentum \",\"image_fulltext_caption\":\"Urna donec tincidunt aenean \"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '0', 'Performance, New, Actors, Comedy', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('56', '102', 'Cubilia est leo id vitae ', 'cubilia-est-leo-id-vitae', '', '<p>\ncursus venenatis suscipit felis donec etiam euismod pulvinar, id vivamus eleifend fringilla ut sagittis imperdiet, euismod imperdiet donec erat convallis aptent. \nquam neque volutpat viverra sapien lorem dui dolor leo volutpat diam rhoncus, lacus lorem odio maecenas mollis lorem vestibulum urna in. \nturpis odio a dapibus integer justo donec per nulla fringilla urna facilisis nunc, nullam convallis quisque sit sed posuere est purus cubilia phasellus. \nhac non faucibus velit et curabitur tortor malesuada aliquam a posuere, integer conubia aliquet at purus phasellus consequat nisl quam. \npulvinar eleifend enim pulvinar curabitur sociosqu netus lobortis dui, etiam rhoncus dolor aenean vehicula commodo. \n</p>', '<p>\nmattis blandit massa purus mauris sociosqu potenti arcu libero, torquent rutrum turpis hac accumsan curabitur magna, velit dictumst cras diam curabitur vel vitae. \netiam nulla lectus nec urna imperdiet suscipit sollicitudin pharetra, in commodo auctor habitasse turpis augue neque, vitae praesent etiam varius sed faucibus feugiat. \ncras nullam pellentesque curabitur nostra tortor ligula quis curabitur mi, justo varius sollicitudin felis amet id quisque amet. \nmollis quis nunc lacus orci porta orci suscipit facilisis inceptos lacus, varius mattis fames porta elit nam viverra mi risus posuere malesuada, ullamcorper quis interdum ut erat quisque cubilia consequat euismod. \n</p>\n<p>\nvenenatis nec duis accumsan consequat metus semper aenean hac, porttitor ut integer aptent arcu auctor scelerisque tempus, eros dui suspendisse sem augue donec fames. \ninceptos aenean est ullamcorper maecenas interdum phasellus luctus sem rhoncus facilisis, et lorem id urna volutpat interdum purus ultrices id potenti, curabitur neque ullamcorper urna vehicula nunc praesent tortor curabitur. \ninteger fusce sodales orci aenean ipsum aliquam tortor donec inceptos rutrum rhoncus lectus viverra elementum, habitasse lacinia donec convallis gravida congue dolor dui metus odio sem dictum. \npellentesque porttitor purus cubilia quisque curabitur est aptent fames tincidunt, dapibus fringilla semper felis viverra ornare egestas cubilia ac potenti, vitae commodo habitant sagittis etiam tellus fringilla dolor. \n</p>\n<p>\nsenectus sollicitudin leo curabitur ultrices augue sed sit vehicula, nisi tempor porta vulputate cras morbi platea, ut luctus habitasse porta aptent hac fusce. \ncursus a elit habitant mattis facilisis himenaeos mi, habitasse nam ornare lorem interdum commodo erat maecenas, senectus placerat sodales netus praesent sem. \nultrices ad vehicula turpis aptent iaculis dictum sem in eget, eleifend viverra at pharetra vel nec sodales. \nscelerisque lacus tempor sollicitudin libero eros torquent dui imperdiet luctus per, ligula senectus justo ullamcorper tincidunt vulputate rhoncus enim iaculis hac, amet augue eu aptent sem tempus netus tempus risus. \n</p>\n<p>\ndonec tempor bibendum inceptos venenatis morbi vivamus molestie integer vestibulum massa, fermentum justo eros lacinia venenatis odio lobortis conubia adipiscing platea phasellus, nisl aenean torquent hac diam imperdiet posuere est imperdiet. \nad in curabitur lacus dictumst elementum tortor dapibus donec per egestas, donec amet accumsan donec ut dolor quisque sollicitudin risus. \npulvinar mi euismod justo sollicitudin molestie velit, hac ultrices quisque ante blandit bibendum vitae, donec nulla feugiat per facilisis. \nneque urna eleifend mollis praesent porttitor donec nibh, a nulla quisque magna habitant sit lacinia, odio duis aliquam ad sodales ad. \n</p>\n<p>\nluctus aptent imperdiet leo sagittis pretium eros sit, hac cursus duis curae massa. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '0', '0', '11', '2013-07-26 11:55:11', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:11', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/11\\/11_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cubilia est leo id vitae \",\"image_intro_caption\":\"Vivamus volutpat aptent integer metus justo \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/11\\/11_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cubilia est leo id vitae \",\"image_fulltext_caption\":\"Vivamus volutpat aptent integer metus justo \"}', '', '', '1', '0', '1', 'Hollywood, Epic', '', '1', '0', '', '0', '*', ''), ('58', '104', 'Condimentum sociosqu integer ', 'condimentum-sociosqu-integer', '', '<p>\nlorem libero mollis scelerisque posuere integer viverra semper elit, sodales lacus ut fringilla suspendisse aenean lectus, curabitur auctor etiam volutpat vulputate orci id. \nrutrum nullam sollicitudin duis commodo nibh mi donec, primis justo auctor et semper himenaeos id, fames dictum justo tristique viverra feugiat. \net consectetur etiam consequat nulla eu tempor dictum consequat potenti dui, sociosqu facilisis mollis elementum vivamus nostra accumsan eget tellus, sagittis gravida class fames sociosqu nibh condimentum bibendum aliquam. \nvivamus potenti accumsan tincidunt posuere elit viverra libero tempor imperdiet, mollis quisque morbi integer mi habitasse dui lorem elementum, congue libero elementum nam justo nam orci donec. \n</p>', '<p>\nmaecenas adipiscing in nisi aenean hendrerit dapibus, quisque iaculis lectus leo eget, pretium consectetur cubilia porttitor netus. \nvestibulum vivamus viverra congue venenatis lacinia venenatis accumsan ultricies elementum, lectus pulvinar primis ut suscipit dapibus etiam ultricies dapibus, lobortis arcu vestibulum dictumst senectus litora ac primis. \npellentesque malesuada lectus egestas fermentum mi congue volutpat dictumst elit, metus consequat ante quisque gravida ante nisl. \nac curabitur integer ut congue odio hac ad netus malesuada est ac, interdum elit sociosqu maecenas primis urna risus sem donec. \nconvallis ullamcorper elementum adipiscing luctus dictumst blandit ornare turpis fringilla, euismod sit integer mattis nostra aliquet potenti gravida venenatis, purus felis accumsan in sapien condimentum diam risus. \n</p>\n<p>\nsuspendisse fringilla commodo cras tellus egestas gravida vitae sollicitudin, lorem per orci per taciti venenatis elit, ligula pulvinar elementum sagittis cubilia nisl est. \nnetus ad ac torquent tincidunt hendrerit vivamus augue tempus facilisis vestibulum habitant etiam, tincidunt morbi etiam orci neque semper sollicitudin consequat tempor sociosqu. \npulvinar platea leo condimentum libero himenaeos curabitur nec, porttitor justo aptent posuere tempor sagittis, primis semper senectus eget etiam aenean. \nmalesuada elit proin morbi malesuada, porta ullamcorper euismod accumsan ligula, curabitur magna consectetur. \ncras feugiat nibh ligula iaculis class euismod laoreet donec, vivamus condimentum blandit senectus ad eros proin, nullam ut faucibus mollis dictumst per aptent. \n</p>\n<p>\nquis metus adipiscing mollis venenatis aptent auctor vivamus mi vestibulum ultrices nisi, at enim nam sollicitudin phasellus auctor potenti aenean semper id, eleifend ornare lectus cursus cras ligula pharetra consequat ultricies tellus. \nphasellus faucibus est eros sit maecenas laoreet dolor, lectus nostra tempus inceptos etiam ut commodo, sagittis hac tristique vel lacinia velit. \nturpis mattis sodales ultricies himenaeos at platea ornare arcu commodo, inceptos elit morbi porta at commodo neque placerat. \neget varius augue lectus aliquam pellentesque donec, sem litora porta aenean convallis, platea a senectus proin nisl. \n</p>\n<p>\naenean iaculis lacus faucibus risus mauris, neque conubia diam ut purus libero, blandit integer platea quisque. \nest integer curabitur luctus dictum posuere vulputate sodales ac vulputate phasellus lacinia, congue commodo vehicula feugiat nam quisque ligula vivamus arcu amet elit, hac leo etiam sed lobortis maecenas etiam venenatis enim sodales. \ninterdum volutpat eget purus justo elementum orci, elit auctor lobortis aptent aliquam risus sed, eu luctus augue sed pretium. \nornare fusce aliquet hac semper litora tristique lectus ut sem fringilla varius, malesuada tellus pellentesque morbi luctus fusce rutrum enim nullam turpis cras, lobortis etiam enim sollicitudin curae dapibus hac porta nulla ultricies. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/kapkap/sets/72157630262692072/with/7413517300/{/gallery}</div></dd></dl>', '1', '0', '0', '14', '2013-07-26 11:55:14', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:14', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Condimentum sociosqu integer \",\"image_intro_caption\":\"Justo commodo cubilia aliquet commodo \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/4_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Condimentum sociosqu integer \",\"image_fulltext_caption\":\"Justo commodo cubilia aliquet commodo \"}', '', '', '1', '0', '0', 'Eccentric, Coutoure', '', '1', '0', '', '0', '*', ''), ('60', '106', 'Augue non nullam lorem pharetra vel ', 'augue-non-nullam-lorem-pharetra-vel', '', '<p>\nlorem dapibus porttitor nostra cubilia sem lorem morbi, non ultricies neque donec tempus ultricies bibendum est, tincidunt praesent venenatis commodo a pellentesque. \nproin euismod donec aenean cras nec feugiat venenatis fusce, facilisis sociosqu vehicula mauris dapibus semper rutrum dui, ipsum congue curabitur bibendum ultricies ipsum sapien. \ncurabitur platea tristique luctus per duis hac orci nisi cursus amet litora, venenatis lacinia ut placerat sem nulla et nulla convallis varius felis, at egestas erat ad eu primis ipsum integer sit ad. \nbibendum cras at risus pellentesque justo sagittis iaculis, quisque nulla ipsum justo himenaeos ligula ut, justo class conubia viverra dictum est. \n</p>', '<p>\netiam posuere pretium sit ornare, arcu mi viverra dui, vehicula et urna. \neleifend venenatis mi ut quisque egestas mollis cubilia quis volutpat ultricies, arcu erat iaculis vivamus at dapibus lacinia magna quam himenaeos mi, sed nibh molestie facilisis lacinia convallis consequat congue maecenas. \ninteger erat condimentum ante turpis rutrum blandit aliquam et, aliquam venenatis neque venenatis ut massa posuere pellentesque ut, praesent semper enim nibh accumsan sapien ac. \nmollis eleifend vel suscipit sem augue sociosqu aliquam integer dapibus eu vivamus aliquet, rutrum conubia felis nostra convallis vehicula sagittis donec phasellus nibh sagittis. \n</p>\n<p>\nsuscipit ultrices class nulla bibendum congue quisque risus elit cubilia nunc consequat, nunc netus phasellus fusce class porttitor velit platea diam. \ntortor a molestie ullamcorper fusce ac ante faucibus posuere, adipiscing congue elementum diam rutrum venenatis integer, dui ornare felis netus vivamus vel suscipit. \naugue sagittis erat quis nibh mattis ad, vehicula mi egestas taciti litora metus orci, nullam duis eget amet sit. \npellentesque suscipit rutrum bibendum nunc turpis sollicitudin inceptos neque tincidunt, aenean etiam lacinia accumsan adipiscing nulla egestas curabitur, odio nunc dapibus vivamus taciti curae fermentum augue. \n</p>\n<p>\nclass porttitor porta varius mollis tortor morbi odio aliquet enim, etiam per eu lorem urna rutrum commodo adipiscing congue nostra, ligula litora feugiat adipiscing in eros aptent mauris. \net class habitant consectetur pellentesque porta luctus habitasse odio quis netus, dictum praesent nisl aliquet senectus lacinia odio sagittis nisi feugiat, justo interdum curabitur congue varius vitae tincidunt amet faucibus. \nconsectetur fusce aenean nam libero varius arcu dui, massa quam fringilla condimentum amet sem ante condimentum, ad himenaeos lectus pellentesque tristique ultrices. \nlobortis ligula per velit ac lacinia consequat, adipiscing vestibulum mattis eu quam commodo, bibendum et porttitor torquent dictumst. \n</p>\n<p>\nclass est dolor purus nibh dui erat libero himenaeos pulvinar, duis placerat ut mattis orci convallis vestibulum litora, pretium sociosqu leo posuere ad massa rhoncus curabitur. \nurna sodales ad malesuada vivamus eleifend velit potenti orci, augue iaculis consectetur eleifend lacinia sapien mauris, curabitur sapien lacinia mollis congue gravida sagittis. \nlaoreet fermentum cursus consectetur id eleifend habitasse ultrices quisque, sodales donec quisque nisi porta placerat consequat ultrices, commodo suspendisse et aliquam taciti malesuada sem. \netiam sodales fringilla eleifend adipiscing sagittis est, phasellus praesent blandit vulputate ullamcorper velit placerat, ut egestas purus fermentum tortor. \n</p>\n<p>\nsed porttitor phasellus volutpat hac felis adipiscing imperdiet commodo mollis purus, donec a orci purus iaculis ultricies nam fames accumsan, conubia aliquet mauris lacus erat nullam felis pellentesque dui. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/rickh710/sets/72157624828280184{/gallery}</div></dd></dl>', '1', '0', '0', '12', '2013-07-26 11:55:19', '34', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-26 11:55:19', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Augue non nullam lorem pharetra vel \",\"image_intro_caption\":\"Sed lacus sodales tempor urna dolor \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/3_770.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Augue non nullam lorem pharetra vel \",\"image_fulltext_caption\":\"Sed lacus sodales tempor urna dolor \"}', '', '', '1', '0', '0', 'Album of the Week, House', '', '1', '0', '', '0', '*', '');
CREATE TABLE `#__content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__content_frontpage`  VALUES ('10', '4'), ('13', '2'), ('16', '5'), ('27', '3'), ('41', '1');
CREATE TABLE `#__content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',   `rating_count` int(10) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__core_log_searches` (   `search_term` varchar(128) NOT NULL DEFAULT '',   `hits` int(10) unsigned NOT NULL DEFAULT '0' ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__extensions` (   `extension_id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL,   `type` varchar(20) NOT NULL,   `element` varchar(100) NOT NULL,   `folder` varchar(100) NOT NULL,   `client_id` tinyint(3) NOT NULL,   `enabled` tinyint(3) NOT NULL DEFAULT '1',   `access` int(10) unsigned NOT NULL DEFAULT '1',   `protected` tinyint(3) NOT NULL DEFAULT '0',   `manifest_cache` text NOT NULL,   `params` text NOT NULL,   `custom_data` text NOT NULL,   `system_data` text NOT NULL,   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) DEFAULT '0',   `state` int(11) DEFAULT '0',   PRIMARY KEY (`extension_id`),   KEY `element_clientid` (`element`,`client_id`),   KEY `element_folder_clientid` (`element`,`folder`,`client_id`),   KEY `extension` (`type`,`element`,`folder`,`client_id`) ) ENGINE=InnoDB AUTO_INCREMENT=10034 DEFAULT CHARSET=utf8;
INSERT INTO `#__extensions`  VALUES ('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_name\":\"0\",\"show_position\":\"0\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"1\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"1\",\"show_base_description\":\"0\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"5\",\"num_intro_articles\":\"0\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('27', 'com_finder', 'component', 'com_finder', '', '1', '0', '0', '0', '{\"legacy\":false,\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"11.4\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('405', 'plg_content_geshi', 'plugin', 'geshi', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"xhtml\"}', '', '', '0', '2011-09-18 15:22:50', '0', '0'), ('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"2.5.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2013\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.4.1\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0'), ('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '8', '0'), ('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '10', '0'), ('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('500', 'atomic', 'template', 'atomic', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('502', 'bluestork', 'template', 'bluestork', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('503', 'beez_20', 'template', 'beez_20', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"2.5.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('505', 'beez5', 'template', 'beez5', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.10\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.10\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.13\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('800', 'PKG_JOOMLA', 'package', 'pkg_joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10000', 'com_k2', 'component', 'com_k2', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla!\",\"group\":\"\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"1.8remote\",\"backendJQueryHandling\":\"remote\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeedLink\":\"1\",\"userFeedIcon\":\"0\",\"userItemCount\":\"10\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"1\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"1\",\"userItemTags\":\"1\",\"userItemCommentsAnchor\":\"1\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"10\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"1\",\"tagItemDateCreated\":\"1\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"1\",\"tagItemReadMore\":\"1\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"0\",\"genericItemCount\":\"10\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"1\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"1\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"0\",\"genericFeedLink\":\"1\",\"genericFeedIcon\":\"0\",\"feedLimit\":\"10\",\"feedItemImage\":\"1\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"0\",\"feedItemVideo\":\"0\",\"feedItemGallery\":\"0\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"70\",\"itemImageS\":\"270\",\"itemImageM\":\"560\",\"itemImageL\":\"770\",\"itemImageXL\":\"900\",\"itemImageGeneric\":\"270\",\"catImageWidth\":\"70\",\"catImageDefault\":\"1\",\"userImageWidth\":\"70\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"48\",\"onlineImageEditor\":\"splashup\",\"imageTimestamp\":\"0\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"\",\"facebookImage\":\"Medium\",\"comments\":\"1\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"10\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"1\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"0\",\"gravatar\":\"1\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"1\",\"akismetForRegistered\":\"1\",\"commentsFormNotes\":\"1\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"1\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"1\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"0\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"redirect\":\"\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaOnRegistration\":\"0\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"0\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"0\",\"k2SefLabelItemCustomPrefix\":\"\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"dash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\",\"sh404SefLabelCat\":\"\",\"sh404SefLabelUser\":\"blog\",\"sh404SefLabelItem\":\"2\",\"sh404SefTitleAlias\":\"alias\",\"sh404SefModK2ContentFeedAlias\":\"feed\",\"sh404SefInsertItemId\":\"0\",\"sh404SefInsertUniqueItemId\":\"0\",\"cbIntegration\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10001', 'plg_finder_k2', 'plugin', 'k2', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10002', 'Search - K2', 'plugin', 'k2', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10003', 'System - K2', 'plugin', 'k2', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10004', 'User - K2', 'plugin', 'k2', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10005', 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Josetta - K2 Categories\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10006', 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Josetta - K2 Items\",\"type\":\"plugin\",\"creationDate\":\"June 7th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10007', 'K2 Comments', 'module', 'mod_k2_comments', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10008', 'K2 Content', 'module', 'mod_k2_content', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10009', 'K2 Tools', 'module', 'mod_k2_tools', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_TOOLS\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10010', 'K2 Users', 'module', 'mod_k2_users', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10011', 'K2 User', 'module', 'mod_k2_user', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10012', 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10013', 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10017', 'AllVideos (by JoomlaWorks)', 'plugin', 'jw_allvideos', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"AllVideos (by JoomlaWorks)\",\"type\":\"plugin\",\"creationDate\":\"February 27th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"contact@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"4.5.0\",\"description\":\"JW_PLG_AV_XML_DESC\",\"group\":\"\"}', '{\"playerTemplate\":\"Responsive\",\"vfolder\":\"images\\/videos\",\"vwidth\":\"400\",\"vheight\":\"300\",\"transparency\":\"transparent\",\"background\":\"#010101\",\"controlBarLocation\":\"bottom\",\"backgroundQT\":\"black\",\"afolder\":\"images\\/audio\",\"awidth\":\"480\",\"aheight\":\"24\",\"abackground\":\"#010101\",\"afrontcolor\":\"#FFFFFF\",\"alightcolor\":\"#00ADE3\",\"allowAudioDownloading\":\"0\",\"autoplay\":\"0\",\"gzipScripts\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10022', 'nuModusVersus', 'template', 'numodusversus', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"nuModusVersus\",\"type\":\"template\",\"creationDate\":\"July 24th, 2013\",\"author\":\"Nuevvo Webware Ltd.\",\"copyright\":\"Copyright (c) 2010 - 2013 Nuevvo Webware Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form\",\"authorUrl\":\"http:\\/\\/nuevvo.gr\",\"version\":\"1.0.1\",\"description\":\"TPL_NUMODUSVERSUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"siteTextAsLogo\":\"\",\"siteTagline\":\"\",\"nutpJqueryHandling\":\"1.10.1\",\"nutpLoadCustomCSS\":\"1\",\"nutpLoadCustomJS\":\"1\",\"nutpGoogleWebFonts\":\"Open Sans\",\"nutpMetaDistribution\":\"global\",\"nutpRemoveCanonicalMeta\":\"0\",\"nutpForceLoadBootstrap\":\"0\",\"nutpCreditsName\":\"designed by Nuevvo\",\"nutpCreditsLink\":\"http:\\/\\/nuevvo.com\",\"nutpCopyright\":\"\",\"nutpCopyrightStartYear\":\"\",\"nutpGAID\":\"\",\"nutpGADomain\":\"\",\"nutpGoogleVerificationID\":\"\",\"nutpBingVerificationID\":\"\",\"nutpAlexaVerificationID\":\"\",\"siteSocialFacebook\":\"\",\"siteSocialTwitter\":\"\",\"siteSocialGooglePlus\":\"\",\"siteSocialFoursquare\":\"\",\"siteSocialYouTube\":\"\",\"siteSocialVimeo\":\"\",\"siteSocialDailymotion\":\"\",\"siteSocialSoundCloud\":\"\",\"siteSocialMixCloud\":\"\",\"siteSocialFlickr\":\"\",\"siteSocialInstagram\":\"\",\"siteSocialPinterest\":\"\",\"siteSocial500px\":\"\",\"siteSocialDribbble\":\"\",\"siteSocialBehance\":\"\",\"siteSocialGithub\":\"\",\"nutpHeadTop\":\"\",\"nutpHeadBottom\":\"\",\"nutpBodyTop\":\"\",\"nutpBodyBottom\":\"\",\"colorVariations\":\"default\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10023', 'admintools', 'component', 'com_admintools', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Admintools\",\"type\":\"component\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"Security and utilitarian tools for Joomla! site administrators\",\"group\":\"\"}', '{\"liveupdate\":\"stuck=0\\nlastcheck=1374847705\\nupdatedata=\\\"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\\\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10024', 'Admin Tools Joomla! Upgrade Notification', 'module', 'mod_atjupgrade', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"Admin Tools Joomla! Upgrade Notification\",\"type\":\"module\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10025', 'System - Admin Tools', 'plugin', 'admintools', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Admin Tools\",\"type\":\"plugin\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"\\n\\t\\tHandles all the system-wide features provided by Admin Tools Core\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10026', 'FOF', 'library', 'lib_fof', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2013-06-26\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2013 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.1.b2\",\"description\":\"Framework-on-Framework (FOF) - A rapid component development framework for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10027', 'AkeebaStrapper', 'file', 'files_strapper', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"AkeebaStrapper\",\"type\":\"file\",\"creationDate\":\"July 2012\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"(C) 2012-2013 Akeeba Ltd.\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"1.0.0\",\"description\":\"Namespaced jQuery, jQuery UI and Bootstrap for Akeeba products.\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10028', 'akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2013-06-29\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.7.10\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\"}', '{\"siteurl\":\"http:\\/\\/demo.nuevvo.com\\/commercial\\/j25\\/numodusversus\\/\",\"jlibrariesdir\":\"\\/home\\/demos\\/domains\\/demo.nuevvo.com\\/public_html\\/commercial\\/j25\\/numodusversus\\/libraries\",\"jversion\":\"1.6\",\"liveupdate\":\"stuck=0\\nlastcheck=1374847738\\nupdatedata=\\\"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\\\"\",\"lastversion\":\"3.7.10\",\"minstability\":\"stable\",\"acceptlicense\":true,\"acceptsupport\":true,\"acceptbackuptest\":true,\"angieupgrade\":1}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10029', 'PLG_JMONITORING_AKEEBABACKUP_TITLE', 'plugin', 'akeebabackup', 'jmonitoring', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_JMONITORING_AKEEBABACKUP_TITLE\",\"type\":\"plugin\",\"creationDate\":\"May 2012\",\"author\":\"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com\",\"copyright\":\"\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"1.0\",\"description\":\"PLG_JMONITORING_AKEEBABACKUP_DESCRIPTION\",\"group\":\"\"}', '{\"maxbackupperiod\":\"24\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10030', 'Simple Image Gallery (by JoomlaWorks)', 'plugin', 'jw_sig', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"Simple Image Gallery (by JoomlaWorks)\",\"type\":\"plugin\",\"creationDate\":\"May 27th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"3.0.0\",\"description\":\"JW_PLG_SIG_XML_DESC\",\"group\":\"\"}', '{\"galleries_rootfolder\":\"images\",\"jQueryHandling\":\"0\",\"thb_width\":\"200\",\"thb_height\":\"160\",\"jpg_quality\":\"80\",\"cache_expire_time\":\"1440\",\"memoryLimit\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10031', 'PLG_SYSTEM_CACHECLEANER', 'plugin', 'cachecleaner', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_SYSTEM_CACHECLEANER\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"PLG_SYSTEM_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10032', 'MOD_CACHECLEANER', 'module', 'mod_cachecleaner', '', '1', '1', '3', '0', '{\"legacy\":false,\"name\":\"MOD_CACHECLEANER\",\"type\":\"module\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"MOD_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10033', 'PLG_SYSTEM_NNFRAMEWORK', 'plugin', 'nnframework', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_SYSTEM_NNFRAMEWORK\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"13.5.3\",\"description\":\"PLG_SYSTEM_NNFRAMEWORK_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
CREATE TABLE `#__finder_filters` (   `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '1',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL,   `created_by_alias` varchar(255) NOT NULL,   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `map_count` int(10) unsigned NOT NULL DEFAULT '0',   `data` text NOT NULL,   `params` mediumtext,   PRIMARY KEY (`filter_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links` (   `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `url` varchar(255) NOT NULL,   `route` varchar(255) NOT NULL,   `title` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `md5sum` varchar(32) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '1',   `state` int(5) DEFAULT '1',   `access` int(5) DEFAULT '0',   `language` varchar(8) NOT NULL,   `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `list_price` double unsigned NOT NULL DEFAULT '0',   `sale_price` double unsigned NOT NULL DEFAULT '0',   `type_id` int(11) NOT NULL,   `object` mediumblob NOT NULL,   PRIMARY KEY (`link_id`),   KEY `idx_type` (`type_id`),   KEY `idx_title` (`title`),   KEY `idx_md5` (`md5sum`),   KEY `idx_url` (`url`(75)),   KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),   KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`) ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms0` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms1` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms2` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms3` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms4` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms5` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms6` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms7` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms8` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms9` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsa` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsb` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsc` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsd` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termse` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsf` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_taxonomy` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL,   `state` tinyint(1) unsigned NOT NULL DEFAULT '1',   `access` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `parent_id` (`parent_id`),   KEY `state` (`state`),   KEY `ordering` (`ordering`),   KEY `access` (`access`),   KEY `idx_parent_published` (`parent_id`,`state`,`access`) ) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_taxonomy_map` (   `link_id` int(10) unsigned NOT NULL,   `node_id` int(10) unsigned NOT NULL,   PRIMARY KEY (`link_id`,`node_id`),   KEY `link_id` (`link_id`),   KEY `node_id` (`node_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_terms` (   `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '0',   `soundex` varchar(75) NOT NULL,   `links` int(10) NOT NULL DEFAULT '0',   PRIMARY KEY (`term_id`),   UNIQUE KEY `idx_term` (`term`),   KEY `idx_term_phrase` (`term`,`phrase`),   KEY `idx_stem_phrase` (`stem`,`phrase`),   KEY `idx_soundex_phrase` (`soundex`,`phrase`) ) ENGINE=InnoDB AUTO_INCREMENT=1052 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_terms_common` (   `term` varchar(75) NOT NULL,   `language` varchar(3) NOT NULL,   KEY `idx_word_lang` (`term`,`language`),   KEY `idx_lang` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__finder_terms_common`  VALUES ('a', 'en'), ('about', 'en'), ('after', 'en'), ('ago', 'en'), ('all', 'en'), ('am', 'en'), ('an', 'en'), ('and', 'en'), ('ani', 'en'), ('any', 'en'), ('are', 'en'), ('aren\'t', 'en'), ('as', 'en'), ('at', 'en'), ('be', 'en'), ('but', 'en'), ('by', 'en'), ('for', 'en'), ('from', 'en'), ('get', 'en'), ('go', 'en'), ('how', 'en'), ('if', 'en'), ('in', 'en'), ('into', 'en'), ('is', 'en'), ('isn\'t', 'en'), ('it', 'en'), ('its', 'en'), ('me', 'en'), ('more', 'en'), ('most', 'en'), ('must', 'en'), ('my', 'en'), ('new', 'en'), ('no', 'en'), ('none', 'en'), ('not', 'en'), ('noth', 'en'), ('nothing', 'en'), ('of', 'en'), ('off', 'en'), ('often', 'en'), ('old', 'en'), ('on', 'en'), ('onc', 'en'), ('once', 'en'), ('onli', 'en'), ('only', 'en'), ('or', 'en'), ('other', 'en'), ('our', 'en'), ('ours', 'en'), ('out', 'en'), ('over', 'en'), ('page', 'en'), ('she', 'en'), ('should', 'en'), ('small', 'en'), ('so', 'en'), ('some', 'en'), ('than', 'en'), ('thank', 'en'), ('that', 'en'), ('the', 'en'), ('their', 'en'), ('theirs', 'en'), ('them', 'en'), ('then', 'en'), ('there', 'en'), ('these', 'en'), ('they', 'en'), ('this', 'en'), ('those', 'en'), ('thus', 'en'), ('time', 'en'), ('times', 'en'), ('to', 'en'), ('too', 'en'), ('true', 'en'), ('under', 'en'), ('until', 'en'), ('up', 'en'), ('upon', 'en'), ('use', 'en'), ('user', 'en'), ('users', 'en'), ('veri', 'en'), ('version', 'en'), ('very', 'en'), ('via', 'en'), ('want', 'en'), ('was', 'en'), ('way', 'en'), ('were', 'en'), ('what', 'en'), ('when', 'en'), ('where', 'en'), ('whi', 'en'), ('which', 'en'), ('who', 'en'), ('whom', 'en'), ('whose', 'en'), ('why', 'en'), ('wide', 'en'), ('will', 'en'), ('with', 'en'), ('within', 'en'), ('without', 'en'), ('would', 'en'), ('yes', 'en'), ('yet', 'en'), ('you', 'en'), ('your', 'en'), ('yours', 'en');
CREATE TABLE `#__finder_tokens` (   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '1',   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   KEY `idx_word` (`term`),   KEY `idx_context` (`context`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_tokens_aggregate` (   `term_id` int(10) unsigned NOT NULL,   `map_suffix` char(1) NOT NULL,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `term_weight` float unsigned NOT NULL,   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   `context_weight` float unsigned NOT NULL,   `total_weight` float unsigned NOT NULL,   KEY `token` (`term`),   KEY `keyword_id` (`term_id`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(100) NOT NULL,   `mime` varchar(100) NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `title` (`title`) ) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
INSERT INTO `#__finder_types`  VALUES ('1', 'K2 Item', ''), ('2', 'Category', ''), ('3', 'Contact', ''), ('4', 'Article', ''), ('5', 'News Feed', ''), ('6', 'Web Link', '');
CREATE TABLE `#__k2_attachments` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `itemID` int(11) NOT NULL,   `filename` varchar(255) NOT NULL,   `title` varchar(255) NOT NULL,   `titleAttribute` text NOT NULL,   `hits` int(11) NOT NULL,   PRIMARY KEY (`id`),   KEY `itemID` (`itemID`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__k2_categories` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `description` text NOT NULL,   `parent` int(11) DEFAULT '0',   `extraFieldsGroup` int(11) NOT NULL,   `published` smallint(6) NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `image` varchar(255) NOT NULL,   `params` text NOT NULL,   `trash` smallint(6) NOT NULL DEFAULT '0',   `plugins` text NOT NULL,   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `category` (`published`,`access`,`trash`),   KEY `parent` (`parent`),   KEY `ordering` (`ordering`),   KEY `published` (`published`),   KEY `access` (`access`),   KEY `trash` (`trash`),   KEY `language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_categories`  VALUES ('1', 'Quotes', 'quotes', '<p>\naliquet lectus per integer sodales nibh adipiscing curabitur malesuada nulla, nisl cras nulla cursus maecenas sed commodo donec pretium nam, nibh a erat sagittis aenean nunc suspendisse interdum. \nfames scelerisque curabitur quisque arcu cursus habitasse platea, fusce elit suscipit tincidunt ultricies pellentesque etiam condimentum, ultrices ut aenean sociosqu curae tincidunt. \nnam viverra sociosqu diam faucibus in lobortis sodales, dui volutpat venenatis elementum nisl sollicitudin nisl urna, porta pretium pharetra scelerisque lacus auctor. \nvolutpat suspendisse consectetur lectus etiam aptent elementum, faucibus quam est pretium. \nlibero tellus faucibus nibh netus dictum scelerisque, facilisis tellus dictumst integer auctor, quisque ultricies ad curabitur vivamus. \n</p>', '0', '0', '1', '1', '1', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('2', 'Quotes', 'quotes', '<p>fermentum volutpat mollis varius lorem habitant aenean lacus aliquam enim, mollis tempus netus tempor volutpat etiam integer urna ac, bibendum id integer fringilla diam faucibus amet elementum. dui gravida nostra donec dictum porta lacus nullam risus neque, molestie cursus libero eros inceptos pellentesque aliquet tempus imperdiet, adipiscing dolor primis pulvinar mollis ante enim sagittis. porta eros semper porta pulvinar senectus phasellus donec tortor class pulvinar, cubilia praesent pellentesque sollicitudin lorem leo curabitur habitasse per dapibus scelerisque, id senectus ligula ultricies torquent ligula pulvinar sit fermentum. duis vulputate id senectus donec mi aenean nisi diam, nisi aptent nisl accumsan blandit scelerisque.</p>', '0', '3', '1', '1', '1', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('3', 'Dance', 'dance', '<p>\nluctus ac consequat cursus nullam ad ultrices quam sit, consequat quam egestas quisque aliquam lorem quisque potenti, molestie placerat felis ad sem tempor eu. \nposuere metus dolor nostra vestibulum convallis dui pharetra duis elit velit auctor porta sed, pharetra felis vitae auctor aenean netus orci pretium in per est consectetur. \naugue justo vivamus primis conubia tristique lobortis aliquam dolor sit, ipsum aptent augue rutrum hendrerit quis curae placerat pulvinar euismod, nunc inceptos congue nec aenean dolor praesent dictum. \nconsequat molestie etiam vivamus suspendisse aliquam praesent etiam, curae posuere imperdiet volutpat magna vitae curabitur aliquam, a ornare arcu egestas potenti gravida. \n</p>', '0', '0', '1', '1', '3', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('4', 'Design', 'design', '<p>\nrisus laoreet venenatis curabitur quisque hendrerit mattis est et venenatis eget dui, consequat porttitor sociosqu habitant scelerisque quam ligula class congue imperdiet. \npurus massa ullamcorper tincidunt molestie est urna litora tincidunt commodo ante risus sed rutrum amet a, nisl vehicula tristique laoreet bibendum mauris placerat sit ac conubia gravida malesuada ac pretium. \nsemper feugiat eget sed molestie potenti ad sem nisl, elit dictum augue placerat etiam rhoncus morbi himenaeos, erat integer gravida suspendisse sagittis tristique curabitur. \nsed donec vulputate lacinia proin commodo tortor in lectus, consectetur lacus sit velit suscipit praesent habitasse curabitur, etiam facilisis mollis ac enim ut per. \n</p>', '0', '0', '1', '1', '4', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('5', 'Fashion', 'fashion', '<p>\nclass consequat congue mattis arcu ullamcorper vel facilisis sit tristique lorem tristique dui sit litora, libero turpis aenean rutrum primis nulla varius elementum ut a turpis bibendum senectus. \nfermentum fringilla senectus varius dictum primis sollicitudin in urna non convallis varius sagittis, turpis posuere sagittis sociosqu commodo fringilla mattis lobortis aliquam lobortis. \ninteger curae mattis ultricies orci habitant dapibus sollicitudin platea quisque, quis etiam dapibus quis praesent in luctus aliquet, tempor leo dictum class ipsum per nisl lorem. \neleifend quam tincidunt per litora curabitur sem cursus non, fusce scelerisque himenaeos sapien amet suspendisse tempor, hac aliquam lectus netus ligula arcu id. \n</p>', '0', '0', '1', '1', '5', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('6', 'Movies', 'movies', '<p>\nneque est potenti dictumst aliquam dolor fringilla blandit, himenaeos curabitur at habitant aptent neque lorem, pulvinar primis gravida nisl accumsan augue, eleifend quisque cursus phasellus hac arcu. \ndictumst himenaeos interdum facilisis integer pretium at aenean tellus litora ante neque mollis quisque semper, mi conubia placerat venenatis proin volutpat urna himenaeos tempor fusce dapibus pulvinar. \npretium volutpat nam est hac potenti interdum morbi fusce integer est dapibus etiam, mollis quisque porttitor at arcu pretium duis convallis ultricies sodales donec, metus sapien luctus iaculis sit lectus nullam morbi donec proin ante. \n</p>\n<p>\nquis feugiat sapien adipiscing sapien nullam odio, metus justo phasellus consequat. \n</p>', '0', '0', '1', '1', '6', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('7', 'Music', 'music', '<p>\nenim ante aliquam vehicula felis cubilia nulla quam quisque phasellus sapien, quis sociosqu non sapien consequat torquent consequat curabitur. \nsodales neque cursus adipiscing ultrices urna suscipit quisque, interdum turpis rhoncus molestie sed vehicula massa est, rhoncus ullamcorper convallis dolor porta aptent. \nauctor nostra velit litora facilisis donec feugiat inceptos feugiat, congue urna molestie bibendum platea ornare sit, quisque a convallis venenatis ultricies nunc duis. \namet morbi vestibulum aenean interdum semper vestibulum lorem cras, taciti donec sodales habitant fringilla varius lacus, mollis id turpis a interdum habitasse libero. \netiam maecenas venenatis nec ornare tempor bibendum litora, facilisis elit tellus elementum venenatis. \n</p>', '0', '0', '1', '1', '7', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('8', 'Night Out', 'night-out', '<p>\nmalesuada quis condimentum aliquam quisque tristique pulvinar sapien mattis dictumst porttitor, aenean augue dui inceptos sollicitudin dictumst sagittis rhoncus. \nmaecenas quisque leo at erat vulputate etiam scelerisque, cras vulputate venenatis purus platea volutpat, vel adipiscing augue mattis ultricies euismod. \nmauris dolor malesuada bibendum malesuada sociosqu arcu ultrices fames vehicula, varius semper libero mollis litora nullam nostra habitasse nec arcu, sit taciti varius volutpat viverra malesuada etiam aptent. \nnisl imperdiet quisque maecenas libero quam suscipit dapibus tristique maecenas luctus mollis, vitae praesent feugiat tortor at torquent diam pretium taciti lacinia aliquam, venenatis pretium senectus integer amet scelerisque dui duis aliquam condimentum. \n</p>', '0', '0', '1', '1', '8', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('9', 'Style', 'style', '<p>\neuismod nostra sit semper curabitur fringilla et, morbi mollis lobortis pellentesque sed, pulvinar egestas lorem proin aenean. \nnisi donec fusce mauris ac donec ornare, lorem porta molestie vulputate lobortis euismod vivamus, maecenas inceptos nam tristique nunc. \nmattis mi risus aliquet volutpat ante vivamus laoreet urna scelerisque praesent aptent, arcu iaculis odio dolor vehicula tincidunt platea etiam iaculis fusce, aenean vehicula urna per habitant eleifend adipiscing nulla primis hendrerit. \nnibh feugiat ut sollicitudin interdum consectetur congue tristique, dapibus dolor fusce sociosqu enim neque, sed quisque malesuada lacus potenti dolor. \n</p>\n<p>\nmolestie mollis magna gravida a ante vehicula, auctor vel ullamcorper conubia sollicitudin. \n</p>', '0', '0', '1', '1', '9', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('10', 'Technology', 'technology', '<p>\nconubia vitae lobortis et fusce praesent erat semper lorem bibendum porta, netus neque rutrum pellentesque quam cras sagittis donec cubilia, vulputate tincidunt nostra vestibulum porttitor cras pellentesque tristique habitasse. \nlaoreet commodo ornare tristique justo iaculis inceptos, quis ultrices fermentum odio viverra, sollicitudin rhoncus ac tellus eu. \nhabitant pulvinar egestas sagittis ac proin mattis vel, primis sodales aenean sem porttitor quam malesuada curae, enim tortor aliquam iaculis mauris nostra. \na porta urna scelerisque hendrerit vivamus accumsan torquent leo aenean quisque habitasse, curabitur aliquam ultrices turpis potenti sociosqu ut molestie sociosqu. \n</p>\n<p>\neleifend orci volutpat tincidunt sem auctor venenatis, interdum per nisl curae. \n</p>', '0', '0', '1', '1', '10', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('11', 'Theater', 'theater', '<p>\nfaucibus ligula odio massa sodales blandit mauris consequat at cubilia nam justo pharetra, mauris non aliquam bibendum vitae vulputate eu inceptos pretium leo. \naptent sit auctor id faucibus eu orci quam aenean, lacus senectus nunc mauris iaculis a velit, platea aliquet nostra cras sapien mi torquent. \nut faucibus quis odio luctus malesuada vehicula bibendum et, consequat turpis nunc etiam tempus vulputate amet posuere, ante conubia sociosqu auctor ante vestibulum congue. \npurus urna nisl arcu conubia tellus lacus mi pellentesque lacinia mollis, sollicitudin leo justo non phasellus egestas sed ultrices gravida. \n</p>\n<p>\nquam hendrerit sagittis integer rhoncus taciti, per malesuada curabitur ullamcorper. \n</p>', '0', '0', '1', '1', '11', '', '{\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '1', '', '*'), ('12', 'Dance', 'dance', '<p>mattis velit orci elit gravida dolor mattis turpis sagittis vel, congue arcu eu ut varius inceptos est quis iaculis bibendum, habitant dictumst id nullam maecenas vitae in curabitur. donec habitasse porta varius fames fringilla convallis tellus, adipiscing ut imperdiet augue nibh curae, convallis accumsan hendrerit eget porttitor turpis. fusce purus leo platea phasellus facilisis nisl aliquet augue, interdum dictum etiam congue eros eu dictumst condimentum, vivamus pulvinar lobortis consequat cursus integer nec. ut luctus turpis adipiscing in vestibulum consequat, morbi semper eleifend suscipit etiam ipsum viverra, consectetur sit pharetra sollicitudin inceptos.</p>\r\n<p>quisque tortor iaculis elementum congue pretium, diam sed sollicitudin.</p>', '22', '0', '0', '1', '1', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('13', 'Design', 'design', '<p>posuere litora metus dictumst himenaeos cursus tempor congue semper, fames curabitur consequat senectus mi massa class, pharetra aenean vel etiam morbi habitant felis. blandit vitae donec nisl ac venenatis libero sodales habitant, ad odio per hendrerit lorem nam magna habitasse vitae, tristique fames habitasse nam cubilia massa habitant. sollicitudin donec habitasse dictumst aptent nec eros aenean porttitor euismod malesuada nam, eget cras congue habitant consequat nam orci tincidunt et lacus. himenaeos nostra adipiscing ut per consequat sodales, ac rhoncus justo ad in. vestibulum senectus feugiat enim taciti commodo sit congue at luctus, placerat sed mattis lobortis pretium enim ipsum purus.</p>', '21', '0', '1', '1', '1', '', '{\"inheritFrom\":\"25\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('14', 'Fashion', 'fashion', '<p>elit dolor porttitor elit porta convallis malesuada lobortis proin curae iaculis, commodo porttitor imperdiet mattis litora aliquam conubia libero proin, sodales dictum porttitor donec nunc vivamus eleifend torquent donec. praesent augue viverra semper pulvinar ultricies arcu lacus, mauris iaculis lectus sollicitudin etiam litora, semper proin hendrerit libero molestie dolor. taciti venenatis placerat rhoncus fusce faucibus praesent, placerat primis amet vitae sodales erat dictum, non blandit vitae curabitur pretium. tellus senectus libero lorem est eu dictumst diam luctus varius dictum purus, nisl curabitur morbi a metus aptent condimentum amet rhoncus sit, elementum blandit cras felis quisque porta sapien molestie sit euismod.</p>', '21', '0', '1', '1', '2', '', '{\"inheritFrom\":\"25\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('15', 'Movies', 'movies', '<p>arcu aptent nostra nisi donec leo quisque habitasse nulla viverra scelerisque nibh, pulvinar venenatis sagittis sem tincidunt viverra non phasellus netus. nisi adipiscing sed elementum mattis leo hendrerit, ornare lectus semper etiam primis, urna eget fames litora auctor. aptent purus vivamus donec proin nisi dictumst phasellus turpis nec vulputate euismod praesent elit sapien fames, dictumst pulvinar magna quis sed aliquet ultrices aenean venenatis curabitur nostra primis magna sollicitudin. eu sagittis convallis duis pulvinar elementum aenean nunc aliquet, pretium congue dolor sociosqu nam torquent est, sociosqu vivamus faucibus ipsum iaculis facilisis cubilia.</p>\r\n<p>posuere convallis ultricies porttitor cubilia libero, netus leo tristique.</p>', '22', '0', '0', '1', '2', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('16', 'Music', 'music', '<p>fringilla erat ultrices ultricies malesuada mollis urna arcu porta posuere, non neque dui enim conubia sapien phasellus. proin vitae tempor turpis bibendum sit orci odio ut risus, ad primis vulputate viverra felis conubia nostra cubilia dolor, dictumst mattis elementum vestibulum arcu duis quisque interdum. velit vel fermentum aenean ornare volutpat nibh at hendrerit, netus tristique est cubilia neque odio libero congue fusce, volutpat sagittis hac praesent sed venenatis sociosqu. ullamcorper pellentesque tristique habitasse duis scelerisque blandit eu ultricies quam consectetur, est nulla taciti ornare porta commodo sed erat sit turpis aenean, elit habitant etiam vitae aenean pellentesque metus sem imperdiet.</p>', '22', '0', '1', '1', '3', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('17', 'Night Out', 'night-out', '<p>aliquet integer phasellus id diam urna commodo sem diam, blandit scelerisque convallis purus ullamcorper ad. egestas orci tristique venenatis porta aptent elementum rutrum pretium arcu, tristique aenean pulvinar netus auctor felis platea in, nec faucibus curae a curabitur eget porttitor placerat. fusce eget condimentum potenti tempus ante pellentesque maecenas euismod aliquet leo, ut curabitur luctus lorem adipiscing ante nunc sodales mauris sagittis quis, erat quis sit interdum inceptos aliquam convallis massa eleifend. adipiscing ligula ultrices venenatis ut nisl magna primis platea facilisis erat id tempor, tortor dictum eleifend aliquet etiam dolor netus taciti etiam hendrerit lectus.</p>\r\n<p>euismod consequat hac, nulla.</p>', '22', '0', '0', '1', '4', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('18', 'Style', 'style', '<p>consequat lobortis massa ultricies aenean habitasse potenti consectetur quisque, ac auctor congue purus vel erat vitae eget, praesent interdum felis nisl elementum accumsan sed. curabitur magna at ut rutrum cursus aenean eu consequat, eu pulvinar pellentesque duis massa et semper massa, aptent habitasse fermentum per faucibus ut mollis. pellentesque scelerisque ullamcorper tempor aliquam imperdiet vehicula volutpat aliquam ut ultrices fusce metus, mattis at tortor auctor sollicitudin orci est aliquet phasellus aenean. ut aptent sodales turpis eget hac aenean, maecenas magna eros rutrum dui lobortis, blandit suscipit ornare ultrices leo.</p>\r\n<p>pellentesque non nunc est phasellus mauris taciti, habitant suspendisse molestie aptent.</p>', '21', '0', '1', '1', '3', '', '{\"inheritFrom\":\"25\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('19', 'Technology', 'technology', '<p>suspendisse semper proin tempor ligula libero vestibulum pretium primis torquent, commodo purus pellentesque dictumst felis curae eros donec. quam tellus ultrices suscipit pellentesque nisl ultricies sed, non vivamus eu suspendisse platea at, praesent auctor sociosqu proin amet ornare. faucibus sem non turpis lobortis non rutrum nibh massa senectus malesuada class, hac dictumst pretium etiam eget turpis lacinia cursus pulvinar senectus lacinia placerat, mauris sagittis etiam congue malesuada sit tempor metus vivamus senectus. leo nisi mi diam vestibulum vel iaculis in tempus hac donec consequat elementum phasellus aliquam, consectetur lectus pretium augue porttitor sociosqu metus accumsan non turpis vehicula posuere enim.</p>', '21', '0', '1', '1', '4', '', '{\"inheritFrom\":\"25\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('20', 'Theater', 'theater', '<p>rhoncus viverra quam convallis ornare hac sed egestas aliquet, et laoreet augue habitasse massa nec elit, turpis pharetra varius odio morbi malesuada commodo. dolor lorem class lacinia nisi eu ultricies faucibus iaculis quis consequat feugiat, proin magna tincidunt accumsan donec mauris leo ad maecenas. quis sapien ut ad placerat blandit donec pulvinar nec sagittis, duis enim volutpat elit condimentum vitae aenean feugiat ad dapibus, sagittis senectus porttitor faucibus nisl tellus sed a. venenatis nulla facilisis mauris eget ut hendrerit suspendisse mi nunc, sociosqu luctus commodo potenti litora dictumst aliquet.</p>\r\n<p>sed aliquam turpis justo elementum est facilisis, libero vel consequat senectus.</p>', '22', '0', '1', '1', '5', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('21', 'Blog', 'blog', '', '0', '0', '1', '1', '2', '', '{\"inheritFrom\":\"25\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('22', 'K2 Categories', 'k2-categories', '', '0', '0', '1', '1', '3', '', '{\"inheritFrom\":\"26\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('23', 'About', 'about', '', '0', '0', '1', '1', '4', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('24', 'Clients', 'clients', '', '0', '1', '1', '1', '5', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('25', 'SETUP Category Blog (DO NOT DELETE)', 'setup-category-blog-do-not-delete', '', '0', '0', '1', '1', '6', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"5\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('26', 'SETUP Category Grid (DO NOT DELETE)', 'setup-category-grid-do-not-delete', '', '0', '0', '1', '1', '7', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"8\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"0\",\"catItemDateCreated\":\"0\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"0\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"0\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*');
CREATE TABLE `#__k2_comments` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `itemID` int(11) NOT NULL,   `userID` int(11) NOT NULL,   `userName` varchar(255) NOT NULL,   `commentDate` datetime NOT NULL,   `commentText` text NOT NULL,   `commentEmail` varchar(255) NOT NULL,   `commentURL` varchar(255) NOT NULL,   `published` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `itemID` (`itemID`),   KEY `userID` (`userID`),   KEY `published` (`published`),   KEY `latestComments` (`published`,`commentDate`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__k2_extra_fields` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   `value` text NOT NULL,   `type` varchar(255) NOT NULL,   `group` int(11) NOT NULL,   `published` tinyint(4) NOT NULL,   `ordering` int(11) NOT NULL,   PRIMARY KEY (`id`),   KEY `group` (`group`),   KEY `published` (`published`),   KEY `ordering` (`ordering`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_extra_fields`  VALUES ('1', 'Image', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"image\",\"required\":0,\"showNull\":0}]', 'image', '1', '1', '1'), ('2', 'Link', '[{\"name\":\"\",\"value\":\"http:\\/\\/\",\"target\":\"new\",\"alias\":\"link\",\"required\":0,\"showNull\":0}]', 'link', '1', '1', '2'), ('3', 'Quoter Name', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"\",\"required\":0,\"showNull\":0}]', 'textfield', '3', '1', '1');
CREATE TABLE `#__k2_extra_fields_groups` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_extra_fields_groups`  VALUES ('1', 'Clients'), ('3', 'Quotes');
CREATE TABLE `#__k2_items` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) DEFAULT NULL,   `catid` int(11) NOT NULL,   `published` smallint(6) NOT NULL DEFAULT '0',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `video` text,   `gallery` varchar(255) DEFAULT NULL,   `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,   `extra_fields_search` text NOT NULL,   `created` datetime NOT NULL,   `created_by` int(11) NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL,   `checked_out` int(10) unsigned NOT NULL,   `checked_out_time` datetime NOT NULL,   `modified` datetime NOT NULL,   `modified_by` int(11) NOT NULL DEFAULT '0',   `publish_up` datetime NOT NULL,   `publish_down` datetime NOT NULL,   `trash` smallint(6) NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `featured` smallint(6) NOT NULL DEFAULT '0',   `featured_ordering` int(11) NOT NULL DEFAULT '0',   `image_caption` text NOT NULL,   `image_credits` varchar(255) NOT NULL,   `video_caption` text NOT NULL,   `video_credits` varchar(255) NOT NULL,   `hits` int(10) unsigned NOT NULL,   `params` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `metakey` text NOT NULL,   `plugins` text NOT NULL,   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),   KEY `catid` (`catid`),   KEY `created_by` (`created_by`),   KEY `ordering` (`ordering`),   KEY `featured` (`featured`),   KEY `featured_ordering` (`featured_ordering`),   KEY `hits` (`hits`),   KEY `created` (`created`),   KEY `language` (`language`),   FULLTEXT KEY `search` (`title`,`introtext`,`fulltext`,`extra_fields_search`,`image_caption`,`image_credits`,`video_caption`,`video_credits`,`metadesc`,`metakey`),   FULLTEXT KEY `title` (`title`) ) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_items`  VALUES ('1', 'Blandit primis cursus', 'blandit-primis-cursus', '12', '1', '<p>\nluctus pulvinar tincidunt sapien dolor conubia placerat libero aenean, vitae netus curae dolor tortor nulla gravida ullamcorper metus, suscipit ullamcorper aptent pellentesque eleifend ipsum sagittis. \nenim per litora dui platea tristique conubia placerat nunc, ullamcorper potenti aenean faucibus vulputate gravida enim, primis ultricies elementum phasellus leo fringilla nostra. \norci ac arcu sem faucibus eros pulvinar torquent, adipiscing donec faucibus bibendum elit malesuada condimentum himenaeos, faucibus arcu nam odio quisque interdum. \ntempor quis viverra orci accumsan cursus scelerisque dapibus fringilla torquent erat elementum, lacinia molestie vulputate potenti nec habitant luctus sed tortor aenean. \n</p>\n<p>\nfermentum elementum laoreet lobortis pretium, risus nisi mattis. \n</p>', '<p>\ninteger lobortis nam accumsan tempor lobortis rhoncus metus, eleifend aenean habitant massa eget vulputate in, urna pulvinar non vulputate luctus amet. \nhendrerit mollis aenean cursus mauris nec orci mollis maecenas vulputate quam sollicitudin, metus lectus varius pharetra libero in quisque ac aliquam lobortis, est rhoncus est pellentesque eget et faucibus praesent ante viverra. \nconubia ut leo netus quisque rutrum cursus donec, id lobortis volutpat ornare aptent eleifend, posuere risus rhoncus duis eu nec. \nvehicula dictumst aliquet porttitor mattis fringilla habitasse risus nunc metus erat auctor vulputate, vestibulum aenean tristique sagittis ad semper elementum nibh quisque praesent hendrerit, convallis pharetra proin lacinia diam at mattis euismod nam gravida convallis. \n</p>\n<p>\namet torquent habitant commodo mauris dapibus duis feugiat quam curabitur aliquam adipiscing congue dolor faucibus, rutrum luctus velit mollis nisl aptent tempor justo nullam ullamcorper ac integer. \nrutrum molestie nisi vel inceptos taciti varius adipiscing tortor fringilla, fames aenean senectus semper auctor donec neque posuere pharetra mauris, aenean vulputate cras habitasse tempor amet eros blandit. \nhac fermentum sagittis fames nunc habitant sit fames curabitur eleifend, ac eros urna lacus augue pulvinar nisi in gravida, at molestie nec proin semper aptent blandit eros. \ndonec enim aptent habitant a fusce sapien semper fringilla ullamcorper quam ligula aenean, sociosqu proin varius pretium phasellus sed hendrerit elit adipiscing a blandit. \n</p>\n<p>\netiam congue vivamus torquent dictumst vestibulum quisque netus tortor cursus rutrum sit, nec condimentum fames lacinia conubia in enim quis habitant justo, rhoncus feugiat gravida sodales lobortis in dictumst curabitur ut nibh. \npotenti rhoncus cursus elit class mi turpis, praesent gravida tortor condimentum libero. \nluctus aliquet volutpat bibendum id fames ante himenaeos aptent, pharetra lacus taciti accumsan dictum auctor nisi, ut netus ullamcorper est orci phasellus inceptos. \nerat etiam sollicitudin platea accumsan consectetur pretium suscipit nam senectus, diam conubia eu aliquet quam suscipit rutrum nunc, sit justo porta id sem egestas amet varius. \n</p>\n<p>\nper dolor consectetur neque blandit per aliquam posuere luctus, cursus faucibus sit vitae nisl adipiscing. \nmauris magna sodales amet phasellus purus ad, mollis ut consectetur urna sollicitudin sed leo, aenean senectus cursus etiam viverra. \neu cubilia amet laoreet tincidunt nunc, fames erat est fames molestie, faucibus lorem aliquet adipiscing. \neros amet hac curabitur quisque ut et nisi non adipiscing, augue et dapibus praesent tellus tristique rutrum consectetur senectus cursus, scelerisque habitasse posuere egestas accumsan aenean fermentum aliquam. \nsed aliquam sodales scelerisque phasellus ultrices, blandit fringilla vestibulum curabitur nunc dolor, consequat fames ultricies diam. \n</p>', '{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-07-26 09:15:53', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:15:53', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', 'Tortor lacinia nibh lacus torquent elit ', 'Generated by FillItUp', 'Egestas quam luctus vivamus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('2', 'Euismod massa maecenas odio', 'euismod-massa-maecenas-odio', '16', '1', '<p>interdum dui imperdiet lacus et tempus sem quam rhoncus lorem vestibulum, ad integer accumsan nostra tortor aliquet vestibulum hendrerit lacinia luctus duis, ipsum habitant fringilla pretium eros augue non donec torquent. euismod metus conubia donec morbi tortor metus ipsum in eget congue dolor id lorem, vestibulum purus egestas cras sollicitudin cubilia sed elit sagittis fusce nisi cursus odio mattis, lacinia fames posuere aptent nisi metus pellentesque turpis himenaeos mi velit aliquet. pretium ultricies torquent hac facilisis velit ad venenatis, sociosqu ad purus quisque purus quisque tellus dictum, id augue ullamcorper mattis duis tempus.</p>\r\n<p>metus gravida rhoncus purus adipiscing, nec velit.</p>\r\n', '\r\n<p>habitasse taciti curae at mattis dolor curae pretium metus himenaeos, sem adipiscing sit mattis morbi iaculis dictumst gravida sapien, fringilla velit molestie accumsan commodo massa auctor dictum. sagittis suspendisse augue ut tempor pretium imperdiet est, neque elit suspendisse sodales diam lobortis nunc potenti, aenean dolor pretium ante tincidunt cursus. inceptos scelerisque vestibulum accumsan purus imperdiet congue tempus habitasse nibh quisque donec ante non turpis, ultricies proin habitant morbi tellus euismod eu pulvinar nullam nisi netus ipsum. inceptos faucibus egestas placerat fringilla urna elit augue molestie id ac lacus quisque, pharetra iaculis tristique ante urna auctor sollicitudin ac suspendisse aliquam.</p>\r\n<p>rhoncus turpis vel fermentum netus per diam ullamcorper conubia ultrices est proin, ad congue conubia torquent porta lectus odio posuere iaculis platea, ultrices pharetra luctus curae turpis quisque lectus consectetur nullam nec. senectus placerat justo aliquam donec sollicitudin congue class at scelerisque interdum porta convallis vivamus vulputate neque turpis, aliquam auctor ligula curae accumsan lorem fames mollis etiam nisi condimentum erat quisque habitasse eleifend. suscipit auctor convallis et primis ligula quis venenatis netus lobortis, dapibus magna vel aenean massa urna fusce. phasellus nisl volutpat dictum euismod pellentesque augue, elementum tempor dictumst ligula.</p>\r\n<p>at vehicula pretium senectus donec sit nullam euismod, etiam sit nullam hendrerit in id nisi, eget vestibulum pulvinar feugiat curabitur himenaeos augue, nisl condimentum nulla sapien lacinia tortor. donec volutpat nec porta blandit massa lobortis rhoncus aptent interdum, lectus cursus phasellus aptent odio congue dolor dictumst eleifend in, mattis metus massa condimentum posuere in feugiat vitae. curae maecenas fermentum fusce odio donec urna cursus augue tempor nisi vivamus mauris aliquet tincidunt, conubia senectus at pulvinar blandit aenean dictum venenatis consequat scelerisque curae imperdiet. himenaeos scelerisque diam vestibulum lacinia eleifend nec diam sodales, leo nulla potenti habitasse ultricies suscipit primis lacinia, aliquam mollis magna ante aenean varius nisl.</p>\r\n<p>gravida ut mollis dapibus proin vehicula fringilla neque metus non maecenas nunc, egestas lorem conubia inceptos cursus fusce turpis scelerisque nibh. augue et euismod sem nulla quam cras iaculis nunc justo, curae urna tellus arcu vitae etiam luctus. lobortis nisi habitant aenean est suspendisse nec et, erat ornare litora odio ante vivamus curae maecenas, primis pellentesque torquent himenaeos quis lectus. sapien eleifend consectetur viverra amet scelerisque etiam taciti proin inceptos habitant nunc venenatis lobortis suscipit consequat vel, molestie maecenas sit pretium suscipit conubia imperdiet placerat gravida nullam ipsum nisi tincidunt ultrices taciti.</p>\r\n<p>purus interdum blandit felis dolor dapibus, mauris congue dolor sem.</p>', '{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}', '', '[]', '', '2013-07-26 09:15:57', '36', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:17:42', '34', '2013-07-26 09:15:57', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', 'Tortor curabitur quisque ullamcorper ', 'Generated by FillItUp', 'Orci magna neque integer neque nunc ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('69', 'Client 2', 'client-2', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:43:54', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:44:05', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('70', 'Client 3', 'client-3', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:14', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:44:25', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('4', 'Nunc torquent lorem vehicula dictumst ipsum', 'nunc-torquent-lorem-vehicula-dictumst-ipsum', '17', '1', '<p>\nnon venenatis vel fames non donec odio, praesent sagittis feugiat consequat facilisis id, vestibulum etiam aenean tristique aenean. \ntorquent venenatis eu viverra aptent quisque ac tellus eleifend, aptent orci aptent curabitur varius lacinia euismod dapibus cubilia, torquent enim aenean tempor duis habitasse id. \netiam id phasellus in nostra laoreet urna curae ultricies aenean, tempus fusce dictum varius litora eu platea. \ntorquent leo himenaeos ut ligula nam enim laoreet, neque facilisis cras lectus nibh curabitur. \nac et aenean taciti fames congue potenti habitant iaculis laoreet, cubilia vulputate odio donec congue dolor ipsum ligula, curabitur id nisl mauris morbi ut cras donec. \n</p>', '<p>\nnisi libero duis integer commodo nulla ultrices, torquent sagittis viverra quisque fusce, nunc rhoncus aptent aenean magna. \nvel praesent risus orci curabitur justo luctus maecenas aliquet erat duis, sociosqu lectus non massa commodo taciti litora ipsum rhoncus vel, donec per rutrum non quam pulvinar rhoncus id cubilia. \nduis bibendum placerat imperdiet erat gravida lacus curabitur eleifend vivamus, malesuada porta augue fermentum lobortis tempus magna venenatis, urna per vulputate quisque nisi vitae elit lacus. \nante congue eros lorem taciti consectetur pharetra non torquent egestas, imperdiet fusce adipiscing ornare nibh vestibulum enim fames, lorem quam porta tristique vulputate quam a massa. \n</p>\n<p>\nneque netus iaculis sed est dictumst scelerisque molestie varius senectus at, egestas quisque est bibendum posuere laoreet fusce leo fusce malesuada urna, integer dapibus torquent neque tempus pulvinar laoreet gravida pretium. \nrhoncus sit vitae luctus morbi congue porttitor enim consectetur proin vulputate, congue himenaeos erat etiam fames etiam sagittis mattis dapibus, vestibulum etiam curabitur sociosqu interdum class cras molestie rutrum. \ncondimentum proin netus iaculis vivamus velit mauris ut, porta senectus urna phasellus nostra pellentesque suspendisse et, ut est quisque erat aliquam class. \nvarius facilisis euismod sed urna malesuada senectus sodales quisque vestibulum vehicula velit, turpis molestie pharetra luctus ipsum non tristique varius nec sociosqu, nisi sodales eleifend suspendisse pellentesque per cubilia maecenas litora ultrices. \n</p>\n<p>\nvenenatis interdum sodales facilisis aliquam feugiat morbi turpis pharetra vehicula, bibendum aenean libero cubilia placerat primis nostra leo nulla nisi, feugiat nullam ut magna habitasse nisl aenean vitae. \nerat vitae libero fringilla vivamus euismod quisque curabitur, tincidunt consequat at eu faucibus habitasse. \nneque nibh orci eget metus aenean himenaeos dui nullam leo, pharetra est tristique facilisis ultricies aenean praesent senectus vivamus, porta luctus mollis cras hac condimentum ad conubia. \ninteger himenaeos semper a dictum gravida diam urna malesuada, scelerisque netus et vivamus torquent at aenean tristique non, curabitur vivamus eget neque eu massa vitae. \n</p>\n<p>\nid semper quis cubilia eros orci pretium lectus netus varius sagittis posuere donec malesuada, ipsum vivamus tortor class lacinia quisque porta at molestie est nullam. \nlacinia ornare interdum id morbi primis malesuada conubia sapien adipiscing, diam scelerisque enim neque purus pretium sagittis. \ncongue metus felis volutpat mattis scelerisque taciti nam, eros neque hac interdum turpis auctor porttitor in, facilisis inceptos lobortis in enim ultrices. \nphasellus pharetra neque dapibus mollis sodales phasellus purus nisl arcu quisque, phasellus taciti potenti tellus potenti rutrum nam maecenas mauris, mollis laoreet quisque risus cubilia senectus libero neque imperdiet. \n</p>', '{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-07-26 09:16:05', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:16:05', '0000-00-00 00:00:00', '0', '1', '10', '0', '0', 'Posuere orci commodo ', 'Generated by FillItUp', 'A fames phasellus rutrum nibh lobortis ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('71', 'Client 4', 'client-4', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:14', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:44:35', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('72', 'Client 5', 'client-5', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:45', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:44:58', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('73', 'Client 6', 'client-6', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:45', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:45:10', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('6', 'Inceptos primis consectetur pretium dapibus', 'inceptos-primis-consectetur-pretium-dapibus', '2', '1', '<p>netus egestas aenean erat scelerisque curabitur lectus rutrum in dictum posuere sociosqu, cubilia in placerat iaculis consectetur varius inceptos fusce phasellus curabitur sollicitudin, fames ullamcorper et senectus habitasse lacus mauris litora blandit accumsan. massa blandit suspendisse rutrum ullamcorper ultricies porttitor et fringilla dui, pellentesque duis convallis sodales condimentum quisque nam porttitor nibh, non amet velit lectus nam pellentesque sollicitudin luctus. id nullam ut arcu praesent rhoncus torquent, vehicula felis duis porta purus sed bibendum, elementum tristique cubilia malesuada porttitor. cursus leo tellus risus ornare est vestibulum et, augue suscipit cursus aenean varius aenean senectus, etiam eu litora dapibus cursus mollis.</p>\r\n', '\r\n<p>pellentesque fringilla proin blandit accumsan rutrum mauris nec vulputate rutrum ullamcorper, erat pellentesque facilisis sem justo ante etiam justo. lobortis habitasse aptent potenti curabitur netus quam fames lectus nisl, phasellus lorem lobortis odio sem euismod sagittis urna, pellentesque per turpis per fermentum consequat eleifend quam. lacus ultrices condimentum tempor cursus rutrum eleifend velit etiam ornare curae potenti, aliquet placerat laoreet ultrices curae gravida accumsan ut litora. adipiscing vehicula sit et eleifend dui taciti ullamcorper aliquet condimentum, ac aenean vivamus ad platea magna sagittis iaculis ut, nullam sit tincidunt diam sed molestie erat taciti.</p>\r\n<p>torquent sed est litora fusce duis consectetur dui inceptos, nam nisi leo proin ultricies varius conubia proin porta, at condimentum rutrum non sed condimentum augue. volutpat convallis nunc inceptos ultricies fermentum ultrices molestie pellentesque varius dictumst condimentum eros, ornare potenti accumsan pretium dictum turpis inceptos mollis tellus proin habitant tristique, suscipit etiam rhoncus mollis ante eu phasellus congue tristique aptent feugiat. non felis justo ante augue hendrerit vulputate condimentum class ornare fames, torquent senectus magna tempus egestas cubilia euismod viverra interdum, primis purus ante luctus habitant dictumst vel risus ornare.</p>\r\n<p>ligula hendrerit egestas nam sollicitudin facilisis donec inceptos et ad faucibus, cras convallis tristique felis nullam placerat malesuada consequat elementum malesuada id, metus massa sagittis habitasse varius torquent sagittis blandit gravida. iaculis maecenas hac diam interdum netus arcu consequat est neque blandit venenatis hendrerit vitae in venenatis, porttitor sagittis praesent sociosqu lectus interdum ad malesuada nisi fringilla sodales pharetra felis. nullam donec elit nam risus ante volutpat, suscipit sollicitudin per lacinia tortor, condimentum lacinia nisi dolor integer. posuere lacinia gravida habitant sapien id vivamus class nulla, pharetra etiam conubia nunc gravida ac facilisis imperdiet, vivamus conubia mattis etiam turpis posuere est.</p>\r\n<p>elementum morbi pharetra lacinia taciti cras cursus quisque maecenas ornare, nulla ornare hendrerit enim ultrices hendrerit curae turpis, eros leo tellus nibh sodales fermentum nunc posuere. rutrum odio metus ipsum tempor consectetur, inceptos viverra fusce elementum, habitasse odio aenean tortor. mollis luctus quam ullamcorper augue sagittis lobortis nulla consequat nam litora, risus iaculis mollis sed libero feugiat sodales nullam odio ut, etiam elementum neque facilisis magna rutrum pharetra litora tempus. porta duis mi lacinia molestie etiam vehicula quis, nulla aliquam integer placerat elit rutrum mi luctus, lorem litora nostra sollicitudin suspendisse himenaeos.</p>\r\n<p>ante urna dolor magna ullamcorper eros donec semper, tortor mollis ante vestibulum rutrum volutpat, laoreet hendrerit luctus potenti gravida aenean. mi primis orci, habitasse.</p>', '{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}', '{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}', '[{\"id\":\"3\",\"value\":\"John Doe\"}]', 'John Doe ', '2013-07-26 09:16:13', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 09:44:09', '34', '2013-07-26 09:16:13', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Nisl metus ad phasellus vivamus ante ', 'Generated by FillItUp', 'Commodo sagittis molestie suspendisse volutpat ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('7', 'Tempor accumsan ac accumsan', 'tempor-accumsan-ac-accumsan', '17', '1', '<p>\ninceptos porttitor ligula lectus tempor per mollis morbi a iaculis, ligula suscipit et pharetra sagittis lacus adipiscing ligula varius, bibendum purus aliquet fermentum consequat molestie elementum morbi. \nfeugiat litora ut duis suspendisse porttitor nisl elit suscipit ipsum elit adipiscing eu, venenatis malesuada ullamcorper inceptos dictumst cubilia ac iaculis eleifend consectetur non. \nmi varius malesuada eu ad nam quam iaculis morbi nunc non donec litora rutrum, volutpat ornare etiam facilisis pulvinar placerat fames nostra pharetra aenean per iaculis. \neuismod gravida congue dolor commodo eget semper amet feugiat, nostra aliquam commodo justo gravida habitant augue, commodo ultricies eros sociosqu hendrerit porta volutpat. \n</p>', '<p>\nvelit cubilia ipsum justo laoreet aptent ut feugiat sodales aptent, dictumst in tincidunt ac gravida eleifend fusce ipsum sociosqu, eget sapien posuere imperdiet egestas vel neque netus. \nposuere donec etiam lorem vitae in nulla curabitur, dui quam consequat porta ipsum lorem, commodo egestas dui odio curae eros. \nhabitant vehicula vitae accumsan aenean luctus tellus hac mollis, duis lacinia est commodo per porttitor ut ad lorem, aliquet bibendum hendrerit curae risus metus est. \nphasellus nibh sit torquent eros erat maecenas ipsum senectus sed suspendisse ante, elementum cras taciti sociosqu fermentum feugiat porta nibh pretium. \n</p>\n<p>\ninteger maecenas gravida etiam purus ornare aliquam taciti non vivamus, euismod dictumst hendrerit eu ornare cras luctus adipiscing, fusce pharetra laoreet venenatis tortor nibh aptent interdum. \nadipiscing tincidunt hendrerit curabitur primis eros nec cubilia fermentum, auctor accumsan elit donec tortor volutpat hendrerit interdum, vel est blandit id primis ad cubilia potenti, sed pharetra primis eleifend sociosqu augue elit. \nsapien aptent aliquam neque mauris risus bibendum dictumst vivamus tristique fermentum blandit hac donec turpis cursus pretium dapibus, egestas semper quam congue lectus justo id augue ullamcorper gravida dapibus lobortis rhoncus blandit congue. \n</p>\n<p>\ndolor rhoncus eleifend nunc dolor tempor nam turpis commodo condimentum donec rutrum sem adipiscing, ut duis odio leo massa iaculis commodo hac sem habitant volutpat. \nipsum dui felis ac auctor platea varius lectus quisque lacus justo nibh, eget luctus porttitor dictum conubia donec ac metus curabitur hac, convallis cras cubilia convallis orci aptent porttitor platea a sociosqu. \nblandit suspendisse non interdum aenean cubilia risus tellus convallis bibendum varius, vivamus donec aliquam donec amet magna curabitur tincidunt proin mattis, viverra magna sit potenti luctus mauris nullam fames maecenas. \nbibendum tortor nunc aliquam sed eros venenatis sed mollis et, nibh lacinia elementum sodales viverra est augue semper neque tempus, est aliquet class placerat conubia quisque pharetra aptent. \n</p>\n<p>\njusto nec dictum erat aenean curabitur feugiat conubia sapien aptent, curabitur luctus ante dictumst ut quis gravida libero augue nisi, placerat quisque vivamus habitasse donec torquent lobortis platea. \nphasellus commodo per massa facilisis consectetur morbi curabitur consectetur, proin cursus quisque metus quisque arcu eu sem arcu, sociosqu venenatis litora sit quam mollis orci. \ntristique rhoncus fusce ultricies commodo elementum hendrerit sollicitudin non urna, consequat lobortis torquent aenean mollis fringilla etiam sociosqu blandit tortor, torquent massa sit inceptos netus aliquam ut morbi. \nlectus tellus libero donec aliquam, fusce torquent semper. \n</p>\n<p>\nmassa etiam neque nunc justo, lectus donec adipiscing quisque, erat ante aptent. \n</p>', '{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}', NULL, '', '2013-07-26 09:21:55', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:21:55', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Neque suscipit ligula lorem consectetur at ', 'Generated by FillItUp', 'Habitasse neque libero tincidunt sociosqu ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('8', 'Torquent orci himenaeos aenean volutpat euismod', 'torquent-orci-himenaeos-aenean-volutpat-euismod', '16', '1', '<p>velit vel metus enim nam nunc consectetur augue pretium netus, habitasse augue feugiat enim ac tristique ligula arcu laoreet, class id ultricies aliquam in aenean hac aliquam. convallis egestas metus duis accumsan praesent odio rutrum dapibus curabitur, mollis varius molestie nostra fusce justo porttitor condimentum aliquam ad, massa porttitor fusce id lacus metus massa fermentum. tellus elit justo euismod viverra ut interdum, etiam dictumst eleifend hac vel dui taciti, platea vehicula aenean dictumst interdum. sagittis feugiat hendrerit etiam tristique libero pulvinar aptent duis dictumst, curae fermentum sed nisl ipsum lectus egestas euismod, torquent neque venenatis gravida ultricies orci tincidunt libero.</p>\r\n', '\r\n<p>sit nullam eros donec bibendum amet elit eu viverra eu curae quisque ut pharetra, curabitur molestie varius bibendum ut vel posuere ultricies cras mauris iaculis. metus semper amet vivamus urna cubilia eget elit tempor etiam condimentum lobortis felis, mauris faucibus pharetra habitant cras semper iaculis diam pretium libero. sociosqu lobortis ac convallis donec semper mollis sed dictum faucibus, rhoncus sit est aenean convallis sollicitudin in. tortor donec facilisis lacus curabitur dui nisi feugiat mollis, litora gravida turpis ornare interdum sodales facilisis class, litora morbi ultrices urna velit aenean phasellus.</p>\r\n<p>vestibulum non interdum ipsum augue velit donec varius neque sagittis, ante taciti euismod vitae dictum fermentum diam tristique maecenas fusce, donec sapien eleifend varius sem convallis per ullamcorper. euismod fusce inceptos a ac habitant morbi vel, sociosqu lacinia praesent cursus odio cubilia ligula, aenean pretium vulputate justo nisi suscipit. consectetur pulvinar taciti pulvinar nullam sagittis imperdiet litora proin, tortor accumsan vivamus ut pharetra volutpat taciti, platea gravida enim tortor commodo in senectus. non leo aliquam integer arcu placerat aenean vestibulum nisi pretium, maecenas ornare placerat justo convallis sociosqu faucibus condimentum volutpat pellentesque, molestie feugiat sit velit morbi pulvinar aenean tempus.</p>\r\n<p>pulvinar ac vulputate ut proin nisi etiam turpis sed ultricies eleifend, primis morbi justo ante volutpat justo malesuada hac netus, ornare luctus vehicula aptent orci pulvinar cubilia elit tortor. sociosqu lacus massa odio cursus vestibulum litora gravida ornare, imperdiet lorem tempor placerat id ultricies accumsan, elementum suspendisse aenean velit luctus et non. ligula eros vehicula ornare convallis curabitur ornare integer odio id metus praesent, rutrum dapibus mollis turpis blandit sagittis erat lacus justo blandit, donec semper est a velit habitasse donec ante etiam eget. imperdiet vel vehicula feugiat gravida mattis aliquam urna, ultrices lorem elit pulvinar accumsan inceptos, tellus vivamus condimentum habitant nostra aliquam.</p>\r\n<p>aenean orci eros morbi malesuada etiam phasellus vestibulum est, venenatis dictum donec netus ornare semper velit, ante dictum potenti justo erat varius hendrerit. ut lobortis curabitur venenatis at nullam libero scelerisque nec, viverra suscipit semper urna eget quis turpis placerat massa, etiam non aliquam bibendum vestibulum mauris facilisis. placerat proin nibh ornare adipiscing per urna morbi, tempus massa in primis integer fringilla nostra porttitor, blandit tempor sed per vulputate amet. sit pulvinar proin curae posuere hac mauris adipiscing habitant vestibulum hac consectetur integer curabitur ac nam, viverra fusce cursus et suscipit ultricies tempus ornare curabitur aptent senectus rhoncus id.</p>\r\n<p>ante interdum sit cubilia, quisque diam, vivamus neque.</p>', '{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}', '', '[]', '', '2013-07-26 09:21:59', '36', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:17:23', '34', '2013-07-26 09:21:59', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Scelerisque amet euismod cursus vulputate ', 'Generated by FillItUp', 'Eget class cursus lacinia odio faucibus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('9', 'Blandit pellentesque accumsan felis taciti', 'blandit-pellentesque-accumsan-felis-taciti', '17', '1', '<p>\nadipiscing congue metus vestibulum cras lacus sociosqu aenean congue dolor, non odio ut convallis etiam ante malesuada aliquet est, tortor mattis nostra congue vehicula ultrices commodo potenti. \nneque faucibus quis ad at cursus cras eu quam consequat, nec arcu aenean cubilia eleifend fusce ac conubia, maecenas facilisis potenti donec pulvinar nisl ipsum venenatis. \nsuspendisse ad semper mauris volutpat consequat velit condimentum nulla class, metus phasellus vehicula neque inceptos quis faucibus libero lobortis faucibus, quisque nulla suspendisse morbi commodo cubilia a mollis. \nlibero quis tempus habitant augue platea massa metus accumsan placerat rhoncus, aenean urna massa donec commodo eros erat hac. \n</p>', '<p>\nsuscipit sodales mauris aenean consectetur ultricies mauris cras urna, condimentum vel mattis porttitor cubilia nisl rhoncus erat, inceptos at sed praesent etiam senectus cursus. \nac duis aliquet varius rhoncus vel donec etiam in, posuere nunc lacus venenatis donec molestie pretium cubilia quis, vehicula integer ultrices consequat suscipit porta ante. \nvarius eros sed convallis etiam sociosqu arcu pellentesque himenaeos eget, nibh gravida donec nec augue venenatis senectus vivamus, duis enim neque morbi auctor gravida ipsum etiam. \nsapien blandit senectus et sed ullamcorper sed neque justo etiam porttitor, lobortis curae turpis sapien semper at ut justo in, magna suspendisse luctus in tempor nunc viverra donec turpis. \n</p>\n<p>\nrhoncus lectus enim convallis justo dui luctus turpis faucibus et, nisi himenaeos nunc pulvinar sem quis nulla consequat, pulvinar libero quisque pretium accumsan per tempor sed. \nvelit mattis nibh cras porta nulla phasellus, malesuada egestas sapien hac leo ultrices, aliquet nulla pharetra nullam senectus. \nvel fringilla hac dapibus cursus ultricies arcu risus id litora, malesuada torquent porta dictumst vehicula a diam eros pellentesque habitant, phasellus vehicula ac dictum eleifend mauris aliquet eros. \nrutrum metus hendrerit cursus nisi ullamcorper vehicula bibendum accumsan, orci etiam tempus felis erat eget laoreet fames, sapien tortor tempor quisque pretium consectetur lorem eleifend, commodo phasellus tellus curabitur dictumst dolor et. \n</p>\n<p>\nsit pulvinar augue accumsan egestas leo mauris sed, elementum tortor cras dictum vivamus quisque enim, dapibus curabitur mi volutpat etiam metus. \neleifend imperdiet iaculis nostra cubilia gravida conubia potenti donec, velit hendrerit phasellus urna dapibus platea laoreet praesent, ornare eros blandit id per vulputate lobortis. \nvehicula sapien est rutrum consequat odio rutrum, ante tellus tempor ipsum lobortis faucibus varius, inceptos habitasse etiam placerat aenean. \nfaucibus nisl auctor inceptos laoreet congue luctus risus arcu duis, urna sodales sagittis dictum aliquam feugiat enim lobortis mattis inceptos, vestibulum fermentum erat arcu purus mauris consequat pellentesque. \n</p>\n<p>\nnibh suscipit semper sapien maecenas pulvinar taciti imperdiet nibh, donec augue ullamcorper mattis senectus torquent elit vivamus faucibus, aliquam laoreet primis dolor viverra hac litora. \nmauris habitant ornare accumsan pretium nostra habitasse aenean tristique imperdiet, fermentum pretium sollicitudin et porta ultrices convallis aliquam, potenti lobortis odio massa sed ut ultricies odio. \neuismod urna ornare cursus maecenas taciti neque aptent, vestibulum lacinia malesuada class molestie cras aptent, risus feugiat nulla interdum class id. \nligula nunc aliquam bibendum ut sem netus at, sodales sapien congue mauris ac potenti morbi, posuere vitae lacinia rhoncus egestas per. \n</p>\n<p>\nfeugiat phasellus malesuada cursus sagittis, quis porttitor. \n</p>', '{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-07-26 09:22:02', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:22:02', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Proin accumsan phasellus varius ', 'Generated by FillItUp', 'Ipsum fusce ultricies nulla molestie a ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('74', 'Client 7', 'client-7', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:45', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:45:23', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('75', 'Client 8', 'client-8', '24', '1', '', '', NULL, NULL, '[{\"id\":\"1\",\"value\":\"\\/images\\/clients\\/jQueryLogo.jpg\"},{\"id\":\"2\",\"value\":[\"jQuery\",\"http:\\/\\/jquery.com\\/\",\"new\"]}]', ' jQuery http://jquery.com/  ', '2013-07-26 13:44:45', '34', '', '0', '0000-00-00 00:00:00', '2013-07-26 13:45:39', '34', '2013-07-26 13:42:47', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('11', 'Conubia vulputate rhoncus', 'conubia-vulputate-rhoncus', '16', '1', '<p>consequat auctor rutrum porttitor congue pharetra diam sociosqu, porta egestas habitant varius arcu sodales, aliquam donec tristique cursus dictumst per. nullam donec dictum nec senectus netus platea ut justo, eleifend vitae tempus litora nisl nisi praesent, netus mauris praesent sapien libero etiam suspendisse. felis ornare quis leo pretium ut semper cursus, porttitor ac nulla iaculis donec lacus, litora dui integer mattis pretium diam. orci curae viverra lobortis fusce augue aliquet nullam sem nunc sed, curabitur ornare primis congue tempus metus integer mi sed consequat suscipit, pulvinar cras torquent pretium blandit mauris commodo libero turpis.</p>\r\n<p>venenatis dictumst at nulla, sapien ultricies.</p>\r\n', '\r\n<p>venenatis eu non feugiat justo semper rhoncus posuere aptent convallis, rhoncus neque vehicula aliquam fermentum diam id dapibus cubilia quisque, duis vehicula neque platea integer cras iaculis ipsum. maecenas a suscipit cursus vulputate eu sed habitant ad venenatis justo at, fusce fermentum ipsum tellus imperdiet inceptos felis donec et dapibus consequat, maecenas curabitur leo conubia quis posuere hac diam fringilla turpis. fringilla cubilia id litora non diam vehicula lacus egestas sit, porttitor tellus luctus litora sodales sit eros etiam platea, nisi vehicula sit aenean platea suscipit platea rutrum.</p>\r\n<p>pulvinar at lacinia litora curabitur nam tellus quam mollis habitant lacus lectus, metus augue vivamus habitant hendrerit justo dolor pharetra erat adipiscing neque, luctus quam etiam platea sodales iaculis feugiat lectus nulla vulputate. consequat aliquam fusce orci hac cras dictumst vel, risus metus elementum class habitasse accumsan tellus blandit, taciti posuere platea imperdiet accumsan scelerisque. aptent cras rhoncus leo cursus phasellus suspendisse neque volutpat primis, egestas himenaeos phasellus aliquam ante sociosqu sed diam condimentum gravida, taciti felis blandit proin pretium posuere accumsan luctus. accumsan lacus urna per sodales dolor quisque consectetur scelerisque morbi, vel nisi nam bibendum condimentum curabitur erat per tempus habitasse, magna platea senectus aliquam mattis congue fermentum lobortis.</p>\r\n<p>class consectetur vel cras mattis iaculis pharetra a sem scelerisque, duis ante etiam aenean nibh conubia metus nunc ante vitae, commodo tristique ultrices fermentum duis accumsan commodo proin. netus lorem ultrices augue tortor donec aenean euismod, duis orci at tempus tincidunt class turpis, mauris massa senectus curabitur eleifend scelerisque. habitant nullam cras at turpis quisque lacinia lobortis posuere vitae justo, tellus per justo fames sodales quam blandit purus pretium, magna pellentesque felis imperdiet nibh etiam curabitur phasellus vitae. tortor placerat etiam consectetur varius posuere etiam malesuada non luctus, pulvinar nulla mollis himenaeos faucibus sit aliquam id, mauris bibendum lorem facilisis laoreet tellus semper sollicitudin.</p>\r\n<p>donec orci pellentesque gravida aliquet litora arcu mi, tempus elit turpis non nam ultrices etiam, malesuada molestie ultrices faucibus dapibus eu. fringilla semper suscipit dapibus euismod nullam pellentesque himenaeos id consectetur porttitor etiam, curabitur placerat iaculis odio lectus habitasse ligula curabitur nunc vestibulum. magna praesent donec nostra enim duis ut commodo litora habitant aliquam, diam proin porta et cras dolor in leo senectus, torquent tempor congue duis massa amet vehicula consectetur laoreet. ligula viverra varius pulvinar lectus mollis tincidunt fermentum metus aptent enim consectetur auctor hendrerit, est cras primis eros porttitor vivamus aliquam pulvinar convallis viverra phasellus.</p>', '{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}', '', '[]', '', '2013-07-26 09:22:10', '35', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:17:56', '34', '2013-07-26 09:22:10', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Aenean nibh vehicula ', 'Generated by FillItUp', 'Per adipiscing elit senectus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('13', 'Aliquam adipiscing aenean', 'aliquam-adipiscing-aenean', '16', '1', '<p>metus laoreet lobortis porttitor primis amet magna tempor est iaculis venenatis dapibus neque eros, nisl aliquet enim porttitor rutrum quisque augue dolor venenatis congue purus pellentesque. felis phasellus placerat dapibus inceptos id fringilla nec ad venenatis nulla habitant fermentum, imperdiet conubia tempus curabitur leo accumsan massa netus integer cursus. nunc vestibulum quisque nostra imperdiet sagittis pretium sagittis eu magna urna inceptos mi taciti, est elit fringilla pulvinar dui urna facilisis massa leo elementum class. eget luctus mi torquent massa ante scelerisque dui diam adipiscing, interdum dictum sit enim orci lectus suspendisse senectus, sapien vivamus cubilia sollicitudin tincidunt dictumst in class.</p>\r\n', '\r\n<p>lacinia urna aenean et nunc habitant vel tortor ultrices sollicitudin mauris euismod, nam vitae ornare nam lobortis eu porta tortor fusce et. fames nullam convallis placerat quisque nullam integer amet facilisis adipiscing facilisis, tempus pulvinar mauris primis lectus ornare facilisis dui mattis, nisl non porta mollis suscipit scelerisque non auctor feugiat. sollicitudin venenatis dui lacinia nullam quisque dui leo eu, mi senectus placerat nisl vestibulum varius pulvinar etiam, metus est nibh cursus neque posuere feugiat. porttitor et eros ultricies molestie fermentum non porta neque himenaeos, fusce porta odio morbi quam elementum suspendisse aptent est mollis, sociosqu adipiscing lobortis ut ullamcorper aenean duis metus.</p>\r\n<p>id posuere tristique morbi etiam nec egestas mollis primis fames, sodales at mi sodales euismod habitant cursus nam dictum, faucibus lectus sit nibh platea aenean ornare luctus. semper ante etiam vel sollicitudin tempor erat quis curabitur, condimentum enim euismod justo fusce a feugiat vehicula mi, nec risus praesent sagittis amet nostra lectus. aptent donec rutrum accumsan vitae nunc egestas sollicitudin curae, aenean eu porttitor posuere venenatis sapien aenean, ad orci potenti tristique quis cubilia metus. duis tempus fermentum turpis lacus vestibulum vivamus massa auctor aenean ligula, himenaeos nam blandit rhoncus egestas scelerisque ut consectetur orci donec, consectetur luctus velit luctus sed nullam facilisis a inceptos.</p>\r\n<p>hac libero sit pharetra pellentesque quisque sodales rhoncus quisque ad, ac maecenas quisque leo convallis urna posuere nunc risus nulla, habitasse ipsum potenti commodo pulvinar class varius felis. tortor hendrerit donec vitae massa volutpat nisl orci iaculis lacinia sem, tempus nec torquent convallis tempus elit odio sit ultrices, porttitor primis interdum ut habitant lobortis praesent fringilla conubia. duis rutrum nam elit et eu pellentesque placerat, aenean quam ut aptent dictum ultricies phasellus, sagittis donec imperdiet nostra risus dictumst. ad ante himenaeos leo aliquam erat molestie himenaeos vestibulum auctor semper posuere accumsan, dictum volutpat vulputate ullamcorper aenean mollis vulputate inceptos tristique sem vestibulum.</p>\r\n<p>consequat integer aenean viverra est ultricies, pretium turpis mi adipiscing erat lacinia, malesuada hac nostra semper. laoreet etiam scelerisque nec sem rutrum tempus commodo, consequat arcu dui litora metus eleifend, accumsan primis mauris auctor duis nisl. vel in donec viverra in eu ligula, viverra sodales suscipit elit suspendisse, nibh felis tempor pellentesque dolor. eget nostra sollicitudin donec habitasse inceptos aenean varius, quam gravida elementum arcu per inceptos eros inceptos, tempor platea molestie justo purus lobortis. fusce non potenti lobortis sem est, curabitur fringilla dui morbi etiam, turpis ut euismod nisi.</p>', '{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}', '', '[]', '', '2013-07-26 09:22:18', '36', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:18:34', '34', '2013-07-26 09:22:18', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Sociosqu taciti leo nisl ', 'Generated by FillItUp', 'Inceptos torquent conubia ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('14', 'Vitae feugiat vehicula', 'vitae-feugiat-vehicula', '19', '1', '<p>vivamus leo nisl mattis felis ligula aenean proin placerat, iaculis condimentum rutrum aenean ligula praesent odio aenean per, mollis taciti placerat etiam aliquet lacinia cursus. nibh pharetra pellentesque ante ut habitant per diam adipiscing, aenean semper orci nostra id fames placerat et neque, pellentesque suscipit elementum enim eu ut varius. ante quisque donec risus lobortis placerat pharetra integer primis, congue dolor sit quisque et nunc mi sagittis suspendisse, pretium venenatis aptent erat himenaeos aenean nibh. elementum enim vivamus mattis aliquam et tortor rhoncus augue, nisi felis condimentum conubia laoreet arcu phasellus lacus volutpat, aliquam dictumst sodales nisl ac sodales elit.</p>\r\n', '\r\n<p>a non tristique dapibus eros quisque lectus aptent risus at per, vulputate etiam sit egestas ante dui diam suscipit enim potenti donec, eget class interdum sollicitudin odio pretium torquent tellus nostra. nulla sapien purus habitant curabitur dictumst mattis metus amet litora ipsum platea aliquam molestie amet, pharetra phasellus euismod porta litora aliquam eu ullamcorper odio nec et rutrum. est cubilia aptent morbi tristique nam pharetra congue dictumst, hac elementum ligula quis luctus tempor suscipit nibh lorem, malesuada ut tempus dapibus molestie mi dui. donec et vestibulum adipiscing etiam fringilla ad platea tempor, sollicitudin morbi vehicula tempor venenatis ultrices aptent, nullam eros sem curabitur taciti lectus inceptos.</p>\r\n<p>cras ac ante congue odio scelerisque vehicula bibendum proin risus, laoreet posuere ipsum phasellus sem vitae malesuada posuere. facilisis consequat faucibus diam amet aliquam lacinia sociosqu dictum donec nec commodo in curae, elit class varius dolor metus est molestie auctor est adipiscing dictum. quisque nostra suspendisse congue placerat amet feugiat arcu sem phasellus, duis eros urna lobortis dictumst sagittis magna lobortis non, nam rhoncus metus etiam molestie consectetur non class. accumsan etiam curae hendrerit congue dolor molestie lobortis, duis pharetra ante laoreet orci lacus rutrum, netus at aliquam posuere proin rhoncus.</p>\r\n<p>ad elementum risus semper blandit iaculis primis donec odio nulla vehicula fermentum, ligula integer pulvinar tempor habitasse primis rhoncus torquent et. pretium fringilla tempus facilisis amet platea lorem, quisque purus nam ultrices erat vulputate curae, risus malesuada etiam leo proin. platea eros mattis aliquet mollis massa varius justo primis, bibendum tincidunt proin erat class molestie ullamcorper urna, vitae etiam hac habitasse feugiat metus nisi. lectus suscipit tincidunt vivamus vulputate aenean phasellus, tincidunt ipsum magna posuere senectus dictum magna, quisque suspendisse cubilia ut ad. himenaeos taciti hac placerat turpis leo commodo euismod porta, vehicula senectus nullam ullamcorper curabitur eleifend urna hac consectetur, etiam senectus sit conubia hendrerit tortor cubilia.</p>\r\n<p>pretium magna ut accumsan lacinia cras integer taciti, lacus ante ornare cubilia non netus, sapien volutpat curabitur non quis varius. lectus praesent augue id pharetra sollicitudin imperdiet nec nulla nostra, ultrices ligula dictumst tincidunt porta iaculis suscipit hendrerit, suspendisse donec hendrerit senectus justo curabitur ac pellentesque. duis potenti morbi neque a nulla feugiat ligula curabitur eu quam, nullam dictumst tincidunt tempus fermentum justo maecenas erat velit vulputate ante, cubilia inceptos urna class condimentum libero mollis vestibulum eu. elementum cursus nam eros nisi faucibus curabitur, amet placerat vel felis proin bibendum, commodo class quam pellentesque tempus.</p>', '{youtube}http://www.youtube.com/watch?v=saMhNUmPaJ4{/youtube}', '{gallery}http://www.flickr.com/photos/9255261@N07/sets/72157605611183371/with/4306905525/{/gallery}', '[]', '', '2013-07-26 09:22:22', '36', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:03:51', '34', '2013-07-26 09:22:22', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Metus risus quisque neque ', 'Generated by FillItUp', 'Accumsan proin aptent ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('18', 'Vehicula vel elementum blandit etiam elementum', 'vehicula-vel-elementum-blandit-etiam-elementum', '17', '1', '<p>\ncommodo vulputate eget fermentum at vel aenean, semper aenean ad sagittis elit et elementum, dictum lectus id torquent mollis. \nmolestie mi mollis tortor semper orci rutrum est et, tristique congue dolor feugiat mauris vehicula fusce, ornare erat vivamus quis suscipit eleifend volutpat. \nmollis aliquam amet lacinia vulputate maecenas nunc eget consequat fringilla, tellus potenti dictumst suspendisse aliquam nibh turpis sem ut velit, rutrum magna phasellus scelerisque vel sed praesent lorem. \nleo consectetur vulputate ut faucibus blandit nullam ultricies justo venenatis consequat, torquent hac integer donec varius rutrum ornare tempus et tincidunt, nulla nisi suspendisse condimentum mauris malesuada consectetur habitasse sapien. \n</p>', '<p>\nvolutpat integer nisl dolor quisque dolor curabitur iaculis fames, vulputate metus faucibus quis egestas viverra torquent sollicitudin, augue arcu neque eros vulputate turpis ipsum. \nad cubilia elementum adipiscing justo blandit pulvinar pharetra hac, in lacus iaculis blandit potenti morbi nisl nam fames, erat augue mollis curabitur donec pellentesque nullam. \nprimis placerat auctor taciti lectus lacinia eros ullamcorper nibh, pulvinar viverra aenean vitae viverra libero. \npurus vulputate ipsum ornare sodales at nisi praesent placerat quisque, hendrerit sodales proin et eleifend sed commodo luctus, molestie aptent tristique erat habitant a felis commodo. \n</p>\n<p>\nornare nostra eu tempus accumsan nunc velit egestas rhoncus integer, fusce duis malesuada ornare vulputate at nulla mi suspendisse, urna imperdiet vulputate egestas ultricies suscipit etiam elementum. \nplatea nullam fringilla netus augue vel libero elit dictum nisl sodales interdum habitant, curabitur himenaeos diam habitant sed praesent hac lorem tortor ligula quisque vehicula, potenti habitant cras potenti non faucibus sagittis donec dictum mi elit. \nturpis lorem elementum habitant senectus magna pulvinar eget nulla suspendisse faucibus consequat, aliquam sapien etiam sed cras sem nibh non lacus mauris sagittis, luctus dolor tincidunt a sagittis augue ante cras metus venenatis. \n</p>\n<p>\nporta dolor imperdiet convallis commodo sagittis vitae metus rhoncus himenaeos mattis mauris, aliquam purus est etiam at torquent aliquam diam est pellentesque purus nulla, sapien justo adipiscing eget class viverra tristique ultrices leo pulvinar. \nmolestie laoreet pellentesque semper turpis est dui euismod curae ad pulvinar, in lacinia tellus facilisis in et dolor tellus ultricies, quis orci potenti donec condimentum habitant interdum porttitor litora. \na quisque tempus netus amet euismod vel sapien rhoncus, arcu diam conubia odio tristique tincidunt vestibulum. \nid proin consectetur pulvinar viverra molestie sem aliquam purus vestibulum lectus sem, molestie lobortis iaculis auctor fames facilisis nostra non viverra mauris quis, ultricies nisi etiam taciti cubilia proin est etiam amet tristique. \n</p>\n<p>\nquis venenatis elit est curabitur augue porttitor urna nullam augue, maecenas mauris phasellus quisque egestas mi eu vitae tellus, est justo elit suspendisse ultricies eros cubilia phasellus. \nplacerat donec habitant vitae varius curabitur lacinia ad lorem, malesuada nam felis porttitor venenatis facilisis curabitur, ultricies tincidunt malesuada ante fusce nisl tincidunt. \ndonec a mauris porttitor et ac bibendum vulputate cursus porttitor fermentum himenaeos congue nec per aptent lectus, congue aenean rhoncus fringilla sit sagittis id fames pellentesque lacinia class maecenas est ante. \ndonec dui enim primis mauris primis duis mi, erat lobortis habitasse sapien nam sapien condimentum, praesent lobortis commodo mattis ultrices potenti. \n</p>', '{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}', NULL, '', '2013-07-26 09:22:40', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:22:40', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Dolor sapien diam aenean ', 'Generated by FillItUp', 'Placerat consequat nec sagittis nulla lacus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('19', 'Sed id sodales sit tellus', 'sed-id-sodales-sit-tellus', '12', '1', '<p>\ndolor dui curabitur urna molestie ipsum justo ornare etiam fermentum, auctor orci primis cubilia vivamus vehicula velit sagittis, at conubia habitant commodo convallis mattis ligula proin. \nquisque suscipit luctus accumsan suspendisse interdum himenaeos ornare cubilia congue, gravida commodo aenean lorem senectus est aliquam elit lobortis, ultrices facilisis dictumst egestas nostra semper varius sem. \ncommodo ante lorem massa quisque quis libero, aptent conubia eu duis hac tempus eros, augue condimentum leo consequat conubia. \nest amet duis elementum scelerisque dapibus etiam potenti etiam pharetra, arcu lectus enim habitasse phasellus est maecenas. \n</p>\n<p>\nfacilisis potenti rhoncus per torquent eleifend class, lacinia congue est dolor. \n</p>', '<p>\nullamcorper taciti at morbi consectetur at eleifend libero ultrices scelerisque, dui conubia lacus donec vulputate vestibulum potenti vivamus cubilia lobortis, habitant platea tincidunt metus ut mattis rutrum sed. \nipsum massa tincidunt vulputate diam lorem proin semper, lacinia morbi etiam ligula integer turpis luctus vulputate, pharetra vel tempor dictumst cras purus. \nurna porttitor morbi aenean scelerisque maecenas pharetra at enim suscipit dapibus vulputate dictumst laoreet pellentesque netus, nostra primis bibendum dictumst tempor interdum consectetur quisque enim suspendisse adipiscing lacinia ac ligula. \nmalesuada blandit tempus lacinia rutrum risus consequat velit condimentum, eu condimentum in lacus pharetra pulvinar faucibus eros potenti, neque odio quis tortor sapien molestie hendrerit. \n</p>\n<p>\ntortor enim platea himenaeos morbi dapibus vivamus, lorem praesent placerat senectus aenean cubilia, eget cras id ut lectus. \nmattis quisque quam euismod eu habitant mauris venenatis duis sociosqu, posuere fames eu ipsum nulla litora class tempor, quis facilisis venenatis dictumst amet placerat elementum taciti. \nporta elit pretium urna quisque sollicitudin rhoncus porta pharetra sodales lacus est faucibus turpis maecenas, eleifend mattis ante hac in potenti himenaeos ut nulla nisl proin amet. \npellentesque praesent malesuada proin fringilla convallis ac fames libero mauris, ornare quisque justo interdum porttitor etiam feugiat venenatis ut, odio ultricies cras diam morbi hendrerit non mauris. \n</p>\n<p>\ngravida habitant vulputate consectetur pulvinar potenti porttitor ipsum tortor scelerisque gravida lacus nulla, turpis odio fermentum et luctus per ligula ante ad augue. \ndictum pretium ultrices risus volutpat eu laoreet elementum hendrerit ut auctor erat nullam luctus, rutrum diam eros sit potenti tincidunt ipsum dictumst curae ullamcorper varius. \ncubilia sit pretium suscipit et primis justo dolor at, ligula conubia eleifend fermentum condimentum habitasse ac. \nprimis mattis elit pharetra velit consectetur vulputate nulla cras varius, elementum iaculis dictum inceptos augue aptent fringilla massa quam massa, lobortis dolor ad aenean arcu suspendisse risus inceptos. \n</p>\n<p>\nsodales ornare pharetra nam egestas sociosqu venenatis hac eleifend tempus, varius lectus cubilia vitae nullam fringilla duis. \nnullam quam lacus lectus cras gravida vivamus, egestas aptent convallis laoreet lorem, lacinia dolor interdum nullam nibh. \nlorem mollis ullamcorper luctus nisl class fusce velit malesuada tempor sociosqu justo, curabitur enim aenean duis conubia donec amet maecenas faucibus aliquet condimentum, at enim aenean ipsum phasellus pellentesque cubilia habitant nec potenti. \neleifend lacus per maecenas dui rutrum senectus augue rutrum, ornare auctor inceptos nisl eleifend ligula aenean diam, ultrices viverra orci erat curabitur conubia ultricies. \n</p>\n<p>\naugue venenatis rhoncus pretium velit etiam dictumst volutpat, metus sit lobortis praesent curae ligula. \n</p>', '{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}', '{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}', NULL, '', '2013-07-26 09:22:45', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:22:45', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Dictumst donec dictum porta ', 'Generated by FillItUp', 'Enim vehicula massa phasellus augue ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('22', 'Vivamus cubilia nam mi class faucibus', 'vivamus-cubilia-nam-mi-class-faucibus', '17', '1', '<p>\nnulla potenti consectetur odio est ultricies auctor phasellus, etiam eros porta ultrices eget egestas class, donec integer curabitur diam rutrum primis. \ncursus malesuada molestie fringilla phasellus cras aliquam, sodales nullam ad iaculis lobortis, ac auctor vestibulum aenean pretium. \ntaciti augue litora inceptos orci vivamus blandit vehicula, posuere per odio id mollis sollicitudin suspendisse, quis dictumst nisl vitae dui eros. \nenim vel litora potenti bibendum erat vehicula purus dictum, ac luctus etiam nam habitasse sed condimentum accumsan curabitur, tellus viverra vel rutrum vehicula odio vel. \nlobortis leo varius placerat adipiscing facilisis, adipiscing urna hendrerit luctus et non, scelerisque ipsum molestie varius. \n</p>', '<p>\nmalesuada class congue dolor convallis nostra tortor rhoncus nisl blandit facilisis ultricies rutrum litora sed, porta facilisis turpis velit fermentum sed mauris fringilla duis condimentum ultricies turpis vitae. \netiam ut ornare rutrum maecenas laoreet mauris justo suspendisse leo adipiscing inceptos, vel habitant posuere litora placerat consequat elit bibendum morbi quis, tristique consectetur aliquam pulvinar aenean torquent non malesuada proin interdum. \nsollicitudin iaculis dui placerat eget sollicitudin senectus commodo, venenatis ultricies dolor taciti pellentesque vulputate nunc, habitasse ad at aliquet placerat mollis. \npurus dictum inceptos arcu viverra aenean id dictum massa fermentum gravida mi, morbi feugiat vel sagittis congue risus commodo eros dictum. \n</p>\n<p>\ndictumst dolor convallis nam amet malesuada in posuere dapibus, luctus adipiscing vestibulum fermentum auctor sollicitudin fermentum aliquet felis, donec volutpat taciti feugiat sit pharetra iaculis. \nvehicula lectus metus hendrerit scelerisque potenti, enim class semper quisque fusce accumsan, est facilisis egestas platea. \naliquam massa est eget rhoncus maecenas aenean sociosqu purus, dictum arcu interdum amet eleifend lacinia ipsum taciti laoreet, sollicitudin pharetra molestie donec odio rhoncus justo. \nmauris curabitur nostra vel quisque ornare donec orci lorem maecenas platea, faucibus ullamcorper euismod inceptos erat curae accumsan pulvinar proin turpis fames, aptent donec iaculis malesuada convallis laoreet nisl ultrices neque. \n</p>\n<p>\nenim interdum elit ornare dictumst taciti libero quisque maecenas nunc, non taciti dictumst interdum porttitor lorem quam egestas, nec venenatis nulla aptent dictumst scelerisque tincidunt viverra. \namet magna vulputate inceptos platea fusce risus, ut convallis aenean interdum per sociosqu litora, sagittis tristique lorem placerat lacinia. \nvehicula est ut habitasse a placerat posuere luctus integer habitasse pretium rutrum odio, tempus venenatis eget nulla enim purus viverra phasellus accumsan vel fames ante, viverra velit dolor suspendisse facilisis curae morbi habitant nisl scelerisque auctor. \ndolor per proin est primis aliquam nullam nec porttitor, tempor quis nullam dapibus condimentum consectetur vel sollicitudin varius, odio pharetra mauris velit orci netus dolor. \n</p>\n<p>\nsuscipit quis lacinia taciti quis aliquam dapibus auctor fames quis tellus, rutrum massa ad odio neque aenean donec volutpat sed id, duis gravida elit volutpat massa aliquam rutrum ullamcorper diam. \narcu leo pretium leo vulputate quisque neque posuere massa elementum faucibus, blandit himenaeos congue dolor nibh aenean mi venenatis curae ligula, aenean magna nisl nullam morbi accumsan integer varius sapien. \naptent accumsan mi pulvinar enim et velit risus primis, cursus mauris aliquam dui litora erat potenti in, aliquam venenatis mattis felis nisl mollis imperdiet. \nsapien lorem eu eleifend est quis sem, diam pellentesque dui primis. \n</p>', '{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-07-26 09:22:58', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:22:58', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', 'Mi at elementum habitasse dictumst neque ', 'Generated by FillItUp', 'Ullamcorper justo tristique ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('23', 'Non adipiscing inceptos', 'non-adipiscing-inceptos', '13', '1', '<p>urna rhoncus sociosqu vitae est et taciti tortor tempus hendrerit praesent at rhoncus pulvinar, gravida sapien senectus cras libero quis feugiat venenatis ultricies nullam viverra. commodo leo etiam ante augue malesuada lacinia auctor viverra convallis, quam a ornare non lobortis etiam lacinia. pharetra felis aliquam lacinia faucibus condimentum, scelerisque fringilla vel lectus in, vulputate nostra arcu hendrerit. sed nunc risus diam etiam cursus eleifend non leo, donec lobortis etiam nulla enim vulputate. purus maecenas consequat aptent massa congue dolor cubilia eu aenean, urna viverra risus sem ligula a egestas condimentum lacinia netus, in quis dolor lectus duis potenti interdum praesent.</p>\r\n', '\r\n<p>ipsum aliquet proin dictum morbi ac euismod quam diam eget aenean dictumst, tortor non vivamus feugiat pellentesque ullamcorper adipiscing aliquam rhoncus aptent tempus, interdum euismod platea dui vivamus aliquam vitae adipiscing laoreet litora. elementum eget vestibulum fringilla nec lobortis cubilia himenaeos cursus, nec fringilla quisque metus curae quis posuere, sapien facilisis potenti fermentum dapibus mauris sociosqu. posuere vivamus quisque risus aenean eget feugiat, aliquet habitant et quam odio lectus diam, per neque taciti cras dapibus. sagittis adipiscing volutpat laoreet aenean dui id, dictumst sodales ullamcorper aptent dapibus sagittis eget, hac nullam vivamus amet leo.</p>\r\n<p>etiam tellus cursus sit commodo pulvinar convallis orci conubia aptent, augue placerat leo curabitur dictum dapibus non adipiscing, cubilia nostra quam consequat accumsan mattis quam feugiat. sem fermentum a vitae at sodales etiam non turpis ante primis vestibulum per nam nisl, facilisis quisque viverra venenatis non suscipit turpis at vehicula ut luctus conubia. velit massa fames leo nam tristique a commodo fringilla, leo ut litora cursus suscipit pellentesque gravida suspendisse, turpis scelerisque viverra varius curabitur sem velit. hac gravida sem elit orci maecenas augue magna platea felis dapibus, aliquam urna curabitur etiam nam massa iaculis interdum lectus, per dui pretium ultrices ac diam luctus aliquet vestibulum.</p>\r\n<p>semper ad libero ultrices arcu tincidunt fringilla sem hendrerit, quisque aliquam non erat donec malesuada quisque, aliquet ligula vivamus porttitor posuere viverra ullamcorper. justo curabitur mi amet libero id tempus condimentum convallis blandit tellus odio feugiat, ligula tempor consequat a convallis ad sapien praesent senectus in. mauris egestas dictum ac integer varius amet libero malesuada aliquam, nec proin eu et non etiam eros tristique, luctus facilisis etiam feugiat velit hac sem magna. enim non augue inceptos primis ante neque est odio, fusce tortor cubilia consequat lacus elementum ac aenean ipsum, id etiam leo vulputate eget semper primis.</p>\r\n<p>mauris litora lorem interdum elementum diam fringilla metus malesuada cursus lacinia convallis, mollis hendrerit sem odio et conubia nam duis facilisis ut, molestie commodo ipsum luctus purus aenean duis semper tincidunt sed. mattis scelerisque eros sollicitudin aliquet primis ac convallis felis aptent, vel iaculis praesent nam auctor tellus nunc nibh, enim vivamus in at tincidunt rutrum ut bibendum. imperdiet litora justo habitasse curabitur enim neque quis adipiscing suspendisse, ultricies porta aliquet sit aptent rutrum ac curabitur euismod, semper netus risus eget turpis senectus dapibus hac. libero semper vestibulum et nisl interdum morbi, ut etiam vitae dapibus vulputate facilisis, ante sapien eget per hendrerit.</p>', '{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}', '{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}', '[]', '', '2013-07-26 09:23:03', '35', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:12:26', '34', '2013-07-26 09:23:03', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', 'Integer taciti metus netus ', 'Generated by FillItUp', 'Iaculis maecenas ac pharetra leo euismod ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('25', 'Interdum vitae class malesuada ac', 'interdum-vitae-class-malesuada-ac', '13', '1', '<p>risus ultrices platea duis platea, phasellus pellentesque quisque magna convallis, nibh egestas suscipit. maecenas quisque ornare eros iaculis leo quam malesuada risus iaculis libero imperdiet etiam, dictum nunc aenean id justo magna mollis nam ipsum non rhoncus. sollicitudin dolor pellentesque lacus ut sodales risus libero morbi pellentesque diam auctor varius, torquent lectus eget iaculis id hendrerit quisque sapien fusce senectus tristique, consequat aliquam rhoncus ligula lacus sollicitudin erat nulla vestibulum quam scelerisque. vestibulum posuere vivamus hendrerit turpis ante dapibus, sapien vivamus donec bibendum consequat vitae quisque, tellus porttitor rhoncus himenaeos et.</p>\r\n<p>fusce leo tristique mattis est erat, etiam laoreet mi.</p>\r\n', '\r\n<p>gravida lacinia sagittis posuere condimentum neque curabitur dictumst dolor, sapien fames magna potenti platea auctor tempor, facilisis lorem quisque aenean placerat tellus eros. feugiat quisque tortor cursus lorem enim auctor habitant, nec quisque a suspendisse turpis eleifend bibendum taciti, fusce morbi ut bibendum suspendisse curae. primis posuere scelerisque class porttitor at vulputate enim purus mollis turpis, sit potenti tempor enim primis bibendum libero leo gravida, tellus turpis a nec et duis purus curabitur ad. morbi gravida habitant orci eu, vel rhoncus enim tellus, sapien lorem curabitur. tellus rhoncus ullamcorper ut nec tortor himenaeos aliquam condimentum sem ultricies, bibendum aenean suspendisse erat nunc sollicitudin ullamcorper leo bibendum, torquent donec iaculis felis torquent pellentesque aenean interdum fermentum.</p>\r\n<p>urna laoreet ultricies proin curae commodo viverra dapibus, lectus massa litora class duis nam varius, etiam pulvinar ligula iaculis dictum dictumst. blandit fermentum dui nec et eget elementum morbi, mattis convallis sollicitudin nostra tempus aenean sollicitudin neque, volutpat non ipsum aliquet ullamcorper varius. dapibus orci viverra quam aenean cursus mattis torquent molestie id bibendum, eleifend consequat sapien lacus libero imperdiet diam molestie. urna nulla semper himenaeos quisque eros dolor condimentum nulla aliquam quisque rhoncus turpis convallis, vitae in venenatis diam maecenas donec curae nostra semper lacinia tristique porta.</p>\r\n<p>sit non vehicula tempus id enim conubia himenaeos lobortis maecenas, semper iaculis sollicitudin laoreet in ut egestas neque primis, sapien vivamus dapibus luctus odio in ac turpis. luctus ligula ullamcorper porttitor pharetra consequat tincidunt facilisis torquent odio, lorem aliquam neque ad fermentum mattis nam himenaeos posuere, porta varius habitasse imperdiet metus commodo tellus felis. purus tempus urna arcu inceptos egestas mattis augue taciti blandit, nisi nostra sem nisl potenti sodales consectetur ac consectetur, nisl accumsan fringilla eget elit ante urna curae. maecenas tincidunt ut ac metus sit, egestas dapibus vel porta id nisi, gravida augue nec at.</p>\r\n<p>lobortis proin lobortis eros id quam maecenas ornare vel suscipit, mollis rhoncus at bibendum ligula magna amet dolor, vel molestie praesent elit libero conubia nisi consectetur. interdum fames semper blandit convallis morbi pretium gravida magna aptent a, non pulvinar venenatis dolor semper ut nibh tempor interdum quam vel, quisque gravida curae torquent tellus id diam luctus non. nibh ullamcorper viverra aenean eros congue consectetur posuere magna nibh ad, aenean turpis tortor dolor ac mattis fusce nibh inceptos, tristique vulputate vestibulum ultricies commodo etiam commodo volutpat fermentum. neque porttitor euismod convallis quisque aliquet, luctus malesuada amet duis, ornare ultricies ad nullam.</p>', '{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}', '{gallery}http://www.flickr.com/photos/cottonblue/sets/72157604378940701/with/3207798737/{/gallery}', '[]', '', '2013-07-26 09:23:11', '35', '', '0', '0000-00-00 00:00:00', '2013-07-26 10:11:04', '34', '2013-07-26 09:23:11', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', 'Donec conubia quisque orci nostra ', 'Generated by FillItUp', 'Nostra cubilia ornare aenean ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('27', 'Rhoncus nec donec diam', 'rhoncus-nec-donec-diam', '15', '1', '<p>\nfelis odio turpis massa sit ad himenaeos porttitor, augue aliquet cras per vitae in hac, ut praesent donec convallis ligula neque. \nrutrum at nullam orci pulvinar ac suspendisse accumsan et commodo non, sed nullam aenean in amet nostra porttitor est cras, lectus commodo pharetra eget ad turpis donec libero in. \nporta cubilia fames ante praesent fermentum ullamcorper tempus quam, massa vivamus sollicitudin non dolor malesuada cubilia tellus, pulvinar cras risus vel vitae ut cubilia. \ndiam cras sagittis mi porttitor eleifend ante ultrices ut eros, quis hac platea viverra sapien eleifend feugiat vel, nisi primis amet sollicitudin himenaeos facilisis vel ultricies. \n</p>', '<p>\nturpis dui urna volutpat id suspendisse inceptos nisl lorem iaculis, auctor habitant rhoncus hac dictum malesuada suscipit magna adipiscing, eu odio nibh congue cubilia amet urna diam. \nmaecenas laoreet nostra nec conubia torquent dui, ut accumsan sapien duis. \ntempor lectus sem auctor conubia suscipit a placerat sagittis, accumsan sociosqu commodo eleifend accumsan iaculis metus torquent, tincidunt himenaeos cursus malesuada litora justo tristique. \nconsectetur tortor laoreet habitasse malesuada auctor ante senectus ac consequat, nisi ut ultrices ut aenean adipiscing dictum ullamcorper, cursus ornare hendrerit fermentum interdum aenean nam lobortis. \n</p>\n<p>\nenim eu lobortis massa dolor potenti vitae porttitor ligula laoreet etiam quisque, vehicula ut mattis neque donec laoreet porttitor mi dolor convallis accumsan aenean, semper conubia risus turpis magna primis nostra bibendum libero etiam. \nhabitant accumsan sollicitudin curae nostra nisi augue pulvinar blandit quam, rhoncus nisl consequat cursus fermentum conubia nam metus, augue ante taciti nunc platea vitae imperdiet volutpat. \nvel conubia ipsum pellentesque mollis integer posuere semper nostra lacinia maecenas diam fringilla adipiscing fusce curabitur, orci arcu eleifend pharetra ipsum senectus congue bibendum congue scelerisque vestibulum turpis aliquet. \n</p>\n<p>\npurus fermentum inceptos orci vel et tempor elementum feugiat, odio senectus consequat lorem posuere hendrerit inceptos cursus, scelerisque fusce libero scelerisque nisi aliquam mollis. \nsapien eleifend phasellus aliquet odio ligula porttitor ad, malesuada sem consectetur curabitur lorem velit, primis etiam ut donec vivamus ut. \ndictum venenatis fames sagittis dapibus adipiscing aliquet praesent lacinia etiam, adipiscing sodales nullam ultrices ut consequat convallis libero sagittis, nullam habitant curae vel sociosqu facilisis bibendum turpis. \nenim a aenean neque facilisis bibendum neque gravida leo cubilia velit varius, nulla at cras dolor donec a sollicitudin lectus nulla leo, congue aliquet faucibus donec metus dui inceptos morbi turpis vel. \n</p>\n<p>\naliquet proin quis habitant velit commodo consectetur amet malesuada etiam, convallis blandit in donec vulputate taciti nostra bibendum, neque leo ut nisi tincidunt nibh porta tempus. \ncursus donec magna sit sapien egestas sociosqu sapien, duis netus risus aliquam mauris ante sapien integer, amet tellus pretium auctor arcu magna. \nnulla vitae pharetra nisl tristique risus rhoncus senectus amet rutrum condimentum, urna felis non aenean magna cursus proin lacus quam pharetra dapibus, enim ac donec ullamcorper leo tortor consequat etiam praesent. \nest at integer primis adipiscing habitant consectetur sagittis dictumst, class blandit mollis phasellus suspendisse justo odio. \n</p>\n<p>\nlectus feugiat velit porttitor himenaeos metus vel risus tempus, at metus purus dapibus tellus potenti himenaeos a posuere, cursus a primis consequat maecenas vehicula amet. \n</p>', '{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}', '{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}', NULL, '', '2013-07-26 09:23:21', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:23:21', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', 'Vestibulum eleifend curabitur ', 'Generated by FillItUp', 'Habitasse class netus molestie mattis risus ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*'), ('29', 'Hendrerit vehicula aenean taciti', 'hendrerit-vehicula-aenean-taciti', '17', '1', '<p>\nut auctor fermentum mollis facilisis nisi sit tempus nec, cras habitant aliquam massa aliquam porttitor fusce hendrerit porttitor, nisi donec ligula praesent suscipit sapien proin. \npretium curabitur vivamus sociosqu molestie vestibulum varius himenaeos ultricies consectetur consequat, aliquet iaculis eros quam donec eu luctus libero ut accumsan class, aliquam et arcu sollicitudin potenti facilisis odio aenean pulvinar. \npharetra ipsum tellus laoreet quisque eget commodo mollis, condimentum inceptos curabitur aptent netus fringilla maecenas, gravida primis ultrices ad id himenaeos. \nplacerat ipsum facilisis elementum fringilla neque elementum tellus lacinia, condimentum et varius fringilla habitant posuere bibendum, felis est felis torquent eros aliquam egestas. \n</p>', '<p>\neleifend sociosqu ac justo laoreet senectus aliquam integer nisi, pulvinar curabitur a quisque fusce ante dictum, odio varius himenaeos habitasse est senectus sodales. \ndolor augue nisl a curabitur at egestas ullamcorper rhoncus, est taciti euismod fames id viverra diam ornare tellus, libero molestie porttitor maecenas nisl nunc porta. \nelit imperdiet ut non orci donec vulputate metus, augue himenaeos accumsan habitant tincidunt nisl. \nnibh dui ipsum porttitor lorem vivamus nisl nulla habitant hendrerit nibh, aenean posuere aliquam adipiscing sapien risus a convallis eros viverra, porttitor dictum aliquam facilisis leo aliquam rhoncus nisl porta. \n</p>\n<p>\nvel quisque interdum habitasse cubilia tincidunt placerat quis, etiam accumsan libero rhoncus tempor vitae massa litora, curabitur hendrerit vehicula suscipit congue suscipit. \na vehicula class fames lectus accumsan donec vel aptent himenaeos odio ut accumsan ut, facilisis magna nam netus per auctor blandit neque imperdiet a euismod. \nrutrum adipiscing rhoncus odio senectus sed nec phasellus eu venenatis curabitur lectus molestie, tristique imperdiet tortor dictumst fringilla potenti donec conubia gravida risus quisque, tortor ullamcorper ultrices sit rhoncus viverra primis rutrum leo vestibulum proin. \nluctus diam sollicitudin volutpat turpis hendrerit primis non lorem sem dui eros, at rutrum sit pulvinar tristique diam elit taciti per ligula. \n</p>\n<p>\negestas cubilia diam tincidunt curabitur donec curae ornare condimentum placerat ut sociosqu ut, mauris quam massa eleifend velit primis donec pulvinar eu scelerisque potenti, inceptos class accumsan cubilia quam turpis pretium praesent non faucibus aenean. \nduis taciti sed varius eget etiam risus urna malesuada ligula rhoncus, netus primis pharetra sodales quisque ut inceptos ipsum nam, potenti amet quisque adipiscing dui duis eleifend eu hendrerit. \nadipiscing consequat egestas porttitor in a hac facilisis ad, risus iaculis euismod libero posuere iaculis hendrerit, iaculis bibendum aliquam mattis dictumst volutpat convallis. \neleifend convallis orci habitant donec vehicula turpis vehicula auctor tortor urna nunc, torquent netus suscipit etiam mattis vestibulum placerat ad habitant. \n</p>\n<p>\naptent vel curae quisque praesent netus torquent suscipit pretium eros, nullam sit nibh scelerisque donec malesuada metus nec hac, fusce elit suscipit eleifend est ad ante aptent. \nut fusce lectus donec lobortis fermentum suscipit sem dapibus viverra erat, aptent suspendisse urna est mauris himenaeos conubia mollis quisque, lacus augue ut eleifend nam pharetra sociosqu semper curabitur. \netiam vitae eleifend donec pellentesque purus imperdiet nisi, risus fermentum fames aliquam pellentesque sed adipiscing auctor, metus libero sapien posuere integer metus. \nvarius commodo fringilla sed nibh volutpat torquent aenean a nec, quisque donec sollicitudin mollis feugiat augue nisl quis. \n</p>', '{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}', '{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}', NULL, '', '2013-07-26 09:23:30', '34', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2013-07-26 09:23:30', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', 'Quisque elementum varius ', 'Generated by FillItUp', 'Platea turpis ipsum tellus auctor viverra ', 'Generated by FillItUp', '0', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', '', '', '', '*');
