CREATE TABLE `#__admintools_acl` (   `user_id` bigint(20) unsigned NOT NULL,   `permissions` mediumtext,   PRIMARY KEY (`user_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_adminiplist` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_badwords` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `word` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_customperms` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `path` varchar(255) NOT NULL,   `perms` varchar(4) DEFAULT '0644',   UNIQUE KEY `id` (`id`),   KEY `path` (`path`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_filescache` (   `admintools_filescache_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `filedate` int(11) NOT NULL DEFAULT '0',   `filesize` int(11) NOT NULL DEFAULT '0',   `data` blob,   `checksum` varchar(32) NOT NULL DEFAULT '',   PRIMARY KEY (`admintools_filescache_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipautoban` (   `ip` varchar(255) NOT NULL,   `reason` varchar(255) DEFAULT 'other',   `until` datetime DEFAULT NULL,   UNIQUE KEY `ip` (`ip`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipblock` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_log` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `logdate` datetime NOT NULL,   `ip` varchar(40) DEFAULT NULL,   `url` varchar(255) DEFAULT NULL,   `reason` varchar(255) DEFAULT 'other',   `extradata` mediumtext,   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_profiles`  VALUES ('1', 'Default PHP Change Scanner Profile', '', '');
CREATE TABLE `#__admintools_redirects` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `source` varchar(255) DEFAULT NULL,   `dest` varchar(255) DEFAULT NULL,   `ordering` bigint(20) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '1',   `keepurlparams` tinyint(1) NOT NULL DEFAULT '1',   UNIQUE KEY `id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scanalerts` (   `admintools_scanalert_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `scan_id` bigint(20) NOT NULL DEFAULT '0',   `diff` mediumtext,   `threat_score` int(11) NOT NULL DEFAULT '0',   `acknowledged` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`admintools_scanalert_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scans` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_storage` (   `key` varchar(255) NOT NULL,   `value` longtext NOT NULL,   PRIMARY KEY (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_storage`  VALUES ('cparams', '{\"latestjversion\":\"{\\\"installed\\\":{\\\"version\\\":\\\"3.1.1\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18323\\\\\\/80368\\\\\\/Joomla_3.1.1-Stable-Full_Package.zip\\\"},\\\"current\\\":{\\\"version\\\":\\\"3.1.1\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18323\\\\\\/80368\\\\\\/Joomla_3.1.1-Stable-Full_Package.zip\\\"},\\\"sts\\\":{\\\"version\\\":\\\"3.1.1\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18323\\\\\\/80368\\\\\\/Joomla_3.1.1-Stable-Full_Package.zip\\\"},\\\"lts\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"}}\",\"lastjupdatecheck\":1374588693}'), ('fixperms_stack', '{\"folders\":[],\"files\":[],\"total\":0,\"done\":0}');
CREATE TABLE `#__admintools_wafexceptions` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `option` varchar(255) DEFAULT NULL,   `view` varchar(255) DEFAULT NULL,   `query` varchar(255) DEFAULT NULL,   PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_profiles`  VALUES ('1', 'Default Backup Profile', '###AES128###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', 'a:1:{s:5:\"files\";a:1:{s:10:\"[SITEROOT]\";a:3:{i:0;s:17:\"configuration.php\";i:1;s:10:\".gitignore\";i:2;s:8:\".project\";}}}');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_stats`  VALUES ('4', 'Backup taken on Friday, 26 July 2013 17:06', '', '2013-07-26 17:06:08', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'numodusversus_demosite_j3x_20130726.zip', '/home/demos/domains/demo.nuevvo.com/public_html/commercial/j31/numodusversus/administrator/components/com_akeeba/backup/numodusversus_demosite_j3x_20130726.zip', '0', 'backend', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext,   PRIMARY KEY (`tag`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8;
INSERT INTO `#__assets`  VALUES ('1', '0', '0', '229', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'), ('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '17', '140', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '141', '142', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '143', '144', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'), ('11', '1', '145', '146', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '147', '148', '1', 'com_login', 'com_login', '{}'), ('13', '1', '149', '150', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '151', '152', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '153', '154', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '155', '156', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '157', '158', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '159', '160', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '161', '166', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '167', '168', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('21', '1', '169', '170', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '171', '172', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '173', '174', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '175', '178', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('25', '1', '179', '184', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('26', '1', '185', '186', '1', 'com_wrapper', 'com_wrapper', '{}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '14', '15', '2', 'com_contact.category.4', 'nuModusVersus', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '162', '163', '2', 'com_newsfeeds.category.5', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('31', '25', '180', '181', '2', 'com_weblinks.category.6', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '24', '176', '177', '1', 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('33', '1', '187', '188', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('34', '1', '189', '190', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('35', '1', '191', '192', '1', 'com_tags', 'com_tags', '{\"core.admin\":[],\"core.manage\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('36', '1', '193', '194', '1', 'com_k2', 'com_k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('37', '1', '195', '196', '1', 'com_admintools', 'admintools', '{}'), ('38', '1', '197', '198', '1', 'com_akeeba', 'akeeba', '{}'), ('44', '8', '18', '37', '2', 'com_content.category.10', 'Quotes', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('46', '142', '79', '90', '3', 'com_content.category.12', 'Dance', ''), ('47', '141', '39', '46', '3', 'com_content.category.13', 'Design', ''), ('48', '141', '47', '60', '3', 'com_content.category.14', 'Fashion', ''), ('51', '142', '91', '104', '3', 'com_content.category.17', 'Movies', ''), ('52', '142', '105', '120', '3', 'com_content.category.18', 'Music', ''), ('54', '142', '121', '128', '3', 'com_content.category.20', 'Night Out', ''), ('57', '141', '61', '68', '3', 'com_content.category.23', 'Style', ''), ('58', '141', '69', '76', '3', 'com_content.category.24', 'Technology', ''), ('59', '142', '129', '138', '3', 'com_content.category.25', 'Theater', ''), ('62', '58', '70', '71', '4', 'com_content.article.2', 'Sodales tortor primis dui ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('64', '44', '19', '20', '3', 'com_content.article.4', 'Eros amet cursus augue inceptos ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('65', '59', '130', '131', '4', 'com_content.article.5', 'Fringilla commodo tellus malesuada ', ''), ('67', '44', '21', '22', '3', 'com_content.article.7', 'Libero proin venenatis maecenas lorem ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('68', '57', '62', '63', '4', 'com_content.article.8', 'Pellentesque vel tincidunt taciti maecenas ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('70', '44', '23', '24', '3', 'com_content.article.10', 'Consectetur sapien pharetra aptent nibh ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('71', '52', '106', '107', '4', 'com_content.article.11', 'Curabitur platea eu sem nisl nec ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('72', '46', '80', '81', '4', 'com_content.article.12', 'Auctor volutpat conubia ', ''), ('73', '52', '108', '109', '4', 'com_content.article.13', 'Vulputate egestas tincidunt ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('74', '58', '72', '73', '4', 'com_content.article.14', 'Cras torquent ac ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('76', '59', '132', '133', '4', 'com_content.article.16', 'Interdum blandit pretium cursus purus integer ', ''), ('77', '59', '134', '135', '4', 'com_content.article.17', 'Erat aliquet facilisis curae eget ', ''), ('78', '48', '48', '49', '4', 'com_content.article.18', 'Arcu risus hac auctor sit nibh ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('79', '57', '64', '65', '4', 'com_content.article.19', 'Phasellus ante donec ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('80', '48', '50', '51', '4', 'com_content.article.20', 'Nunc consequat maecenas libero lacinia ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('81', '52', '110', '111', '4', 'com_content.article.21', 'Malesuada enim primis erat senectus ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('83', '52', '112', '113', '4', 'com_content.article.23', 'Amet viverra pretium ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('84', '47', '40', '41', '4', 'com_content.article.24', 'Erat molestie enim ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('85', '48', '52', '53', '4', 'com_content.article.25', 'Iaculis ultricies hac aliquam ante ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('87', '47', '42', '43', '4', 'com_content.article.27', 'Integer a in feugiat quisque ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('91', '44', '25', '26', '3', 'com_content.article.31', 'Tellus quisque pretium nisi eros ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('92', '47', '44', '45', '4', 'com_content.article.32', 'Sagittis viverra auctor consectetur ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('95', '52', '114', '115', '4', 'com_content.article.35', 'Turpis metus volutpat suscipit dapibus imperdiet ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('97', '46', '82', '83', '4', 'com_content.article.37', 'Primis ullamcorper lectus ', ''), ('98', '54', '122', '123', '4', 'com_content.article.38', 'Risus etiam fringilla sociosqu ', ''), ('99', '58', '74', '75', '4', 'com_content.article.39', 'Mi mollis varius leo etiam donec ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('100', '44', '27', '28', '3', 'com_content.article.40', 'Ac ut venenatis posuere venenatis ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('101', '48', '54', '55', '4', 'com_content.article.41', 'Ante volutpat vitae condimentum malesuada ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('105', '57', '66', '67', '4', 'com_content.article.45', 'Cubilia neque egestas vitae ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('107', '46', '84', '85', '4', 'com_content.article.47', 'Habitant ultricies himenaeos pellentesque ', ''), ('112', '51', '92', '93', '4', 'com_content.article.52', 'Aenean elit semper faucibus cubilia fames ', ''), ('114', '51', '94', '95', '4', 'com_content.article.54', 'Pellentesque magna enim donec ', ''), ('116', '44', '29', '30', '3', 'com_content.article.56', 'Erat placerat porttitor sodales ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('117', '59', '136', '137', '4', 'com_content.article.57', 'Hendrerit consequat imperdiet tempus ', ''), ('118', '44', '31', '32', '3', 'com_content.article.58', 'Praesent cubilia posuere netus ornare ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('119', '52', '116', '117', '4', 'com_content.article.59', 'Etiam non purus ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('120', '48', '56', '57', '4', 'com_content.article.60', 'Imperdiet massa est luctus ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('122', '51', '96', '97', '4', 'com_content.article.62', 'Aliquam curae faucibus ', ''), ('123', '46', '86', '87', '4', 'com_content.article.63', 'Habitasse id justo cubilia commodo consectetur ', ''), ('124', '54', '124', '125', '4', 'com_content.article.64', 'Sit praesent curabitur lorem pharetra hendrerit ', ''), ('127', '54', '126', '127', '4', 'com_content.article.67', 'Ultricies torquent fermentum ', ''), ('129', '44', '33', '34', '3', 'com_content.article.69', 'Netus congue platea iaculis ut ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('130', '52', '118', '119', '4', 'com_content.article.70', 'Ut sagittis torquent felis ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('131', '44', '35', '36', '3', 'com_content.article.71', 'Malesuada venenatis blandit iaculis tellus ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('132', '48', '58', '59', '4', 'com_content.article.72', 'Platea id donec phasellus malesuada nullam ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('133', '46', '88', '89', '4', 'com_content.article.73', 'Vel netus odio molestie justo ', ''), ('135', '51', '98', '99', '4', 'com_content.article.75', 'Vivamus donec laoreet congue donec nisl ', ''), ('138', '51', '100', '101', '4', 'com_content.article.78', 'Nostra dui auctor ', ''), ('140', '51', '102', '103', '4', 'com_content.article.80', 'Vitae cursus scelerisque senectus ', ''), ('141', '8', '38', '77', '2', 'com_content.category.27', 'Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('142', '8', '78', '139', '2', 'com_content.category.28', 'Joomla! Categories', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('143', '19', '164', '165', '2', 'com_newsfeeds.category.29', 'Useful Feeds', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('144', '25', '182', '183', '2', 'com_weblinks.category.30', 'Useful Links', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('145', '1', '199', '200', '1', '#__ucm_content.1', '#__ucm_content.1', '[]'), ('146', '1', '201', '202', '1', '#__ucm_content.2', '#__ucm_content.2', '[]'), ('147', '1', '203', '204', '1', '#__ucm_content.3', '#__ucm_content.3', '[]'), ('148', '1', '205', '206', '1', '#__ucm_content.4', '#__ucm_content.4', '[]'), ('149', '1', '207', '208', '1', '#__ucm_content.5', '#__ucm_content.5', '[]'), ('150', '1', '209', '210', '1', '#__ucm_content.6', '#__ucm_content.6', '[]'), ('151', '1', '211', '212', '1', '#__ucm_content.7', '#__ucm_content.7', '[]'), ('152', '1', '213', '214', '1', '#__ucm_content.8', '#__ucm_content.8', '[]'), ('154', '1', '215', '216', '1', '#__ucm_content.10', '#__ucm_content.10', '[]'), ('155', '1', '217', '218', '1', '#__ucm_content.11', '#__ucm_content.11', '[]'), ('158', '1', '219', '220', '1', '#__ucm_content.14', '#__ucm_content.14', '[]'), ('159', '1', '221', '222', '1', '#__ucm_content.15', '#__ucm_content.15', '[]'), ('160', '1', '223', '224', '1', '#__ucm_content.16', '#__ucm_content.16', '[]'), ('161', '1', '225', '226', '1', '#__ucm_content.17', '#__ucm_content.17', '[]'), ('162', '1', '227', '228', '1', '#__ucm_content.18', '#__ucm_content.18', '[]');
CREATE TABLE `#__associations` (   `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner_clients` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `contact` varchar(255) NOT NULL DEFAULT '',   `email` varchar(255) NOT NULL DEFAULT '',   `extrainfo` text NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `metakey` text NOT NULL,   `own_prefix` tinyint(4) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   PRIMARY KEY (`id`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner_tracks` (   `track_date` datetime NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL,   `count` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`track_date`,`track_type`,`banner_id`),   KEY `idx_track_date` (`track_date`),   KEY `idx_track_type` (`track_type`),   KEY `idx_banner_id` (`banner_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__banners` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `clickurl` varchar(200) NOT NULL DEFAULT '',   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text NOT NULL,   `custombannercode` varchar(2048) NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `params` text NOT NULL,   `own_prefix` tinyint(1) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `language` char(7) NOT NULL DEFAULT '',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `version` int(10) unsigned NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `idx_state` (`state`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`),   KEY `idx_banner_catid` (`catid`),   KEY `idx_language` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `level` int(10) unsigned NOT NULL DEFAULT '0',   `path` varchar(255) NOT NULL DEFAULT '',   `extension` varchar(50) NOT NULL DEFAULT '',   `title` varchar(255) NOT NULL,   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `note` varchar(255) NOT NULL DEFAULT '',   `description` mediumtext NOT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `params` text NOT NULL,   `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',   `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',   `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `cat_idx` (`extension`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_path` (`path`),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`),   KEY `idx_language` (`language`) ) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
INSERT INTO `#__categories`  VALUES ('1', '0', '0', '0', '39', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '42', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('3', '28', '1', '1', '2', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('4', '29', '1', '3', '4', '1', 'numodusversus', 'com_contact', 'nuModusVersus', 'numodusversus', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '42', '2011-01-01 00:00:01', '471', '2013-06-21 13:05:12', '0', '*', '1'), ('5', '30', '1', '5', '6', '1', 'general', 'com_newsfeeds', 'General', 'general', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '42', '2011-01-01 00:00:01', '471', '2013-07-11 11:37:21', '0', '*', '1'), ('6', '31', '1', '7', '8', '1', 'general', 'com_weblinks', 'General', 'general', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '42', '2011-01-01 00:00:01', '471', '2013-07-11 11:44:41', '0', '*', '1'), ('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('10', '44', '1', '11', '12', '1', 'quotes', 'com_content', 'Quotes', 'quotes', '', '<p>dolor scelerisque et eget fames nisi nunc magna fames, magna facilisis et consectetur ligula quam. dui senectus habitasse feugiat donec augue rutrum sodales viverra mollis proin quisque, mauris potenti senectus bibendum augue diam suspendisse quis orci. tortor suscipit lobortis ut mi nulla nunc erat cras elementum, ante ut neque morbi euismod scelerisque curabitur facilisis viverra iaculis, lacinia semper nisi etiam aliquet faucibus ligula hac. elit malesuada taciti hendrerit fringilla ad vitae, ullamcorper aenean class primis laoreet risus integer, accumsan velit odio luctus mauris. aliquam etiam elementum sit nullam pellentesque proin, pellentesque posuere quisque orci proin, venenatis hac donec torquent quisque.</p>', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '471', '2013-07-11 10:38:24', '471', '2013-07-11 10:43:42', '0', '*', '1'), ('12', '46', '28', '24', '25', '2', 'joomla-categories/dance', 'com_content', 'Dance', 'dance', '', '<p>\nvestibulum class vehicula purus enim sociosqu primis sapien vel consequat massa ac posuere, faucibus euismod sed curabitur dapibus diam velit sit donec arcu varius, sodales inceptos purus elementum ipsum class habitant litora netus etiam imperdiet. \nfaucibus viverra donec cursus hendrerit viverra elit mollis eleifend leo, interdum justo commodo consequat aliquet nec aliquam platea, nam hac suspendisse habitant pharetra praesent tortor aliquet. \nlobortis duis aenean felis platea ut ultricies ornare rhoncus etiam mollis dapibus aliquet donec aenean etiam molestie metus, aliquet pretium aenean nunc posuere tellus consectetur cubilia vel erat fringilla rutrum facilisis potenti volutpat diam. \n</p>\n<p>\nneque nulla consectetur aliquam, volutpat. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:38:35', '471', '2013-07-11 10:46:19', '2', '*', '1'), ('13', '47', '27', '14', '15', '2', 'blog/design', 'com_content', 'Design', 'design', '', '<p>\ninceptos est id elit aliquam torquent ac pharetra aptent, sociosqu donec varius maecenas gravida eros dictum tempor vehicula, aptent inceptos turpis quam platea vitae quam. \nconsequat dictumst phasellus ut curabitur nunc lacus habitasse nisi platea risus conubia gravida curabitur arcu tortor congue justo, quam phasellus eros tempus turpis sem tristique nostra erat etiam mi duis tempus pellentesque lacus. \nquisque orci est metus sed scelerisque lacinia curabitur posuere curae adipiscing sagittis a sem hac aliquam, rhoncus accumsan praesent tellus nibh malesuada fringilla imperdiet habitant ante maecenas facilisis risus. \ntaciti ultricies aliquet quam eget volutpat malesuada justo, pharetra ac nunc varius vestibulum. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:38:40', '471', '2013-07-11 10:44:27', '3', '*', '1'), ('14', '48', '27', '16', '17', '2', 'blog/fashion', 'com_content', 'Fashion', 'fashion', '', '<p>\nlaoreet nisl imperdiet class potenti scelerisque dictumst egestas, iaculis euismod vulputate augue urna fringilla aenean, per vestibulum ac augue ut urna. \ncurabitur sapien potenti in vulputate litora amet tempor augue, tellus ante tempor curae in elementum. \nsuscipit et in sed aliquam vehicula maecenas per pulvinar euismod leo, semper diam massa lacus nullam bibendum vehicula mattis velit rutrum pellentesque, pulvinar adipiscing curabitur aliquet viverra mollis ligula volutpat feugiat. \naliquet volutpat donec quisque scelerisque faucibus curae non fringilla taciti, porta himenaeos curae habitant risus pretium massa hac maecenas conubia, netus vehicula nostra sagittis ullamcorper nostra quisque euismod. \n</p>\n<p>\nvehicula sapien potenti curabitur, ullamcorper. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:38:45', '471', '2013-07-11 10:44:27', '54', '*', '1'), ('17', '51', '28', '26', '27', '2', 'joomla-categories/movies', 'com_content', 'Movies', 'movies', '', '<p>\nvestibulum at vestibulum eleifend leo potenti convallis lobortis sodales suspendisse quis, ut proin nunc faucibus suspendisse tellus aenean cras interdum, class dictum luctus eleifend donec fringilla sagittis pulvinar accumsan. \nfusce sed leo felis massa lectus aenean odio ut tempor elementum vulputate, at nostra aenean sociosqu leo iaculis massa quis tempor lorem, per cubilia dolor condimentum sit curabitur lorem ornare nostra turpis. \nporta eu lacus semper aenean ut pretium consectetur, neque ut enim leo est fermentum diam ullamcorper, malesuada ut pellentesque leo duis taciti. \nmolestie suscipit blandit hendrerit ut et eros integer fames fringilla, posuere tortor risus integer tortor libero netus. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:01', '471', '2013-07-11 10:46:19', '2', '*', '1'), ('18', '52', '28', '28', '29', '2', 'joomla-categories/music', 'com_content', 'Music', 'music', '', '<p>\nclass libero sociosqu velit ligula lacus euismod etiam ultrices, nulla imperdiet volutpat donec magna maecenas aliquam, vitae sociosqu placerat volutpat viverra eu litora. \narcu mollis sodales faucibus commodo fames nostra cubilia ultrices sollicitudin euismod iaculis blandit, litora facilisis duis lorem nunc porttitor mollis metus ultricies consectetur odio. \negestas elit ad libero enim rhoncus elementum sit, rhoncus vulputate nec ligula aptent orci, imperdiet blandit facilisis quis dictumst ligula. \neget amet sit habitant etiam tempus, cubilia vulputate morbi cras fusce placerat, pulvinar luctus fermentum pretium. \ndonec molestie quisque dictumst diam felis tempus ut turpis velit, tristique viverra sit porttitor nisi neque morbi. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:04', '471', '2013-07-11 10:46:19', '92', '*', '1'), ('20', '54', '28', '30', '31', '2', 'joomla-categories/night-out', 'com_content', 'Night Out', 'night-out', '', '<p>\nblandit conubia molestie egestas condimentum blandit convallis pretium nunc porttitor, rutrum duis sodales porttitor ad per at inceptos dapibus, eu quis euismod curabitur interdum dictumst inceptos potenti. \nblandit leo elit massa ligula velit nostra lectus ultrices primis, iaculis luctus habitasse lacus elit scelerisque vitae nisl turpis, arcu non donec suspendisse diam tortor placerat morbi. \ntempor elementum eget consectetur accumsan duis varius eu fringilla commodo, aenean pellentesque consectetur taciti iaculis morbi scelerisque sagittis, placerat sit sapien duis ultricies quisque consequat curabitur. \ncurae ac fusce aliquam himenaeos volutpat risus enim, pellentesque tempus imperdiet etiam auctor ultricies, diam phasellus diam varius suspendisse tortor. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:09', '471', '2013-07-11 10:46:19', '1', '*', '1'), ('23', '57', '27', '18', '19', '2', 'blog/style', 'com_content', 'Style', 'style', '', '<p>\ndui lobortis volutpat cursus scelerisque sagittis pellentesque est purus vulputate arcu, curae senectus ac in suspendisse euismod vitae ullamcorper dapibus, placerat ultricies quisque feugiat blandit tortor platea rutrum quisque. \npellentesque varius faucibus proin torquent etiam blandit nunc, metus eu sollicitudin phasellus tempus quisque, dui integer himenaeos lacinia dolor vitae. \nmaecenas accumsan maecenas himenaeos per vehicula pulvinar mauris velit ad proin, justo aliquam tempus sodales imperdiet risus augue arcu diam adipiscing, interdum tempus ullamcorper tempus laoreet gravida senectus mollis lobortis. \nfringilla sapien maecenas ut etiam class praesent vulputate, viverra sed fermentum lectus at taciti dictumst, faucibus lectus convallis proin sapien fusce. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:21', '471', '2013-07-11 10:44:27', '79', '*', '1'), ('24', '58', '27', '20', '21', '2', 'blog/technology', 'com_content', 'Technology', 'technology', '', '<p>\nblandit senectus id per aptent ut consequat sodales posuere at mauris litora, maecenas euismod habitant tellus tortor scelerisque mollis feugiat tristique duis habitasse cras, accumsan fames ligula posuere aliquam euismod dui nulla porta ultrices. \negestas nam neque dapibus vitae id sit ut aliquam dolor, vehicula vivamus suspendisse phasellus nam suscipit nulla dui ad odio, id erat metus inceptos praesent potenti ipsum etiam. \nsapien donec enim ad curae leo lacus aliquet pretium ligula, nisl ad felis senectus semper taciti tristique ut, magna velit libero convallis consectetur placerat augue turpis. \n</p>\n<p>\nodio lacus ut blandit class massa ultrices, turpis neque sodales arcu fringilla. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:27', '471', '2013-07-11 10:44:27', '3', '*', '1'), ('25', '59', '28', '32', '33', '2', 'joomla-categories/theater', 'com_content', 'Theater', 'theater', '', '<p>\ntempor ad quisque massa nibh donec auctor viverra lectus lobortis, egestas feugiat pellentesque hac maecenas et tempus class, nisl donec ad posuere faucibus id lacinia ornare. \nut hendrerit quisque viverra varius nec duis lacinia ipsum, sociosqu bibendum phasellus platea eros rutrum nec nullam sollicitudin, rutrum justo fermentum mattis cursus quisque auctor. \nmi ornare curabitur nam etiam feugiat euismod lorem ullamcorper velit conubia, nulla sapien senectus facilisis ultricies augue varius pharetra himenaeos torquent, cras curabitur vulputate netus nisl fames ad phasellus pharetra. \nquisque rhoncus quisque integer sem consequat ac, etiam convallis aliquet quis aenean etiam taciti, potenti rhoncus volutpat porttitor vulputate. \n</p>', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '471', '2013-07-11 10:39:31', '471', '2013-07-11 10:46:19', '1', '*', '1'), ('27', '141', '1', '13', '22', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '471', '2013-07-11 10:43:58', '0', '0000-00-00 00:00:00', '8', '*', '1'), ('28', '142', '1', '23', '34', '1', 'joomla-categories', 'com_content', 'Joomla! Categories', 'joomla-categories', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '471', '2013-07-11 10:45:58', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('29', '143', '1', '35', '36', '1', 'useful-feeds', 'com_newsfeeds', 'Useful Feeds', 'useful-feeds', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '471', '2013-07-11 11:37:31', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('30', '144', '1', '37', '38', '1', 'useful-links', 'com_weblinks', 'Useful Links', 'useful-links', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\",\"tags\":null}', '471', '2013-07-11 11:44:55', '0', '0000-00-00 00:00:00', '0', '*', '1');
CREATE TABLE `#__contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `con_position` varchar(255) DEFAULT NULL,   `address` text,   `suburb` varchar(100) DEFAULT NULL,   `state` varchar(100) DEFAULT NULL,   `country` varchar(100) DEFAULT NULL,   `postcode` varchar(100) DEFAULT NULL,   `telephone` varchar(255) DEFAULT NULL,   `fax` varchar(255) DEFAULT NULL,   `misc` mediumtext,   `image` varchar(255) DEFAULT NULL,   `email_to` varchar(255) DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `mobile` varchar(255) NOT NULL DEFAULT '',   `webpage` varchar(255) NOT NULL DEFAULT '',   `sortname1` varchar(255) NOT NULL,   `sortname2` varchar(255) NOT NULL,   `sortname3` varchar(255) NOT NULL,   `language` char(7) NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `version` int(10) unsigned NOT NULL DEFAULT '1',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__contact_details`  VALUES ('1', 'nuModusVersus', 'numodusversus', '', '1766 Madison Ave.', 'New York', '', 'USA', '10029', '+1 222 333 4567', '+1 222 333 5678', '<p>Etiam tincidunt laoreet turpis a vulputate. Etiam diam lorem, convallis ac laoreet a, pretium id nisl. Morbi tincidunt nibh a ante fringilla at tincidunt eros venenatis. Nunc a dui mi, in imperdiet sem. Aenean eu nulla massa. Ut interdum tristique est commodo pharetra.</p>', '', 'contact@example.com', '0', '1', '0', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":null,\"linkb_name\":\"\",\"linkb\":null,\"linkc_name\":\"\",\"linkc\":null,\"linkd_name\":\"\",\"linkd\":null,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '0', '4', '1', '+1 222 333 6789', 'http://example.com', '', '', '', '*', '2013-06-21 13:07:39', '471', '', '2013-07-10 12:10:02', '471', '', '', '{\"robots\":\"\",\"rights\":\"\",\"tags\":null}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '3', '0');
CREATE TABLE `#__content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text NOT NULL,   `urls` text NOT NULL,   `attribs` varchar(5120) NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `access` int(10) unsigned NOT NULL DEFAULT '0',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `language` char(7) NOT NULL COMMENT 'The language code for the article.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;
INSERT INTO `#__content`  VALUES ('2', '62', 'Sodales tortor primis dui ', 'sodales-tortor-primis-dui', '<p>lectus auctor sit nam purus sagittis litora turpis phasellus, varius volutpat augue sit fusce a pellentesque aptent, semper dictumst curae leo curabitur adipiscing turpis. velit leo venenatis semper proin habitasse curabitur lobortis sodales purus, torquent semper turpis elementum mi platea facilisis massa ad nec, conubia ornare lacus id habitant lorem luctus augue. tempor nulla ultricies augue hac cursus pharetra dui curabitur, sollicitudin quis lacinia netus pellentesque id eget quam, lorem sem velit tortor diam orci aenean. primis suscipit praesent nisi aliquam sociosqu euismod malesuada facilisis, suscipit ultrices accumsan felis etiam maecenas eros mattis, blandit curabitur ullamcorper ligula consectetur senectus fermentum.</p>\r\n', '\r\n<p>sagittis ac ut tortor risus gravida pretium, mattis ad torquent euismod aenean, aptent quam vulputate egestas sociosqu sem, molestie habitasse enim dui. sagittis malesuada morbi ipsum tempus nulla, posuere adipiscing interdum himenaeos ullamcorper erat, litora aenean auctor eros. augue praesent hac commodo faucibus tempor nulla fames erat, senectus luctus vitae magna risus sed donec, bibendum nibh gravida ligula auctor scelerisque molestie. vehicula enim interdum auctor morbi molestie potenti pulvinar aptent, vestibulum dictum sit porttitor curae vitae per velit feugiat, sociosqu porttitor volutpat facilisis cubilia pellentesque senectus. malesuada enim litora luctus non tempus platea feugiat, torquent lectus curabitur hac arcu lectus mauris, aptent ut torquent taciti ornare faucibus.</p>\r\n<p>metus porttitor auctor ad arcu himenaeos hac interdum arcu laoreet senectus auctor, dui massa hendrerit curabitur semper gravida suscipit augue tellus curae laoreet, consectetur duis massa quisque nullam purus semper elementum ut molestie. varius nullam molestie aptent cursus vitae etiam cubilia fusce, pellentesque inceptos odio quisque rutrum est dictumst, lacus sed semper pretium scelerisque placerat mattis. elementum hac semper condimentum donec, tortor curabitur pulvinar ornare, non primis fusce. sagittis netus varius tortor fringilla ligula cubilia lacus purus, quisque phasellus nisl etiam maecenas class lacus inceptos, elementum porta sapien felis nec ultrices phasellus.</p>\r\n<p>turpis maecenas hac vivamus fringilla etiam at vel nisi praesent taciti lorem, torquent leo morbi eleifend non ullamcorper eu diam massa felis, phasellus augue hac quis eu tellus sed vulputate ad condimentum. laoreet ligula convallis nisi semper lectus donec aliquet ornare consequat, ut suspendisse ac sit tortor donec proin cras ante nulla, morbi lacinia praesent condimentum ut nisl auctor ultrices. consequat dolor cubilia luctus porta nostra himenaeos pellentesque, aenean rhoncus pellentesque ut habitant fusce, lectus adipiscing consectetur torquent pharetra netus. quis rhoncus facilisis vel platea dui fames morbi varius imperdiet semper at, non venenatis in suspendisse rutrum dolor mattis ornare maecenas.</p>\r\n<p>et augue donec tellus in consectetur cursus curae ligula consequat, curabitur duis netus sagittis litora amet mollis donec felis curabitur, auctor ultricies dictum vel enim rhoncus velit quisque. pharetra nunc netus id auctor eu lacinia amet integer eu placerat, sodales tempus lacinia gravida duis lacus non condimentum vestibulum. mattis adipiscing pretium malesuada vehicula torquent pretium cubilia nullam, a ac viverra quisque facilisis sed aliquam mattis, nibh ultrices felis aliquam adipiscing neque class. euismod quam class ornare tortor purus netus fermentum, vulputate magna curabitur tortor vulputate egestas, taciti suspendisse praesent inceptos curabitur venenatis.</p>\r\n<p>fames curabitur lacus phasellus suspendisse, in massa mi.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/9255261@N07/sets/72157605611183371/with/4306905525/{/gallery}</div>', '1', '24', '2013-07-11 10:39:44', '472', '', '2013-07-19 10:21:22', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:39:44', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sodales tortor primis dui \",\"image_intro_caption\":\"Habitasse convallis vestibulum \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/8_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sodales tortor primis dui \",\"image_fulltext_caption\":\"Habitasse convallis vestibulum \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '2', 'Trendy, Bleeding Edge, Must Buy', '', '1', '1', '{\"tags\":[2,9,23],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('4', '64', 'Eros amet cursus augue inceptos ', 'eros-amet-cursus-augue-inceptos', '<p>lorem duis eros erat aenean taciti ullamcorper dictum rutrum, fusce et proin eros elit consectetur eget, enim aliquet nunc varius sed non viverra. aliquam laoreet luctus nisl iaculis libero duis posuere eleifend libero, mattis curabitur platea curabitur porta mattis habitasse porttitor, aliquet donec arcu augue fusce eget scelerisque tellus. erat elit eu nulla mollis sociosqu, sollicitudin fames senectus est, quis malesuada aliquam luctus. hendrerit et phasellus eros placerat feugiat cursus eleifend fermentum ante lacinia velit sodales quisque magna malesuada cursus, auctor maecenas curabitur dictum consequat donec dictum consequat fringilla iaculis aenean lacus aenean porta.</p>\r\n<p>luctus velit pretium eros, egestas luctus.</p>\r\n', '\r\n<p>nibh vestibulum quisque condimentum lacinia vivamus mi commodo nisl himenaeos, consequat auctor a tempus litora rhoncus molestie per. a etiam euismod laoreet euismod sollicitudin velit malesuada etiam ante, ad est justo convallis elit litora ante. enim duis nisi nibh porttitor semper ornare litora, massa nunc ac sagittis ultrices posuere, eu platea posuere massa leo cursus. lobortis ut vehicula fringilla venenatis aliquam pellentesque sapien fames ut nisl tellus, tempus condimentum viverra dictum erat placerat facilisis at vestibulum. taciti placerat proin elementum eleifend volutpat ligula vehicula velit aptent velit quam dapibus faucibus sapien cras libero, himenaeos adipiscing elit malesuada erat etiam orci curae ante leo himenaeos tincidunt lorem dictum facilisis.</p>\r\n<p>ultrices morbi eget vehicula sagittis lorem, dui odio senectus curae condimentum, velit eu vestibulum congue. suspendisse ante himenaeos cubilia dictum ligula consequat mi, duis etiam vulputate purus etiam. et a posuere leo duis feugiat tortor elementum torquent integer, dictum amet habitasse aliquam netus amet per bibendum eu torquent, ultrices venenatis tristique dapibus eget cras consequat curabitur. suscipit nec aliquam nullam scelerisque faucibus hac volutpat, adipiscing hendrerit et curabitur posuere tristique etiam, quam hendrerit aenean elit sem consequat. aliquam ultrices sem amet elementum tortor, ullamcorper amet vehicula aliquet. arcu proin eros nisl urna feugiat arcu rutrum class massa himenaeos litora, class ut curae metus aliquet molestie pulvinar curabitur proin etiam, at porttitor facilisis sed himenaeos placerat ipsum amet donec volutpat.</p>\r\n<p>turpis placerat mollis magna eu cubilia ultrices dolor ante, cursus suspendisse mi placerat fringilla mattis ante fames, non justo rutrum quisque curabitur cubilia neque. conubia praesent vehicula fringilla eu ipsum dapibus nunc nisl ultrices, sodales ornare adipiscing senectus aliquet libero tempor feugiat. rhoncus ligula rutrum turpis posuere auctor hac leo fringilla, commodo lobortis dapibus eros tempus porta lacus fermentum, lobortis quis hac faucibus iaculis cras hendrerit. dui nec class urna ad pellentesque urna condimentum id metus, mollis iaculis morbi mattis turpis felis rutrum egestas. scelerisque etiam in dapibus dui auctor nostra semper cursus arcu gravida, sapien lobortis consequat laoreet nunc ornare aenean taciti molestie, primis class conubia dolor accumsan varius at ornare aliquam.</p>\r\n<p>convallis congue massa magna vestibulum et malesuada sociosqu faucibus sagittis, curabitur mi iaculis leo lacinia lectus proin tempus feugiat congue, interdum bibendum interdum lectus convallis faucibus malesuada curae. egestas non elit fermentum tempus cursus eleifend nostra volutpat, pellentesque vivamus sagittis nam praesent euismod curabitur, taciti mollis iaculis vehicula eu nostra quisque. platea adipiscing lorem inceptos in mi, aenean pellentesque taciti.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:39:48', '471', '', '2013-07-18 14:55:00', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:39:48', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Eros amet cursus augue inceptos \",\"image_intro_caption\":\"Convallis fermentum a \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Eros amet cursus augue inceptos \",\"image_fulltext_caption\":\"Convallis fermentum a \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '8', 'CEO, CFO, Forbes', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('5', '65', 'Fringilla commodo tellus malesuada ', 'fringilla-commodo-tellus-malesuada', '<p>\nposuere nostra neque phasellus ligula mollis ante blandit, viverra duis sagittis viverra pulvinar tristique. \nclass augue vulputate euismod dictum tortor nam etiam per convallis in, elementum aliquet viverra euismod inceptos tellus donec elit tempus amet curae, malesuada neque molestie diam quisque aliquet semper maecenas libero. \nnisi id sollicitudin dictum rhoncus etiam maecenas varius dui, dapibus praesent mauris luctus rhoncus dictum ullamcorper cubilia, tellus fringilla ligula in dapibus cubilia posuere. \naptent integer nunc fringilla pulvinar litora proin ut velit fermentum dictumst arcu, fames egestas class dictumst purus euismod fusce nam pretium. \n</p>\n<p>\nad in imperdiet fringilla aliquam molestie, morbi nisi mauris magna. \n</p>', '<p>\neget integer lorem elementum placerat aliquam condimentum sociosqu, adipiscing est tristique posuere est iaculis, facilisis aliquam molestie faucibus senectus luctus. \nmalesuada commodo magna fusce potenti nisi quam tincidunt, integer lacinia proin suspendisse etiam in, dapibus ut egestas fames sem dictum. \nnulla turpis ut viverra felis varius ut, convallis lacus hendrerit metus porta placerat viverra, leo nullam est inceptos himenaeos. \nconsequat curabitur tempor sed sodales ad, auctor imperdiet nostra feugiat, ornare ad euismod eget. \nnisi etiam purus semper pellentesque aptent ullamcorper fermentum dapibus sagittis morbi imperdiet felis curabitur ut, lacus praesent interdum in vulputate erat ac mattis bibendum donec facilisis fames. \n</p>\n<p>\ninteger dolor varius non justo at venenatis eget risus adipiscing aenean blandit, habitasse cras felis platea euismod inceptos per bibendum odio. \naenean habitasse taciti cubilia justo sed ante molestie vel fringilla dapibus rhoncus, fringilla volutpat vestibulum scelerisque erat urna tortor rutrum conubia nulla. \nsenectus turpis fermentum etiam vestibulum donec enim nulla, suspendisse enim tempus nostra arcu pharetra facilisis tempus, semper condimentum luctus cubilia eleifend varius. \nnisl laoreet curabitur quisque urna sagittis porttitor rutrum himenaeos tincidunt quis conubia, morbi urna sollicitudin mauris leo arcu pulvinar senectus vehicula netus purus commodo, platea donec velit ullamcorper eros nisi velit donec sagittis leo. \n</p>\n<p>\netiam dolor vehicula tellus felis aptent augue ligula purus dictumst eu, per nostra neque interdum vestibulum netus mollis nec aliquam congue elementum, curabitur eros ligula elit nam tincidunt maecenas neque luctus. \nsodales ad metus nunc duis cursus pretium scelerisque nullam ante, sem aliquam sit litora inceptos pharetra vel ante. \nmalesuada praesent semper vulputate eget habitant hendrerit pharetra quam facilisis est odio donec, ante luctus arcu sem elementum et donec quam dictum justo. \nproin cubilia dictumst ante quam dictumst hac quam leo aenean cras velit, aenean ultricies tristique lacus purus iaculis morbi tellus eros tempus. \n</p>\n<p>\nfermentum tristique amet fringilla ligula vivamus, adipiscing nulla dictumst felis pellentesque, elementum morbi in nostra. \nnisi nibh massa nullam dui at nunc consectetur commodo porta, aliquam ultrices mauris felis blandit purus nisl. \nligula placerat auctor ligula himenaeos et pellentesque ornare justo habitant suspendisse sed at, ullamcorper duis euismod maecenas congue suspendisse faucibus porta phasellus consequat sem, integer quisque placerat taciti per ligula amet cras eleifend etiam massa. \nconvallis sociosqu fames est tincidunt tortor urna adipiscing ut egestas odio lobortis venenatis, integer aenean tellus aliquet dictumst fusce interdum etiam sollicitudin aliquam. \n</p>\n<p>\nper morbi ultrices leo mollis inceptos dui, urna facilisis cursus venenatis hac, leo metus tortor hendrerit tortor. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}</div></dd></dl>', '1', '25', '2013-07-11 10:39:50', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:39:50', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/25\\/5_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Fringilla commodo tellus malesuada \",\"image_intro_caption\":\"Laoreet in quam \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/25\\/5_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Fringilla commodo tellus malesuada \",\"image_fulltext_caption\":\"Laoreet in quam \"}', '', '', '1', '3', 'Performance, Comedy, Drama', '', '1', '0', '', '0', '*', ''), ('7', '67', 'Libero proin venenatis maecenas lorem ', 'libero-proin-venenatis-maecenas-lorem', '<p>cursus vulputate nostra litora augue dapibus elementum adipiscing, ut inceptos vulputate cras duis consectetur quisque netus, aptent orci suspendisse ullamcorper nunc molestie. ullamcorper consequat erat ligula etiam adipiscing porta, eleifend justo eu erat purus duis, lorem purus pulvinar aliquam quam. sapien diam curae non et turpis duis condimentum per ultrices nisi, euismod turpis libero purus ligula aliquam vivamus porttitor semper malesuada, amet vivamus commodo torquent id eros nisi rutrum feugiat. primis nisi rhoncus eget blandit curabitur cursus pretium felis imperdiet, suspendisse aliquam auctor dictumst morbi nulla augue vulputate, lectus ullamcorper nisi faucibus taciti eros amet etiam.</p>\r\n<p>odio ut aliquet, himenaeos.</p>\r\n', '\r\n<p>commodo faucibus platea phasellus quisque scelerisque tortor molestie elit fames ad imperdiet, scelerisque aenean gravida pharetra duis aliquet ultricies arcu fusce eleifend, potenti curabitur turpis placerat a est nec sapien senectus nisi. turpis interdum velit orci quis ipsum conubia augue quis risus curabitur eget, senectus curabitur nullam lorem vestibulum volutpat semper orci neque cursus, netus ultrices purus phasellus viverra sed nam nibh netus rutrum. nec sociosqu pharetra posuere class elit arcu ac etiam quis, taciti pretium gravida fermentum non metus in adipiscing, diam eleifend eros dapibus orci mi vulputate dictumst.</p>\r\n<p>in fusce bibendum quam eleifend cubilia tortor conubia in augue class aliquam fringilla proin, fermentum nulla vulputate magna semper mollis morbi senectus aenean integer varius. primis ut aenean lobortis sapien cubilia aliquet, justo hac a hendrerit in non faucibus, urna est sagittis nulla vitae. ipsum vestibulum porttitor hac massa interdum euismod sociosqu, netus tortor integer faucibus netus curabitur risus, justo lectus pellentesque mollis ac gravida. leo lacus imperdiet scelerisque nostra consequat class, etiam inceptos mi potenti ante hac suspendisse, auctor enim ullamcorper egestas fermentum. molestie id quam ut nostra ante dictumst malesuada dictum malesuada aptent, velit netus aptent consequat quam augue libero ut hac consectetur, in dapibus tincidunt torquent gravida molestie porta nullam placerat.</p>\r\n<p>pretium enim cursus non curabitur donec feugiat donec eleifend cubilia, ut non curabitur lectus dictumst maecenas consequat ipsum mi, dictum habitasse feugiat himenaeos dictumst est per curabitur. pharetra etiam semper iaculis fames dictumst ut erat pretium fermentum quisque justo donec non nam, at porta eget donec dapibus primis quisque tellus gravida ad convallis aptent proin. tempor ultricies habitasse bibendum tempor laoreet sagittis nibh tellus fringilla, est feugiat quam risus tincidunt aliquam id mollis at, non curae elementum sociosqu etiam euismod curabitur senectus. nunc facilisis mauris netus congue nec ut aliquam eget pharetra hac tellus, fringilla sagittis sem eleifend faucibus a nunc leo ac nam.</p>\r\n<p>varius egestas tortor vestibulum sodales senectus vestibulum mi venenatis adipiscing, non diam odio tempus tristique netus taciti augue, lacus erat scelerisque ipsum posuere laoreet varius lobortis. duis amet varius elit velit litora cras euismod, nullam quisque ullamcorper elit ipsum hac, fames aenean cras rhoncus malesuada platea. curabitur nibh ipsum felis volutpat tortor viverra nunc proin suscipit orci, sagittis dictumst placerat cubilia magna odio donec lobortis viverra, nunc litora semper mattis cras duis leo turpis vitae. praesent eleifend lorem sem massa tincidunt eleifend, fames facilisis curabitur integer amet, habitasse interdum dictumst neque ultricies.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:39:55', '471', '', '2013-07-18 14:55:21', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:39:55', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Libero proin venenatis maecenas lorem \",\"image_intro_caption\":\"Donec netus luctus habitant \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Libero proin venenatis maecenas lorem \",\"image_fulltext_caption\":\"Donec netus luctus habitant \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '7', 'Marketing, CEO', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('8', '68', 'Pellentesque vel tincidunt taciti maecenas ', 'pellentesque-vel-tincidunt-taciti-maecenas', '<p>venenatis etiam conubia fusce ac lobortis aliquet blandit, quis tincidunt praesent placerat in feugiat inceptos, netus maecenas gravida donec id integer. quisque luctus orci auctor hendrerit ultrices etiam est fringilla curae consectetur tellus, sem sollicitudin nulla aptent justo sodales primis leo id aenean phasellus, pellentesque duis eu vehicula cras senectus magna turpis odio a. luctus feugiat a vulputate mi felis placerat hac magna curabitur elit per eu ultrices elementum tempus, curae tincidunt rutrum in cubilia tortor sed nibh tristique mi ornare tincidunt porta eget. nunc etiam ut platea bibendum ornare ultrices nam ac, ligula donec ultricies libero pharetra ad feugiat.</p>\r\n', '\r\n<p>volutpat ligula inceptos morbi a fermentum aenean lorem, leo lacinia erat felis condimentum pharetra quam, lorem vel class ad mi hendrerit. sociosqu aliquam phasellus curabitur ad tellus tristique enim vestibulum sociosqu quisque, mi consectetur at conubia tellus sit suscipit ac torquent, curabitur potenti laoreet risus consequat nulla fusce cubilia accumsan. nostra consectetur lobortis nulla habitasse luctus netus dolor, lorem nibh senectus nisl rutrum sodales cubilia, magna netus condimentum fames lorem pellentesque. fringilla lectus elementum feugiat curae quis libero id suspendisse, convallis tortor at quam venenatis orci maecenas, senectus maecenas fusce erat ligula pulvinar inceptos.</p>\r\n<p>est tortor litora potenti nisl fames fusce viverra inceptos auctor, vivamus morbi praesent arcu bibendum sapien conubia primis consequat nullam, tristique maecenas duis leo felis elementum eget interdum. elit est sed erat potenti eros aliquet enim ut, vel nulla fames enim tellus vulputate fusce. luctus potenti interdum augue litora nullam suscipit dapibus justo nisl himenaeos, egestas lobortis nisi dictumst bibendum aliquam pellentesque phasellus suscipit elit, etiam vel dapibus cubilia tortor litora luctus leo proin. dui a iaculis posuere auctor faucibus himenaeos adipiscing commodo venenatis suspendisse ultricies amet enim venenatis, consectetur platea lacinia mauris euismod iaculis id nec sociosqu hendrerit cursus interdum.</p>\r\n<p>sapien netus non sociosqu ultrices risus at vel urna quisque felis, turpis ornare risus adipiscing inceptos pellentesque id diam suspendisse. lobortis nulla volutpat auctor proin accumsan tincidunt aliquet scelerisque mi aliquam, curabitur vehicula aliquam nullam dictum elementum aliquam velit habitant etiam, ante magna aliquet per mi commodo taciti nibh curae. sollicitudin nisl viverra phasellus lobortis felis luctus ligula ac conubia, fermentum etiam bibendum placerat aliquam lorem scelerisque class accumsan, amet mi semper curabitur in gravida curabitur est. massa diam tempus curabitur quis habitasse et malesuada praesent lectus, et metus nostra hendrerit etiam gravida suspendisse potenti.</p>\r\n<p>fringilla conubia senectus vel est mi fames varius faucibus ut praesent class, porta neque odio hendrerit dolor pretium inceptos rutrum euismod diam sollicitudin, sociosqu arcu augue donec justo sed odio curae scelerisque etiam. felis phasellus pellentesque libero orci quisque nisi fusce gravida ultricies molestie, mattis varius mauris hendrerit ante habitasse hac vel torquent aliquam, torquent nulla turpis porttitor arcu hendrerit taciti cursus nullam. litora at litora nibh molestie varius dapibus faucibus morbi tempor egestas, feugiat praesent faucibus vehicula eros nisl class lectus metus vitae habitant, eu torquent ac integer aliquam potenti nisi rhoncus dolor.</p>\r\n<p>aptent habitant vitae per arcu etiam turpis mollis eu, euismod diam mauris lectus consectetur imperdiet proin.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/kapkap/sets/72157630262692072/with/7413517300/{/gallery}</div>', '1', '23', '2013-07-11 10:39:57', '472', '', '2013-07-19 10:19:01', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:39:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/11_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Pellentesque vel tincidunt taciti maecenas \",\"image_intro_caption\":\"Gravida rutrum nostra ornare eros \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/11_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Pellentesque vel tincidunt taciti maecenas \",\"image_fulltext_caption\":\"Gravida rutrum nostra ornare eros \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '3', 'Eccentric, Minimal, Autumn - Winter, Avant Garde', '', '1', '3', '{\"tags\":[6,11,15,21],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('10', '70', 'Consectetur sapien pharetra aptent nibh ', 'consectetur-sapien-pharetra-aptent-nibh', '<p>suscipit convallis sed commodo tempus nisi dictum, aenean ornare nostra curabitur taciti, facilisis non potenti semper conubia. iaculis augue eros ipsum eleifend pellentesque donec fermentum platea placerat, maecenas justo curabitur rhoncus sodales eu elit id class, mollis quisque feugiat habitasse nisi tellus congue senectus. fringilla integer hendrerit blandit hendrerit bibendum purus eros erat, id eleifend fames consequat curabitur vehicula tincidunt fringilla, tristique phasellus enim dui aenean mauris fusce. sapien luctus ultricies non netus nec proin nunc a, aliquet risus suspendisse nisl cras ullamcorper lectus iaculis urna, mollis vitae faucibus taciti conubia tempus eleifend.</p>\r\n<p>viverra himenaeos feugiat magna accumsan, commodo elit.</p>\r\n', '\r\n<p>varius torquent lorem ut sit dui dapibus convallis posuere, ornare scelerisque consectetur scelerisque consectetur quisque ipsum nibh sagittis, varius himenaeos elementum ultricies vel nec semper. eleifend mattis habitasse faucibus porttitor neque augue sollicitudin amet sodales, urna condimentum sapien augue iaculis interdum non vivamus posuere, ad etiam diam eleifend torquent molestie vehicula conubia. sapien vestibulum accumsan venenatis quam mollis ad etiam, velit curae lacus congue fermentum quisque etiam, fusce accumsan ac primis lectus aenean. duis neque dictumst luctus lorem vel litora sollicitudin laoreet fermentum consequat volutpat et nibh facilisis vitae convallis nec, morbi risus quis mauris morbi duis condimentum accumsan cubilia malesuada id vestibulum pretium vel class.</p>\r\n<p>tempor aenean nostra vehicula posuere sagittis a, aenean lobortis habitasse metus nullam aliquam est, praesent tortor vulputate luctus nullam. etiam primis auctor praesent donec primis dictum sapien senectus rutrum venenatis, ut tempor cras diam vulputate aliquam eleifend phasellus non ante, litora aptent pharetra tortor hendrerit tempor cras convallis habitant. himenaeos diam varius habitant curae luctus nisi himenaeos magna nisl, eget vehicula fusce donec urna lorem varius class. eleifend luctus class tempor phasellus quis varius ultrices pellentesque, primis ligula praesent posuere urna tempor feugiat ut, dapibus suspendisse pharetra faucibus quisque cubilia platea.</p>\r\n<p>taciti sed adipiscing nibh viverra justo elit, aliquam rhoncus tortor lacinia ipsum erat vehicula, tellus odio primis tempus donec. eros dictumst commodo vehicula malesuada consequat mi nec, habitasse erat egestas primis class magna convallis, lectus pretium elit ultrices amet iaculis. tellus id aptent congue et sit a massa rhoncus eros, bibendum donec himenaeos eros lacus ultricies cubilia curae. lorem fusce cras quis pulvinar nunc tortor non, eu torquent habitasse dictum laoreet rutrum placerat cursus, quisque semper justo class tellus tempus. imperdiet senectus cubilia potenti consequat mi suspendisse nisl porta, cursus tempor amet sociosqu dolor aliquam elementum condimentum, rutrum elit posuere tempor posuere mi inceptos.</p>\r\n<p>potenti rhoncus sed inceptos vestibulum eget primis sit, velit aliquet arcu vel accumsan ac mattis cursus, habitant nisi habitant purus eros euismod. orci etiam magna interdum varius orci arcu aptent fames habitasse, egestas nibh quisque turpis fusce ante himenaeos accumsan sapien, tincidunt phasellus nunc diam class ultricies lacinia phasellus. elementum donec praesent sagittis leo primis pulvinar inceptos, molestie enim sem dictumst iaculis est aenean tortor, phasellus torquent amet ac fringilla sodales. donec fames amet lectus eleifend lobortis tristique aenean quisque nullam pellentesque aptent, amet sem quis non lectus cubilia quisque sit auctor aenean.</p>\r\n<p>imperdiet nulla tempus accumsan, lectus volutpat.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:40:01', '471', '', '2013-07-18 14:54:34', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:01', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Consectetur sapien pharetra aptent nibh \",\"image_intro_caption\":\"Nisi suspendisse suscipit tellus quisque \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Consectetur sapien pharetra aptent nibh \",\"image_fulltext_caption\":\"Nisi suspendisse suscipit tellus quisque \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '6', 'Roi, Debate, Takeover', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('11', '71', 'Curabitur platea eu sem nisl nec ', 'curabitur-platea-eu-sem-nisl-nec', '<p>tristique sem morbi mollis magna nibh dictum nec sodales imperdiet massa, tortor venenatis senectus primis cursus sodales in taciti risus, odio quam enim faucibus per et lobortis ad enim. taciti sed sem donec semper lacus ut, vivamus velit magna sagittis adipiscing porttitor sem, conubia nulla vehicula bibendum nunc. libero ullamcorper massa a eros neque praesent conubia ultricies condimentum, pellentesque aliquet sociosqu nec imperdiet maecenas lacinia quis iaculis dui, suscipit egestas auctor duis consequat duis a nulla. ad vitae pretium blandit pharetra taciti elit cursus conubia, potenti aliquam vivamus etiam rhoncus proin lobortis viverra, habitasse auctor imperdiet enim iaculis curabitur eleifend.</p>\r\n', '\r\n<p>lorem malesuada magna ultricies fringilla metus primis feugiat cursus, porttitor fringilla urna ac iaculis scelerisque hac, malesuada diam ac nibh urna platea pulvinar. nullam convallis conubia sem ultrices interdum adipiscing libero urna duis pharetra tellus congue, dolor diam interdum ornare ipsum lectus rutrum feugiat ad ligula torquent. cubilia sed nunc ad accumsan ut aenean, arcu sollicitudin libero dui cras hendrerit ac, duis vulputate ac viverra non. at mollis varius aliquam tincidunt curabitur interdum auctor luctus egestas, cubilia dui erat eget luctus ad mi tristique potenti, dapibus dictumst quam aliquam egestas congue tincidunt auctor.</p>\r\n<p>platea rutrum curae suspendisse cras faucibus risus odio purus urna, pulvinar aliquam eget vitae vestibulum elit ligula accumsan in, vestibulum consequat imperdiet primis class libero semper himenaeos. ad ullamcorper purus fames dictum sodales pretium neque vulputate ultricies cursus leo lacinia, tincidunt aliquam lorem vel urna varius leo curabitur neque condimentum porta, eu nisl vivamus ut dictumst neque sed purus platea habitasse est. cras habitant libero imperdiet cursus convallis ornare tortor nisi fringilla, luctus iaculis dictumst sem lacinia a justo urna, ut condimentum elit a himenaeos ut per potenti.</p>\r\n<p>proin inceptos odio vulputate vivamus sociosqu, euismod placerat nulla senectus scelerisque feugiat, ullamcorper sem ut egestas. dolor bibendum vulputate nisl inceptos at magna rhoncus, ullamcorper torquent aenean nam dapibus suscipit dictum, scelerisque ut urna orci integer ornare. dapibus nunc gravida adipiscing ipsum aptent etiam viverra mattis nunc nisi dictum, potenti consectetur dictumst dolor himenaeos interdum porttitor pellentesque conubia nam dictumst habitasse, gravida conubia nunc bibendum class pellentesque sapien metus eleifend fusce. elit velit blandit lacinia diam venenatis scelerisque commodo aenean volutpat aliquam vitae, risus elit habitant condimentum sodales vehicula gravida luctus habitasse cursus, ligula fringilla etiam mattis aenean curabitur nullam rutrum habitant etiam.</p>\r\n<p>sociosqu condimentum orci class eros libero scelerisque est tempor quam lectus nec porttitor, libero placerat purus dictumst tortor praesent orci morbi dictum tortor phasellus. praesent ut aliquam vestibulum donec vivamus varius libero dapibus habitasse tortor ut, non fusce vulputate aenean cursus feugiat fusce aliquam mauris. phasellus volutpat ut interdum dui aliquet nunc semper metus, vehicula curabitur euismod sapien sit magna per, nisl cursus per dui velit placerat luctus. egestas varius consequat eleifend turpis ut est praesent mi, habitant at litora habitant fusce felis erat nostra vestibulum, lorem mauris quam suscipit integer pretium non.</p>\r\n<p>pellentesque sed phasellus semper turpis diam orci, imperdiet condimentum tortor viverra ligula urna, nulla semper cursus amet litora. congue primis elementum posuere, tristique.</p>', '1', '18', '2013-07-11 10:40:03', '471', '', '2013-07-19 10:04:58', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:03', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/7_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Curabitur platea eu sem nisl nec \",\"image_intro_caption\":\"Litora praesent ullamcorper vel \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/7_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Curabitur platea eu sem nisl nec \",\"image_fulltext_caption\":\"Litora praesent ullamcorper vel \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '6', 'Chill out, New Release, Upcoming, House', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('12', '72', 'Auctor volutpat conubia ', 'auctor-volutpat-conubia', '<p>\nfaucibus sem nunc pretium porta ullamcorper ligula est nam hendrerit, vitae facilisis etiam fusce ullamcorper purus dolor lobortis, ut nostra habitasse viverra id duis class torquent. \na lacinia gravida posuere pretium porta inceptos eros aenean quis sem, orci tortor dictumst morbi molestie tellus habitant fermentum morbi, erat eleifend rutrum facilisis malesuada consequat torquent eget malesuada. \ntortor nulla habitasse massa leo posuere sed tempus sociosqu senectus, id dui gravida platea lectus platea leo volutpat curabitur, gravida fringilla id sagittis torquent convallis velit maecenas, torquent est lacus hac bibendum inceptos varius blandit. \n</p>\n<p>\nnulla faucibus nostra felis, scelerisque tempus venenatis tortor, luctus duis. \n</p>', '<p>\nquisque in eu dictum neque malesuada ut volutpat nisi feugiat velit a amet curabitur, eleifend euismod sapien sollicitudin donec elit phasellus tellus ac mattis conubia per. \nnulla vestibulum conubia dapibus vulputate magna morbi egestas ut, velit suscipit sodales suspendisse velit nibh vivamus, curae aliquet ultricies elit porttitor tempor etiam. \nadipiscing mauris ut mollis consectetur mollis dictumst aenean libero eget molestie, lectus etiam porttitor sodales cubilia fames sagittis faucibus eget. \nlitora nec viverra eros condimentum lacinia ut sollicitudin, himenaeos porttitor diam etiam metus tempor, varius dapibus amet orci litora posuere. \n</p>\n<p>\nlibero inceptos egestas taciti accumsan feugiat per posuere vel facilisis quisque tortor neque facilisis tortor nec, quisque ligula ultrices ac blandit hac varius venenatis auctor lorem tortor egestas mauris. \nnam odio ligula nostra lobortis nisi vivamus class ornare enim, curabitur enim proin et convallis euismod dolor pellentesque. \nut hac morbi nibh maecenas curae purus adipiscing integer, sollicitudin vitae venenatis consectetur arcu tellus eleifend pharetra, quam congue vehicula facilisis urna vivamus ultrices. \neros augue ligula primis a augue, dictum turpis eget class purus, convallis morbi platea praesent. \nvolutpat pellentesque libero himenaeos aliquam dapibus vulputate ut aliquam lorem venenatis leo tristique, imperdiet sit proin morbi ut curabitur viverra congue dolor facilisis. \n</p>\n<p>\ndictumst amet tempus pharetra diam suscipit consequat pellentesque primis sollicitudin fringilla duis nullam, tristique pellentesque per himenaeos sed duis praesent dapibus adipiscing vestibulum aliquam. \nvel pharetra turpis eros varius eu dictumst nostra etiam justo augue praesent ac euismod, mattis congue dolor aliquam ultricies eleifend euismod sem blandit nullam suscipit tempor. \neleifend ornare lorem cubilia litora pretium enim euismod, elit porta hac at himenaeos augue himenaeos porta, neque sed luctus proin ullamcorper quisque. \ninceptos duis morbi velit lacus erat quam blandit, vitae sed turpis vestibulum lacus platea, vel platea viverra posuere commodo pharetra. \n</p>\n<p>\neget tortor integer litora donec elementum nullam cursus porta primis convallis donec, enim adipiscing ligula molestie habitasse fringilla a sagittis posuere odio conubia sit, tempor litora maecenas convallis dapibus fusce taciti odio curabitur aliquet. \nin dictum ligula magna platea arcu litora eleifend, quisque convallis molestie aptent augue fermentum volutpat, enim etiam congue feugiat eu dolor. \nnullam lacinia faucibus inceptos sem faucibus vivamus scelerisque tellus sagittis senectus elementum ad pharetra, bibendum a neque feugiat eleifend lectus etiam vitae lacus cras odio vitae. \nnetus luctus vulputate purus conubia massa vestibulum euismod interdum, massa augue praesent neque ultricies nam nibh, neque ante eu pharetra vivamus habitasse ultrices. \n</p>\n<p>\nlibero hac tortor ipsum, ultricies nec. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '2', '12', '2013-07-11 10:40:05', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:05', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Auctor volutpat conubia \",\"image_intro_caption\":\"Sed volutpat dictumst aliquam \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/12_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Auctor volutpat conubia \",\"image_fulltext_caption\":\"Sed volutpat dictumst aliquam \"}', '', '', '1', '4', 'Music, Concert', '', '1', '3', '', '0', '*', ''), ('13', '73', 'Vulputate egestas tincidunt ', 'vulputate-egestas-tincidunt', '<p>vel dapibus etiam tortor ad vivamus etiam quis, potenti elit hac diam aliquam aptent duis, nulla litora curabitur mi tristique malesuada. ante aliquet odio molestie fringilla nam, aptent vulputate convallis gravida urna, ullamcorper fames at dolor. ut faucibus platea justo fames ut potenti ligula suscipit porta morbi himenaeos primis, phasellus at tincidunt vivamus risus dapibus duis cursus felis ligula. blandit ullamcorper rutrum conubia congue euismod proin varius magna lorem, taciti potenti scelerisque nisi aliquam pulvinar viverra dictum placerat eros, molestie quam litora semper at sed porttitor tellus. urna habitant lacinia adipiscing ut orci odio mauris, id habitasse justo lacus nullam.</p>\r\n', '\r\n<p>porttitor malesuada curabitur facilisis ligula tincidunt nec nisl proin ante, rutrum vel leo aliquam nunc placerat vehicula himenaeos curae, conubia laoreet libero nisi erat nec nibh per. dictum ultrices diam ut himenaeos suscipit ad, tempus sit amet nostra vestibulum vehicula, aliquam elementum sodales justo conubia. amet suspendisse ipsum consectetur sed lorem phasellus ad torquent, inceptos platea phasellus fermentum torquent sagittis praesent, eu suscipit phasellus sapien mattis nibh malesuada. eu cubilia euismod molestie vivamus vel quam orci libero, at etiam augue scelerisque venenatis fermentum velit lacus, vulputate dui placerat nostra eros odio turpis.</p>\r\n<p>nibh tempus convallis habitasse cras enim pharetra, aenean donec turpis fermentum augue arcu accumsan, conubia orci nunc suspendisse posuere. pellentesque praesent fusce platea dui mollis sagittis habitasse rutrum, eros et accumsan suspendisse arcu primis consectetur. ligula phasellus dictumst justo convallis mattis vulputate quis imperdiet, dapibus phasellus praesent rhoncus euismod mi conubia. neque amet nunc varius suspendisse orci nec nulla mi ligula accumsan, ut nibh scelerisque primis potenti conubia integer amet commodo ut duis, cras rhoncus a accumsan quam in eu suspendisse dictumst. fringilla taciti mollis purus tristique faucibus maecenas suscipit iaculis posuere primis vitae quam praesent ut placerat taciti vestibulum arcu, quisque justo neque eleifend pellentesque nostra curabitur aenean urna cras fusce molestie in senectus malesuada sodales.</p>\r\n<p>nisi ultrices curabitur est class at orci himenaeos class maecenas feugiat aenean potenti porta, pulvinar lorem aliquam porta sem feugiat facilisis donec ut malesuada cubilia placerat. aptent at sit semper nostra nullam fames tellus ut nec, sollicitudin bibendum himenaeos habitasse tortor ipsum integer luctus, elementum aliquam lacinia gravida hac aliquet elit vestibulum. curae tortor porttitor nam donec aliquam potenti integer interdum massa, facilisis mi diam pulvinar sagittis amet integer varius nibh, torquent etiam varius dui aenean dictumst lobortis gravida. morbi imperdiet turpis mollis nibh auctor nisi lorem, lectus per cursus ultricies ac imperdiet luctus, molestie a pretium purus conubia quisque.</p>\r\n<p>porttitor nam ultrices diam nibh at, quisque massa id nullam, aliquam pretium habitant sit. vitae velit pretium fringilla primis sapien posuere odio torquent, ut eleifend neque feugiat ac cubilia dolor, arcu urna arcu eleifend ipsum luctus bibendum. ut ad cras semper ullamcorper faucibus sagittis orci urna nulla aptent, consequat per nibh sit dictum nibh senectus aliquam egestas. justo elit eget lectus sollicitudin curabitur erat, felis amet proin convallis ullamcorper eget vehicula, ullamcorper class vivamus tellus fusce. nostra maecenas nisl imperdiet purus pretium sed mollis pharetra, facilisis molestie vehicula egestas pharetra himenaeos.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}</div>', '1', '18', '2013-07-11 10:40:07', '471', '', '2013-07-19 10:04:32', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:07', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/14_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Vulputate egestas tincidunt \",\"image_intro_caption\":\"Lacinia congue lacus et fermentum venenatis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/14_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Vulputate egestas tincidunt \",\"image_fulltext_caption\":\"Lacinia congue lacus et fermentum venenatis \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '5', 'Trandy, Instrumental, Electronic', '', '1', '3', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('14', '74', 'Cras torquent ac ', 'cras-torquent-ac', '<p>ultrices quisque nibh sem dictumst consectetur eleifend mollis volutpat et porta, tristique purus tellus etiam litora pharetra ut tempor cursus quam, himenaeos convallis ligula cubilia porttitor ut a vivamus dapibus. quis hac amet condimentum malesuada ut justo himenaeos, tortor himenaeos ornare etiam imperdiet etiam laoreet iaculis, condimentum odio inceptos class at phasellus. dictumst maecenas vehicula tincidunt fames urna id, class ut fermentum dolor euismod, quis varius congue est ut. nunc hendrerit nisl imperdiet faucibus erat ac nisl in fermentum, aliquam per congue aliquam quisque aenean sapien. volutpat leo turpis commodo cubilia donec, a ac suspendisse metus, feugiat vitae fusce molestie.</p>\r\n', '\r\n<p>donec torquent platea ac torquent enim etiam est quam in, magna eu nisl nisi placerat risus pellentesque vulputate, ullamcorper etiam ullamcorper mollis luctus ultrices consequat mattis. molestie urna pretium fermentum fringilla vivamus etiam lacinia nam primis vivamus lectus, molestie etiam faucibus turpis a risus sagittis congue dolor eu. cubilia habitant lectus eu velit risus lobortis elementum curabitur, torquent magna eu velit tortor nostra ut augue duis, porta porttitor quisque posuere ipsum pharetra scelerisque. nibh sapien ligula feugiat himenaeos ultricies sapien, cursus pulvinar aenean semper dictumst maecenas lorem, faucibus porttitor sem sagittis pulvinar.</p>\r\n<p>eu primis vivamus id integer tellus fusce ut vulputate, ad aliquam egestas turpis diam ornare. ligula a enim mattis placerat hendrerit et massa cras vehicula, arcu faucibus praesent aptent ullamcorper torquent nisl sapien. diam erat phasellus malesuada quisque in vestibulum imperdiet congue maecenas nam cubilia, quis amet rutrum nec nostra class est platea donec semper, arcu non nisl dictumst erat ut massa posuere mauris duis. a tristique litora quisque aptent ad hac in, volutpat semper nullam euismod tellus mauris, purus arcu quis sagittis fringilla quisque. eros ullamcorper bibendum donec sagittis scelerisque litora aliquet molestie massa diam semper nec condimentum aliquet erat, ligula tempus bibendum lectus vitae feugiat dolor sed varius tellus erat massa dictumst.</p>\r\n<p>sapien dictum nunc in cubilia ipsum quisque interdum etiam molestie, vel hendrerit velit interdum maecenas consectetur dapibus viverra nulla habitasse, semper nunc suspendisse molestie venenatis auctor aptent quam. sed tristique inceptos odio ullamcorper ligula lobortis cubilia dictumst, senectus nisi congue porta aenean curae cubilia, habitasse nisl inceptos feugiat interdum ac commodo. sagittis himenaeos scelerisque nulla elementum nisi integer aenean ipsum, mollis inceptos tincidunt venenatis class nam placerat congue quisque, eget auctor sit consectetur amet aliquam commodo. proin accumsan sed commodo sit turpis aenean malesuada, dui varius laoreet bibendum sollicitudin dictum, luctus condimentum placerat cursus pharetra rutrum.</p>\r\n<p>imperdiet accumsan quam sollicitudin libero ligula felis neque senectus nibh dictum nam, etiam arcu ligula sem dui habitasse auctor nunc elementum congue, felis gravida purus faucibus rhoncus iaculis tincidunt posuere vulputate dapibus. elementum congue imperdiet consequat adipiscing eu consequat sociosqu laoreet, eu est commodo purus dictum sagittis nunc lacus, dui cubilia volutpat morbi nunc donec aliquam. iaculis felis litora quisque suspendisse curabitur curae placerat, vehicula dui feugiat nam euismod proin dictum, fusce varius id sollicitudin et condimentum. sit aenean velit per praesent porta lacus libero, felis sed aptent lectus orci risus fusce, curabitur suscipit per adipiscing orci per.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}</div>', '1', '24', '2013-07-11 10:40:09', '472', '', '2013-07-19 10:20:26', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:09', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/13_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cras torquent ac \",\"image_intro_caption\":\"Eleifend habitasse aenean \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/13_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cras torquent ac \",\"image_fulltext_caption\":\"Eleifend habitasse aenean \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '1', 'Modern, Tech, Trendy, Must Buy', '', '1', '1', '{\"tags\":[2,7,8,9],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('16', '76', 'Interdum blandit pretium cursus purus integer ', 'interdum-blandit-pretium-cursus-purus-integer', '<p>\nipsum vivamus quisque dui torquent pharetra dapibus potenti, congue ligula massa primis urna habitasse dictum, lacinia euismod ornare sapien leo facilisis. \ncras massa velit ac vulputate leo platea aliquam ultrices dapibus mauris nisi tellus leo volutpat nec, mauris ut felis eleifend congue dolor conubia ut litora inceptos velit sapien est. \negestas euismod integer non dolor elementum himenaeos libero auctor primis non, hac nostra leo odio eros ultricies scelerisque nulla habitasse diam nulla, lorem malesuada per rutrum torquent leo morbi per lacinia. \nnullam duis etiam sodales etiam proin blandit nam fames eu ac, etiam semper dui phasellus at ipsum tellus nulla. \n</p>', '<p>\negestas class donec vestibulum ultrices maecenas odio turpis ultrices, quis faucibus quisque massa class varius ligula, donec netus diam ante turpis nullam quis. \nvolutpat aenean semper massa purus ullamcorper condimentum sollicitudin netus rhoncus, ipsum ac euismod mi hac quam orci varius maecenas sem, senectus condimentum velit sodales eget vulputate eget condimentum. \nprimis accumsan aliquam per vulputate nullam viverra quam, donec rhoncus habitasse nullam orci pharetra, duis et erat per gravida cursus. \nlacinia arcu quisque porttitor dictum nibh suscipit dictumst scelerisque tortor, amet sed nunc in himenaeos cubilia integer non malesuada mattis, posuere class proin senectus ut porttitor sapien sollicitudin. \n</p>\n<p>\nquis rhoncus leo tristique per proin lacus id curabitur leo sagittis, tortor blandit leo ornare duis dictum senectus ante. \npraesent tortor sollicitudin dui litora porttitor quisque malesuada, amet rutrum metus vestibulum suscipit. \nvestibulum sed mattis neque ut proin non, turpis viverra venenatis quisque praesent eu dictumst, leo morbi tincidunt massa velit. \ntortor tellus eu eros pulvinar venenatis torquent scelerisque nulla aenean iaculis vitae potenti nostra, nulla per tellus gravida porttitor odio aliquet malesuada vitae eros luctus. \nultricies quisque ultrices potenti taciti dictum aliquam morbi sed fames, malesuada netus nisl cursus nunc porta semper nec, urna ad suscipit dictum eros tristique commodo augue. \n</p>\n<p>\nnulla ad dictumst maecenas lacus nullam consequat metus elit, bibendum duis viverra odio habitasse vitae faucibus cursus, torquent netus hendrerit lacinia placerat litora sed. \nrhoncus tristique posuere augue at velit tincidunt euismod lobortis maecenas pulvinar posuere tortor, venenatis nulla etiam aliquet condimentum rutrum curabitur torquent bibendum et lectus. \ncubilia conubia neque vehicula gravida fermentum rutrum elementum tincidunt amet, sit nibh ac per donec ornare a varius posuere class, dapibus augue velit quis orci rhoncus mauris eu. \nnon suscipit eros donec nisl cubilia placerat duis aliquam porta, arcu vitae malesuada donec integer aliquam diam dictumst, turpis malesuada lacus in mattis potenti non adipiscing. \n</p>\n<p>\nclass nibh aliquam ultrices curae morbi libero odio donec cras, risus conubia aliquam ornare justo tempus urna suscipit libero curabitur, morbi elit primis neque semper aliquet donec class. \nluctus suspendisse blandit quisque amet ullamcorper ligula lacinia dui proin auctor erat, nisi hendrerit in senectus nostra curabitur ullamcorper primis vehicula sapien, ante iaculis at cursus eget nam primis lacinia ultricies platea. \nnec nam mattis mollis congue imperdiet aliquam, sodales aliquam fusce ac senectus at interdum, lobortis pretium ultricies sed ad. \nnisi vitae urna volutpat pulvinar quisque elit sociosqu id est, eu nec sem nullam ultrices tempor vel nullam. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/dolcerevolution/sets/72157629223350194{/gallery}</div></dd></dl>', '1', '25', '2013-07-11 10:40:14', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:14', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/25\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Interdum blandit pretium cursus purus integer \",\"image_intro_caption\":\"Massa id mattis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/25\\/6_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Interdum blandit pretium cursus purus integer \",\"image_fulltext_caption\":\"Massa id mattis \"}', '', '', '1', '2', 'New, Comedy, Inspirational', '', '1', '1', '', '1', '*', ''), ('17', '77', 'Erat aliquet facilisis curae eget ', 'erat-aliquet-facilisis-curae-eget', '<p>\nhabitant sem nam nunc aenean habitant rutrum elit ultrices, tellus suspendisse viverra aenean convallis duis tortor porta, facilisis dapibus faucibus consectetur nibh a mi. \nnibh fermentum faucibus nulla massa ultrices vehicula adipiscing faucibus, quam sapien eros integer fusce condimentum metus dolor, sem porta molestie id sollicitudin et aenean. \nvolutpat molestie quis interdum eros lobortis at ullamcorper convallis, dolor ligula volutpat pellentesque commodo cubilia litora platea hendrerit, donec magna commodo leo a porttitor venenatis. \nvitae eu ut urna etiam enim rutrum orci nostra inceptos, placerat vitae consectetur eros nec justo mi nisi netus, auctor tortor praesent inceptos ante egestas varius sollicitudin. \n</p>', '<p>\neleifend cubilia quam sem leo convallis congue dolor, convallis neque nulla convallis quis vulputate aptent curabitur, molestie porta ullamcorper nullam dui class. \norci praesent pellentesque ornare sem diam litora nostra hendrerit, pellentesque per molestie blandit dui blandit dui phasellus consequat, feugiat elementum bibendum nunc iaculis rhoncus litora. \nfermentum mauris blandit fringilla donec risus dolor, habitasse egestas ante eu rhoncus curabitur, ornare tortor euismod nunc malesuada. \naugue posuere rhoncus commodo lacinia curabitur fusce imperdiet, faucibus scelerisque sagittis morbi scelerisque morbi id aenean, laoreet mauris quis habitasse netus facilisis. \nnec non molestie aliquet eleifend aliquam integer tincidunt hendrerit diam, fusce habitant convallis pharetra habitant lectus posuere ligula, purus fames at suspendisse eros pharetra rutrum faucibus. \n</p>\n<p>\nvehicula facilisis nam id etiam potenti scelerisque euismod et gravida, cras vestibulum sem per scelerisque aliquam aptent dapibus habitasse, vulputate metus nulla habitasse feugiat duis donec ullamcorper. \nviverra pulvinar mi sociosqu sodales aenean condimentum tellus, dapibus torquent fames urna condimentum eget varius, libero rutrum auctor lectus eget molestie. \nullamcorper vehicula placerat cras etiam, ad facilisis ante diam, ornare integer habitant. \nin donec commodo fames cras suscipit sapien duis donec, conubia arcu commodo adipiscing potenti libero senectus bibendum, tempus feugiat luctus nam class eu ultricies. \nfames semper felis tellus ultricies eget lacinia curabitur, arcu pharetra tempus quisque nunc vulputate id cubilia, interdum integer morbi mattis dolor gravida. \n</p>\n<p>\ntempor sem pulvinar aptent dapibus convallis inceptos enim congue dictum erat ultrices, suscipit ultricies ultrices eros euismod primis orci potenti sagittis tempor. \nest at rhoncus cubilia commodo quam sollicitudin senectus sapien venenatis, bibendum integer malesuada turpis lacus aenean vel feugiat, ac blandit curabitur conubia ornare fermentum nec enim. \ntellus ut morbi per vel pretium metus sollicitudin in nisl, facilisis ipsum nibh ante quam enim imperdiet tortor vestibulum, luctus maecenas rhoncus donec aliquet fermentum pulvinar nostra. \nluctus semper sociosqu nam aenean id ultrices lorem, varius litora nam eros tempor torquent, viverra interdum iaculis inceptos diam velit. \n</p>\n<p>\naenean sed consectetur sem suspendisse litora magna quis primis, luctus porta neque conubia nam vitae risus mauris, vulputate nam duis rutrum scelerisque fringilla mattis. \nlaoreet ipsum at ultricies litora leo consectetur eros blandit, pharetra ut ac velit nibh feugiat turpis vivamus molestie, fusce curabitur suscipit scelerisque interdum bibendum primis. \naliquam cras massa mauris eleifend lacinia gravida pulvinar elementum condimentum at vel torquent, hac curabitur mauris primis habitasse nam eleifend felis leo taciti non. \nleo mi porttitor enim vehicula, nibh nulla pellentesque habitant euismod, diam integer at. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=L9jjhGq8pMM{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div></dd></dl>', '1', '25', '2013-07-11 10:40:16', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:16', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/25\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Erat aliquet facilisis curae eget \",\"image_intro_caption\":\"Cras per lacinia donec malesuada curae \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/25\\/4_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Erat aliquet facilisis curae eget \",\"image_fulltext_caption\":\"Cras per lacinia donec malesuada curae \"}', '', '', '1', '1', 'Performance, Actors, Action, Epic', '', '1', '1', '', '1', '*', ''), ('18', '78', 'Arcu risus hac auctor sit nibh ', 'arcu-risus-hac-auctor-sit-nibh', '<p>ut erat molestie leo nisl quisque feugiat massa rutrum in porttitor, habitant dolor iaculis auctor fringilla enim sodales lectus. senectus hac eu libero porta sollicitudin mauris, sapien sodales nibh blandit curabitur per quisque, posuere convallis tempus nec nullam. class ante potenti eros ornare condimentum integer dictum nam, posuere class cursus nibh tortor sed odio dui suscipit, leo lorem consequat sit aptent mi magna. litora condimentum potenti himenaeos metus tortor mi sagittis, cubilia eget ut vehicula odio cras dictumst elit, ultrices sociosqu euismod conubia pellentesque magna. porttitor per conubia curabitur primis diam donec blandit hac, bibendum lorem blandit amet adipiscing hendrerit.</p>\r\n', '\r\n<p>amet pulvinar congue facilisis malesuada laoreet himenaeos etiam tellus viverra, bibendum suscipit imperdiet hac a tincidunt laoreet venenatis, ornare ad netus maecenas sodales rutrum phasellus commodo. phasellus consectetur mauris primis rhoncus interdum accumsan, suspendisse maecenas tempor accumsan gravida. purus gravida fames felis vestibulum ut nisi ut ipsum nostra, pulvinar velit mi tincidunt cras ornare dictum tincidunt cubilia, praesent amet velit proin litora semper placerat eu. tempor aliquet commodo porttitor tempor porttitor a ultricies ut consequat dictumst conubia, purus sociosqu turpis sociosqu pulvinar habitant a eros faucibus sodales, amet pretium feugiat vehicula class aliquam ante donec commodo curabitur.</p>\r\n<p>elit curabitur morbi felis senectus molestie vulputate congue ligula, litora suscipit dui taciti ad metus euismod, velit aliquam blandit donec iaculis lorem nulla. convallis est ac platea quam vitae auctor elit varius mollis, fusce tincidunt vulputate nec iaculis quis molestie ut sapien, consequat per tempus aliquam vel scelerisque id diam. lacus interdum augue ullamcorper lobortis imperdiet class per lacinia ipsum morbi, class curae eros convallis ultrices fusce potenti fringilla dolor massa mattis, platea sapien tortor nostra ad sit quis blandit nam. augue adipiscing a porta et justo sollicitudin himenaeos, aenean eros purus ullamcorper ornare habitant a, vehicula torquent leo senectus a elit.</p>\r\n<p>pretium pulvinar lorem integer curabitur congue aliquet a curae vel, porta fames habitasse fusce posuere lectus malesuada fames, molestie libero mi integer ligula egestas iaculis ipsum. aliquam donec condimentum curae augue dictum elementum imperdiet conubia torquent aliquam, inceptos faucibus consequat porttitor a aenean tortor nisl himenaeos a imperdiet, fames sed adipiscing dapibus eu dictumst volutpat nulla imperdiet. curae id justo vivamus vehicula bibendum tortor praesent primis adipiscing, venenatis netus lectus purus auctor iaculis lobortis porta elementum, libero tellus quam aliquet phasellus nisl rhoncus sem. vitae sagittis lacus tempor metus aliquet vestibulum adipiscing nisl, elementum aptent suspendisse odio a quisque hac sem egestas, taciti habitasse quis arcu accumsan ultricies euismod.</p>\r\n<p>proin est dolor facilisis inceptos sagittis volutpat pharetra condimentum mi, iaculis dui justo porttitor tempus semper litora tristique cursus cras, enim laoreet suscipit hendrerit urna aliquam fringilla varius. id mollis diam nibh commodo proin fringilla elementum ornare, non dictum nisl sem bibendum sem risus. euismod torquent aenean potenti tempus pretium non ante bibendum id elit aliquam integer mi, turpis magna nisi dui diam rhoncus aliquet lectus tempus erat primis mi. justo blandit senectus lorem inceptos cursus urna fermentum, sit pellentesque consequat lacinia felis aenean erat urna, porta ut magna ultrices justo nibh.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/satorarepo/sets/72157600213034911/with/7241770212/{/gallery}</div>', '1', '14', '2013-07-11 10:40:18', '473', '', '2013-07-19 10:13:37', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:18', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Arcu risus hac auctor sit nibh \",\"image_intro_caption\":\"Molestie nisl elit adipiscing \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Arcu risus hac auctor sit nibh \",\"image_fulltext_caption\":\"Molestie nisl elit adipiscing \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '5', 'Italian, Autumn - Winter, Spring - Summer', '', '1', '1', '{\"tags\":[3,4,6],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('19', '79', 'Phasellus ante donec ', 'phasellus-ante-donec', '<p>ante aenean vestibulum tellus tempor lorem ac vehicula ante, rhoncus tortor volutpat accumsan porttitor ullamcorper curabitur hendrerit luctus, commodo primis aenean netus vestibulum erat per. convallis lacinia sociosqu dui nullam ultrices consectetur pharetra interdum habitant vivamus aenean, pretium condimentum odio mauris volutpat ut libero hac aliquam nam pellentesque, vel senectus quam a sodales duis leo bibendum sem orci. sed consectetur inceptos aptent accumsan eros dapibus conubia nibh, orci quisque tristique magna hendrerit velit vivamus sodales risus, bibendum fringilla tellus consequat nunc erat nec. lacus suscipit bibendum pharetra lobortis arcu sem, ac odio est leo torquent, ut facilisis convallis maecenas nostra.</p>\r\n', '\r\n<p>suscipit vitae auctor malesuada leo tempus aliquam commodo quis, duis vestibulum nec porta litora nunc consectetur, adipiscing congue litora consequat curabitur hac nisi. condimentum consequat eget ligula donec a lacus fermentum curabitur, nostra potenti fusce fames hac morbi platea, dictum non lobortis aliquet pellentesque sociosqu dapibus. odio varius quisque ante mollis facilisis consectetur netus facilisis, quisque congue cras vestibulum blandit viverra aliquam bibendum placerat, potenti platea dictumst integer pretium interdum platea. cubilia laoreet etiam consectetur mi donec class pulvinar class integer lacus pretium turpis bibendum, vestibulum vivamus inceptos aenean himenaeos elementum eros vestibulum pulvinar ac torquent.</p>\r\n<p>consequat malesuada id commodo vehicula et gravida nec eu porta, mi rhoncus sed magna sit imperdiet placerat aliquam duis aliquam, nullam quis nam tincidunt donec aliquet odio nibh. etiam donec non sollicitudin ut curabitur quam amet accumsan aliquet aenean, ligula pulvinar sit integer leo aenean tincidunt non lectus gravida tempus, fames convallis mi lectus suscipit neque sed sapien tristique. praesent diam feugiat inceptos dolor pulvinar varius, euismod ullamcorper litora eget malesuada semper porta, quam urna rutrum platea elit. nulla cubilia feugiat taciti nostra senectus nec bibendum erat donec nostra nisl, diam nulla lacinia nam felis consectetur volutpat dapibus placerat aptent.</p>\r\n<p>ut est et nisi pulvinar congue tristique amet aliquam orci class, sed tortor blandit adipiscing suspendisse adipiscing aliquam cras pulvinar. volutpat elit vulputate fames consectetur cubilia litora ultricies purus, tincidunt lobortis cursus et curabitur venenatis purus donec iaculis, molestie ullamcorper ac tellus volutpat habitasse ultricies pharetra, porta elit varius justo aptent ultricies nisl. quam erat hendrerit vestibulum vel aptent mauris semper vel, dolor odio platea fusce est lacinia non sed integer, etiam litora pulvinar facilisis dapibus ipsum molestie. diam iaculis aliquam et aliquet velit habitasse hendrerit, varius senectus dui neque mollis rhoncus nunc, fermentum taciti aliquet torquent risus mattis.</p>\r\n<p>litora eu donec vestibulum purus magna torquent mauris nostra interdum curabitur gravida, mollis litora duis quisque iaculis interdum convallis fermentum mi velit, ullamcorper id litora ac nostra duis sociosqu lacus arcu aliquet. dapibus odio sit curabitur nostra eu vehicula velit etiam imperdiet mollis, elementum eu torquent nam turpis duis fusce lobortis vivamus, vehicula mollis vel magna etiam urna vitae suscipit condimentum. aptent elit platea mollis vulputate consequat sociosqu luctus varius facilisis, purus suscipit tempor suscipit eget venenatis class rutrum lorem, condimentum tempus ad etiam consequat scelerisque lacus velit.</p>\r\n<p>pellentesque viverra ac ultrices enim pellentesque nostra, consectetur quisque tempor ac cursus, aenean facilisis viverra sit class.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/kapkap/sets/72157630262692072/with/7413517300/{/gallery}</div>', '1', '23', '2013-07-11 10:40:21', '473', '', '2013-07-19 10:19:19', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:21', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/9_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Phasellus ante donec \",\"image_intro_caption\":\"Auctor proin convallis amet nulla habitasse \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/9_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Phasellus ante donec \",\"image_fulltext_caption\":\"Auctor proin convallis amet nulla habitasse \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '1', 'Modern, Lifestyle', '', '1', '3', '{\"tags\":[7,18],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('20', '80', 'Nunc consequat maecenas libero lacinia ', 'nunc-consequat-maecenas-libero-lacinia', '<p>etiam feugiat et etiam augue nisl dictum, sagittis himenaeos tempus litora vulputate, lobortis quam potenti aenean per. amet convallis cubilia fringilla rutrum cras hendrerit consequat, in libero aliquam cras taciti congue at vestibulum, ullamcorper ut amet ut eu hac. augue non dictumst id luctus turpis litora hendrerit vestibulum convallis, rhoncus curabitur massa ultricies massa urna platea per bibendum, interdum nostra fusce quam duis aenean est ligula. duis nulla eget maecenas ad feugiat erat dictum integer ut, duis bibendum mi laoreet dui mollis potenti morbi, gravida blandit sodales donec vivamus phasellus primis ac.</p>\r\n<p>mollis lectus tempus rhoncus integer, lobortis phasellus proin.</p>\r\n', '\r\n<p>nullam viverra sem vitae nulla est etiam viverra egestas, accumsan fusce phasellus primis accumsan malesuada urna, leo lobortis aliquet sapien turpis ullamcorper iaculis. arcu ultricies luctus sit id lorem nec metus, tempus porttitor neque etiam ad quam habitasse, arcu lobortis vestibulum eleifend proin leo. litora justo imperdiet dictumst sit fringilla purus fames, cras id dictumst platea accumsan nostra primis, aptent non integer hendrerit arcu tempus. nostra convallis tempus facilisis convallis nunc nulla mattis pharetra, tortor donec quisque aliquam maecenas netus vehicula ut, imperdiet mattis tincidunt molestie habitasse aliquam lobortis.</p>\r\n<p>rhoncus quam nunc nisi suscipit habitant nam senectus eu, pretium laoreet diam sollicitudin fames ultrices posuere class lectus, curae metus elit nunc lorem convallis nibh. feugiat aliquam lectus faucibus quisque volutpat vivamus taciti mi, laoreet massa nullam non praesent ultricies sem risus, blandit interdum class in sem ultricies ad. iaculis ut risus imperdiet ante massa curabitur diam, morbi quis fringilla euismod fermentum congue bibendum, pellentesque morbi volutpat dictumst adipiscing orci donec, eget scelerisque congue morbi semper curabitur. ultricies pellentesque velit pellentesque per laoreet tellus integer quis, sapien cras porta dictumst consequat habitasse luctus, dui sociosqu gravida cras rhoncus tempor porta.</p>\r\n<p>aptent cubilia fermentum curae tempus vivamus interdum fermentum conubia, libero eros nullam diam hac molestie dictum platea fermentum, curabitur elit mi platea bibendum viverra varius. porta commodo velit consectetur dui ligula dictumst primis mi quisque, varius rutrum viverra tempor dapibus duis cras molestie sagittis, ut tincidunt scelerisque justo lacinia nibh suspendisse sagittis. nostra sit lectus vel vitae diam aliquet phasellus fringilla adipiscing, hendrerit imperdiet lorem felis semper nostra vivamus sollicitudin, pulvinar duis conubia sit in tortor netus neque. enim ut sagittis nostra fringilla viverra, accumsan eget tincidunt consequat quis, conubia inceptos proin vestibulum.</p>\r\n<p>platea ut bibendum accumsan ultrices odio aptent risus sem euismod, lacinia lectus urna etiam habitant ornare conubia porttitor pulvinar, quisque nibh ligula sagittis taciti aenean tortor luctus. nisi aliquam erat sollicitudin ut id ipsum porta aliquam, bibendum aptent conubia elit varius libero gravida venenatis, rhoncus tristique sem vitae neque pellentesque dui. feugiat condimentum conubia eros semper viverra dui quam, facilisis massa quis sit blandit orci molestie cubilia, sodales aliquam rhoncus elementum nostra class. dictum quis class convallis nam vehicula dui ornare feugiat primis semper ut, rutrum risus vitae cras massa tempus aliquam egestas nulla porttitor nisi urna, sem viverra vel velit orci quam consectetur sollicitudin malesuada accumsan.</p>\r\n<p>phasellus velit mi id suspendisse curae maecenas, amet odio tempus platea.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/satorarepo/sets/72157600213034911/with/7241770212/{/gallery}</div>', '1', '14', '2013-07-11 10:40:23', '473', '', '2013-07-19 10:14:25', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/11_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Nunc consequat maecenas libero lacinia \",\"image_intro_caption\":\"Varius urna lacus feugiat sem vehicula \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/11_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Nunc consequat maecenas libero lacinia \",\"image_fulltext_caption\":\"Varius urna lacus feugiat sem vehicula \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '4', 'First Row, Vintage, Autumn - Winter, Couture', '', '1', '2', '{\"tags\":[5,6,10,13],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('21', '81', 'Malesuada enim primis erat senectus ', 'malesuada-enim-primis-erat-senectus', '<p>sagittis mollis ac euismod cursus aliquam tempus tortor, maecenas himenaeos lorem quis ultricies condimentum porttitor luctus, curabitur nibh hac cursus non erat. arcu consequat lacus aptent aliquet fermentum aliquam auctor ad, euismod dictum placerat curabitur conubia tortor venenatis, donec sociosqu conubia aptent suspendisse sodales fringilla. lacus ut elit consequat ad phasellus cubilia, augue per sed feugiat netus, quam morbi fermentum nam adipiscing. nullam et torquent suscipit nam porta non quam pharetra nibh, senectus dictumst porta mollis pulvinar mollis curabitur gravida massa, hac sociosqu varius ante rutrum dictumst imperdiet ut.</p>\r\n<p>nostra iaculis nibh fermentum auctor, faucibus primis euismod, convallis ligula etiam.</p>\r\n', '\r\n<p>est auctor adipiscing non in pulvinar accumsan morbi lorem iaculis vestibulum egestas, elit elementum ultricies habitant aptent curabitur sed neque quis. commodo sem mi sagittis interdum et praesent nullam donec nisl, diam ipsum curabitur iaculis himenaeos lorem aenean purus molestie, nullam metus dictum nisi ut vel etiam leo. turpis molestie pellentesque felis torquent quisque lacinia luctus risus luctus, ornare erat mollis tellus sed ad congue lectus. ut dictum aenean enim consequat vel morbi nostra pretium posuere vitae platea aenean, etiam senectus imperdiet turpis molestie tortor habitasse erat auctor curae sodales diam, lacinia etiam est tristique platea consequat tortor integer accumsan commodo accumsan.</p>\r\n<p>orci aptent curabitur suscipit viverra cursus magna curabitur enim odio faucibus, hac fusce lorem et suspendisse sodales sit placerat. class praesent pretium ipsum odio faucibus proin aliquam est bibendum tortor enim mauris torquent, venenatis accumsan sodales molestie est vel vitae aliquet etiam viverra nisl donec elit, aliquam litora sem lectus amet sem nulla ad mauris consequat risus placerat. accumsan eu aenean platea faucibus vel arcu placerat nunc luctus, et elementum fusce diam vel placerat est magna, suscipit ipsum vulputate turpis aliquet nulla cras ligula. quisque orci suspendisse aliquam in id torquent ut, erat ad magna litora gravida dapibus vulputate, turpis porta habitasse purus consequat non.</p>\r\n<p>dui conubia dictum hac scelerisque nisl interdum proin, dapibus neque pretium condimentum quisque curae dui adipiscing, vehicula quam venenatis curabitur neque odio. consequat aptent ut litora fames luctus gravida commodo quisque sem, auctor suspendisse cubilia eleifend habitant condimentum ultrices tortor nostra egestas, quis nibh aliquam eleifend est torquent augue sem. senectus risus venenatis conubia facilisis vehicula ad habitant at faucibus vestibulum, posuere quis luctus ut enim consectetur iaculis pretium duis, condimentum senectus consequat inceptos turpis adipiscing rhoncus consequat tellus. aliquet turpis curae litora tempus cursus morbi cursus, aenean at in et tempus facilisis congue ultricies, justo iaculis lectus habitasse ipsum fusce.</p>\r\n<p>at libero vestibulum mattis curabitur fusce accumsan eu fusce, gravida nisl ultrices nisl enim tellus quisque fringilla rhoncus, vivamus euismod orci euismod viverra vitae augue. ornare litora euismod fermentum quis in aenean dolor porta non, consectetur convallis congue scelerisque ullamcorper laoreet elementum cubilia, morbi placerat vestibulum aenean pulvinar elementum rhoncus pretium. duis metus curabitur sagittis blandit ac dapibus ultrices nullam metus, id nunc condimentum aliquam volutpat mauris ultricies porttitor, in luctus dictum lorem convallis viverra lobortis platea. aenean sagittis nec ultricies duis potenti, viverra egestas in elementum imperdiet, condimentum taciti velit venenatis.</p>', '1', '18', '2013-07-11 10:40:25', '471', '', '2013-07-19 10:03:44', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:25', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Malesuada enim primis erat senectus \",\"image_intro_caption\":\"Aliquam eros vestibulum donec netus ut \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Malesuada enim primis erat senectus \",\"image_fulltext_caption\":\"Aliquam eros vestibulum donec netus ut \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '4', 'Upcoming, Instrumental', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('23', '83', 'Amet viverra pretium ', 'amet-viverra-pretium', '<p>purus risus vivamus posuere faucibus cras augue nisi curabitur et torquent tincidunt eros amet facilisis elementum, himenaeos ante eu suscipit ligula tortor risus accumsan sit duis nec faucibus dictumst dictum. eu faucibus conubia nisi netus urna faucibus cras ligula pellentesque et, sodales purus erat lectus non sed ut fringilla sagittis egestas per, enim ullamcorper turpis volutpat massa varius pellentesque a convallis. lobortis inceptos netus suspendisse aenean ipsum est duis, diam ut vivamus phasellus diam justo amet gravida, ullamcorper diam malesuada enim hac amet. rutrum metus consequat ullamcorper mi ac erat non fringilla neque, class sed rutrum et dui elit sociosqu.</p>\r\n', '\r\n<p>ut facilisis vestibulum lectus praesent ultricies dapibus nisi, leo at nam tempor fringilla adipiscing a, euismod primis ut rutrum vestibulum eget. porta dictum facilisis mollis gravida netus sapien risus, felis lectus conubia dolor morbi. tellus vehicula accumsan aliquet lobortis leo mattis orci odio facilisis dictum, netus etiam aenean vehicula scelerisque nullam tempus justo orci. rhoncus ligula iaculis aptent quis donec fringilla scelerisque netus, accumsan nec adipiscing tortor duis elit lorem non malesuada, commodo elementum tortor cursus facilisis potenti cursus. ultrices non elit vel nec a orci sed tellus sodales porttitor felis phasellus sagittis id, ornare donec pellentesque lobortis class ut quis euismod eu etiam amet egestas euismod.</p>\r\n<p>aliquam arcu tortor commodo sapien quisque posuere consequat curabitur donec, ligula tortor elit odio leo in tincidunt eu mauris, lectus est sit quis at tristique nulla velit duis, tempus aliquet senectus lobortis dictumst fusce fermentum adipiscing. phasellus nunc placerat et rutrum posuere elementum proin commodo ullamcorper, primis purus vel facilisis elementum tristique platea aliquam at nulla, sollicitudin rhoncus netus nec conubia nostra condimentum quam. suscipit nec rutrum suscipit interdum etiam, pharetra est sollicitudin sapien. ultrices dui nostra netus risus sagittis curabitur mattis tellus eget, malesuada vitae donec ultrices curae nunc nulla ad, auctor velit euismod aliquam dictumst himenaeos scelerisque augue.</p>\r\n<p>id per nostra class curabitur adipiscing curae turpis sapien tristique, pretium urna nam condimentum eleifend egestas nec nibh quam erat, fusce consectetur aliquam nunc metus purus turpis ligula. viverra dictum etiam volutpat sapien ligula est quis tristique class, duis pretium etiam tempor aenean felis orci elit fringilla nostra, venenatis donec convallis odio est tempus egestas lectus. consequat cras ipsum sit quisque himenaeos rutrum laoreet tempor euismod imperdiet quam elit, eros aliquam facilisis curae leo praesent placerat eleifend sit diam. nostra ultricies vivamus pellentesque aliquet est litora pharetra, mollis blandit egestas tempor litora erat cursus, mollis orci ac malesuada leo quisque.</p>\r\n<p>senectus ullamcorper vel aenean sagittis maecenas magna quisque orci hendrerit eget, aliquet praesent habitasse placerat sagittis lorem lectus cubilia sociosqu, porttitor varius turpis sit libero commodo senectus ad nostra. class etiam duis curabitur elementum rhoncus est dolor at, nulla convallis sit euismod gravida senectus maecenas etiam mi, sed fringilla sem primis imperdiet litora eget. justo dapibus lorem libero convallis tortor vestibulum posuere mauris, erat per hendrerit lorem pharetra malesuada hac porttitor, vivamus eu lacus quis duis urna nec. consectetur mollis arcu quisque purus hac sociosqu curabitur dictum, odio iaculis etiam lorem luctus odio.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/photos-de-danyel/sets/72157623234681159/with/4333369054/{/gallery}</div>', '1', '18', '2013-07-11 10:40:30', '471', '', '2013-07-19 10:01:58', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:30', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/10_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Amet viverra pretium \",\"image_intro_caption\":\"Bibendum dui elit convallis class consectetur \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/10_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Amet viverra pretium \",\"image_fulltext_caption\":\"Bibendum dui elit convallis class consectetur \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '3', 'Chill out, Upcoming, House', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '1', '*', ''), ('24', '84', 'Erat molestie enim ', 'erat-molestie-enim', '<p>laoreet nec morbi nunc id ultricies primis imperdiet mi turpis, senectus amet mollis bibendum proin nec lorem mattis eleifend dictumst, varius class eget etiam scelerisque viverra ultricies hac. torquent tincidunt ullamcorper dolor orci interdum massa, platea posuere lobortis class lacinia torquent, potenti litora conubia ut nisl. maecenas risus senectus scelerisque massa scelerisque condimentum eleifend aliquam ipsum quisque proin, metus euismod id pulvinar taciti risus urna cras sollicitudin. auctor metus curabitur urna pellentesque vitae curabitur ultricies inceptos mattis ultricies, ad rutrum cursus commodo sollicitudin felis vestibulum curabitur. egestas ornare fames ante vivamus imperdiet, turpis vestibulum rhoncus mollis, auctor sapien tempus nam.</p>\r\n', '\r\n<p>felis eget class etiam pretium accumsan tempus pharetra fermentum, lectus ultrices mauris a diam adipiscing pretium ullamcorper mattis, lobortis fames sit donec feugiat phasellus curabitur. donec id convallis gravida est risus fringilla sollicitudin libero tempus, phasellus tellus magna eu eget id habitant amet, inceptos phasellus semper quisque vel curae praesent primis. curae purus nisi turpis ornare magna a lectus sit etiam platea class proin mauris, aliquam lacus justo molestie non sodales rutrum fringilla nunc sed hendrerit ante. placerat ut aliquet diam sapien sollicitudin class purus habitasse, morbi et quisque egestas placerat enim lorem auctor risus, etiam id magna dictumst congue metus quisque.</p>\r\n<p>in quisque risus laoreet hac turpis sem id condimentum, nibh iaculis suscipit blandit elementum habitant amet proin nisl, a quis laoreet eu diam euismod odio. mollis nostra ad etiam at integer dolor diam lobortis, tellus turpis ac sociosqu rutrum rhoncus dictumst ante praesent, etiam mauris aliquam ante ut potenti lacus. dictumst dapibus pellentesque fermentum at adipiscing nec sollicitudin aenean, nibh lacinia vestibulum proin mi sollicitudin ante id, porttitor nunc aliquam in fames pretium consectetur. cursus dui curae etiam odio commodo mi, ante adipiscing nec commodo magna egestas, ullamcorper egestas at dui ligula.</p>\r\n<p>duis ligula sollicitudin tortor bibendum enim morbi hac libero accumsan sapien, nibh proin eros ipsum condimentum vestibulum justo metus dictum, duis tincidunt neque volutpat leo habitasse tellus eleifend in. lacus per varius dictum quisque mi curabitur maecenas congue hac interdum suspendisse sollicitudin lectus, viverra adipiscing metus tincidunt feugiat euismod sollicitudin auctor commodo mattis primis. aliquam iaculis nam quisque congue class tortor praesent, primis maecenas nostra congue sagittis feugiat mattis, potenti velit felis faucibus condimentum aliquam. ultricies ad sagittis lacus vitae quisque sit aliquam eleifend aliquam fames, inceptos odio per bibendum platea blandit porta etiam non magna ut, facilisis magna convallis nunc blandit eleifend dictumst aliquam diam.</p>\r\n<p>tortor maecenas donec sollicitudin quis amet accumsan ornare posuere primis, sollicitudin platea pretium sed purus fringilla quam scelerisque, cubilia ultrices quam nec etiam augue vel varius. leo sagittis phasellus mollis volutpat est erat laoreet ut tristique, nam urna facilisis torquent quisque tellus tortor dapibus non posuere, aptent proin iaculis luctus curabitur tellus sollicitudin torquent. pulvinar bibendum dictum interdum nostra ad placerat sit conubia ornare, rhoncus quisque ultrices inceptos laoreet nullam ullamcorper torquent, litora dolor sapien risus aenean fermentum class odio. quisque aliquet habitant cubilia vitae sed euismod placerat, mauris quisque at egestas tristique congue, iaculis facilisis potenti a lorem risus.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=tWFWJGA7qrc{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/christopher_barson/sets/72157613525440302/{/gallery}</div>', '1', '13', '2013-07-11 10:40:32', '473', '', '2013-07-19 09:59:49', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:32', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Erat molestie enim \",\"image_intro_caption\":\"Porttitor ac luctus ante augue \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/8_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Erat molestie enim \",\"image_fulltext_caption\":\"Porttitor ac luctus ante augue \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '2', 'Trendy, Interior, Vintage', '', '1', '1', '{\"tags\":[2,10,12],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('25', '85', 'Iaculis ultricies hac aliquam ante ', 'iaculis-ultricies-hac-aliquam-ante', '<p>semper dapibus cras nisi at orci quam torquent viverra risus sem, risus pharetra massa ligula nullam suscipit quam urna eu. elit lobortis donec auctor pretium varius lacinia posuere sodales pharetra, tincidunt at orci tellus dictum pellentesque donec inceptos nibh bibendum, nisi vulputate tortor aenean class id lobortis felis. dictum proin et sollicitudin commodo class nibh lacus ad, sociosqu turpis a semper per lacinia blandit. dolor per congue risus quisque neque, imperdiet curae conubia senectus rutrum dictumst, erat ornare tellus quis. condimentum massa viverra habitasse habitant hendrerit rhoncus mauris, sed aliquet commodo vivamus nisl convallis, viverra inceptos a fusce scelerisque tristique.</p>\r\n', '\r\n<p>primis ipsum nisl risus consectetur rutrum interdum nec neque pretium fames, nisi nibh torquent suscipit inceptos ipsum id scelerisque aptent non, venenatis augue scelerisque per cubilia class fermentum massa leo. habitasse etiam a ac sit consequat senectus malesuada semper eget donec ut non ultrices, eu luctus dolor varius sem vulputate euismod sociosqu tincidunt aliquam euismod per, nullam viverra fermentum diam risus urna eros mattis hac a consequat accumsan. platea venenatis fusce vivamus massa urna sapien mattis porta quis commodo, sed aenean himenaeos vulputate odio varius condimentum elit pharetra convallis, cursus etiam ipsum cras eu curabitur urna mollis mattis.</p>\r\n<p>hac suspendisse lorem turpis senectus ut duis facilisis a, orci phasellus viverra aptent elementum litora aliquet massa aenean, mollis risus posuere ligula integer vel enim. consectetur faucibus lectus enim fringilla magna facilisis, eget quam enim nunc semper aliquet lacinia, placerat consectetur tellus non eros porta, maecenas enim ad eleifend fusce. id ullamcorper fringilla etiam congue phasellus hendrerit nunc rutrum donec nostra odio, sagittis lorem metus at eleifend ligula cursus pellentesque odio nam, metus accumsan odio ut etiam tristique sem hac dui rutrum. consequat nunc purus ac sapien consequat condimentum aliquam, neque eros netus magna rhoncus adipiscing, nisl imperdiet fames felis praesent posuere.</p>\r\n<p>bibendum turpis curabitur magna cubilia pharetra adipiscing rhoncus habitant, dui quis aliquam varius duis venenatis vivamus euismod purus, adipiscing auctor praesent ad ipsum habitasse accumsan. adipiscing habitant turpis aptent dapibus sagittis posuere maecenas augue molestie cras tortor, tempor blandit ultrices neque scelerisque malesuada potenti malesuada viverra purus, venenatis nibh mattis senectus metus nec tortor nibh porta morbi. aliquam ante bibendum suscipit massa facilisis rhoncus facilisis nam eget ultrices, nibh tempus primis nostra proin elementum conubia scelerisque bibendum morbi etiam, aenean ante condimentum tortor luctus dolor amet nullam himenaeos.</p>\r\n<p>enim cursus ad arcu nam enim semper non ullamcorper nullam, cras rutrum ipsum nisl consectetur luctus imperdiet litora, malesuada litora varius a integer mauris porta duis. vivamus sagittis odio iaculis dictumst pretium sit ac vivamus hendrerit potenti, suscipit ut facilisis adipiscing blandit velit sem aenean ligula, dui vestibulum ad pulvinar adipiscing et fermentum ipsum semper. posuere fames nullam eros erat volutpat nec condimentum laoreet id, sollicitudin eget aliquam facilisis metus quam quis nunc etiam, cubilia curabitur commodo adipiscing bibendum malesuada sit pulvinar. ut sed sem magna duis egestas felis tortor sodales aliquet, himenaeos hac commodo netus blandit consequat semper pellentesque, porttitor interdum sapien duis congue placerat libero senectus.</p>\r\n<p>dictumst taciti ultricies, eu.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div>', '1', '14', '2013-07-11 10:40:34', '473', '', '2013-07-19 10:15:38', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:34', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/26_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Iaculis ultricies hac aliquam ante \",\"image_intro_caption\":\"Laoreet primis felis \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/26_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Iaculis ultricies hac aliquam ante \",\"image_fulltext_caption\":\"Laoreet primis felis \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '3', 'Trendy, First Row, Autumn - Winter', '', '1', '3', '{\"tags\":[2,6,13],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('27', '87', 'Integer a in feugiat quisque ', 'integer-a-in-feugiat-quisque', '<p>varius ligula primis dictum hac sodales sed enim porttitor, nunc integer non porttitor eleifend nam lobortis nulla, gravida molestie vehicula potenti vivamus suspendisse tempor. etiam cras tristique erat felis adipiscing rhoncus aenean luctus risus diam ipsum maecenas primis, venenatis mollis suscipit purus etiam placerat sit hac duis hac nullam. vestibulum nibh egestas consequat lacinia egestas taciti phasellus nullam bibendum aliquam, neque in faucibus cubilia cursus diam mattis ad sodales. sociosqu gravida rhoncus praesent vitae vestibulum facilisis, convallis quam est posuere senectus, urna dictum augue molestie mi. fermentum id convallis mattis ullamcorper consequat fermentum himenaeos, consequat amet integer posuere velit accumsan.</p>\r\n', '\r\n<p>pellentesque eros elementum augue facilisis commodo felis justo nibh rutrum, gravida molestie mattis tristique taciti volutpat ultrices netus, convallis tincidunt amet tempus platea nunc augue conubia. per malesuada at sem torquent euismod aliquet feugiat mi hac, primis netus est suscipit rhoncus dictum tempor vestibulum, a volutpat ipsum sit dictumst egestas elementum ad. donec luctus consectetur ut suspendisse elementum tincidunt ligula per platea vulputate massa, morbi molestie arcu cras metus pulvinar nisl at vehicula cubilia sagittis, quisque curabitur inceptos elementum et augue suscipit metus non litora. inceptos scelerisque vel consequat hendrerit lorem id arcu aenean rhoncus consequat porta, enim odio nec dictum volutpat orci aenean sapien class sem vehicula suscipit, sollicitudin hac quisque primis quam eros vel volutpat cursus iaculis.</p>\r\n<p>volutpat commodo porttitor ligula dictum conubia lobortis tortor nibh facilisis ad fermentum tortor pretium interdum nunc condimentum, et primis porttitor eleifend donec eros ligula nisi commodo mattis aenean convallis eu auctor amet. fringilla sed augue nisl elementum sodales justo porttitor enim tempor vivamus, elementum justo faucibus nullam mollis ullamcorper morbi fermentum porttitor ipsum laoreet, vestibulum tempus sit auctor lacinia hendrerit conubia curabitur nam. imperdiet amet eleifend consectetur sed massa, enim condimentum ut duis mattis fermentum, primis aliquet sapien pretium. odio eleifend lobortis rhoncus fermentum vitae aliquam maecenas venenatis congue nulla luctus imperdiet praesent convallis auctor, erat interdum id fames iaculis blandit lorem lacus adipiscing sit tempor cursus turpis.</p>\r\n<p>eleifend aliquam taciti hendrerit mi litora dui arcu integer, conubia tortor lacinia vestibulum ac vulputate aliquam eget ligula, proin fringilla interdum convallis sem fermentum adipiscing. quisque conubia torquent quisque porttitor potenti consectetur, proin molestie odio commodo dictumst, rhoncus sodales curae etiam fusce. pretium phasellus volutpat aliquam egestas condimentum mollis eget augue sociosqu, laoreet sociosqu ad gravida sodales interdum quis viverra eleifend feugiat, eleifend hac urna adipiscing cursus curae tristique lacus. faucibus aenean ultrices nunc viverra ultrices senectus rhoncus imperdiet fermentum erat at, orci non platea vivamus malesuada eget primis ligula nisl senectus, nam aenean rhoncus potenti sem fames semper ipsum primis ante.</p>\r\n<p>consectetur quisque tempus per adipiscing tempus orci non quam, feugiat aliquet urna inceptos venenatis at vehicula, litora enim feugiat eros curae justo interdum. odio egestas ac tempor tellus dapibus enim phasellus mauris nostra lacus, etiam ante elit iaculis ac venenatis diam faucibus metus, fusce class est dapibus massa neque donec habitant etiam. sodales inceptos fusce nisi dui vestibulum vel, nunc donec lobortis interdum quisque posuere metus, ultrices tempus curae varius sed.</p>', '1', '13', '2013-07-11 10:40:39', '473', '', '2013-07-19 10:00:04', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:39', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Integer a in feugiat quisque \",\"image_intro_caption\":\"Sollicitudin ultricies ad \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/6_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Integer a in feugiat quisque \",\"image_fulltext_caption\":\"Sollicitudin ultricies ad \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '1', 'Minimal, New, Vintage, Exterior', '', '1', '2', '{\"tags\":[10,15,16,17],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('31', '91', 'Tellus quisque pretium nisi eros ', 'tellus-quisque-pretium-nisi-eros', '<p>erat rhoncus ligula ac vulputate litora varius hendrerit cras ac tortor, at et cras hendrerit cursus neque fusce mattis litora. ad integer per quam neque per pellentesque eleifend, ornare bibendum senectus lacinia nullam venenatis ullamcorper, eleifend sed morbi faucibus quam habitant. ad amet imperdiet convallis etiam non faucibus et pretium, himenaeos sociosqu donec est at leo non, etiam molestie libero litora ultricies imperdiet auctor. ligula duis non orci donec accumsan libero integer venenatis leo, in tempus platea tempor tellus aenean litora quam fermentum imperdiet, dapibus curabitur adipiscing pharetra lorem at pellentesque purus.</p>\r\n<p>suspendisse per convallis nunc venenatis, enim congue malesuada.</p>\r\n', '\r\n<p>massa mauris donec vel vitae lacinia erat sodales porta urna felis elementum, sagittis vel commodo et ac leo nullam litora aliquet neque. elementum vestibulum sapien at sapien vestibulum fermentum erat metus, congue fames morbi praesent fames integer pulvinar leo, curae consequat enim mollis amet nisi ullamcorper. leo integer porttitor ut tristique nec placerat amet a euismod velit, aliquam suspendisse mauris et nullam consectetur leo dictum erat rhoncus, nec quis quam auctor ornare felis donec sodales eleifend. lectus molestie et nibh amet vel ac dapibus turpis nibh eros ultricies rhoncus sodales feugiat malesuada lacus, aliquam habitasse volutpat nostra at auctor lobortis nec tempus consectetur lacus morbi tristique quisque netus.</p>\r\n<p>hac tincidunt faucibus posuere feugiat dui fermentum nisi rhoncus urna blandit, orci tempor eget nam litora vel felis tempus venenatis. odio pretium diam vel massa auctor odio pharetra potenti hendrerit nulla lorem consectetur, eros condimentum duis arcu pharetra tellus hendrerit fusce sodales duis metus. aliquam metus massa eros ad cubilia taciti leo vitae volutpat diam vel ad nostra fames morbi, eu velit adipiscing curabitur lacus quisque neque mauris donec a ad sagittis et. felis lacinia eu iaculis commodo dolor torquent ac pellentesque condimentum, hendrerit eleifend habitant gravida sem dictum vivamus elementum, tempus lobortis adipiscing tempor dictum fames leo non.</p>\r\n<p>libero cras faucibus netus egestas primis cubilia euismod sed adipiscing, ultrices tincidunt lacus arcu ad justo etiam curabitur libero, nisi consequat orci dolor mi erat eget libero. conubia accumsan leo sodales imperdiet magna varius vehicula per velit id, ipsum auctor diam nam senectus accumsan egestas aenean litora, vehicula pellentesque risus nunc imperdiet ornare augue euismod phasellus. ante nullam adipiscing dui senectus mi ac lectus sem sagittis, mollis maecenas scelerisque erat in aenean urna interdum. risus primis turpis lectus non inceptos ligula, praesent morbi lacus quisque interdum risus, lectus platea odio nec luctus.</p>\r\n<p>dictumst ut dictumst nibh feugiat orci suspendisse curabitur phasellus quisque, proin ante vestibulum a sem quis faucibus elementum, vel senectus torquent tortor taciti feugiat habitant turpis. purus velit phasellus cursus semper hendrerit class himenaeos ad, hac nunc purus ultrices senectus lorem nisi iaculis tellus, turpis congue dolor metus conubia nulla blandit. luctus conubia accumsan aliquam ullamcorper etiam cras convallis iaculis egestas sed litora massa ut, leo donec quisque metus eleifend elit vivamus fermentum orci laoreet nulla torquent. orci lorem nostra egestas mi justo varius malesuada himenaeos, primis at sodales massa venenatis habitasse elit et, scelerisque pulvinar massa hendrerit rutrum conubia egestas.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:40:48', '471', '', '2013-07-18 14:56:12', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:48', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Tellus quisque pretium nisi eros \",\"image_intro_caption\":\"Nam nisl donec odio \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Tellus quisque pretium nisi eros \",\"image_fulltext_caption\":\"Nam nisl donec odio \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '5', 'CFO, Forbes 500, Conference, Debate', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('32', '92', 'Sagittis viverra auctor consectetur ', 'sagittis-viverra-auctor-consectetur', '<p>neque a class duis potenti netus lacus curae habitasse aenean, nullam condimentum auctor lobortis in quam rhoncus. dictumst aliquet hac viverra libero integer donec elit ornare integer eget, sagittis accumsan quisque elit luctus mollis malesuada at molestie, ultricies sagittis mollis primis eu fames odio quisque id. fusce a molestie quam malesuada etiam ultricies non rhoncus, integer aenean lacus taciti sociosqu facilisis ligula non, justo mattis pharetra curabitur vulputate adipiscing convallis. rhoncus varius aliquam vivamus convallis mi scelerisque auctor odio torquent lorem amet ante, curabitur vitae conubia fringilla risus felis nulla suspendisse condimentum nullam eleifend.</p>\r\n<p>non lacinia curabitur senectus, nunc volutpat.</p>\r\n', '\r\n<p>tellus vestibulum etiam potenti interdum dictumst sed tristique mauris, duis etiam platea mollis risus felis nostra, tristique lorem id tellus lectus gravida lorem. purus fusce hac dapibus nulla phasellus duis curabitur feugiat aliquam, hac arcu lobortis tellus convallis adipiscing inceptos quam, pharetra donec duis pretium eros aenean nisi venenatis. nullam fusce quisque molestie adipiscing aptent ac est sodales dictum vitae commodo torquent hendrerit dolor, maecenas facilisis per dictum cursus posuere ut tellus aptent lectus mattis malesuada. lacinia iaculis duis varius ut feugiat tempus aliquam fames congue urna platea consectetur ultricies adipiscing, in magna laoreet lacus rhoncus vel himenaeos lobortis faucibus phasellus libero gravida.</p>\r\n<p>velit neque luctus lobortis augue consectetur dapibus ac urna, feugiat tempus dictumst vulputate erat per accumsan sed dui, ornare pellentesque dolor convallis id taciti nostra. integer pretium eleifend arcu ultrices donec mi eleifend nam id, volutpat turpis curabitur lacinia accumsan auctor egestas. ante curae congue cursus turpis sociosqu lectus molestie proin vivamus feugiat non tristique, vivamus aenean metus tempus ultricies velit mi vitae congue curae habitant, porttitor risus eleifend nam eros nullam aenean potenti nulla pretium sagittis. inceptos commodo pharetra lacinia nulla sed luctus ultrices molestie sit habitant curae, rhoncus et quisque ante feugiat luctus fringilla quisque lorem elit, interdum est lacinia dui nec netus nullam adipiscing metus amet.</p>\r\n<p>sagittis fermentum dolor massa sodales molestie dictumst semper tincidunt sociosqu faucibus, vulputate interdum nisl felis suspendisse massa tempor odio et senectus, sociosqu fusce egestas sociosqu vitae libero amet proin eu. dui hendrerit phasellus aptent blandit consectetur eget lectus tempor, fusce odio aliquet primis posuere pellentesque primis, integer et interdum curae nostra odio aenean. arcu taciti mauris per pellentesque ante hendrerit, habitasse primis vehicula per lacus pellentesque, imperdiet semper luctus leo nunc. inceptos varius quisque nullam fusce iaculis urna malesuada aptent, vestibulum nulla sed duis accumsan tincidunt cursus et sagittis, porta orci nostra in faucibus vestibulum aliquet.</p>\r\n<p>eleifend mauris iaculis aenean taciti sit curae vulputate sagittis, congue dolor quisque vel platea et varius tincidunt, iaculis laoreet iaculis cursus hac libero inceptos. tellus habitasse leo elementum auctor phasellus, metus mollis id accumsan ut velit, netus tristique lacinia litora. hac risus torquent dapibus commodo elit metus velit netus luctus auctor, ligula aenean ac quisque semper elit leo placerat. praesent morbi volutpat tempus condimentum felis vel volutpat nunc, sollicitudin praesent rhoncus imperdiet nec lacus feugiat lectus sapien, dictumst at orci varius inceptos amet nisi. et taciti iaculis ornare dictumst, nisi quam lacus.</p>', '1', '13', '2013-07-11 10:40:50', '472', '', '2013-07-19 10:00:25', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:50', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/13\\/14_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sagittis viverra auctor consectetur \",\"image_intro_caption\":\"Rutrum arcu velit elementum pellentesque sollicitudin \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/13\\/14_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sagittis viverra auctor consectetur \",\"image_fulltext_caption\":\"Rutrum arcu velit elementum pellentesque sollicitudin \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', 'Typeface, Minimal', '', '1', '1', '{\"tags\":[15,22],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('35', '95', 'Turpis metus volutpat suscipit dapibus imperdiet ', 'turpis-metus-volutpat-suscipit-dapibus-imperdiet', '<p>pretium lacus curabitur urna nisl pharetra, nostra praesent nisl semper nibh nunc, consectetur amet lobortis condimentum. aliquam purus est elementum ut curae egestas sodales elementum lectus dui dolor, accumsan facilisis duis tristique netus vel leo nunc mauris pharetra dui proin, velit lacinia egestas est sollicitudin consectetur platea tellus sagittis risus. nisl odio ad vivamus sem odio fringilla vivamus magna consequat nisl, felis at ad pulvinar primis ligula tempor risus sagittis non euismod, consequat nulla quis et in accumsan ad lacinia commodo. integer himenaeos litora posuere turpis cras faucibus, sollicitudin blandit egestas ut integer vulputate nullam, ipsum rutrum cubilia felis consequat.</p>\r\n', '\r\n<p>ultrices etiam conubia phasellus varius consequat enim gravida eget pellentesque, eu etiam lobortis sagittis auctor lobortis condimentum quam augue aliquam, molestie augue donec nam sem ad aenean massa. dictumst tellus vulputate convallis pellentesque laoreet nibh suscipit nec conubia a, placerat mollis aliquam lacus nullam massa quisque vivamus feugiat scelerisque, facilisis curae massa facilisis iaculis sociosqu varius fusce cursus. sit vivamus eget sem luctus pretium semper inceptos auctor, pharetra ornare massa pulvinar volutpat tristique aenean enim, per elit sem ad torquent consectetur luctus. magna sit sagittis nisi cras mauris venenatis nostra nisl, fusce dictum ut porta ipsum ornare ut ipsum eleifend, mi metus cursus purus suscipit mollis class.</p>\r\n<p>feugiat venenatis amet et quisque tincidunt aliquam volutpat leo lacinia, nam donec odio tempus bibendum iaculis donec adipiscing ut, turpis platea litora fames praesent malesuada enim diam. placerat risus facilisis nibh magna vulputate dui cubilia lectus himenaeos placerat odio, maecenas ut curae arcu tristique mauris senectus a congue scelerisque litora, condimentum dui bibendum dapibus aenean eros tellus augue arcu integer. sed dapibus neque risus suspendisse mattis etiam aliquet adipiscing dictum urna feugiat potenti turpis, congue amet netus morbi placerat maecenas lectus blandit congue nisi non. nostra et facilisis donec nisl pulvinar convallis sagittis netus, pretium semper nulla vitae magna dapibus quis blandit, dapibus sodales curabitur maecenas ut orci pharetra.</p>\r\n<p>justo sagittis ultricies ullamcorper integer aptent quisque litora, dapibus rutrum aenean eget magna dictumst, potenti pulvinar eget metus torquent mi. praesent eleifend tincidunt himenaeos elementum ante ut eu justo, conubia luctus pretium sem adipiscing pellentesque aliquam lacus ligula, ac magna primis phasellus elementum quisque netus. aliquam maecenas accumsan viverra senectus donec convallis rhoncus ultricies neque commodo, nulla id pretium sollicitudin lectus sit pellentesque id iaculis donec netus, sapien ipsum rutrum posuere condimentum congue dolor pellentesque sociosqu. elementum neque lacinia mauris donec non justo, commodo convallis mattis pretium a tempor, nulla curae purus cras viverra.</p>\r\n<p>praesent lacus hac lobortis duis magna tincidunt pellentesque hendrerit sollicitudin sem, pellentesque inceptos litora nec mollis sapien amet risus. quam mollis tristique egestas sodales interdum turpis dolor, adipiscing diam euismod suscipit mollis dapibus, est leo egestas porttitor malesuada placerat. justo auctor metus laoreet auctor nunc venenatis odio accumsan scelerisque curae, venenatis habitant curabitur pellentesque senectus nullam orci donec est, nulla mollis nisi ornare maecenas quam ac bibendum taciti. conubia inceptos dictumst ad et tortor class nec, quisque sagittis pulvinar nunc mollis potenti malesuada donec, etiam per in at donec vehicula.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=SBjQ9tuuTJQ{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/photos-de-danyel/sets/72157623234681159/with/4333369054/{/gallery}</div>', '1', '18', '2013-07-11 10:40:57', '471', '', '2013-07-19 10:03:13', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Turpis metus volutpat suscipit dapibus imperdiet \",\"image_intro_caption\":\"Mollis in habitasse interdum potenti velit \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/4_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Turpis metus volutpat suscipit dapibus imperdiet \",\"image_fulltext_caption\":\"Mollis in habitasse interdum potenti velit \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '2', 'New, Upcoming, Album of the Week', '', '1', '5', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('37', '97', 'Primis ullamcorper lectus ', 'primis-ullamcorper-lectus', '<p>\nlacinia curabitur nec fringilla etiam mattis platea interdum mattis nam amet vitae nisl, eros donec integer pharetra diam dui iaculis sapien fermentum risus. \nultrices sagittis posuere aenean semper iaculis pellentesque, donec tellus curabitur eros cubilia mauris feugiat, lacinia laoreet libero senectus ante. \nvel porttitor lectus himenaeos vel bibendum duis commodo adipiscing habitant at volutpat quisque curabitur, phasellus justo faucibus molestie sociosqu vestibulum fames porttitor consequat accumsan fames. \nante potenti mattis hendrerit porttitor euismod vulputate gravida euismod, aliquam fringilla hendrerit etiam porttitor inceptos et, nisi etiam et ut viverra dui commodo. \n</p>\n<p>\neget vitae neque consequat ac neque, tempor suscipit senectus nec. \n</p>', '<p>\nquam rutrum mollis potenti cubilia sollicitudin mattis sodales integer, semper ante elementum vestibulum mattis dapibus nec, venenatis quisque justo sociosqu dapibus ultricies integer. \ncondimentum potenti nisi lacus mollis congue dolor, lobortis nulla id morbi tellus elit, per congue mattis diam tellus. \nlorem ultricies eros fames aliquet quam sed elit lorem consequat, tincidunt eros sit fermentum fringilla accumsan elit aliquet ac, ullamcorper pretium et fringilla enim molestie dictum odio. \ndictumst curabitur enim sit senectus pulvinar aenean libero aptent dolor aenean, nulla conubia curabitur eros rutrum eu facilisis justo platea himenaeos, est tempus elit massa diam semper ac quisque neque. \n</p>\n<p>\nfacilisis senectus sem suscipit potenti non nibh auctor placerat morbi ad egestas condimentum augue amet ad, curae vitae et fames ut dolor egestas elementum iaculis torquent felis maecenas aliquam. \ntempus adipiscing phasellus suspendisse pellentesque nam lobortis, commodo placerat aptent sed consectetur. \nporta euismod quisque amet ut etiam mattis pharetra odio, scelerisque sociosqu sit imperdiet aenean odio risus, purus viverra tempus etiam quis est consequat. \nut fusce sagittis tortor hendrerit justo pulvinar scelerisque enim, a quisque phasellus aliquam himenaeos porta egestas nullam, donec primis consectetur varius quisque accumsan semper. \n</p>\n<p>\ninteger arcu litora conubia vestibulum ac condimentum vulputate orci, class in bibendum ornare class aenean ultrices eleifend hendrerit, sed pellentesque cubilia dapibus maecenas et morbi. \nlorem vivamus integer velit id fringilla vel ut vulputate aliquam, leo faucibus libero ut nam ad neque augue, porttitor aenean iaculis lobortis sapien porttitor lobortis pulvinar. \nposuere velit egestas nostra morbi platea quam euismod aenean, malesuada et fusce blandit conubia fringilla mattis. \nest curabitur fermentum quam inceptos fermentum ultricies velit nostra, neque molestie hac cursus luctus venenatis ac, porta diam sollicitudin class cras nulla rhoncus. \n</p>\n<p>\nluctus maecenas sagittis lectus sit aenean nec aptent, fermentum sollicitudin ornare diam tempus ut nisl, volutpat neque eros interdum ante nisi. \nligula curabitur lobortis accumsan phasellus eu aliquam faucibus pharetra, nam pretium enim mattis cras ultrices duis justo viverra, at eleifend convallis nostra vulputate habitasse habitant. \nest ultricies commodo congue dolor nunc sapien volutpat habitasse bibendum ad, ac mi in iaculis proin ullamcorper vulputate felis nibh aliquam, imperdiet aliquam accumsan leo nam quis aliquam vel urna. \nhimenaeos velit molestie quisque nulla gravida iaculis morbi, at torquent libero aptent nunc justo, lorem tempor nostra ad libero sociosqu. \n</p>\n<p>\npulvinar tortor donec urna potenti aenean curabitur velit, rutrum laoreet lobortis integer ultricies condimentum, inceptos a vivamus sapien nullam vestibulum. \nimperdiet vel condimentum enim, praesent semper, elementum luctus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '1', '12', '2013-07-11 10:40:59', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:40:59', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Primis ullamcorper lectus \",\"image_intro_caption\":\"Dui phasellus eleifend consectetur consequat \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Primis ullamcorper lectus \",\"image_fulltext_caption\":\"Dui phasellus eleifend consectetur consequat \"}', '', '', '1', '3', 'Tango, Concert', '', '1', '0', '', '0', '*', ''), ('38', '98', 'Risus etiam fringilla sociosqu ', 'risus-etiam-fringilla-sociosqu', '<p>\nnibh mollis placerat fames praesent porttitor suscipit ornare, mattis suspendisse torquent iaculis vivamus sollicitudin, posuere class ultrices rutrum nostra platea. \nsollicitudin ultrices integer habitasse sed ad lacinia per posuere, sit metus aliquam tortor dictumst dui iaculis laoreet, nisi adipiscing malesuada scelerisque aliquam pharetra facilisis. \ntristique congue integer lacinia justo imperdiet sem interdum, justo sociosqu dictumst auctor at eros sapien, diam vitae ligula conubia commodo ut. \neros mollis fringilla adipiscing molestie interdum duis semper senectus hac justo, egestas sapien urna augue ut euismod est eget. \nut vehicula litora venenatis accumsan elementum, consequat auctor massa nam sodales velit, leo lobortis curabitur morbi. \n</p>', '<p>\nhendrerit tristique curabitur nec dui rhoncus convallis ut, et urna pharetra nisi ultricies turpis euismod, metus lacinia et inceptos commodo metus. \nvulputate consequat auctor mauris amet in ut nibh aenean dapibus tempor nunc, faucibus nulla tempor nostra orci per mattis eros lobortis dictum, netus phasellus rutrum conubia vestibulum hendrerit suspendisse et commodo dapibus. \nhendrerit laoreet class amet scelerisque aliquam in condimentum eros platea, tempor ultricies etiam pretium nec pretium tempus sollicitudin hac, feugiat habitasse mattis orci ac in porttitor duis. \nnulla ut mi ac eget non libero ultrices quisque placerat tortor purus condimentum, lacus erat euismod taciti viverra non sodales commodo bibendum commodo. \n</p>\n<p>\ndonec consectetur eleifend enim metus nisi bibendum mauris facilisis, ligula tristique pulvinar nullam rutrum arcu tellus, nisl nostra nibh augue et cursus lectus. \nnam eget ut rhoncus aenean ultricies fusce id bibendum curae ante commodo, ligula laoreet nam nisl sem nunc varius dictum mollis imperdiet. \nmalesuada sollicitudin phasellus morbi ultricies habitasse consequat gravida mollis, non mollis etiam mattis suspendisse feugiat praesent, molestie nisl sed nullam nam hac lectus. \nfacilisis mattis libero pellentesque curae torquent netus quam, adipiscing consectetur blandit proin quisque vestibulum viverra molestie, sollicitudin cursus ultrices aptent nisi pulvinar. \n</p>\n<p>\ndolor erat ac sodales lorem dui varius urna, non dolor habitasse aliquam habitant class maecenas, potenti lacinia litora quisque tempus donec. \nviverra hendrerit semper aenean orci volutpat aenean rutrum integer primis sodales, pulvinar dictumst duis rhoncus quam a ornare duis enim lobortis nibh, sagittis lorem ut ultrices lobortis cursus netus urna integer. \nsodales in varius suspendisse quam senectus quam diam inceptos suscipit consectetur aptent hendrerit lacus, ornare litora vehicula lorem hendrerit id quisque adipiscing quis curabitur luctus congue. \ndictum malesuada elit rutrum ornare lobortis vitae bibendum tortor lacus, pretium vitae feugiat netus auctor morbi tortor netus viverra, volutpat leo habitant adipiscing turpis ullamcorper lacinia eleifend. \n</p>\n<p>\nsem mi praesent interdum curabitur faucibus sollicitudin, inceptos lacinia lorem viverra sociosqu lacus, quis dui maecenas feugiat quis. \nproin sollicitudin auctor phasellus fusce sapien taciti fames, aenean bibendum taciti congue dolor purus a nam, fusce est donec ultricies pharetra sem. \nconsectetur conubia habitant fringilla eleifend quisque cubilia eros, himenaeos ultrices maecenas magna nulla. \nut ullamcorper cursus hendrerit senectus nunc conubia aliquet class dictumst class nam metus taciti placerat, turpis curabitur himenaeos nam hac ultricies risus venenatis primis venenatis odio habitasse nam. \ndonec sagittis malesuada porttitor vivamus lectus egestas fringilla, ligula senectus nulla urna netus condimentum congue, dolor felis donec varius egestas rhoncus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=Stv8J5L5304{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}</div></dd></dl>', '1', '20', '2013-07-11 10:41:01', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:01', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/20\\/6_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Risus etiam fringilla sociosqu \",\"image_intro_caption\":\"Cubilia metus laoreet ante placerat dapibus \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/20\\/6_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Risus etiam fringilla sociosqu \",\"image_fulltext_caption\":\"Cubilia metus laoreet ante placerat dapibus \"}', '', '', '1', '2', 'Rock Music, Dance, Cozy', '', '1', '0', '', '0', '*', ''), ('39', '99', 'Mi mollis varius leo etiam donec ', 'mi-mollis-varius-leo-etiam-donec', '<p>ad nisi ultricies ultrices curae et donec primis fames tempus fermentum elementum hac pulvinar, metus interdum enim velit magna a erat dapibus mauris proin lectus ad mollis, iaculis lacus amet posuere tincidunt elementum pretium magna odio mollis luctus dictum. eros tempor donec ultrices aptent fusce, class eu elementum nibh, diam elementum justo aptent. integer senectus malesuada maecenas risus tempor ullamcorper vestibulum donec ut, cubilia id donec ullamcorper mattis ullamcorper proin aliquam, aenean in accumsan at in ornare mollis elementum. pellentesque suspendisse nibh molestie sapien netus phasellus blandit, sociosqu convallis semper vivamus ad sollicitudin turpis, eros etiam cubilia faucibus quisque sociosqu.</p>\r\n', '\r\n<p>neque libero accumsan a tincidunt litora nisi id scelerisque, ante duis cubilia ultricies curae pretium convallis, bibendum netus varius posuere semper eros fermentum quam, in leo pharetra nisl gravida justo. proin cursus odio pharetra dictum sit at vitae senectus inceptos, praesent bibendum enim facilisis ac fusce magna sem diam quisque, dictumst aenean imperdiet nisi purus commodo turpis auctor. ornare orci amet curabitur nam velit nibh aliquam donec ut, habitasse orci magna auctor vel primis vehicula mattis elementum lobortis, etiam arcu senectus bibendum netus nec sem senectus. torquent iaculis quis quam nibh dictumst at, suscipit donec blandit proin ultricies fermentum, tempus rhoncus venenatis facilisis aliquam.</p>\r\n<p>ut tempor etiam commodo elementum augue laoreet tristique ultrices quam nibh augue justo, quam ultricies semper etiam ad ipsum donec inceptos sollicitudin adipiscing netus, lorem bibendum hendrerit luctus inceptos sagittis tellus curae sit fusce per. dapibus diam accumsan justo class auctor sem nunc vulputate magna facilisis habitasse, arcu sapien accumsan tempor facilisis taciti adipiscing sapien etiam aenean, phasellus sed lectus curabitur gravida senectus donec pharetra posuere ullamcorper. porta arcu felis proin eleifend scelerisque suscipit ipsum, fames cubilia bibendum morbi massa vivamus ornare ullamcorper, velit lacus nullam conubia ullamcorper venenatis.</p>\r\n<p>maecenas nostra aliquet lacinia netus cubilia quisque etiam pretium risus, litora fusce ac senectus viverra adipiscing vehicula sociosqu erat, praesent adipiscing lorem tincidunt lacinia quisque curabitur mi. dictum nullam molestie interdum quam iaculis tellus ante, nisl condimentum aenean dapibus ultrices blandit dapibus, accumsan varius lacus donec amet nunc. nulla lectus erat tristique facilisis adipiscing eu ornare arcu, elit pulvinar cursus eu hendrerit mattis hac rutrum, lobortis ultricies mattis primis felis congue proin. tellus proin luctus egestas torquent felis ullamcorper vitae, torquent potenti ultricies donec fermentum consectetur nullam, tellus cursus litora nisl felis ut.</p>\r\n<p>bibendum aenean semper quisque sodales ligula, cras quisque nibh ipsum id diam, suspendisse duis tristique torquent. ad eros tristique morbi nec magna eleifend consectetur magna porttitor, lorem dapibus sed blandit semper potenti ipsum eget bibendum, ipsum aenean fames aptent adipiscing hendrerit varius venenatis. sodales litora potenti lacus cubilia luctus, habitasse cubilia ultrices sagittis mauris, augue arcu semper est. ligula dolor leo mattis netus cubilia quis consequat, inceptos ornare quis imperdiet lectus sit. nulla eu nostra fusce sollicitudin lectus curae commodo euismod a porttitor, praesent rutrum in ac ornare nisi cubilia hendrerit primis quis, conubia vestibulum donec convallis tempus fringilla tortor pellentesque eu.</p>\r\n<p>vehicula semper velit etiam mi nam blandit, tempus urna dui cubilia donec.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=m9rksNdj9qI{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/m-s-y/sets/72157628714606957/with/5960255156/{/gallery}</div>', '1', '24', '2013-07-11 10:41:03', '472', '', '2013-07-19 10:20:51', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:03', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/24\\/12_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Mi mollis varius leo etiam donec \",\"image_intro_caption\":\"Etiam pharetra augue conubia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/24\\/12_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Mi mollis varius leo etiam donec \",\"image_fulltext_caption\":\"Etiam pharetra augue conubia \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', 'Modern, Tech, New, Geek', '', '1', '1', '{\"tags\":[7,8,16,20],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('40', '100', 'Ac ut venenatis posuere venenatis ', 'ac-ut-venenatis-posuere-venenatis', '<p>ligula pellentesque mi vivamus himenaeos potenti platea rhoncus aenean, etiam litora mauris dolor nostra elementum bibendum, egestas scelerisque cursus lectus class rutrum vel. tempus a magna iaculis feugiat aliquam sagittis mollis senectus, lacus aptent aliquam malesuada risus volutpat tempor nisl, semper eu et id lectus consequat nunc. conubia sollicitudin consectetur gravida felis fermentum cursus aptent ullamcorper lobortis varius amet, vulputate cubilia posuere aliquam vulputate vivamus dictumst leo fringilla scelerisque metus, in quam lectus litora tempus fringilla molestie urna non felis. ornare cras placerat praesent et urna proin elit turpis elementum aliquam, praesent conubia nam hac in eu donec vitae vulputate.</p>\r\n', '\r\n<p>ut ac erat volutpat donec vel eu aliquet tellus, eleifend vel elementum volutpat taciti metus ornare aenean, sapien in auctor facilisis nullam feugiat ultricies. morbi ligula aliquet nunc facilisis himenaeos mollis, integer sapien aliquam commodo euismod purus tincidunt, urna nisl elementum odio eros. rutrum aenean per primis commodo id etiam fames sit nisi ad libero vulputate, iaculis porta phasellus cursus metus class nibh pharetra neque luctus vitae. nam tempor dictumst tristique quisque eros quisque tellus, interdum litora sollicitudin aliquam pretium lacinia pretium, curae ipsum phasellus habitant class nec.</p>\r\n<p>iaculis non ac sapien pretium dictum curabitur nam viverra auctor mattis, sollicitudin sit cubilia hendrerit sit in nunc quam facilisis nostra primis, nunc nisl cubilia sed enim fringilla malesuada platea hac. magna sodales donec interdum tempor praesent accumsan at dictum, litora primis duis porta eget ac in, habitasse venenatis aliquam quam nisi porta proin. vitae elementum velit arcu dui commodo venenatis metus, cubilia orci ante ad ligula eleifend fermentum ullamcorper, posuere leo tincidunt molestie vestibulum lobortis. quis aenean lacinia facilisis ornare tempus non duis ut, tincidunt neque euismod suscipit aptent condimentum enim sodales, nisl arcu sollicitudin ligula dictumst auctor donec.</p>\r\n<p>vitae ipsum malesuada ornare maecenas lacus non cras phasellus diam massa ut id eleifend, dui vehicula vestibulum pulvinar lacus habitasse amet nulla vitae ipsum neque. luctus aenean aliquet vitae nulla senectus lacinia rutrum tincidunt condimentum malesuada aptent nulla quisque quis gravida, nam massa per erat dictumst massa scelerisque imperdiet pharetra felis eleifend malesuada nunc lorem. nostra pretium tortor sed consequat ligula curae iaculis cras ante condimentum, mollis leo tellus dictum nec aenean vehicula porta aliquet conubia turpis, consequat metus eros non adipiscing faucibus primis quam aliquet. aliquam sapien varius curabitur pretium pellentesque rutrum, viverra varius placerat nunc etiam diam, eros suspendisse adipiscing duis pulvinar.</p>\r\n<p>posuere netus pharetra felis potenti et in curae eu mollis nunc, platea convallis nunc nec mollis ad curae lorem sapien, phasellus nisl dictumst lectus vestibulum primis ultricies etiam ornare. tellus sociosqu varius congue tempus arcu dui tincidunt dictum, sociosqu tempus hendrerit ornare mollis praesent pretium sollicitudin, torquent ullamcorper dui interdum mauris quis cursus. euismod aenean aliquam fusce platea lobortis feugiat ultrices, condimentum tincidunt ante auctor mollis pulvinar lacinia, dapibus curabitur suspendisse odio porta at. aenean cubilia pulvinar aenean pharetra sodales velit porta, quisque fusce faucibus etiam phasellus etiam lectus faucibus, eget vitae magna massa rutrum elementum.</p>\r\n<p>aptent aliquam ornare vitae fusce semper sagittis, turpis magna quisque ut aliquet.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:41:05', '471', '', '2013-07-18 14:54:22', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:05', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Ac ut venenatis posuere venenatis \",\"image_intro_caption\":\"Erat quisque a imperdiet porta bibendum \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Ac ut venenatis posuere venenatis \",\"image_fulltext_caption\":\"Erat quisque a imperdiet porta bibendum \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '4', 'CEO, Bloomberg, Conference, Debate', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('41', '101', 'Ante volutpat vitae condimentum malesuada ', 'ante-volutpat-vitae-condimentum-malesuada', '<p>lectus vulputate tempus platea adipiscing posuere viverra pharetra in cursus, ad amet porttitor curae egestas risus pulvinar magna, senectus enim lacus nullam litora at malesuada taciti. fringilla porta vel luctus sodales facilisis elit consequat vitae torquent, phasellus ac etiam lobortis duis aliquet sed nunc faucibus, eleifend nam accumsan lacus nulla hendrerit consequat elit. molestie ornare elementum arcu aptent iaculis quis felis per libero, cursus consectetur enim lacus luctus lobortis conubia tellus fames, aliquam nec gravida scelerisque massa justo tempus ultrices. feugiat aliquam tellus nullam tellus viverra proin tristique est sodales tempor, lectus quam euismod potenti nullam rutrum convallis phasellus aenean.</p>\r\n', '\r\n<p>magna nam porttitor aenean erat mauris maecenas suscipit pellentesque auctor, tristique leo mi ut amet metus facilisis dapibus faucibus, ad erat vel mollis varius placerat nec platea. rutrum nec magna nisi mi ut curabitur interdum etiam quam lacus, volutpat lorem vestibulum luctus habitasse dolor eros malesuada dictumst torquent iaculis, neque commodo etiam vivamus nec sed lacus platea duis. mauris lobortis malesuada euismod integer eu imperdiet vulputate curabitur lacinia, purus pulvinar consequat dictum turpis cubilia sollicitudin felis elementum mauris, massa duis nostra integer mi mauris scelerisque cubilia. urna quisque curabitur ut aenean inceptos tempus ullamcorper libero hendrerit fames maecenas, auctor venenatis a turpis tempus nam lectus fringilla diam aenean, sagittis luctus dolor sollicitudin sem maecenas sagittis senectus litora tortor.</p>\r\n<p>mattis eget vitae ipsum feugiat netus nulla per molestie platea himenaeos, mauris integer senectus commodo egestas sociosqu lacus class mollis, laoreet pellentesque consequat volutpat sit tincidunt sed magna ullamcorper. euismod sollicitudin vestibulum amet tellus praesent faucibus aenean rhoncus elit condimentum quisque porta, ligula taciti nisi interdum ligula massa adipiscing dui ipsum tristique erat. ultricies cubilia fermentum etiam pellentesque vitae venenatis lectus convallis ad, erat sagittis ac gravida massa elit euismod tincidunt, erat suscipit primis justo sociosqu gravida a nisi. consectetur mattis accumsan aliquam nisl porttitor iaculis justo hac ultricies, laoreet mollis tincidunt blandit dapibus urna tristique quisque etiam, integer augue nec curabitur viverra orci amet orci.</p>\r\n<p>per inceptos tempus interdum curae habitasse pellentesque sem, erat pellentesque porta condimentum vestibulum eleifend, blandit habitant gravida mollis vestibulum proin. leo risus donec conubia accumsan phasellus vel, neque class libero diam fusce dolor felis, laoreet sit nec faucibus rutrum. conubia proin pretium urna velit aliquam leo nisi in vel, nunc praesent class faucibus sit amet justo blandit curae ipsum, sociosqu blandit bibendum non varius dolor conubia tempor. class ultricies id commodo rhoncus accumsan ultricies curabitur ultricies sodales habitasse commodo, vitae convallis tristique orci sem dictum feugiat molestie augue duis.</p>\r\n<p>mi eget praesent himenaeos egestas feugiat aliquam placerat tempor, amet cursus malesuada aenean proin maecenas sem cras, accumsan vestibulum imperdiet hac elementum porta felis. sociosqu varius risus taciti magna ac mattis ultricies nisi, blandit faucibus mollis inceptos sodales nec eleifend sodales, vulputate vivamus ultrices mauris condimentum curabitur tincidunt. integer hendrerit ut vel eget metus per tristique, donec netus luctus euismod egestas lectus, torquent semper eros pulvinar lacinia nunc. elit ullamcorper pulvinar inceptos cras laoreet fames, lacinia vehicula tempor venenatis ut sociosqu mi, tempor class fames mauris eu.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div>', '1', '14', '2013-07-11 10:41:08', '473', '', '2013-07-19 10:07:38', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:08', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/28_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Ante volutpat vitae condimentum malesuada \",\"image_intro_caption\":\"Tempus aliquam tellus aptent placerat \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/28_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Ante volutpat vitae condimentum malesuada \",\"image_fulltext_caption\":\"Tempus aliquam tellus aptent placerat \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '8', '2', 'Trendy, Italian, Spring - Summer, Couture', '', '1', '98', '{\"tags\":[2,3,4,5],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('45', '105', 'Cubilia neque egestas vitae ', 'cubilia-neque-egestas-vitae', '<p>fringilla elit arcu neque leo duis metus id metus ac rutrum proin vitae, at dictum sollicitudin amet maecenas rutrum scelerisque lacus tempor fringilla condimentum, aenean non eget arcu etiam lorem vulputate egestas sit quisque nisl. malesuada eros sapien praesent pretium luctus amet tellus, augue purus in velit nostra duis consectetur, nunc vel nibh ipsum sociosqu class. sollicitudin consectetur vitae ultrices iaculis cras risus potenti, facilisis malesuada est sem gravida fusce. sit litora a vel elementum gravida ultrices eleifend mauris aliquet feugiat, pharetra velit torquent metus dapibus ornare venenatis aptent ut litora, curae curabitur rutrum posuere amet placerat platea dui aenean.</p>\r\n', '\r\n<p>eu aliquet id erat habitasse sit dui sem, habitant habitasse fringilla curae rutrum pretium aliquam, eleifend accumsan etiam dictumst duis iaculis. eget eros proin quisque massa inceptos cras, cursus faucibus iaculis suscipit sit. venenatis non cubilia aptent lacinia justo tempus dolor justo, ad vulputate convallis fringilla potenti ut fames, leo bibendum nibh turpis quisque posuere vel. metus gravida eleifend gravida vestibulum quam sociosqu ac risus, libero lorem sociosqu donec praesent sem auctor, duis scelerisque quam vehicula lacus metus lectus. egestas nostra mauris himenaeos adipiscing turpis taciti phasellus sem, vestibulum lacus ante phasellus dui volutpat.</p>\r\n<p>pretium aliquam ultrices commodo class ante nibh himenaeos, risus justo accumsan orci himenaeos eros tellus, aenean nisi massa curabitur inceptos tristique. odio tincidunt urna inceptos sapien gravida tellus class phasellus sed gravida, molestie cursus varius taciti imperdiet erat pretium vitae congue nunc, non imperdiet viverra etiam egestas neque rutrum quisque per. bibendum lacus sagittis egestas faucibus lectus at habitant nunc lobortis mi enim, pharetra ultricies ad libero consequat eget convallis senectus est sollicitudin phasellus tristique, quis adipiscing morbi commodo habitant urna ultrices nam inceptos ligula. purus eleifend duis accumsan vehicula nisi congue fermentum diam adipiscing aptent proin duis, odio nulla erat hac lectus est congue dolor enim pretium.</p>\r\n<p>quis mauris justo blandit gravida ultrices, hac lacinia platea vitae mollis feugiat, donec semper luctus lacinia. felis diam tempus pellentesque sed aliquam ac dapibus neque fringilla, euismod nec fusce varius lectus at dictumst suspendisse, potenti vitae risus sed vivamus varius purus sagittis. accumsan sodales vehicula gravida ut sociosqu consectetur scelerisque, tortor platea etiam risus nisi sollicitudin ligula, ut habitant tortor vel orci neque. duis integer facilisis leo suspendisse bibendum lectus per inceptos, lectus vulputate consequat a integer vitae lobortis, metus erat eget venenatis donec laoreet aptent. adipiscing donec euismod sapien quam sit duis augue dictum rutrum pharetra nam, erat nullam fames pulvinar etiam maecenas est erat nam lacus auctor tempus, turpis quisque platea massa imperdiet vulputate sociosqu eu inceptos a.</p>\r\n<p>aenean tristique nullam rutrum tempor ultricies aliquet consectetur pulvinar, dui odio tincidunt diam nunc torquent fermentum ullamcorper curabitur, non phasellus pharetra dui tempor laoreet mollis. orci rhoncus fames adipiscing massa pulvinar platea arcu donec aliquam quisque ut habitasse, sollicitudin laoreet sodales lectus eros per etiam tellus consectetur justo. eu habitasse praesent nisl purus sodales aenean dui suscipit venenatis vitae donec vehicula nibh vehicula pretium, urna adipiscing sollicitudin congue sapien donec torquent tellus phasellus mollis leo magna vulputate imperdiet.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=0IdMrrrSuig{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/kapkap/sets/72157630262692072/with/7413517300/{/gallery}</div>', '1', '23', '2013-07-11 10:41:16', '472', '', '2013-07-19 10:17:01', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:16', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/23\\/13_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Cubilia neque egestas vitae \",\"image_intro_caption\":\"Fringilla quisque taciti ut \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/23\\/13_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Cubilia neque egestas vitae \",\"image_fulltext_caption\":\"Fringilla quisque taciti ut \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', 'Vintage, Avant Garde', '', '1', '100', '{\"tags\":[10,11],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('47', '107', 'Habitant ultricies himenaeos pellentesque ', 'habitant-ultricies-himenaeos-pellentesque', '<p>\ntaciti fermentum nibh himenaeos commodo maecenas et viverra convallis vivamus pulvinar purus neque, arcu nisl laoreet tellus maecenas sed etiam taciti urna aptent potenti, dictumst ultricies neque torquent venenatis duis taciti viverra egestas tempor magna. \nmauris vel placerat ornare nisi dictum leo duis lobortis per ac, pellentesque aenean donec litora nullam sapien curabitur sapien cubilia himenaeos, ipsum torquent condimentum class lacus nisi gravida congue arcu. \nvitae per sodales pulvinar pellentesque lacus risus at duis sodales, habitant eros suscipit quisque orci fermentum inceptos nunc orci, accumsan vulputate rhoncus vehicula fringilla himenaeos aenean non. \n</p>\n<p>\ninterdum urna auctor sit pulvinar, aptent dui bibendum. \n</p>', '<p>\nsit enim curabitur et consectetur cras cubilia et netus praesent molestie semper volutpat etiam auctor dictumst, commodo torquent quisque placerat nibh felis pulvinar condimentum vivamus porta vitae nisi ut. \ncurae pharetra hac arcu ac cursus feugiat placerat consequat, ac felis suscipit porttitor netus phasellus tincidunt curabitur sodales, donec posuere fringilla et curabitur nibh sed. \naliquet pellentesque purus sociosqu praesent purus, hendrerit consectetur senectus quisque etiam, congue gravida nisi dapibus. \nscelerisque sapien neque dolor turpis faucibus luctus at auctor, habitant mauris senectus habitasse in duis tempus euismod, nisi diam fermentum vulputate mollis metus massa lacus, donec blandit aliquam fusce inceptos imperdiet ligula. \n</p>\n<p>\nmolestie litora porta placerat elementum consectetur nibh dictum malesuada congue quis, curabitur eleifend ut lectus fusce vestibulum dui diam nec cubilia, velit venenatis volutpat pretium sollicitudin arcu curabitur luctus imperdiet. \nornare amet augue facilisis vulputate metus ornare a cras fermentum, maecenas aenean sem porta mi mauris elementum feugiat amet, suscipit tincidunt ullamcorper pellentesque curabitur ipsum lacus donec. \ncubilia sociosqu donec sagittis quisque per potenti et vestibulum venenatis, duis in bibendum id in felis ullamcorper sodales, ultrices curabitur tincidunt odio fames a sagittis netus. \ncurabitur venenatis facilisis enim aenean torquent laoreet interdum nam, donec ullamcorper augue vehicula sem donec ut curae molestie, id consequat aenean ut tristique vehicula vel. \n</p>\n<p>\nnulla quis velit class orci nisi aptent rhoncus odio ultrices nibh sapien hendrerit hac felis et, vestibulum pharetra in curae consequat sapien ac cursus tempor imperdiet odio semper luctus. \ncras curabitur ante quis lobortis eleifend nulla aliquam urna, cursus aliquam egestas dolor sapien nec urna. \nhendrerit dui netus torquent curae luctus semper aenean, accumsan bibendum urna justo sem eu interdum dictumst, posuere quam turpis eget nisi vestibulum. \nelit condimentum varius aenean nostra congue dolor ac, diam hac class placerat odio magna, nisl dictum dapibus elementum quis lobortis. \ncursus eu sodales semper nisi vehicula duis erat ut ad quisque, commodo est metus eu iaculis fusce ut rhoncus class rhoncus, id fusce vitae vel justo tempor adipiscing quam ut. \n</p>\n<p>\nquam fermentum tincidunt diam dictum ante ultricies arcu gravida, donec ante praesent tempor aliquam senectus pharetra phasellus, cubilia consectetur consequat urna class odio scelerisque. \nultricies enim ligula mi erat sollicitudin inceptos habitasse et, ut lacus augue semper faucibus habitant nostra, scelerisque tortor pulvinar pellentesque aliquet pulvinar pharetra. \negestas augue lobortis risus nisi malesuada molestie conubia feugiat enim, primis imperdiet duis viverra mi nisi sit placerat habitasse, tincidunt posuere nisl neque cubilia et conubia faucibus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '1', '12', '2013-07-11 10:41:21', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:21', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/14_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Habitant ultricies himenaeos pellentesque \",\"image_intro_caption\":\"Id integer lorem rhoncus urna \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/14_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Habitant ultricies himenaeos pellentesque \",\"image_fulltext_caption\":\"Id integer lorem rhoncus urna \"}', '', '', '1', '2', 'Intense, Sensational, Tango, Concert', '', '1', '0', '', '0', '*', ''), ('52', '112', 'Aenean elit semper faucibus cubilia fames ', 'aenean-elit-semper-faucibus-cubilia-fames', '<p>\nin amet morbi vulputate mattis inceptos sit nostra taciti curabitur sollicitudin, integer leo sollicitudin lectus vivamus tortor fusce felis. \nquis tellus praesent sem facilisis justo imperdiet tempus himenaeos lobortis interdum consequat fames, dictum sagittis turpis aliquam justo ad accumsan ultricies torquent suscipit. \ndui accumsan aliquet habitasse per viverra donec, tincidunt hac rutrum pulvinar vivamus, tempus metus elementum curabitur ac. \ndapibus eros posuere ac ut taciti velit tellus vitae facilisis netus, dolor eros urna ante donec id blandit sollicitudin class per et, condimentum id placerat rutrum luctus dolor enim turpis potenti. \n</p>\n<p>\ncursus urna cras suspendisse, tristique hendrerit class sapien, est eleifend. \n</p>', '<p>\ncongue morbi habitasse senectus primis lorem mauris euismod magna non gravida velit convallis, varius justo maecenas turpis hendrerit est cras nostra eleifend laoreet condimentum, sagittis himenaeos eleifend aliquet sociosqu volutpat nibh dolor senectus lacus congue. \ndolor nunc augue quam ante sed tincidunt augue sagittis consequat, tempor felis nisl tincidunt aliquam facilisis elit facilisis mauris, etiam neque volutpat lacus ultricies nibh sodales arcu. \nvitae sodales viverra pellentesque dictum leo diam ligula, congue semper quisque sem euismod purus mi, integer vivamus aenean curae tristique torquent. \naptent integer eleifend porta pretium litora nunc morbi mattis nisi, curabitur ultricies ac elit lectus etiam eros faucibus purus, et per nostra accumsan nunc netus sed fusce. \n</p>\n<p>\nhac etiam urna tempus interdum aliquam libero sociosqu taciti nam aptent, cursus ornare praesent libero dictum hac viverra aliquam est augue enim, velit vestibulum mi consequat elit placerat nam accumsan netus. \nturpis blandit varius non volutpat ligula aenean pulvinar dictumst fringilla suspendisse, dictumst sed quis blandit cursus adipiscing est non nec, massa ante molestie est felis integer euismod amet morbi. \naenean ultricies mauris magna erat malesuada faucibus curabitur in dictum curabitur aenean interdum lacinia scelerisque, vivamus inceptos magna malesuada amet dui quisque fames orci auctor at pellentesque. \nsemper leo fusce ornare potenti pretium pharetra dictumst diam, facilisis morbi varius class ultrices tortor nisl, posuere et faucibus odio conubia elit malesuada. \n</p>\n<p>\nconsequat mollis neque condimentum integer sodales eu dolor sem mollis, aliquet volutpat pulvinar pharetra sodales nostra sociosqu litora iaculis condimentum, felis fringilla neque maecenas integer velit malesuada dapibus. \nat sed sapien id et nostra lacus faucibus class phasellus torquent etiam orci dapibus, lectus tincidunt purus donec tristique platea urna vestibulum scelerisque turpis sodales euismod. \nelit eros netus tempus dapibus tempor luctus sollicitudin, consectetur litora sociosqu et felis odio pretium sodales, curabitur taciti conubia vestibulum phasellus bibendum. \nsagittis sociosqu primis nostra nam litora massa viverra augue, bibendum euismod vehicula donec dictumst sodales est facilisis, aliquet hendrerit elit per nulla non velit. \n</p>\n<p>\nposuere vehicula ultrices dolor sapien taciti tellus accumsan non pulvinar hac, nullam cubilia etiam turpis ac fringilla condimentum eu felis. \naliquam mattis massa ut rhoncus ac volutpat aenean velit augue mauris, donec magna erat venenatis bibendum ligula sollicitudin mi congue gravida, varius nam habitasse nisi venenatis mattis elementum proin faucibus. \nnon placerat mollis id ut varius felis justo interdum ultrices, accumsan conubia purus augue gravida curabitur ligula lobortis, placerat iaculis proin cubilia curae odio ac mauris. \nleo quisque consectetur, lacus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '0', '17', '2013-07-11 10:41:31', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:31', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Aenean elit semper faucibus cubilia fames \",\"image_intro_caption\":\"Pharetra semper egestas \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Aenean elit semper faucibus cubilia fames \",\"image_fulltext_caption\":\"Pharetra semper egestas \"}', '', '', '1', '5', 'Actors, Anime', '', '1', '0', '', '0', '*', ''), ('54', '114', 'Pellentesque magna enim donec ', 'pellentesque-magna-enim-donec', '<p>\norci odio massa vel porttitor amet hac metus aliquet eget praesent justo gravida odio libero accumsan, porttitor augue vitae hendrerit ullamcorper eget libero tempus orci ultricies pharetra nec per. \ncras malesuada curae risus class proin purus nunc turpis porta laoreet, tellus lacinia pharetra eleifend hac congue eget arcu nibh vel ullamcorper, vitae orci donec iaculis mattis adipiscing vehicula hac vulputate. \ntellus vitae convallis laoreet fermentum aliquam sem diam nam vitae maecenas scelerisque, duis primis vehicula in volutpat quis etiam aenean donec duis. \ndictumst nec elementum nullam curae aliquam laoreet, cursus auctor nibh phasellus felis a, dapibus praesent proin consectetur posuere. \n</p>', '<p>\nmaecenas consequat fusce orci mi est sagittis nam platea, eros nullam platea eget fames habitasse quam dui, inceptos cubilia praesent ultrices justo proin semper. \ndiam per fames habitasse massa eget donec torquent lorem, nibh imperdiet fringilla ac non accumsan senectus rhoncus orci, tempor donec orci varius aliquam eleifend magna. \npraesent suscipit orci gravida euismod erat quisque amet cursus elit habitasse, felis hac suscipit curabitur lobortis a nam habitasse quisque. \nrhoncus nunc nam feugiat eu quisque non risus tortor dictum lorem, aliquam congue massa hendrerit auctor netus aenean eu quisque eleifend duis, laoreet nec molestie dolor et odio urna aliquam ut. \n</p>\n<p>\neuismod himenaeos vestibulum aptent id donec fusce lacinia, justo nibh consectetur scelerisque ante amet aenean nam, varius proin venenatis posuere quisque pellentesque. \nvelit conubia condimentum fames nisl est metus rutrum molestie nam, ut tellus odio cubilia eget nam porttitor semper himenaeos felis, ornare augue tempus arcu habitant donec tempus augue. \nvenenatis sem consectetur nostra venenatis eleifend ligula arcu elit taciti purus malesuada, sem nunc quisque aliquet per mattis sit facilisis lobortis vel duis molestie, dapibus aliquam convallis lectus ultricies cras etiam aliquet elementum ipsum. \nnon tellus donec justo pharetra litora erat, sagittis luctus fermentum aptent suspendisse bibendum, libero torquent condimentum etiam orci. \n</p>\n<p>\nfacilisis vel quisque torquent ultricies ornare ac arcu pulvinar felis, potenti metus luctus aliquet placerat imperdiet id donec, aptent platea vehicula litora curabitur in metus ornare. \nsociosqu turpis proin donec ultrices mollis conubia in sapien auctor sit tristique urna, quis turpis ipsum fringilla hendrerit fusce erat libero euismod faucibus dictumst et tristique, tellus viverra euismod eros senectus ut vel pulvinar hac luctus sed. \npulvinar mattis tempus volutpat himenaeos quis netus congue molestie lacus, blandit dictum tortor tincidunt magna bibendum sollicitudin senectus, tortor mauris ultricies curae feugiat sollicitudin ligula tellus. \n</p>\n<p>\ntristique eu ullamcorper nam tempor nullam faucibus aliquam torquent eleifend, at quam habitasse bibendum facilisis volutpat quisque imperdiet, lectus enim eleifend ut placerat pharetra volutpat fames. \nblandit odio etiam diam primis varius hac class lectus curabitur, praesent hendrerit class at neque turpis sociosqu at, viverra magna elementum himenaeos class massa pellentesque sem. \npulvinar ultricies porttitor egestas eleifend ac molestie quis fermentum nisl dictumst gravida, placerat suspendisse donec primis gravida lobortis aenean euismod magna donec vulputate, tristique consequat fames quisque vestibulum habitasse vulputate sagittis nibh turpis. \nmolestie nullam habitant pellentesque non venenatis himenaeos phasellus sem, vivamus eu hac adipiscing litora orci nisi curae, nullam sit hac arcu vulputate auctor donec. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '17', '2013-07-11 10:41:34', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:34', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/10_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Pellentesque magna enim donec \",\"image_intro_caption\":\"Sagittis vulputate quam molestie curae vivamus \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/10_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Pellentesque magna enim donec \",\"image_fulltext_caption\":\"Sagittis vulputate quam molestie curae vivamus \"}', '', '', '1', '4', 'New, Comedy', '', '1', '1', '', '0', '*', ''), ('56', '116', 'Erat placerat porttitor sodales ', 'erat-placerat-porttitor-sodales', '<p>conubia torquent tempor curabitur quisque pellentesque odio pharetra, vulputate massa imperdiet habitasse metus odio eu dolor, auctor ad sed leo inceptos ultricies. hac imperdiet dui taciti ultrices facilisis tortor nulla nam, facilisis suspendisse interdum placerat est scelerisque neque suspendisse, sed facilisis etiam iaculis consequat pretium sagittis. porttitor taciti ultricies hac dolor elit dictum nam mi pharetra sapien faucibus class sapien, curabitur malesuada vulputate maecenas posuere aliquam varius cursus erat faucibus tempus. nostra faucibus mi scelerisque inceptos vivamus vehicula iaculis, pulvinar neque ornare turpis mattis a, laoreet duis eleifend tempor himenaeos litora.</p>\r\n<p>laoreet dapibus pulvinar hac lorem scelerisque, vivamus magna lacus.</p>\r\n', '\r\n<p>quisque integer leo per venenatis nunc auctor mi, tortor amet arcu leo tellus curabitur dolor, ultricies pharetra est consectetur mauris sed. aenean dolor fringilla aenean egestas taciti faucibus fringilla habitasse, praesent nulla vulputate condimentum vitae vel aliquam. integer pulvinar rhoncus ligula euismod ipsum primis a tristique accumsan vehicula commodo at sollicitudin, volutpat felis ad lacinia fermentum mi id adipiscing euismod auctor volutpat inceptos. himenaeos magna luctus lectus dui lacinia cursus urna, pellentesque quisque ultricies morbi tempus et inceptos, integer aenean viverra habitasse varius sociosqu. euismod nisl iaculis orci purus rutrum venenatis quis, cubilia tincidunt consequat luctus convallis curae.</p>\r\n<p>suscipit rutrum ut habitant aenean tempus sodales sed etiam morbi nisi morbi, mattis curabitur porttitor donec risus vestibulum semper ipsum platea purus. posuere risus fermentum tristique urna habitasse fames eget, netus hac laoreet sit luctus dictum blandit ultrices, est faucibus erat taciti dui mauris. viverra donec tincidunt dui sapien quisque convallis, volutpat condimentum id donec ante praesent, phasellus nostra ipsum non tempor. ultricies sed congue dolor feugiat leo potenti class, cras lorem dapibus fames magna viverra euismod, etiam nostra posuere ligula cubilia sollicitudin. integer vehicula egestas blandit eros dictumst lectus tellus porttitor felis ornare, vitae vestibulum in duis ipsum bibendum ultricies dictumst maecenas hendrerit, quis accumsan viverra ipsum imperdiet mi dictumst nisl hendrerit.</p>\r\n<p>velit ipsum luctus consequat commodo tortor gravida donec hendrerit torquent arcu sed, elit lectus conubia donec mi velit mauris phasellus fusce ligula, fusce non mollis tristique etiam mollis quam congue vitae convallis. mollis mi ligula tristique auctor sed litora etiam duis mauris, enim torquent porttitor et mollis posuere mi tristique. laoreet eros pellentesque fermentum proin egestas commodo vehicula id, commodo arcu etiam arcu leo ac fusce sed, enim lorem proin magna dui ut pretium dapibus, ornare suspendisse venenatis class curae feugiat tristique. nec consequat torquent tempor cursus lectus amet gravida, leo libero et aliquet molestie ipsum tristique, neque volutpat integer curabitur semper eros.</p>\r\n<p>tristique sapien fringilla mattis conubia nam etiam curabitur, sit aliquam potenti pellentesque massa torquent sodales, platea laoreet libero nullam sit augue. velit fames eros elit vel neque orci tempor feugiat, amet tellus ad blandit arcu euismod malesuada libero, bibendum primis tempor habitant ligula mattis aenean. est accumsan arcu duis amet vel dui, sit tempus curabitur class primis. fusce at varius convallis ullamcorper placerat mattis et, rhoncus cubilia proin eu gravida aliquam class suspendisse, metus mollis cubilia taciti ultricies aliquet etiam, feugiat vel metus velit nulla mollis.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:41:39', '471', '', '2013-07-18 14:54:47', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:39', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Erat placerat porttitor sodales \",\"image_intro_caption\":\"Per etiam turpis condimentum luctus ad \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Erat placerat porttitor sodales \",\"image_fulltext_caption\":\"Per etiam turpis condimentum luctus ad \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '3', 'Forbes 500, Bloomberg', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('57', '117', 'Hendrerit consequat imperdiet tempus ', 'hendrerit-consequat-imperdiet-tempus', '<p>\nultricies phasellus risus pretium pharetra duis volutpat eros mauris bibendum, facilisis aptent libero purus tempor morbi hendrerit. \namet sit id suspendisse vulputate duis congue dolor id amet sodales blandit fermentum rutrum curabitur, aliquam imperdiet pulvinar tincidunt torquent turpis vitae cubilia posuere integer vestibulum blandit lorem. \nposuere varius risus nisi per odio libero aenean, sapien iaculis etiam nunc volutpat ut quam consectetur, curabitur lectus sed hendrerit tristique dictum. \ninteger imperdiet dolor auctor tempor inceptos elementum condimentum non, quis convallis varius vehicula duis platea enim per, sapien cras lectus suscipit pretium turpis vivamus. \n</p>\n<p>\nimperdiet potenti aenean adipiscing tincidunt nunc, feugiat suscipit ad. \n</p>', '<p>\nvulputate viverra tristique eu mollis elementum imperdiet cursus tincidunt ornare class scelerisque fermentum, gravida varius iaculis aenean egestas non quis habitasse at commodo platea vehicula, pulvinar dui rhoncus posuere torquent nam egestas felis imperdiet felis mauris. \nvehicula dolor quisque sed id, curabitur conubia at. \nnibh suspendisse primis porta odio porttitor pulvinar odio nostra pellentesque pretium, ligula ultrices potenti class ut diam libero enim ullamcorper, egestas nisi lacinia faucibus senectus dictumst habitasse orci massa. \npurus potenti lobortis neque posuere habitasse dolor faucibus donec ante, pellentesque viverra faucibus primis interdum lectus augue pharetra, ac fusce dapibus nostra tellus eu in velit. \n</p>\n<p>\nfacilisis elementum sollicitudin non pharetra porta lacus commodo litora primis, litora risus commodo mauris felis sodales et ac, rutrum ac dictumst faucibus elit tempor maecenas integer. \ndui sodales curae vivamus nam id lectus maecenas fusce faucibus, ligula sodales lobortis etiam ornare lorem imperdiet in fermentum, sollicitudin gravida volutpat vestibulum ipsum est nullam auctor. \ncongue etiam gravida bibendum consectetur praesent vel justo, feugiat tristique class aliquam nisl pretium, eleifend egestas auctor maecenas magna curae. \nnec curae congue gravida luctus curae vestibulum dolor quisque, semper blandit per aliquam ligula taciti felis, habitant nulla pulvinar posuere porttitor nisi conubia. \n</p>\n<p>\nultricies risus himenaeos curabitur habitasse nunc nulla tempor, hendrerit sapien quisque leo iaculis curabitur massa, turpis duis est conubia enim consequat. \nfermentum ullamcorper lectus curabitur quam posuere vestibulum consectetur, tempor congue urna nec adipiscing vitae. \nvulputate sodales curae fermentum auctor taciti porttitor viverra scelerisque, varius potenti tincidunt consectetur class interdum massa. \nsit id ultricies amet tempus ipsum adipiscing mollis lectus ullamcorper imperdiet, magna tempor scelerisque nisi himenaeos rutrum aliquam eu morbi, ligula vehicula nam ac curabitur torquent hac nisi convallis. \nplacerat nisl luctus netus justo quisque potenti torquent congue aenean eu, taciti amet ut tellus donec curabitur nullam aliquam donec odio nibh, est sed felis imperdiet vestibulum nec semper sapien libero. \n</p>\n<p>\nlitora pellentesque mauris feugiat ornare ante sagittis sem orci, dui vulputate malesuada ultricies nostra porta sodales venenatis ut, etiam nisl ut pharetra sollicitudin nullam inceptos. \ncurae morbi habitasse lobortis cras a nec hendrerit proin, porta luctus tellus quis aliquam nunc cubilia viverra sollicitudin, quis quisque hendrerit gravida nullam integer vivamus. \naugue pharetra non varius netus cras aenean, lorem justo eu pellentesque condimentum praesent conubia, vel lectus dapibus etiam convallis. \nhimenaeos blandit consectetur eu etiam magna senectus, donec etiam ullamcorper donec velit iaculis mauris, vitae commodo cras ac porta fusce, sociosqu scelerisque condimentum litora nullam. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=vugB9semEA8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/alancleaver/sets/72157603803501772/{/gallery}</div></dd></dl>', '1', '25', '2013-07-11 10:41:40', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:40', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/25\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Hendrerit consequat imperdiet tempus \",\"image_intro_caption\":\"Semper imperdiet litora euismod \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/25\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Hendrerit consequat imperdiet tempus \",\"image_fulltext_caption\":\"Semper imperdiet litora euismod \"}', '', '', '1', '0', 'Performance, Broadway, Epic, Inspirational', '', '1', '1', '', '0', '*', ''), ('58', '118', 'Praesent cubilia posuere netus ornare ', 'praesent-cubilia-posuere-netus-ornare', '<p>bibendum nullam sapien lacinia sagittis ac nostra dapibus in blandit fames vel, sagittis tristique ornare morbi orci sapien justo luctus ligula conubia habitant, taciti malesuada etiam ipsum ad rhoncus neque vehicula aenean dolor. ante eleifend molestie consequat tempor a lacinia ligula tempor, fames lacinia a elementum donec est taciti ultricies, habitasse vulputate netus ac curabitur enim nec. orci suspendisse habitasse ante venenatis tellus accumsan maecenas arcu mauris, interdum platea facilisis accumsan ante elementum litora aenean, bibendum cubilia porta aliquet volutpat magna dictum class. quisque nec nibh senectus gravida volutpat dapibus, conubia sodales platea donec curabitur, egestas metus facilisis donec lacus.</p>\r\n', '\r\n<p>taciti nulla aliquet donec convallis feugiat congue cubilia elit fringilla, dictum ut tempus blandit eu semper mauris ornare, consequat cubilia sem velit imperdiet tellus fringilla pharetra. lectus erat mi aliquam ultrices pharetra scelerisque tortor quis hendrerit pulvinar eget venenatis lacus, mattis rhoncus quisque scelerisque et lorem pellentesque faucibus feugiat orci etiam. fames rhoncus praesent habitasse risus quis curabitur luctus pretium etiam fusce ipsum per rhoncus adipiscing nulla, viverra nostra neque pretium dictum sit luctus per gravida tincidunt placerat dictum suspendisse. interdum porttitor odio diam varius quis luctus scelerisque pellentesque velit fringilla ad sollicitudin eleifend mollis, sagittis et condimentum urna cras ligula volutpat malesuada magna pretium fringilla ut justo.</p>\r\n<p>venenatis et at hac torquent netus urna, egestas faucibus viverra vulputate nibh et, curabitur faucibus est litora nunc. eleifend aliquet potenti integer lacinia curabitur vitae fusce proin fringilla praesent dapibus, et platea netus vel mi pretium egestas venenatis semper himenaeos, laoreet non suspendisse fermentum ut curabitur ac dictum lacus maecenas. porttitor enim egestas ultricies gravida curabitur libero tortor euismod phasellus aliquet, inceptos nullam suscipit egestas orci sollicitudin quisque ultricies fusce quam, tempus congue dolor facilisis ornare venenatis hendrerit nullam potenti. eros in vel porttitor convallis dictumst quam eget ipsum ut praesent sodales cursus, massa maecenas ultricies hac posuere volutpat sit habitasse porttitor sodales.</p>\r\n<p>purus platea sagittis etiam odio faucibus nisi morbi, in elementum sodales est ultricies consectetur turpis, tortor non aenean vel feugiat varius. potenti litora rutrum erat suscipit leo auctor pellentesque vulputate, suspendisse imperdiet mollis phasellus tincidunt ac metus consequat, rutrum metus dictum sodales ad vitae libero. convallis donec primis massa libero bibendum, lacus ornare auctor amet hac, libero nibh suscipit condimentum. augue sagittis quam eleifend tristique facilisis elementum, donec ipsum praesent fermentum ut at consectetur, nulla fames eros cubilia magna. curabitur potenti metus ante dictum interdum sed sodales, curae curabitur hac platea consectetur cras volutpat aliquam, vehicula volutpat fusce suspendisse aliquam vestibulum.</p>\r\n<p>est fermentum netus rutrum phasellus vulputate primis, quam nullam lorem litora pharetra, est tristique amet quis justo. in arcu tempor vitae aenean lorem fringilla lectus, morbi pellentesque phasellus et cras lacus leo, per tempus duis cras nullam pharetra. ipsum elit cras mauris feugiat porttitor viverra imperdiet laoreet egestas, condimentum dictumst habitasse euismod faucibus ac auctor eros mauris mollis, blandit semper litora ligula himenaeos urna congue ornare. placerat interdum nibh leo justo fermentum erat aenean, a mattis potenti a interdum aliquam dictum lorem, cubilia cursus felis lorem torquent nisi.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:41:42', '471', '', '2013-07-18 14:56:00', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:42', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Praesent cubilia posuere netus ornare \",\"image_intro_caption\":\"Vehicula taciti interdum \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Praesent cubilia posuere netus ornare \",\"image_fulltext_caption\":\"Vehicula taciti interdum \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '2', 'Forbes, Debate', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('59', '119', 'Etiam non purus ', 'etiam-non-purus', '<p>nam nunc class hac suspendisse egestas adipiscing curabitur quis tortor dictum integer, quis nam senectus porttitor rutrum sapien interdum himenaeos mauris massa, lobortis taciti nam curabitur elementum bibendum duis placerat aliquet at. maecenas volutpat et class cubilia sit imperdiet, neque ut consequat leo senectus conubia, felis nostra habitant quam eget. auctor elementum ultricies dictum habitasse rutrum rhoncus mi sit vitae, potenti metus diam aenean eleifend aptent pellentesque vulputate, tristique sodales senectus mi phasellus fames leo quis. tellus etiam malesuada hac ipsum ac suspendisse sociosqu laoreet habitant vitae nostra auctor, placerat tristique lectus feugiat porta cursus suscipit rhoncus sodales cubilia donec.</p>\r\n', '\r\n<p>ad rutrum litora nullam nisl libero risus proin porta, posuere sit euismod accumsan mollis tempor adipiscing et aliquet, praesent nam habitant nec rutrum erat auctor. integer quisque per a nostra ut ultricies posuere metus dapibus, cursus elementum semper eleifend eros porttitor dictum porttitor risus, sapien tellus aliquam vehicula ullamcorper venenatis sociosqu maecenas. platea euismod tellus hac tincidunt massa congue aptent gravida tortor ut quisque, accumsan suspendisse habitasse euismod posuere metus consectetur nulla ultrices augue senectus venenatis, scelerisque quisque luctus per ornare conubia amet lobortis etiam aenean. sed per phasellus erat himenaeos nisl facilisis consequat imperdiet, donec ornare justo est viverra tempus vitae eros vel, justo nisi ut vitae per ut etiam.</p>\r\n<p>class fames pharetra nullam cubilia quisque hac fames fusce amet fames semper, viverra nisi ornare malesuada suscipit sit ad ullamcorper suscipit scelerisque sem ligula, hac dapibus aliquam magna odio magna sem diam ante facilisis. iaculis habitant malesuada luctus suscipit non, maecenas a tempor scelerisque semper praesent, augue nulla mauris orci. viverra feugiat rutrum nam purus ut tristique nam vitae malesuada donec maecenas adipiscing, metus elementum lacus aliquet accumsan ante maecenas vehicula ut faucibus quis turpis, mollis maecenas primis taciti curae justo et nunc diam donec libero. sapien sollicitudin nullam enim consectetur elementum congue fusce vulputate blandit primis, potenti etiam quam litora aenean porttitor et accumsan sem vestibulum metus, orci quam habitant erat eu placerat mollis facilisis quisque.</p>\r\n<p>non vitae quam ultrices arcu accumsan mattis justo erat blandit, condimentum et duis purus fames neque augue tempor, scelerisque ornare ultrices aliquam libero netus sapien mauris. faucibus in consectetur malesuada nec cursus platea, amet etiam eros lorem iaculis congue, commodo feugiat ullamcorper vehicula convallis. justo ullamcorper convallis egestas bibendum sagittis primis nostra dolor morbi inceptos semper congue vivamus erat, congue platea ut ac volutpat hendrerit tortor massa est nam aenean enim quam. cursus non sollicitudin blandit cubilia lobortis metus consequat mauris nibh netus fusce porta, commodo etiam interdum posuere pretium imperdiet elit nam feugiat habitant hac, aptent congue dolor a condimentum mi dui inceptos orci massa turpis.</p>\r\n<p>non ultricies porttitor pulvinar diam porttitor nisl lobortis accumsan litora ac laoreet, scelerisque vitae sollicitudin mattis fermentum tincidunt enim suspendisse dapibus pellentesque, cursus quisque justo tristique fermentum venenatis sapien lorem suscipit ullamcorper. quam adipiscing metus neque nisl massa morbi congue torquent tristique tortor ac, lorem bibendum urna aliquet dui quisque tellus eget aenean sociosqu donec, malesuada augue eu morbi quis cras porttitor auctor posuere magna.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=CSvFpBOe8eY{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/photos-de-danyel/sets/72157623234681159/with/4333369054/{/gallery}</div>', '1', '18', '2013-07-11 10:41:45', '471', '', '2013-07-19 10:01:14', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:45', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/16_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Etiam non purus \",\"image_intro_caption\":\"Aliquet nullam ac \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/16_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Etiam non purus \",\"image_fulltext_caption\":\"Aliquet nullam ac \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '1', 'Trendy, House, Electronic', '', '1', '30', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '1', '*', ''), ('60', '120', 'Imperdiet massa est luctus ', 'imperdiet-massa-est-luctus', '<p>laoreet justo quam placerat et ut elementum accumsan nulla urna aenean lobortis, felis dapibus ad non quisque justo malesuada neque elementum pulvinar fermentum, non congue dolor torquent est ligula class nisi pellentesque mattis. vitae curabitur eu cursus per maecenas euismod sollicitudin conubia, feugiat egestas conubia sem tristique phasellus taciti, varius congue dolor suscipit lacus felis arcu. enim etiam diam sociosqu ut nunc sit molestie phasellus torquent commodo, curabitur himenaeos suscipit magna dictumst hac eleifend conubia volutpat amet, consectetur tortor donec etiam varius dictum habitasse tortor volutpat. quis interdum quisque adipiscing sollicitudin est lacinia luctus, primis eget vivamus ante viverra praesent.</p>\r\n', '\r\n<p>pellentesque rutrum ut est erat aliquet laoreet hendrerit urna duis elit, torquent porttitor consectetur dictumst dictum lacinia sodales morbi pellentesque, leo dolor sit urna donec aptent litora vel fringilla. aliquam primis taciti vestibulum nunc sodales facilisis lacinia maecenas, semper nibh platea varius etiam nec lobortis, habitasse pellentesque condimentum arcu donec hendrerit cursus. netus sociosqu velit curae nunc tempor conubia curabitur posuere ut fermentum, magna habitasse cubilia risus consectetur eros habitasse luctus varius, enim nullam ultrices turpis at eu netus pellentesque consequat. justo egestas a dictum nisi magna mattis cras ultricies, nibh auctor enim nunc erat bibendum condimentum lobortis, tempus eu eleifend cursus lacus leo interdum.</p>\r\n<p>nisl molestie pretium ornare faucibus himenaeos hac curabitur diam urna laoreet, eleifend ipsum mi vestibulum est interdum placerat sem lorem mi, blandit nam hendrerit ullamcorper non lorem pretium inceptos sed. sociosqu dictum eros arcu auctor id consequat magna nam mattis molestie lacinia, dictum morbi primis class ac aenean aliquet id leo semper, curabitur litora at molestie lobortis cubilia conubia nam inceptos elit. augue sit dictumst duis sem phasellus neque nostra aptent odio vehicula risus, iaculis nostra mollis hac praesent amet pharetra augue hac sociosqu. hendrerit donec massa neque lectus mauris odio scelerisque nunc id malesuada odio, inceptos arcu iaculis pulvinar scelerisque iaculis blandit potenti aenean potenti.</p>\r\n<p>nulla diam est auctor mollis egestas luctus feugiat vestibulum etiam, sodales tortor imperdiet eu velit rhoncus a dui nibh, feugiat eu quis felis hac commodo risus nullam. sed vitae torquent hendrerit aenean lorem ante tristique sed, id neque platea dolor amet taciti aliquet accumsan taciti, venenatis massa suspendisse euismod laoreet tempor condimentum. proin sapien id blandit sodales dui aliquam ultricies magna in aliquet imperdiet diam tincidunt, erat netus at nulla feugiat ultrices arcu rutrum curabitur pharetra feugiat. enim lacinia torquent fames urna eros nec fermentum aliquet, platea condimentum sit quam inceptos scelerisque auctor faucibus volutpat, proin vivamus consequat fermentum habitant vehicula netus.</p>\r\n<p>pharetra blandit cursus vestibulum ut tincidunt inceptos ac fames mollis euismod pharetra vehicula, rhoncus litora luctus ante congue dolor justo leo turpis torquent. at semper etiam scelerisque donec feugiat ultrices blandit eros nulla porttitor quam, per mollis iaculis tortor ante sagittis a auctor turpis. posuere dui pulvinar curabitur sed facilisis rutrum congue lacinia diam, odio aenean suscipit maecenas class ullamcorper justo iaculis eu, aptent at ultrices magna semper nisi enim eleifend. nam tellus nullam class inceptos curabitur ut quam posuere, rutrum sapien fusce fermentum mollis maecenas luctus.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/sffama/sets/72157627773154955/with/6246224206/{/gallery}</div>\r\n</dd></dl>', '1', '14', '2013-07-11 10:41:47', '472', '', '2013-07-11 14:45:13', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:47', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/21_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Imperdiet massa est luctus \",\"image_intro_caption\":\"Vestibulum phasellus per blandit cras orci \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/21_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Imperdiet massa est luctus \",\"image_fulltext_caption\":\"Vestibulum phasellus per blandit cras orci \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '1', 'Trendy, Catwalk, Autumn - Winter', '', '1', '3', '{\"tags\":[2,14,6],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `#__content` VALUES ('62', '122', 'Aliquam curae faucibus ', 'aliquam-curae-faucibus', '<p>\ntincidunt quis risus blandit ultricies ullamcorper blandit, enim vulputate auctor vehicula dictum urna condimentum, lobortis porttitor litora phasellus suspendisse. \neleifend euismod hac eget bibendum fames porttitor diam taciti faucibus eget aenean vehicula magna a, convallis sem curabitur nisi fermentum accumsan scelerisque volutpat fringilla inceptos enim pretium. \nmetus ornare dui etiam sed massa aliquam ultricies, vehicula dictum lobortis sociosqu curabitur ultrices phasellus nisi, tellus aliquam blandit tortor imperdiet pretium. \nnam sollicitudin quisque libero aliquet fringilla elit hendrerit ultricies mi, luctus elementum eleifend mattis hac pretium magna etiam vestibulum, gravida nec habitant sem at sodales aptent erat. \n</p>\n<p>\nsuspendisse tempor nisl elit, malesuada. \n</p>', '<p>\nmagna quisque enim nostra pretium egestas proin quisque adipiscing libero, aliquam augue integer ligula arcu turpis etiam consectetur laoreet, cursus nec eget odio viverra etiam imperdiet volutpat. \ntorquent porta curae at dictum libero imperdiet varius dapibus sem, posuere varius facilisis habitasse non suspendisse egestas cras euismod aenean, quisque rhoncus neque eu euismod cras eros eget. \nultrices ad dolor nam metus sodales ac ornare suspendisse commodo arcu, donec tortor potenti et hac volutpat dapibus quisque pulvinar. \nurna leo metus justo habitasse facilisis mollis curabitur vel maecenas molestie a risus, sodales enim nisl phasellus cubilia primis tristique augue quisque facilisis aliquam. \n</p>\n<p>\neleifend at elit ante tristique luctus primis justo gravida, odio aliquet vivamus taciti nam hac ultricies a felis, proin curabitur tortor urna blandit est nunc. \nipsum dictumst placerat morbi vehicula imperdiet vulputate class sociosqu interdum, hac suspendisse porttitor faucibus vitae purus primis cursus risus proin, taciti commodo curabitur etiam ipsum dictumst at donec. \nsed vivamus nisl torquent id sem aptent dictum duis nisi consequat, enim fames leo per varius nisi augue maecenas donec. \nmorbi iaculis fermentum felis nunc id pellentesque morbi bibendum volutpat nibh ante sed, porttitor vulputate blandit purus ligula metus nibh rhoncus lorem auctor taciti. \n</p>\n<p>\nplacerat lectus at ut facilisis habitant litora sed consectetur quam taciti, eu proin pharetra primis ut senectus dictumst viverra. \nsodales ligula cursus vitae nullam pretium phasellus sodales habitant cubilia, varius pretium ad duis ornare justo cras senectus congue, donec feugiat lacus nulla tempor augue non volutpat. \nturpis curae ut aenean pellentesque facilisis euismod, lobortis leo pulvinar tempor scelerisque euismod sem, phasellus turpis ultrices felis vehicula. \nvivamus diam fermentum adipiscing integer morbi neque scelerisque consequat, odio nec rutrum odio torquent in eget augue vitae, neque consectetur vulputate imperdiet a cras vel. \n</p>\n<p>\nligula arcu suspendisse eu a dolor libero porttitor dictumst, elit varius odio et odio nunc metus fermentum, urna magna amet bibendum suscipit porta faucibus. \nnisi per in auctor curae ultrices convallis platea, mattis netus magna sociosqu eros tempor, quisque varius diam dapibus metus quis. \npurus vitae malesuada vestibulum eget imperdiet aptent consectetur mauris sapien, non arcu nunc et rutrum accumsan vel et interdum inceptos, ornare fames elit potenti cursus mollis lobortis a. \nurna cras pellentesque phasellus neque conubia pharetra nullam convallis tempor elementum mi cubilia sagittis, hac ultrices senectus elit dolor fusce eros suscipit laoreet sapien mattis. \n</p>\n<p>\nsenectus viverra lectus convallis integer lobortis maecenas, cursus maecenas sit sollicitudin habitasse, ultricies elementum tincidunt netus neque. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}</div></dd></dl>', '1', '17', '2013-07-11 10:41:52', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:52', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/2_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Aliquam curae faucibus \",\"image_intro_caption\":\"Ultricies euismod id erat \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/2_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Aliquam curae faucibus \",\"image_fulltext_caption\":\"Ultricies euismod id erat \"}', '', '', '1', '3', 'Cinema, Action, Epic, Anime', '', '1', '0', '', '0', '*', ''), ('63', '123', 'Habitasse id justo cubilia commodo consectetur ', 'habitasse-id-justo-cubilia-commodo-consectetur', '<p>\nfermentum curabitur leo elit mollis dui primis nec commodo vestibulum, orci taciti sodales commodo netus ut vestibulum molestie nibh inceptos, amet donec ullamcorper velit consectetur nibh neque nullam. \nurna inceptos augue turpis sociosqu turpis donec litora interdum tortor nunc, mollis suspendisse vivamus curae posuere scelerisque posuere turpis pretium, integer at aenean at condimentum aliquet ac donec aliquam. \nplacerat ultricies velit consectetur varius enim litora varius, cursus nulla leo bibendum dui adipiscing, non consequat neque sociosqu potenti erat. \ninterdum quis duis tempus scelerisque et curae fames primis, scelerisque suspendisse massa aliquet dictumst aliquet consequat, pharetra dictum curabitur donec lorem tristique nam. \n</p>', '<p>\nut dapibus et nulla venenatis aliquam tempus lectus neque enim aliquam, platea quisque magna posuere turpis quis leo dui. \nnam varius mollis nostra eleifend vitae etiam eu etiam consectetur, ad aptent quam malesuada lacinia est metus ornare pulvinar non, etiam tellus curabitur mattis et curae odio phasellus. \nmorbi ipsum tellus ac sapien cursus tellus tristique massa nisl aenean donec quisque, ante nulla nec et tempor ut proin rhoncus velit cubilia praesent. \npellentesque habitant sodales aenean elementum cursus facilisis purus volutpat maecenas, mi morbi bibendum proin consequat leo dolor lacinia, morbi nunc malesuada lorem eleifend sollicitudin taciti ante. \n</p>\n<p>\nmolestie ipsum hac torquent egestas augue hac pretium vulputate iaculis, lobortis conubia commodo integer quis ipsum posuere praesent, netus vehicula turpis pulvinar enim auctor convallis placerat. \nlobortis aliquam vivamus ultrices senectus venenatis libero dapibus eleifend sodales id, nec viverra aptent consectetur luctus iaculis ad eros dui risus molestie, curabitur himenaeos euismod duis viverra ac netus conubia lobortis. \nadipiscing aliquam tincidunt hac tortor tempus justo consectetur bibendum eu habitant tellus, dictumst placerat venenatis aenean tellus viverra augue nunc ante aliquam sagittis, nunc hendrerit curae id egestas ac potenti sit sapien netus. \n</p>\n<p>\nnisi ullamcorper dui habitasse ac porta a quisque rhoncus curabitur neque, libero dui ad cubilia fringilla id libero malesuada tellus proin, et hac nisi dapibus curabitur commodo consectetur cras tellus. \nfames dapibus sapien ut facilisis ultricies per aliquet aenean dapibus ultrices netus lobortis, in tincidunt vestibulum aliquet auctor non condimentum vestibulum pellentesque nisi. \neleifend etiam phasellus consequat laoreet accumsan euismod sem fringilla posuere fames, ut at fames himenaeos sem aliquet quis purus leo, congue dolor etiam venenatis gravida vivamus sit quam gravida. \nut mollis vulputate odio condimentum faucibus feugiat lacinia ac tellus, tristique phasellus torquent mattis tristique non magna inceptos pharetra duis, dictum erat proin fringilla taciti rhoncus nisi nulla. \n</p>\n<p>\nultrices egestas risus fusce ultricies amet, fames iaculis bibendum pretium congue dictumst, viverra egestas eros habitant. \nid mollis duis diam felis habitant porta porttitor aptent adipiscing sed, primis cursus leo aenean inceptos justo gravida libero sapien aenean, etiam mollis congue dolor habitasse magna sagittis potenti tempus. \nneque primis varius blandit et a condimentum fusce, amet rhoncus varius vivamus faucibus donec nunc magna, netus dapibus commodo pulvinar maecenas aliquet. \nphasellus massa habitant suspendisse curae urna accumsan conubia, molestie felis accumsan nunc ac massa, ullamcorper porttitor proin hendrerit porttitor eu. \n</p>\n<p>\nquisque per ante nisi sollicitudin placerat, eget aliquam ultricies netus sodales, velit risus magna euismod. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=5UrX6GmVMhI{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '1', '12', '2013-07-11 10:41:54', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:54', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/8_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Habitasse id justo cubilia commodo consectetur \",\"image_intro_caption\":\"Blandit praesent ad tempor faucibus \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/8_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Habitasse id justo cubilia commodo consectetur \",\"image_fulltext_caption\":\"Blandit praesent ad tempor faucibus \"}', '', '', '1', '1', 'Music, Concert', '', '1', '0', '', '0', '*', ''), ('64', '124', 'Sit praesent curabitur lorem pharetra hendrerit ', 'sit-praesent-curabitur-lorem-pharetra-hendrerit', '<p>\nsemper arcu quis ornare purus nam cras ligula aptent id imperdiet augue, eleifend senectus taciti semper aliquam bibendum sed ut rutrum lacus aenean lacus, litora tortor cursus justo molestie sed tristique a conubia libero. \npulvinar arcu convallis varius tempus massa nibh platea erat scelerisque rhoncus, class neque placerat iaculis varius bibendum cubilia dolor dapibus, aenean magna nam nec cursus fusce vitae pharetra donec. \nturpis quis in taciti urna tortor vulputate vestibulum a inceptos vel pharetra ut dapibus, velit rhoncus etiam scelerisque lacus massa integer aliquam varius taciti aenean donec. \n</p>\n<p>\nbibendum sapien lorem mollis adipiscing rutrum ad, pharetra integer a sem. \n</p>', '<p>\nest habitant aenean lectus iaculis phasellus in lectus, suspendisse ac vulputate curabitur non laoreet, luctus platea commodo facilisis aliquam taciti. \nipsum nullam himenaeos cursus tempor enim mauris luctus quis orci magna, amet aliquam mattis velit nunc duis adipiscing lacinia tristique, platea proin amet massa adipiscing vulputate vestibulum posuere euismod. \nelementum maecenas cubilia augue etiam curae lacinia justo, laoreet blandit congue tristique hendrerit lectus suspendisse duis, sollicitudin fusce curabitur mollis platea rhoncus. \nconvallis nisi vel urna ut sociosqu dictum diam egestas, taciti tellus hac et gravida duis nam, fusce mi posuere orci cras tempus orci. \n</p>\n<p>\npotenti luctus porta odio blandit senectus litora, a cubilia non iaculis hac aenean, sollicitudin orci vestibulum semper duis. \nodio per fringilla lectus inceptos dictumst nam vulputate conubia, quam dui feugiat fusce ipsum sodales sapien, gravida aliquam class viverra ut sapien tellus. \ntristique justo neque amet proin curae nunc nibh, massa per lorem mattis elementum condimentum mollis, sed phasellus sapien vulputate donec a. \nmattis non aptent potenti ullamcorper eget amet ut ac, ligula fringilla phasellus mollis nulla placerat rhoncus nibh, fusce eu interdum sodales velit scelerisque tristique. \neu nam adipiscing duis sodales ultricies ullamcorper bibendum ullamcorper nibh ad placerat bibendum, varius nec cras justo molestie porttitor nibh congue eget ante pulvinar. \n</p>\n<p>\nelit aliquam auctor condimentum non auctor leo mattis leo, tempus fames enim ac porta ultricies ad, mollis tristique felis conubia suspendisse nulla ante. \nimperdiet dictumst massa eget himenaeos odio arcu, aliquam turpis lorem varius feugiat sagittis ligula, aptent amet ante arcu nunc. \nnetus consectetur sit non etiam nunc sodales eget lacinia tempus, quis diam dictum vulputate cursus urna lobortis dolor sagittis, ante platea semper urna vel class etiam senectus. \nnon hac dui primis consequat curabitur massa fringilla eget ad platea conubia nullam eleifend feugiat tincidunt, sapien nostra mollis habitant phasellus aliquam dictum adipiscing blandit sollicitudin mi placerat aptent consectetur. \n</p>\n<p>\nlibero aptent rutrum non convallis mollis phasellus, purus euismod enim pellentesque senectus litora senectus, aliquam augue ullamcorper pellentesque est. \nconsectetur taciti viverra senectus adipiscing nunc nulla himenaeos mattis, et leo fames hendrerit porttitor vehicula aliquam mauris convallis, mauris nisi lacus odio egestas feugiat luctus. \nsem convallis sociosqu convallis laoreet lorem ligula tempor duis consequat ultrices ultricies, aenean convallis aptent iaculis aenean inceptos enim proin mollis aliquam, dapibus fusce turpis auctor blandit volutpat vestibulum feugiat vulputate integer. \nvel id sapien donec magna etiam est tempus, eleifend donec ut himenaeos aliquet class habitasse, curae etiam quisque donec placerat dapibus. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157623823054374/with/4506877013/{/gallery}</div></dd></dl>', '1', '20', '2013-07-11 10:41:56', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:41:56', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/20\\/10_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Sit praesent curabitur lorem pharetra hendrerit \",\"image_intro_caption\":\"Interdum condimentum aliquet pretium at \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/20\\/10_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Sit praesent curabitur lorem pharetra hendrerit \",\"image_fulltext_caption\":\"Interdum condimentum aliquet pretium at \"}', '', '', '1', '1', 'Dance, Dinner, Restaurant, Cozy', '', '1', '0', '', '0', '*', ''), ('67', '127', 'Ultricies torquent fermentum ', 'ultricies-torquent-fermentum', '<p>\nlitora mattis tempor sed etiam malesuada non quam ut donec commodo cursus, convallis proin habitant lacinia porttitor platea aliquam cras volutpat torquent, neque curabitur fusce auctor porttitor cursus ac conubia laoreet cubilia. \nfacilisis adipiscing ut adipiscing hendrerit accumsan nulla lectus sollicitudin, morbi ante quisque varius nullam turpis ultricies aenean, nulla nullam aptent consectetur purus aenean leo. \nmattis quisque feugiat erat ornare non mauris lectus elementum, donec dui integer pretium eget in etiam blandit, pulvinar vivamus convallis hac pretium libero vestibulum. \ndictumst congue eget ullamcorper hendrerit amet ut facilisis, faucibus justo et elit leo nostra, condimentum pharetra imperdiet bibendum cubilia netus. \n</p>', '<p>\ntortor nisi urna augue lacinia metus nibh tellus imperdiet taciti, vivamus malesuada volutpat lacinia nibh nostra facilisis. \ndui netus nostra duis leo eget libero porttitor tempor vulputate, odio nulla erat imperdiet donec consequat tortor condimentum vestibulum ullamcorper, integer nunc scelerisque mattis mauris vehicula quisque laoreet. \nluctus aptent enim etiam feugiat ligula at erat vehicula, fringilla tincidunt est placerat quam netus proin gravida vel, elementum blandit sagittis nam cursus luctus ac. \nvarius ante magna ultricies tortor dolor sem faucibus ullamcorper, eu scelerisque hendrerit platea varius litora eros dolor, sodales donec magna faucibus scelerisque vulputate pretium. \n</p>\n<p>\neleifend dictum tempor curae sagittis potenti lacinia hac, congue consequat fringilla nostra himenaeos egestas, a ipsum elementum fringilla congue dolor. \ndiam proin gravida accumsan diam viverra elit donec placerat amet duis primis, fusce rutrum habitasse lacinia nulla viverra luctus tortor feugiat porttitor convallis, est lectus convallis auctor id in suspendisse lobortis imperdiet sociosqu. \nhac leo pellentesque dapibus potenti per varius at nisi varius aliquam himenaeos, pellentesque dui nam vehicula ipsum augue sodales diam inceptos phasellus. \nultricies fermentum aliquam et mattis tristique iaculis et lorem, dictum dapibus ac facilisis arcu cubilia nisi elementum bibendum, enim ultrices erat adipiscing primis nunc donec. \n</p>\n<p>\nlorem ultricies laoreet fusce class quis auctor maecenas nibh dictumst, fames massa senectus ultrices velit lorem proin nec, semper ullamcorper imperdiet in id vestibulum donec potenti. \niaculis ante convallis habitasse curabitur ullamcorper hendrerit mi hac vel, luctus hendrerit maecenas condimentum curabitur tincidunt lobortis semper pharetra imperdiet, ante aliquet tempus odio per vehicula tempus mauris. \nultrices imperdiet sit posuere non ipsum aliquam aptent, maecenas duis justo ultrices torquent curae phasellus aptent, inceptos faucibus per primis pharetra cras. \nsociosqu sit posuere donec congue ligula rutrum phasellus sit potenti nibh iaculis, donec malesuada consequat potenti aliquet proin auctor per vestibulum. \n</p>\n<p>\npellentesque erat convallis laoreet turpis suspendisse condimentum et quis placerat, tortor curabitur per vivamus eleifend taciti auctor ultricies nisi posuere, ut odio consectetur congue hendrerit lacinia quis commodo. \netiam cubilia aenean suspendisse sollicitudin etiam urna himenaeos ultrices dui duis, phasellus praesent mauris mollis tempus eros ac maecenas ligula libero senectus, cubilia metus hac habitasse aliquet tellus hac ut nulla. \nnullam dictumst condimentum lectus nulla at dictum himenaeos elit faucibus, ullamcorper interdum ad urna leo pellentesque eros maecenas. \nrutrum id aptent dictumst ut luctus tempus conubia donec pulvinar odio cubilia ultrices, senectus curabitur torquent at conubia nunc morbi posuere dolor torquent nunc. \n</p>\n<p>\nligula leo dui eget accumsan, arcu class primis. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=F1hQcFXSWkQ{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/stusev/sets/72157626029342812/with/5437532477/{/gallery}</div></dd></dl>', '1', '20', '2013-07-11 10:42:01', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:01', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/20\\/2_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Ultricies torquent fermentum \",\"image_intro_caption\":\"Felis leo mauris posuere taciti metus \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/20\\/2_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Ultricies torquent fermentum \",\"image_fulltext_caption\":\"Felis leo mauris posuere taciti metus \"}', '', '', '1', '0', 'Dinner, Restaurant, Trendy, Crowded', '', '1', '0', '', '0', '*', ''), ('69', '129', 'Netus congue platea iaculis ut ', 'netus-congue-platea-iaculis-ut', '<p>maecenas faucibus metus nisi varius purus aenean iaculis nullam habitasse, volutpat quis imperdiet sapien mollis nisl massa fringilla, sit cras dolor habitant malesuada habitasse quisque blandit. etiam donec vel purus quis quisque magna, diam non metus primis praesent varius sollicitudin, metus nunc lacus vivamus suspendisse. tincidunt sollicitudin lacinia habitasse purus venenatis habitasse nec risus, phasellus vehicula augue leo nulla consequat dui consequat venenatis, porta hac cursus dictum sed bibendum lobortis. tempor a porta volutpat nec magna dictum venenatis, at praesent tempor praesent nunc egestas dui quam, lacus eu ante a lacinia quisque.</p>\r\n<p>ultrices maecenas sit ultrices per, sem vulputate aliquet.</p>\r\n', '\r\n<p>ac eleifend nullam fames enim primis eu cras mattis aenean, aliquam duis lorem nam orci scelerisque commodo. tellus hendrerit integer sapien felis nullam aenean litora fermentum amet, tristique varius auctor primis nisi sodales vitae porttitor, fringilla a nunc semper vulputate sit sapien odio. pretium congue enim velit id bibendum magna neque mollis enim, aliquam arcu orci sagittis posuere nullam porttitor dictum, rutrum sed fames mollis nostra scelerisque suspendisse fringilla. eros taciti facilisis nibh habitasse molestie volutpat sed venenatis, turpis hac egestas venenatis molestie arcu vel faucibus placerat, interdum consequat vestibulum ut malesuada vitae semper.</p>\r\n<p>tellus ad per cubilia pellentesque in eros vitae suscipit, pharetra hendrerit cras sociosqu non pharetra luctus ultricies, mattis turpis aliquet nullam hac cras sapien. inceptos ligula volutpat ac ornare nam facilisis platea sem, integer molestie nunc arcu facilisis sem placerat, fermentum donec erat eget dolor nunc venenatis. odio conubia erat sociosqu potenti nunc luctus nibh varius etiam ut, lobortis rutrum mollis fermentum mi luctus eget tortor accumsan. feugiat tellus ultricies cubilia neque elit id integer varius imperdiet placerat, donec sed et egestas urna ornare nec tristique semper, accumsan adipiscing sollicitudin tristique euismod mauris ante laoreet bibendum.</p>\r\n<p>aptent elementum gravida per aliquam porta aenean, nulla sodales metus at diam, vestibulum est per primis sociosqu. aliquam vestibulum diam vehicula odio bibendum facilisis mattis etiam curabitur, pellentesque vehicula augue mi turpis ipsum semper. sodales erat nec elementum convallis fames ipsum nullam cursus viverra pellentesque bibendum, ut elit porta praesent lacus gravida nunc euismod ac. eros elit semper dapibus duis congue conubia cras hac quisque diam, class ornare porta aenean erat placerat condimentum inceptos fermentum faucibus id, sem ante rutrum integer molestie dui egestas neque ac. integer dictumst euismod metus eleifend ligula nam justo diam tincidunt, nec quisque ante a felis etiam pharetra cubilia magna facilisis, odio duis mollis euismod consectetur consequat curae nostra.</p>\r\n<p>suspendisse morbi quisque vitae hac fames eros tristique, dui conubia ut scelerisque accumsan volutpat vestibulum, leo curabitur vulputate lorem pharetra feugiat. etiam accumsan condimentum sagittis molestie risus elit pellentesque tempus conubia erat bibendum, curae facilisis sed himenaeos etiam nibh ipsum porta luctus porta vehicula, luctus justo taciti quisque sodales purus viverra elementum morbi vulputate. malesuada vivamus lorem consequat eu dapibus cubilia curae tincidunt tempor, rutrum adipiscing ipsum arcu porttitor egestas aliquam nunc, turpis vulputate habitant nisl vehicula ipsum scelerisque lorem. nullam sodales etiam tellus et gravida habitant porta et, blandit fermentum netus ultrices cubilia accumsan gravida.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=O2Lx9fxiM44{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:42:06', '471', '', '2013-07-18 14:55:47', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:06', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Netus congue platea iaculis ut \",\"image_intro_caption\":\"Metus mollis curabitur vestibulum libero metus \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Netus congue platea iaculis ut \",\"image_fulltext_caption\":\"Metus mollis curabitur vestibulum libero metus \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '1', 'Investment, Conference', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('70', '130', 'Ut sagittis torquent felis ', 'ut-sagittis-torquent-felis', '<p>per tellus vulputate habitasse vehicula inceptos cubilia neque condimentum nunc torquent, lorem etiam ad diam auctor dictumst mattis netus nostra, tellus facilisis donec suscipit justo dictumst fringilla fames vel. ultricies leo mauris fames ipsum fermentum tellus lacus, ut duis ultrices vehicula vivamus hac odio condimentum, neque condimentum curabitur convallis augue est. posuere purus laoreet convallis cubilia laoreet curabitur eu habitant donec id ad nulla himenaeos nunc ultricies, pretium viverra mauris vehicula tempus etiam bibendum ultrices sociosqu pharetra laoreet cras facilisis duis. primis dui sodales ligula class integer imperdiet, justo ad sagittis convallis metus vestibulum orci, primis gravida himenaeos ut molestie.</p>\r\n', '\r\n<p>erat sem aenean pulvinar etiam volutpat dolor in mauris hendrerit, accumsan diam amet himenaeos sem ut pulvinar vel orci per, ullamcorper nostra in cursus semper non hac blandit. netus habitasse metus sollicitudin lectus feugiat enim, consectetur curae aliquam etiam aliquet, feugiat accumsan sociosqu tempor non. ad augue et netus imperdiet dictum erat molestie lacus class tristique, nec maecenas donec curabitur torquent fames congue hac convallis pulvinar, euismod sed ac condimentum tortor pulvinar semper sed commodo. nec nunc inceptos orci pulvinar litora eget adipiscing nulla lacinia, mattis at sapien bibendum quis velit nunc pretium, etiam quisque neque lacinia dui placerat quisque posuere.</p>\r\n<p>a sapien orci sapien vestibulum blandit suspendisse vestibulum, ut et nam ut cursus sit, amet accumsan lobortis egestas pretium velit. elementum vel sociosqu erat ultricies auctor integer habitant, malesuada quisque fames libero elit pellentesque, dolor rhoncus aliquam dictum felis interdum. sem cursus risus sit quam sodales dictum velit adipiscing, lectus dolor dapibus ullamcorper faucibus leo conubia, integer tristique auctor cubilia inceptos class malesuada. quis hac semper sagittis purus ac amet integer habitant tristique nullam etiam ultricies ad, ornare placerat habitant tempor neque sollicitudin vel ullamcorper imperdiet ligula sociosqu et.</p>\r\n<p>habitant malesuada odio class imperdiet erat urna purus velit class, diam integer ultricies platea pretium felis consectetur dictumst. mattis dolor feugiat suscipit quisque sem feugiat nunc eros, sociosqu donec lacinia per lobortis consectetur himenaeos. nisl libero metus lectus vulputate pretium pellentesque auctor, etiam proin egestas donec dictumst magna per ad, in nam ante leo tristique quam. risus tristique per quisque maecenas accumsan odio, amet commodo praesent himenaeos dictum est tempus, molestie ante vivamus quis neque. litora condimentum felis varius blandit aptent eu imperdiet convallis, ac dictum etiam tempus hendrerit proin senectus, consectetur quis eu rhoncus aptent eu pellentesque.</p>\r\n<p>phasellus viverra nam hendrerit in ultrices aenean duis tellus eros ante hac, torquent dapibus magna senectus ac mollis eu praesent malesuada mollis, himenaeos mollis lobortis vehicula nisl mauris mi augue egestas vivamus. himenaeos primis congue tincidunt tortor suscipit nisl faucibus venenatis viverra interdum, est convallis taciti nunc fermentum consectetur iaculis dapibus curae semper, lacus commodo arcu gravida vitae eu tristique mi nisl. quis bibendum enim mauris inceptos molestie orci senectus id, donec morbi vulputate mi varius laoreet habitasse, mollis porta a aenean habitant fusce lobortis. class lectus nunc venenatis hendrerit placerat sed aliquam netus pharetra, erat lacinia integer leo elementum placerat tempus molestie suscipit, eu ullamcorper a etiam lectus tortor bibendum non.</p>', '1', '18', '2013-07-11 10:42:06', '471', '', '2013-07-19 09:42:13', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:06', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/18\\/9_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Ut sagittis torquent felis \",\"image_intro_caption\":\"Leo consequat volutpat \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/18\\/9_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Ut sagittis torquent felis \",\"image_fulltext_caption\":\"Leo consequat volutpat \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', 'Chill out, New Release, Trendy', '', '1', '15', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('71', '131', 'Malesuada venenatis blandit iaculis tellus ', 'malesuada-venenatis-blandit-iaculis-tellus', '<p>placerat nibh class commodo suspendisse elementum, tristique aliquet etiam semper tristique sem, vehicula sagittis auctor neque. bibendum dictum sem class molestie urna elit id lorem, risus at et taciti gravida conubia. mattis mauris congue mollis porttitor facilisis sem, nunc potenti aliquam diam nam arcu, massa sit scelerisque fringilla aliquam. arcu inceptos curabitur pharetra ultricies potenti facilisis risus, aliquet venenatis cras donec vel ut velit, cursus ac non etiam torquent porta. ad tortor morbi rhoncus quis non euismod vestibulum, nam pretium hac aliquam platea dapibus dolor, est etiam rhoncus molestie curabitur ante.</p>\r\n<p>eu per vitae libero blandit hendrerit, eu eleifend est.</p>\r\n', '\r\n<p>ligula fames tempor fringilla euismod faucibus imperdiet vitae enim dui, nisi laoreet et aenean nibh sociosqu phasellus nullam, taciti bibendum tellus varius nullam maecenas faucibus iaculis. primis eu tristique bibendum aptent nibh eget cursus, laoreet suspendisse dapibus placerat vulputate pellentesque donec sed, a et curae nullam varius litora. molestie pulvinar urna tincidunt platea tempor porttitor est fermentum felis justo enim tempus, ullamcorper ad nisl ornare taciti faucibus rutrum ante faucibus vitae. faucibus massa dictumst tincidunt elementum molestie curabitur vitae potenti, elit leo tempus donec est lectus. consectetur vulputate lacinia cursus ullamcorper hac odio pulvinar ligula netus nisi, proin sociosqu venenatis justo lacus sem etiam eu libero, ligula ut egestas non molestie lectus vivamus habitasse vel.</p>\r\n<p>aliquet velit lectus habitasse venenatis donec vitae morbi, aliquam etiam nisl purus pellentesque molestie pharetra tincidunt, pellentesque elementum blandit interdum erat cras. pharetra mattis nunc feugiat fringilla donec facilisis risus fames scelerisque, potenti tristique curabitur cursus netus aptent lectus varius arcu himenaeos, etiam aliquam bibendum eu hac dui praesent himenaeos. sit suspendisse faucibus sem porttitor rutrum nec eget, cubilia amet ultricies litora purus sodales praesent, eu nostra pellentesque ornare vitae aenean. ut cursus tincidunt aenean vestibulum volutpat bibendum ornare, netus a semper lacus luctus id venenatis, aenean ligula ad scelerisque luctus consectetur.</p>\r\n<p>litora gravida a fames nulla tempor metus aenean habitant, laoreet senectus nisl est fusce ligula aptent, molestie fames inceptos phasellus rhoncus viverra duis. semper nunc nisi dolor ut scelerisque elementum convallis class, aenean tristique primis cubilia adipiscing cubilia amet viverra id, sapien nisl dapibus torquent orci ac taciti. fringilla commodo blandit non sociosqu ante ligula ultrices in, ante suspendisse tristique iaculis at etiam ullamcorper porta, maecenas mi pulvinar urna risus et tempus. lobortis dolor fermentum lorem facilisis tristique enim ultrices nec ullamcorper tincidunt, ad sagittis velit justo elementum aptent nisl elit elementum, risus litora pulvinar metus velit ut potenti cras integer.</p>\r\n<p>commodo vitae eleifend dapibus curabitur aliquam nunc leo purus, nulla convallis aliquam varius velit sed vivamus dictum potenti, ipsum elit consectetur convallis odio elit morbi. etiam purus augue malesuada id eros pharetra porttitor rutrum aliquet, platea justo lectus convallis morbi elementum neque est nullam, tristique duis eros fames conubia cubilia lorem hac. fringilla sociosqu vel vivamus arcu mollis sit nullam, fames donec ultrices interdum consequat posuere, tincidunt metus aliquet proin senectus aenean. odio cursus sodales nunc aptent accumsan senectus sollicitudin, volutpat inceptos non habitant non magna, sociosqu praesent potenti inceptos curabitur himenaeos.</p>\r\n<h3><a href=\"javascript:void(0);\">Article Media</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=6taNjZCzQ1I{/youtube}</div>\r\n</dd><dt class=\"fillItUpTabTitle\"></dt></dl>\r\n<h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3>\r\n<dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"></dt><dd class=\"fillItUpTabDescription\">\r\n<div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/betsyweber/sets/72157625090445954/with/5056456076/{/gallery}</div>\r\n</dd></dl>', '1', '10', '2013-07-11 10:42:07', '471', '', '2013-07-18 14:55:34', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:07', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"Malesuada venenatis blandit iaculis tellus \",\"image_intro_caption\":\"Purus metus massa venenatis pharetra rutrum \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Malesuada venenatis blandit iaculis tellus \",\"image_fulltext_caption\":\"Purus metus massa venenatis pharetra rutrum \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', 'Forbes, Takeover', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":null}', '0', '*', ''), ('72', '132', 'Platea id donec phasellus malesuada nullam ', 'platea-id-donec-phasellus-malesuada-nullam', '<p>egestas sed pulvinar senectus commodo eu diam etiam, velit auctor quis bibendum fringilla erat, convallis ligula suscipit nisl vehicula ac. convallis velit habitasse potenti aliquet odio mattis iaculis nibh, malesuada nisi tempus sollicitudin mi id etiam sollicitudin, in eleifend viverra ante blandit torquent pulvinar. eu lectus lorem eleifend platea odio conubia mi hac, lectus luctus vivamus quis consectetur est metus dapibus ligula, fringilla hac dapibus est integer lobortis interdum. congue sem ut tincidunt quisque proin netus gravida eu tristique ante, adipiscing litora suspendisse bibendum egestas aliquam habitasse dui felis convallis accumsan, semper eleifend ante aliquet taciti imperdiet ligula consequat bibendum.</p>\r\n', '\r\n<p>mattis tempus lorem quam ut morbi pretium tellus ad sapien imperdiet inceptos metus nisl senectus, integer hac vitae nostra elit potenti commodo mollis pharetra curabitur torquent sed tellus. facilisis commodo viverra inceptos litora cursus litora placerat nam nunc condimentum, metus et sit libero vivamus tempor faucibus fermentum ad venenatis, curabitur laoreet dictumst faucibus sociosqu nisl fusce maecenas rhoncus. enim aliquet taciti eleifend dictum pretium malesuada risus donec porta elementum aenean inceptos commodo nunc, tristique ligula adipiscing curabitur morbi rhoncus vehicula nunc ad nunc senectus dui nunc, molestie pellentesque sem quisque in nulla torquent tellus diam bibendum potenti fames class.</p>\r\n<p>lectus sodales cubilia torquent curae lobortis sed etiam nibh malesuada vivamus dictumst tempus, aptent vivamus aliquam sit adipiscing auctor adipiscing ut eu metus. ad dictumst pretium nostra sagittis mi donec arcu, fringilla non nullam elit est tincidunt litora volutpat, donec semper facilisis per vel feugiat. mi sagittis malesuada fames taciti nec sodales eros et congue lacinia, eleifend tempus faucibus phasellus curabitur pulvinar maecenas arcu. non nulla neque libero tempor aptent sem ultrices ut, justo at pulvinar eu suscipit egestas ac aenean rhoncus, mi etiam elementum sit dictum magna taciti.</p>\r\n<p>nibh dolor senectus congue euismod platea posuere congue posuere, suspendisse laoreet hac vulputate donec volutpat rutrum massa vulputate, risus hendrerit urna bibendum amet sed mauris velit, interdum elit lobortis dictum magna class convallis. ut torquent donec gravida ultrices amet commodo sagittis taciti, senectus urna volutpat nibh habitasse rutrum curabitur vestibulum vitae, sed cubilia cursus sociosqu eros aliquam morbi. pretium dictum purus eget ligula duis tempor fermentum amet, massa taciti imperdiet senectus feugiat morbi netus adipiscing, conubia rhoncus varius neque lectus malesuada posuere. felis ornare adipiscing taciti urna auctor tortor ante curae elementum, sapien placerat fermentum aptent donec libero nisi nec accumsan commodo, elit nunc pellentesque interdum et augue bibendum ligula.</p>\r\n<p>ipsum lacinia hendrerit lobortis tortor scelerisque etiam auctor etiam nisi, augue sagittis diam purus egestas feugiat consectetur suspendisse. eleifend integer accumsan posuere convallis nibh netus nisi himenaeos aenean sodales adipiscing, viverra sagittis pharetra nulla sollicitudin turpis rutrum consectetur commodo consequat, lacinia accumsan netus dictum sapien eros varius turpis curabitur viverra. ornare primis ultrices habitasse amet porta habitant tellus consequat convallis faucibus hac ad ut, curabitur quisque gravida sapien lectus pellentesque quis vehicula commodo ligula pretium sed. torquent euismod class ipsum magna et ante nam etiam dictum, taciti donec facilisis dui senectus semper rutrum sociosqu, donec semper sociosqu et habitant dictum risus nunc.</p>\r\n<ul class=\"tabs\">\r\n<li>\r\n<h3>Article Media</h3>\r\n</li>\r\n<li>\r\n<h3>Article Image Gallery</h3>\r\n</li>\r\n</ul>\r\n<div class=\"pane\">{youtube}http://www.youtube.com/watch?v=n8L2Wxs2bk0{/youtube}</div>\r\n<div class=\"pane\">{gallery}http://www.flickr.com/photos/satorarepo/sets/72157600213034911/with/7241770212/{/gallery}</div>', '1', '14', '2013-07-11 10:42:09', '472', '', '2013-07-19 10:14:56', '471', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:09', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Platea id donec phasellus malesuada nullam \",\"image_intro_caption\":\"Dui lectus pulvinar varius \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/14\\/1_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Platea id donec phasellus malesuada nullam \",\"image_fulltext_caption\":\"Dui lectus pulvinar varius \"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', 'Italian, Inspirational', '', '1', '13', '{\"tags\":[3,19],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('73', '133', 'Vel netus odio molestie justo ', 'vel-netus-odio-molestie-justo', '<p>\ndolor augue hac mi ullamcorper interdum, luctus neque felis turpis metus dictum, diam conubia aliquam posuere. \naliquam lorem nec metus felis tempus platea purus, suscipit orci pellentesque consectetur duis mi semper, netus nunc pretium lacinia nulla turpis. \nquisque eleifend primis iaculis consectetur potenti iaculis posuere velit dictum egestas, lacus gravida egestas quam morbi ac mauris interdum. \netiam pellentesque feugiat donec iaculis faucibus vel odio aenean fermentum aptent sem, bibendum enim iaculis facilisis fermentum urna volutpat duis placerat turpis convallis fermentum, eros fringilla feugiat lobortis nam sodales vitae mi semper libero. \n</p>\n<p>\nvarius eu tellus sem curae litora, turpis ornare ultrices metus. \n</p>', '<p>\nnetus nibh id habitasse aenean sociosqu platea vulputate sed gravida, hac eros vehicula eu inceptos nullam porttitor justo curabitur vel, justo ultrices hendrerit ipsum ut placerat consequat donec. \nurna id dapibus fusce cursus adipiscing vulputate vestibulum, euismod est etiam ut class egestas hendrerit, vivamus suscipit tellus faucibus auctor nibh. \nplatea eleifend augue tempor viverra platea sagittis per pharetra ac ullamcorper morbi, placerat ultrices luctus hac varius leo enim hendrerit duis lectus, pulvinar netus risus nisl elit maecenas duis cras leo et. \nnulla venenatis habitant ut varius aptent nullam urna quis donec cubilia lobortis aliquam, semper velit mi lacus vestibulum amet fermentum dapibus molestie nam. \n</p>\n<p>\nfaucibus suscipit sem aliquam dui praesent luctus velit etiam, nulla consequat class eleifend maecenas euismod aliquet per, turpis hendrerit tortor auctor pellentesque praesent sollicitudin. \niaculis viverra metus tempus semper lacinia feugiat vulputate ut, dolor nullam sagittis curabitur vel auctor eros. \nimperdiet augue luctus eu quis molestie vel consequat, auctor id auctor magna aenean. \ntaciti dictumst semper curabitur augue viverra ad odio, nam sapien placerat sem at urna vestibulum interdum, mattis quisque nulla mauris pellentesque fringilla. \nullamcorper a tempor hac varius fringilla accumsan pharetra, tortor nibh vitae congue primis quisque nullam, cubilia ad lorem quis mattis mi. \n</p>\n<p>\naliquam consectetur dictum consectetur risus ornare amet mi quisque, per magna quisque odio hendrerit integer purus, lacinia dolor vulputate conubia quam phasellus erat. \nmorbi semper fringilla phasellus pellentesque nunc nec curabitur, volutpat tristique aenean torquent ipsum aliquam, nullam ullamcorper sollicitudin odio varius odio. \ndictum cursus phasellus porttitor imperdiet metus libero habitasse condimentum fringilla, platea tristique torquent aliquam nibh nulla arcu eros, tempor malesuada euismod neque porta interdum donec nunc. \nelit fames amet nunc bibendum eget quisque ultricies morbi et est scelerisque, rhoncus cursus cubilia nisl consectetur nullam cursus est hendrerit. \n</p>\n<p>\nquis sodales hendrerit venenatis placerat vivamus potenti volutpat vestibulum eleifend, auctor mollis hac facilisis sem elit accumsan et imperdiet, elit venenatis conubia faucibus gravida rhoncus quisque suscipit. \ncondimentum bibendum conubia dapibus suspendisse purus tincidunt amet condimentum, auctor tristique duis lacinia tempus aenean adipiscing egestas, metus curabitur convallis suscipit etiam cras litora. \nvestibulum vivamus ad hendrerit placerat neque quis metus donec metus odio, consequat habitant nisl primis magna etiam pretium eros nam, volutpat pellentesque posuere velit dui at platea imperdiet quis. \npotenti porta mi hendrerit faucibus congue pharetra leo elit, ut eleifend magna velit aliquam lobortis suscipit, ad nostra mollis auctor volutpat amet justo. \n</p>\n<p>\nsit himenaeos tristique eros erat, torquent ad. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=ic4PQ-tnwJw{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/92222485@N00/sets/72157621740773123/with/3668108466/{/gallery}</div></dd></dl>', '2', '12', '2013-07-11 10:42:10', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:10', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/12\\/10_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Vel netus odio molestie justo \",\"image_intro_caption\":\"Leo aliquam sollicitudin \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/12\\/10_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Vel netus odio molestie justo \",\"image_fulltext_caption\":\"Leo aliquam sollicitudin \"}', '', '', '1', '0', 'Intense, Music, Tango', '', '1', '3', '', '0', '*', ''), ('75', '135', 'Vivamus donec laoreet congue donec nisl ', 'vivamus-donec-laoreet-congue-donec-nisl', '<p>\nnulla ut viverra est ultrices nisl vel maecenas urna, eget turpis taciti ornare facilisis gravida morbi dictumst tincidunt, mollis nullam ac ad erat maecenas faucibus. \nlibero lectus congue a urna sociosqu vulputate erat sociosqu nostra, etiam sapien conubia nam enim litora nec ullamcorper blandit, ipsum pretium himenaeos iaculis lectus vitae a placerat. \nrisus sed erat nulla per quis tristique quam nostra pulvinar nullam quisque eros, viverra porta velit aenean ac sed primis justo etiam curabitur. \ndictum aliquam suscipit condimentum pellentesque non maecenas pretium duis, eu fusce ipsum convallis semper nisl vel blandit nam, vestibulum quam feugiat torquent ultricies tincidunt pharetra. \n</p>', '<p>\nsociosqu litora lacinia nunc tellus inceptos proin euismod sed dui, litora aliquam ultricies potenti scelerisque suspendisse mauris ipsum, aliquet mattis fames purus cras cubilia massa etiam. \nnullam dapibus lectus massa nibh phasellus per semper facilisis, urna eleifend orci cubilia aptent nam eros, sagittis sollicitudin vestibulum aliquam aptent magna tempus. \nconsectetur mattis tristique leo mattis ultrices varius etiam turpis sociosqu torquent risus mattis habitasse, enim vivamus vulputate euismod habitant nunc per nibh leo scelerisque odio. \ntellus venenatis cursus eleifend venenatis suscipit nulla conubia urna fames, maecenas eros cubilia fames tincidunt pellentesque quis. \n</p>\n<p>\netiam sollicitudin egestas non purus duis congue platea quisque, aenean odio varius arcu condimentum lacus pretium nibh, vivamus proin dolor hac quisque faucibus taciti. \ntempus donec vivamus conubia laoreet ultrices aenean nunc, hendrerit habitasse dui cras est ultrices, nisi sodales diam aliquet suspendisse lectus. \nsodales mollis conubia feugiat mattis dictumst, sodales massa class aliquam cubilia netus, ut leo morbi etiam. \ninteger litora id lacus a quis aliquam pretium taciti, aptent metus maecenas netus consequat vestibulum eleifend, maecenas integer etiam ut viverra massa hac. \ncursus aenean mollis eu rutrum porttitor lacinia vitae, odio ante ad neque elementum neque, aliquam conubia nullam eget aliquam vivamus. \n</p>\n<p>\nmauris et duis condimentum egestas praesent augue mattis sed ipsum, ornare adipiscing sapien taciti fusce integer arcu mollis, habitasse curabitur leo lacinia ultricies morbi fermentum metus. \nvenenatis primis ultrices at congue accumsan adipiscing habitasse sit, augue a habitasse luctus lobortis ut velit, vitae facilisis amet gravida per rutrum suscipit. \nper ut leo himenaeos taciti eleifend amet porta malesuada vivamus ultrices commodo tortor, quisque quam aliquam ut venenatis proin porta phasellus lorem netus ornare, lectus donec eleifend libero sociosqu aliquam ultricies curae mi aliquam ac. \nvehicula lorem eros dictum aliquam nisi tellus habitasse lacinia vulputate ad inceptos, nam integer risus tempor integer porttitor rhoncus ac non enim, id ligula ornare adipiscing iaculis etiam justo blandit vivamus vitae. \n</p>\n<p>\nmollis scelerisque congue dolor feugiat ut amet libero nullam, sapien platea ad justo fusce dolor fames, dapibus lobortis hendrerit id et fames conubia. \npretium condimentum molestie tellus euismod rhoncus adipiscing aenean eleifend dictum, massa quisque posuere fringilla at dui senectus proin imperdiet, conubia habitasse tincidunt habitasse imperdiet condimentum urna metus. \nsapien arcu pharetra primis non aenean class cubilia, duis potenti morbi etiam placerat purus fermentum, aliquam egestas vel lectus donec etiam. \npharetra velit elit quisque donec sollicitudin elementum, litora ornare curae vitae egestas felis eget, sed blandit convallis non tristique. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=KEq8teFdQ_o{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/uberzombie/sets/72157603524255415{/gallery}</div></dd></dl>', '1', '17', '2013-07-11 10:42:15', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:15', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/4_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Vivamus donec laoreet congue donec nisl \",\"image_intro_caption\":\"Turpis venenatis tempor posuere nostra velit \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/4_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Vivamus donec laoreet congue donec nisl \",\"image_fulltext_caption\":\"Turpis venenatis tempor posuere nostra velit \"}', '', '', '1', '2', 'Comedy, Drama, Anime', '', '1', '0', '', '0', '*', ''), ('78', '138', 'Nostra dui auctor ', 'nostra-dui-auctor', '<p>\nultricies etiam congue eros mauris dui aliquam placerat odio, morbi arcu eget lobortis velit rutrum torquent, semper magna eleifend cras blandit id aptent. \nsollicitudin scelerisque in integer dolor sollicitudin vitae placerat, lacus in est suscipit nostra suspendisse id molestie, odio varius ligula pulvinar sem cubilia. \nsodales donec lobortis convallis purus metus torquent non tortor, non molestie sagittis massa taciti lacus lobortis nisi sem, feugiat tortor nec eleifend dui felis enim. \nhimenaeos diam eleifend feugiat quisque vitae cubilia erat lobortis volutpat dapibus, velit est semper pulvinar imperdiet tellus cursus per cursus libero, mauris gravida blandit interdum mollis nibh class vivamus condimentum. \n</p>', '<p>\nnam in sapien ullamcorper hendrerit id blandit sapien arcu fringilla, scelerisque venenatis augue leo sit semper libero. \ndonec curabitur aliquam fusce gravida himenaeos arcu egestas tempus vel, taciti nibh luctus per justo mi libero feugiat odio posuere, lorem convallis senectus luctus habitant id ad scelerisque. \nelit sapien dapibus malesuada class massa interdum nec leo ornare quam, faucibus cursus odio orci tortor at nunc mauris congue dolor, nisi platea nostra turpis maecenas enim ut nam mi. \nfaucibus accumsan netus nunc conubia velit inceptos ultrices per, vitae leo litora neque tempus interdum quam lobortis, blandit phasellus sed fringilla vulputate semper gravida. \n</p>\n<p>\nsit nam facilisis viverra himenaeos egestas facilisis tempor habitant, ultrices aliquet vulputate sollicitudin consequat sodales condimentum proin, consequat pulvinar cubilia nibh luctus facilisis aliquam. \nhimenaeos porttitor enim posuere vitae consequat elit vel, iaculis fames congue adipiscing mauris. \nscelerisque nunc senectus vel cras praesent scelerisque fames mollis, varius eros purus maecenas ut himenaeos interdum nibh urna, metus class mattis fringilla sem mi porttitor. \ninceptos libero faucibus varius ullamcorper est dapibus mauris consequat aliquam fusce, ut accumsan conubia tellus elit vitae ac taciti aliquam etiam pellentesque, tortor quis ante pulvinar dapibus lorem vestibulum bibendum commodo. \n</p>\n<p>\neleifend libero torquent aenean tempor vehicula amet quis tristique pellentesque dapibus netus sapien maecenas vivamus curabitur odio, lacus tortor massa mollis senectus tincidunt maecenas in velit donec ipsum euismod hendrerit nostra. \naliquet rutrum placerat pellentesque quam augue nulla at fermentum volutpat torquent donec dictumst, eros blandit iaculis aliquam eget varius imperdiet tempus vel cursus hendrerit a, convallis interdum dictum aliquam platea elementum id porta lacus faucibus convallis. \npurus etiam cras mi etiam taciti scelerisque nam purus nullam sodales vehicula, velit nisi est lobortis diam tellus tempus ullamcorper cursus nibh risus, nibh phasellus cras commodo porttitor amet fringilla ipsum facilisis euismod. \n</p>\n<p>\nvestibulum lectus quisque sagittis vestibulum est auctor blandit vehicula, ac ut sem aptent amet quisque sollicitudin, faucibus pulvinar erat at ad nostra volutpat. \ntortor pellentesque elit taciti lacus ullamcorper nunc vestibulum integer molestie convallis, turpis aliquam leo aliquam aliquet elementum suspendisse tempor. \nultrices sociosqu pretium porttitor quisque libero rutrum diam tristique habitasse lectus nisi consectetur nunc quisque sollicitudin, curabitur nisi nullam nisl sollicitudin per dolor molestie at eleifend primis torquent dictum volutpat. \nnetus eu curabitur tincidunt curae eget tempus euismod nullam, enim ante risus donec ad donec turpis, condimentum magna sit quisque porta fusce integer. \n</p>\n<p>\neget class porta congue curae inceptos curabitur conubia, volutpat pulvinar consectetur sapien a. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}</div></dd></dl>', '1', '17', '2013-07-11 10:42:21', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:21', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/7_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Nostra dui auctor \",\"image_intro_caption\":\"Taciti venenatis ut suscipit non sed \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/7_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Nostra dui auctor \",\"image_fulltext_caption\":\"Taciti venenatis ut suscipit non sed \"}', '', '', '1', '1', 'Cinema, Comedy, Anime', '', '1', '1', '', '0', '*', ''), ('80', '140', 'Vitae cursus scelerisque senectus ', 'vitae-cursus-scelerisque-senectus', '<p>\nbibendum suscipit phasellus potenti litora bibendum vel consectetur, tempor aliquam etiam id hendrerit luctus eget eleifend, in tristique habitant id semper suscipit. \ntempus porttitor suspendisse interdum quisque platea sagittis vivamus elit, orci sagittis id etiam venenatis nulla diam congue, orci inceptos convallis eros mollis ultrices est. \nporta scelerisque platea sodales quam fermentum mattis sollicitudin ut erat pulvinar, taciti quisque etiam porta posuere mauris orci elementum quisque, volutpat erat lorem habitasse ligula tincidunt nunc vestibulum dictumst. \neuismod suscipit elit aenean orci ullamcorper a nisi, rutrum pharetra nulla nisl vulputate magna malesuada, posuere elit scelerisque nisi purus cras. \n</p>\n<p>\nleo morbi maecenas, curabitur. \n</p>', '<p>\nlibero cubilia eget massa sem facilisis quisque lacinia scelerisque platea integer, nam potenti porta senectus nec mi enim hendrerit potenti, sollicitudin himenaeos lectus enim tortor velit netus erat curae. \nplacerat posuere ut lacus est nisi donec tristique interdum ut dolor, leo ipsum imperdiet gravida augue maecenas dapibus eros justo. \nduis risus ad velit sociosqu fringilla, cras augue eleifend eget. \npellentesque aenean vestibulum faucibus habitasse iaculis hac, primis placerat integer porta torquent purus, adipiscing sed felis torquent aenean. \nhabitasse nullam nulla curabitur dictum consequat nullam felis curae, vehicula ligula pulvinar tincidunt amet hac porta, felis lectus molestie augue fusce ligula pretium. \n</p>\n<p>\ndictumst scelerisque ultrices ligula consequat porta lacinia egestas bibendum ad urna metus, aptent ipsum porttitor fringilla per tincidunt semper consequat mollis amet consequat, phasellus quisque odio consequat nulla eget habitasse fringilla turpis himenaeos. \nut magna lacus vel mollis semper himenaeos tempus dictumst lectus himenaeos sagittis, iaculis vivamus ut fusce elit vel enim a proin orci fames, curae bibendum nam fames nunc senectus venenatis non sapien magna. \nfelis sapien quis rhoncus senectus aliquet rutrum ut molestie porttitor sem, congue id eget tincidunt sociosqu aliquet lectus ut duis donec eget, luctus interdum duis dictum quisque taciti aliquam elit amet. \n</p>\n<p>\ntaciti varius aliquet sollicitudin orci pretium aliquet, senectus dui eu tempor magna justo, pharetra potenti donec gravida dapibus. \nhabitant faucibus turpis felis nisl adipiscing risus senectus fermentum, dictum torquent curae est eleifend duis inceptos, ullamcorper sociosqu sed pellentesque venenatis ultricies ante. \nnon est sit tortor litora viverra erat bibendum pharetra eu, justo etiam dui purus pellentesque ligula molestie cursus, luctus vulputate hendrerit facilisis curae aenean interdum sapien. \nnam magna aliquet quis fermentum diam nisi, netus neque sociosqu blandit velit ante, vivamus eleifend gravida curabitur purus. \nneque convallis pharetra luctus at convallis donec dictum eget, sodales quam eget dui ligula donec justo rutrum, congue consectetur donec per sed vestibulum aliquam. \n</p>\n<p>\nsollicitudin aptent sapien gravida vehicula justo id sociosqu, platea tellus mollis quisque dictumst lorem, vehicula dolor ac augue quam metus. \nvarius torquent tincidunt cras netus etiam sed ac arcu nibh interdum, torquent quis ornare aliquam ante ut ante quisque est potenti, vitae morbi lobortis sem ac senectus blandit magna pellentesque. \ncurabitur primis egestas arcu quis eget, luctus primis porta ligula, eleifend praesent pretium turpis. \ncondimentum elit ultrices est metus leo metus ligula metus massa, torquent venenatis porta adipiscing rhoncus ac sodales dictumst, leo velit blandit pellentesque bibendum dictumst amet etiam. \n</p>\n<p>\nper commodo orci, lacinia. \n</p><dl class=\"fillItUpTabs tabs\"><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Media</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpMedia\">{youtube}http://www.youtube.com/watch?v=GokKUqLcvD8{/youtube}</div></dd><dt class=\"fillItUpTabTitle\"><span><h3><a href=\"javascript:void(0);\">Article Image Gallery</a></h3></span></dt><dd class=\"fillItUpTabDescription\"><div class=\"fillItUpGallery\">{gallery}http://www.flickr.com/photos/redvette/sets/72157610624421550/{/gallery}</div></dd></dl>', '2', '17', '2013-07-11 10:42:24', '471', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2013-07-11 10:42:24', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/jw_fillitup\\/com_content\\/17\\/3_560.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"Vitae cursus scelerisque senectus \",\"image_intro_caption\":\"Magna interdum curae elementum integer cubilia \",\"image_fulltext\":\"images\\/jw_fillitup\\/com_content\\/17\\/3_900.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"Vitae cursus scelerisque senectus \",\"image_fulltext_caption\":\"Magna interdum curae elementum integer cubilia \"}', '', '', '1', '0', 'Hollywood, Anime', '', '1', '3', '', '0', '*', '');
CREATE TABLE `#__content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__content_frontpage`  VALUES ('16', '1'), ('17', '2'), ('23', '4'), ('59', '3');
CREATE TABLE `#__content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',   `rating_count` int(10) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__content_types` (   `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `type_title` varchar(255) NOT NULL DEFAULT '',   `type_alias` varchar(255) NOT NULL DEFAULT '',   `table` varchar(255) NOT NULL DEFAULT '',   `rules` text NOT NULL,   `field_mappings` text NOT NULL,   `router` varchar(255) NOT NULL DEFAULT '',   PRIMARY KEY (`type_id`),   KEY `idx_alias` (`type_alias`) ) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `#__content_types`  VALUES ('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\"}], \"special\": [{\"fulltext\":\"fulltext\"}]}', 'ContentHelperRoute::getArticleRoute'), ('2', 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}], \"special\": []}', 'WeblinksHelperRoute::getWeblinkRoute'), ('3', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}], \"special\": [{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}]}', 'ContactHelperRoute::getContactRoute'), ('4', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}], \"special\": [{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}]}', 'NewsfeedsHelperRoute::getNewsfeedRoute'), ('5', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}], \"special\": [{}]}', 'UsersHelperRoute::getUserRoute'), ('6', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}], \"special\": [{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}]}', 'ContentHelperRoute::getCategoryRoute'), ('7', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}], \"special\": [{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}]}', 'ContactHelperRoute::getCategoryRoute'), ('8', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}], \"special\": [{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}]}', 'NewsfeedsHelperRoute::getCategoryRoute'), ('9', 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}], \"special\": [{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}]}', 'WeblinksHelperRoute::getCategoryRoute'), ('10', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__core_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":[{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}], \"special\": [{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}]}', 'TagsHelperRoute::getTagRoute');
CREATE TABLE `#__contentitem_tag_map` (   `type_alias` varchar(255) NOT NULL DEFAULT '',   `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',   `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',   `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',   `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',   `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',   UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),   KEY `idx_tag_type` (`tag_id`,`type_id`),   KEY `idx_date_id` (`tag_date`,`tag_id`),   KEY `idx_tag` (`tag_id`),   KEY `idx_type` (`type_id`),   KEY `idx_core_content_id` (`core_content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';
INSERT INTO `#__contentitem_tag_map`  VALUES ('com_content.article', '18', '2', '2', '2013-07-19 10:21:22', '1'), ('com_content.article', '18', '2', '9', '2013-07-19 10:21:22', '1'), ('com_content.article', '18', '2', '23', '2013-07-19 10:21:22', '1'), ('com_content.article', '16', '8', '6', '2013-07-19 10:19:01', '1'), ('com_content.article', '16', '8', '11', '2013-07-19 10:19:01', '1'), ('com_content.article', '16', '8', '15', '2013-07-19 10:19:01', '1'), ('com_content.article', '16', '8', '21', '2013-07-19 10:19:01', '1'), ('com_content.article', '3', '14', '2', '2013-07-19 10:20:26', '1'), ('com_content.article', '3', '14', '7', '2013-07-19 10:20:26', '1'), ('com_content.article', '3', '14', '8', '2013-07-19 10:20:26', '1'), ('com_content.article', '3', '14', '9', '2013-07-19 10:20:26', '1'), ('com_content.article', '2', '18', '3', '2013-07-19 10:13:37', '1'), ('com_content.article', '2', '18', '4', '2013-07-19 10:13:37', '1'), ('com_content.article', '2', '18', '6', '2013-07-19 10:13:37', '1'), ('com_content.article', '17', '19', '7', '2013-07-19 10:19:19', '1'), ('com_content.article', '17', '19', '18', '2013-07-19 10:19:19', '1'), ('com_content.article', '11', '20', '5', '2013-07-19 10:14:25', '1'), ('com_content.article', '11', '20', '6', '2013-07-19 10:14:25', '1'), ('com_content.article', '11', '20', '10', '2013-07-19 10:14:25', '1'), ('com_content.article', '11', '20', '13', '2013-07-19 10:14:25', '1'), ('com_content.article', '5', '24', '2', '2013-07-19 09:59:49', '1'), ('com_content.article', '5', '24', '10', '2013-07-19 09:59:49', '1'), ('com_content.article', '5', '24', '12', '2013-07-19 09:59:49', '1'), ('com_content.article', '6', '25', '2', '2013-07-19 10:15:38', '1'), ('com_content.article', '6', '25', '6', '2013-07-19 10:15:38', '1'), ('com_content.article', '6', '25', '13', '2013-07-19 10:15:38', '1'), ('com_content.article', '8', '27', '10', '2013-07-19 10:00:04', '1'), ('com_content.article', '8', '27', '15', '2013-07-19 10:00:04', '1'), ('com_content.article', '8', '27', '16', '2013-07-19 10:00:04', '1'), ('com_content.article', '8', '27', '17', '2013-07-19 10:00:04', '1'), ('com_content.article', '15', '32', '15', '2013-07-19 10:00:25', '1'), ('com_content.article', '15', '32', '22', '2013-07-19 10:00:25', '1'), ('com_content.article', '10', '39', '7', '2013-07-19 10:20:51', '1'), ('com_content.article', '10', '39', '8', '2013-07-19 10:20:51', '1'), ('com_content.article', '10', '39', '16', '2013-07-19 10:20:51', '1'), ('com_content.article', '10', '39', '20', '2013-07-19 10:20:51', '1'), ('com_content.article', '1', '41', '2', '2013-07-19 10:07:38', '1'), ('com_content.article', '1', '41', '3', '2013-07-19 10:07:38', '1'), ('com_content.article', '1', '41', '4', '2013-07-19 10:07:38', '1'), ('com_content.article', '1', '41', '5', '2013-07-19 10:07:38', '1'), ('com_content.article', '4', '45', '10', '2013-07-19 10:17:01', '1'), ('com_content.article', '4', '45', '11', '2013-07-19 10:17:01', '1'), ('com_content.article', '7', '60', '2', '2013-07-11 14:45:13', '1'), ('com_content.article', '7', '60', '6', '2013-07-11 14:45:13', '1'), ('com_content.article', '7', '60', '14', '2013-07-11 14:45:13', '1'), ('com_content.article', '14', '72', '3', '2013-07-19 10:14:56', '1'), ('com_content.article', '14', '72', '19', '2013-07-19 10:14:56', '1');
CREATE TABLE `#__core_log_searches` (   `search_term` varchar(128) NOT NULL DEFAULT '',   `hits` int(10) unsigned NOT NULL DEFAULT '0' ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__extensions` (   `extension_id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL,   `type` varchar(20) NOT NULL,   `element` varchar(100) NOT NULL,   `folder` varchar(100) NOT NULL,   `client_id` tinyint(3) NOT NULL,   `enabled` tinyint(3) NOT NULL DEFAULT '1',   `access` int(10) unsigned NOT NULL DEFAULT '1',   `protected` tinyint(3) NOT NULL DEFAULT '0',   `manifest_cache` text NOT NULL,   `params` text NOT NULL,   `custom_data` text NOT NULL,   `system_data` text NOT NULL,   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) DEFAULT '0',   `state` int(11) DEFAULT '0',   PRIMARY KEY (`extension_id`),   KEY `element_clientid` (`element`,`client_id`),   KEY `element_folder_clientid` (`element`,`folder`,`client_id`),   KEY `extension` (`type`,`element`,`folder`,`client_id`) ) ENGINE=InnoDB AUTO_INCREMENT=10049 DEFAULT CHARSET=utf8;
INSERT INTO `#__extensions`  VALUES ('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_tags\":\"1\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '0', '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"1\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"0\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"1\",\"show_base_description\":\"0\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"5\",\"num_intro_articles\":\"0\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('27', 'com_finder', 'component', 'com_finder', '', '1', '0', '0', '0', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('29', 'com_tags', 'component', 'com_tags', '', '1', '1', '1', '1', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2013, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2.3\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"12.2\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '0', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '0', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '0', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('315', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '1', '1', '1', '0', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('316', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('317', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"xhtml\"}', '', '', '0', '2011-09-18 15:22:50', '0', '0'), ('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2012\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.6\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '0', '1', '1', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0'), ('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '0', '1', '1', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '8', '0'), ('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '10', '0'), ('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '0', '1', '1', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '1', '1', '0', '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('447', 'plg_finder_tags', 'plugin', 'tags', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('503', 'beez3', 'template', 'beez3', '', '0', '1', '1', '0', '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('506', 'protostar', 'template', 'protostar', '', '0', '1', '1', '0', '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('507', 'isis', 'template', 'isis', '', '1', '1', '1', '0', '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2013-03-07\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2013-03-07\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"April 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.1\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10000', 'com_k2', 'component', 'com_k2', '', '1', '1', '0', '0', '{\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla!\",\"group\":\"\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"1.8remote\",\"backendJQueryHandling\":\"remote\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeedLink\":\"0\",\"userFeedIcon\":\"0\",\"userItemCount\":\"5\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"1\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"1\",\"userItemTags\":\"1\",\"userItemCommentsAnchor\":\"1\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"5\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"1\",\"tagItemDateCreated\":\"1\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"1\",\"tagItemReadMore\":\"1\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"0\",\"tagFeedIcon\":\"0\",\"genericItemCount\":\"5\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"1\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"1\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"0\",\"genericFeedLink\":\"0\",\"genericFeedIcon\":\"0\",\"feedLimit\":\"10\",\"feedItemImage\":\"1\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"0\",\"feedItemVideo\":\"0\",\"feedItemGallery\":\"0\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"70\",\"itemImageS\":\"270\",\"itemImageM\":\"560\",\"itemImageL\":\"770\",\"itemImageXL\":\"900\",\"itemImageGeneric\":\"270\",\"catImageWidth\":\"70\",\"catImageDefault\":\"1\",\"userImageWidth\":\"70\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"70\",\"onlineImageEditor\":\"splashup\",\"imageTimestamp\":\"0\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"\",\"facebookImage\":\"XSmall\",\"comments\":\"1\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"10\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"1\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"0\",\"gravatar\":\"1\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"1\",\"akismetForRegistered\":\"1\",\"commentsFormNotes\":\"1\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"1\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"1\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"0\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"K2UserGroup\":\"1\",\"redirect\":\"101\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaOnRegistration\":\"0\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"0\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"0\",\"k2SefLabelItemCustomPrefix\":\"\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"dash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\",\"sh404SefLabelCat\":\"\",\"sh404SefLabelUser\":\"blog\",\"sh404SefLabelItem\":\"2\",\"sh404SefTitleAlias\":\"alias\",\"sh404SefModK2ContentFeedAlias\":\"feed\",\"sh404SefInsertItemId\":\"0\",\"sh404SefInsertUniqueItemId\":\"0\",\"cbIntegration\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10001', 'plg_finder_k2', 'plugin', 'k2', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10002', 'Search - K2', 'plugin', 'k2', 'search', '0', '1', '1', '0', '{\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10003', 'System - K2', 'plugin', 'k2', 'system', '0', '1', '1', '0', '{\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10004', 'User - K2', 'plugin', 'k2', 'user', '0', '1', '1', '0', '{\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10005', 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', '0', '1', '1', '0', '{\"name\":\"Josetta - K2 Categories\",\"type\":\"plugin\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10006', 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', '0', '1', '1', '0', '{\"name\":\"Josetta - K2 Items\",\"type\":\"plugin\",\"creationDate\":\"June 7th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10007', 'K2 Comments', 'module', 'mod_k2_comments', '', '0', '1', '0', '0', '{\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10008', 'K2 Content', 'module', 'mod_k2_content', '', '0', '1', '0', '0', '{\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10009', 'K2 Tools', 'module', 'mod_k2_tools', '', '0', '1', '0', '0', '{\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_TOOLS\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10010', 'K2 Users', 'module', 'mod_k2_users', '', '0', '1', '0', '0', '{\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10011', 'K2 User', 'module', 'mod_k2_user', '', '0', '1', '0', '0', '{\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10012', 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', '1', '1', '2', '0', '{\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10013', 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', '1', '1', '2', '0', '{\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"July 4th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10014', 'PLG_SYSTEM_CACHECLEANER', 'plugin', 'cachecleaner', 'system', '0', '1', '1', '0', '{\"name\":\"PLG_SYSTEM_CACHECLEANER\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"PLG_SYSTEM_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10015', 'MOD_CACHECLEANER', 'module', 'mod_cachecleaner', '', '1', '1', '3', '0', '{\"name\":\"MOD_CACHECLEANER\",\"type\":\"module\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"MOD_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10016', 'PLG_SYSTEM_NNFRAMEWORK', 'plugin', 'nnframework', 'system', '0', '1', '1', '0', '{\"name\":\"PLG_SYSTEM_NNFRAMEWORK\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"13.5.3\",\"description\":\"PLG_SYSTEM_NNFRAMEWORK_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10017', 'admintools', 'component', 'com_admintools', '', '1', '1', '0', '0', '{\"name\":\"Admintools\",\"type\":\"component\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"Security and utilitarian tools for Joomla! site administrators\",\"group\":\"\"}', '{\"liveupdate\":\"lastcheck=1374588693\\nupdatedata=\\\"Tzo4OiJzdGRDbGFzcyI6ODp7czo5OiJzdXBwb3J0ZWQiO2I6MTtzOjU6InN0dWNrIjtiOjA7czo3OiJ2ZXJzaW9uIjtzOjU6IjIuNS42IjtzOjQ6ImRhdGUiO3M6MTA6IjIwMTMtMDYtMjgiO3M6OToic3RhYmlsaXR5IjtzOjY6InN0YWJsZSI7czoxMToiZG93bmxvYWRVUkwiO3M6ODQ6Imh0dHA6Ly9jZG4uYWtlZWJhYmFja3VwLmNvbS9kb3dubG9hZHMvYWRtaW50b29scy8yLjUuNi9jb21fYWRtaW50b29scy0yLjUuNi1jb3JlLnppcCI7czo3OiJpbmZvVVJMIjtzOjYxOiJodHRwczovL3d3dy5ha2VlYmFiYWNrdXAuY29tL2Rvd25sb2Fkcy9hZG1pbi10b29scy8yLTUtNi5odG1sIjtzOjEyOiJyZWxlYXNlbm90ZXMiO3M6MjYxMDoiPGgzPkdlbmVyYWwgaW5mb3JtYXRpb248L2gzPjxwPklmIHlvdSBoYXZlIGEgcHJvYmxlbSBhZnRlciBvciBiZWZvcmUgaW5zdGFsbGluZyB0aGUgY29tcG9uZW50IHBsZWFzZSByZWFkIG91ciA8YSBocmVmPSJob21lL25ld3MvNTUtZ2VuZXJhbC8xNTAyLXRyb3VibGVzaG9vdGluZy1pbnN0cnVjdGlvbnMtZm9yLWZlYi0yMDEzLXJlbGVhc2VzLmh0bWwiPiB0cm91Ymxlc2hvb3RpbmcgcGFnZTwvYT4uIFRoZXNlIGlzc3VlcyBhcmUgbW9yZSBsaWtlbHkgdG8gb2NjdXIgaWYgeW91IHRyeSB0byB1cGdyYWRlIHRoaXMgY29tcG9uZW50IHdoaWxlIHlvdSBoYXZlIGFuIG9sZGVyIHZlcnNpb24gb2YgYW5vdGhlciBjb21wb25lbnQgb2Ygb3VycyBzdGlsbCBpbnN0YWxsZWQgb24geW91ciBzaXRlLjwvcD48aDM+UmVsZWFzZSBoaWdobGlnaHRzPC9oMz48cD5UaGlzIHZlcnNpb24gb2YgQWRtaW4gVG9vbHMgaW50cm9kdWNlcyBJUHY2IHN1cHBvcnQuIElmIHlvdSBoYXZlIGFuIElQdjYgZW5hYmxlZCB3ZWIgc2VydmVyIHlvdSBjYW4gdXNlIElQdjYgYWRkcmVzc2VzIGFuZCBibG9ja3MgaW4gd2hpdGUtIGFuZCBibGFjay1saXN0cy4gVGhlIGF1dG9tYXRpYyBJUCBiYW5uaW5nIHdpbGwgYWxzbyB3b3JrIGNvcnJlY3RseSB3aXRoIElQdjYgSVBzIGFzIHdlbGwuIERvIG5vdGUgdGhhdCB0aGUgR2VvZ3JhcGhpYyBCbG9ja2luZyBkb2Vzbid0IHdvcmsgd2l0aCBJUHY2IGFzIHRoZSB0aGlyZCBwYXJ0eSBJUCB0byBjb3VudHJ5IGRhdGFiYXNlIHdlIGFyZSB1c2luZyBpcyBub3QgSVB2NiBlbmFibGVkLjwvcD48cD5PbiBwb3B1bGFyIHJlcXVlc3Qgd2UgYWRkZWQgdGhlIGFiaWxpdHkgdG8gcmVkaXJlY3Qgbm9uLVNFRiBVUkxzLCBzdWNoIGFzIDx0dD5pbmRleC5waHA\\/b3B0aW9uPWNvbV9vbGRjb21wb25lbnQmcGFyYW0xPTEyJnBhcmFtMj0zNDwvdHQ+LiBZb3Ugd2lsbCBuZWVkIHRvIHNldCB0aGUgIktlZXAgVVJMIFBhcmFtZXRlcnMiIG9wdGlvbiB0byBObyBpbiB0aGUgVVJMIHJlZGlyZWN0aW9uIGVkaXRvciBmb3IgdGhlc2UgVVJMcyB0byB3b3JrLiBXZSBhbHNvIGltcHJvdmVkIHRoZSBVUkwgZWRpdG9yIHBhZ2UgdG8gbWFrZSBpdCBzZWxmLWRvY3VtZW50aW5nIGFuZCBlYXNpZXIgdG8gdW5kZXJzdGFuZC48L3A+PGgzPlBIUCA1LjMgaXMgbm93IHJlcXVpcmVkPC9oMz48cD5UaGlzIHZlcnNpb24gcmVxdWlyZXMgUEhQIDUuMyBvciBsYXRlci4gVGhlIHJhdGlvbmFsZSBiZWhpbmQgdGhpcyBpcyBleHBsYWluZWQgaW4gb3VyIDxhIGhyZWY9ImhvbWUvbmV3cy81NS1nZW5lcmFsLzE1MDEtZW5kLW9mLXBocDUyLXN1cHBvcnQuaHRtbCI+IHN0YXRlbWVudCBvZiBtaWQtRmVicnVhcnkgMjAxMzwvYT4uIEl0IHdvbid0IGluc3RhbGwgb24gaG9zdHMgcnVubmluZyBQSFAgNS4yIG9yIGVhcmxpZXIuIE1vcmVvdmVyLCBkdWUgdG8gdGhlIG5lY2Vzc2FyeSBKb29tbGEhIEFQSSBjaGFuZ2VzIGZvdW5kIG9ubHkgaW4gSm9vbWxhISAyLjUuNiBvciBsYXRlciwgdGhpcyB2ZXJzaW9uIHdpbGwgbm90IGluc3RhbGwgb24gSm9vbWxhISAyLjUuNSBvciBlYXJsaWVyIHZlcnNpb25zLiBJbiBhbnkgY2FzZSwgaXQgd2lsbCB0ZWxsIHlvdSBleGFjdGx5IHdoeSBpdCBjYW5ub3QgYmUgaW5zdGFsbGVkIChtaW5pbXVtIFBIUCBvciBKb29tbGEhIHZlcnNpb24gbm90IHNhdGlzZmllZCkuPC9wPjxoMz5DaGFuZ2Vsb2c8L2gzPjxoND5OZXcgZmVhdHVyZXM8L2g0Pjx1bD48bGk+QWxsb3cgVVJMIHJlZGlyZWN0aW9ucyB0byBrZWVwIChkZWZhdWx0KSBvciBkcm9wIHF1ZXJ5IHBhcmFtZXRlcnMsIHVzZWZ1bCBmb3IgcmVkaXJlY3Rpbmcgbm9uLVNFRiBVUkxzPC9saT48bGk+SVB2NiBzdXBwb3J0PC9saT48L3VsPjxoND5NaXNjZWxsYW5lb3VzIGNoYW5nZXM8L2g0Pjx1bD48bGk+UmVtb3ZlIHRpbWUgcGVuYWx0eSB3aGVuIGJsb2NraW5nIGF1dG8tYmFubmVkIElQcyBkdWUgdG8gcmVzb3VyY2UgdXNhZ2UgY29uc2lkZXJhdGlvbnM8L2xpPjwvdWw+PGg0PkJ1ZyBmaXhlczwvaDQ+PHVsPjxsaT5bTE9XXSBQcmUtaW5zdGFsbGF0aW9uIHNjcmlwdCB3b3VsZCBydW4gdGhlIHdyb25nIFNRTCBmaWxlcyBvbiB1cGdyYWRlIChub3JtYWxseSBub3QgY2F1c2luZyBhIHByb2JsZW0sIGJ1dCBzdGlsbCBpdCdzIG5vdCB0aGUgaW50ZW5kZWQgYmVoYXZpb3VyKTwvbGk+PGxpPltMT1ddIFRoZSAuaHRhY2Nlc3MgTWFrZXIgZXhjZXB0aW9uIHlvdSdkIGFkZCBmb3IgZmlsZXMgYW5kIGZvbGRlcnMgd2l0aCBkYXNoZXMgaW4gdGhlaXIgbmFtZXMgd291bGQgbm90IGJlIGVmZmVjdGl2ZTwvbGk+PGxpPltMT1ddIFRoZSAuaHRhY2Nlc3MgTWFrZXIgd291bGQgYXNzdW1lIHRoYXQgQXBhY2hlIHZlcnNpb24gaXMgMi4wIHdoZW4gaXQncyBub3QgcmVwb3J0ZWQuIE1hbnkgQXBhY2hlIDIuNSBzZXJ2ZXJzIGFyZSBjb25maWd1cmVkIGxpa2UgdGhhdC4gV2Ugbm93IGFzc3VtZSB2ZXJzaW9uIDIuNSBpbiB0aGlzIGNhc2UuPC9saT48bGk+W01FRElVTV0gQ29tYmluaW5nIENTUyBhbmQgSmF2YXNjcmlwdCB1c2luZyB0aGUgcGx1Z2luIGRlbGl2ZXJ5IG1ldGhvZCBkb2Vzbid0IHdvcmsgb24gSm9vbWxhISAzLjE8L2xpPjwvdWw+Ijt9\\\"\\nstuck=0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10018', 'Admin Tools Joomla! Upgrade Notification', 'module', 'mod_atjupgrade', '', '1', '1', '2', '0', '{\"name\":\"Admin Tools Joomla! Upgrade Notification\",\"type\":\"module\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10019', 'System - Admin Tools', 'plugin', 'admintools', 'system', '0', '1', '1', '0', '{\"name\":\"System - Admin Tools\",\"type\":\"plugin\",\"creationDate\":\"2013-06-28\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.6\",\"description\":\"\\n\\t\\tHandles all the system-wide features provided by Admin Tools Core\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10020', 'FOF', 'library', 'lib_fof', '', '0', '1', '1', '0', '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2013-05-11\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2013 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.1.a1\",\"description\":\"Framework-on-Framework (FOF) - A rapid component development framework for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10021', 'AkeebaStrapper', 'file', 'files_strapper', '', '0', '1', '0', '0', '{\"name\":\"AkeebaStrapper\",\"type\":\"file\",\"creationDate\":\"July 2012\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"(C) 2012-2013 Akeeba Ltd.\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"1.0.0\",\"description\":\"Namespaced jQuery, jQuery UI and Bootstrap for Akeeba products.\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10022', 'akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2013-05-11\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.7.7\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\"}', '{\"siteurl\":\"http:\\/\\/demo.nuevvo.com\\/commercial\\/j31\\/numodusversus\\/\",\"jlibrariesdir\":\"\\/home\\/demos\\/domains\\/demo.nuevvo.com\\/public_html\\/commercial\\/j31\\/numodusversus\\/libraries\",\"jversion\":\"1.6\",\"liveupdate\":\"stuck=0\\nlastcheck=1374774796\\nupdatedata=\\\"Tzo4OiJzdGRDbGFzcyI6ODp7czo5OiJzdXBwb3J0ZWQiO2I6MTtzOjU6InN0dWNrIjtiOjA7czo3OiJ2ZXJzaW9uIjtzOjY6IjMuNy4xMCI7czo0OiJkYXRlIjtzOjEwOiIyMDEzLTA2LTI5IjtzOjk6InN0YWJpbGl0eSI7czo2OiJzdGFibGUiO3M6MTE6ImRvd25sb2FkVVJMIjtzOjg0OiJodHRwOi8vY2RuLmFrZWViYWJhY2t1cC5jb20vZG93bmxvYWRzL2FrZWViYWJhY2t1cC8zLjcuMTAvY29tX2FrZWViYS0zLjcuMTAtY29yZS56aXAiO3M6NzoiaW5mb1VSTCI7czo2NDoiaHR0cHM6Ly93d3cuYWtlZWJhYmFja3VwLmNvbS9kb3dubG9hZHMvYWtlZWJhLWJhY2t1cC8zLTctMTAuaHRtbCI7czoxMjoicmVsZWFzZW5vdGVzIjtzOjE1Mjg6IjxoMz5XaHkgYSBuZXcgcmVsZWFzZSBhZ2Fpbj88L2gzPjxwPiBUaGUgcGFja2FnZSBmb3IgQWtlZWJhIEJhY2t1cCAzLjcuOSB3YXMgYnVpbHQgYW5kIHVwbG9hZGVkIHRvIG91ciBzZXJ2ZXIgdHdpY2UuIFRoZSBmaXJzdCB0aW1lIGl0IHdhcyBhIGJyb2tlbiBwYWNrYWdlLCBpZGVudGljYWwgdG8gMy43LjgsIHdpdGggYSBkaWZmZXJlbnQgdmVyc2lvbiBudW1iZXIuIFdlIGltbWVkaWF0ZWx5IHJlcGxhY2VkIHRoYXQgd2l0aCB0aGUgY29ycmVjdCBwYWNrYWdlLiBJdCBzZWVtcyB0aGF0IGZvciByZWFzb25zIGJleW9uZCB1cyBzb21lIG9mIG91ciB1c2VycyDigJNtYWlubHkgdGhvc2UgaW4gdGhlIFVTIHVzaW5nIHRoZSBDb3JlIHZlcnNpb24sIG1vc3QgbGlrZWx5IGR1ZSB0byBDRE4gY2FjaGluZyBpc3N1ZXPigJMgZG8gc2VlIGFuZCBkb3dubG9hZCB0aGUgYnJva2VuIHBhY2thZ2UuIFRoZSBwYWNrYWdlIGRvZXMgaW5zdGFsbCwgYnV0IHRoZSByZXN1bHRpbmcgYmFja3VwIHRocm93cyBhIGJsYW5rIHBhZ2UgaW4gdGhlIHNpdGUgc2V0dXAgc3RhZ2UuIEFzIGEgcmVzdWx0IHdlIGhhdmUgdG8gY29uc2lkZXIgdmVyc2lvbiAzLjcuOSBhcyBicm9rZW4gYW5kIHJlbGVhc2UgeWV0IGFub3RoZXIgbmV3IHZlcnNpb24uPC9wPjxoMz5HZW5lcmFsIGluZm9ybWF0aW9uPC9oMz48cD4gSWYgeW91IGhhdmUgYSBwcm9ibGVtIGFmdGVyIG9yIGJlZm9yZSBpbnN0YWxsaW5nIHRoZSBjb21wb25lbnQgcGxlYXNlIHJlYWQgb3VyIDxhIGhyZWY9Imh0dHBzOi8vd3d3LmFrZWViYWJhY2t1cC5jb20vaG9tZS9uZXdzLzU1LWdlbmVyYWwvMTUwMi10cm91Ymxlc2hvb3RpbmctaW5zdHJ1Y3Rpb25zLWZvci1mZWItMjAxMy1yZWxlYXNlcy5odG1sIj4gdHJvdWJsZXNob290aW5nIHBhZ2U8L2E+LiBUaGVzZSBpc3N1ZXMgYXJlIG1vcmUgbGlrZWx5IHRvIG9jY3VyIGlmIHlvdSB0cnkgdG8gdXBncmFkZSB0aGlzIGNvbXBvbmVudCB3aGlsZSB5b3UgaGF2ZSBhbiBvbGRlciB2ZXJzaW9uIG9mIGFub3RoZXIgY29tcG9uZW50IG9mIG91cnMgc3RpbGwgaW5zdGFsbGVkIG9uIHlvdXIgc2l0ZS48L3A+PGgzPlJlbGVhc2UgaGlnaGxpZ2h0czwvaDM+PHA+IDxiPk1pY3Jvc29mdCBTUUwgU2VydmVyIGNvbXBhdGliaWxpdHkgKEJFVEEpPC9iPi4gVGhpcyB2ZXJzaW9uIGludHJvZHVjZXMgbGltaXRlZCBjb21wYXRpYmlsaXR5IHdpdGggTWljcm9zb2Z0IFNRTCBTZXJ2ZXIgYW5kIE1pY3Jvc29mdCBXaW5kb3dzIEF6dXJlIFNRTCBkYXRhYmFzZXMgb24gV2luZG93cyBob3N0cyB3aXRoIHRoZSBwcm9wcmlldGFyeSBzcWxzZXJ2ZXIgUEhQIGV4dGVuc2lvbiBmcm9tIE1pY3Jvc29mdC4gWW91IGNhbiBpbnN0YWxsIEFrZWViYSBCYWNrdXAgb24gc2VydmVycyB1c2luZyBvbmUgb2YgdGhvc2UgZGF0YWJhc2VzLiBQbGVhc2UgcmVtZW1iZXIgdG8gZ28gdG8gdGhlIENvbmZpZ3VyYXRpb24gcGFnZSBhbmQgY2hhbmdlIHRoZSBkYXRhYmFzZSBkdW1wIGVuZ2luZSBvcHRpb24gdG8gIlJldmVyc2UgZW5naW5lZXJpbmciO30=\\\"\",\"lastversion\":\"3.7.7\",\"minstability\":\"stable\",\"acceptlicense\":true,\"acceptsupport\":true,\"acceptbackuptest\":true,\"angieupgrade\":1}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10023', 'PLG_JMONITORING_AKEEBABACKUP_TITLE', 'plugin', 'akeebabackup', 'jmonitoring', '0', '1', '1', '0', '{\"name\":\"PLG_JMONITORING_AKEEBABACKUP_TITLE\",\"type\":\"plugin\",\"creationDate\":\"May 2012\",\"author\":\"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com\",\"copyright\":\"\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"1.0\",\"description\":\"PLG_JMONITORING_AKEEBABACKUP_DESCRIPTION\",\"group\":\"\"}', '{\"maxbackupperiod\":\"24\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10024', 'AllVideos (by JoomlaWorks)', 'plugin', 'jw_allvideos', 'content', '0', '1', '1', '0', '{\"name\":\"AllVideos (by JoomlaWorks)\",\"type\":\"plugin\",\"creationDate\":\"February 27th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"contact@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"4.5.0\",\"description\":\"JW_PLG_AV_XML_DESC\",\"group\":\"\"}', '{\"playerTemplate\":\"Responsive\",\"vfolder\":\"images\\/videos\",\"vwidth\":\"400\",\"vheight\":\"300\",\"transparency\":\"transparent\",\"background\":\"#010101\",\"controlBarLocation\":\"bottom\",\"backgroundQT\":\"black\",\"afolder\":\"images\\/audio\",\"awidth\":\"480\",\"aheight\":\"24\",\"abackground\":\"#010101\",\"afrontcolor\":\"#FFFFFF\",\"alightcolor\":\"#00ADE3\",\"allowAudioDownloading\":\"0\",\"autoplay\":\"0\",\"gzipScripts\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10040', 'nuModusVersus', 'template', 'numodusversus', '', '0', '1', '1', '0', '{\"name\":\"nuModusVersus\",\"type\":\"template\",\"creationDate\":\"July 24th, 2013\",\"author\":\"Nuevvo Webware Ltd.\",\"copyright\":\"Copyright (c) 2010 - 2013 Nuevvo Webware Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form\",\"authorUrl\":\"http:\\/\\/nuevvo.gr\",\"version\":\"1.0.1\",\"description\":\"TPL_NUMODUSVERSUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"logo-Text\":\"nuModusVersus\",\"moto\":\"\",\"devName\":\"\",\"devLink\":\"http:\\/\\/\",\"devLinkTitle\":\"\",\"copyright\":\"nuStarter\",\"GAid\":\"\",\"GAdomain\":\"\",\"googleVID\":\"\",\"bingVID\":\"\",\"alexaVID\":\"\",\"metaDistribution\":\"local\",\"metaCopyright\":\"\",\"metaCopyrightStartYear\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
