<?php
/**
 * @version     1.0.2
 * @package     nuModusVersus
 * @author      Nuevvo - http://nuevvo.com
 * @copyright   Copyright (c) 2010 - 2013 Nuevvo Webware Ltd. All rights reserved.
 * @license     http://nuevvo.com/license
 */

// no direct access
defined('_JEXEC') or die;

// Define default image size (do not change)
K2HelperUtilities::setDefaultImage($this->item, 'itemlist', $this->params);

?>

<!-- Start K2 Item Layout -->
<div class="liBlock catItemView group<?php echo ucfirst($this->item->itemGroup); ?><?php echo ($this->item->featured) ? ' liItemIsFeatured catItemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">

	<!-- Plugins: BeforeDisplay -->
	<?php echo $this->item->event->BeforeDisplay; ?>

	<!-- K2 Plugins: K2BeforeDisplay -->
	<?php echo $this->item->event->K2BeforeDisplay; ?>
	
	
	<?php if($this->item->params->get('catItemImage') && !empty($this->item->image)): ?>
  <!-- Item Image -->
  <div class="liItemImageBlock catItemImageBlock">
    <span class="liItemImage catItemImage">
      <a href="<?php echo $this->item->link; ?>" title="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>">
        <img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" style="width:<?php echo $this->item->imageWidth; ?>px; height:auto;" />
      </a>
    </span>
    <div class="clr"></div>
  </div>
  <?php endif; ?>
  
  <div class="liItemBodyBlock">      	
  
  	<div class="liItemHeader catItemHeader">  	  
  	  <?php if ($this->item->params->get('catItemReadMore')): ?>
      <!-- Item "read more..." link -->
      <div class="liItemReadMore catItemReadMore">
        <a class="k2ReadMore" href="<?php echo $this->item->link; ?>" title="<?php echo JText::_('K2_READ_MORE'); ?>">
          <i class="icon-eye-open"></i>         
        </a>
      </div>
      <?php endif; ?>
    
  		<?php if($this->item->params->get('catItemDateCreated')): ?>
  		<!-- Date created -->
  		<span class="liItemDateCreated catItemDateCreated">
  			<?php echo JHTML::_('date', $this->item->created , 'd F Y'); ?>
  		</span>
  		<?php endif; ?>
  
  	  <?php if($this->item->params->get('catItemTitle')): ?>
  	  <!-- Item title -->
  	  <h3 class="liItemTitle catItemTitle">
  			<?php if(isset($this->item->editLink)): ?>
  			<!-- Item edit link -->
  			<span class="catItemEditLink">
  				<a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
  					<?php echo JText::_('K2_EDIT_ITEM'); ?>
  				</a>
  			</span>
  			<?php endif; ?>
  
  	  	<?php if ($this->item->params->get('catItemTitleLinked')): ?>
  			<a href="<?php echo $this->item->link; ?>">
  	  		<?php echo $this->item->title; ?>
  	  	</a>
  	  	<?php else: ?>
  	  	<?php echo $this->item->title; ?>
  	  	<?php endif; ?>
  
  	  	<?php if($this->item->params->get('catItemFeaturedNotice') && $this->item->featured): ?>
  	  	<!-- Featured flag -->
  	  	<span>
  		  	<sup>
  		  		<?php echo JText::_('K2_FEATURED'); ?>
  		  	</sup>
  	  	</span>
  	  	<?php endif; ?>
  	  </h3>
  	  <?php endif; ?>
  
  		<?php if($this->item->params->get('catItemAuthor')): ?>
  		<!-- Item Author -->
  		<span class="liItemAuthor catItemAuthor">
  			<?php echo K2HelperUtilities::writtenBy($this->item->author->profile->gender); ?> 
  			<?php if(isset($this->item->author->link) && $this->item->author->link): ?>
  			<a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
  			<?php else: ?>
  			<?php echo $this->item->author->name; ?>
  			<?php endif; ?>
  		</span>
  		<?php endif; ?>
    </div>
  
    <!-- Plugins: AfterDisplayTitle -->
    <?php echo $this->item->event->AfterDisplayTitle; ?>
  
    <!-- K2 Plugins: K2AfterDisplayTitle -->
    <?php echo $this->item->event->K2AfterDisplayTitle; ?>
  
  	<?php if($this->item->params->get('catItemRating')): ?>
  	<!-- Item Rating -->
  	<div class="liItemRatingBlock catItemRatingBlock">
  		<span><?php echo JText::_('K2_RATE_THIS_ITEM'); ?></span>
  		<div class="itemRatingForm">
  			<ul class="itemRatingList">
  				<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
  				<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
  				<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
  				<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
  				<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
  				<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
  			</ul>
  			<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
  			<div class="clr"></div>
  		</div>
  		<div class="clr"></div>
  	</div>
  	<?php endif; ?>
  
    <div class="liItemBody catItemBody">
  
  	  <!-- Plugins: BeforeDisplayContent -->
  	  <?php echo $this->item->event->BeforeDisplayContent; ?>
  
  	  <!-- K2 Plugins: K2BeforeDisplayContent -->
  	  <?php echo $this->item->event->K2BeforeDisplayContent; ?>	  
  
  	  <?php if($this->item->params->get('catItemIntroText')): ?>
  	  <!-- Item introtext -->
  	  <div class="liItemIntroText catItemIntroText">
  	  	<?php echo $this->item->introtext; ?>
  	  </div>
  	  <?php endif; ?>
  
  		<div class="clr"></div>
  
  	  <?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
  	  <!-- Item extra fields -->
  	  <div class="liItemExtraFields catItemExtraFields">
  	  	<h4><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h4>
  	  	<ul>
  			<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
  			<?php if($extraField->value != ''): ?>
  			<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
  				<?php if($extraField->type == 'header'): ?>
  				<h4 class="extraFieldsHeader"><?php echo $extraField->name; ?></h4>
  				<?php else: ?>
  				<span class="extraFieldsLabel"><?php echo $extraField->name; ?></span>
  				<span class="extraFieldsValue"><?php echo $extraField->value; ?></span>
  				<?php endif; ?>
  			</li>
  			<?php endif; ?>
  			<?php endforeach; ?>
  			</ul>
  	    <div class="clr"></div>
  	  </div>
  	  <?php endif; ?>
  
  	  <!-- Plugins: AfterDisplayContent -->
  	  <?php echo $this->item->event->AfterDisplayContent; ?>
  
  	  <!-- K2 Plugins: K2AfterDisplayContent -->
  	  <?php echo $this->item->event->K2AfterDisplayContent; ?>
  
  	  <div class="clr"></div>
    </div>
  
    <?php if(
    $this->item->params->get('catItemHits') ||
    $this->item->params->get('catItemCategory') ||
    $this->item->params->get('catItemTags') ||
    $this->item->params->get('catItemAttachments')
    ): ?>
    <div class="liItemLinks catItemLinks">
  
  		<?php if($this->item->params->get('catItemHits')): ?>
  		<!-- Item Hits -->
  		<div class="liItemHitsBlock catItemHitsBlock">
  			<span class="liItemHits catItemHits">
  				<?php echo JText::_('K2_READ'); ?> <b><?php echo $this->item->hits; ?></b> <?php echo JText::_('K2_TIMES'); ?>
  			</span>
  		</div>
  		<?php endif; ?>
  
  		<?php if($this->item->params->get('catItemCategory')): ?>
  		<!-- Item category name -->
  		<div class="liItemCategory catItemCategory">
  			<span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span>
  			<a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
  		</div>
  		<?php endif; ?>
  
  	  <?php if($this->item->params->get('catItemTags') && count($this->item->tags)): ?>
  	  <!-- Item tags -->
  	  <div class="liItemTagsBlock catItemTagsBlock">
  		  <span><i class="icon-tags"></i><?php //echo JText::_('K2_TAGGED_UNDER'); ?></span>
  		  <ul class="liItemTags catItemTags">
  		    <?php foreach ($this->item->tags as $tag): ?>
  		    <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
  		    <?php endforeach; ?>
  		  </ul>
  		  <div class="clr"></div>
  	  </div>
  	  <?php endif; ?>
  
  	  <?php if($this->item->params->get('catItemAttachments') && count($this->item->attachments)): ?>
  	  <!-- Item attachments -->
  	  <div class="liItemAttachmentsBlock catItemAttachmentsBlock">
  		  <span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
  		  <ul class="liItemAttachments catItemAttachments">
  		    <?php foreach ($this->item->attachments as $attachment): ?>
  		    <li>
  			    <a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>">
  			    	<?php echo $attachment->title ; ?>
  			    </a>
  			    <?php if($this->item->params->get('catItemAttachmentsCounter')): ?>
  			    <span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
  			    <?php endif; ?>
  		    </li>
  		    <?php endforeach; ?>
  		  </ul>
  	  </div>
  	  <?php endif; ?>
  
  		<div class="clr"></div>
    </div>
    <?php endif; ?>
  
  	<div class="clr"></div>
  
    <?php if($this->item->params->get('catItemVideo') && !empty($this->item->video)): ?>
    <!-- Item video -->
    <div class="liItemVideoBlock catItemVideoBlock">
    	<h3><?php echo JText::_('K2_RELATED_VIDEO'); ?></h3>
  		<?php if($this->item->videoType=='embedded'): ?>
  		<div class="liItemVideoEmbedded catItemVideoEmbedded">
  			<?php echo $this->item->video; ?>
  		</div>
  		<?php else: ?>
  		<span class="liItemVideo catItemVideo"><?php echo $this->item->video; ?></span>
  		<?php endif; ?>
    </div>
    <?php endif; ?>
  
    <?php if($this->item->params->get('catItemImageGallery') && !empty($this->item->gallery)): ?>
    <!-- Item image gallery -->
    <div class="liItemImageGallery catItemImageGallery">
  	  <h4><?php echo JText::_('K2_IMAGE_GALLERY'); ?></h4>
  	  <?php echo $this->item->gallery; ?>
    </div>
    <?php endif; ?>
  
    <div class="clr"></div>
  
  	<?php if($this->item->params->get('catItemCommentsAnchor') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1')) ): ?>
  	<!-- Anchor link to comments below -->
  	<div class="liItemCommentsLink catItemCommentsLink">
  		<?php if(!empty($this->item->event->K2CommentsCounter)): ?>
  			<!-- K2 Plugins: K2CommentsCounter -->
  			<?php echo $this->item->event->K2CommentsCounter; ?>
  		<?php else: ?>
  			<?php if($this->item->numOfComments > 0): ?>
  			<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
  				<?php echo $this->item->numOfComments; ?> <?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?>
  			</a>
  			<?php else: ?>
  			<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
  				<?php echo JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?>
  			</a>
  			<?php endif; ?>
  		<?php endif; ?>
  	</div>
  	<?php endif; ?>
    	
  	<div class="clr"></div>
  
  	<?php if($this->item->params->get('catItemDateModified')): ?>
  	<!-- Item date modified -->
  	<?php if($this->item->modified != $this->nullDate && $this->item->modified != $this->item->created ): ?>
  	<span class="liItemDateModified catItemDateModified">
  		<?php echo JText::_('K2_LAST_MODIFIED_ON'); ?> <?php echo JHTML::_('date', $this->item->modified, JText::_('K2_DATE_FORMAT_LC2')); ?>
  	</span>
  	<?php endif; ?>
  	<?php endif; ?>
  	
    <div class="clr"></div>
  </div>
  
  <!-- Plugins: AfterDisplay -->
  <?php echo $this->item->event->AfterDisplay; ?>

  <!-- K2 Plugins: K2AfterDisplay -->
  <?php echo $this->item->event->K2AfterDisplay; ?>

	<div class="clr"></div>	
</div>
<!-- End K2 Item Layout -->
