CREATE TABLE `#__admintools_acl` (   `user_id` bigint(20) unsigned NOT NULL,   `permissions` mediumtext,   PRIMARY KEY (`user_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_adminiplist` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_badwords` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `word` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_customperms` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `path` varchar(255) NOT NULL,   `perms` varchar(4) DEFAULT '0644',   UNIQUE KEY `id` (`id`),   KEY `path` (`path`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_filescache` (   `admintools_filescache_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `filedate` int(11) NOT NULL DEFAULT '0',   `filesize` int(11) NOT NULL DEFAULT '0',   `data` blob,   `checksum` varchar(32) NOT NULL DEFAULT '',   PRIMARY KEY (`admintools_filescache_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipautoban` (   `ip` varchar(255) NOT NULL,   `reason` varchar(255) DEFAULT 'other',   `until` datetime DEFAULT NULL,   UNIQUE KEY `ip` (`ip`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_ipblock` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `ip` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_log` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `logdate` datetime NOT NULL,   `ip` varchar(40) DEFAULT NULL,   `url` varchar(255) DEFAULT NULL,   `reason` varchar(255) DEFAULT 'other',   `extradata` mediumtext,   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_profiles`  VALUES ('1', 'Default PHP Change Scanner Profile', '', '');
CREATE TABLE `#__admintools_redirects` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `source` varchar(255) DEFAULT NULL,   `dest` varchar(255) DEFAULT NULL,   `ordering` bigint(20) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '1',   `keepurlparams` tinyint(1) NOT NULL DEFAULT '1',   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scanalerts` (   `admintools_scanalert_id` bigint(20) NOT NULL AUTO_INCREMENT,   `path` varchar(2048) NOT NULL,   `scan_id` bigint(20) NOT NULL DEFAULT '0',   `diff` mediumtext,   `threat_score` int(11) NOT NULL DEFAULT '0',   `acknowledged` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`admintools_scanalert_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_scans` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__admintools_storage` (   `key` varchar(255) NOT NULL,   `value` longtext NOT NULL,   PRIMARY KEY (`key`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__admintools_storage`  VALUES ('cparams', '{\"latestjversion\":\"{\\\"installed\\\":{\\\"version\\\":\\\"2.5.14\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18624\\\\\\/83477\\\\\\/Joomla_2.5.14-Stable-Full_Package.zip\\\"},\\\"current\\\":{\\\"version\\\":\\\"2.5.14\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18624\\\\\\/83477\\\\\\/Joomla_2.5.14-Stable-Full_Package.zip\\\"},\\\"sts\\\":{\\\"version\\\":\\\"3.1.5\\\",\\\"package\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/18622\\\\\\/83487\\\\\\/Joomla_3.1.5-Stable-Full_Package.zip\\\"},\\\"lts\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"}}\",\"lastjupdatecheck\":1381763295}'), ('fixperms_stack', '{\"folders\":[],\"files\":[],\"total\":0,\"done\":0}');
CREATE TABLE `#__admintools_wafexceptions` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `option` varchar(255) DEFAULT NULL,   `view` varchar(255) DEFAULT NULL,   `query` varchar(255) DEFAULT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_profiles`  VALUES ('1', 'Default Backup Profile', '###AES128###u0IxwI8smmRFknb8IbT1grwH6Xs9hlBF/Qf6BZk97fmFrjMWAsAzXkrUJMpWru3/PHTje0Lvdn1C5m652EZzYv4Q2g4oRgzquwPdk5CqtcGkiBHAsuPTyqK6iR4KTOLoRFv2bAFjwsjalg1OP9slDYSYr2ChRWP3Gv0jMtf+pCGUvpgcZseZzrdLp+GzgHK2h5vTqWBHLjnp6fRJq9/5PykpXYMLz1hOwQJ8Bo1ksvGcAmzJxbLTUHxr08pOksIQhTeLuuoboFD+0x26OYgQn+Qf5ZjVY0aXSeBJ5GO0xSVg5U++YtRiuVGv1Kba9LzIeeV1sGUVyBZXjCPlAXJRYxHYIN8KGvuT8bZSmOuyQB4W4CnUnP71uY4Ddis/z+BY3w6+B9h/8acUnOKNOHha7Nveq7kGhcff1OCUd6zz8Gl10K6KP/zQOiGAnKRasRic2DXnfwa4+/L+YDam47fvLENvrWiE/Ge7kRR1Gg0FOEm6jqITvxzpuZU8VOR8yfDY+nhdidziJq2Q2eCHuRzDy9Eab0bXPc6B2RNoMo2/llvUk/13ACbfZAkwYuYCSqUghvG5tvQfPZ7Ou6BZ/F5w3PAa4Ur58XLuSE5yf6FvFRkEXIcIjuO5VuxEIYm//mJokluFl+l7YDEI8F2ogT/aih0GITCgbXnlD5IOnbXpLuytf8QHEx1uOPGwPi6TGCHt+ltj4oQvsrGPIxSkWkeg8sWwlyiVFe3EUKYp8LUyioAAVdHaha+dukqaTwcsSXVYUA7qnYKY0DM8aCRIhb1sKlg5PBZbjvLgGnDjn4S19kPW+SBAng25txCiELX5AE50iG1f/nV872jVFw8dZS5EgJT38A8cT341wk1VRuEtP0/IfCh885fTIgzxgZfy+abbyLBlMJPggZmG5wqnhTgF1orfcjb4G9IgevOS/yLon11s7B4KCLTXMNzZ43pdV/FDFhlnhih1GH8AZZ6k0u4plbPPvY5ZM3vmPXA9Mw2WAWQ9FLkP/tqze1MBO3qfoqCgTWmbjOOi2aZXl/gfMb3BgfGlneKLafA5yXPi0ZSR1RA8cv8I71mPJ54oBf/2CQ+MjdSrlbEJ3r2i5Ll2ED+0J3PjY71nWdHRdgRG1LglaQqSYCB/eSMhxufF7UWnLDZ68x8bEtQ1XYwYNQzaZG+TTu84gj/Nwi2mGX5kstfJ8meqpudghudm64IelXKdybG43rH4CiZxVzg8AEZiO5A5R5W8zyfIx/0HYvreyUxG539DWiyysJ15nL9FMJvzGhpy1AyEt4NAcusFScye6Hrw7hLFtP+HQ0v9nOs1nx1ZWS/xmPt6moVrIkbqEz1O/05f0KCwXg8kUx+A7un/kMedhRMWCPMNY3BZFQ2Uv+8drqKHGqfjOyzWH/xS0GlE/QM1jRc+D4NFmnfvuwsj/m653DpanmBVMMOs+9V8XwXAAHOIuQXfBueMpNNwTwRfUFsqdHHt5iY5ZRTfJJScg7EJSLdmEXt3ehi1SEnRtC/wWj2gIjK7HvPwsPcF2KKqdrOKLp/NJLQ44Wkt/F5ZIx1AGhnolGGWFmqaiYF32+RzQr/4Ep9T4+F/rzkVRIpQR8+ZBh3Z500o4wYwWTKByI19zVx4CO5WjQjUVkjZT+3x5LFU7MxF1CwBirDb5PW4ElR4HCVrP6lwf7Ew09obwoRgm63cQOciiaw7B3pRebVL0OHVL3WlxN8gNMWlrEAtjdRBD6hcgs4dRSYIsIAro+maOJPtyKnLA6Fg1ydewJJbHjFYbQtrQ58a4he3UYamgNGq816CaknhPBDd9cQf8KpoK7/VbopESXkhQ3/GpaozyCHfryuuDvEvocvj6SRq23hVnP4Bmat5vbx5fNtyoQ5r2HLBGDYCSV80e4M168KhTgE3kfe45rgXoR5XjNI/ODA7QXH48tvU5u/14LcwKh0zP/fkqZEyivLp/oE1T5z9A5SpA5Iu8tXHxxufjqIhpN8avu/+U/7YHlHrOYFWDJt4zRY9+m4Y8moYoAjNOFsvLLBQp6DrpAKzGFyMV5N6VZ0KZwtqDtTtRrRkY+hiCWlzPeU5R/dzo9fyxY4TRJEmru/4deFpyyOb3ZpGyAb8bNoLNfXhRNiBLHY5iZfRWWsiI0C+gGanzRaiwCsIbrm9svJqumgjSs2GcMRareCG7MW2XAYAAA==', 'a:2:{s:11:\"directories\";a:1:{s:10:\"[SITEROOT]\";a:1:{i:0;s:2:\"v1\";}}s:5:\"files\";a:1:{s:10:\"[SITEROOT]\";a:5:{i:0;s:17:\"configuration.php\";i:1;s:10:\".gitignore\";i:2;s:9:\".htaccess\";i:3;s:8:\".project\";i:4;s:7:\"apc.php\";}}}');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_stats`  VALUES ('13', 'Backup taken on Friday, 29 November 2013 13:54', '', '2013-11-29 13:54:54', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'getk2_demosite_j25_20131129.zip', '/home/demos/domains/demo.nuevvo.com/public_html/commercial/j25/takai/administrator/components/com_akeeba/backup/getk2_demosite_j25_20131129.zip', '0', 'backend', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext,   PRIMARY KEY (`tag`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=MyISAM AUTO_INCREMENT=265 DEFAULT CHARSET=utf8;
INSERT INTO `#__assets`  VALUES ('1', '0', '1', '460', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '10', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '11', '12', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '13', '14', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '15', '16', '1', 'com_config', 'com_config', '{}'), ('7', '1', '17', '20', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '21', '58', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '59', '60', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '61', '62', '1', 'com_installer', 'com_installer', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.delete\":[],\"core.edit.state\":[]}'), ('11', '1', '63', '64', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '65', '66', '1', 'com_login', 'com_login', '{}'), ('13', '1', '67', '68', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '69', '70', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '71', '72', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '73', '74', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '75', '76', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '77', '78', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '79', '82', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '83', '84', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('21', '1', '85', '86', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '87', '88', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '89', '90', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '91', '92', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('25', '1', '93', '96', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('26', '1', '97', '98', '1', 'com_wrapper', 'com_wrapper', '{}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Leaderboard - (728x90)', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '18', '19', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '80', '81', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('31', '25', '94', '95', '2', 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '1', '452', '453', '1', 'com_admintools', 'admintools', '{}'), ('33', '1', '454', '455', '1', 'com_k2', 'k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('147', '8', '22', '47', '2', 'com_content.category.25', 'Subjects', ''), ('148', '8', '48', '55', '2', 'com_content.category.26', 'Catalogue', ''), ('149', '8', '56', '57', '2', 'com_content.category.27', 'Typography', ''), ('150', '147', '23', '24', '3', 'com_content.category.28', 'Automotive', ''), ('230', '147', '41', '42', '3', 'com_content.category.37', 'Technology', ''), ('221', '147', '39', '40', '3', 'com_content.category.36', 'Style', ''), ('212', '147', '37', '38', '3', 'com_content.category.35', 'Sports', ''), ('203', '147', '35', '36', '3', 'com_content.category.34', 'Politics', ''), ('195', '147', '33', '34', '3', 'com_content.category.33', 'Health', ''), ('186', '147', '31', '32', '3', 'com_content.category.32', 'Entertainment', ''), ('177', '147', '29', '30', '3', 'com_content.category.31', 'Design', ''), ('168', '147', '27', '28', '3', 'com_content.category.30', 'Culture', ''), ('159', '147', '25', '26', '3', 'com_content.category.29', 'Business', ''), ('239', '147', '43', '44', '3', 'com_content.category.38', 'Travel', ''), ('248', '147', '45', '46', '3', 'com_content.category.39', 'World News', ''), ('256', '148', '49', '54', '3', 'com_content.category.40', 'Fashion', ''), ('257', '256', '50', '51', '4', 'com_content.category.41', 'Woman Collection', ''), ('258', '256', '52', '53', '4', 'com_content.category.42', 'Men Collection', ''), ('260', '1', '456', '457', '1', 'com_akeeba', 'akeeba', '{}'), ('262', '1', '458', '459', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('263', '3', '6', '7', '2', 'com_banners.category.43', 'Banner 300x250 (top)', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('264', '3', '8', '9', '2', 'com_banners.category.44', 'Banner 300x250 (bottom)', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
CREATE TABLE `#__associations` (   `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner_clients` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `contact` varchar(255) NOT NULL DEFAULT '',   `email` varchar(255) NOT NULL DEFAULT '',   `extrainfo` text NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `metakey` text NOT NULL,   `own_prefix` tinyint(4) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   PRIMARY KEY (`id`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__banner_clients`  VALUES ('1', 'Default Client', 'Client', 'nospam@nuevvo.com', '', '1', '0', '0000-00-00 00:00:00', '', '0', '', '-1', '0', '0');
CREATE TABLE `#__banner_tracks` (   `track_date` datetime NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL,   `count` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`track_date`,`track_type`,`banner_id`),   KEY `idx_track_date` (`track_date`),   KEY `idx_track_type` (`track_type`),   KEY `idx_banner_id` (`banner_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__banners` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `clickurl` varchar(200) NOT NULL DEFAULT '',   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text NOT NULL,   `custombannercode` varchar(2048) NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `params` text NOT NULL,   `own_prefix` tinyint(1) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(255) NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `language` char(7) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `idx_state` (`state`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`),   KEY `idx_banner_catid` (`catid`),   KEY `idx_language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `#__banners`  VALUES ('1', '1', '1', 'Leaderboard 728x90', 'leaderboard-728x90', '0', '540', '0', '', '1', '3', '', '<iframe src=\"http://cdn.joomlaworks.org/ads/728x90_all.html\" style=\"border:none;padding:0;margin:0 auto;overflow:hidden;width:728px;height:90px;display:block;\" frameborder=\"0\" scrolling=\"no\"></iframe>', '0', '1', '', '{\"imageurl\":\"\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', '0', '', '1', '0', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-07-04 17:57:33', '*'), ('2', '1', '1', 'Rectangle 300x250 top', 'rectangle-300x250-top', '0', '538', '0', '', '1', '43', '', '<!-- 300x250 -->\r\n<iframe src=\"http://cdn.joomlaworks.org/ads/300x250_all.html\" style=\"border:none;padding:0;margin:0 auto;overflow:hidden;width:300px;height:250px;display:block;\"></iframe>', '0', '1', '', '{\"imageurl\":\"\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', '0', '', '1', '0', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-07-04 17:58:12', '*'), ('3', '1', '1', 'Rectangle 300x250 bottom', 'rectangle-300x250-bottom', '0', '536', '0', '', '1', '44', '', '<!-- 300x250 -->\r\n<iframe src=\"http://cdn.joomlaworks.org/ads/300x250_all.html\" style=\"border:none;padding:0;margin:0 auto;overflow:hidden;width:300px;height:250px;display:block;\"></iframe>', '0', '1', '', '{\"imageurl\":\"\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', '0', '', '1', '0', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-07-04 17:58:45', '*');
CREATE TABLE `#__categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `level` int(10) unsigned NOT NULL DEFAULT '0',   `path` varchar(255) NOT NULL DEFAULT '',   `extension` varchar(50) NOT NULL DEFAULT '',   `title` varchar(255) NOT NULL,   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `note` varchar(255) NOT NULL DEFAULT '',   `description` mediumtext,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `access` int(10) unsigned DEFAULT NULL,   `params` text NOT NULL,   `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',   `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',   `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `cat_idx` (`extension`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_path` (`path`),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`),   KEY `idx_language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
INSERT INTO `#__categories`  VALUES ('1', '0', '0', '0', '49', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2009-10-18 16:07:09', '0', '0000-00-00 00:00:00', '0', '*'), ('3', '28', '1', '1', '2', '1', 'leaderboard-728x90', 'com_banners', 'Leaderboard - (728x90)', 'leaderboard-728x90', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:35', '45', '2013-07-04 17:53:24', '0', '*'), ('4', '29', '1', '3', '4', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:57', '0', '0000-00-00 00:00:00', '0', '*'), ('5', '30', '1', '5', '6', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:15', '0', '0000-00-00 00:00:00', '0', '*'), ('6', '31', '1', '7', '8', '1', 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '0', '0000-00-00 00:00:00', '0', '*'), ('33', '195', '25', '20', '21', '2', 'subjects/health', 'com_content', 'Health', 'health', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:22', '44', '2011-11-29 16:17:24', '0', '*'), ('27', '149', '1', '43', '44', '1', 'typography', 'com_content', 'Typography', 'typography', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('25', '147', '1', '9', '34', '1', 'subjects', 'com_content', 'Subjects', 'subjects', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:20', '44', '2011-11-29 16:17:24', '0', '*'), ('26', '148', '1', '35', '42', '1', 'catalogue', 'com_content', 'Catalogue', 'catalogue', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('42', '258', '40', '39', '40', '3', 'catalogue/fashion/men-collection', 'com_content', 'Men Collection', 'men-collection', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:24', '44', '2011-11-29 16:17:24', '0', '*'), ('32', '186', '25', '18', '19', '2', 'subjects/entertainment', 'com_content', 'Entertainment', 'entertainment', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:22', '44', '2011-11-29 16:17:24', '0', '*'), ('28', '150', '25', '10', '11', '2', 'subjects/automotive', 'com_content', 'Automotive', 'automotive', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('29', '159', '25', '12', '13', '2', 'subjects/business', 'com_content', 'Business', 'business', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('30', '168', '25', '14', '15', '2', 'subjects/culture', 'com_content', 'Culture', 'culture', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('41', '257', '40', '37', '38', '3', 'catalogue/fashion/woman-collection', 'com_content', 'Woman Collection', 'woman-collection', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:24', '44', '2011-11-29 16:17:24', '0', '*'), ('40', '256', '26', '36', '41', '2', 'catalogue/fashion', 'com_content', 'Fashion', 'fashion', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:24', '44', '2011-11-29 16:17:24', '0', '*'), ('39', '248', '25', '32', '33', '2', 'subjects/world-news', 'com_content', 'World News', 'world-news', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:23', '44', '2011-11-29 16:17:24', '0', '*'), ('38', '239', '25', '30', '31', '2', 'subjects/travel', 'com_content', 'Travel', 'travel', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:23', '44', '2011-11-29 16:17:24', '0', '*'), ('37', '230', '25', '28', '29', '2', 'subjects/technology', 'com_content', 'Technology', 'technology', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:23', '44', '2011-11-29 16:17:24', '0', '*'), ('36', '221', '25', '26', '27', '2', 'subjects/style', 'com_content', 'Style', 'style', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:23', '44', '2011-11-29 16:17:24', '0', '*'), ('35', '212', '25', '24', '25', '2', 'subjects/sports', 'com_content', 'Sports', 'sports', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:23', '44', '2011-11-29 16:17:24', '0', '*'), ('34', '203', '25', '22', '23', '2', 'subjects/politics', 'com_content', 'Politics', 'politics', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:22', '44', '2011-11-29 16:17:24', '0', '*'), ('31', '177', '25', '16', '17', '2', 'subjects/design', 'com_content', 'Design', 'design', '', '', '-2', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '44', '2011-11-29 16:17:21', '44', '2011-11-29 16:17:24', '0', '*'), ('43', '263', '1', '45', '46', '1', 'banner-300x250-top', 'com_banners', 'Banner 300x250 (top)', 'banner-300x250-top', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '45', '2013-07-04 17:53:36', '0', '0000-00-00 00:00:00', '0', '*'), ('44', '264', '1', '47', '48', '1', 'banner-300x250-bottom', 'com_banners', 'Banner 300x250 (bottom)', 'banner-300x250-bottom', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '45', '2013-07-04 17:53:47', '0', '0000-00-00 00:00:00', '0', '*');
CREATE TABLE `#__contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `con_position` varchar(255) DEFAULT NULL,   `address` text,   `suburb` varchar(100) DEFAULT NULL,   `state` varchar(100) DEFAULT NULL,   `country` varchar(100) DEFAULT NULL,   `postcode` varchar(100) DEFAULT NULL,   `telephone` varchar(255) DEFAULT NULL,   `fax` varchar(255) DEFAULT NULL,   `misc` mediumtext,   `image` varchar(255) DEFAULT NULL,   `imagepos` varchar(20) DEFAULT NULL,   `email_to` varchar(255) DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned DEFAULT NULL,   `mobile` varchar(255) NOT NULL DEFAULT '',   `webpage` varchar(255) NOT NULL DEFAULT '',   `sortname1` varchar(255) NOT NULL,   `sortname2` varchar(255) NOT NULL,   `sortname3` varchar(255) NOT NULL,   `language` char(7) NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__contact_details`  VALUES ('1', 'Contact us', 'contact-us', '', '', '', '', '', '', '', '', '', '', NULL, '', '0', '1', '0', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"hide\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"0\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":null,\"linkb_name\":\"\",\"linkb\":null,\"linkc_name\":\"\",\"linkc\":null,\"linkd_name\":\"\",\"linkd\":null,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '45', '4', '1', '', '', '', '', '', '*', '2013-07-01 15:18:59', '45', '', '2013-07-01 15:54:28', '45', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
CREATE TABLE `#__content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',   `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `sectionid` int(10) unsigned NOT NULL DEFAULT '0',   `mask` int(10) unsigned NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text NOT NULL,   `urls` text NOT NULL,   `attribs` varchar(5120) NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   `parentid` int(10) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `access` int(10) unsigned NOT NULL DEFAULT '0',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `metadata` text NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `language` char(7) NOT NULL COMMENT 'The language code for the article.',   `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=MyISAM AUTO_INCREMENT=95 DEFAULT CHARSET=utf8;
CREATE TABLE `#__content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__content_frontpage`  VALUES ('53', '3'), ('80', '2'), ('47', '1');
CREATE TABLE `#__content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',   `rating_count` int(10) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__core_log_searches` (   `search_term` varchar(128) NOT NULL DEFAULT '',   `hits` int(10) unsigned NOT NULL DEFAULT '0' ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__extensions` (   `extension_id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL,   `type` varchar(20) NOT NULL,   `element` varchar(100) NOT NULL,   `folder` varchar(100) NOT NULL,   `client_id` tinyint(3) NOT NULL,   `enabled` tinyint(3) NOT NULL DEFAULT '1',   `access` int(10) unsigned DEFAULT NULL,   `protected` tinyint(3) NOT NULL DEFAULT '0',   `manifest_cache` text NOT NULL,   `params` text NOT NULL,   `custom_data` text NOT NULL,   `system_data` text NOT NULL,   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) DEFAULT '0',   `state` int(11) DEFAULT '0',   PRIMARY KEY (`extension_id`),   KEY `element_clientid` (`element`,`client_id`),   KEY `element_folder_clientid` (`element`,`folder`,`client_id`),   KEY `extension` (`type`,`element`,`folder`,`client_id`) ) ENGINE=MyISAM AUTO_INCREMENT=10061 DEFAULT CHARSET=utf8;
INSERT INTO `#__extensions`  VALUES ('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"0\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\",\"enable_flash\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"10\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"12\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"11.4\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('405', 'plg_content_geshi', 'plugin', 'geshi', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"xhtml\"}', '', '', '0', '2011-09-18 15:22:50', '0', '0'), ('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"2.5.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2013\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.4.1\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"compressed\":\"0\",\"cleanup_startup\":\"0\",\"cleanup_save\":\"2\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"safari\":\"0\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0'), ('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '8', '0'), ('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('500', 'atomic', 'template', 'atomic', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('502', 'bluestork', 'template', 'bluestork', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('503', 'beez_20', 'template', 'beez_20', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"2.5.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('505', 'beez5', 'template', 'beez5', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.10\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.10\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.16\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('800', 'PKG_JOOMLA', 'package', 'pkg_joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10001', 'System - Admin Tools', 'plugin', 'admintools', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Admin Tools\",\"type\":\"plugin\",\"creationDate\":\"2013-11-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.10\",\"description\":\"\\n\\t\\tHandles all the system-wide features provided by Admin Tools Core\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '-30000', '0'), ('10002', 'admintools', 'component', 'com_admintools', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Admintools\",\"type\":\"component\",\"creationDate\":\"2013-11-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.5.10\",\"description\":\"Security and utilitarian tools for Joomla! site administrators\",\"group\":\"\"}', '{\"liveupdate\":\"lastcheck=1385724125\\nupdatedata=\\\"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\\\"\\nstuck=0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10003', 'K2 Comments', 'module', 'mod_k2_comments', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10004', 'K2 Content', 'module', 'mod_k2_content', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10006', 'K2 Tools', 'module', 'mod_k2_tools', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_TOOLS\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10007', 'K2 Users', 'module', 'mod_k2_users', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10008', 'K2 User', 'module', 'mod_k2_user', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10009', 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10010', 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10011', 'Search - K2', 'plugin', 'k2', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10012', 'System - K2', 'plugin', 'k2', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10013', 'User - K2', 'plugin', 'k2', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10014', 'com_k2', 'component', 'com_k2', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla!\",\"group\":\"\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"1.8remote\",\"backendJQueryHandling\":\"remote\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeedLink\":\"1\",\"userFeedIcon\":\"1\",\"userItemCount\":\"10\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"1\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"1\",\"userItemTags\":\"1\",\"userItemCommentsAnchor\":\"1\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"10\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"1\",\"tagItemDateCreated\":\"1\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"1\",\"tagItemReadMore\":\"1\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"0\",\"genericItemCount\":\"10\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"1\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"1\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"1\",\"genericFeedLink\":\"1\",\"genericFeedIcon\":\"1\",\"feedLimit\":\"10\",\"feedItemImage\":\"1\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"1\",\"feedItemVideo\":\"1\",\"feedItemGallery\":\"1\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"100\",\"itemImageS\":\"210\",\"itemImageM\":\"320\",\"itemImageL\":\"480\",\"itemImageXL\":\"670\",\"itemImageGeneric\":\"310\",\"catImageWidth\":\"194\",\"catImageDefault\":\"1\",\"userImageWidth\":\"200\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"48\",\"onlineImageEditor\":\"splashup\",\"imageTimestamp\":\"1\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"joomlaworks\",\"facebookImage\":\"Small\",\"comments\":\"2\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"10\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"0\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"1\",\"gravatar\":\"1\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"1\",\"akismetForRegistered\":\"1\",\"commentsFormNotes\":\"1\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"0\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"0\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"1\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"K2UserGroup\":\"1\",\"redirect\":\"\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaOnRegistration\":\"1\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"1\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"2\",\"k2SefLabelItemCustomPrefix\":\"story\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"slash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\",\"sh404SefLabelCat\":\"\",\"sh404SefLabelUser\":\"blog\",\"sh404SefLabelItem\":\"2\",\"sh404SefTitleAlias\":\"alias\",\"sh404SefModK2ContentFeedAlias\":\"feed\",\"sh404SefInsertItemId\":\"0\",\"sh404SefInsertUniqueItemId\":\"0\",\"cbIntegration\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10015', 'AllVideos (by JoomlaWorks)', 'plugin', 'jw_allvideos', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"AllVideos (by JoomlaWorks)\",\"type\":\"plugin\",\"creationDate\":\"February 27th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"contact@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"4.5.0\",\"description\":\"JW_PLG_AV_XML_DESC\",\"group\":\"\"}', '{\"playerTemplate\":\"Responsive\",\"vfolder\":\"images\\/videos\",\"vwidth\":\"834\",\"vheight\":\"480\",\"transparency\":\"transparent\",\"background\":\"#010101\",\"controlBarLocation\":\"bottom\",\"backgroundQT\":\"black\",\"afolder\":\"images\\/audio\",\"awidth\":\"300\",\"aheight\":\"20\",\"abackground\":\"#010101\",\"afrontcolor\":\"#FFFFFF\",\"alightcolor\":\"#00ADE3\",\"allowAudioDownloading\":\"0\",\"autoplay\":\"0\",\"gzipScripts\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"en-gb\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '10', '0'), ('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('27', 'com_finder', 'component', 'com_finder', '', '1', '1', '0', '0', '', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"porter_en\",\"enable_logging\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.7.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10017', 'PLG_SYSTEM_CACHECLEANER', 'plugin', 'cachecleaner', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_SYSTEM_CACHECLEANER\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"PLG_SYSTEM_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10021', 'plg_finder_k2', 'plugin', 'k2', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10059', 'Takai', 'template', 'takai', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Takai\",\"type\":\"template\",\"creationDate\":\"October, 2013\",\"author\":\"Nuevvo\",\"copyright\":\"Copyright (c) 2010 - 2013 Nuevvo Webware Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@nuevvo.com\",\"authorUrl\":\"http:\\/\\/nuevvo.com\",\"version\":\"1.0.0\",\"description\":\"TPL_NU_XML_DESCRIPTION\",\"group\":\"\"}', '{\"siteTextAsLogo\":\"\",\"siteTagline\":\"\",\"nutpJqueryHandling\":\"1.10.1\",\"nutpLoadCustomCSS\":\"1\",\"nutpLoadCustomJS\":\"1\",\"nutpGoogleWebFonts\":\"Istok Web,Droid Serif\",\"nutpMetaDistribution\":\"global\",\"nutpRemoveCanonicalMeta\":\"0\",\"nutpForceLoadBootstrap\":\"0\",\"nutpCreditsName\":\"designed by Nuevvo\",\"nutpCreditsLink\":\"http:\\/\\/nuevvo.com\",\"nutpCopyright\":\"\",\"nutpCopyrightStartYear\":\"\",\"nutpGAID\":\"\",\"nutpGADomain\":\"\",\"nutpGoogleVerificationID\":\"\",\"nutpBingVerificationID\":\"\",\"nutpAlexaVerificationID\":\"\",\"nutpHeadTop\":\"\",\"nutpHeadBottom\":\"\",\"nutpBodyTop\":\"\",\"nutpBodyBottom\":\"\",\"colorVariations\":\"default\",\"sidebartabsleft\":\"LATEST COMMENTS\",\"sidebartabsmiddle\":\"TOP COMMENTERS\",\"sidebartabsright\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10060', 'FOF', 'library', 'lib_fof', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2013-11-13 11:10:54\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2013 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.1.0\",\"description\":\"Framework-on-Framework (FOF) - A rapid component development framework for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10026', 'AkeebaStrapper', 'file', 'files_strapper', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"AkeebaStrapper\",\"type\":\"file\",\"creationDate\":\"July 2012\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"(C) 2012-2013 Akeeba Ltd.\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"1.0.0\",\"description\":\"Namespaced jQuery, jQuery UI and Bootstrap for Akeeba products.\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10029', 'akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2013-11-20\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.9.1\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\"}', '{\"siteurl\":\"http:\\/\\/demo.nuevvo.com\\/commercial\\/j25\\/takai\\/\",\"jlibrariesdir\":\"\\/home\\/demos\\/domains\\/demo.nuevvo.com\\/public_html\\/commercial\\/j25\\/takai\\/libraries\",\"jversion\":\"1.6\",\"lastversion\":\"3.8.2\",\"minstability\":\"stable\",\"liveupdate\":\"lastcheck=1385724096\\nupdatedata=\\\"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\\\"\\nstuck=0\",\"acceptlicense\":true,\"acceptsupport\":true,\"acceptbackuptest\":true,\"angieupgrade\":0}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10054', 'ArabicUnitag', 'language', 'ar-AA', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"27 April 2013\",\"author\":\"Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia\",\"copyright\":\"Copyright (C) 2005 - 2012 Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia and Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.11\",\"description\":\"Arabic Unitag site language pack for Joomla! 2.5.11 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10055', 'ArabicUnitag', 'language', 'ar-AA', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"27 April 2013\",\"author\":\"Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia\",\"copyright\":\"Copyright (C) 2005 - 2012 Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia and Open Source Matters. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com \\/ maxnew486@hotmail.com\\u200f\",\"authorUrl\":\"www.jarabic.com\",\"version\":\"2.5.11\",\"description\":\"Arabic Unitag Administrator language 2.5.11 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10056', 'اللغة العربية للمحرر TinyMCE', 'file', 'TinyMCE_ar-AA', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0644\\u0645\\u062d\\u0631\\u0631 TinyMCE\",\"type\":\"file\",\"creationDate\":\"01 September 2012\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"(C) 2010-2011 Arabic Translation Team\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.jarabic.com\",\"version\":\"3.5.3\",\"description\":\"\\n\\t\\t<h3>\\u062a\\u0645 \\u0628\\u0646\\u062c\\u0627\\u062d \\u062a\\u0646\\u0635\\u064a\\u0628 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0644\\u0645\\u062d\\u0631\\u0631 TinyMCE 3 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0645\\u062f \\u0641\\u064a \\u062c\\u0648\\u0645\\u0644\\u0627! 2.5<\\/h3>\\n\\t\\t<div style=\\\"font-weight:normal\\\">\\u062a\\u0630\\u0643\\u0631 \\u0623\\u0646\\u0647 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0627\\u062c\\u0628 \\u0627\\u062f\\u062e\\u0627\\u0644 \\u0643\\u0648\\u062f \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 ar \\u0641\\u064a \\u062e\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0639\\u0646\\u062f<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong> \\u0627\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0645\\u062d\\u0631\\u0631-TinyMCE <\\/strong><\\/a><br \\/>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10030', 'PLG_JMONITORING_AKEEBABACKUP_TITLE', 'plugin', 'akeebabackup', 'jmonitoring', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_JMONITORING_AKEEBABACKUP_TITLE\",\"type\":\"plugin\",\"creationDate\":\"May 2012\",\"author\":\"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com\",\"copyright\":\"\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"1.0\",\"description\":\"PLG_JMONITORING_AKEEBABACKUP_DESCRIPTION\",\"group\":\"\"}', '{\"maxbackupperiod\":\"24\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10031', 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Josetta - K2 Categories\",\"type\":\"plugin\",\"creationDate\":\"July 8th, 2013\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10032', 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Josetta - K2 Items\",\"type\":\"plugin\",\"creationDate\":\"June 7th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.7\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10051', 'MOD_CACHECLEANER', 'module', 'mod_cachecleaner', '', '1', '1', '3', '0', '{\"legacy\":false,\"name\":\"MOD_CACHECLEANER\",\"type\":\"module\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"3.1.5FREE\",\"description\":\"MOD_CACHECLEANER_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10052', 'PLG_SYSTEM_NNFRAMEWORK', 'plugin', 'nnframework', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"PLG_SYSTEM_NNFRAMEWORK\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"NoNumber (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2012 NoNumber All Rights Reserved\",\"authorEmail\":\"peter@nonumber.nl\",\"authorUrl\":\"http:\\/\\/www.nonumber.nl\",\"version\":\"13.5.3\",\"description\":\"PLG_SYSTEM_NNFRAMEWORK_DESC\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10057', 'ar-AA', 'package', 'pkg_ar-AA', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Arabic Unitag Language Package - \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\",\"type\":\"package\",\"creationDate\":\"27 April 2013\",\"author\":\"Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters & Dr. Ashraf Damra\\/Abu Nidal and Karim embarek\\/xmedia. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com \\/ maxnew486@hotmail.com\\u200f\",\"authorUrl\":\"www.jarabic.com\",\"version\":\"2.5.11.1\",\"description\":\"\\n\\t    <h3>\\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u062c\\u0648\\u0645\\u0644\\u0627! 2.5.11 \\u0627\\u0644\\u0627\\u0635\\u062f\\u0627\\u0631 1<\\/h3>\\n\\t\\t<h3>Arabic Unitag Language Package for Joomla! 2.5.11 version 1<\\/h3>\\n\\t\\t<h3>\\u062a\\u0645 \\u0628\\u0646\\u062c\\u0627\\u062d \\u062a\\u0646\\u0635\\u064a\\u0628 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0644\\u0645\\u062d\\u0631\\u0631 TinyMCE 3 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0645\\u062f \\u0641\\u064a \\u062c\\u0648\\u0645\\u0644\\u0627! 2.5<\\/h3>\\n\\t\\t<div style=\\\"font-weight:normal\\\">\\u062a\\u0630\\u0643\\u0631 \\u0623\\u0646\\u0647 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0627\\u062c\\u0628 \\u0627\\u062f\\u062e\\u0627\\u0644 \\u0643\\u0648\\u062f \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 ar \\u0641\\u064a \\u062e\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0639\\u0646\\u062f<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong> \\u0627\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0645\\u062d\\u0631\\u0631-TinyMCE <\\/strong><\\/a><br \\/>\\n\\t\\t\\n   \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
CREATE TABLE `#__finder_filters` (   `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '1',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL,   `created_by_alias` varchar(255) NOT NULL,   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `map_count` int(10) unsigned NOT NULL DEFAULT '0',   `data` text NOT NULL,   `params` mediumtext,   PRIMARY KEY (`filter_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links` (   `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `url` varchar(255) NOT NULL,   `route` varchar(255) NOT NULL,   `title` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `md5sum` varchar(32) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '1',   `state` int(5) DEFAULT '1',   `access` int(5) DEFAULT '0',   `language` varchar(8) NOT NULL,   `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `list_price` double unsigned NOT NULL DEFAULT '0',   `sale_price` double unsigned NOT NULL DEFAULT '0',   `type_id` int(11) NOT NULL,   `object` mediumblob NOT NULL,   PRIMARY KEY (`link_id`),   KEY `idx_type` (`type_id`),   KEY `idx_title` (`title`),   KEY `idx_md5` (`md5sum`),   KEY `idx_url` (`url`(75)),   KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),   KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms0` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms1` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms2` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms3` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms4` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms5` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms6` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms7` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms8` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_terms9` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsa` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsb` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsc` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsd` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termse` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_links_termsf` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_taxonomy` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL,   `state` tinyint(1) unsigned NOT NULL DEFAULT '1',   `access` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `parent_id` (`parent_id`),   KEY `state` (`state`),   KEY `ordering` (`ordering`),   KEY `access` (`access`),   KEY `idx_parent_published` (`parent_id`,`state`,`access`) ) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_taxonomy_map` (   `link_id` int(10) unsigned NOT NULL,   `node_id` int(10) unsigned NOT NULL,   PRIMARY KEY (`link_id`,`node_id`),   KEY `link_id` (`link_id`),   KEY `node_id` (`node_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_terms` (   `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '0',   `soundex` varchar(75) NOT NULL,   `links` int(10) NOT NULL DEFAULT '0',   PRIMARY KEY (`term_id`),   UNIQUE KEY `idx_term` (`term`),   KEY `idx_term_phrase` (`term`,`phrase`),   KEY `idx_stem_phrase` (`stem`,`phrase`),   KEY `idx_soundex_phrase` (`soundex`,`phrase`) ) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_terms_common` (   `term` varchar(75) NOT NULL,   `language` varchar(3) NOT NULL,   KEY `idx_word_lang` (`term`,`language`),   KEY `idx_lang` (`language`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__finder_terms_common`  VALUES ('a', 'en'), ('about', 'en'), ('after', 'en'), ('ago', 'en'), ('all', 'en'), ('am', 'en'), ('an', 'en'), ('and', 'en'), ('ani', 'en'), ('any', 'en'), ('are', 'en'), ('aren\'t', 'en'), ('as', 'en'), ('at', 'en'), ('be', 'en'), ('but', 'en'), ('by', 'en'), ('for', 'en'), ('from', 'en'), ('get', 'en'), ('go', 'en'), ('how', 'en'), ('if', 'en'), ('in', 'en'), ('into', 'en'), ('is', 'en'), ('isn\'t', 'en'), ('it', 'en'), ('its', 'en'), ('me', 'en'), ('more', 'en'), ('most', 'en'), ('must', 'en'), ('my', 'en'), ('new', 'en'), ('no', 'en'), ('none', 'en'), ('not', 'en'), ('noth', 'en'), ('nothing', 'en'), ('of', 'en'), ('off', 'en'), ('often', 'en'), ('old', 'en'), ('on', 'en'), ('onc', 'en'), ('once', 'en'), ('onli', 'en'), ('only', 'en'), ('or', 'en'), ('other', 'en'), ('our', 'en'), ('ours', 'en'), ('out', 'en'), ('over', 'en'), ('page', 'en'), ('she', 'en'), ('should', 'en'), ('small', 'en'), ('so', 'en'), ('some', 'en'), ('than', 'en'), ('thank', 'en'), ('that', 'en'), ('the', 'en'), ('their', 'en'), ('theirs', 'en'), ('them', 'en'), ('then', 'en'), ('there', 'en'), ('these', 'en'), ('they', 'en'), ('this', 'en'), ('those', 'en'), ('thus', 'en'), ('time', 'en'), ('times', 'en'), ('to', 'en'), ('too', 'en'), ('true', 'en'), ('under', 'en'), ('until', 'en'), ('up', 'en'), ('upon', 'en'), ('use', 'en'), ('user', 'en'), ('users', 'en'), ('veri', 'en'), ('version', 'en'), ('very', 'en'), ('via', 'en'), ('want', 'en'), ('was', 'en'), ('way', 'en'), ('were', 'en'), ('what', 'en'), ('when', 'en'), ('where', 'en'), ('whi', 'en'), ('which', 'en'), ('who', 'en'), ('whom', 'en'), ('whose', 'en'), ('why', 'en'), ('wide', 'en'), ('will', 'en'), ('with', 'en'), ('within', 'en'), ('without', 'en'), ('would', 'en'), ('yes', 'en'), ('yet', 'en'), ('you', 'en'), ('your', 'en'), ('yours', 'en');
CREATE TABLE `#__finder_tokens` (   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '1',   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   KEY `idx_word` (`term`),   KEY `idx_context` (`context`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_tokens_aggregate` (   `term_id` int(10) unsigned NOT NULL,   `map_suffix` char(1) NOT NULL,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `term_weight` float unsigned NOT NULL,   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   `context_weight` float unsigned NOT NULL,   `total_weight` float unsigned NOT NULL,   KEY `token` (`term`),   KEY `keyword_id` (`term_id`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8;
CREATE TABLE `#__finder_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(100) NOT NULL,   `mime` varchar(100) NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `title` (`title`) ) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
INSERT INTO `#__finder_types`  VALUES ('1', 'K2 Item', ''), ('2', 'Category', ''), ('3', 'Contact', ''), ('4', 'Article', ''), ('5', 'News Feed', ''), ('6', 'Web Link', '');
CREATE TABLE `#__k2_attachments` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `itemID` int(11) NOT NULL,   `filename` varchar(255) NOT NULL,   `title` varchar(255) NOT NULL,   `titleAttribute` text NOT NULL,   `hits` int(11) NOT NULL,   PRIMARY KEY (`id`),   KEY `itemID` (`itemID`) ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_attachments`  VALUES ('2', '96', 'sample.txt', 'Some document', 'sample.txt', '3840');
CREATE TABLE `#__k2_categories` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `description` text NOT NULL,   `parent` int(11) DEFAULT '0',   `extraFieldsGroup` int(11) NOT NULL,   `published` smallint(6) NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `image` varchar(255) NOT NULL,   `params` text NOT NULL,   `trash` smallint(6) NOT NULL DEFAULT '0',   `plugins` text NOT NULL,   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `category` (`published`,`access`,`trash`),   KEY `parent` (`parent`),   KEY `ordering` (`ordering`),   KEY `published` (`published`),   KEY `access` (`access`),   KEY `trash` (`trash`),   KEY `language` (`language`) ) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_categories`  VALUES ('1', 'Categories', 'categories', '<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. </p>', '0', '0', '1', '1', '1', '', '{\"inheritFrom\":\"0\",\"theme\":\"frontpage\",\"num_leading_items\":\"1\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Small\",\"num_secondary_items\":\"2\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"none\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"rdate\",\"catPagination\":\"0\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"225\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"45\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('2', 'Automotive', 'automotive', '', '1', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('3', 'Business', 'business', '', '1', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('5', 'Design', 'design', '', '1', '0', '1', '1', '4', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('6', 'Entertainment', 'entertainment', '', '1', '0', '1', '1', '5', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('9', 'Sports', 'sports', '', '1', '0', '1', '1', '6', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('11', 'Technology', 'technology', '', '1', '0', '1', '1', '7', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('13', 'World News', 'world-news', '', '3', '1', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('14', 'Catalogue', 'catalogue', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris hendrerit justo a massa dapibus a vehicula tellus suscipit. Maecenas non elementum diam. Cras velit urna, tristique id pretium in, mollis ut lorem. Nullam laoreet lacus purus, at ornare sem. Praesent ut scelerisque urna. Mauris lacinia felis eu neque vehicula nec malesuada arcu aliquam. Nullam eget lectus magna, id tincidunt purus. Morbi rutrum enim id velit elementum ornare. Suspendisse potenti.</p>', '0', '1', '1', '1', '2', '14.png', '{\"inheritFrom\":\"21\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"1\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('17', 'Women\'s Collection', 'women-s-collection', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris hendrerit justo a massa dapibus a vehicula tellus suscipit. Maecenas non elementum diam.</p>', '14', '1', '1', '1', '2', '17.jpeg', '{\"inheritFrom\":\"22\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('18', 'Men\'s Collection', 'men-s-collection', '<p>Cras velit urna, tristique id pretium in, mollis ut lorem. Nullam laoreet lacus purus, at ornare sem. Praesent ut scelerisque urna. Mauris lacinia felis.</p>', '14', '1', '1', '1', '3', '18.png', '{\"inheritFrom\":\"22\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('19', 'Default Parent Category Style', 'default-parent-category-style', '', '0', '0', '1', '1', '5', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('20', 'Default Item Listings', 'default-item-listings', '', '0', '0', '1', '1', '7', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"none\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"rdate\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"660\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"1\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"35\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('21', 'Default Catalog  Parent', 'default-catalog-parent', '', '0', '0', '1', '1', '6', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"1\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"3\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('22', 'Default Catalog Listing', 'default-catalog-listing', '', '0', '0', '1', '1', '8', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"2\",\"num_secondary_columns\":\"2\",\"secondaryImgSize\":\"Medium\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"none\",\"catCatalogMode\":\"1\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"20\",\"catItemExtraFields\":\"1\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('23', 'Blog', 'blog', '', '0', '0', '1', '1', '3', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"8\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"40\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('24', 'Kids Collection', 'woman-collection', '<p>Mauris lacinia felis eu neque vehicula nec malesuada arcu aliquam. Nullam eget lectus magna, id tincidunt purus. Morbi rutrum enim id velit elementum ornare.</p>', '14', '1', '1', '1', '4', '24.jpeg', '{\"inheritFrom\":\"22\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('43', 'Demo site', 'demo-site', '', '0', '0', '1', '1', '4', '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"none\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"0\",\"catItemDateCreated\":\"0\",\"catItemRating\":\"0\",\"catItemImage\":\"0\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"0\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"0\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"0\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"0\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"0\",\"itemImage\":\"0\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"0\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"0\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"0\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('26', 'Football', 'football', '', '9', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('27', 'Tennis', 'tennis', '', '9', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('28', 'Basket', 'basket', '', '9', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('29', 'Live Music', 'live-music', '', '6', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('30', 'Cinema', 'cinema', '', '6', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('31', 'Night Out', 'night-out', '', '6', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('32', 'Architecture', 'architecture', '', '5', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('33', 'Interior Design', 'interior-design', '', '5', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('34', 'Objects', 'objects', '', '5', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('35', 'Computers', 'computers', '', '11', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('36', 'Smartphones', 'smartphones', '', '11', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('38', 'Financial', 'financial', '', '3', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('39', 'Opinion', 'opinion', '', '3', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('40', 'Sports Cars', 'sports-cars', '', '2', '0', '1', '1', '1', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('41', 'Collection', 'collection', '', '2', '0', '1', '1', '2', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('42', 'Bikes', 'bikes', '', '2', '0', '1', '1', '3', '', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*'), ('44', 'Open Source', 'open-source', '', '11', '2', '1', '1', '4', '44.jpg', '{\"inheritFrom\":\"20\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', '0', '', '*');
CREATE TABLE `#__k2_comments` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `itemID` int(11) NOT NULL,   `userID` int(11) NOT NULL,   `userName` varchar(255) NOT NULL,   `commentDate` datetime NOT NULL,   `commentText` text NOT NULL,   `commentEmail` varchar(255) NOT NULL,   `commentURL` varchar(255) NOT NULL,   `published` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `itemID` (`itemID`),   KEY `userID` (`userID`),   KEY `published` (`published`),   KEY `latestComments` (`published`,`commentDate`) ) ENGINE=MyISAM AUTO_INCREMENT=438 DEFAULT CHARSET=utf8;
CREATE TABLE `#__k2_extra_fields` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   `value` text NOT NULL,   `type` varchar(255) NOT NULL,   `group` int(11) NOT NULL,   `published` tinyint(4) NOT NULL,   `ordering` int(11) NOT NULL,   PRIMARY KEY (`id`),   KEY `group` (`group`),   KEY `published` (`published`),   KEY `ordering` (`ordering`) ) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_extra_fields`  VALUES ('1', 'Color', '[{\"name\":null,\"value\":\"\",\"target\":null}]', 'textfield', '1', '1', '1'), ('2', 'Size', '[{\"name\":null,\"value\":\"\",\"target\":null}]', 'textfield', '1', '1', '2'), ('3', 'Price', '[{\"name\":null,\"value\":\"\",\"target\":null}]', 'textfield', '1', '1', '3'), ('4', 'Publisher', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"\",\"required\":0,\"showNull\":0}]', 'textfield', '2', '1', '1'), ('5', 'Source', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"\",\"required\":0,\"showNull\":0}]', 'textfield', '2', '1', '2'), ('6', 'Version', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"\",\"required\":0,\"showNull\":0}]', 'textfield', '2', '1', '3'), ('7', 'Status', '[{\"name\":null,\"value\":\"\",\"target\":null,\"alias\":\"\",\"required\":0,\"showNull\":0}]', 'textfield', '2', '1', '4');
CREATE TABLE `#__k2_extra_fields_groups` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_extra_fields_groups`  VALUES ('1', 'variations'), ('2', 'More Information');
CREATE TABLE `#__k2_items` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) DEFAULT NULL,   `catid` int(11) NOT NULL,   `published` smallint(6) NOT NULL DEFAULT '0',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `video` text,   `gallery` varchar(255) DEFAULT NULL,   `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,   `extra_fields_search` text NOT NULL,   `created` datetime NOT NULL,   `created_by` int(11) NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL,   `checked_out` int(10) unsigned NOT NULL,   `checked_out_time` datetime NOT NULL,   `modified` datetime NOT NULL,   `modified_by` int(11) NOT NULL DEFAULT '0',   `publish_up` datetime NOT NULL,   `publish_down` datetime NOT NULL,   `trash` smallint(6) NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `featured` smallint(6) NOT NULL DEFAULT '0',   `featured_ordering` int(11) NOT NULL DEFAULT '0',   `image_caption` text NOT NULL,   `image_credits` varchar(255) NOT NULL,   `video_caption` text NOT NULL,   `video_credits` varchar(255) NOT NULL,   `hits` int(10) unsigned NOT NULL,   `params` text NOT NULL,   `metadesc` text NOT NULL,   `metadata` text NOT NULL,   `metakey` text NOT NULL,   `plugins` text NOT NULL,   `language` char(7) NOT NULL,   PRIMARY KEY (`id`),   KEY `item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),   KEY `catid` (`catid`),   KEY `created_by` (`created_by`),   KEY `ordering` (`ordering`),   KEY `featured` (`featured`),   KEY `featured_ordering` (`featured_ordering`),   KEY `hits` (`hits`),   KEY `created` (`created`),   KEY `language` (`language`),   FULLTEXT KEY `search` (`title`,`introtext`,`fulltext`,`extra_fields_search`,`image_caption`,`image_credits`,`video_caption`,`video_credits`,`metadesc`,`metakey`),   FULLTEXT KEY `title` (`title`) ) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=utf8;
INSERT INTO `#__k2_items`  VALUES ('1', 'Mauris ac dolor id sapien aliquet dignissim', 'mauris-ac-dolor-id-sapien-aliquet-dignissim', '2', '1', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam dictum metus non erat gravida laoreet. Nulla facilisi. Phasellus sit amet cursus arcu. Aenean sem justo, pellentesque in fringilla et, porta in arcu.</p>\r\n', '\r\n<p>Praesent luctus ligula dapibus quam scelerisque tristique. Pellentesque tempus lorem quam, quis vestibulum erat. Nullam libero sapien, ornare ut auctor quis, dictum id dolor.</p>\r\n<p>Proin nibh tellus, mattis ac interdum ac, adipiscing vel ipsum. Phasellus nulla turpis, lobortis quis rhoncus eu, cursus a orci. Donec malesuada sodales commodo. Pellentesque molestie accumsan leo, et aliquet metus blandit at. Nam luctus tempor nisl, et porta purus feugiat nec. Donec semper turpis sit amet lectus faucibus tincidunt. Praesent facilisis justo vitae massa mollis euismod. Nunc vitae mi interdum justo semper aliquet. Vivamus imperdiet, neque eu luctus iaculis, dui magna ultrices odio, vitae posuere risus odio a quam. Maecenas ante erat, sollicitudin eu pharetra non, placerat vulputate sapien. Sed elementum nunc non purus pulvinar accumsan. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam pharetra lacus id tellus suscipit sed pellentesque massa elementum. Ut sodales faucibus adipiscing. Donec pretium leo ut lectus commodo vitae rutrum leo ornare.</p>\r\n<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>', NULL, NULL, '[]', '', '2011-11-08 13:43:26', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 13:43:26', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '637', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('2', 'Proin vitae augue vel nisi', 'proin-vitae-augue-vel-nisi', '2', '1', '<p>Proin nibh tellus, mattis ac interdum ac, adipiscing vel ipsum. Phasellus nulla turpis, lobortis quis rhoncus eu, cursus a orci. Donec malesuada sodales commodo. Pellentesque molestie accumsan leo, et aliquet metus blandit at.</p>\r\n', '\r\n<p>Nam luctus tempor nisl, et porta purus feugiat nec. Donec semper turpis sit amet lectus faucibus tincidunt. Praesent facilisis justo vitae massa mollis euismod. Nunc vitae mi interdum justo semper aliquet. Vivamus imperdiet, neque eu luctus iaculis, dui magna ultrices odio, vitae posuere risus odio a quam. Maecenas ante erat, sollicitudin eu pharetra non, placerat vulputate sapien. Sed elementum nunc non purus pulvinar accumsan. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam pharetra lacus id tellus suscipit sed pellentesque massa elementum. Ut sodales faucibus adipiscing. Donec pretium leo ut lectus commodo vitae rutrum leo ornare.</p>\r\n<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>\r\n<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus. Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>', NULL, NULL, '[]', '', '2011-11-08 14:07:40', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:07:40', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '3988', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('3', 'Pellentesque adipiscing nisi quis', 'pellentesque-adipiscing-nisi-quis', '2', '1', '<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>\r\n<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus. Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>\r\n<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa. Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>', NULL, NULL, '[]', '', '2011-11-08 14:08:27', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:08:27', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '714', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('4', 'Fusce massa sem, venenatis sed', 'fusce-massa-sem-venenatis-sed', '2', '1', '<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus.</p>\r\n', '\r\n<p>Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>\r\n<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa. Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>\r\n<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas. Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>', NULL, NULL, '[]', '', '2011-11-08 14:09:09', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:09:09', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '413', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('5', 'Praesent luctus volutpat dui', 'praesent-luctus-volutpat-dui', '2', '1', '<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa.</p>\r\n', '\r\n<p>Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>\r\n<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas. Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>\r\n<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus. Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>', NULL, NULL, '[]', '', '2011-11-08 14:10:41', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:10:41', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '425', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('6', 'In hac habitasse platea dictumst', 'in-hac-habitasse-platea-dictumst', '2', '1', '<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas.</p>\r\n', '\r\n<p>Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>\r\n<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus. Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>\r\n<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra. Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>', NULL, NULL, '[]', '', '2011-11-08 14:11:45', '43', '', '0', '0000-00-00 00:00:00', '2011-11-08 14:16:23', '43', '2011-11-08 14:11:45', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '293', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('7', 'Cras tincidunt ante et mi eleifend sollicitudin', 'cras-tincidunt-ante-et-mi-eleifend-sollicitudin', '2', '1', '<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus.</p>\r\n', '\r\n<p>Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>\r\n<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra. Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>\r\n<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla. Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>', NULL, NULL, '[]', '', '2011-11-08 14:12:39', '43', '', '0', '0000-00-00 00:00:00', '2011-11-08 14:16:46', '43', '2011-11-08 14:12:39', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '272', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('8', 'Vestibulum bibendum blandit augue', 'vestibulum-bibendum-blandit-augue', '2', '1', '<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra.</p>\r\n', '\r\n<p>Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>\r\n<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla. Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>\r\n<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus. Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p> </p>', '{vimeo}3741976{/vimeo}', '{gallery}http://www.flickr.com/photos/audiusa/sets/72157624537648429/{/gallery}', '[]', '', '2011-11-08 14:13:20', '43', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:53:57', '43', '2011-11-08 14:13:20', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '547', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('9', 'Donec suscipit purus eget turpis laoreet ornare', 'donec-suscipit-purus-eget-turpis-laoreet-ornare', '3', '1', '<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla.</p>\r\n', '\r\n<p>Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>\r\n<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus. Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus. Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>', '{vimeo}9011666{/vimeo}', '{gallery}http://www.flickr.com/photos/worldeconomicforum/sets/72157603708578538/{/gallery}', '[]', '', '2011-11-08 14:14:14', '43', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:54:46', '43', '2011-11-08 14:14:14', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '397', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('10', 'Quisque est est, porttitor a scelerisque vitae', 'quisque-est-est-porttitor-a-scelerisque-vitae', '3', '1', '<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus.</p>\r\n', '\r\n<p>Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus. Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>\r\n<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus. Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>', NULL, NULL, '[]', '', '2011-11-08 15:43:06', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:43:06', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '397', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('11', 'Duis malesuada metus pellentesque', 'duis-malesuada-metus-pellentesque', '3', '1', '<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus.</p>\r\n', '\r\n<p>Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>\r\n<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus. Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>\r\n<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi. Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>', NULL, NULL, '[]', '', '2011-11-08 15:43:56', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:43:56', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '419', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('12', 'Curabitur pulvinar mollis lectus', 'curabitur-pulvinar-mollis-lectus', '3', '1', '<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus.</p>\r\n', '\r\n<p>Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>\r\n<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi. Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>\r\n<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor. Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>', NULL, NULL, '[]', '', '2011-11-08 15:44:40', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:44:40', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '531', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('13', 'Nam est nisl, elementum et vulputate id', 'nam-est-nisl-elementum-et-vulputate-id', '3', '1', '<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi.</p>\r\n', '\r\n<p>Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>\r\n<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor. Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>\r\n<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>', NULL, NULL, '[]', '', '2011-11-08 15:45:16', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:45:16', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '529', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('14', 'Mauris congue convallis placerat', 'mauris-congue-convallis-placerat', '3', '1', '<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor.</p>\r\n', '\r\n<p>Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>\r\n<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>\r\n<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque. Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>', NULL, NULL, '[]', '', '2011-11-08 15:46:36', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:46:36', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '475', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('15', 'Nullam a ante leo, at iaculis lectus', 'nullam-a-ante-leo-at-iaculis-lectus', '3', '1', '<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque. Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>\r\n<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>', NULL, NULL, '[]', '', '2011-11-08 15:47:19', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:47:19', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '404', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('16', 'Donec id purus vitae massa', 'donec-id-purus-vitae-massa', '3', '1', '<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque.</p>\r\n', '\r\n<p>Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>\r\n<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>\r\n<p>Duis lobortis aliquet sem vitae suscipit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut tristique nulla ac quam scelerisque a egestas erat placerat. Vestibulum erat erat, dictum vel molestie eu, pretium sit amet ante. Cras volutpat placerat leo eu lobortis. Aenean pharetra, eros pretium scelerisque viverra, velit est iaculis massa, ac viverra turpis tortor ut leo. Aenean rhoncus est et nisl faucibus sed sodales elit iaculis. Cras congue leo et ante elementum sit amet rhoncus turpis tincidunt.</p>', NULL, NULL, '[]', '', '2011-11-08 15:48:30', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:48:30', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '521', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('17', 'Duis et lectus non ante elementum', 'duis-et-lectus-non-ante-elementum', '40', '1', '<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Duis lobortis aliquet sem vitae suscipit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut tristique nulla ac quam scelerisque a egestas erat placerat. Vestibulum erat erat, dictum vel molestie eu, pretium sit amet ante. Cras volutpat placerat leo eu lobortis. Aenean pharetra, eros pretium scelerisque viverra, velit est iaculis massa, ac viverra turpis tortor ut leo. Aenean rhoncus est et nisl faucibus sed sodales elit iaculis. Cras congue leo et ante elementum sit amet rhoncus turpis tincidunt.</p>\r\n<p>Integer ultrices velit ligula, vel interdum massa. Integer ullamcorper nunc eu mi mattis suscipit. Integer tempus nisl nec elit rhoncus vehicula. Praesent sem mi, scelerisque vitae blandit sit amet, mattis eget nisi. Proin blandit ultricies magna, id tincidunt est faucibus at. Vestibulum in nisl nisl. Vivamus vulputate enim vitae nunc ultrices pulvinar. Duis vel libero et enim ultricies vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque et iaculis tellus.</p>\r\n<p>Suspendisse euismod nisi vitae odio pellentesque aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Maecenas posuere accumsan rhoncus. Integer lobortis enim non arcu ultricies accumsan. Nulla nec libero non ipsum vulputate tincidunt. Aliquam ullamcorper ullamcorper mi id posuere. Duis porttitor, nunc ac tincidunt consectetur, neque urna laoreet tortor, rutrum consectetur urna metus at justo. Morbi sit amet urna vel est fringilla tristique non quis lectus. Duis et lectus non ante elementum tincidunt eu in mi. Proin velit lacus, tempus nec molestie quis, iaculis sit amet neque. </p>', NULL, NULL, '[]', '', '2011-11-08 16:21:58', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:21:58', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '688', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('18', 'Nunc feugiat viverra lorem quis tincidunt', 'nunc-feugiat-viverra-lorem-quis-tincidunt', '40', '1', '<p>Suspendisse euismod nisi vitae odio pellentesque aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Maecenas posuere accumsan rhoncus. Integer lobortis enim non arcu ultricies accumsan. Nulla nec libero non ipsum vulputate tincidunt. Aliquam ullamcorper ullamcorper mi id posuere.</p>\r\n', '\r\n<p>Duis porttitor, nunc ac tincidunt consectetur, neque urna laoreet tortor, rutrum consectetur urna metus at justo. Morbi sit amet urna vel est fringilla tristique non quis lectus. Duis et lectus non ante elementum tincidunt eu in mi. Proin velit lacus, tempus nec molestie quis, iaculis sit amet neque. Vestibulum dapibus sodales nisl non tincidunt. Donec felis purus, vehicula vitae euismod vitae, porttitor quis nisi. Phasellus faucibus consequat lorem eget interdum. Fusce ullamcorper placerat est, in pharetra diam cursus et. Sed nec risus et sapien rutrum pulvinar ac et mi.</p>\r\n<p>Suspendisse potenti. Pellentesque pulvinar pharetra mi quis elementum. Proin vulputate tempor convallis. Morbi aliquet diam id mauris tempus mollis. Nullam arcu nulla, porttitor non sodales in, auctor sed tellus. Donec varius hendrerit dolor, vitae vestibulum mauris mattis eu. Nunc vel sapien leo. Maecenas ac nunc nulla, quis faucibus eros. Sed est eros, ullamcorper sit amet viverra ac, facilisis et dolor. Nam est felis, dapibus vitae dapibus at, elementum a lectus. Cras dapibus, augue non lacinia euismod, elit massa mollis sapien, at porta arcu urna vitae tortor. Nunc feugiat viverra lorem quis tincidunt. Maecenas condimentum dui a libero cursus luctus. Pellentesque varius neque felis, sit amet congue tortor. Aliquam erat volutpat. Aliquam ut risus nisl.</p>\r\n<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem. Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:23:07', '43', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:48:26', '43', '2011-11-08 16:23:07', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '530', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('19', 'Sed egestas purus quis dui fringilla mollis', 'sed-egestas-purus-quis-dui-fringilla-mollis', '40', '1', '<p>Suspendisse potenti. Pellentesque pulvinar pharetra mi quis elementum. Proin vulputate tempor convallis. Morbi aliquet diam id mauris tempus mollis. Nullam arcu nulla, porttitor non sodales in, auctor sed tellus. Donec varius hendrerit dolor, vitae vestibulum mauris mattis eu. Nunc vel sapien leo.</p>\r\n', '\r\n<p>Maecenas ac nunc nulla, quis faucibus eros. Sed est eros, ullamcorper sit amet viverra ac, facilisis et dolor. Nam est felis, dapibus vitae dapibus at, elementum a lectus. Cras dapibus, augue non lacinia euismod, elit massa mollis sapien, at porta arcu urna vitae tortor. Nunc feugiat viverra lorem quis tincidunt. Maecenas condimentum dui a libero cursus luctus. Pellentesque varius neque felis, sit amet congue tortor. Aliquam erat volutpat. Aliquam ut risus nisl.</p>\r\n<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem. Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>\r\n<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus. Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>', NULL, NULL, '[]', '', '2011-11-08 16:23:47', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:23:47', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '530', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('20', 'Duis condimentum lectus vel lacus', 'duis-condimentum-lectus-vel-lacus', '40', '1', '<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem.</p>\r\n', '\r\n<p>Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>\r\n<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus. Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>\r\n<p>Sed ac dolor nunc, at venenatis massa. Donec leo ligula, tincidunt vitae posuere eget, blandit vel nunc. Fusce sit amet nulla nec libero blandit aliquam in ac diam. Nunc at rhoncus massa. Suspendisse potenti. Pellentesque dignissim risus nec urna tristique iaculis. Maecenas commodo lorem eget nisi egestas a tincidunt enim hendrerit. Praesent varius sagittis dui, in tristique dui consectetur vitae. Cras id lectus massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. In convallis ipsum id nunc vestibulum blandit. Vestibulum in convallis leo.</p>', NULL, NULL, '[]', '', '2011-11-08 16:24:28', '43', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:49:03', '43', '2011-11-08 16:24:28', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '587', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('21', 'Donec eu sapien a lectus porta ultricies', 'donec-eu-sapien-a-lectus-porta-ultricies', '40', '1', '<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus.</p>\r\n', '\r\n<p>Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>\r\n<p>Sed ac dolor nunc, at venenatis massa. Donec leo ligula, tincidunt vitae posuere eget, blandit vel nunc. Fusce sit amet nulla nec libero blandit aliquam in ac diam. Nunc at rhoncus massa. Suspendisse potenti. Pellentesque dignissim risus nec urna tristique iaculis. Maecenas commodo lorem eget nisi egestas a tincidunt enim hendrerit. Praesent varius sagittis dui, in tristique dui consectetur vitae. Cras id lectus massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. In convallis ipsum id nunc vestibulum blandit. Vestibulum in convallis leo.</p>\r\n<p>Mauris quis massa id libero accumsan dignissim. Pellentesque enim diam, cursus nec condimentum a, placerat vitae ipsum. In hac habitasse platea dictumst. Duis lobortis luctus leo porta volutpat. Praesent risus est, scelerisque eget condimentum vel, malesuada ut leo. Nulla facilisi. Aliquam gravida, tellus eu cursus interdum, purus magna cursus lacus, eu vestibulum urna eros eu sapien. Vestibulum luctus vehicula ultricies. Ut nunc nunc, lobortis lobortis aliquam eu, consequat at tellus. Mauris sagittis elit quis enim cursus et interdum nibh imperdiet. Proin viverra lectus nec velit semper tristique. Morbi tempus ipsum sed nisi iaculis sed eleifend ipsum euismod. Nunc cursus commodo lacus, sit amet tristique arcu sollicitudin a.</p>\r\n<p>Nulla dolor lacus, consectetur sed malesuada in, fringilla sed lorem. Maecenas malesuada ornare lorem sed porttitor. Donec eu sapien a lectus porta ultricies. Pellentesque aliquet purus sed velit vulputate rhoncus vitae a lorem. Sed id ultrices massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse potenti.</p>', NULL, NULL, '[]', '', '2011-11-08 16:25:09', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:25:09', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '839', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('22', 'Maecenas viverra nisl gravida lectus rutrum laoreet', 'maecenas-viverra-nisl-gravida-lectus-rutrum-laoreet', '40', '1', '<p>Nulla dolor lacus, consectetur sed malesuada in, fringilla sed lorem. Maecenas malesuada ornare lorem sed porttitor. Donec eu sapien a lectus porta ultricies. Pellentesque aliquet purus sed velit vulputate rhoncus vitae a lorem. Sed id ultrices massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse potenti.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Cras sed facilisis quam. Nunc nisl nisl, scelerisque sit amet fermentum ut, hendrerit laoreet nisl. Integer quis dolor odio, in scelerisque nibh. Phasellus rutrum, elit a fringilla gravida, leo nunc congue ante, et mollis lorem mauris in enim. Ut laoreet tempor scelerisque. Nam lobortis nulla non nisi lacinia rutrum et vel enim. Vivamus sed sagittis nibh.</p>\r\n<p>Curabitur quis ipsum sapien. Mauris gravida nisi non tellus mollis sit amet iaculis erat fringilla. Phasellus vulputate orci eu nunc dictum eu elementum est fermentum. Phasellus non vulputate lorem. In in ultrices leo. Maecenas sit amet nisl metus, pellentesque iaculis tortor. Nam tristique hendrerit convallis. Aenean dolor diam, tristique quis tristique vitae, sollicitudin in velit. Aliquam tempor, lectus vitae aliquam interdum, libero justo posuere eros, nec euismod dolor neque quis leo. Sed magna massa, pellentesque sollicitudin malesuada et, mollis sed orci. Pellentesque euismod faucibus est, ac rhoncus lorem laoreet nec. In et urna et nulla tincidunt eleifend a at augue. Vestibulum sit amet accumsan nisi.</p>\r\n<p>Suspendisse nec urna vitae nisl posuere interdum. Donec id velit sit amet turpis egestas tempor. Maecenas viverra nisl gravida lectus rutrum laoreet. Suspendisse quis vulputate ipsum. Nullam magna magna, molestie a venenatis eget, blandit in purus. Donec porta orci sed leo dapibus ac scelerisque eros pretium. Praesent at tristique sem. Maecenas vitae odio turpis. Nam tempus erat vitae nunc commodo non accumsan tellus dapibus. Donec sit amet nisl et nulla condimentum porta id at libero. Etiam id orci quis magna lobortis suscipit. Quisque placerat tristique adipiscing. Nulla facilisi. Quisque ullamcorper dolor nec lacus consectetur pharetra. Cras at magna nec turpis tempus lacinia.</p>', NULL, NULL, '[]', '', '2011-11-08 16:26:02', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:26:02', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '962', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('23', 'Suspendisse sem tortor', 'suspendisse-sem-tortor', '40', '1', '<p>Suspendisse nec urna vitae nisl posuere interdum. Donec id velit sit amet turpis egestas tempor. Maecenas viverra nisl gravida lectus rutrum laoreet. Suspendisse quis vulputate ipsum. Nullam magna magna, molestie a venenatis eget, blandit in purus. Donec porta orci sed leo dapibus ac scelerisque eros pretium.</p>\r\n', '\r\n<p>Praesent at tristique sem. Maecenas vitae odio turpis. Nam tempus erat vitae nunc commodo non accumsan tellus dapibus. Donec sit amet nisl et nulla condimentum porta id at libero. Etiam id orci quis magna lobortis suscipit. Quisque placerat tristique adipiscing. Nulla facilisi. Quisque ullamcorper dolor nec lacus consectetur pharetra. Cras at magna nec turpis tempus lacinia.</p>\r\n<p>Donec scelerisque, mauris eu luctus condimentum, neque leo venenatis lectus, sit amet dictum massa nulla vel sem. Suspendisse porttitor, eros in semper semper, massa felis mattis nulla, quis sodales nulla nisi in risus. Aliquam bibendum, massa vel molestie accumsan, est lorem varius turpis, sit amet tincidunt tortor augue vel nulla. Donec sit amet purus justo, at bibendum erat. Vestibulum massa dui, scelerisque eu auctor at, blandit sit amet ligula. Nam gravida tristique lorem, sed egestas ante tempus ut. Donec quis facilisis felis. Fusce velit lacus, porttitor vitae faucibus eu, tristique at diam. Aenean velit nisl, dictum at scelerisque at, interdum eu tortor. Vestibulum feugiat elit mi. Donec ac turpis enim.</p>\r\n<p>Maecenas vitae tortor eget justo mattis luctus vel auctor nunc. Fusce adipiscing dui mattis est rhoncus tempus. Nam eget malesuada nisi. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean interdum, diam in dapibus molestie, mauris ante rhoncus arcu, ac adipiscing sapien tortor ut ante. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus eget arcu eget est ornare convallis et id dui. Nulla ultrices fringilla lorem, id ultricies odio porttitor nec. Vivamus id neque magna, mollis porta metus. Suspendisse sem tortor, sagittis sit amet euismod at, ultrices posuere odio. Integer vulputate nisi purus, tempus consectetur nisi. Etiam ac nulla nec elit interdum hendrerit id vitae nunc. Proin feugiat nisi bibendum nibh ultricies malesuada. Nullam porta suscipit mollis. Pellentesque porta iaculis nisl sed tincidunt.</p>', NULL, NULL, '[]', '', '2011-11-08 16:26:41', '43', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:49:28', '43', '2011-11-08 16:26:41', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '1037', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('24', 'Ut risus ipsum, pulvinar sed pretium quis', 'ut-risus-ipsum-pulvinar-sed-pretium-quis', '40', '1', '<p>Maecenas vitae tortor eget justo mattis luctus vel auctor nunc. Fusce adipiscing dui mattis est rhoncus tempus. Nam eget malesuada nisi. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean interdum, diam in dapibus molestie, mauris ante rhoncus arcu, ac adipiscing sapien tortor ut ante.</p>\r\n', '\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus eget arcu eget est ornare convallis et id dui. Nulla ultrices fringilla lorem, id ultricies odio porttitor nec. Vivamus id neque magna, mollis porta metus. Suspendisse sem tortor, sagittis sit amet euismod at, ultrices posuere odio. Integer vulputate nisi purus, tempus consectetur nisi. Etiam ac nulla nec elit interdum hendrerit id vitae nunc. Proin feugiat nisi bibendum nibh ultricies malesuada. Nullam porta suscipit mollis. Pellentesque porta iaculis nisl sed tincidunt.</p>\r\n<p>Curabitur sollicitudin nisi vel nulla lobortis eu bibendum sapien vestibulum. Donec laoreet viverra ligula non porta. Maecenas hendrerit velit sit amet felis rutrum ut pretium massa vestibulum. Phasellus tincidunt velit sed ligula vehicula ac placerat orci feugiat. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc et orci quis est ornare auctor eget vitae nulla. Vestibulum ornare magna ut orci imperdiet porttitor. Phasellus eu lobortis neque.</p>\r\n<p>Proin eleifend posuere neque in hendrerit. Donec tempus felis in nulla rutrum vitae elementum mauris mattis. Maecenas a leo sit amet nisl ornare vulputate et a magna. Aliquam erat volutpat. Sed accumsan purus ac arcu luctus bibendum. Suspendisse potenti. Aliquam aliquam semper metus, eu tristique libero rutrum a. Ut risus ipsum, pulvinar sed pretium quis, sodales ac augue. Cras est metus, bibendum ut ultrices sit amet, tempor quis nisl. Praesent ultricies sagittis nulla eget lacinia.</p>\r\n<p>Suspendisse vitae mauris sit amet sem tristique ornare a vel odio. Sed eu ultricies ante. Fusce tincidunt tortor a turpis iaculis a tincidunt neque facilisis. Nam bibendum odio vitae massa ornare commodo. Nullam vitae nisl orci. Nulla a elit augue. Cras eget dolor tortor, eget lacinia sapien. Sed sodales nisl in mauris malesuada sed vulputate justo consectetur.</p>', '{vimeo}8546368{/vimeo}', '{gallery}http://www.flickr.com/photos/oregonballettheatre/sets/72157625963314632/with/6264619429/{/gallery}', '[]', '', '2011-11-08 16:27:24', '43', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:55:21', '43', '2011-11-08 16:27:24', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '1248', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('25', 'Morbi adipiscing sapien non tellus', 'morbi-adipiscing-sapien-non-tellus', '5', '1', '<p>Proin eleifend posuere neque in hendrerit. Donec tempus felis in nulla rutrum vitae elementum mauris mattis. Maecenas a leo sit amet nisl ornare vulputate et a magna. Aliquam erat volutpat. Sed accumsan purus ac arcu luctus bibendum.</p>\r\n', '\r\n<p>Suspendisse potenti. Aliquam aliquam semper metus, eu tristique libero rutrum a. Ut risus ipsum, pulvinar sed pretium quis, sodales ac augue. Cras est metus, bibendum ut ultrices sit amet, tempor quis nisl. Praesent ultricies sagittis nulla eget lacinia.</p>\r\n<p>Suspendisse vitae mauris sit amet sem tristique ornare a vel odio. Sed eu ultricies ante. Fusce tincidunt tortor a turpis iaculis a tincidunt neque facilisis. Nam bibendum odio vitae massa ornare commodo. Nullam vitae nisl orci. Nulla a elit augue. Cras eget dolor tortor, eget lacinia sapien. Sed sodales nisl in mauris malesuada sed vulputate justo consectetur. Vestibulum placerat sem eu libero pretium faucibus. Fusce leo augue, rutrum mattis volutpat at, lobortis nec nunc. Sed velit mauris, ultricies vehicula feugiat in, feugiat et massa. Pellentesque vel est non elit hendrerit pharetra ut ut quam. Suspendisse vel metus non lectus ornare suscipit. Suspendisse potenti.</p>\r\n<p>Maecenas id ante diam, nec consectetur augue. Donec tempor sollicitudin felis sed tincidunt. Mauris sollicitudin ligula lacinia mauris dignissim malesuada. Nullam nibh risus, molestie et suscipit non, bibendum eget ipsum. Morbi mi risus, molestie ut semper vel, aliquam sit amet augue. Curabitur turpis orci, luctus sit amet sagittis vel, lacinia et tellus. Morbi adipiscing sapien non tellus facilisis eget fermentum mauris consequat. Nam id ante urna, sit amet eleifend arcu. Pellentesque et magna vel lacus congue convallis at vitae purus. Duis est metus, lacinia ut posuere et, suscipit quis elit. In gravida aliquet magna sit amet cursus. Etiam et neque eget neque gravida malesuada commodo a nunc. Aenean mollis, tellus a tempus feugiat, sem lacus ornare sem, vel mattis neque diam id mauris.</p>', NULL, NULL, '[]', '', '2011-11-08 16:28:16', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:19', '45', '2011-11-08 16:28:16', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '440', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('26', 'Quisque vel lacinia urna', 'quisque-vel-lacinia-urna', '5', '1', '<p>Curabitur quis libero leo, pharetra mattis eros. Praesent consequat libero eget dolor convallis vel rhoncus magna scelerisque. Donec nisl ante, elementum eget posuere a, consectetur a metus. Proin a adipiscing sapien. Suspendisse vehicula porta lectus vel semper. Nullam sapien elit, lacinia eu tristique non, posuere at mi. Morbi at turpis id urna ullamcorper ullamcorper.</p>\r\n', '\r\n<p> </p>\r\n<p>Mauris interdum molestie felis in accumsan. Pellentesque in est felis, a eleifend diam. Mauris dolor augue, ultrices eu adipiscing nec, molestie vel massa. Proin ultricies diam ac orci tincidunt at hendrerit ipsum malesuada. Integer placerat, mauris ultrices elementum aliquam, felis quam ultrices libero, ac porttitor mauris eros eget orci. Suspendisse porttitor placerat sapien, nec consequat dui eleifend non. Pellentesque ultricies lectus quis enim tristique congue. Morbi sed ante elit. Proin diam mi, vestibulum vel eleifend nec, aliquet id massa. Phasellus quis turpis tortor, eu congue sem. Suspendisse congue faucibus neque, vitae cursus dui consectetur eu. Praesent quis turpis a metus elementum mollis eu et tortor. Donec lobortis nisl vel urna convallis tincidunt. Nunc ut arcu sem, sed elementum velit.</p>\r\n<p>Mauris id tortor magna, consequat bibendum quam. Aliquam viverra, velit vitae iaculis ullamcorper, ante est euismod nisl, a auctor augue est id quam. Donec eget augue id lorem interdum pretium. Quisque vel lacinia urna. Donec dictum lorem est. Aliquam ante nulla, sodales in tincidunt quis, vulputate non magna. Aliquam erat volutpat. Maecenas pharetra luctus turpis, ut varius mi tincidunt in.</p>\r\n<p> </p>', NULL, NULL, '[]', '', '2011-11-08 16:29:07', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:00', '45', '2011-11-08 16:29:07', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '607', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('27', 'Quisque malesuada, libero in mollis pretium', 'quisque-malesuada-libero-in-mollis-pretium', '5', '1', '<p>Mauris id tortor magna, consequat bibendum quam. Aliquam viverra, velit vitae iaculis ullamcorper, ante est euismod nisl, a auctor augue est id quam. Donec eget augue id lorem interdum pretium. Quisque vel lacinia urna. Donec dictum lorem est. Aliquam ante nulla, sodales in tincidunt quis, vulputate non magna. Aliquam erat volutpat. Maecenas pharetra luctus turpis, ut varius mi tincidunt in.</p>\r\n', '\r\n<p> </p>\r\n<p>Nulla interdum tristique justo sit amet tincidunt. Vestibulum adipiscing auctor nisl, quis feugiat magna molestie id. In tincidunt consequat libero sit amet ornare. In et consectetur nibh. Curabitur libero justo, laoreet vitae sagittis sit amet, pulvinar vitae elit. Vestibulum gravida, risus non gravida suscipit, lorem lectus vestibulum velit, a tincidunt diam urna non mi. Integer ac lectus et urna fringilla blandit. Phasellus congue massa non felis vestibulum feugiat. In lobortis placerat interdum. Nam dapibus libero vel elit suscipit a semper lacus tempor. Duis vehicula vulputate rhoncus. Aenean feugiat sollicitudin sapien, non semper erat vehicula ut. Suspendisse a felis nunc. Suspendisse tristique iaculis ligula in porttitor. Proin diam ipsum, auctor ac mollis sollicitudin, ultrices ut lacus.</p>\r\n<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper. Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:37:06', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:45', '45', '2011-11-08 16:37:06', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '489', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('28', 'Donec a imperdiet lorem', 'donec-a-imperdiet-lorem', '5', '1', '<p>Nulla interdum tristique justo sit amet tincidunt. Vestibulum adipiscing auctor nisl, quis feugiat magna molestie id. In tincidunt consequat libero sit amet ornare. In et consectetur nibh. Curabitur libero justo, laoreet vitae sagittis sit amet, pulvinar vitae elit.</p>\r\n', '\r\n<p>Vestibulum gravida, risus non gravida suscipit, lorem lectus vestibulum velit, a tincidunt diam urna non mi. Integer ac lectus et urna fringilla blandit. Phasellus congue massa non felis vestibulum feugiat. In lobortis placerat interdum. Nam dapibus libero vel elit suscipit a semper lacus tempor. Duis vehicula vulputate rhoncus. Aenean feugiat sollicitudin sapien, non semper erat vehicula ut. Suspendisse a felis nunc. Suspendisse tristique iaculis ligula in porttitor. Proin diam ipsum, auctor ac mollis sollicitudin, ultrices ut lacus.</p>\r\n<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper. Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>\r\n<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>', NULL, NULL, '[]', '', '2011-11-08 16:37:55', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:46', '45', '2011-11-08 16:37:55', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '284', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('29', 'Vivamus tempor lobortis rutrum', 'vivamus-tempor-lobortis-rutrum', '5', '1', '<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper.</p>\r\n', '\r\n<p>Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>\r\n<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>\r\n<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus. Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>', NULL, NULL, '[]', '', '2011-11-08 16:38:43', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:36', '45', '2011-11-08 16:38:43', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '437', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('30', 'Mauris nisi sapien, sodales sed bibendum in', 'mauris-nisi-sapien-sodales-sed-bibendum-in', '5', '1', '<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus.</p>\r\n', '\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>\r\n<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus. Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>\r\n<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui. Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>', '{vimeo}6622363{/vimeo}', '{gallery}http://www.flickr.com/photos/chictip/sets/72157626210569395/with/5559842544/{/gallery}', '[]', '', '2011-11-08 16:39:26', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:14', '45', '2011-11-08 16:39:26', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '258', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('31', 'Curabitur vitae leo dui, ac malesuada arcu', 'curabitur-vitae-leo-dui-ac-malesuada-arcu', '5', '1', '<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus.</p>\r\n', '\r\n<p>Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>\r\n<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui. Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>\r\n<p>Sed ac metus nisl, vel fringilla lorem. Curabitur at nibh felis. Aenean facilisis posuere aliquet. Nullam lobortis, ligula id sollicitudin scelerisque, turpis leo imperdiet mauris, a placerat neque mauris quis nulla. In quis lacus ac nulla faucibus euismod non non dolor. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nulla suscipit fermentum purus, ut fringilla dui facilisis vitae. Proin consequat aliquam sapien, vitae porta nunc consectetur eget. Curabitur pulvinar dignissim volutpat. Aliquam lobortis, nisl ac tempus vulputate, sapien eros molestie arcu, vel porttitor urna eros nec eros. Sed iaculis libero nec purus accumsan sagittis.</p>', NULL, NULL, '[]', '', '2011-11-08 16:40:14', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:03', '45', '2011-11-08 16:40:14', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '469', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('32', 'Donec ut lorem sit amet eros', 'donec-ut-lorem-sit-amet-eros', '5', '1', '<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui.</p>\r\n', '\r\n<p>Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>\r\n<p>Sed ac metus nisl, vel fringilla lorem. Curabitur at nibh felis. Aenean facilisis posuere aliquet. Nullam lobortis, ligula id sollicitudin scelerisque, turpis leo imperdiet mauris, a placerat neque mauris quis nulla. In quis lacus ac nulla faucibus euismod non non dolor. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nulla suscipit fermentum purus, ut fringilla dui facilisis vitae. Proin consequat aliquam sapien, vitae porta nunc consectetur eget. Curabitur pulvinar dignissim volutpat. Aliquam lobortis, nisl ac tempus vulputate, sapien eros molestie arcu, vel porttitor urna eros nec eros. Sed iaculis libero nec purus accumsan sagittis.</p>\r\n<p>Mauris eget nibh et eros pellentesque posuere. Maecenas elementum, sem eget pharetra rhoncus, orci odio sodales sapien, pretium porta enim justo in diam. Sed pharetra nunc vel orci consectetur non varius odio elementum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi in lacus ante. Duis aliquet auctor erat at sagittis. Donec pulvinar, tortor vitae suscipit viverra, lacus sem dignissim metus, eget suscipit arcu lacus vitae quam. Aenean aliquam pharetra sapien et ullamcorper. Etiam viverra, quam in sodales volutpat, felis sem adipiscing velit, ac gravida dolor dolor non turpis.</p>\r\n<p>Nulla commodo mollis sagittis. Suspendisse non orci mauris, et dictum elit. Donec bibendum, quam nec fermentum adipiscing, arcu ligula dictum enim, vitae venenatis ipsum purus eu tellus. Aenean nec euismod nibh. Fusce convallis eros sed leo feugiat commodo. Sed accumsan facilisis rhoncus. Quisque leo mi, adipiscing at viverra at, iaculis et mi. Suspendisse potenti. Sed nec blandit risus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:41:01', '43', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:33:49', '45', '2011-11-08 16:41:01', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '445', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('33', 'Curabitur non erat diam', 'curabitur-non-erat-diam', '6', '1', '<p>Pellentesque consectetur, quam ut rhoncus rhoncus, massa neque gravida augue, eget imperdiet quam ligula vitae enim. Suspendisse ut neque ut nibh laoreet imperdiet. Nam id urna neque. Nam a turpis purus, ut scelerisque quam. In vulputate posuere odio, at ultrices nisl vestibulum elementum.</p>\r\n', '\r\n<p>Morbi diam sem, tincidunt quis laoreet sit amet, cursus ut quam. Ut ultricies eros ultrices neque convallis a ultricies felis consectetur. Fusce convallis felis magna, eu rutrum nulla. Phasellus ut viverra odio. Aenean at augue quis risus ultricies mollis lobortis nec felis. Vivamus vestibulum iaculis sollicitudin. Aliquam volutpat erat at dui ultricies dignissim. Praesent lacus metus, varius nec mollis non, luctus vitae nisl. Aliquam eu mauris suscipit urna dictum porttitor.</p>\r\n<p>Fusce arcu augue, mattis tincidunt egestas in, facilisis quis nisi. Nunc vel sem vitae nulla rhoncus dictum. Donec eleifend suscipit diam, at ornare ante elementum nec. Maecenas vel dolor ac dolor sodales feugiat. Nam pharetra, metus ut pellentesque lacinia, est est consequat sem, id cursus dolor nisi et orci. Duis tincidunt tincidunt volutpat. Vivamus malesuada mauris at felis mattis et fringilla mauris suscipit. In urna libero, rhoncus eget suscipit nec, egestas ac lectus. In hac habitasse platea dictumst. Maecenas sit amet est neque, vitae gravida ante.</p>\r\n<p>Aenean lobortis imperdiet tellus, imperdiet aliquam massa dictum nec. Aenean pulvinar sollicitudin magna sed facilisis. Curabitur non erat diam. Cras pretium dignissim fermentum. Ut bibendum lobortis mauris, ac imperdiet risus dictum eget. Nunc fringilla sem vel ligula mattis non iaculis mi vulputate. Duis sollicitudin fringilla hendrerit. Vivamus malesuada metus et nunc rhoncus euismod. Donec adipiscing sem fermentum augue ultricies dapibus. In tincidunt tempor tortor, in blandit eros ultricies eget.</p>', NULL, NULL, '[]', '', '2011-11-09 09:22:04', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:22:04', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '250', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('34', 'Mauris at dignissim ante', 'mauris-at-dignissim-ante', '6', '1', '<p>Aenean lobortis imperdiet tellus, imperdiet aliquam massa dictum nec. Aenean pulvinar sollicitudin magna sed facilisis. Curabitur non erat diam. Cras pretium dignissim fermentum. Ut bibendum lobortis mauris, ac imperdiet risus dictum eget.</p>\r\n', '\r\n<p>Nunc fringilla sem vel ligula mattis non iaculis mi vulputate. Duis sollicitudin fringilla hendrerit. Vivamus malesuada metus et nunc rhoncus euismod. Donec adipiscing sem fermentum augue ultricies dapibus. In tincidunt tempor tortor, in blandit eros ultricies eget.</p>\r\n<p>Mauris sem nulla, interdum ut dapibus sit amet, rhoncus eu arcu. Suspendisse ullamcorper mi ut lacus feugiat pellentesque. Nunc sed lacus tellus. Proin convallis blandit nisi at luctus. Donec est turpis, commodo et pharetra vel, lacinia eget mi. Vivamus vitae leo mi, sit amet ullamcorper massa. Ut non sem id ligula iaculis fringilla nec et nulla. Mauris commodo auctor eros eget vestibulum. Integer sit amet leo ultricies nunc dapibus accumsan. Suspendisse potenti. Donec non neque sapien. Curabitur mattis enim ut est eleifend ut egestas lectus adipiscing.</p>\r\n<p>Vestibulum ligula diam, cursus quis vulputate eu, tincidunt at lacus. Donec iaculis, neque eget pretium tempor, turpis tortor vehicula risus, vitae posuere orci lectus nec sapien. Praesent a nisi elit, sed pellentesque dolor. Mauris ac bibendum nisi. Donec imperdiet bibendum dignissim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus gravida neque sit amet diam suscipit ac mollis purus rutrum. Proin et arcu nec diam faucibus rutrum. Mauris at dignissim ante. Donec at purus vehicula est condimentum elementum. Pellentesque laoreet neque sed odio pretium in malesuada risus condimentum. Duis eu purus vitae est pretium blandit.</p>\r\n<p>Aenean ac orci a tortor ornare dapibus non a est. Sed faucibus condimentum rhoncus. Ut id velit magna. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse potenti. Nunc tincidunt felis eget sem congue varius. Vivamus pellentesque felis ac lacus tincidunt a ornare massa blandit.</p>', NULL, NULL, '[]', '', '2011-11-09 09:24:29', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:24:29', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '240', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('35', 'Integer volutpat euismod diam convallis auctor', 'integer-volutpat-euismod-diam-convallis-auctor', '6', '1', '<p>Donec tincidunt nisi et mauris dictum et mollis lectus tincidunt. Duis vitae est odio. Donec varius imperdiet risus, quis sodales lectus cursus a. Quisque laoreet tortor in turpis sollicitudin at posuere dolor consequat. Donec leo mauris, ultricies vitae tempus nec, tincidunt nec ipsum.</p>\r\n', '\r\n<p>Donec sapien felis, tincidunt at luctus sed, porta vitae leo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin massa est, porta in cursus vehicula, faucibus porta urna. Aliquam et mauris eleifend nibh facilisis scelerisque. Suspendisse et sollicitudin ipsum. Maecenas a bibendum urna. Proin consequat sapien quis lacus aliquet mollis. Cras sodales, orci eu luctus volutpat, felis augue condimentum ligula, ut pellentesque mi quam laoreet sapien. Sed ut nunc neque. Sed eu dolor porta sapien pulvinar tempus. Nullam nulla dolor, aliquet non rhoncus et, porttitor in quam.</p>\r\n<p>Duis eu lectus quis eros tristique consequat quis in metus. Mauris aliquam aliquam condimentum. Curabitur ultrices dui consequat lorem pellentesque placerat. Fusce elementum volutpat ultrices. Etiam molestie ultrices euismod. Morbi sollicitudin dapibus tristique. Ut faucibus posuere turpis at bibendum. Etiam bibendum commodo congue. Cras ullamcorper tincidunt lectus, et consectetur arcu hendrerit vel. Fusce ante est, pharetra sit amet laoreet vel, dapibus non eros. Aenean hendrerit accumsan mauris, ut laoreet risus adipiscing id. Mauris ullamcorper volutpat nunc, laoreet bibendum lacus placerat nec. Nunc at purus lorem.</p>\r\n<p>Duis suscipit iaculis tortor, sit amet sagittis purus dictum ac. Donec ut vehicula massa. Mauris nunc eros, aliquet vel lacinia vel, lobortis et augue. Proin tincidunt, lorem eu dictum tempus, magna sem imperdiet lacus, vitae ullamcorper ligula dui eget turpis. Maecenas eget urna in nisl porta rutrum. Integer hendrerit congue tellus. Integer volutpat euismod diam convallis auctor. Mauris semper mauris et magna varius adipiscing. Maecenas lacinia malesuada eleifend. Mauris dictum mattis odio vel posuere. Sed facilisis odio semper risus facilisis eget tempus mi ullamcorper.</p>', '{vimeo}31174829{/vimeo}', '{gallery}http://www.flickr.com/photos/44124451616@N01/sets/72157627872600618/with/6235207641/{/gallery}', '[]', '', '2011-11-09 09:25:54', '43', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:56:24', '43', '2011-11-09 09:25:54', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '240', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('36', 'Proin dignissim orci et tellus facilisis', 'proin-dignissim-orci-et-tellus-facilisis', '6', '1', '<p>Donec vel tortor quam. Donec non elit id purus congue luctus ut sed ante. Integer massa tortor, egestas lacinia gravida mollis, vehicula nec erat. Nulla consectetur odio id nisl sagittis blandit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n', '\r\n<p>Donec aliquam augue pellentesque tortor laoreet sodales. Aliquam elit diam, accumsan non pharetra a, vehicula vitae lorem. Fusce neque ante, dictum id volutpat eget, interdum sed sapien. Curabitur tristique velit quis dui blandit laoreet. Fusce massa velit, convallis vitae vulputate accumsan, blandit lobortis neque. Phasellus non justo quis mauris feugiat luctus. Praesent rutrum hendrerit vulputate. Phasellus sagittis tellus eget augue faucibus mollis. Mauris nunc nulla, ullamcorper ac lobortis at, sagittis eget tortor.</p>\r\n<p>Aliquam in turpis dolor, vel viverra metus. Pellentesque non tellus massa, at congue dui. Vivamus tempor, odio eu ullamcorper adipiscing, nibh dui euismod arcu, id eleifend velit metus a justo. Donec dolor nisi, feugiat sed tincidunt quis, pharetra in tellus. Quisque non risus eros, non vulputate risus. Duis non tincidunt sapien. Proin dignissim orci et tellus facilisis pulvinar. Nullam libero risus, auctor ut eleifend vitae, feugiat ac nisl. Suspendisse facilisis varius sodales. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aliquam in leo ut erat ultricies pharetra id suscipit felis. Nullam vehicula tristique dolor, vitae scelerisque risus luctus sed.</p>\r\n<p>Curabitur egestas cursus sapien, eu ultricies leo eleifend sed. Nunc eleifend est vitae diam tristique eu venenatis libero tincidunt. Duis vehicula vehicula diam, sit amet sagittis tortor molestie ac. Curabitur vitae libero eu eros bibendum vulputate at et justo. Integer porttitor orci justo, in viverra leo. Suspendisse lacinia pharetra lectus, et suscipit eros fermentum vitae. Donec sapien felis, convallis dignissim pretium a, interdum vitae ante. Aenean aliquam commodo justo non ornare. Sed pellentesque semper elementum. Sed vel mauris pharetra ipsum bibendum sollicitudin. Suspendisse metus leo, molestie eget tempus et, hendrerit et neque. Morbi a tempor sem.</p>', NULL, NULL, '[]', '', '2011-11-09 09:27:01', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:27:01', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '228', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('37', 'Praesent eu nibh ut leo euismod semper', 'praesent-eu-nibh-ut-leo-euismod-semper', '6', '1', '<p>Curabitur egestas cursus sapien, eu ultricies leo eleifend sed. Nunc eleifend est vitae diam tristique eu venenatis libero tincidunt. Duis vehicula vehicula diam, sit amet sagittis tortor molestie ac. Curabitur vitae libero eu eros bibendum vulputate at et justo.</p>\r\n', '\r\n<p>Integer porttitor orci justo, in viverra leo. Suspendisse lacinia pharetra lectus, et suscipit eros fermentum vitae. Donec sapien felis, convallis dignissim pretium a, interdum vitae ante. Aenean aliquam commodo justo non ornare. Sed pellentesque semper elementum. Sed vel mauris pharetra ipsum bibendum sollicitudin. Suspendisse metus leo, molestie eget tempus et, hendrerit et neque. Morbi a tempor sem.</p>\r\n<p>Integer commodo semper augue, ut placerat velit molestie non. Phasellus in nisi ante. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Donec consequat, massa ac rhoncus eleifend, diam quam luctus risus, a malesuada diam erat quis massa. Morbi eu tellus ac arcu luctus tempor non a mauris. Pellentesque in purus ac libero consequat aliquet in in dolor. Aliquam eget leo ante, ac sagittis metus. Nam ullamcorper, erat vel vestibulum egestas, urna libero varius turpis, non tempus purus diam eget arcu. Nam sed risus sit amet tortor rhoncus dignissim. Morbi nisi dolor, luctus eget feugiat a, adipiscing quis odio. Maecenas in lacus elit, at dictum libero. Proin dapibus augue ac erat elementum euismod in quis odio. Quisque sed est dolor, ac viverra urna. Curabitur imperdiet, neque eget bibendum porttitor, purus enim scelerisque nunc, eget pretium ante nunc et velit.</p>\r\n<p>Quisque mollis hendrerit elit, eu volutpat risus elementum in. Sed rutrum nunc non dui commodo consectetur. Praesent eu nibh ut leo euismod semper. Curabitur porta volutpat ipsum, et ullamcorper ligula sodales at. Integer quis varius est. Nam at nunc vel ligula auctor placerat. Etiam at eros vel urna porttitor egestas vel vel turpis. Praesent non varius dui. Integer id accumsan sapien. Donec sodales ipsum eu sem mollis et faucibus nisl vestibulum. Morbi facilisis euismod magna, ac tincidunt eros vehicula vel. Phasellus condimentum, risus vel sodales tincidunt, dolor lectus egestas dolor, dictum mollis nibh nunc eu tellus. Sed id tellus non odio auctor accumsan a eget quam. Sed ipsum ligula, aliquet ut fringilla eu, varius venenatis nunc. Duis euismod, est ut fringilla ornare, nisi dolor porta elit, vitae lacinia leo erat ac ante.</p>', NULL, NULL, '[]', '', '2011-11-09 09:27:46', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:27:46', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '224', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('38', 'Ut eleifend felis lacus', 'ut-eleifend-felis-lacus', '6', '1', '<p>Quisque mollis hendrerit elit, eu volutpat risus elementum in. Sed rutrum nunc non dui commodo consectetur. Praesent eu nibh ut leo euismod semper. Curabitur porta volutpat ipsum, et ullamcorper ligula sodales at. Integer quis varius est. Nam at nunc vel ligula auctor placerat.</p>\r\n', '\r\n<p>Etiam at eros vel urna porttitor egestas vel vel turpis. Praesent non varius dui. Integer id accumsan sapien. Donec sodales ipsum eu sem mollis et faucibus nisl vestibulum. Morbi facilisis euismod magna, ac tincidunt eros vehicula vel. Phasellus condimentum, risus vel sodales tincidunt, dolor lectus egestas dolor, dictum mollis nibh nunc eu tellus. Sed id tellus non odio auctor accumsan a eget quam. Sed ipsum ligula, aliquet ut fringilla eu, varius venenatis nunc. Duis euismod, est ut fringilla ornare, nisi dolor porta elit, vitae lacinia leo erat ac ante.</p>\r\n<p>In nec augue id urna elementum cursus non nec mi. Sed at orci sit amet diam ornare commodo. Nulla sit amet nisl a elit dignissim luctus venenatis vel nisl. Ut eleifend felis lacus. Sed mi massa, posuere dictum rhoncus ac, aliquet quis massa. Quisque massa neque, commodo pharetra eleifend ut, ullamcorper vitae arcu. Mauris semper hendrerit lacus nec tempor. Nulla pellentesque diam a purus gravida sollicitudin vitae et mauris. Donec purus libero, volutpat at ullamcorper vel, viverra in leo. Suspendisse commodo fermentum neque ac posuere. In ac velit lacus, eu ultricies tellus. Phasellus molestie placerat massa sed bibendum. Aliquam varius turpis pretium metus placerat non consequat leo lobortis. Etiam gravida mauris at augue dictum laoreet.</p>\r\n<p>Pellentesque condimentum nibh rutrum turpis elementum imperdiet. Nulla semper mi ac erat porttitor pretium dictum lectus euismod. Mauris pulvinar bibendum sapien non aliquam. Proin auctor iaculis dictum. Cras sodales, tellus eu posuere lacinia, odio nibh elementum eros, a laoreet lorem augue ut nibh. Duis nunc nisl, feugiat sed iaculis sit amet, bibendum vitae nisl. Fusce eget nunc at eros hendrerit sagittis. Vivamus ac risus tortor. Fusce mattis hendrerit ipsum, id porta mauris sollicitudin sed. Donec rhoncus, sapien nec venenatis varius, est dolor dictum elit, quis mollis ante ligula in leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque vehicula dapibus blandit. Praesent dignissim quam a nunc ornare gravida. Duis id mi a enim gravida adipiscing. Fusce erat nisl, malesuada id eleifend iaculis, pellentesque sed mi.</p>', NULL, NULL, '[]', '', '2011-11-09 09:28:41', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:28:41', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '239', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('39', 'Donec ultricies feugiat facilisis', 'donec-ultricies-feugiat-facilisis', '6', '1', '<p>Pellentesque condimentum nibh rutrum turpis elementum imperdiet. Nulla semper mi ac erat porttitor pretium dictum lectus euismod. Mauris pulvinar bibendum sapien non aliquam. Proin auctor iaculis dictum.</p>\r\n', '\r\n<p>Cras sodales, tellus eu posuere lacinia, odio nibh elementum eros, a laoreet lorem augue ut nibh. Duis nunc nisl, feugiat sed iaculis sit amet, bibendum vitae nisl. Fusce eget nunc at eros hendrerit sagittis. Vivamus ac risus tortor. Fusce mattis hendrerit ipsum, id porta mauris sollicitudin sed. Donec rhoncus, sapien nec venenatis varius, est dolor dictum elit, quis mollis ante ligula in leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque vehicula dapibus blandit. Praesent dignissim quam a nunc ornare gravida. Duis id mi a enim gravida adipiscing. Fusce erat nisl, malesuada id eleifend iaculis, pellentesque sed mi.</p>\r\n<p>Nam scelerisque accumsan tincidunt. Suspendisse bibendum placerat tincidunt. Nam mauris sapien, malesuada ultrices ultricies eu, ornare ac neque. Duis lacus lacus, tempor eget posuere a, facilisis sit amet augue. Pellentesque aliquam hendrerit viverra. Quisque sit amet est mauris, at ornare tortor. Proin id velit nisi. Fusce dictum lobortis cursus. Nam at quam eget nunc volutpat blandit id sit amet tellus. Donec ultricies feugiat facilisis. Mauris laoreet aliquet est, in condimentum eros aliquet eu. Proin viverra vestibulum auctor. Praesent feugiat odio quis justo aliquam accumsan. Etiam fermentum tincidunt arcu at tristique. Vestibulum pellentesque ultrices nulla.</p>\r\n<p>Mauris convallis arcu sit amet sem dignissim faucibus. Duis gravida ipsum libero. Vivamus molestie, tortor aliquet ultrices semper, orci nisl elementum magna, id vulputate lacus arcu sed elit. Suspendisse potenti. Donec eu ante sit amet orci lacinia ultrices. Pellentesque ac neque id lectus porttitor lacinia a quis urna. Nullam fermentum lobortis pulvinar. Morbi ultricies, neque sed tincidunt tristique, felis odio vestibulum erat, nec porta elit ante id velit. Duis auctor pharetra odio, et lobortis lacus commodo sed. Nulla in tellus turpis, non faucibus ipsum. Sed lacinia, velit quis feugiat fermentum, dolor lacus gravida ipsum, ac ullamcorper libero urna vel nisi. Sed ut sem sapien. Nam id nunc quam.</p>', NULL, NULL, '[]', '', '2011-11-09 09:29:27', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:29:27', '0000-00-00 00:00:00', '0', '1', '9', '0', '0', '', '', '', '', '196', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('40', 'Maecenas varius orci dui, a iaculis mi', 'maecenas-varius-orci-dui-a-iaculis-mi', '6', '1', '<p>Mauris convallis arcu sit amet sem dignissim faucibus. Duis gravida ipsum libero. Vivamus molestie, tortor aliquet ultrices semper, orci nisl elementum magna, id vulputate lacus arcu sed elit. Suspendisse potenti. Donec eu ante sit amet orci lacinia ultrices.</p>\r\n', '\r\n<p>Pellentesque ac neque id lectus porttitor lacinia a quis urna. Nullam fermentum lobortis pulvinar. Morbi ultricies, neque sed tincidunt tristique, felis odio vestibulum erat, nec porta elit ante id velit. Duis auctor pharetra odio, et lobortis lacus commodo sed. Nulla in tellus turpis, non faucibus ipsum. Sed lacinia, velit quis feugiat fermentum, dolor lacus gravida ipsum, ac ullamcorper libero urna vel nisi. Sed ut sem sapien. Nam id nunc quam.</p>\r\n<p>Integer ac commodo ligula. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Ut id sollicitudin tortor. Vestibulum tortor dolor, adipiscing a ultricies vel, varius nec elit. Vivamus elementum, est ut vulputate cursus, mauris mi elementum neque, non porttitor est magna in magna. Sed eros ipsum, ultrices ut lacinia congue, interdum bibendum quam. Integer nisl augue, euismod ut luctus ut, mollis et enim. Aliquam lobortis, diam sed vehicula aliquam, ligula nunc scelerisque lorem, at tempor nulla justo a ipsum. Suspendisse a arcu dui, vel facilisis tellus.</p>\r\n<p>Nulla faucibus orci vel sem mollis in hendrerit neque suscipit. Pellentesque imperdiet dapibus tellus vitae aliquam. Maecenas varius orci dui, a iaculis mi. Pellentesque tincidunt fermentum dui, id feugiat diam congue pharetra. Sed sollicitudin nunc ut augue lobortis non ultricies mi ullamcorper. Integer et ligula sit amet justo sodales hendrerit tristique vel tortor. Mauris sed turpis leo, vel semper dolor. Etiam fringilla dolor a neque mollis eu cursus nulla consectetur. Nullam imperdiet, nulla nec laoreet euismod, sem mauris blandit nibh, sit amet bibendum odio metus at est. Suspendisse vehicula mattis elit, non vehicula risus tempus vitae. Aenean id sem et eros consectetur scelerisque. Donec ante nulla, gravida accumsan consequat eget, malesuada et est. Aliquam erat volutpat.</p>', NULL, NULL, '[]', '', '2011-11-09 09:30:15', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:30:15', '0000-00-00 00:00:00', '0', '1', '10', '0', '0', '', '', '', '', '217', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('41', 'Sed at faucibus lacus', 'sed-at-faucibus-lacus', '41', '1', '<p>Nulla faucibus orci vel sem mollis in hendrerit neque suscipit. Pellentesque imperdiet dapibus tellus vitae aliquam. Maecenas varius orci dui, a iaculis mi. Pellentesque tincidunt fermentum dui, id feugiat diam congue pharetra. Sed sollicitudin nunc ut augue lobortis non ultricies mi ullamcorper.</p>\r\n', '\r\n<p>Integer et ligula sit amet justo sodales hendrerit tristique vel tortor. Mauris sed turpis leo, vel semper dolor. Etiam fringilla dolor a neque mollis eu cursus nulla consectetur. Nullam imperdiet, nulla nec laoreet euismod, sem mauris blandit nibh, sit amet bibendum odio metus at est. Suspendisse vehicula mattis elit, non vehicula risus tempus vitae. Aenean id sem et eros consectetur scelerisque. Donec ante nulla, gravida accumsan consequat eget, malesuada et est. Aliquam erat volutpat.</p>\r\n<p>Integer ante nisi, volutpat molestie lobortis at, molestie id dui. Nunc ut posuere sem. Fusce leo turpis, semper sed posuere non, consequat eget est. Morbi ullamcorper velit eget dolor euismod egestas. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus cursus mauris nec enim tempor aliquet. Maecenas condimentum metus sit amet augue laoreet nec cursus nisi vulputate. Sed tincidunt sem ac tortor gravida at venenatis dui pellentesque.</p>\r\n<p>Vivamus nulla mi, pharetra nec pulvinar et, dictum quis nisl. Quisque varius lacus ut lectus gravida adipiscing. Nullam dapibus nibh sit amet dui rhoncus interdum. Nunc tincidunt libero at sem vehicula tempus ac et diam. Sed id dictum sapien. Nulla pellentesque fringilla ipsum, nec tristique tortor mattis id. Aliquam tempor vehicula risus quis luctus. Ut accumsan libero in neque ultricies vel vulputate leo eleifend. Sed at faucibus lacus. Aliquam commodo molestie est ac adipiscing.</p>\r\n<p>Nam convallis fermentum ligula, at cursus sem scelerisque vitae. Curabitur molestie turpis eu nibh porttitor ac ornare felis porttitor. Duis semper, magna at semper ultricies, libero turpis interdum dolor, at molestie metus quam vel ligula. Morbi at diam massa. In hac habitasse platea dictumst. Curabitur rhoncus ornare felis at luctus. Fusce varius tortor ac sem laoreet blandit. Quisque mauris risus, viverra sed semper non, pellentesque a dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin luctus orci vel enim pretium pellentesque.</p>', NULL, NULL, '[]', '', '2011-11-09 09:34:14', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:34:14', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '454', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('42', 'Praesent iaculis placerat velit quis dictum', 'praesent-iaculis-placerat-velit-quis-dictum', '41', '1', '<p>Aenean condimentum sapien a diam consequat faucibus. Suspendisse quis mi est, ut semper libero. Etiam tincidunt suscipit sagittis. Aliquam sed dui ante. Cras ornare pretium velit viverra dictum. Pellentesque tincidunt ultricies ornare. Aenean hendrerit, mi at fermentum tempor, tortor ante imperdiet quam, non bibendum lacus lorem fringilla orci. Nullam bibendum lacinia semper.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Donec feugiat accumsan vestibulum. Maecenas eget laoreet purus. Duis sem orci, elementum vel convallis et, ultricies ornare turpis. Sed pellentesque mi scelerisque velit vestibulum vitae pretium dui tempor. Mauris sit amet metus nec purus dignissim dictum a at ante. Nam nec ultrices arcu. Nullam eu elit nulla, at ornare massa. Suspendisse enim elit, dapibus in laoreet sed, adipiscing vitae lectus. Pellentesque scelerisque nisi bibendum ante sollicitudin tristique. Praesent viverra velit sed diam ullamcorper lacinia.</p>\r\n<p>Donec varius semper velit aliquet malesuada. Nullam libero lacus, interdum in tristique sit amet, congue eget lacus. Nulla ac purus non nisl lacinia feugiat. Pellentesque metus urna, elementum sed aliquam molestie, mollis quis neque. Sed pellentesque hendrerit urna non faucibus. In est orci, vestibulum vel mollis vitae, volutpat a odio. Curabitur neque dui, euismod sed tincidunt quis, sodales ac neque. Nam fringilla blandit faucibus. Nam id elit neque. Ut id consequat lacus. Phasellus ante felis, pretium quis accumsan adipiscing, tempus porttitor augue.</p>\r\n<p>Praesent iaculis placerat velit quis dictum. Mauris nec neque leo, a vehicula neque. Aliquam elit sem, pharetra ac dignissim pellentesque, ullamcorper ut magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi semper elit ut mauris tincidunt ut blandit justo scelerisque. Ut rhoncus felis in lacus fermentum quis posuere ante interdum.</p>', NULL, NULL, '[]', '', '2011-11-09 09:38:39', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:38:39', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '463', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('43', 'Etiam nec massa purus', 'etiam-nec-massa-purus', '41', '1', '<p>Praesent iaculis placerat velit quis dictum. Mauris nec neque leo, a vehicula neque. Aliquam elit sem, pharetra ac dignissim pellentesque, ullamcorper ut magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\r\n', '\r\n<p>Morbi semper elit ut mauris tincidunt ut blandit justo scelerisque. Ut rhoncus felis in lacus fermentum quis posuere ante interdum. Aliquam adipiscing velit vel tellus sollicitudin laoreet. Donec velit velit, venenatis in rhoncus dapibus, dictum vitae metus. Sed sagittis dapibus augue sit amet varius.</p>\r\n<p>Aliquam erat volutpat. Quisque dolor dolor, convallis sed hendrerit sed, luctus sit amet massa. Pellentesque congue pretium diam, non ullamcorper velit iaculis et. Sed in lorem ut dui mattis tempus sed in ligula. Cras a venenatis purus. Integer eleifend tempus ligula, vitae dignissim sapien tincidunt sit amet. Pellentesque vel elit pharetra orci ultrices ultricies ut in mauris. Vestibulum mattis diam non mauris lacinia venenatis. Ut vitae velit vel dolor consequat consectetur. Nunc in pretium augue. Proin eget ante turpis. Vestibulum nisi dolor, tempor et varius quis, interdum id nulla. Maecenas tempus sagittis est vel ultrices. Sed ornare orci congue velit laoreet at varius nibh convallis. Ut in sem vel ligula gravida porttitor.</p>\r\n<p>Duis hendrerit imperdiet mauris sed dignissim. Phasellus venenatis tortor in turpis auctor molestie. Morbi fermentum consequat dolor a egestas. Suspendisse egestas luctus libero, non volutpat felis varius et. Phasellus accumsan tincidunt nulla eu lobortis. Maecenas ipsum urna, hendrerit id aliquam id, commodo id turpis. Etiam nec massa purus. Integer tempus cursus diam nec pretium.</p>\r\n<p>Vivamus facilisis pretium fringilla. Donec et augue nibh, quis sagittis velit. Cras nec eros mauris. Vestibulum posuere massa a tellus feugiat vel lobortis est volutpat. Curabitur a odio tellus. Donec urna ipsum, porttitor eget dignissim vitae, semper quis nisi. Nunc eleifend mattis elit in pretium. Morbi sed elit sagittis quam vehicula lobortis ac a nisl. Praesent vel ipsum dolor.</p>', '{vimeo}26682269{/vimeo}', '{gallery}http://www.flickr.com/photos/lululemonathletica/sets/72157627774053516/with/6192770768/{/gallery}', '[]', '', '2011-11-09 09:39:40', '43', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:56:54', '43', '2011-11-09 09:39:40', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '444', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('44', 'Nam in libero a sem mollis egestas', 'nam-in-libero-a-sem-mollis-egestas', '41', '1', '<p>Vivamus facilisis pretium fringilla. Donec et augue nibh, quis sagittis velit. Cras nec eros mauris. Vestibulum posuere massa a tellus feugiat vel lobortis est volutpat. Curabitur a odio tellus. Donec urna ipsum, porttitor eget dignissim vitae, semper quis nisi. Nunc eleifend mattis elit in pretium. Morbi sed elit sagittis quam vehicula lobortis ac a nisl. Praesent vel ipsum dolor.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Quisque non massa odio, eget varius ipsum. Pellentesque nunc lorem, blandit et auctor eu, commodo convallis dui. Nunc posuere elementum odio, ut adipiscing risus convallis eget. Nullam sit amet dui in orci rutrum luctus ac vitae neque. Nunc risus mauris, rutrum vitae pellentesque eget, feugiat quis leo. Praesent egestas imperdiet odio, in pretium velit sollicitudin eu. Donec eget orci et leo dictum viverra nec eu lacus. Pellentesque pellentesque sagittis euismod.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin dignissim congue mauris, scelerisque convallis nisi malesuada ac. Donec aliquet arcu sed turpis mattis lobortis. Maecenas elementum nibh et turpis auctor vehicula porttitor lacus iaculis. Nunc fermentum odio quis odio posuere condimentum. Pellentesque nec pellentesque dui. Mauris ac elit in elit porttitor convallis in quis est. In sed scelerisque augue. Donec vel metus risus, quis molestie felis. Sed vel enim ac libero accumsan porttitor nec eu urna. Pellentesque urna mauris, pharetra et viverra quis, dapibus eu turpis. Aenean facilisis, nisl sed porttitor consectetur, arcu turpis aliquet mi, in blandit enim felis eu orci. Mauris pharetra magna non libero elementum vel interdum nisi dignissim. Duis vitae lobortis tortor. In scelerisque augue nec est ultrices placerat.</p>\r\n<p>&nbsp;</p>\r\n<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar. Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu.</p>', NULL, NULL, '[]', '', '2011-11-09 09:40:23', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:40:23', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '435', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('45', 'Nam in libero a sem mollis egestas', 'nam-in-libero-a-sem-mollis-egestas', '41', '1', '<p>Quisque non massa odio, eget varius ipsum. Pellentesque nunc lorem, blandit et auctor eu, commodo convallis dui. Nunc posuere elementum odio, ut adipiscing risus convallis eget. Nullam sit amet dui in orci rutrum luctus ac vitae neque.</p>\r\n', '\r\n<p>Nunc risus mauris, rutrum vitae pellentesque eget, feugiat quis leo. Praesent egestas imperdiet odio, in pretium velit sollicitudin eu. Donec eget orci et leo dictum viverra nec eu lacus. Pellentesque pellentesque sagittis euismod.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin dignissim congue mauris, scelerisque convallis nisi malesuada ac. Donec aliquet arcu sed turpis mattis lobortis. Maecenas elementum nibh et turpis auctor vehicula porttitor lacus iaculis. Nunc fermentum odio quis odio posuere condimentum. Pellentesque nec pellentesque dui. Mauris ac elit in elit porttitor convallis in quis est. In sed scelerisque augue. Donec vel metus risus, quis molestie felis. Sed vel enim ac libero accumsan porttitor nec eu urna. Pellentesque urna mauris, pharetra et viverra quis, dapibus eu turpis. Aenean facilisis, nisl sed porttitor consectetur, arcu turpis aliquet mi, in blandit enim felis eu orci. Mauris pharetra magna non libero elementum vel interdum nisi dignissim. Duis vitae lobortis tortor. In scelerisque augue nec est ultrices placerat.</p>\r\n<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar. Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu. Suspendisse at velit vel sem dignissim ornare et vitae sem. Proin auctor massa in mauris consequat condimentum. Cras vehicula dignissim nulla ac semper. Nulla aliquet elementum nibh, sed pharetra turpis lacinia ut. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam in libero a sem mollis egestas.</p>', NULL, NULL, '[]', '', '2011-11-09 09:41:55', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:41:55', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '450', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'), ('46', 'Fusce sed tincidunt tortor', 'fusce-sed-tincidunt-tortor', '41', '1', '<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar.</p>\r\n', '\r\n<p>Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu. Suspendisse at velit vel sem dignissim ornare et vitae sem. Proin auctor massa in mauris consequat condimentum. Cras vehicula dignissim nulla ac semper. Nulla aliquet elementum nibh, sed pharetra turpis lacinia ut. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam in libero a sem mollis egestas.</p>\r\n<p>Mauris viverra nibh egestas augue pellentesque in interdum elit interdum. Mauris fringilla imperdiet orci, ac hendrerit nibh ultricies eget. Morbi ac arcu purus, sit amet facilisis tortor. In at rhoncus eros. Duis quis ante quis tortor hendrerit viverra id et urna. Vestibulum nec elit purus, vel posuere massa. Aliquam arcu ligula, convallis vel hendrerit ut, congue sit amet nisl. In hac habitasse platea dictumst. Maecenas consequat bibendum dui, et rhoncus sapien aliquet id. Phasellus quam odio, dapibus eu tempor in, auctor quis nunc. Integer ligula turpis, convallis et cursus at, elementum quis quam.</p>\r\n<p>Vestibulum venenatis pretium nisi, sed pulvinar mauris imperdiet ac. Vestibulum ultricies hendrerit tempus. Fusce nisi lacus, vulputate at luctus ut, congue ut quam. Nunc ac magna purus, ac hendrerit tortor. Nullam porttitor hendrerit ultrices. Sed aliquam posuere mattis. Integer molestie rhoncus nulla tincidunt fringilla. Nunc porttitor, felis elementum ultricies consequat, libero elit fermentum arcu, scelerisque dapibus augue arcu vitae orci. Fusce sed tincidunt tortor. Phasellus vitae sagittis ante.</p>\r\n<p>Pellentesque posuere augue consectetur sapien lobortis tincidunt. Aenean consectetur laoreet euismod. Nunc vel leo tellus. Mauris consectetur elit id magna pharetra varius. Aliquam erat volutpat. Nulla vulputate turpis nec dui molestie interdum. Ut eros lacus, commodo nec luctus quis, volutpat id elit. Nunc bibendum dignissim tempor.</p>', NULL, NULL, '[]', '', '2011-11-09 09:42:46', '43', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:42:46', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '463', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*');
