<?php
/**
 * Module Helper File
 *
 * @package         Cache Cleaner
 * @version         3.1.5
 *
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2012 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class modCacheCleaner
{
	function modCacheCleaner()
	{
		// Load plugin parameters
		require_once JPATH_PLUGINS . '/system/nnframework/helpers/parameters.php';
		$parameters = NNParameters::getInstance();
		$this->params = $parameters->getPluginParams('cachecleaner');
	}

	function render()
	{
		if (!isset($this->params->display_link)) {
			return;
		}

		// load the admin language file
		$lang = JFactory::getLanguage();
		if ($lang->getTag() != 'en-GB') {
			// Loads English language file as fallback (for undefined stuff in other language file)
			$lang->load('mod_cachecleaner', JPATH_ADMINISTRATOR, 'en-GB');
		}
		$lang->load('mod_cachecleaner', JPATH_ADMINISTRATOR, null, 1);

		require_once JPATH_PLUGINS . '/system/nnframework/helpers/versions.php';

		JHtml::stylesheet('nnframework/style.min.css', false, true);
		JHtml::script('nnframework/script.min.js', false, true);

		$script = "
			var cachecleaner_base = '" . JURI::base(true) . "';
			var cachecleaner_root = '" . JURI::root() . "';
			var cachecleaner_msg_clean = '" . addslashes(html_entity_decode(JText::_('CC_CLEANING_CACHE'))) . "';
			var cachecleaner_msg_inactive = '" . addslashes(html_entity_decode(JText::_('CC_SYSTEM_PLUGIN_NOT_ENABLED'))) . "';
			var cachecleaner_msg_failure = '" . addslashes(html_entity_decode(JText::_('CC_CACHE_COULD_NOT_BE_CLEANED'))) . "';";
		JFactory::getDocument()->addScriptDeclaration($script);
		JHtml::stylesheet('cachecleaner/style.min.css', false, true);
		JHtml::script('cachecleaner/script.min.js', false, true);

		$hastip = $this->params->display_tooltip;
		if ($hastip) {
			JHtml::_('bootstrap.tooltip');
		}

		$html = array();
		$html[] = '<div class="btn-group cachecleaner">';
		$html[] = '<a href="javascript://" onclick="return false;" class="cachecleaner_link' . ($hastip ? ' hasTooltip" title="' . JText::_('CC_CLEAN_CACHE_DESC') . '"' : '"') . '>';
		if ($this->params->display_link != 'text') {
			$html[] = '<i class="icon-nonumber icon-cachecleaner"></i> ';
		}
		if ($this->params->display_link != 'icon') {
			$text_ini = strtoupper(str_replace(' ', '_', $this->params->icon_text));
			$text = JText::_($text_ini);
			if ($text == $text_ini) {
				$text = JText::_($this->params->icon_text);
			}
			$html[] = $text;
		}
		$html[] = '</a>';
		$html[] = '</div>';

		echo implode('', $html);
	}
}
