/*
 * Regular.js - A light and simple JavaScript Library
 * Copyright © 2021 Regular Labs - All Rights Reserved
 * License https://github.com/regularlabs/regularjs/blob/master/LICENCE MIT
 */
if(typeof window.Regular==='undefined'||typeof Regular.version==='undefined'||Regular.version<1.3){"use strict";window.Regular=new function(){this.version=1.3;this.alias=function(word){if(typeof window[word]!=='undefined'){console.error(`Cannot set'${word}'as am alias of Regular,as it already exists.`);return false;}
window[word]=$;return true;};this.hasClasses=function(selector,classes,matchAll=true){if(!selector){return false;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if(typeof classes==='string'){classes=classes.split(' ');}
let hasClass=false;for(const clss of classes){hasClass=element.classList.contains(clss);if(matchAll&&!hasClass){return false;}
if(!matchAll&&hasClass){return true;}}
return hasClass;};this.addClasses=function(selector,classes){doClasses('add',selector,classes);};this.removeClasses=function(selector,classes){doClasses('remove',selector,classes);};this.toggleClasses=function(selector,classes){doClasses('toggle',selector,classes);};this.show=function(selector){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.show(subElement));return;}
let computedDisplay=getComputedStyle(element,'display');if(!('origDisplay'in element)){element.origDisplay=computedDisplay==='none'?getDefaultComputedStyle(element,'display'):computedDisplay;}
if(computedDisplay==='none'){element.style.display=('origDisplay'in element)?element.origDisplay:'';}
computedDisplay=getComputedStyle(element,'display');if(computedDisplay==='none'){element.style.display='block';}
element.style.visibility='visible';element.style.opacity=1;};this.hide=function(selector){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.hide(subElement));return;}
const computedDisplay=getComputedStyle(element,'display');if(computedDisplay!=='none'&&!('origDisplay'in element)){element.origDisplay=computedDisplay;}
element.style.display='none';element.style.visibility='hidden';element.style.opacity=0;};this.fadeIn=function(selector,duration=250,oncomplete){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.fadeIn(subElement,duration,oncomplete));return;}
element.setAttribute('data-fading','in');const wait=50;const nr_of_steps=duration/wait;const change=1/nr_of_steps;element.style.opacity=getComputedStyle(element,'opacity');if(!element.style.opacity){element.style.opacity=0;}
if(element.style.display==='none'){element.style.display='block';}
element.style.visibility='visible';(function fade(){if(element.getAttribute('data-fading')==='out'){return;}
const new_opacity=parseFloat(element.style.opacity)+change;if(new_opacity>=1){$.show(element);element.setAttribute('data-fading','');if(oncomplete){oncomplete.call(element);}
return;}
element.style.opacity=new_opacity;setTimeout(function(){fade.call();},wait);})();};this.fadeOut=function(selector,duration=250,oncomplete){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.fadeOut(subElement,duration,oncomplete));return;}
element.setAttribute('data-fading','out');const wait=50;const nr_of_steps=duration/wait;const change=1/nr_of_steps;element.style.opacity=getComputedStyle(element,'opacity');(function fade(){if(element.getAttribute('data-fading')==='in'){return;}
const new_opacity=parseFloat(element.style.opacity)-change;if(element.style.opacity<=0){$.hide(element);element.setAttribute('data-fading','');if(oncomplete){oncomplete.call(element);}
return;}
element.style.opacity=new_opacity;setTimeout(function(){fade.call();},wait);})();};this.onReady=function(func){document.addEventListener('DOMContentLoaded',func);};this.createElementFromHTML=function(html){return document.createRange().createContextualFragment(html);};this.loadUrl=function(url,data,success,fail){const request=new XMLHttpRequest();request.open("POST",url,true);request.setRequestHeader('Content-type','application/x-www-form-urlencoded');request.onreadystatechange=function(){if(this.readyState!==4){return;}
if(this.status===200){success&&success.call(null,this.responseText,this.status,this);return;}
fail&&fail.call(null,this.responseText,this.status,this);};request.send(data);};this.as=this.alias;this.hasClass=this.hasClasses;this.addClass=this.addClasses;this.removeClass=this.removeClasses;this.toggleClass=this.toggleClasses;const doClasses=function(action,selector,classes){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>doClasses(action,subElement,classes));return;}
if(typeof classes==='string'){classes=classes.split(' ');}
element.classList[action](...classes);};const getComputedStyle=function(element,property){if(!element){return null;}
return window.getComputedStyle(element).getPropertyValue(property);};const getDefaultComputedStyle=function(element,property){if(!element){return null;}
const defaultElement=document.createElement(element.nodeName);document.body.append(defaultElement);let propertyValue=window.getComputedStyle(defaultElement).getPropertyValue(property);defaultElement.remove();return propertyValue;};const $=this;};}