/**ABDB**/CREATE TABLE `#__wf_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `types` varchar(255) NOT NULL,
  `components` text NOT NULL,
  `area` tinyint(3) NOT NULL,
  `rows` text NOT NULL,
  `plugins` text NOT NULL,
  `published` tinyint(3) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` tinyint(3) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__wf_profiles`  VALUES 
('1', 'Default', 'Default Profile for all users', '', '3,4,5,6,7,8', '', '0', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,blockquote,formatselect,styleselect,removeformat,cleanup;fontselect,fontsizeselect,forecolor,backcolor,spacer,paste,indent,outdent,numlist,bullist,sub,sup,textcase,charmap,hr;directionality,fullscreen,preview,source,print,searchreplace,spacer,table;visualaid,visualchars,nonbreaking,style,xhtmlxtras,anchor,unlink,link,imgmanager,spellchecker,article', 'contextmenu,browser,inlinepopups,media,help,paste,searchreplace,directionality,fullscreen,preview,source,table,textcase,print,style,nonbreaking,visualchars,xhtmlxtras,imgmanager,link,spellchecker,article', '1', '1', '0', '0000-00-00 00:00:00', ''),
('2', 'Front End', 'Sample Front-end Profile', '', '3,4,5', '', '1', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,formatselect,styleselect;paste,searchreplace,indent,outdent,numlist,bullist,cleanup,charmap,removeformat,hr,sub,sup,textcase,nonbreaking,visualchars;fullscreen,preview,print,visualaid,style,xhtmlxtras,anchor,unlink,link,imgmanager,spellchecker,article', 'contextmenu,inlinepopups,help,paste,searchreplace,fullscreen,preview,print,style,textcase,nonbreaking,visualchars,xhtmlxtras,imgmanager,link,spellchecker,article', '0', '2', '0', '0000-00-00 00:00:00', '');
/**ABDB**/CREATE TABLE `#__weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `url` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '1', '[6,2,8]'),
('3', 'Special', '2', '[6,3,8]');
/**ABDB**/CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__utf8_conversion`  VALUES 
('5');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_block` (`block`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('42', 'Super User', 'admin', 'admin@example.com', '$2y$10$deLtHPGad.s6oQbgNUzYWeCWu7dMR.S3NXkXOmLwNB2LD7pouy12i', '0', '1', '2011-10-26 18:22:43', '2021-09-14 12:39:56', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('44', 'John Doe', 'john', 'john@example.com', '6d1b47776792259cdbfee232f880b78e:tJJHaeWok7mtvsTr2yyVcpAlRueG7Dxh', '0', '0', '2011-11-29 13:43:54', '2013-03-05 14:22:05', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('45', 'Andy Williams', 'andy', 'andy@example.com', '5c0723c98fc2005d12e3ab5c85877560:GQoQFJyDhpkp2JRpcTqDBB1TNiAWiRtT', '0', '0', '2012-02-29 15:53:40', '2013-07-10 17:04:57', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('46', 'Jane Doe', 'jane', 'jane@example.com', '$2y$10$T6MGQhGFZMIR3uElzbg1EO0LwnIU/QtHsQHaaNdMDPlobHrILA7Va', '0', '0', '2018-08-14 14:45:04', '0000-00-00 00:00:00', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '20', 'Public'),
('2', '1', '6', '17', 'Registered'),
('3', '2', '7', '14', 'Author'),
('4', '3', '8', '11', 'Editor'),
('5', '4', '9', '10', 'Publisher'),
('6', '1', '2', '5', 'Manager'),
('7', '6', '3', '4', 'Administrator'),
('8', '1', '18', '19', 'Super Users');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('42', '8'),
('44', '2'),
('45', '2'),
('46', '2');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('1', '10', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
('2', '10', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', ''),
('3', '10', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
('4', '10', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
('5', '10', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
('6', '10', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
('7', '10', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
('8', '10', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
('9', '10', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
('10', '10', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
('11', '10', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
('12', '10', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
('13', '10', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
('14', '10', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
('15', '10', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
('16', '10', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
('17', '10', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
('18', '10', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
('19', '10', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.9.28.2', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
('20', '10', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
('21', '10', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
('22', '10', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
('23', '10', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
('24', '10', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
('25', '10', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
('26', '10', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
('27', '10', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
('28', '10', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.9.25.2', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
('29', '10', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', ''),
('30', '10', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
('31', '10', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '3.10.0.1', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
('32', '10', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
('33', '10', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
('34', '10', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
('35', '10', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '3.9.29.2', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
('36', '10', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '3.10.0.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
('37', '10', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
('38', '10', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
('39', '10', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
('40', '10', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
('41', '10', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
('42', '10', '0', 'Tamil', '', 'pkg_ta-IN', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
('43', '10', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
('44', '10', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
('45', '10', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
('46', '10', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
('47', '10', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
('48', '10', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
('49', '10', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
('50', '10', '0', 'German DE', '', 'pkg_de-DE', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
('51', '10', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
('52', '10', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
('53', '10', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
('54', '10', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
('55', '10', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.10.1.2', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
('56', '10', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
('57', '10', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
('58', '10', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
('59', '10', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', ''),
('60', '10', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
('61', '10', '0', 'English CA', '', 'pkg_en-CA', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
('62', '10', '0', 'French CA', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
('63', '10', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
('64', '10', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
('65', '10', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
('66', '10', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
('67', '10', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
('68', '10', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
('69', '10', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '3.10.1.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
('70', '10', '0', 'Spanish CO', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
('71', '10', '0', 'German CH', '', 'pkg_de-CH', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
('72', '10', '0', 'German AT', '', 'pkg_de-AT', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
('73', '10', '0', 'German LI', '', 'pkg_de-LI', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
('74', '10', '0', 'German LU', '', 'pkg_de-LU', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
('75', '10', '0', 'English NZ', '', 'pkg_en-NZ', 'package', '', '0', '3.9.28.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
('76', '10', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', ''),
('77', '79', '0', 'Regular Labs - Regular Labs Library', '', 'library', 'library', '', '0', '21.8.0', '', 'https://download.regularlabs.com/updates.xml?e=library&type=.xml', '', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('10', '802'),
('10', '10057'),
('24', '28'),
('70', '10015'),
('71', '10084'),
('72', '10014'),
('73', '10017'),
('73', '10079'),
('74', '10107'),
('75', '801'),
('76', '10121'),
('77', '10138'),
('78', '10057'),
('79', '10101'),
('79', '10148');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1631623522', ''),
('10', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', '1', '1631623522', ''),
('24', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1631623522', ''),
('70', 'AllVideos', 'extension', 'https://cdn.joomlaworks.org/updates/allvideos.xml', '1', '1631623522', ''),
('71', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1631623523', ''),
('72', 'K2 Updates', 'extension', 'http://getk2.org/app/update.xml', '1', '1631623523', ''),
('73', 'Regular Labs - Cache Cleaner', 'extension', 'https://download.regularlabs.com/updates.xml?e=cachecleaner&type=.xml', '1', '1631623523', ''),
('74', 'Akeeba Backup Core', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebacore.xml', '1', '1631623523', ''),
('75', 'Weblinks Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/weblinks/master/manifest.xml', '1', '1631623523', ''),
('76', 'Akeeba FEF', 'extension', 'http://cdn.akeeba.com/updates/fef.xml', '1', '1631623523', ''),
('77', 'FOF 4.x', 'extension', 'http://cdn.akeeba.com/updates/fof4_file.xml', '1', '1631623523', ''),
('78', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist_3.xml', '1', '1631623524', ''),
('79', 'Regular Labs Library', 'extension', 'https://download.regularlabs.com/updates.xml?e=library&type=.xml', '1', '1631623524', '');
/**ABDB**/CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci,
  `core_urls` text COLLATE utf8mb4_unicode_ci,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT '0',
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('3', 'atomic', '0', '0', 'Atomic - Default', '{}', '0', ''),
('5', 'hathor', '1', '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}', '0', ''),
('8', 'protostar', '0', '0', 'protostar - Default', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '0', ''),
('9', 'isis', '1', '1', 'isis - Default', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '0', ''),
('11', 'takai', '0', '1', 'Takai - Default', '{\"siteLogo\":\"images\\/takai-logo.png\",\"siteLogoAltText\":\"\",\"siteTextAsLogo\":\"\",\"siteTagline\":\"\",\"nutpIconIOS57x57\":\"\",\"nutpIconIOS72x72\":\"\",\"nutpIconIOS114x114\":\"\",\"nutpIconIOS144x144\":\"\",\"nutpJqueryHandling\":\"1.10.1\",\"nutpLoadCustomCSS\":\"1\",\"nutpLoadCustomJS\":\"1\",\"nutpGoogleWebFonts\":{\"fonts\":[\"Droid Serif\",\"Istok Web\"],\"urls\":{\"ABeeZee\":\"\\/\\/fonts.googleapis.com\\/css?family=ABeeZee:regular,italic&subset=latin\",\"Abel\":\"\\/\\/fonts.googleapis.com\\/css?family=Abel:regular&subset=latin\",\"Abril Fatface\":\"\\/\\/fonts.googleapis.com\\/css?family=Abril+Fatface:regular&subset=latin,latin-ext\",\"Aclonica\":\"\\/\\/fonts.googleapis.com\\/css?family=Aclonica:regular&subset=latin\",\"Acme\":\"\\/\\/fonts.googleapis.com\\/css?family=Acme:regular&subset=latin\",\"Actor\":\"\\/\\/fonts.googleapis.com\\/css?family=Actor:regular&subset=latin\",\"Adamina\":\"\\/\\/fonts.googleapis.com\\/css?family=Adamina:regular&subset=latin\",\"Advent Pro\":\"\\/\\/fonts.googleapis.com\\/css?family=Advent+Pro:100,200,300,regular,500,600,700&subset=greek,latin,latin-ext\",\"Aguafina Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Aguafina+Script:regular&subset=latin,latin-ext\",\"Akronim\":\"\\/\\/fonts.googleapis.com\\/css?family=Akronim:regular&subset=latin,latin-ext\",\"Aladin\":\"\\/\\/fonts.googleapis.com\\/css?family=Aladin:regular&subset=latin,latin-ext\",\"Aldrich\":\"\\/\\/fonts.googleapis.com\\/css?family=Aldrich:regular&subset=latin\",\"Alef\":\"\\/\\/fonts.googleapis.com\\/css?family=Alef:regular,700&subset=latin\",\"Alegreya\":\"\\/\\/fonts.googleapis.com\\/css?family=Alegreya:regular,italic,700,700italic,900,900italic&subset=latin,latin-ext\",\"Alegreya SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Alegreya+SC:regular,italic,700,700italic,900,900italic&subset=latin,latin-ext\",\"Alex Brush\":\"\\/\\/fonts.googleapis.com\\/css?family=Alex+Brush:regular&subset=latin,latin-ext\",\"Alfa Slab One\":\"\\/\\/fonts.googleapis.com\\/css?family=Alfa+Slab+One:regular&subset=latin\",\"Alice\":\"\\/\\/fonts.googleapis.com\\/css?family=Alice:regular&subset=latin\",\"Alike\":\"\\/\\/fonts.googleapis.com\\/css?family=Alike:regular&subset=latin\",\"Alike Angular\":\"\\/\\/fonts.googleapis.com\\/css?family=Alike+Angular:regular&subset=latin\",\"Allan\":\"\\/\\/fonts.googleapis.com\\/css?family=Allan:regular,700&subset=latin,latin-ext\",\"Allerta\":\"\\/\\/fonts.googleapis.com\\/css?family=Allerta:regular&subset=latin\",\"Allerta Stencil\":\"\\/\\/fonts.googleapis.com\\/css?family=Allerta+Stencil:regular&subset=latin\",\"Allura\":\"\\/\\/fonts.googleapis.com\\/css?family=Allura:regular&subset=latin,latin-ext\",\"Almendra\":\"\\/\\/fonts.googleapis.com\\/css?family=Almendra:regular,italic,700,700italic&subset=latin,latin-ext\",\"Almendra Display\":\"\\/\\/fonts.googleapis.com\\/css?family=Almendra+Display:regular&subset=latin,latin-ext\",\"Almendra SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Almendra+SC:regular&subset=latin\",\"Amarante\":\"\\/\\/fonts.googleapis.com\\/css?family=Amarante:regular&subset=latin,latin-ext\",\"Amaranth\":\"\\/\\/fonts.googleapis.com\\/css?family=Amaranth:regular,italic,700,700italic&subset=latin\",\"Amatic SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Amatic+SC:regular,700&subset=latin\",\"Amethysta\":\"\\/\\/fonts.googleapis.com\\/css?family=Amethysta:regular&subset=latin\",\"Anaheim\":\"\\/\\/fonts.googleapis.com\\/css?family=Anaheim:regular&subset=latin,latin-ext\",\"Andada\":\"\\/\\/fonts.googleapis.com\\/css?family=Andada:regular&subset=latin,latin-ext\",\"Andika\":\"\\/\\/fonts.googleapis.com\\/css?family=Andika:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Angkor\":\"\\/\\/fonts.googleapis.com\\/css?family=Angkor:regular&subset=khmer\",\"Annie Use Your Telescope\":\"\\/\\/fonts.googleapis.com\\/css?family=Annie+Use+Your+Telescope:regular&subset=latin\",\"Anonymous Pro\":\"\\/\\/fonts.googleapis.com\\/css?family=Anonymous+Pro:regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Antic\":\"\\/\\/fonts.googleapis.com\\/css?family=Antic:regular&subset=latin\",\"Antic Didone\":\"\\/\\/fonts.googleapis.com\\/css?family=Antic+Didone:regular&subset=latin\",\"Antic Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Antic+Slab:regular&subset=latin\",\"Anton\":\"\\/\\/fonts.googleapis.com\\/css?family=Anton:regular&subset=latin,latin-ext\",\"Arapey\":\"\\/\\/fonts.googleapis.com\\/css?family=Arapey:regular,italic&subset=latin\",\"Arbutus\":\"\\/\\/fonts.googleapis.com\\/css?family=Arbutus:regular&subset=latin,latin-ext\",\"Arbutus Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Arbutus+Slab:regular&subset=latin,latin-ext\",\"Architects Daughter\":\"\\/\\/fonts.googleapis.com\\/css?family=Architects+Daughter:regular&subset=latin\",\"Archivo Black\":\"\\/\\/fonts.googleapis.com\\/css?family=Archivo+Black:regular&subset=latin,latin-ext\",\"Archivo Narrow\":\"\\/\\/fonts.googleapis.com\\/css?family=Archivo+Narrow:regular,italic,700,700italic&subset=latin,latin-ext\",\"Arimo\":\"\\/\\/fonts.googleapis.com\\/css?family=Arimo:regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Arizonia\":\"\\/\\/fonts.googleapis.com\\/css?family=Arizonia:regular&subset=latin,latin-ext\",\"Armata\":\"\\/\\/fonts.googleapis.com\\/css?family=Armata:regular&subset=latin,latin-ext\",\"Artifika\":\"\\/\\/fonts.googleapis.com\\/css?family=Artifika:regular&subset=latin\",\"Arvo\":\"\\/\\/fonts.googleapis.com\\/css?family=Arvo:regular,italic,700,700italic&subset=latin\",\"Asap\":\"\\/\\/fonts.googleapis.com\\/css?family=Asap:regular,italic,700,700italic&subset=latin,latin-ext\",\"Asset\":\"\\/\\/fonts.googleapis.com\\/css?family=Asset:regular&subset=latin\",\"Astloch\":\"\\/\\/fonts.googleapis.com\\/css?family=Astloch:regular,700&subset=latin\",\"Asul\":\"\\/\\/fonts.googleapis.com\\/css?family=Asul:regular,700&subset=latin\",\"Atomic Age\":\"\\/\\/fonts.googleapis.com\\/css?family=Atomic+Age:regular&subset=latin\",\"Aubrey\":\"\\/\\/fonts.googleapis.com\\/css?family=Aubrey:regular&subset=latin\",\"Audiowide\":\"\\/\\/fonts.googleapis.com\\/css?family=Audiowide:regular&subset=latin,latin-ext\",\"Autour One\":\"\\/\\/fonts.googleapis.com\\/css?family=Autour+One:regular&subset=latin,latin-ext\",\"Average\":\"\\/\\/fonts.googleapis.com\\/css?family=Average:regular&subset=latin,latin-ext\",\"Average Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Average+Sans:regular&subset=latin,latin-ext\",\"Averia Gruesa Libre\":\"\\/\\/fonts.googleapis.com\\/css?family=Averia+Gruesa+Libre:regular&subset=latin,latin-ext\",\"Averia Libre\":\"\\/\\/fonts.googleapis.com\\/css?family=Averia+Libre:300,300italic,regular,italic,700,700italic&subset=latin\",\"Averia Sans Libre\":\"\\/\\/fonts.googleapis.com\\/css?family=Averia+Sans+Libre:300,300italic,regular,italic,700,700italic&subset=latin\",\"Averia Serif Libre\":\"\\/\\/fonts.googleapis.com\\/css?family=Averia+Serif+Libre:300,300italic,regular,italic,700,700italic&subset=latin\",\"Bad Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Bad+Script:regular&subset=latin,cyrillic\",\"Balthazar\":\"\\/\\/fonts.googleapis.com\\/css?family=Balthazar:regular&subset=latin\",\"Bangers\":\"\\/\\/fonts.googleapis.com\\/css?family=Bangers:regular&subset=latin\",\"Basic\":\"\\/\\/fonts.googleapis.com\\/css?family=Basic:regular&subset=latin,latin-ext\",\"Battambang\":\"\\/\\/fonts.googleapis.com\\/css?family=Battambang:regular,700&subset=khmer\",\"Baumans\":\"\\/\\/fonts.googleapis.com\\/css?family=Baumans:regular&subset=latin\",\"Bayon\":\"\\/\\/fonts.googleapis.com\\/css?family=Bayon:regular&subset=khmer\",\"Belgrano\":\"\\/\\/fonts.googleapis.com\\/css?family=Belgrano:regular&subset=latin\",\"Belleza\":\"\\/\\/fonts.googleapis.com\\/css?family=Belleza:regular&subset=latin,latin-ext\",\"BenchNine\":\"\\/\\/fonts.googleapis.com\\/css?family=BenchNine:300,regular,700&subset=latin,latin-ext\",\"Bentham\":\"\\/\\/fonts.googleapis.com\\/css?family=Bentham:regular&subset=latin\",\"Berkshire Swash\":\"\\/\\/fonts.googleapis.com\\/css?family=Berkshire+Swash:regular&subset=latin,latin-ext\",\"Bevan\":\"\\/\\/fonts.googleapis.com\\/css?family=Bevan:regular&subset=latin\",\"Bigelow Rules\":\"\\/\\/fonts.googleapis.com\\/css?family=Bigelow+Rules:regular&subset=latin,latin-ext\",\"Bigshot One\":\"\\/\\/fonts.googleapis.com\\/css?family=Bigshot+One:regular&subset=latin\",\"Bilbo\":\"\\/\\/fonts.googleapis.com\\/css?family=Bilbo:regular&subset=latin,latin-ext\",\"Bilbo Swash Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Bilbo+Swash+Caps:regular&subset=latin,latin-ext\",\"Bitter\":\"\\/\\/fonts.googleapis.com\\/css?family=Bitter:regular,italic,700&subset=latin,latin-ext\",\"Black Ops One\":\"\\/\\/fonts.googleapis.com\\/css?family=Black+Ops+One:regular&subset=latin,latin-ext\",\"Bokor\":\"\\/\\/fonts.googleapis.com\\/css?family=Bokor:regular&subset=khmer\",\"Bonbon\":\"\\/\\/fonts.googleapis.com\\/css?family=Bonbon:regular&subset=latin\",\"Boogaloo\":\"\\/\\/fonts.googleapis.com\\/css?family=Boogaloo:regular&subset=latin\",\"Bowlby One\":\"\\/\\/fonts.googleapis.com\\/css?family=Bowlby+One:regular&subset=latin\",\"Bowlby One SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Bowlby+One+SC:regular&subset=latin,latin-ext\",\"Brawler\":\"\\/\\/fonts.googleapis.com\\/css?family=Brawler:regular&subset=latin\",\"Bree Serif\":\"\\/\\/fonts.googleapis.com\\/css?family=Bree+Serif:regular&subset=latin,latin-ext\",\"Bubblegum Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Bubblegum+Sans:regular&subset=latin,latin-ext\",\"Bubbler One\":\"\\/\\/fonts.googleapis.com\\/css?family=Bubbler+One:regular&subset=latin,latin-ext\",\"Buda\":\"\\/\\/fonts.googleapis.com\\/css?family=Buda:300&subset=latin\",\"Buenard\":\"\\/\\/fonts.googleapis.com\\/css?family=Buenard:regular,700&subset=latin,latin-ext\",\"Butcherman\":\"\\/\\/fonts.googleapis.com\\/css?family=Butcherman:regular&subset=latin,latin-ext\",\"Butterfly Kids\":\"\\/\\/fonts.googleapis.com\\/css?family=Butterfly+Kids:regular&subset=latin,latin-ext\",\"Cabin\":\"\\/\\/fonts.googleapis.com\\/css?family=Cabin:regular,italic,500,500italic,600,600italic,700,700italic&subset=latin\",\"Cabin Condensed\":\"\\/\\/fonts.googleapis.com\\/css?family=Cabin+Condensed:regular,500,600,700&subset=latin\",\"Cabin Sketch\":\"\\/\\/fonts.googleapis.com\\/css?family=Cabin+Sketch:regular,700&subset=latin\",\"Caesar Dressing\":\"\\/\\/fonts.googleapis.com\\/css?family=Caesar+Dressing:regular&subset=latin\",\"Cagliostro\":\"\\/\\/fonts.googleapis.com\\/css?family=Cagliostro:regular&subset=latin\",\"Calligraffitti\":\"\\/\\/fonts.googleapis.com\\/css?family=Calligraffitti:regular&subset=latin\",\"Cambo\":\"\\/\\/fonts.googleapis.com\\/css?family=Cambo:regular&subset=latin\",\"Candal\":\"\\/\\/fonts.googleapis.com\\/css?family=Candal:regular&subset=latin\",\"Cantarell\":\"\\/\\/fonts.googleapis.com\\/css?family=Cantarell:regular,italic,700,700italic&subset=latin\",\"Cantata One\":\"\\/\\/fonts.googleapis.com\\/css?family=Cantata+One:regular&subset=latin,latin-ext\",\"Cantora One\":\"\\/\\/fonts.googleapis.com\\/css?family=Cantora+One:regular&subset=latin,latin-ext\",\"Capriola\":\"\\/\\/fonts.googleapis.com\\/css?family=Capriola:regular&subset=latin,latin-ext\",\"Cardo\":\"\\/\\/fonts.googleapis.com\\/css?family=Cardo:regular,italic,700&subset=greek,latin,greek-ext,latin-ext\",\"Carme\":\"\\/\\/fonts.googleapis.com\\/css?family=Carme:regular&subset=latin\",\"Carrois Gothic\":\"\\/\\/fonts.googleapis.com\\/css?family=Carrois+Gothic:regular&subset=latin\",\"Carrois Gothic SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Carrois+Gothic+SC:regular&subset=latin\",\"Carter One\":\"\\/\\/fonts.googleapis.com\\/css?family=Carter+One:regular&subset=latin\",\"Caudex\":\"\\/\\/fonts.googleapis.com\\/css?family=Caudex:regular,italic,700,700italic&subset=greek,latin,greek-ext,latin-ext\",\"Cedarville Cursive\":\"\\/\\/fonts.googleapis.com\\/css?family=Cedarville+Cursive:regular&subset=latin\",\"Ceviche One\":\"\\/\\/fonts.googleapis.com\\/css?family=Ceviche+One:regular&subset=latin\",\"Changa One\":\"\\/\\/fonts.googleapis.com\\/css?family=Changa+One:regular,italic&subset=latin\",\"Chango\":\"\\/\\/fonts.googleapis.com\\/css?family=Chango:regular&subset=latin,latin-ext\",\"Chau Philomene One\":\"\\/\\/fonts.googleapis.com\\/css?family=Chau+Philomene+One:regular,italic&subset=latin,latin-ext\",\"Chela One\":\"\\/\\/fonts.googleapis.com\\/css?family=Chela+One:regular&subset=latin,latin-ext\",\"Chelsea Market\":\"\\/\\/fonts.googleapis.com\\/css?family=Chelsea+Market:regular&subset=latin,latin-ext\",\"Chenla\":\"\\/\\/fonts.googleapis.com\\/css?family=Chenla:regular&subset=khmer\",\"Cherry Cream Soda\":\"\\/\\/fonts.googleapis.com\\/css?family=Cherry+Cream+Soda:regular&subset=latin\",\"Cherry Swash\":\"\\/\\/fonts.googleapis.com\\/css?family=Cherry+Swash:regular,700&subset=latin,latin-ext\",\"Chewy\":\"\\/\\/fonts.googleapis.com\\/css?family=Chewy:regular&subset=latin\",\"Chicle\":\"\\/\\/fonts.googleapis.com\\/css?family=Chicle:regular&subset=latin,latin-ext\",\"Chivo\":\"\\/\\/fonts.googleapis.com\\/css?family=Chivo:regular,italic,900,900italic&subset=latin\",\"Cinzel\":\"\\/\\/fonts.googleapis.com\\/css?family=Cinzel:regular,700,900&subset=latin\",\"Cinzel Decorative\":\"\\/\\/fonts.googleapis.com\\/css?family=Cinzel+Decorative:regular,700,900&subset=latin\",\"Clicker Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Clicker+Script:regular&subset=latin,latin-ext\",\"Coda\":\"\\/\\/fonts.googleapis.com\\/css?family=Coda:regular,800&subset=latin\",\"Coda Caption\":\"\\/\\/fonts.googleapis.com\\/css?family=Coda+Caption:800&subset=latin\",\"Codystar\":\"\\/\\/fonts.googleapis.com\\/css?family=Codystar:300,regular&subset=latin,latin-ext\",\"Combo\":\"\\/\\/fonts.googleapis.com\\/css?family=Combo:regular&subset=latin,latin-ext\",\"Comfortaa\":\"\\/\\/fonts.googleapis.com\\/css?family=Comfortaa:300,regular,700&subset=greek,cyrillic-ext,latin,latin-ext,cyrillic\",\"Coming Soon\":\"\\/\\/fonts.googleapis.com\\/css?family=Coming+Soon:regular&subset=latin\",\"Concert One\":\"\\/\\/fonts.googleapis.com\\/css?family=Concert+One:regular&subset=latin,latin-ext\",\"Condiment\":\"\\/\\/fonts.googleapis.com\\/css?family=Condiment:regular&subset=latin,latin-ext\",\"Content\":\"\\/\\/fonts.googleapis.com\\/css?family=Content:regular,700&subset=khmer\",\"Contrail One\":\"\\/\\/fonts.googleapis.com\\/css?family=Contrail+One:regular&subset=latin\",\"Convergence\":\"\\/\\/fonts.googleapis.com\\/css?family=Convergence:regular&subset=latin\",\"Cookie\":\"\\/\\/fonts.googleapis.com\\/css?family=Cookie:regular&subset=latin\",\"Copse\":\"\\/\\/fonts.googleapis.com\\/css?family=Copse:regular&subset=latin\",\"Corben\":\"\\/\\/fonts.googleapis.com\\/css?family=Corben:regular,700&subset=latin\",\"Courgette\":\"\\/\\/fonts.googleapis.com\\/css?family=Courgette:regular&subset=latin,latin-ext\",\"Cousine\":\"\\/\\/fonts.googleapis.com\\/css?family=Cousine:regular,italic,700,700italic&subset=latin\",\"Coustard\":\"\\/\\/fonts.googleapis.com\\/css?family=Coustard:regular,900&subset=latin\",\"Covered By Your Grace\":\"\\/\\/fonts.googleapis.com\\/css?family=Covered+By+Your+Grace:regular&subset=latin\",\"Crafty Girls\":\"\\/\\/fonts.googleapis.com\\/css?family=Crafty+Girls:regular&subset=latin\",\"Creepster\":\"\\/\\/fonts.googleapis.com\\/css?family=Creepster:regular&subset=latin\",\"Crete Round\":\"\\/\\/fonts.googleapis.com\\/css?family=Crete+Round:regular,italic&subset=latin,latin-ext\",\"Crimson Text\":\"\\/\\/fonts.googleapis.com\\/css?family=Crimson+Text:regular,italic,600,600italic,700,700italic&subset=latin\",\"Croissant One\":\"\\/\\/fonts.googleapis.com\\/css?family=Croissant+One:regular&subset=latin,latin-ext\",\"Crushed\":\"\\/\\/fonts.googleapis.com\\/css?family=Crushed:regular&subset=latin\",\"Cuprum\":\"\\/\\/fonts.googleapis.com\\/css?family=Cuprum:regular,italic,700,700italic&subset=latin,latin-ext,cyrillic\",\"Cutive\":\"\\/\\/fonts.googleapis.com\\/css?family=Cutive:regular&subset=latin,latin-ext\",\"Cutive Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Cutive+Mono:regular&subset=latin,latin-ext\",\"Damion\":\"\\/\\/fonts.googleapis.com\\/css?family=Damion:regular&subset=latin\",\"Dancing Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Dancing+Script:regular,700&subset=latin\",\"Dangrek\":\"\\/\\/fonts.googleapis.com\\/css?family=Dangrek:regular&subset=khmer\",\"Dawning of a New Day\":\"\\/\\/fonts.googleapis.com\\/css?family=Dawning+of+a+New+Day:regular&subset=latin\",\"Days One\":\"\\/\\/fonts.googleapis.com\\/css?family=Days+One:regular&subset=latin\",\"Delius\":\"\\/\\/fonts.googleapis.com\\/css?family=Delius:regular&subset=latin\",\"Delius Swash Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Delius+Swash+Caps:regular&subset=latin\",\"Delius Unicase\":\"\\/\\/fonts.googleapis.com\\/css?family=Delius+Unicase:regular,700&subset=latin\",\"Della Respira\":\"\\/\\/fonts.googleapis.com\\/css?family=Della+Respira:regular&subset=latin\",\"Denk One\":\"\\/\\/fonts.googleapis.com\\/css?family=Denk+One:regular&subset=latin,latin-ext\",\"Devonshire\":\"\\/\\/fonts.googleapis.com\\/css?family=Devonshire:regular&subset=latin,latin-ext\",\"Didact Gothic\":\"\\/\\/fonts.googleapis.com\\/css?family=Didact+Gothic:regular&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Diplomata\":\"\\/\\/fonts.googleapis.com\\/css?family=Diplomata:regular&subset=latin,latin-ext\",\"Diplomata SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Diplomata+SC:regular&subset=latin,latin-ext\",\"Domine\":\"\\/\\/fonts.googleapis.com\\/css?family=Domine:regular,700&subset=latin,latin-ext\",\"Donegal One\":\"\\/\\/fonts.googleapis.com\\/css?family=Donegal+One:regular&subset=latin,latin-ext\",\"Doppio One\":\"\\/\\/fonts.googleapis.com\\/css?family=Doppio+One:regular&subset=latin,latin-ext\",\"Dorsa\":\"\\/\\/fonts.googleapis.com\\/css?family=Dorsa:regular&subset=latin\",\"Dosis\":\"\\/\\/fonts.googleapis.com\\/css?family=Dosis:200,300,regular,500,600,700,800&subset=latin,latin-ext\",\"Dr Sugiyama\":\"\\/\\/fonts.googleapis.com\\/css?family=Dr+Sugiyama:regular&subset=latin,latin-ext\",\"Droid Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Droid+Sans:regular,700&subset=latin\",\"Droid Sans Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Droid+Sans+Mono:regular&subset=latin\",\"Droid Serif\":\"\\/\\/fonts.googleapis.com\\/css?family=Droid+Serif:regular,italic,700,700italic&subset=latin\",\"Duru Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Duru+Sans:regular&subset=latin,latin-ext\",\"Dynalight\":\"\\/\\/fonts.googleapis.com\\/css?family=Dynalight:regular&subset=latin,latin-ext\",\"EB Garamond\":\"\\/\\/fonts.googleapis.com\\/css?family=EB+Garamond:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic,vietnamese\",\"Eagle Lake\":\"\\/\\/fonts.googleapis.com\\/css?family=Eagle+Lake:regular&subset=latin,latin-ext\",\"Eater\":\"\\/\\/fonts.googleapis.com\\/css?family=Eater:regular&subset=latin,latin-ext\",\"Economica\":\"\\/\\/fonts.googleapis.com\\/css?family=Economica:regular,italic,700,700italic&subset=latin,latin-ext\",\"Electrolize\":\"\\/\\/fonts.googleapis.com\\/css?family=Electrolize:regular&subset=latin\",\"Elsie\":\"\\/\\/fonts.googleapis.com\\/css?family=Elsie:regular,900&subset=latin,latin-ext\",\"Elsie Swash Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Elsie+Swash+Caps:regular,900&subset=latin,latin-ext\",\"Emblema One\":\"\\/\\/fonts.googleapis.com\\/css?family=Emblema+One:regular&subset=latin,latin-ext\",\"Emilys Candy\":\"\\/\\/fonts.googleapis.com\\/css?family=Emilys+Candy:regular&subset=latin,latin-ext\",\"Engagement\":\"\\/\\/fonts.googleapis.com\\/css?family=Engagement:regular&subset=latin\",\"Englebert\":\"\\/\\/fonts.googleapis.com\\/css?family=Englebert:regular&subset=latin,latin-ext\",\"Enriqueta\":\"\\/\\/fonts.googleapis.com\\/css?family=Enriqueta:regular,700&subset=latin,latin-ext\",\"Erica One\":\"\\/\\/fonts.googleapis.com\\/css?family=Erica+One:regular&subset=latin\",\"Esteban\":\"\\/\\/fonts.googleapis.com\\/css?family=Esteban:regular&subset=latin,latin-ext\",\"Euphoria Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Euphoria+Script:regular&subset=latin,latin-ext\",\"Ewert\":\"\\/\\/fonts.googleapis.com\\/css?family=Ewert:regular&subset=latin,latin-ext\",\"Exo\":\"\\/\\/fonts.googleapis.com\\/css?family=Exo:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&subset=latin,latin-ext\",\"Expletus Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Expletus+Sans:regular,italic,500,500italic,600,600italic,700,700italic&subset=latin\",\"Fanwood Text\":\"\\/\\/fonts.googleapis.com\\/css?family=Fanwood+Text:regular,italic&subset=latin\",\"Fascinate\":\"\\/\\/fonts.googleapis.com\\/css?family=Fascinate:regular&subset=latin\",\"Fascinate Inline\":\"\\/\\/fonts.googleapis.com\\/css?family=Fascinate+Inline:regular&subset=latin\",\"Faster One\":\"\\/\\/fonts.googleapis.com\\/css?family=Faster+One:regular&subset=latin\",\"Fasthand\":\"\\/\\/fonts.googleapis.com\\/css?family=Fasthand:regular&subset=khmer\",\"Fauna One\":\"\\/\\/fonts.googleapis.com\\/css?family=Fauna+One:regular&subset=latin,latin-ext\",\"Federant\":\"\\/\\/fonts.googleapis.com\\/css?family=Federant:regular&subset=latin\",\"Federo\":\"\\/\\/fonts.googleapis.com\\/css?family=Federo:regular&subset=latin\",\"Felipa\":\"\\/\\/fonts.googleapis.com\\/css?family=Felipa:regular&subset=latin,latin-ext\",\"Fenix\":\"\\/\\/fonts.googleapis.com\\/css?family=Fenix:regular&subset=latin,latin-ext\",\"Finger Paint\":\"\\/\\/fonts.googleapis.com\\/css?family=Finger+Paint:regular&subset=latin\",\"Fjalla One\":\"\\/\\/fonts.googleapis.com\\/css?family=Fjalla+One:regular&subset=latin,latin-ext\",\"Fjord One\":\"\\/\\/fonts.googleapis.com\\/css?family=Fjord+One:regular&subset=latin\",\"Flamenco\":\"\\/\\/fonts.googleapis.com\\/css?family=Flamenco:300,regular&subset=latin\",\"Flavors\":\"\\/\\/fonts.googleapis.com\\/css?family=Flavors:regular&subset=latin\",\"Fondamento\":\"\\/\\/fonts.googleapis.com\\/css?family=Fondamento:regular,italic&subset=latin,latin-ext\",\"Fontdiner Swanky\":\"\\/\\/fonts.googleapis.com\\/css?family=Fontdiner+Swanky:regular&subset=latin\",\"Forum\":\"\\/\\/fonts.googleapis.com\\/css?family=Forum:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Francois One\":\"\\/\\/fonts.googleapis.com\\/css?family=Francois+One:regular&subset=latin,latin-ext\",\"Freckle Face\":\"\\/\\/fonts.googleapis.com\\/css?family=Freckle+Face:regular&subset=latin,latin-ext\",\"Fredericka the Great\":\"\\/\\/fonts.googleapis.com\\/css?family=Fredericka+the+Great:regular&subset=latin\",\"Fredoka One\":\"\\/\\/fonts.googleapis.com\\/css?family=Fredoka+One:regular&subset=latin\",\"Freehand\":\"\\/\\/fonts.googleapis.com\\/css?family=Freehand:regular&subset=khmer\",\"Fresca\":\"\\/\\/fonts.googleapis.com\\/css?family=Fresca:regular&subset=latin,latin-ext\",\"Frijole\":\"\\/\\/fonts.googleapis.com\\/css?family=Frijole:regular&subset=latin\",\"Fruktur\":\"\\/\\/fonts.googleapis.com\\/css?family=Fruktur:regular&subset=latin,latin-ext\",\"Fugaz One\":\"\\/\\/fonts.googleapis.com\\/css?family=Fugaz+One:regular&subset=latin\",\"GFS Didot\":\"\\/\\/fonts.googleapis.com\\/css?family=GFS+Didot:regular&subset=greek\",\"GFS Neohellenic\":\"\\/\\/fonts.googleapis.com\\/css?family=GFS+Neohellenic:regular,italic,700,700italic&subset=greek\",\"Gabriela\":\"\\/\\/fonts.googleapis.com\\/css?family=Gabriela:regular&subset=latin,latin-ext\",\"Gafata\":\"\\/\\/fonts.googleapis.com\\/css?family=Gafata:regular&subset=latin,latin-ext\",\"Galdeano\":\"\\/\\/fonts.googleapis.com\\/css?family=Galdeano:regular&subset=latin\",\"Galindo\":\"\\/\\/fonts.googleapis.com\\/css?family=Galindo:regular&subset=latin,latin-ext\",\"Gentium Basic\":\"\\/\\/fonts.googleapis.com\\/css?family=Gentium+Basic:regular,italic,700,700italic&subset=latin,latin-ext\",\"Gentium Book Basic\":\"\\/\\/fonts.googleapis.com\\/css?family=Gentium+Book+Basic:regular,italic,700,700italic&subset=latin,latin-ext\",\"Geo\":\"\\/\\/fonts.googleapis.com\\/css?family=Geo:regular,italic&subset=latin\",\"Geostar\":\"\\/\\/fonts.googleapis.com\\/css?family=Geostar:regular&subset=latin\",\"Geostar Fill\":\"\\/\\/fonts.googleapis.com\\/css?family=Geostar+Fill:regular&subset=latin\",\"Germania One\":\"\\/\\/fonts.googleapis.com\\/css?family=Germania+One:regular&subset=latin\",\"Gilda Display\":\"\\/\\/fonts.googleapis.com\\/css?family=Gilda+Display:regular&subset=latin,latin-ext\",\"Give You Glory\":\"\\/\\/fonts.googleapis.com\\/css?family=Give+You+Glory:regular&subset=latin\",\"Glass Antiqua\":\"\\/\\/fonts.googleapis.com\\/css?family=Glass+Antiqua:regular&subset=latin,latin-ext\",\"Glegoo\":\"\\/\\/fonts.googleapis.com\\/css?family=Glegoo:regular&subset=latin,latin-ext\",\"Gloria Hallelujah\":\"\\/\\/fonts.googleapis.com\\/css?family=Gloria+Hallelujah:regular&subset=latin\",\"Goblin One\":\"\\/\\/fonts.googleapis.com\\/css?family=Goblin+One:regular&subset=latin\",\"Gochi Hand\":\"\\/\\/fonts.googleapis.com\\/css?family=Gochi+Hand:regular&subset=latin\",\"Gorditas\":\"\\/\\/fonts.googleapis.com\\/css?family=Gorditas:regular,700&subset=latin\",\"Goudy Bookletter 1911\":\"\\/\\/fonts.googleapis.com\\/css?family=Goudy+Bookletter+1911:regular&subset=latin\",\"Graduate\":\"\\/\\/fonts.googleapis.com\\/css?family=Graduate:regular&subset=latin\",\"Grand Hotel\":\"\\/\\/fonts.googleapis.com\\/css?family=Grand+Hotel:regular&subset=latin,latin-ext\",\"Gravitas One\":\"\\/\\/fonts.googleapis.com\\/css?family=Gravitas+One:regular&subset=latin\",\"Great Vibes\":\"\\/\\/fonts.googleapis.com\\/css?family=Great+Vibes:regular&subset=latin,latin-ext\",\"Griffy\":\"\\/\\/fonts.googleapis.com\\/css?family=Griffy:regular&subset=latin,latin-ext\",\"Gruppo\":\"\\/\\/fonts.googleapis.com\\/css?family=Gruppo:regular&subset=latin,latin-ext\",\"Gudea\":\"\\/\\/fonts.googleapis.com\\/css?family=Gudea:regular,italic,700&subset=latin,latin-ext\",\"Habibi\":\"\\/\\/fonts.googleapis.com\\/css?family=Habibi:regular&subset=latin,latin-ext\",\"Hammersmith One\":\"\\/\\/fonts.googleapis.com\\/css?family=Hammersmith+One:regular&subset=latin,latin-ext\",\"Hanalei\":\"\\/\\/fonts.googleapis.com\\/css?family=Hanalei:regular&subset=latin,latin-ext\",\"Hanalei Fill\":\"\\/\\/fonts.googleapis.com\\/css?family=Hanalei+Fill:regular&subset=latin,latin-ext\",\"Handlee\":\"\\/\\/fonts.googleapis.com\\/css?family=Handlee:regular&subset=latin\",\"Hanuman\":\"\\/\\/fonts.googleapis.com\\/css?family=Hanuman:regular,700&subset=khmer\",\"Happy Monkey\":\"\\/\\/fonts.googleapis.com\\/css?family=Happy+Monkey:regular&subset=latin,latin-ext\",\"Headland One\":\"\\/\\/fonts.googleapis.com\\/css?family=Headland+One:regular&subset=latin,latin-ext\",\"Henny Penny\":\"\\/\\/fonts.googleapis.com\\/css?family=Henny+Penny:regular&subset=latin\",\"Herr Von Muellerhoff\":\"\\/\\/fonts.googleapis.com\\/css?family=Herr+Von+Muellerhoff:regular&subset=latin,latin-ext\",\"Holtwood One SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Holtwood+One+SC:regular&subset=latin\",\"Homemade Apple\":\"\\/\\/fonts.googleapis.com\\/css?family=Homemade+Apple:regular&subset=latin\",\"Homenaje\":\"\\/\\/fonts.googleapis.com\\/css?family=Homenaje:regular&subset=latin,latin-ext\",\"IM Fell DW Pica\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+DW+Pica:regular,italic&subset=latin\",\"IM Fell DW Pica SC\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+DW+Pica+SC:regular&subset=latin\",\"IM Fell Double Pica\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+Double+Pica:regular,italic&subset=latin\",\"IM Fell Double Pica SC\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+Double+Pica+SC:regular&subset=latin\",\"IM Fell English\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+English:regular,italic&subset=latin\",\"IM Fell English SC\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+English+SC:regular&subset=latin\",\"IM Fell French Canon\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+French+Canon:regular,italic&subset=latin\",\"IM Fell French Canon SC\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+French+Canon+SC:regular&subset=latin\",\"IM Fell Great Primer\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+Great+Primer:regular,italic&subset=latin\",\"IM Fell Great Primer SC\":\"\\/\\/fonts.googleapis.com\\/css?family=IM+Fell+Great+Primer+SC:regular&subset=latin\",\"Iceberg\":\"\\/\\/fonts.googleapis.com\\/css?family=Iceberg:regular&subset=latin\",\"Iceland\":\"\\/\\/fonts.googleapis.com\\/css?family=Iceland:regular&subset=latin\",\"Imprima\":\"\\/\\/fonts.googleapis.com\\/css?family=Imprima:regular&subset=latin,latin-ext\",\"Inconsolata\":\"\\/\\/fonts.googleapis.com\\/css?family=Inconsolata:regular,700&subset=latin,latin-ext\",\"Inder\":\"\\/\\/fonts.googleapis.com\\/css?family=Inder:regular&subset=latin,latin-ext\",\"Indie Flower\":\"\\/\\/fonts.googleapis.com\\/css?family=Indie+Flower:regular&subset=latin\",\"Inika\":\"\\/\\/fonts.googleapis.com\\/css?family=Inika:regular,700&subset=latin,latin-ext\",\"Irish Grover\":\"\\/\\/fonts.googleapis.com\\/css?family=Irish+Grover:regular&subset=latin\",\"Istok Web\":\"\\/\\/fonts.googleapis.com\\/css?family=Istok+Web:regular,italic,700,700italic&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Italiana\":\"\\/\\/fonts.googleapis.com\\/css?family=Italiana:regular&subset=latin\",\"Italianno\":\"\\/\\/fonts.googleapis.com\\/css?family=Italianno:regular&subset=latin,latin-ext\",\"Jacques Francois\":\"\\/\\/fonts.googleapis.com\\/css?family=Jacques+Francois:regular&subset=latin\",\"Jacques Francois Shadow\":\"\\/\\/fonts.googleapis.com\\/css?family=Jacques+Francois+Shadow:regular&subset=latin\",\"Jim Nightshade\":\"\\/\\/fonts.googleapis.com\\/css?family=Jim+Nightshade:regular&subset=latin,latin-ext\",\"Jockey One\":\"\\/\\/fonts.googleapis.com\\/css?family=Jockey+One:regular&subset=latin,latin-ext\",\"Jolly Lodger\":\"\\/\\/fonts.googleapis.com\\/css?family=Jolly+Lodger:regular&subset=latin,latin-ext\",\"Josefin Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Josefin+Sans:100,100italic,300,300italic,regular,italic,600,600italic,700,700italic&subset=latin\",\"Josefin Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Josefin+Slab:100,100italic,300,300italic,regular,italic,600,600italic,700,700italic&subset=latin\",\"Joti One\":\"\\/\\/fonts.googleapis.com\\/css?family=Joti+One:regular&subset=latin,latin-ext\",\"Judson\":\"\\/\\/fonts.googleapis.com\\/css?family=Judson:regular,italic,700&subset=latin\",\"Julee\":\"\\/\\/fonts.googleapis.com\\/css?family=Julee:regular&subset=latin\",\"Julius Sans One\":\"\\/\\/fonts.googleapis.com\\/css?family=Julius+Sans+One:regular&subset=latin,latin-ext\",\"Junge\":\"\\/\\/fonts.googleapis.com\\/css?family=Junge:regular&subset=latin\",\"Jura\":\"\\/\\/fonts.googleapis.com\\/css?family=Jura:300,regular,500,600&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Just Another Hand\":\"\\/\\/fonts.googleapis.com\\/css?family=Just+Another+Hand:regular&subset=latin\",\"Just Me Again Down Here\":\"\\/\\/fonts.googleapis.com\\/css?family=Just+Me+Again+Down+Here:regular&subset=latin,latin-ext\",\"Kameron\":\"\\/\\/fonts.googleapis.com\\/css?family=Kameron:regular,700&subset=latin\",\"Karla\":\"\\/\\/fonts.googleapis.com\\/css?family=Karla:regular,italic,700,700italic&subset=latin,latin-ext\",\"Kaushan Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Kaushan+Script:regular&subset=latin,latin-ext\",\"Kavoon\":\"\\/\\/fonts.googleapis.com\\/css?family=Kavoon:regular&subset=latin,latin-ext\",\"Keania One\":\"\\/\\/fonts.googleapis.com\\/css?family=Keania+One:regular&subset=latin,latin-ext\",\"Kelly Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Kelly+Slab:regular&subset=latin,latin-ext,cyrillic\",\"Kenia\":\"\\/\\/fonts.googleapis.com\\/css?family=Kenia:regular&subset=latin\",\"Khmer\":\"\\/\\/fonts.googleapis.com\\/css?family=Khmer:regular&subset=khmer\",\"Kite One\":\"\\/\\/fonts.googleapis.com\\/css?family=Kite+One:regular&subset=latin\",\"Knewave\":\"\\/\\/fonts.googleapis.com\\/css?family=Knewave:regular&subset=latin,latin-ext\",\"Kotta One\":\"\\/\\/fonts.googleapis.com\\/css?family=Kotta+One:regular&subset=latin,latin-ext\",\"Koulen\":\"\\/\\/fonts.googleapis.com\\/css?family=Koulen:regular&subset=khmer\",\"Kranky\":\"\\/\\/fonts.googleapis.com\\/css?family=Kranky:regular&subset=latin\",\"Kreon\":\"\\/\\/fonts.googleapis.com\\/css?family=Kreon:300,regular,700&subset=latin\",\"Kristi\":\"\\/\\/fonts.googleapis.com\\/css?family=Kristi:regular&subset=latin\",\"Krona One\":\"\\/\\/fonts.googleapis.com\\/css?family=Krona+One:regular&subset=latin,latin-ext\",\"La Belle Aurore\":\"\\/\\/fonts.googleapis.com\\/css?family=La+Belle+Aurore:regular&subset=latin\",\"Lancelot\":\"\\/\\/fonts.googleapis.com\\/css?family=Lancelot:regular&subset=latin\",\"Lato\":\"\\/\\/fonts.googleapis.com\\/css?family=Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic&subset=latin\",\"League Script\":\"\\/\\/fonts.googleapis.com\\/css?family=League+Script:regular&subset=latin\",\"Leckerli One\":\"\\/\\/fonts.googleapis.com\\/css?family=Leckerli+One:regular&subset=latin\",\"Ledger\":\"\\/\\/fonts.googleapis.com\\/css?family=Ledger:regular&subset=latin,latin-ext,cyrillic\",\"Lekton\":\"\\/\\/fonts.googleapis.com\\/css?family=Lekton:regular,italic,700&subset=latin,latin-ext\",\"Lemon\":\"\\/\\/fonts.googleapis.com\\/css?family=Lemon:regular&subset=latin\",\"Libre Baskerville\":\"\\/\\/fonts.googleapis.com\\/css?family=Libre+Baskerville:regular,italic,700&subset=latin,latin-ext\",\"Life Savers\":\"\\/\\/fonts.googleapis.com\\/css?family=Life+Savers:regular,700&subset=latin,latin-ext\",\"Lilita One\":\"\\/\\/fonts.googleapis.com\\/css?family=Lilita+One:regular&subset=latin,latin-ext\",\"Lily Script One\":\"\\/\\/fonts.googleapis.com\\/css?family=Lily+Script+One:regular&subset=latin,latin-ext\",\"Limelight\":\"\\/\\/fonts.googleapis.com\\/css?family=Limelight:regular&subset=latin,latin-ext\",\"Linden Hill\":\"\\/\\/fonts.googleapis.com\\/css?family=Linden+Hill:regular,italic&subset=latin\",\"Lobster\":\"\\/\\/fonts.googleapis.com\\/css?family=Lobster:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Lobster Two\":\"\\/\\/fonts.googleapis.com\\/css?family=Lobster+Two:regular,italic,700,700italic&subset=latin\",\"Londrina Outline\":\"\\/\\/fonts.googleapis.com\\/css?family=Londrina+Outline:regular&subset=latin\",\"Londrina Shadow\":\"\\/\\/fonts.googleapis.com\\/css?family=Londrina+Shadow:regular&subset=latin\",\"Londrina Sketch\":\"\\/\\/fonts.googleapis.com\\/css?family=Londrina+Sketch:regular&subset=latin\",\"Londrina Solid\":\"\\/\\/fonts.googleapis.com\\/css?family=Londrina+Solid:regular&subset=latin\",\"Lora\":\"\\/\\/fonts.googleapis.com\\/css?family=Lora:regular,italic,700,700italic&subset=latin\",\"Love Ya Like A Sister\":\"\\/\\/fonts.googleapis.com\\/css?family=Love+Ya+Like+A+Sister:regular&subset=latin\",\"Loved by the King\":\"\\/\\/fonts.googleapis.com\\/css?family=Loved+by+the+King:regular&subset=latin\",\"Lovers Quarrel\":\"\\/\\/fonts.googleapis.com\\/css?family=Lovers+Quarrel:regular&subset=latin,latin-ext\",\"Luckiest Guy\":\"\\/\\/fonts.googleapis.com\\/css?family=Luckiest+Guy:regular&subset=latin\",\"Lusitana\":\"\\/\\/fonts.googleapis.com\\/css?family=Lusitana:regular,700&subset=latin\",\"Lustria\":\"\\/\\/fonts.googleapis.com\\/css?family=Lustria:regular&subset=latin\",\"Macondo\":\"\\/\\/fonts.googleapis.com\\/css?family=Macondo:regular&subset=latin\",\"Macondo Swash Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Macondo+Swash+Caps:regular&subset=latin\",\"Magra\":\"\\/\\/fonts.googleapis.com\\/css?family=Magra:regular,700&subset=latin,latin-ext\",\"Maiden Orange\":\"\\/\\/fonts.googleapis.com\\/css?family=Maiden+Orange:regular&subset=latin\",\"Mako\":\"\\/\\/fonts.googleapis.com\\/css?family=Mako:regular&subset=latin\",\"Marcellus\":\"\\/\\/fonts.googleapis.com\\/css?family=Marcellus:regular&subset=latin,latin-ext\",\"Marcellus SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Marcellus+SC:regular&subset=latin,latin-ext\",\"Marck Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Marck+Script:regular&subset=latin,latin-ext,cyrillic\",\"Margarine\":\"\\/\\/fonts.googleapis.com\\/css?family=Margarine:regular&subset=latin,latin-ext\",\"Marko One\":\"\\/\\/fonts.googleapis.com\\/css?family=Marko+One:regular&subset=latin\",\"Marmelad\":\"\\/\\/fonts.googleapis.com\\/css?family=Marmelad:regular&subset=latin,latin-ext,cyrillic\",\"Marvel\":\"\\/\\/fonts.googleapis.com\\/css?family=Marvel:regular,italic,700,700italic&subset=latin\",\"Mate\":\"\\/\\/fonts.googleapis.com\\/css?family=Mate:regular,italic&subset=latin\",\"Mate SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Mate+SC:regular&subset=latin\",\"Maven Pro\":\"\\/\\/fonts.googleapis.com\\/css?family=Maven+Pro:regular,500,700,900&subset=latin\",\"McLaren\":\"\\/\\/fonts.googleapis.com\\/css?family=McLaren:regular&subset=latin,latin-ext\",\"Meddon\":\"\\/\\/fonts.googleapis.com\\/css?family=Meddon:regular&subset=latin\",\"MedievalSharp\":\"\\/\\/fonts.googleapis.com\\/css?family=MedievalSharp:regular&subset=latin,latin-ext\",\"Medula One\":\"\\/\\/fonts.googleapis.com\\/css?family=Medula+One:regular&subset=latin\",\"Megrim\":\"\\/\\/fonts.googleapis.com\\/css?family=Megrim:regular&subset=latin\",\"Meie Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Meie+Script:regular&subset=latin,latin-ext\",\"Merienda\":\"\\/\\/fonts.googleapis.com\\/css?family=Merienda:regular,700&subset=latin,latin-ext\",\"Merienda One\":\"\\/\\/fonts.googleapis.com\\/css?family=Merienda+One:regular&subset=latin\",\"Merriweather\":\"\\/\\/fonts.googleapis.com\\/css?family=Merriweather:300,300italic,regular,italic,700,700italic,900,900italic&subset=latin,latin-ext\",\"Merriweather Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Merriweather+Sans:300,300italic,regular,italic,700,700italic,800,800italic&subset=latin,latin-ext\",\"Metal\":\"\\/\\/fonts.googleapis.com\\/css?family=Metal:regular&subset=khmer\",\"Metal Mania\":\"\\/\\/fonts.googleapis.com\\/css?family=Metal+Mania:regular&subset=latin,latin-ext\",\"Metamorphous\":\"\\/\\/fonts.googleapis.com\\/css?family=Metamorphous:regular&subset=latin,latin-ext\",\"Metrophobic\":\"\\/\\/fonts.googleapis.com\\/css?family=Metrophobic:regular&subset=latin\",\"Michroma\":\"\\/\\/fonts.googleapis.com\\/css?family=Michroma:regular&subset=latin\",\"Milonga\":\"\\/\\/fonts.googleapis.com\\/css?family=Milonga:regular&subset=latin,latin-ext\",\"Miltonian\":\"\\/\\/fonts.googleapis.com\\/css?family=Miltonian:regular&subset=latin\",\"Miltonian Tattoo\":\"\\/\\/fonts.googleapis.com\\/css?family=Miltonian+Tattoo:regular&subset=latin\",\"Miniver\":\"\\/\\/fonts.googleapis.com\\/css?family=Miniver:regular&subset=latin\",\"Miss Fajardose\":\"\\/\\/fonts.googleapis.com\\/css?family=Miss+Fajardose:regular&subset=latin,latin-ext\",\"Modern Antiqua\":\"\\/\\/fonts.googleapis.com\\/css?family=Modern+Antiqua:regular&subset=latin,latin-ext\",\"Molengo\":\"\\/\\/fonts.googleapis.com\\/css?family=Molengo:regular&subset=latin,latin-ext\",\"Molle\":\"\\/\\/fonts.googleapis.com\\/css?family=Molle:italic&subset=latin,latin-ext\",\"Monda\":\"\\/\\/fonts.googleapis.com\\/css?family=Monda:regular,700&subset=latin,latin-ext\",\"Monofett\":\"\\/\\/fonts.googleapis.com\\/css?family=Monofett:regular&subset=latin\",\"Monoton\":\"\\/\\/fonts.googleapis.com\\/css?family=Monoton:regular&subset=latin\",\"Monsieur La Doulaise\":\"\\/\\/fonts.googleapis.com\\/css?family=Monsieur+La+Doulaise:regular&subset=latin,latin-ext\",\"Montaga\":\"\\/\\/fonts.googleapis.com\\/css?family=Montaga:regular&subset=latin\",\"Montez\":\"\\/\\/fonts.googleapis.com\\/css?family=Montez:regular&subset=latin\",\"Montserrat\":\"\\/\\/fonts.googleapis.com\\/css?family=Montserrat:regular,700&subset=latin\",\"Montserrat Alternates\":\"\\/\\/fonts.googleapis.com\\/css?family=Montserrat+Alternates:regular,700&subset=latin\",\"Montserrat Subrayada\":\"\\/\\/fonts.googleapis.com\\/css?family=Montserrat+Subrayada:regular,700&subset=latin\",\"Moul\":\"\\/\\/fonts.googleapis.com\\/css?family=Moul:regular&subset=khmer\",\"Moulpali\":\"\\/\\/fonts.googleapis.com\\/css?family=Moulpali:regular&subset=khmer\",\"Mountains of Christmas\":\"\\/\\/fonts.googleapis.com\\/css?family=Mountains+of+Christmas:regular,700&subset=latin\",\"Mouse Memoirs\":\"\\/\\/fonts.googleapis.com\\/css?family=Mouse+Memoirs:regular&subset=latin,latin-ext\",\"Mr Bedfort\":\"\\/\\/fonts.googleapis.com\\/css?family=Mr+Bedfort:regular&subset=latin,latin-ext\",\"Mr Dafoe\":\"\\/\\/fonts.googleapis.com\\/css?family=Mr+Dafoe:regular&subset=latin,latin-ext\",\"Mr De Haviland\":\"\\/\\/fonts.googleapis.com\\/css?family=Mr+De+Haviland:regular&subset=latin,latin-ext\",\"Mrs Saint Delafield\":\"\\/\\/fonts.googleapis.com\\/css?family=Mrs+Saint+Delafield:regular&subset=latin,latin-ext\",\"Mrs Sheppards\":\"\\/\\/fonts.googleapis.com\\/css?family=Mrs+Sheppards:regular&subset=latin,latin-ext\",\"Muli\":\"\\/\\/fonts.googleapis.com\\/css?family=Muli:300,300italic,regular,italic&subset=latin\",\"Mystery Quest\":\"\\/\\/fonts.googleapis.com\\/css?family=Mystery+Quest:regular&subset=latin,latin-ext\",\"Neucha\":\"\\/\\/fonts.googleapis.com\\/css?family=Neucha:regular&subset=latin,cyrillic\",\"Neuton\":\"\\/\\/fonts.googleapis.com\\/css?family=Neuton:200,300,regular,italic,700,800&subset=latin,latin-ext\",\"New Rocker\":\"\\/\\/fonts.googleapis.com\\/css?family=New+Rocker:regular&subset=latin,latin-ext\",\"News Cycle\":\"\\/\\/fonts.googleapis.com\\/css?family=News+Cycle:regular,700&subset=latin,latin-ext\",\"Niconne\":\"\\/\\/fonts.googleapis.com\\/css?family=Niconne:regular&subset=latin,latin-ext\",\"Nixie One\":\"\\/\\/fonts.googleapis.com\\/css?family=Nixie+One:regular&subset=latin\",\"Nobile\":\"\\/\\/fonts.googleapis.com\\/css?family=Nobile:regular,italic,700,700italic&subset=latin\",\"Nokora\":\"\\/\\/fonts.googleapis.com\\/css?family=Nokora:regular,700&subset=khmer\",\"Norican\":\"\\/\\/fonts.googleapis.com\\/css?family=Norican:regular&subset=latin,latin-ext\",\"Nosifer\":\"\\/\\/fonts.googleapis.com\\/css?family=Nosifer:regular&subset=latin,latin-ext\",\"Nothing You Could Do\":\"\\/\\/fonts.googleapis.com\\/css?family=Nothing+You+Could+Do:regular&subset=latin\",\"Noticia Text\":\"\\/\\/fonts.googleapis.com\\/css?family=Noticia+Text:regular,italic,700,700italic&subset=latin,latin-ext,vietnamese\",\"Noto Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Noto+Sans:regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Noto Serif\":\"\\/\\/fonts.googleapis.com\\/css?family=Noto+Serif:regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Nova Cut\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Cut:regular&subset=latin\",\"Nova Flat\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Flat:regular&subset=latin\",\"Nova Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Mono:regular&subset=greek,latin\",\"Nova Oval\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Oval:regular&subset=latin\",\"Nova Round\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Round:regular&subset=latin\",\"Nova Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Script:regular&subset=latin\",\"Nova Slim\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Slim:regular&subset=latin\",\"Nova Square\":\"\\/\\/fonts.googleapis.com\\/css?family=Nova+Square:regular&subset=latin\",\"Numans\":\"\\/\\/fonts.googleapis.com\\/css?family=Numans:regular&subset=latin\",\"Nunito\":\"\\/\\/fonts.googleapis.com\\/css?family=Nunito:300,regular,700&subset=latin\",\"Odor Mean Chey\":\"\\/\\/fonts.googleapis.com\\/css?family=Odor+Mean+Chey:regular&subset=khmer\",\"Offside\":\"\\/\\/fonts.googleapis.com\\/css?family=Offside:regular&subset=latin\",\"Old Standard TT\":\"\\/\\/fonts.googleapis.com\\/css?family=Old+Standard+TT:regular,italic,700&subset=latin\",\"Oldenburg\":\"\\/\\/fonts.googleapis.com\\/css?family=Oldenburg:regular&subset=latin,latin-ext\",\"Oleo Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Oleo+Script:regular,700&subset=latin,latin-ext\",\"Oleo Script Swash Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Oleo+Script+Swash+Caps:regular,700&subset=latin,latin-ext\",\"Open Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Open+Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Open Sans Condensed\":\"\\/\\/fonts.googleapis.com\\/css?family=Open+Sans+Condensed:300,300italic,700&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Oranienbaum\":\"\\/\\/fonts.googleapis.com\\/css?family=Oranienbaum:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Orbitron\":\"\\/\\/fonts.googleapis.com\\/css?family=Orbitron:regular,500,700,900&subset=latin\",\"Oregano\":\"\\/\\/fonts.googleapis.com\\/css?family=Oregano:regular,italic&subset=latin,latin-ext\",\"Orienta\":\"\\/\\/fonts.googleapis.com\\/css?family=Orienta:regular&subset=latin,latin-ext\",\"Original Surfer\":\"\\/\\/fonts.googleapis.com\\/css?family=Original+Surfer:regular&subset=latin\",\"Oswald\":\"\\/\\/fonts.googleapis.com\\/css?family=Oswald:300,regular,700&subset=latin,latin-ext\",\"Over the Rainbow\":\"\\/\\/fonts.googleapis.com\\/css?family=Over+the+Rainbow:regular&subset=latin\",\"Overlock\":\"\\/\\/fonts.googleapis.com\\/css?family=Overlock:regular,italic,700,700italic,900,900italic&subset=latin,latin-ext\",\"Overlock SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Overlock+SC:regular&subset=latin,latin-ext\",\"Ovo\":\"\\/\\/fonts.googleapis.com\\/css?family=Ovo:regular&subset=latin\",\"Oxygen\":\"\\/\\/fonts.googleapis.com\\/css?family=Oxygen:300,regular,700&subset=latin,latin-ext\",\"Oxygen Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Oxygen+Mono:regular&subset=latin,latin-ext\",\"PT Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Mono:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"PT Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Sans:regular,italic,700,700italic&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"PT Sans Caption\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Sans+Caption:regular,700&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"PT Sans Narrow\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Sans+Narrow:regular,700&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"PT Serif\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Serif:regular,italic,700,700italic&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"PT Serif Caption\":\"\\/\\/fonts.googleapis.com\\/css?family=PT+Serif+Caption:regular,italic&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Pacifico\":\"\\/\\/fonts.googleapis.com\\/css?family=Pacifico:regular&subset=latin\",\"Paprika\":\"\\/\\/fonts.googleapis.com\\/css?family=Paprika:regular&subset=latin\",\"Parisienne\":\"\\/\\/fonts.googleapis.com\\/css?family=Parisienne:regular&subset=latin,latin-ext\",\"Passero One\":\"\\/\\/fonts.googleapis.com\\/css?family=Passero+One:regular&subset=latin,latin-ext\",\"Passion One\":\"\\/\\/fonts.googleapis.com\\/css?family=Passion+One:regular,700,900&subset=latin,latin-ext\",\"Pathway Gothic One\":\"\\/\\/fonts.googleapis.com\\/css?family=Pathway+Gothic+One:regular&subset=latin,latin-ext\",\"Patrick Hand\":\"\\/\\/fonts.googleapis.com\\/css?family=Patrick+Hand:regular&subset=latin,latin-ext,vietnamese\",\"Patrick Hand SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Patrick+Hand+SC:regular&subset=latin,latin-ext,vietnamese\",\"Patua One\":\"\\/\\/fonts.googleapis.com\\/css?family=Patua+One:regular&subset=latin\",\"Paytone One\":\"\\/\\/fonts.googleapis.com\\/css?family=Paytone+One:regular&subset=latin\",\"Peralta\":\"\\/\\/fonts.googleapis.com\\/css?family=Peralta:regular&subset=latin,latin-ext\",\"Permanent Marker\":\"\\/\\/fonts.googleapis.com\\/css?family=Permanent+Marker:regular&subset=latin\",\"Petit Formal Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Petit+Formal+Script:regular&subset=latin,latin-ext\",\"Petrona\":\"\\/\\/fonts.googleapis.com\\/css?family=Petrona:regular&subset=latin\",\"Philosopher\":\"\\/\\/fonts.googleapis.com\\/css?family=Philosopher:regular,italic,700,700italic&subset=latin,cyrillic\",\"Piedra\":\"\\/\\/fonts.googleapis.com\\/css?family=Piedra:regular&subset=latin,latin-ext\",\"Pinyon Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Pinyon+Script:regular&subset=latin\",\"Pirata One\":\"\\/\\/fonts.googleapis.com\\/css?family=Pirata+One:regular&subset=latin,latin-ext\",\"Plaster\":\"\\/\\/fonts.googleapis.com\\/css?family=Plaster:regular&subset=latin,latin-ext\",\"Play\":\"\\/\\/fonts.googleapis.com\\/css?family=Play:regular,700&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Playball\":\"\\/\\/fonts.googleapis.com\\/css?family=Playball:regular&subset=latin,latin-ext\",\"Playfair Display\":\"\\/\\/fonts.googleapis.com\\/css?family=Playfair+Display:regular,italic,700,700italic,900,900italic&subset=latin,latin-ext,cyrillic\",\"Playfair Display SC\":\"\\/\\/fonts.googleapis.com\\/css?family=Playfair+Display+SC:regular,italic,700,700italic,900,900italic&subset=latin,latin-ext,cyrillic\",\"Podkova\":\"\\/\\/fonts.googleapis.com\\/css?family=Podkova:regular,700&subset=latin\",\"Poiret One\":\"\\/\\/fonts.googleapis.com\\/css?family=Poiret+One:regular&subset=latin,latin-ext,cyrillic\",\"Poller One\":\"\\/\\/fonts.googleapis.com\\/css?family=Poller+One:regular&subset=latin\",\"Poly\":\"\\/\\/fonts.googleapis.com\\/css?family=Poly:regular,italic&subset=latin\",\"Pompiere\":\"\\/\\/fonts.googleapis.com\\/css?family=Pompiere:regular&subset=latin\",\"Pontano Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Pontano+Sans:regular&subset=latin,latin-ext\",\"Port Lligat Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Port+Lligat+Sans:regular&subset=latin\",\"Port Lligat Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Port+Lligat+Slab:regular&subset=latin\",\"Prata\":\"\\/\\/fonts.googleapis.com\\/css?family=Prata:regular&subset=latin\",\"Preahvihear\":\"\\/\\/fonts.googleapis.com\\/css?family=Preahvihear:regular&subset=khmer\",\"Press Start 2P\":\"\\/\\/fonts.googleapis.com\\/css?family=Press+Start+2P:regular&subset=greek,latin,latin-ext,cyrillic\",\"Princess Sofia\":\"\\/\\/fonts.googleapis.com\\/css?family=Princess+Sofia:regular&subset=latin,latin-ext\",\"Prociono\":\"\\/\\/fonts.googleapis.com\\/css?family=Prociono:regular&subset=latin\",\"Prosto One\":\"\\/\\/fonts.googleapis.com\\/css?family=Prosto+One:regular&subset=latin,latin-ext,cyrillic\",\"Puritan\":\"\\/\\/fonts.googleapis.com\\/css?family=Puritan:regular,italic,700,700italic&subset=latin\",\"Purple Purse\":\"\\/\\/fonts.googleapis.com\\/css?family=Purple+Purse:regular&subset=latin,latin-ext\",\"Quando\":\"\\/\\/fonts.googleapis.com\\/css?family=Quando:regular&subset=latin,latin-ext\",\"Quantico\":\"\\/\\/fonts.googleapis.com\\/css?family=Quantico:regular,italic,700,700italic&subset=latin\",\"Quattrocento\":\"\\/\\/fonts.googleapis.com\\/css?family=Quattrocento:regular,700&subset=latin,latin-ext\",\"Quattrocento Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Quattrocento+Sans:regular,italic,700,700italic&subset=latin,latin-ext\",\"Questrial\":\"\\/\\/fonts.googleapis.com\\/css?family=Questrial:regular&subset=latin\",\"Quicksand\":\"\\/\\/fonts.googleapis.com\\/css?family=Quicksand:300,regular,700&subset=latin\",\"Quintessential\":\"\\/\\/fonts.googleapis.com\\/css?family=Quintessential:regular&subset=latin,latin-ext\",\"Qwigley\":\"\\/\\/fonts.googleapis.com\\/css?family=Qwigley:regular&subset=latin,latin-ext\",\"Racing Sans One\":\"\\/\\/fonts.googleapis.com\\/css?family=Racing+Sans+One:regular&subset=latin,latin-ext\",\"Radley\":\"\\/\\/fonts.googleapis.com\\/css?family=Radley:regular,italic&subset=latin,latin-ext\",\"Raleway\":\"\\/\\/fonts.googleapis.com\\/css?family=Raleway:100,200,300,regular,500,600,700,800,900&subset=latin\",\"Raleway Dots\":\"\\/\\/fonts.googleapis.com\\/css?family=Raleway+Dots:regular&subset=latin,latin-ext\",\"Rambla\":\"\\/\\/fonts.googleapis.com\\/css?family=Rambla:regular,italic,700,700italic&subset=latin,latin-ext\",\"Rammetto One\":\"\\/\\/fonts.googleapis.com\\/css?family=Rammetto+One:regular&subset=latin,latin-ext\",\"Ranchers\":\"\\/\\/fonts.googleapis.com\\/css?family=Ranchers:regular&subset=latin,latin-ext\",\"Rancho\":\"\\/\\/fonts.googleapis.com\\/css?family=Rancho:regular&subset=latin\",\"Rationale\":\"\\/\\/fonts.googleapis.com\\/css?family=Rationale:regular&subset=latin\",\"Redressed\":\"\\/\\/fonts.googleapis.com\\/css?family=Redressed:regular&subset=latin\",\"Reenie Beanie\":\"\\/\\/fonts.googleapis.com\\/css?family=Reenie+Beanie:regular&subset=latin\",\"Revalia\":\"\\/\\/fonts.googleapis.com\\/css?family=Revalia:regular&subset=latin,latin-ext\",\"Ribeye\":\"\\/\\/fonts.googleapis.com\\/css?family=Ribeye:regular&subset=latin,latin-ext\",\"Ribeye Marrow\":\"\\/\\/fonts.googleapis.com\\/css?family=Ribeye+Marrow:regular&subset=latin,latin-ext\",\"Righteous\":\"\\/\\/fonts.googleapis.com\\/css?family=Righteous:regular&subset=latin,latin-ext\",\"Risque\":\"\\/\\/fonts.googleapis.com\\/css?family=Risque:regular&subset=latin,latin-ext\",\"Roboto\":\"\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Roboto Condensed\":\"\\/\\/fonts.googleapis.com\\/css?family=Roboto+Condensed:300,300italic,regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Roboto Slab\":\"\\/\\/fonts.googleapis.com\\/css?family=Roboto+Slab:100,300,regular,700&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic,vietnamese\",\"Rochester\":\"\\/\\/fonts.googleapis.com\\/css?family=Rochester:regular&subset=latin\",\"Rock Salt\":\"\\/\\/fonts.googleapis.com\\/css?family=Rock+Salt:regular&subset=latin\",\"Rokkitt\":\"\\/\\/fonts.googleapis.com\\/css?family=Rokkitt:regular,700&subset=latin\",\"Romanesco\":\"\\/\\/fonts.googleapis.com\\/css?family=Romanesco:regular&subset=latin,latin-ext\",\"Ropa Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Ropa+Sans:regular,italic&subset=latin,latin-ext\",\"Rosario\":\"\\/\\/fonts.googleapis.com\\/css?family=Rosario:regular,italic,700,700italic&subset=latin\",\"Rosarivo\":\"\\/\\/fonts.googleapis.com\\/css?family=Rosarivo:regular,italic&subset=latin,latin-ext\",\"Rouge Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Rouge+Script:regular&subset=latin\",\"Ruda\":\"\\/\\/fonts.googleapis.com\\/css?family=Ruda:regular,700,900&subset=latin,latin-ext\",\"Rufina\":\"\\/\\/fonts.googleapis.com\\/css?family=Rufina:regular,700&subset=latin,latin-ext\",\"Ruge Boogie\":\"\\/\\/fonts.googleapis.com\\/css?family=Ruge+Boogie:regular&subset=latin,latin-ext\",\"Ruluko\":\"\\/\\/fonts.googleapis.com\\/css?family=Ruluko:regular&subset=latin,latin-ext\",\"Rum Raisin\":\"\\/\\/fonts.googleapis.com\\/css?family=Rum+Raisin:regular&subset=latin,latin-ext\",\"Ruslan Display\":\"\\/\\/fonts.googleapis.com\\/css?family=Ruslan+Display:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Russo One\":\"\\/\\/fonts.googleapis.com\\/css?family=Russo+One:regular&subset=latin,latin-ext,cyrillic\",\"Ruthie\":\"\\/\\/fonts.googleapis.com\\/css?family=Ruthie:regular&subset=latin,latin-ext\",\"Rye\":\"\\/\\/fonts.googleapis.com\\/css?family=Rye:regular&subset=latin,latin-ext\",\"Sacramento\":\"\\/\\/fonts.googleapis.com\\/css?family=Sacramento:regular&subset=latin,latin-ext\",\"Sail\":\"\\/\\/fonts.googleapis.com\\/css?family=Sail:regular&subset=latin\",\"Salsa\":\"\\/\\/fonts.googleapis.com\\/css?family=Salsa:regular&subset=latin\",\"Sanchez\":\"\\/\\/fonts.googleapis.com\\/css?family=Sanchez:regular,italic&subset=latin,latin-ext\",\"Sancreek\":\"\\/\\/fonts.googleapis.com\\/css?family=Sancreek:regular&subset=latin,latin-ext\",\"Sansita One\":\"\\/\\/fonts.googleapis.com\\/css?family=Sansita+One:regular&subset=latin\",\"Sarina\":\"\\/\\/fonts.googleapis.com\\/css?family=Sarina:regular&subset=latin,latin-ext\",\"Satisfy\":\"\\/\\/fonts.googleapis.com\\/css?family=Satisfy:regular&subset=latin\",\"Scada\":\"\\/\\/fonts.googleapis.com\\/css?family=Scada:regular,italic,700,700italic&subset=latin,latin-ext,cyrillic\",\"Schoolbell\":\"\\/\\/fonts.googleapis.com\\/css?family=Schoolbell:regular&subset=latin\",\"Seaweed Script\":\"\\/\\/fonts.googleapis.com\\/css?family=Seaweed+Script:regular&subset=latin,latin-ext\",\"Sevillana\":\"\\/\\/fonts.googleapis.com\\/css?family=Sevillana:regular&subset=latin,latin-ext\",\"Seymour One\":\"\\/\\/fonts.googleapis.com\\/css?family=Seymour+One:regular&subset=latin,latin-ext,cyrillic\",\"Shadows Into Light\":\"\\/\\/fonts.googleapis.com\\/css?family=Shadows+Into+Light:regular&subset=latin\",\"Shadows Into Light Two\":\"\\/\\/fonts.googleapis.com\\/css?family=Shadows+Into+Light+Two:regular&subset=latin,latin-ext\",\"Shanti\":\"\\/\\/fonts.googleapis.com\\/css?family=Shanti:regular&subset=latin\",\"Share\":\"\\/\\/fonts.googleapis.com\\/css?family=Share:regular,italic,700,700italic&subset=latin,latin-ext\",\"Share Tech\":\"\\/\\/fonts.googleapis.com\\/css?family=Share+Tech:regular&subset=latin\",\"Share Tech Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Share+Tech+Mono:regular&subset=latin\",\"Shojumaru\":\"\\/\\/fonts.googleapis.com\\/css?family=Shojumaru:regular&subset=latin,latin-ext\",\"Short Stack\":\"\\/\\/fonts.googleapis.com\\/css?family=Short+Stack:regular&subset=latin\",\"Siemreap\":\"\\/\\/fonts.googleapis.com\\/css?family=Siemreap:regular&subset=khmer\",\"Sigmar One\":\"\\/\\/fonts.googleapis.com\\/css?family=Sigmar+One:regular&subset=latin\",\"Signika\":\"\\/\\/fonts.googleapis.com\\/css?family=Signika:300,regular,600,700&subset=latin,latin-ext\",\"Signika Negative\":\"\\/\\/fonts.googleapis.com\\/css?family=Signika+Negative:300,regular,600,700&subset=latin,latin-ext\",\"Simonetta\":\"\\/\\/fonts.googleapis.com\\/css?family=Simonetta:regular,italic,900,900italic&subset=latin,latin-ext\",\"Sintony\":\"\\/\\/fonts.googleapis.com\\/css?family=Sintony:regular,700&subset=latin,latin-ext\",\"Sirin Stencil\":\"\\/\\/fonts.googleapis.com\\/css?family=Sirin+Stencil:regular&subset=latin\",\"Six Caps\":\"\\/\\/fonts.googleapis.com\\/css?family=Six+Caps:regular&subset=latin\",\"Skranji\":\"\\/\\/fonts.googleapis.com\\/css?family=Skranji:regular,700&subset=latin,latin-ext\",\"Slackey\":\"\\/\\/fonts.googleapis.com\\/css?family=Slackey:regular&subset=latin\",\"Smokum\":\"\\/\\/fonts.googleapis.com\\/css?family=Smokum:regular&subset=latin\",\"Smythe\":\"\\/\\/fonts.googleapis.com\\/css?family=Smythe:regular&subset=latin\",\"Sniglet\":\"\\/\\/fonts.googleapis.com\\/css?family=Sniglet:800&subset=latin\",\"Snippet\":\"\\/\\/fonts.googleapis.com\\/css?family=Snippet:regular&subset=latin\",\"Snowburst One\":\"\\/\\/fonts.googleapis.com\\/css?family=Snowburst+One:regular&subset=latin,latin-ext\",\"Sofadi One\":\"\\/\\/fonts.googleapis.com\\/css?family=Sofadi+One:regular&subset=latin\",\"Sofia\":\"\\/\\/fonts.googleapis.com\\/css?family=Sofia:regular&subset=latin\",\"Sonsie One\":\"\\/\\/fonts.googleapis.com\\/css?family=Sonsie+One:regular&subset=latin,latin-ext\",\"Sorts Mill Goudy\":\"\\/\\/fonts.googleapis.com\\/css?family=Sorts+Mill+Goudy:regular,italic&subset=latin,latin-ext\",\"Source Code Pro\":\"\\/\\/fonts.googleapis.com\\/css?family=Source+Code+Pro:200,300,regular,500,600,700,900&subset=latin,latin-ext\",\"Source Sans Pro\":\"\\/\\/fonts.googleapis.com\\/css?family=Source+Sans+Pro:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,900,900italic&subset=latin,latin-ext\",\"Special Elite\":\"\\/\\/fonts.googleapis.com\\/css?family=Special+Elite:regular&subset=latin\",\"Spicy Rice\":\"\\/\\/fonts.googleapis.com\\/css?family=Spicy+Rice:regular&subset=latin\",\"Spinnaker\":\"\\/\\/fonts.googleapis.com\\/css?family=Spinnaker:regular&subset=latin,latin-ext\",\"Spirax\":\"\\/\\/fonts.googleapis.com\\/css?family=Spirax:regular&subset=latin\",\"Squada One\":\"\\/\\/fonts.googleapis.com\\/css?family=Squada+One:regular&subset=latin\",\"Stalemate\":\"\\/\\/fonts.googleapis.com\\/css?family=Stalemate:regular&subset=latin,latin-ext\",\"Stalinist One\":\"\\/\\/fonts.googleapis.com\\/css?family=Stalinist+One:regular&subset=latin,latin-ext,cyrillic\",\"Stardos Stencil\":\"\\/\\/fonts.googleapis.com\\/css?family=Stardos+Stencil:regular,700&subset=latin\",\"Stint Ultra Condensed\":\"\\/\\/fonts.googleapis.com\\/css?family=Stint+Ultra+Condensed:regular&subset=latin,latin-ext\",\"Stint Ultra Expanded\":\"\\/\\/fonts.googleapis.com\\/css?family=Stint+Ultra+Expanded:regular&subset=latin,latin-ext\",\"Stoke\":\"\\/\\/fonts.googleapis.com\\/css?family=Stoke:300,regular&subset=latin,latin-ext\",\"Strait\":\"\\/\\/fonts.googleapis.com\\/css?family=Strait:regular&subset=latin\",\"Sue Ellen Francisco\":\"\\/\\/fonts.googleapis.com\\/css?family=Sue+Ellen+Francisco:regular&subset=latin\",\"Sunshiney\":\"\\/\\/fonts.googleapis.com\\/css?family=Sunshiney:regular&subset=latin\",\"Supermercado One\":\"\\/\\/fonts.googleapis.com\\/css?family=Supermercado+One:regular&subset=latin\",\"Suwannaphum\":\"\\/\\/fonts.googleapis.com\\/css?family=Suwannaphum:regular&subset=khmer\",\"Swanky and Moo Moo\":\"\\/\\/fonts.googleapis.com\\/css?family=Swanky+and+Moo+Moo:regular&subset=latin\",\"Syncopate\":\"\\/\\/fonts.googleapis.com\\/css?family=Syncopate:regular,700&subset=latin\",\"Tangerine\":\"\\/\\/fonts.googleapis.com\\/css?family=Tangerine:regular,700&subset=latin\",\"Taprom\":\"\\/\\/fonts.googleapis.com\\/css?family=Taprom:regular&subset=khmer\",\"Tauri\":\"\\/\\/fonts.googleapis.com\\/css?family=Tauri:regular&subset=latin,latin-ext\",\"Telex\":\"\\/\\/fonts.googleapis.com\\/css?family=Telex:regular&subset=latin\",\"Tenor Sans\":\"\\/\\/fonts.googleapis.com\\/css?family=Tenor+Sans:regular&subset=cyrillic-ext,latin,latin-ext,cyrillic\",\"Text Me One\":\"\\/\\/fonts.googleapis.com\\/css?family=Text+Me+One:regular&subset=latin,latin-ext\",\"The Girl Next Door\":\"\\/\\/fonts.googleapis.com\\/css?family=The+Girl+Next+Door:regular&subset=latin\",\"Tienne\":\"\\/\\/fonts.googleapis.com\\/css?family=Tienne:regular,700,900&subset=latin\",\"Tinos\":\"\\/\\/fonts.googleapis.com\\/css?family=Tinos:regular,italic,700,700italic&subset=latin\",\"Titan One\":\"\\/\\/fonts.googleapis.com\\/css?family=Titan+One:regular&subset=latin,latin-ext\",\"Titillium Web\":\"\\/\\/fonts.googleapis.com\\/css?family=Titillium+Web:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,900&subset=latin,latin-ext\",\"Trade Winds\":\"\\/\\/fonts.googleapis.com\\/css?family=Trade+Winds:regular&subset=latin\",\"Trocchi\":\"\\/\\/fonts.googleapis.com\\/css?family=Trocchi:regular&subset=latin,latin-ext\",\"Trochut\":\"\\/\\/fonts.googleapis.com\\/css?family=Trochut:regular,italic,700&subset=latin\",\"Trykker\":\"\\/\\/fonts.googleapis.com\\/css?family=Trykker:regular&subset=latin,latin-ext\",\"Tulpen One\":\"\\/\\/fonts.googleapis.com\\/css?family=Tulpen+One:regular&subset=latin\",\"Ubuntu\":\"\\/\\/fonts.googleapis.com\\/css?family=Ubuntu:300,300italic,regular,italic,500,500italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Ubuntu Condensed\":\"\\/\\/fonts.googleapis.com\\/css?family=Ubuntu+Condensed:regular&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Ubuntu Mono\":\"\\/\\/fonts.googleapis.com\\/css?family=Ubuntu+Mono:regular,italic,700,700italic&subset=greek,cyrillic-ext,latin,greek-ext,latin-ext,cyrillic\",\"Ultra\":\"\\/\\/fonts.googleapis.com\\/css?family=Ultra:regular&subset=latin\",\"Uncial Antiqua\":\"\\/\\/fonts.googleapis.com\\/css?family=Uncial+Antiqua:regular&subset=latin\",\"Underdog\":\"\\/\\/fonts.googleapis.com\\/css?family=Underdog:regular&subset=latin,latin-ext,cyrillic\",\"Unica One\":\"\\/\\/fonts.googleapis.com\\/css?family=Unica+One:regular&subset=latin,latin-ext\",\"UnifrakturCook\":\"\\/\\/fonts.googleapis.com\\/css?family=UnifrakturCook:700&subset=latin\",\"UnifrakturMaguntia\":\"\\/\\/fonts.googleapis.com\\/css?family=UnifrakturMaguntia:regular&subset=latin\",\"Unkempt\":\"\\/\\/fonts.googleapis.com\\/css?family=Unkempt:regular,700&subset=latin\",\"Unlock\":\"\\/\\/fonts.googleapis.com\\/css?family=Unlock:regular&subset=latin\",\"Unna\":\"\\/\\/fonts.googleapis.com\\/css?family=Unna:regular&subset=latin\",\"VT323\":\"\\/\\/fonts.googleapis.com\\/css?family=VT323:regular&subset=latin\",\"Vampiro One\":\"\\/\\/fonts.googleapis.com\\/css?family=Vampiro+One:regular&subset=latin,latin-ext\",\"Varela\":\"\\/\\/fonts.googleapis.com\\/css?family=Varela:regular&subset=latin,latin-ext\",\"Varela Round\":\"\\/\\/fonts.googleapis.com\\/css?family=Varela+Round:regular&subset=latin\",\"Vast Shadow\":\"\\/\\/fonts.googleapis.com\\/css?family=Vast+Shadow:regular&subset=latin\",\"Vibur\":\"\\/\\/fonts.googleapis.com\\/css?family=Vibur:regular&subset=latin\",\"Vidaloka\":\"\\/\\/fonts.googleapis.com\\/css?family=Vidaloka:regular&subset=latin\",\"Viga\":\"\\/\\/fonts.googleapis.com\\/css?family=Viga:regular&subset=latin,latin-ext\",\"Voces\":\"\\/\\/fonts.googleapis.com\\/css?family=Voces:regular&subset=latin,latin-ext\",\"Volkhov\":\"\\/\\/fonts.googleapis.com\\/css?family=Volkhov:regular,italic,700,700italic&subset=latin\",\"Vollkorn\":\"\\/\\/fonts.googleapis.com\\/css?family=Vollkorn:regular,italic,700,700italic&subset=latin\",\"Voltaire\":\"\\/\\/fonts.googleapis.com\\/css?family=Voltaire:regular&subset=latin\",\"Waiting for the Sunrise\":\"\\/\\/fonts.googleapis.com\\/css?family=Waiting+for+the+Sunrise:regular&subset=latin\",\"Wallpoet\":\"\\/\\/fonts.googleapis.com\\/css?family=Wallpoet:regular&subset=latin\",\"Walter Turncoat\":\"\\/\\/fonts.googleapis.com\\/css?family=Walter+Turncoat:regular&subset=latin\",\"Warnes\":\"\\/\\/fonts.googleapis.com\\/css?family=Warnes:regular&subset=latin,latin-ext\",\"Wellfleet\":\"\\/\\/fonts.googleapis.com\\/css?family=Wellfleet:regular&subset=latin,latin-ext\",\"Wendy One\":\"\\/\\/fonts.googleapis.com\\/css?family=Wendy+One:regular&subset=latin,latin-ext\",\"Wire One\":\"\\/\\/fonts.googleapis.com\\/css?family=Wire+One:regular&subset=latin\",\"Yanone Kaffeesatz\":\"\\/\\/fonts.googleapis.com\\/css?family=Yanone+Kaffeesatz:200,300,regular,700&subset=latin,latin-ext\",\"Yellowtail\":\"\\/\\/fonts.googleapis.com\\/css?family=Yellowtail:regular&subset=latin\",\"Yeseva One\":\"\\/\\/fonts.googleapis.com\\/css?family=Yeseva+One:regular&subset=latin,latin-ext,cyrillic\",\"Yesteryear\":\"\\/\\/fonts.googleapis.com\\/css?family=Yesteryear:regular&subset=latin\",\"Zeyada\":\"\\/\\/fonts.googleapis.com\\/css?family=Zeyada:regular&subset=latin\"}},\"nutpMetaDistribution\":\"global\",\"nutpOpenGraphURL\":\"\",\"nutpOpenGraphTitle\":\"\",\"nutpOpenGraphDescription\":\"\",\"nutpOpenGraphImage\":\"\",\"nutpFacebookAppID\":\"\",\"nutpFeedLink1\":\"\",\"nutpFeedLink1Title\":\"\",\"nutpFeedLink2\":\"\",\"nutpFeedLink2Title\":\"\",\"nutpFeedLink3\":\"\",\"nutpFeedLink3Title\":\"\",\"nutpRemoveCanonicalMeta\":\"0\",\"nutpForceLoadBootstrap\":\"0\",\"nutpCreditsName\":\"designed by Your Company Name\",\"nutpCreditsLink\":\"#\",\"nutpCopyright\":\"\",\"nutpCopyrightStartYear\":\"\",\"nutpGAID\":\"\",\"nutpGADomain\":\"\",\"nutpGoogleVerificationID\":\"\",\"nutpBingVerificationID\":\"\",\"nutpAlexaVerificationID\":\"\",\"nutpHeadTop\":\"\",\"nutpHeadBottom\":\"\",\"nutpBodyTop\":\"\",\"nutpBodyBottom\":\"\",\"colorVariations\":\"default\",\"_COLOR1_\":\"\",\"_COLOR5_\":\"\",\"_COLOR2_\":\"\",\"_COLOR3_\":\"\",\"_COLOR4_\":\"\",\"_COLOR6_\":\"\",\"sidebartabsleft\":\"LATEST COMMENTS\",\"sidebartabsmiddle\":\"TOP COMMENTERS\",\"sidebartabsright\":\"\"}', '0', ''),
('12', 'beez3', '0', '0', 'beez3 - Default', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\",\"backgroundcolor\":\"#eee\"}', '0', '');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '1', '0', '', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2011-01-01 00:00:01', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
/**ABDB**/CREATE TABLE `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) unsigned DEFAULT NULL,
  `guest` tinyint(3) unsigned DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('21', '3.5.1'),
('700', '3.10.0-2021-05-28'),
('10029', '3.6.0-2012-07-31');
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_link_modifed` (`modified_date`),
  KEY `idx_old_url` (`old_url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__postinstall_messages`  VALUES 
('1', '700', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', '1', 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', '0'),
('2', '700', 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', '1', 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', '0'),
('12', '700', 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', '0'),
('13', '700', 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', '1', 'message', '', '', '', '', '3.3.0', '0'),
('14', '700', 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', '0'),
('15', '700', 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', '0'),
('16', '700', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', '1', 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', '0'),
('17', '700', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', '0'),
('18', '700', 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', '1', 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', '0'),
('19', '700', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', '1', 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', '0'),
('20', '700', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', '0'),
('21', '700', 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', '1', 'message', '', '', '', '', '3.9.0', '0'),
('22', '700', 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', '1', 'message', '', '', '', '', '3.9.0', '0'),
('23', '700', 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', '0'),
('24', '700', 'COM_CPANEL_MSG_TEXTFILTER3919_TITLE', 'COM_CPANEL_MSG_TEXTFILTER3919_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/textfilter3919.php', 'admin_postinstall_textfilter3919_condition', '3.9.19', '0'),
('25', '700', 'COM_CPANEL_MSG_HTACCESSSVG_TITLE', 'COM_CPANEL_MSG_HTACCESSSVG_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/htaccesssvg.php', 'admin_postinstall_htaccesssvg_condition', '3.9.21', '0'),
('26', '700', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_DESCRIPTION', '', 'com_admin', '1', 'message', '', '', NULL, NULL, '3.9.22', '0'),
('27', '700', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_DESCRIPTION', 'COM_ADMIN_POSTINSTALL_MSG_BEHIND_LOAD_BALANCER_ACTION', 'com_admin', '1', 'action', 'admin://components/com_admin/postinstall/behindproxy.php', 'behindproxy_postinstall_action', 'admin://components/com_admin/postinstall/behindproxy.php', 'admin_postinstall_behindproxy_condition', '3.9.26', '0'),
('28', '700', 'COM_ADMIN_POSTINSTALL_MSG_FLOC_BLOCKER_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_FLOC_BLOCKER_DESCRIPTION', '', 'com_admin', '1', 'message', '', '', NULL, NULL, '3.9.27', '0');
/**ABDB**/CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules_menu`  VALUES 
('2', '0'),
('3', '0'),
('4', '0'),
('6', '0'),
('7', '0'),
('8', '0'),
('9', '0'),
('10', '0'),
('12', '0'),
('13', '0'),
('14', '0'),
('15', '0'),
('79', '0'),
('87', '0'),
('88', '0'),
('89', '0'),
('90', '0'),
('91', '0'),
('92', '0'),
('93', '0'),
('94', '0'),
('95', '0'),
('96', '0'),
('97', '0'),
('98', '0'),
('99', '0'),
('100', '0'),
('101', '156'),
('101', '157'),
('101', '160'),
('101', '161'),
('101', '162'),
('101', '163'),
('101', '164'),
('101', '165'),
('102', '156'),
('102', '157'),
('102', '160'),
('102', '161'),
('102', '162'),
('102', '163'),
('102', '164'),
('102', '165'),
('103', '164'),
('104', '0'),
('105', '161'),
('105', '162'),
('105', '163'),
('105', '165'),
('106', '158'),
('106', '159'),
('108', '0'),
('109', '156'),
('110', '156'),
('110', '158'),
('110', '159'),
('110', '161'),
('110', '162'),
('110', '163'),
('110', '165'),
('111', '0'),
('112', '161'),
('112', '162'),
('112', '163'),
('112', '164'),
('112', '165'),
('114', '161'),
('114', '162'),
('114', '163'),
('114', '165'),
('116', '161'),
('116', '162'),
('116', '163'),
('116', '165'),
('117', '164'),
('122', '0'),
('126', '0'),
('127', '0'),
('128', '0'),
('130', '0'),
('131', '0'),
('132', '0');
/**ABDB**/CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned DEFAULT NULL,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules`  VALUES 
('2', '0', 'Login', '', '', '1', 'login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*'),
('3', '0', 'Popular Articles', '', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('4', '0', 'Recently Added Articles', '', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('8', '0', 'Toolbar', '', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*'),
('9', '0', 'Quick Icons', '', '', '98', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*'),
('10', '280', 'Logged-in Users', '', '', '1', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*'),
('12', '0', 'Admin Menu', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*'),
('13', '0', 'Admin Submenu', '', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*'),
('14', '277', 'User Status', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*'),
('15', '0', 'Title', '', '', '1', 'title', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*'),
('79', '0', 'Multilanguage status', '', '', '3', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('87', '282', 'K2 QuickIcons (admin)', '', '', '1', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_quickicons', '3', '1', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '1', '*'),
('88', '281', 'K2 Stats (admin)', '', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_stats', '3', '1', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '1', '*'),
('89', '278', 'Multilanguage status', '', '', '4', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('90', '279', 'Multilanguage status', '', '', '5', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('91', '0', 'Joomla Version', '', '', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_version', '3', '1', '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('93', '0', 'BLOG LAYOUT', '', '', '1', 'takai-Main-Menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"blog-layout\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"column small-12 large-4 vertical-menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('94', '0', 'CATALOG LAYOUT', '', '', '1', 'takai-Main-Menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"catalog-layout\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"column small-12 large-4 vertical-menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('95', '0', 'MAGAZINE LAYOUT', '', '', '1', 'takai-Main-Menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"magazine-layout\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"column small-12 large-4 .vertical-menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('96', '0', 'K2 Categories List', '', '', '1', 'takai-Footer-Top', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"small-block-grid-2 large-block-grid-6\",\"module_usage\":\"4\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"1\",\"authors_module_category\":\"1\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"1\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('97', '0', 'Tag Cloud', '', '', '1', 'takai-Footer-Middle', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"footerTagCloud\",\"module_usage\":\"7\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"210\",\"cloud_limit\":\"20\",\"cloud_category\":[\"1\",\"2\",\"3\",\"13\",\"5\",\"6\",\"9\",\"11\",\"14\",\"17\",\"18\",\"24\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('98', '0', 'Archives', '', '', '1', 'takai-Footer-Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"footerArchives\",\"module_usage\":\"0\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"1\",\"2\",\"3\",\"13\",\"5\",\"6\",\"9\",\"11\",\"14\",\"17\",\"18\",\"24\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('99', '0', 'Search', '', '', '1', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"SideSearch sideModule\",\"module_usage\":\"6\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"1\",\"liveSearch\":\"1\",\"width\":\"20\",\"text\":\"Search K2 content...\",\"button\":\"1\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('100', '0', 'K2 Blog Calendar', '', '', '2', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"SideCalendar sideModule\",\"module_usage\":\"2\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('101', '0', 'K2 Latest Comments', '', '', '1', 'takai-Tab1', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_comments', '1', '0', '{\"moduleclass_sfx\":\"SideComments\",\"module_usage\":\"0\",\"catfilter\":\"0\",\"comments_limit\":\"4\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"0\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('102', '0', 'K2 Top Commenters', '', '', '1', 'takai-Tab2', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_comments', '1', '0', '{\"moduleclass_sfx\":\"sideCommenters\",\"module_usage\":\"1\",\"catfilter\":\"0\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"4\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('103', '0', 'Popular this month', '', '', '1', 'takai-Inner-Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"IndexPopular\",\"getTemplate\":\"Lists\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"1\",\"2\",\"40\",\"41\",\"42\",\"3\",\"13\",\"38\",\"39\",\"5\",\"32\",\"33\",\"34\",\"6\",\"29\",\"30\",\"31\",\"9\",\"26\",\"27\",\"28\",\"11\",\"35\",\"36\"],\"getChildren\":\"0\",\"itemCount\":\"4\",\"itemsOrdering\":\"hits\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"0\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"1\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"Our most popular articles of all time! We can now filter popular articles written in a specified range in the past.\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"161\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('104', '0', 'K2 Users', '', '', '1', 'takai-Index-Middle-Bottom', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_users', '1', '1', '{\"moduleclass_sfx\":\"IndexUsers\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"filter\":\"1\",\"K2UserGroup\":\"1\",\"ordering\":\"recent\",\"limit\":\"4\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"147\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"10\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"2\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('105', '0', 'BLOG AUTHORS', '', '', '1', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"BlogAuthors\",\"module_usage\":\"1\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"23\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"1\",\"category_id\":[\"23\"],\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('106', '0', 'K2 Categories list', '', '', '1', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"footerCats\",\"module_usage\":\"4\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"1\",\"authors_module_category\":\"1\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"1\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('108', '0', 'K2 User Login', '', '', '1', 'takai-login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_user', '1', '1', '{\"moduleclass_sfx\":\"k2LoginMod hide-on-small\",\"pretext\":\"\",\"posttext\":\"\",\"userGreetingText\":\"\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"161\",\"logout\":\"161\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('109', '0', 'LATEST POSTS', '', '', '1', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"latestPosts\",\"getTemplate\":\"Lists\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"2\",\"40\",\"41\",\"42\",\"3\",\"13\",\"38\",\"39\",\"5\",\"32\",\"33\",\"34\",\"6\",\"29\",\"30\",\"31\",\"9\",\"26\",\"27\",\"28\",\"11\",\"35\",\"36\"],\"getChildren\":\"1\",\"itemCount\":\"5\",\"itemsOrdering\":\"rdate\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XSmall\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"Praesent a lorem ante, at lacinia sapien. Sed sapien massa, congue et porta nec, vestibulum pellentesque odio mollis et libero.\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"161\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('110', '0', 'K2 Breadcrumbs', '', '', '1', 'takai-breadcrumbs', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"BreadCrumbsk2\",\"module_usage\":\"3\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"Home\",\"seperator\":\"\\/\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('111', '0', 'About Us ( Footer )', '', '', '1', 'takai-Footer-Left', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '0', '{\"moduleclass_sfx\":\"FooterAboutUs\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"\\t\\t\\t\\t\\t\\t<div class=\\\"disclaimer\\\">\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t<p>You\'ve already been there... Joomla! is a great content management system. In fact it\'s considered one of the best in the world. But the default article system in Joomla! is so spartan! Just a title, your content body and that\'s it. This is where K2 comes in.<\\/p>\\r\\n\\t\\t\\t\\t\\t\\t\\t\\t<a target=\\\"_blank\\\" href=\\\"http:\\/\\/getk2.org\\\">Learn more at getk2.org<\\/a>\\r\\n\\t\\t\\t\\t\\t\\t\\t<\\/div>\",\"parsePhp\":\"1\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('112', '285', '@joomlaworks', '', '', '1', 'takai-SideBarLower', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"TwitterBuzz sideModule centered-on-small\",\"module_usage\":\"8\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"0\",\"text\":\"\",\"button\":\"0\",\"imagebutton\":\"0\",\"button_text\":\"\",\"searchItemId\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":[\"0\"],\"cloud_category_recursive\":\"0\",\"customCode\":\"<a class=\\\"twitter-timeline\\\" data-height=\\\"800\\\" href=\\\"https:\\/\\/twitter.com\\/joomlaworks\\\">Tweets by joomlaworks<\\/a>\\r\\n<script async src=\\\"https:\\/\\/platform.twitter.com\\/widgets.js\\\" charset=\\\"utf-8\\\"><\\/script>\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('114', '0', 'BLOG TAG CLOUD', '', '', '6', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_tools', '1', '1', '{\"moduleclass_sfx\":\"BlogTagCloud sideModule\",\"module_usage\":\"7\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"0\",\"authors_module_category\":\"0\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"0\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"0\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"0\",\"catfilter\":\"0\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"220\",\"cloud_limit\":\"20\",\"cloud_category\":[\"23\"],\"cloud_category_recursive\":\"1\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('116', '0', 'Popular Blog Posts', '', '', '4', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"latestPosts\",\"getTemplate\":\"Lists\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"23\"],\"getChildren\":\"1\",\"itemCount\":\"5\",\"itemsOrdering\":\"hits\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XSmall\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"1\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"Praesent a lorem ante, at lacinia sapien. Sed sapien massa, congue et porta nec, vestibulum pellentesque odio mollis et libero.\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"161\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('117', '0', 'Opinions', '', '', '1', 'takai-Inner-Right', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_k2_content', '1', '1', '{\"moduleclass_sfx\":\"IndexPopular\",\"getTemplate\":\"Lists\",\"source\":\"filter\",\"catfilter\":\"1\",\"category_id\":[\"39\"],\"getChildren\":\"0\",\"itemCount\":\"4\",\"itemsOrdering\":\"rdate\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"0\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"0\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"0\",\"itemIntroText\":\"0\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemAttachments\":\"0\",\"itemTags\":\"0\",\"itemCategory\":\"0\",\"itemDateCreated\":\"0\",\"itemHits\":\"0\",\"itemReadMore\":\"0\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"0\",\"feed\":\"0\",\"itemPreText\":\"\",\"itemCustomLink\":\"1\",\"itemCustomLinkTitle\":\"See all the opinions\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"161\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('126', '0', 'LeaderBoard 728x90', '', '', '1', 'takai-Leaderboard', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_banners', '1', '0', '{\"target\":\"1\",\"count\":\"5\",\"cid\":\"1\",\"catid\":[\"3\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"hide-on-small\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('127', '0', 'Banner 300x250 (top)', '', '', '5', 'takai-SideBar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_banners', '1', '0', '{\"target\":\"1\",\"count\":\"1\",\"cid\":\"1\",\"catid\":[\"43\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"textCenter sideBanner\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('128', '0', 'Banner 300x250 (bottom)', '', '', '1', 'takai-SideBarLower', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_banners', '1', '0', '{\"target\":\"1\",\"count\":\"1\",\"cid\":\"0\",\"catid\":[\"44\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"textCenter sideBanner\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('132', '274', 'Regular Labs - Cache Cleaner', '', '', '2', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_cachecleaner', '3', '1', '', '1', '*');
/**ABDB**/CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu_types`  VALUES 
('1', '0', 'mainmenu', 'Main Menu', 'The main menu for the site', '0'),
('2', '0', 'blog-layout', 'BLOG LAYOUT', 'Top Menu', '0'),
('3', '0', 'catalog-layout', 'CATALOG LAYOUT', 'Top Menu', '0'),
('4', '0', 'magazine-layout', 'MAGAZINE LAYOUT', 'Top Menu', '0'),
('6', '0', 'hidden', 'Hidden', '', '0'),
('7', '0', 'helper_menu', 'Helper Menu', '', '0');
/**ABDB**/CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned DEFAULT NULL,
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=682 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu`  VALUES 
('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '0', '117', '0', '*', '0'),
('2', 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '1', '1', '1', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '1', '10', '0', '*', '1'),
('3', 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1'),
('4', 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', '1', '2', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1'),
('5', 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1'),
('6', 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '1', '2', '2', '4', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1'),
('7', 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '1', '1', '1', '8', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '11', '16', '0', '*', '1'),
('8', 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', '1', '7', '2', '8', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '12', '13', '0', '*', '1'),
('9', 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', '1', '7', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact-cat', '0', '', '14', '15', '0', '*', '1'),
('10', 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', '1', '1', '1', '15', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages', '0', '', '17', '20', '0', '*', '1'),
('11', 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', '1', '10', '2', '15', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-add', '0', '', '18', '19', '0', '*', '1'),
('13', 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '1', '1', '17', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '21', '26', '0', '*', '1'),
('14', 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '13', '2', '17', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '22', '23', '0', '*', '1'),
('15', 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', '1', '13', '2', '6', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds-cat', '0', '', '24', '25', '0', '*', '1'),
('16', 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', '1', '1', '1', '24', '0', '0000-00-00 00:00:00', '0', '0', 'class:redirect', '0', '', '29', '30', '0', '*', '1'),
('17', 'main', 'com_search', 'Search', '', 'Search', 'index.php?option=com_search', 'component', '1', '1', '1', '19', '0', '0000-00-00 00:00:00', '0', '0', 'class:search', '0', '', '27', '28', '0', '*', '1'),
('21', 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '1', '1', '1', '27', '0', '0000-00-00 00:00:00', '0', '0', 'class:finder', '0', '', '33', '34', '0', '*', '1'),
('23', 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', '1', '1', '1', '29', '0', '0000-00-00 00:00:00', '0', '1', 'class:tags', '0', '', '35', '36', '0', '', '1'),
('101', 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', '-2', '1', '1', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"featured_categories\":[\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"2\",\"num_columns\":\"3\",\"num_links\":\"0\",\"multi_column_order\":\"0\",\"orderby_pri\":\"\",\"orderby_sec\":\"rdate\",\"order_date\":\"\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '31', '32', '0', '*', '0'),
('142', 'mainmenu', 'Template', '2011-11-08-15-41-03', '', '2011-11-08-15-41-03', '#', 'url', '-2', '1', '1', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '39', '40', '0', '*', '0'),
('143', 'mainmenu', 'Using K2', 'using-k2', '', 'using-k2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=1', 'component', '-2', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"1\"],\"singleCatOrdering\":\"\",\"theme\":\"default\",\"catFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '41', '42', '0', '*', '0'),
('156', 'magazine-layout', 'Categories', 'categories', '', 'categories', 'index.php?option=com_k2&view=itemlist&layout=category&task=&id=', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"2\",\"40\",\"41\",\"42\",\"3\",\"13\",\"38\",\"39\",\"5\",\"32\",\"33\",\"34\",\"6\",\"29\",\"30\",\"31\",\"9\",\"26\",\"27\",\"28\",\"11\",\"35\",\"36\",\"37\"],\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"none\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"rdate\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '57', '58', '0', '*', '0'),
('157', 'magazine-layout', 'Latest Items by Selected Categories', 'latest-items-by-selected-categories', '', 'latest-items-by-selected-categories', 'index.php?option=com_k2&view=latest&layout=latest', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"source\":\"1\",\"latestItemsCols\":\"2\",\"latestItemsLimit\":\"5\",\"latestItemsDisplayEffect\":\"first\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"categoryIDs\":[\"2\",\"6\",\"5\",\"9\"],\"categoryTitle\":\"1\",\"categoryDescription\":\"0\",\"categoryImage\":\"0\",\"categoryFeed\":\"0\",\"latestItemTitle\":\"1\",\"latestItemTitleLinked\":\"1\",\"latestItemDateCreated\":\"1\",\"latestItemImage\":\"1\",\"latestItemImageSize\":\"Medium\",\"latestItemVideo\":\"1\",\"latestItemVideoWidth\":\"\",\"latestItemVideoHeight\":\"\",\"latestItemAudioWidth\":\"\",\"latestItemAudioHeight\":\"\",\"latestItemVideoAutoPlay\":\"0\",\"latestItemIntroText\":\"1\",\"latestItemCategory\":\"0\",\"latestItemTags\":\"1\",\"latestItemReadMore\":\"1\",\"latestItemCommentsAnchor\":\"1\",\"feedLink\":\"1\",\"latestItemK2Plugins\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '59', '60', '0', '*', '0'),
('158', 'catalog-layout', 'Catalog', 'catalog', '', 'catalog', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=14', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"14\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '53', '54', '0', '*', '0'),
('159', 'catalog-layout', 'Catalog Item', 'catalog-item', '', 'catalog-item', 'index.php?option=com_k2&view=item&layout=item&id=112', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '55', '56', '0', '*', '0'),
('160', 'magazine-layout', 'Latest Items by Selected Users', 'latest-items-by-selected-users', '', 'latest-items-by-selected-users', 'index.php?option=com_k2&view=latest&layout=latest', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"source\":\"0\",\"latestItemsCols\":\"2\",\"latestItemsLimit\":\"5\",\"latestItemsDisplayEffect\":\"first\",\"userIDs\":[\"43\",\"45\"],\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"0\",\"userEmail\":\"0\",\"userFeed\":\"0\",\"categoryIDs\":[\"1\"],\"categoryTitle\":\"1\",\"categoryDescription\":\"1\",\"categoryImage\":\"1\",\"categoryFeed\":\"1\",\"latestItemTitle\":\"1\",\"latestItemTitleLinked\":\"1\",\"latestItemDateCreated\":\"1\",\"latestItemImage\":\"1\",\"latestItemImageSize\":\"Medium\",\"latestItemVideo\":\"1\",\"latestItemVideoWidth\":\"\",\"latestItemVideoHeight\":\"\",\"latestItemAudioWidth\":\"\",\"latestItemAudioHeight\":\"\",\"latestItemVideoAutoPlay\":\"0\",\"latestItemIntroText\":\"1\",\"latestItemCategory\":\"1\",\"latestItemTags\":\"1\",\"latestItemReadMore\":\"1\",\"latestItemCommentsAnchor\":\"1\",\"feedLink\":\"1\",\"latestItemK2Plugins\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '61', '62', '0', '*', '0'),
('161', 'blog-layout', 'User Blog', 'user-blog', '', 'user-blog', 'index.php?option=com_k2&view=itemlist&layout=user&id=43&task=user', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"userOrdering\":\"\",\"userFeedLink\":\"1\",\"userFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '45', '46', '0', '*', '0'),
('162', 'blog-layout', 'Category Blog', 'category-blog', '', 'category-blog', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=23', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"23\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '47', '48', '0', '*', '0'),
('163', 'blog-layout', 'Items By Tag', 'items-by-tag', '', 'items-by-tag', 'index.php?option=com_k2&view=itemlist&layout=tag&tag=tech&task=tag', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"theme\":\"default\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '51', '52', '0', '*', '0'),
('164', 'mainmenu', 'Home', 'index', '', 'index', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=1', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"1\"],\"singleCatOrdering\":\"rdate\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '43', '44', '1', '*', '0'),
('165', 'blog-layout', 'Blog Entry (Item)', 'blog-entry', '', 'blog-entry', 'index.php?option=com_k2&view=item&layout=item&id=117', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '49', '50', '0', '*', '0'),
('207', 'magazine-layout', 'Item', 'item', '', 'item', 'index.php?option=com_k2&view=item&layout=item&id=96', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '63', '64', '0', '*', '0'),
('321', 'hidden', 'Site', 'site', '', 'site', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=43', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"categories\":[\"43\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '65', '66', '0', '*', '0'),
('346', 'hidden', 'Root menu for all unassigned K2 urls', 'show', '', 'show', 'index.php?option=com_k2&view=itemlist&layout=category&task=&id=', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '67', '68', '0', '*', '0'),
('475', 'helper_menu', 'Contact Us', 'contact-us', '', 'contact-us', 'index.php?option=com_contact&view=contact&id=1', 'component', '1', '1', '1', '8', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"presentation_style\":\"\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"\",\"show_name\":\"0\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '69', '70', '0', '*', '0'),
('476', 'helper_menu', 'Login', 'login', '', 'login', 'index.php?option=com_users&view=login', 'component', '1', '1', '1', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '71', '72', '0', '*', '0'),
('477', 'helper_menu', 'Profile', 'profile', '', 'profile', 'index.php?option=com_users&view=profile', 'component', '1', '1', '1', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '73', '74', '0', '*', '0'),
('478', 'helper_menu', 'Register', 'register', '', 'register', 'index.php?option=com_users&view=registration', 'component', '1', '1', '1', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '75', '76', '0', '*', '0'),
('479', 'helper_menu', 'Remind', 'remind', '', 'remind', 'index.php?option=com_users&view=remind', 'component', '1', '1', '1', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '77', '78', '0', '*', '0'),
('480', 'helper_menu', 'Reset', 'reset', '', 'reset', 'index.php?option=com_users&view=reset', 'component', '1', '1', '1', '25', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '79', '80', '0', '*', '0'),
('487', 'helper_menu', 'Search', 'search', '', 'search', 'index.php?option=com_search&view=search&searchword=', 'component', '1', '1', '1', '19', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"search_areas\":\"\",\"show_date\":\"\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '81', '82', '0', '*', '0'),
('503', 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', '1', '1', '1', '32', '0', '0000-00-00 00:00:00', '0', '1', 'class:postinstall', '0', '', '37', '38', '0', '*', '1'),
('594', 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', '1', '1', '1', '28', '0', '0000-00-00 00:00:00', '0', '1', 'class:joomlaupdate', '0', '{}', '83', '84', '0', '', '1'),
('617', 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', '1', '1', '1', '34', '0', '0000-00-00 00:00:00', '0', '1', 'class:associations', '0', '{}', '85', '86', '0', '*', '1'),
('642', 'main', 'com_weblinks', 'com-weblinks', '', 'com-weblinks', 'index.php?option=com_weblinks', 'component', '1', '1', '1', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks', '0', '{}', '87', '92', '0', '', '1'),
('643', 'main', 'com_weblinks_links', 'com-weblinks-links', '', 'com-weblinks/com-weblinks-links', 'index.php?option=com_weblinks', 'component', '1', '642', '2', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks', '0', '{}', '88', '89', '0', '', '1'),
('644', 'main', 'com_weblinks_categories', 'com-weblinks-categories', '', 'com-weblinks/com-weblinks-categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', '1', '642', '2', '21', '0', '0000-00-00 00:00:00', '0', '1', 'class:weblinks-cat', '0', '{}', '90', '91', '0', '', '1'),
('669', 'main', 'COM_K2', 'com-k2', '', 'com-k2', 'index.php?option=com_k2&view=items', 'component', '1', '1', '1', '10014', '0', '0000-00-00 00:00:00', '0', '1', '../media/k2/assets/images/backend/k2_logo_16x16.png', '0', '{}', '93', '114', '0', '', '1'),
('670', 'main', 'K2_ITEMS', 'k2-items', '', 'com-k2/k2-items', 'index.php?option=com_k2&view=items', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '94', '95', '0', '', '1'),
('671', 'main', 'K2_CATEGORIES', 'k2-categories', '', 'com-k2/k2-categories', 'index.php?option=com_k2&view=categories', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '96', '97', '0', '', '1'),
('672', 'main', 'K2_TAGS', 'k2-tags', '', 'com-k2/k2-tags', 'index.php?option=com_k2&view=tags', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '98', '99', '0', '', '1'),
('673', 'main', 'K2_COMMENTS', 'k2-comments', '', 'com-k2/k2-comments', 'index.php?option=com_k2&view=comments', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '100', '101', '0', '', '1'),
('674', 'main', 'K2_USERS', 'k2-users', '', 'com-k2/k2-users', 'index.php?option=com_k2&view=users', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '102', '103', '0', '', '1'),
('675', 'main', 'K2_USER_GROUPS', 'k2-user-groups', '', 'com-k2/k2-user-groups', 'index.php?option=com_k2&view=usergroups', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '104', '105', '0', '', '1'),
('676', 'main', 'K2_EXTRA_FIELDS', 'k2-extra-fields', '', 'com-k2/k2-extra-fields', 'index.php?option=com_k2&view=extrafields', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '106', '107', '0', '', '1'),
('677', 'main', 'K2_EXTRA_FIELD_GROUPS', 'k2-extra-field-groups', '', 'com-k2/k2-extra-field-groups', 'index.php?option=com_k2&view=extrafieldsgroups', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '108', '109', '0', '', '1'),
('678', 'main', 'K2_MEDIA_MANAGER', 'k2-media-manager', '', 'com-k2/k2-media-manager', 'index.php?option=com_k2&view=media', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '110', '111', '0', '', '1'),
('679', 'main', 'K2_INFORMATION', 'k2-information', '', 'com-k2/k2-information', 'index.php?option=com_k2&view=info', 'component', '1', '669', '2', '10014', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '112', '113', '0', '', '1'),
('681', 'main', 'COM_AKEEBA', 'com-akeeba', '', 'com-akeeba', 'index.php?option=com_akeeba', 'component', '1', '1', '1', '10029', '0', '0000-00-00 00:00:00', '0', '1', 'class:component', '0', '{}', '115', '116', '0', '', '1');
/**ABDB**/CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_access` (`access`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__languages`  VALUES 
('1', '0', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '1', '0', '1');
/**ABDB**/CREATE TABLE `#__k2_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `gender` enum('m','f','n') NOT NULL DEFAULT 'n',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `group` int(11) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userID` (`userID`),
  KEY `group` (`group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_users`  VALUES 
('2', '45', 'Andy Williams', 'm', '<p>Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis , Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis.</p>', '2.png', 'http://getk2.org', '1', '', '::1', 'localhost', ''),
('3', '44', 'John Doe', 'm', '<p>Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis ,Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis.</p>', '3.png', 'http://getk2.org', '1', '', '', '', ''),
('4', '42', 'Super User', 'm', '<p>Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis, Quisque interdum hendrerit molestie. Vestibulum adipiscing, tellus sit amet accumsan lobortis.</p>', '4.png', 'http://getk2.org', '1', '', '178.128.157.207', '178.128.157.207.dsl.dyn.forthnet.gr', ''),
('5', '46', 'Jane Doe', 'f', '<p>Vestibulum adipiscing auctor nisl, quis feugiat magna molestie id. In tincidunt consequat libero sit amet ornare. In et consectetur nibh. Curabitur libero justo.</p>', '5.png', 'http://getk2.org', '1', '', '', '', '');
/**ABDB**/CREATE TABLE `#__k2_user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `permissions` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_user_groups`  VALUES 
('1', 'Registered', '{\"comment\":\"1\",\"frontEdit\":\"0\",\"add\":\"0\",\"editOwn\":\"0\",\"editAll\":\"0\",\"publish\":\"0\",\"inheritance\":0,\"categories\":\"all\"}'),
('2', 'Site Owner', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"inheritance\":1,\"categories\":\"all\"}');
/**ABDB**/CREATE TABLE `#__k2_tags_xref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagID` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tagID` (`tagID`),
  KEY `itemID` (`itemID`)
) ENGINE=InnoDB AUTO_INCREMENT=792 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_tags_xref`  VALUES 
('7', '1', '74'),
('43', '4', '111'),
('44', '4', '112'),
('48', '13', '95'),
('49', '6', '95'),
('53', '15', '94'),
('54', '13', '94'),
('55', '16', '94'),
('56', '17', '93'),
('57', '18', '93'),
('58', '19', '93'),
('59', '5', '92'),
('60', '2', '92'),
('61', '20', '91'),
('62', '21', '91'),
('63', '22', '91'),
('64', '23', '91'),
('65', '24', '90'),
('66', '25', '90'),
('67', '26', '89'),
('68', '15', '89'),
('69', '7', '88'),
('70', '27', '88'),
('71', '28', '88'),
('72', '29', '87'),
('73', '30', '87'),
('74', '7', '87'),
('75', '31', '86'),
('76', '32', '86'),
('77', '7', '86'),
('78', '33', '85'),
('79', '13', '85'),
('80', '7', '85'),
('81', '7', '84'),
('82', '34', '84'),
('83', '35', '84'),
('84', '7', '83'),
('85', '36', '83'),
('86', '37', '83'),
('87', '1', '79'),
('88', '38', '79'),
('89', '39', '79'),
('90', '1', '80'),
('91', '40', '80'),
('92', '41', '80'),
('93', '7', '81'),
('94', '42', '81'),
('95', '43', '81'),
('96', '7', '82'),
('97', '30', '82'),
('98', '44', '82'),
('99', '1', '78'),
('100', '41', '78'),
('101', '45', '78'),
('102', '1', '77'),
('103', '46', '77'),
('104', '47', '77'),
('105', '1', '76'),
('106', '41', '76'),
('107', '48', '76'),
('108', '49', '76'),
('109', '1', '75'),
('110', '36', '75'),
('111', '50', '75'),
('112', '1', '73'),
('113', '51', '73'),
('114', '41', '73'),
('115', '52', '72'),
('116', '53', '72'),
('117', '54', '71'),
('118', '23', '71'),
('119', '55', '70'),
('120', '56', '70'),
('121', '57', '69'),
('122', '14', '68'),
('123', '58', '68'),
('124', '53', '68'),
('125', '59', '64'),
('126', '60', '64'),
('127', '13', '64'),
('128', '61', '63'),
('129', '62', '63'),
('130', '63', '62'),
('131', '64', '62'),
('132', '61', '62'),
('133', '65', '61'),
('134', '66', '61'),
('135', '67', '61'),
('136', '68', '61'),
('137', '69', '60'),
('138', '64', '60'),
('139', '70', '59'),
('140', '64', '59'),
('141', '71', '32'),
('142', '72', '32'),
('143', '73', '31'),
('144', '74', '30'),
('145', '38', '29'),
('146', '48', '29'),
('147', '75', '29'),
('148', '76', '29'),
('149', '77', '28'),
('150', '78', '28'),
('151', '73', '26'),
('152', '79', '26'),
('153', '80', '25'),
('154', '81', '25'),
('155', '72', '25'),
('156', '82', '27'),
('157', '48', '27'),
('158', '51', '27'),
('159', '38', '27'),
('183', '1', '136'),
('184', '51', '136'),
('185', '41', '136'),
('186', '1', '135'),
('187', '1', '134'),
('188', '36', '134'),
('189', '50', '134'),
('190', '1', '133'),
('191', '41', '133'),
('192', '48', '133'),
('193', '49', '133'),
('194', '1', '132'),
('195', '46', '132'),
('196', '47', '132'),
('197', '1', '131'),
('198', '41', '131'),
('199', '45', '131'),
('200', '1', '130'),
('201', '38', '130'),
('202', '39', '130'),
('203', '1', '129'),
('204', '40', '129'),
('205', '41', '129'),
('229', '41', '137'),
('230', '51', '137'),
('231', '1', '137'),
('232', '1', '138'),
('233', '50', '139'),
('234', '36', '139'),
('235', '1', '139'),
('236', '49', '140'),
('237', '48', '140'),
('238', '41', '140'),
('239', '1', '140'),
('240', '47', '141'),
('241', '46', '141'),
('242', '1', '141'),
('243', '45', '142'),
('244', '41', '142'),
('245', '1', '142'),
('246', '39', '143'),
('247', '38', '143'),
('248', '1', '143'),
('249', '41', '144'),
('250', '40', '144'),
('251', '1', '144'),
('327', '59', '153'),
('328', '60', '153'),
('329', '13', '153'),
('330', '61', '154'),
('331', '62', '154'),
('332', '63', '155'),
('333', '64', '155'),
('334', '61', '155'),
('335', '65', '156'),
('336', '66', '156'),
('337', '67', '156'),
('338', '68', '156'),
('339', '69', '157'),
('340', '64', '157'),
('341', '70', '158'),
('342', '64', '158'),
('375', '13', '168'),
('376', '60', '168'),
('377', '59', '168'),
('378', '62', '167'),
('379', '61', '167'),
('380', '61', '166'),
('381', '64', '166'),
('382', '63', '166'),
('383', '68', '165'),
('384', '67', '165'),
('385', '66', '165'),
('386', '65', '165'),
('387', '64', '164'),
('388', '69', '164'),
('389', '64', '163'),
('390', '70', '163'),
('391', '59', '169'),
('392', '60', '169'),
('393', '13', '169'),
('394', '61', '170'),
('395', '62', '170'),
('396', '63', '171'),
('397', '64', '171'),
('398', '61', '171'),
('399', '65', '172'),
('400', '66', '172'),
('401', '67', '172'),
('402', '68', '172'),
('403', '69', '173'),
('404', '64', '173'),
('405', '70', '174'),
('406', '64', '174'),
('407', '83', '179'),
('408', '84', '179'),
('409', '84', '180'),
('414', '89', '184'),
('415', '90', '184'),
('416', '88', '183'),
('419', '85', '181'),
('420', '86', '182'),
('421', '87', '182'),
('422', '91', '193'),
('423', '92', '193'),
('424', '93', '193'),
('425', '94', '194'),
('426', '95', '194'),
('427', '92', '195'),
('428', '96', '195'),
('429', '97', '195'),
('430', '98', '196'),
('431', '91', '196'),
('432', '99', '197'),
('433', '100', '197'),
('434', '101', '197'),
('435', '102', '198'),
('436', '103', '198'),
('437', '104', '198'),
('438', '91', '199'),
('439', '97', '199'),
('440', '105', '199'),
('441', '96', '199'),
('447', '106', '200'),
('448', '99', '200'),
('449', '100', '200'),
('450', '92', '200'),
('451', '108', '200'),
('452', '109', '185'),
('453', '110', '185'),
('454', '111', '185'),
('474', '71', '201'),
('475', '72', '201'),
('476', '73', '202'),
('477', '112', '202'),
('478', '113', '202'),
('479', '114', '203'),
('480', '115', '203'),
('481', '116', '203'),
('482', '38', '204'),
('483', '48', '204'),
('484', '75', '204'),
('485', '76', '204'),
('486', '71', '204'),
('487', '77', '205'),
('488', '78', '205'),
('489', '117', '205'),
('490', '82', '206'),
('491', '48', '206'),
('492', '51', '206'),
('493', '38', '206'),
('494', '73', '207'),
('495', '79', '207'),
('496', '80', '208'),
('497', '81', '208'),
('498', '72', '208'),
('499', '91', '208'),
('530', '118', '209'),
('531', '41', '209'),
('532', '119', '210'),
('533', '120', '210'),
('534', '121', '210'),
('535', '38', '211'),
('536', '51', '211'),
('537', '48', '211'),
('538', '82', '211'),
('545', '122', '212'),
('546', '123', '212'),
('547', '76', '213'),
('548', '75', '213'),
('549', '48', '213'),
('550', '38', '213'),
('551', '71', '213'),
('565', '72', '216'),
('566', '71', '216'),
('567', '128', '216'),
('568', '41', '216'),
('569', '129', '216'),
('570', '116', '216'),
('571', '125', '215'),
('572', '126', '215'),
('573', '127', '215'),
('574', '8', '215'),
('575', '114', '214'),
('576', '116', '214'),
('577', '124', '214'),
('607', '130', '217'),
('608', '131', '217'),
('613', '132', '218'),
('614', '133', '218'),
('615', '124', '218'),
('619', '134', '220'),
('620', '135', '220'),
('621', '132', '220'),
('622', '136', '221'),
('623', '135', '221'),
('624', '137', '221'),
('625', '138', '222'),
('626', '139', '222'),
('627', '140', '223'),
('628', '141', '223'),
('629', '142', '223'),
('630', '143', '224'),
('631', '135', '224'),
('632', '132', '224'),
('633', '144', '224'),
('634', '145', '224'),
('635', '8', '120'),
('636', '146', '120'),
('637', '26', '120'),
('638', '147', '120'),
('639', '24', '119'),
('640', '148', '119'),
('641', '149', '119'),
('642', '20', '118'),
('643', '23', '118'),
('644', '150', '118'),
('645', '151', '118'),
('646', '152', '118'),
('647', '2', '117'),
('648', '20', '117'),
('649', '153', '117'),
('650', '24', '116'),
('651', '18', '116'),
('652', '3', '115'),
('653', '14', '115'),
('654', '16', '115'),
('655', '154', '114'),
('656', '13', '114'),
('657', '3', '113'),
('658', '11', '113'),
('659', '155', '113'),
('660', '58', '113'),
('687', '26', '225'),
('688', '146', '225'),
('689', '8', '225'),
('690', '147', '225'),
('691', '148', '226'),
('692', '24', '226'),
('693', '149', '226'),
('694', '20', '227'),
('695', '151', '227'),
('696', '150', '227'),
('697', '23', '227'),
('698', '152', '227'),
('699', '2', '228'),
('700', '20', '228'),
('701', '153', '228'),
('702', '24', '229'),
('703', '18', '229'),
('704', '3', '230'),
('705', '14', '230'),
('706', '16', '230'),
('707', '154', '231'),
('708', '13', '231'),
('719', '124', '219'),
('720', '116', '219'),
('721', '114', '219'),
('783', '9', '96'),
('784', '156', '96'),
('785', '157', '96'),
('786', '158', '96'),
('787', '159', '96'),
('788', '3', '232'),
('789', '11', '232'),
('790', '155', '232'),
('791', '58', '232');
/**ABDB**/CREATE TABLE `#__k2_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=160 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_tags`  VALUES 
('1', 'tech', '1'),
('2', 'accident', '1'),
('3', 'blog', '1'),
('4', 'clothes', '1'),
('5', 'News', '1'),
('6', 'World', '1'),
('7', 'Travel', '1'),
('8', 'Design', '1'),
('9', 'K2', '1'),
('11', 'Religion', '1'),
('13', 'London', '1'),
('14', 'Businessman', '1'),
('15', 'Stock Photo', '1'),
('16', 'Cellphone', '1'),
('17', 'Air', '1'),
('18', 'Wind power', '1'),
('19', 'Energy', '1'),
('20', 'Toronto', '1'),
('21', 'NWO', '1'),
('22', 'Riots', '1'),
('23', 'G20', '1'),
('24', 'Pollution', '1'),
('25', 'Climate Change', '1'),
('26', 'Train', '1'),
('27', 'Greece', '1'),
('28', 'Summer', '1'),
('29', 'Antiques', '1'),
('30', 'Traditional', '1'),
('31', 'Paris', '1'),
('32', 'Eifel Tower', '1'),
('33', 'Thames River', '1'),
('34', 'Desert', '1'),
('35', 'Camels', '1'),
('36', 'Photography', '1'),
('37', 'Valley', '1'),
('38', 'Gadgets', '1'),
('39', 'Windows Phone', '1'),
('40', 'iMAc', '1'),
('41', 'Apple', '1'),
('42', 'Beach', '1'),
('43', 'Paradise', '1'),
('44', 'Village', '1'),
('45', 'Macbook', '1'),
('46', 'Facebook', '1'),
('47', 'Social Media', '1'),
('48', 'iPhone', '1'),
('49', '3gs', '1'),
('50', 'Nikon', '1'),
('51', 'iPod', '1'),
('52', 'Despair', '1'),
('53', 'Crisis', '1'),
('54', 'Finance', '1'),
('55', 'Purse', '1'),
('56', 'Markets', '1'),
('57', 'Skirt', '1'),
('58', 'Italy', '1'),
('59', 'Horse Racing', '1'),
('60', 'England', '1'),
('61', 'Win', '1'),
('62', 'Football', '1'),
('63', 'Porche', '1'),
('64', 'Race', '1'),
('65', 'Edmilson', '1'),
('66', 'Barcelona', '1'),
('67', 'Celtic', '1'),
('68', 'Nakamura', '1'),
('69', 'Cycling', '1'),
('70', 'Marathon', '1'),
('71', 'Office', '1'),
('72', 'Decoration', '1'),
('73', 'Typography', '1'),
('74', 'Interior Design', '1'),
('75', 'Pens', '1'),
('76', 'Watches', '1'),
('77', 'Present', '1'),
('78', 'Kids', '1'),
('79', 'Thank You', '1'),
('80', 'Asthetic', '1'),
('81', 'Chairs', '1'),
('82', 'Magazines', '1'),
('83', 'Brad Pitt', '1'),
('84', 'Action', '1'),
('85', 'Historic', '1'),
('86', 'Antonio Banderas', '1'),
('87', 'Drama', '1'),
('88', 'Romantic', '1'),
('89', 'Historical', '1'),
('90', 'Biography', '1'),
('91', 'Bar', '1'),
('92', 'Chill Out', '1'),
('93', 'Drinks', '1'),
('94', 'Disco', '1'),
('95', 'Music', '1'),
('96', 'Relax', '1'),
('97', 'Jazz', '1'),
('98', 'Loud Music', '1'),
('99', 'DJ', '1'),
('100', 'House', '1'),
('101', 'Dance', '1'),
('102', 'Rock', '1'),
('103', 'Beers', '1'),
('104', 'Guitars', '1'),
('105', 'Blues', '1'),
('106', 'Hitech', '1'),
('108', 'Lounge Music', '1'),
('109', 'Lounge Bar', '1'),
('110', 'Quality', '1'),
('111', 'Luxury', '1'),
('112', 'Wall', '1'),
('113', 'Tapestry', '1'),
('114', 'Home', '1'),
('115', 'Bedroom', '1'),
('116', 'Minimal', '1'),
('117', 'Gifts', '1'),
('118', 'iPad', '1'),
('119', 'Laptop', '1'),
('120', 'Linux', '1'),
('121', 'Ubuntu', '1'),
('122', 'Sony', '1'),
('123', 'Mp3 Player', '1'),
('124', 'Lights', '1'),
('125', 'LCD', '1'),
('126', 'TV', '1'),
('127', 'Led tv', '1'),
('128', 'Mac', '1'),
('129', 'Library', '1'),
('130', 'Berlin', '1'),
('131', 'Brademburg Gate', '1'),
('132', 'Skyscrapers', '1'),
('133', 'Night', '1'),
('134', 'New York', '1'),
('135', 'USA', '1'),
('136', 'Bridge', '1'),
('137', 'Skyscr', '1'),
('138', 'Classical', '1'),
('139', 'Monument', '1'),
('140', 'Australia', '1'),
('141', 'Opera', '1'),
('142', 'Modern', '1'),
('143', 'LA', '1'),
('144', 'Avenues', '1'),
('145', 'Traffic', '1'),
('146', 'Tube', '1'),
('147', 'Metro', '1'),
('148', 'Black and White', '1'),
('149', 'Smog', '1'),
('150', 'Cops', '1'),
('151', 'Demonstration', '1'),
('152', 'Activism', '1'),
('153', 'Fire Dept', '1'),
('154', 'Rain', '1'),
('155', 'Pope', '1'),
('156', 'joomla', '1'),
('157', 'extension', '1'),
('158', 'component', '1'),
('159', 'joomlaworks', '1');
/**ABDB**/CREATE TABLE `#__k2_rating` (
  `itemID` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(11) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(11) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`itemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_rating`  VALUES 
('1', '5', '1', '37.1.223.254'),
('2', '9', '2', '37.1.223.254'),
('4', '8', '2', '37.1.223.254'),
('7', '3', '1', '37.1.223.254'),
('17', '40', '9', '188.6.100.214'),
('18', '21', '5', '41.140.24.7'),
('19', '5', '1', '68.67.52.186'),
('20', '14', '3', '119.93.6.43'),
('21', '31', '7', '195.169.153.5'),
('22', '20', '5', '82.246.167.218'),
('23', '10', '4', '113.166.56.91'),
('24', '70', '17', '151.82.107.137'),
('31', '1', '1', '37.1.223.254'),
('41', '5', '2', '95.222.198.205'),
('42', '3', '1', '88.153.184.12'),
('43', '3', '1', '189.182.182.21'),
('45', '9', '2', '109.172.14.53'),
('46', '4', '1', '70.68.18.85'),
('47', '4', '1', '89.76.209.218'),
('48', '10', '2', '78.31.63.204'),
('49', '11', '3', '194.44.173.110'),
('50', '5', '1', '117.195.219.71'),
('51', '14', '3', '95.220.170.26'),
('52', '14', '3', '208.168.229.163'),
('53', '12', '3', '31.40.47.127'),
('54', '17', '4', '114.143.85.199'),
('55', '30', '7', '122.116.181.148'),
('56', '63', '14', '77.106.98.23'),
('61', '3', '1', '37.78.206.129'),
('65', '5', '1', '193.58.255.3'),
('66', '8', '2', '178.130.42.83'),
('70', '5', '1', '37.98.75.188'),
('71', '9', '3', '81.162.242.13'),
('72', '9', '2', '46.147.240.179'),
('73', '5', '1', '188.175.139.224'),
('74', '4', '1', '46.12.47.150'),
('80', '5', '1', '80.4.138.25'),
('81', '19', '5', '46.101.38.123'),
('82', '5', '1', '178.219.29.196'),
('83', '25', '7', '46.101.38.123'),
('84', '4', '1', '2.38.40.163'),
('85', '16', '4', '213.192.60.61'),
('86', '15', '3', '189.68.210.201'),
('87', '20', '5', '188.169.241.172'),
('88', '48', '12', '91.116.148.250'),
('89', '6', '2', '91.120.104.227'),
('90', '6', '2', '201.85.33.19'),
('91', '15', '3', '93.80.113.73'),
('92', '24', '6', '24.193.59.188'),
('93', '17', '4', '77.23.40.9'),
('94', '26', '7', '91.120.104.227'),
('95', '69', '19', '188.94.32.65'),
('96', '4969', '1214', '90.242.128.34'),
('97', '5', '1', '164.127.206.73'),
('98', '12', '3', '187.72.168.60'),
('99', '4', '1', '159.50.249.148'),
('100', '51', '11', '197.225.63.199'),
('102', '17', '4', '193.77.56.159'),
('103', '66', '15', '122.50.240.86'),
('104', '76', '20', '188.126.58.58'),
('105', '4', '1', '79.216.155.82'),
('106', '68', '17', '127.0.0.1'),
('107', '9', '2', '94.164.195.152'),
('108', '11', '3', '174.56.60.136'),
('109', '21', '5', '78.234.205.15'),
('110', '13', '3', '86.204.70.173'),
('111', '60', '16', '127.0.0.1'),
('112', '416', '99', '127.0.0.1'),
('113', '4', '1', '101.63.33.68'),
('114', '5', '1', '77.29.12.109'),
('115', '11', '3', '62.178.52.127'),
('116', '5', '1', '77.29.12.109'),
('117', '122', '31', '89.252.1.174'),
('120', '10', '2', '176.120.44.9'),
('122', '7', '2', '83.6.244.146'),
('124', '5', '1', '94.21.134.234'),
('125', '23', '5', '85.15.111.108'),
('126', '5', '1', '82.31.54.159'),
('127', '14', '3', '71.207.158.47'),
('128', '11', '3', '186.112.57.130'),
('129', '36', '8', '193.34.160.67'),
('130', '9', '2', '193.243.202.58'),
('131', '5', '1', '192.162.108.82'),
('132', '9', '2', '41.85.161.126'),
('135', '2', '1', '92.118.133.28'),
('136', '11', '3', '123.138.74.87'),
('137', '18', '4', '197.205.93.45'),
('138', '5', '1', '117.6.129.220'),
('139', '6', '2', '91.207.126.66'),
('140', '14', '3', '91.207.126.66'),
('141', '4', '1', '77.2.71.220'),
('142', '9', '3', '91.207.126.66'),
('143', '11', '3', '91.207.126.66'),
('145', '9', '2', '190.188.193.189'),
('146', '9', '2', '80.239.243.93'),
('147', '4', '1', '82.136.196.67'),
('148', '3', '1', '82.136.196.67'),
('149', '5', '1', '94.241.39.162'),
('150', '10', '3', '151.24.180.220'),
('151', '10', '2', '109.188.126.178'),
('152', '26', '6', '76.183.152.225'),
('153', '10', '3', '176.112.78.146'),
('154', '14', '4', '37.255.72.213'),
('155', '5', '1', '91.44.98.130'),
('156', '7', '2', '200.29.151.130'),
('157', '5', '1', '91.44.98.130'),
('158', '7', '3', '31.8.99.252'),
('159', '9', '2', '31.8.99.252'),
('160', '5', '1', '199.106.147.10'),
('161', '25', '6', '122.179.140.231'),
('162', '5', '1', '122.179.140.231'),
('163', '5', '1', '122.179.140.231'),
('164', '1', '1', '122.179.140.231'),
('165', '6', '2', '122.179.140.231'),
('166', '4', '2', '122.179.140.231'),
('167', '6', '2', '122.179.140.231'),
('168', '7', '2', '122.179.140.231'),
('173', '5', '1', '92.244.231.166'),
('174', '4', '2', '82.127.61.197'),
('176', '10', '2', '93.115.123.172'),
('177', '11', '3', '46.32.84.32'),
('178', '21', '5', '187.66.9.57'),
('179', '5', '1', '46.32.84.32'),
('181', '10', '3', '114.31.2.244'),
('182', '1', '1', '79.166.43.108'),
('183', '3', '1', '79.165.194.5'),
('184', '9', '2', '79.166.43.108'),
('185', '8', '3', '174.113.237.37'),
('186', '13', '3', '62.178.52.127'),
('187', '4', '1', '174.113.237.37'),
('190', '9', '2', '124.6.168.225'),
('191', '5', '1', '124.6.168.225'),
('192', '5', '1', '183.82.135.160'),
('193', '36', '8', '109.192.17.85'),
('194', '18', '5', '206.248.160.60'),
('195', '10', '2', '80.243.152.129'),
('196', '5', '1', '109.52.237.44'),
('197', '16', '4', '109.188.126.178'),
('198', '16', '4', '114.130.28.82'),
('199', '11', '3', '109.188.126.178'),
('200', '19', '5', '109.188.126.178'),
('201', '16', '4', '91.79.67.215'),
('202', '10', '3', '109.152.229.180'),
('203', '12', '3', '46.205.234.131'),
('204', '3', '1', '85.170.116.255'),
('205', '5', '2', '85.170.116.255'),
('206', '7', '2', '93.40.100.234'),
('208', '8', '2', '109.12.140.11'),
('209', '11', '3', '77.43.6.162'),
('210', '9', '2', '80.245.118.26'),
('211', '13', '3', '75.71.153.103'),
('212', '16', '4', '187.113.227.104'),
('213', '8', '2', '194.24.164.6'),
('214', '9', '3', '128.78.151.38'),
('215', '14', '3', '86.124.103.68'),
('216', '13', '3', '86.124.103.68'),
('217', '79', '20', '93.85.58.118'),
('218', '114', '31', '2601:581:8100:1590:307c:8587:10f9:4fd0'),
('219', '102', '24', '141.0.12.71'),
('220', '199', '48', '85.141.66.46'),
('221', '1266', '315', '127.0.0.1'),
('222', '1785', '422', '127.0.0.1'),
('223', '386', '98', '127.0.0.1'),
('224', '677', '163', '127.0.0.1'),
('225', '47', '12', '31.147.119.220'),
('226', '141', '35', '41.13.0.8'),
('227', '136', '34', '95.187.151.223'),
('228', '22', '5', '80.11.129.3'),
('229', '159', '41', '79.173.88.20'),
('230', '96', '23', '65.248.100.253'),
('231', '404', '99', '171.97.67.76'),
('232', '600', '151', '127.0.0.1');
/**ABDB**/CREATE TABLE `#__k2_log` (
  `status` int(11) NOT NULL,
  `response` text NOT NULL,
  `timestamp` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_log`  VALUES 
('200', 'OK', '2018-08-13 14:51:19');
/**ABDB**/CREATE TABLE `#__k2_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` smallint(6) NOT NULL DEFAULT '0',
  `featured_ordering` int(11) NOT NULL DEFAULT '0',
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `created_by` (`created_by`),
  KEY `ordering` (`ordering`),
  KEY `featured` (`featured`),
  KEY `featured_ordering` (`featured_ordering`),
  KEY `hits` (`hits`),
  KEY `created` (`created`),
  KEY `language` (`language`),
  KEY `idx_item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),
  FULLTEXT KEY `search` (`title`,`introtext`,`fulltext`,`extra_fields_search`,`image_caption`,`image_credits`,`video_caption`,`video_credits`,`metadesc`,`metakey`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__k2_items`  VALUES 
('1', 'Mauris ac dolor id sapien aliquet dignissim', 'mauris-ac-dolor-id-sapien-aliquet-dignissim', '2', '1', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam dictum metus non erat gravida laoreet. Nulla facilisi. Phasellus sit amet cursus arcu. Aenean sem justo, pellentesque in fringilla et, porta in arcu.</p>\r\n', '\r\n<p>Praesent luctus ligula dapibus quam scelerisque tristique. Pellentesque tempus lorem quam, quis vestibulum erat. Nullam libero sapien, ornare ut auctor quis, dictum id dolor.</p>\r\n<p>Proin nibh tellus, mattis ac interdum ac, adipiscing vel ipsum. Phasellus nulla turpis, lobortis quis rhoncus eu, cursus a orci. Donec malesuada sodales commodo. Pellentesque molestie accumsan leo, et aliquet metus blandit at. Nam luctus tempor nisl, et porta purus feugiat nec. Donec semper turpis sit amet lectus faucibus tincidunt. Praesent facilisis justo vitae massa mollis euismod. Nunc vitae mi interdum justo semper aliquet. Vivamus imperdiet, neque eu luctus iaculis, dui magna ultrices odio, vitae posuere risus odio a quam. Maecenas ante erat, sollicitudin eu pharetra non, placerat vulputate sapien. Sed elementum nunc non purus pulvinar accumsan. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam pharetra lacus id tellus suscipit sed pellentesque massa elementum. Ut sodales faucibus adipiscing. Donec pretium leo ut lectus commodo vitae rutrum leo ornare.</p>\r\n<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>', NULL, NULL, '[]', '', '2011-11-08 13:43:26', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 13:43:26', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '932', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('2', 'Proin vitae augue vel nisi', 'proin-vitae-augue-vel-nisi', '2', '1', '<p>Proin nibh tellus, mattis ac interdum ac, adipiscing vel ipsum. Phasellus nulla turpis, lobortis quis rhoncus eu, cursus a orci. Donec malesuada sodales commodo. Pellentesque molestie accumsan leo, et aliquet metus blandit at.</p>\r\n', '\r\n<p>Nam luctus tempor nisl, et porta purus feugiat nec. Donec semper turpis sit amet lectus faucibus tincidunt. Praesent facilisis justo vitae massa mollis euismod. Nunc vitae mi interdum justo semper aliquet. Vivamus imperdiet, neque eu luctus iaculis, dui magna ultrices odio, vitae posuere risus odio a quam. Maecenas ante erat, sollicitudin eu pharetra non, placerat vulputate sapien. Sed elementum nunc non purus pulvinar accumsan. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam pharetra lacus id tellus suscipit sed pellentesque massa elementum. Ut sodales faucibus adipiscing. Donec pretium leo ut lectus commodo vitae rutrum leo ornare.</p>\r\n<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>\r\n<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus. Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>', NULL, NULL, '[]', '', '2011-11-08 14:07:40', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:07:40', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '4292', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('3', 'Pellentesque adipiscing nisi quis', 'pellentesque-adipiscing-nisi-quis', '2', '1', '<p>Ut auctor sollicitudin metus, sed lobortis mauris pulvinar vitae. Etiam nec justo neque. Mauris ac dolor id sapien aliquet dignissim. Aliquam mollis ligula accumsan nibh posuere quis dignissim mi eleifend.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. In condimentum, purus ac gravida vestibulum, metus mauris rhoncus massa, id eleifend turpis eros consectetur erat. Vivamus adipiscing faucibus auctor. Ut facilisis turpis a magna pharetra ac aliquam est rutrum. Donec nisl sem, tincidunt feugiat mollis sit amet, pretium nec justo. Proin vitae augue vel nisi pulvinar mattis eu non ligula.</p>\r\n<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus. Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>\r\n<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa. Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>', NULL, NULL, '[]', '', '2011-11-08 14:08:27', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:08:27', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '1022', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('4', 'Fusce massa sem, venenatis sed', 'fusce-massa-sem-venenatis-sed', '2', '1', '<p>Etiam mattis risus eget ipsum mollis tincidunt facilisis mauris pellentesque. Morbi ut mi vel erat consectetur vestibulum. Aliquam fringilla, lectus eget euismod elementum, orci purus molestie sem, sed vestibulum dui lorem feugiat purus.</p>\r\n', '\r\n<p>Nulla facilisi. Curabitur cursus sagittis urna sit amet eleifend. Maecenas mattis lacinia ornare. Sed non mattis eros. Nulla eu odio elit, vitae laoreet erat. Nullam urna tortor, tincidunt interdum condimentum iaculis, fermentum quis purus. Vestibulum et lectus sagittis quam egestas laoreet. Proin venenatis viverra semper. Praesent eu dui nunc. Integer volutpat magna quis justo dictum a molestie eros posuere. Pellentesque adipiscing nisi quis orci imperdiet vitae gravida erat semper.</p>\r\n<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa. Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>\r\n<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas. Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>', NULL, NULL, '[]', '', '2011-11-08 14:09:09', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:09:09', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '733', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('5', 'Praesent luctus volutpat dui', 'praesent-luctus-volutpat-dui', '2', '1', '<p>Vivamus interdum ultrices tellus eget rutrum. Vestibulum eu orci massa, eget condimentum orci. Fusce massa sem, venenatis sed rutrum quis, tristique at turpis. Maecenas sed risus vitae nisl gravida ultricies id in massa.</p>\r\n', '\r\n<p>Vivamus quis augue orci. Morbi rutrum adipiscing iaculis. Mauris mattis turpis ac augue fermentum interdum. Vestibulum consectetur sollicitudin ligula, eget fermentum ante ultricies sed. Etiam blandit mauris vitae enim tristique dignissim.</p>\r\n<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas. Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>\r\n<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus. Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>', NULL, NULL, '[]', '', '2011-11-08 14:10:41', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 14:10:41', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '724', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('6', 'In hac habitasse platea dictumst', 'in-hac-habitasse-platea-dictumst', '2', '1', '<p>Ut eu sodales odio. Vivamus viverra dui id magna tempor nec commodo massa elementum. Proin nibh libero, hendrerit eu rhoncus in, suscipit vulputate nisl. Praesent sollicitudin orci vitae lorem consectetur egestas.</p>\r\n', '\r\n<p>Integer varius enim eget lacus vestibulum sit amet suscipit sem mollis. Mauris malesuada, dolor non accumsan facilisis, nibh massa rutrum quam, ac molestie odio metus et sem. Proin congue elit sed ante porta eu dapibus sapien suscipit. Nulla nibh ligula, tincidunt vitae mollis non, placerat vel risus. Nam tincidunt nulla ac elit imperdiet blandit. Nulla facilisi. Nulla bibendum sem ac lectus tincidunt consectetur. Nulla facilisi. Mauris purus eros, scelerisque in suscipit et, elementum a leo. Nulla varius tempus libero non posuere. Etiam a lacus magna.</p>\r\n<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus. Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>\r\n<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra. Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>', NULL, NULL, '[]', '', '2011-11-08 14:11:45', '44', '', '0', '0000-00-00 00:00:00', '2011-11-08 14:16:23', '43', '2011-11-08 14:11:45', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '610', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('7', 'Cras tincidunt ante et mi eleifend sollicitudin', 'cras-tincidunt-ante-et-mi-eleifend-sollicitudin', '2', '1', '<p>Ut suscipit varius mauris vel imperdiet. Nulla ac purus porta ante ornare fermentum quis eget ligula. Praesent luctus volutpat dui, a suscipit nunc euismod porta. Ut lobortis, nisi sit amet vehicula pretium, dolor dolor laoreet ipsum, id placerat sapien erat a metus.</p>\r\n', '\r\n<p>Praesent at nunc lorem, at ultricies dolor. Suspendisse hendrerit sagittis euismod. Fusce condimentum convallis tortor, nec venenatis arcu sodales vel. Nullam sit amet nisl velit. Integer vitae mi est, vitae semper magna. Nunc massa est, semper quis auctor in, pharetra ut ipsum. Nulla facilisi.</p>\r\n<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra. Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>\r\n<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla. Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>', NULL, NULL, '[]', '', '2011-11-08 14:12:39', '44', '', '0', '0000-00-00 00:00:00', '2011-11-08 14:16:46', '43', '2011-11-08 14:12:39', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '581', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('8', 'Vestibulum bibendum blandit augue', 'vestibulum-bibendum-blandit-augue', '2', '1', '<p>Nulla faucibus quam a nulla aliquet mollis. Duis metus felis, vestibulum in fermentum ut, dignissim vel libero. In hac habitasse platea dictumst. Cras magna dui, rhoncus ut accumsan sed, auctor a eros. Donec ut tellus a lacus venenatis viverra.</p>\r\n', '\r\n<p>Aenean sit amet odio nec enim vestibulum luctus non et lorem. Integer porta sollicitudin lectus vel volutpat. Vestibulum faucibus iaculis magna.</p>\r\n<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla. Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>\r\n<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus. Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p> </p>', '{vimeo}3741976{/vimeo}', '{gallery}http://www.flickr.com/photos/audiusa/sets/72157624537648429/{/gallery}', '[]', '', '2011-11-08 14:13:20', '44', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:53:57', '43', '2011-11-08 14:13:20', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '900', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('9', 'Donec suscipit purus eget turpis laoreet ornare', 'donec-suscipit-purus-eget-turpis-laoreet-ornare', '3', '1', '<p>Donec odio nisi, vestibulum ac iaculis id, mattis id elit. Morbi semper fringilla lacus ac hendrerit. Cras tincidunt ante et mi eleifend sollicitudin. Pellentesque nulla erat, pulvinar non condimentum in, elementum id nulla.</p>\r\n', '\r\n<p>Nam ornare interdum tortor id pretium. Integer luctus neque sit amet mauris semper mattis. Praesent sed lectus quis elit sodales euismod. Donec tincidunt nibh non sapien bibendum adipiscing. Suspendisse volutpat euismod lorem non rhoncus.</p>\r\n<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus. Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus. Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>', '{vimeo}9011666{/vimeo}', '{gallery}http://www.flickr.com/photos/worldeconomicforum/sets/72157603708578538/{/gallery}', '[]', '', '2011-11-08 14:14:14', '44', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:54:46', '43', '2011-11-08 14:14:14', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '733', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('10', 'Quisque est est, porttitor a scelerisque vitae', 'quisque-est-est-porttitor-a-scelerisque-vitae', '3', '1', '<p>Sed pulvinar justo ac eros aliquam aliquam. Cras adipiscing lacus a libero tristique ac porttitor odio malesuada. Aliquam faucibus fringilla congue. Nullam sed lorem dolor. Phasellus enim elit, vulputate et ornare quis, aliquet vitae tellus.</p>\r\n', '\r\n<p>Morbi enim nibh, condimentum a congue id, molestie nec est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum bibendum blandit augue, sit amet ultricies erat aliquet sit amet. Donec suscipit purus eget turpis laoreet ornare. Morbi egestas tellus in nulla porttitor faucibus consectetur nisi porta. Duis eros felis, ultricies nec venenatis quis, malesuada ac sapien. Curabitur est felis, dapibus sit amet imperdiet pharetra, pulvinar quis ligula. Donec semper scelerisque libero. Maecenas magna metus, fringilla ac laoreet eu, eleifend at arcu. Pellentesque laoreet rhoncus ipsum, nec congue dolor consectetur a.</p>\r\n<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus. Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>\r\n<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus. Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>', NULL, NULL, '[]', '', '2011-11-08 15:43:06', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:43:06', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '717', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('11', 'Duis malesuada metus pellentesque', 'duis-malesuada-metus-pellentesque', '3', '1', '<p>Fusce bibendum sollicitudin mauris, et tempus mi tempor id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin imperdiet malesuada leo sit amet venenatis. Etiam at lorem turpis. Nunc porttitor mollis bibendum. Nullam sagittis hendrerit rhoncus.</p>\r\n', '\r\n<p>Sed erat dolor, sagittis non varius sed, mollis luctus orci. Nam at massa id ipsum gravida pretium in vel turpis. Curabitur sed eros eget purus tempor sollicitudin. Aliquam interdum rhoncus libero id faucibus. Sed tortor neque, auctor eu facilisis tincidunt, faucibus sit amet sapien. Fusce eget ligula enim.</p>\r\n<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus. Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>\r\n<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi. Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>', NULL, NULL, '[]', '', '2011-11-08 15:43:56', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:43:56', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '705', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('12', 'Curabitur pulvinar mollis lectus', 'curabitur-pulvinar-mollis-lectus', '3', '1', '<p>Donec sit amet justo sit amet dui malesuada sollicitudin non eget diam. In eleifend, massa condimentum semper pellentesque, tellus elit rhoncus dui, sit amet facilisis lacus est a eros. Vestibulum iaculis neque a arcu ultrices a rutrum eros rhoncus.</p>\r\n', '\r\n<p>Maecenas vel odio tortor, sed condimentum mi. Morbi vitae metus sed ipsum suscipit lacinia non vitae eros. Quisque est est, porttitor a scelerisque vitae, pharetra id turpis. Phasellus ut est feugiat velit iaculis lobortis. Quisque blandit viverra metus, eu pretium purus dapibus at. Fusce convallis lacus eu enim sollicitudin quis feugiat odio aliquet. Duis malesuada metus pellentesque enim consectetur sit amet varius urna volutpat.</p>\r\n<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi. Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>\r\n<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor. Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>', NULL, NULL, '[]', '', '2011-11-08 15:44:40', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:44:40', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '835', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('13', 'Nam est nisl, elementum et vulputate id', 'nam-est-nisl-elementum-et-vulputate-id', '3', '1', '<p>Sed dapibus, diam a ullamcorper tincidunt, mi eros fringilla ante, quis euismod mauris eros pretium dui. Vestibulum condimentum, lacus et congue eleifend, nisl lorem commodo ante, non venenatis turpis dolor id dolor. Maecenas rhoncus nisl a lorem eleifend viverra et placerat nisi.</p>\r\n', '\r\n<p>Maecenas nec aliquam tellus. Mauris augue augue, cursus eu commodo et, dictum eu nulla. Ut ac enim id velit vehicula sodales. Sed vel nisl eu arcu posuere facilisis. Cras erat mauris, venenatis eget mattis at, consequat a mauris.</p>\r\n<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor. Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>\r\n<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>', NULL, NULL, '[]', '', '2011-11-08 15:45:16', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:45:16', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '808', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('14', 'Mauris congue convallis placerat', 'mauris-congue-convallis-placerat', '3', '1', '<p>Morbi euismod viverra neque, in laoreet velit interdum sed. Curabitur pulvinar mollis lectus, sit amet scelerisque ipsum mattis nec. Duis ut libero non libero bibendum vestibulum. Duis ac massa ut magna hendrerit consectetur. Suspendisse potenti. Nulla facilisi. Cras tempor nibh at eros placerat porttitor.</p>\r\n', '\r\n<p>Duis molestie convallis gravida. Sed vel enim sed erat adipiscing vulputate. Aenean sed risus odio. Morbi sollicitudin consequat lorem at bibendum. Vestibulum rutrum viverra viverra. Integer hendrerit, est vel viverra feugiat, dolor purus fermentum erat, volutpat scelerisque sapien erat vel augue. Nam est nisl, elementum et vulputate id, feugiat eu lorem. Pellentesque ipsum tortor, imperdiet vel lobortis non, pulvinar at ipsum. Curabitur eu nibh tincidunt orci posuere eleifend.</p>\r\n<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>\r\n<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque. Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>', NULL, NULL, '[]', '', '2011-11-08 15:46:36', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:46:36', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '761', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('15', 'Nullam a ante leo, at iaculis lectus', 'nullam-a-ante-leo-at-iaculis-lectus', '3', '1', '<p>Suspendisse ultricies magna in ipsum mattis tincidunt eu vitae felis. Mauris congue convallis placerat. In non velit ante, nec porttitor mi. Aenean id lacinia quam. Vestibulum ut elit libero, sed tincidunt arcu. Sed euismod lacus et nibh volutpat sodales. Aliquam eu elementum augue. Phasellus odio felis, ornare eu laoreet ut, ultricies id enim. Praesent et turpis sapien. Cras ac varius odio.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque. Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>\r\n<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>', NULL, NULL, '[]', '', '2011-11-08 15:47:19', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:47:19', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '690', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('16', 'Donec id purus vitae massa', 'donec-id-purus-vitae-massa', '3', '1', '<p>Vivamus eros turpis, pulvinar ut malesuada in, commodo et metus. Praesent quis dignissim odio. Aliquam in ligula non lorem lobortis ultrices ut in mauris. Donec non ante sit amet felis gravida suscipit. Praesent porta imperdiet mauris non pellentesque.</p>\r\n', '\r\n<p>Proin consectetur egestas tortor, rhoncus bibendum ante commodo nec. Sed dictum rutrum porttitor. Quisque rutrum libero non ligula pellentesque quis tempus odio gravida. Pellentesque iaculis convallis dolor sit amet consequat. Pellentesque convallis enim in nulla facilisis consequat. Nullam a ante leo, at iaculis lectus. Nam tristique tempus nibh, fringilla faucibus felis mollis quis. Praesent ac tellus vel turpis consequat dictum. Donec orci lorem, aliquam id porta vel, blandit non purus. Fusce luctus nisi vel quam egestas ac iaculis felis ornare.</p>\r\n<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>\r\n<p>Duis lobortis aliquet sem vitae suscipit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut tristique nulla ac quam scelerisque a egestas erat placerat. Vestibulum erat erat, dictum vel molestie eu, pretium sit amet ante. Cras volutpat placerat leo eu lobortis. Aenean pharetra, eros pretium scelerisque viverra, velit est iaculis massa, ac viverra turpis tortor ut leo. Aenean rhoncus est et nisl faucibus sed sodales elit iaculis. Cras congue leo et ante elementum sit amet rhoncus turpis tincidunt.</p>', NULL, NULL, '[]', '', '2011-11-08 15:48:30', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 15:48:30', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '827', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('17', 'Duis et lectus non ante elementum', 'duis-et-lectus-non-ante-elementum', '40', '1', '<p>Mauris sapien velit, aliquet et sagittis quis, pretium ac erat. Ut blandit sapien ac nibh varius aliquam ut sit amet mauris. In in erat sit amet leo molestie interdum ut et magna. Quisque non velit vel nisi mollis fringilla. Curabitur in ultricies sapien. Morbi ut pretium odio. Phasellus facilisis tortor ac orci faucibus vehicula. Donec id purus vitae massa pretium ornare laoreet quis eros.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Duis lobortis aliquet sem vitae suscipit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Ut tristique nulla ac quam scelerisque a egestas erat placerat. Vestibulum erat erat, dictum vel molestie eu, pretium sit amet ante. Cras volutpat placerat leo eu lobortis. Aenean pharetra, eros pretium scelerisque viverra, velit est iaculis massa, ac viverra turpis tortor ut leo. Aenean rhoncus est et nisl faucibus sed sodales elit iaculis. Cras congue leo et ante elementum sit amet rhoncus turpis tincidunt.</p>\r\n<p>Integer ultrices velit ligula, vel interdum massa. Integer ullamcorper nunc eu mi mattis suscipit. Integer tempus nisl nec elit rhoncus vehicula. Praesent sem mi, scelerisque vitae blandit sit amet, mattis eget nisi. Proin blandit ultricies magna, id tincidunt est faucibus at. Vestibulum in nisl nisl. Vivamus vulputate enim vitae nunc ultrices pulvinar. Duis vel libero et enim ultricies vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque et iaculis tellus.</p>\r\n<p>Suspendisse euismod nisi vitae odio pellentesque aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Maecenas posuere accumsan rhoncus. Integer lobortis enim non arcu ultricies accumsan. Nulla nec libero non ipsum vulputate tincidunt. Aliquam ullamcorper ullamcorper mi id posuere. Duis porttitor, nunc ac tincidunt consectetur, neque urna laoreet tortor, rutrum consectetur urna metus at justo. Morbi sit amet urna vel est fringilla tristique non quis lectus. Duis et lectus non ante elementum tincidunt eu in mi. Proin velit lacus, tempus nec molestie quis, iaculis sit amet neque. </p>', NULL, NULL, '[]', '', '2011-11-08 16:21:58', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:21:58', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '1035', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('18', 'Nunc feugiat viverra lorem quis tincidunt', 'nunc-feugiat-viverra-lorem-quis-tincidunt', '40', '1', '<p>Suspendisse euismod nisi vitae odio pellentesque aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Maecenas posuere accumsan rhoncus. Integer lobortis enim non arcu ultricies accumsan. Nulla nec libero non ipsum vulputate tincidunt. Aliquam ullamcorper ullamcorper mi id posuere.</p>\r\n', '\r\n<p>Duis porttitor, nunc ac tincidunt consectetur, neque urna laoreet tortor, rutrum consectetur urna metus at justo. Morbi sit amet urna vel est fringilla tristique non quis lectus. Duis et lectus non ante elementum tincidunt eu in mi. Proin velit lacus, tempus nec molestie quis, iaculis sit amet neque. Vestibulum dapibus sodales nisl non tincidunt. Donec felis purus, vehicula vitae euismod vitae, porttitor quis nisi. Phasellus faucibus consequat lorem eget interdum. Fusce ullamcorper placerat est, in pharetra diam cursus et. Sed nec risus et sapien rutrum pulvinar ac et mi.</p>\r\n<p>Suspendisse potenti. Pellentesque pulvinar pharetra mi quis elementum. Proin vulputate tempor convallis. Morbi aliquet diam id mauris tempus mollis. Nullam arcu nulla, porttitor non sodales in, auctor sed tellus. Donec varius hendrerit dolor, vitae vestibulum mauris mattis eu. Nunc vel sapien leo. Maecenas ac nunc nulla, quis faucibus eros. Sed est eros, ullamcorper sit amet viverra ac, facilisis et dolor. Nam est felis, dapibus vitae dapibus at, elementum a lectus. Cras dapibus, augue non lacinia euismod, elit massa mollis sapien, at porta arcu urna vitae tortor. Nunc feugiat viverra lorem quis tincidunt. Maecenas condimentum dui a libero cursus luctus. Pellentesque varius neque felis, sit amet congue tortor. Aliquam erat volutpat. Aliquam ut risus nisl.</p>\r\n<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem. Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:23:07', '44', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:48:26', '43', '2011-11-08 16:23:07', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '839', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('19', 'Sed egestas purus quis dui fringilla mollis', 'sed-egestas-purus-quis-dui-fringilla-mollis', '40', '1', '<p>Suspendisse potenti. Pellentesque pulvinar pharetra mi quis elementum. Proin vulputate tempor convallis. Morbi aliquet diam id mauris tempus mollis. Nullam arcu nulla, porttitor non sodales in, auctor sed tellus. Donec varius hendrerit dolor, vitae vestibulum mauris mattis eu. Nunc vel sapien leo.</p>\r\n', '\r\n<p>Maecenas ac nunc nulla, quis faucibus eros. Sed est eros, ullamcorper sit amet viverra ac, facilisis et dolor. Nam est felis, dapibus vitae dapibus at, elementum a lectus. Cras dapibus, augue non lacinia euismod, elit massa mollis sapien, at porta arcu urna vitae tortor. Nunc feugiat viverra lorem quis tincidunt. Maecenas condimentum dui a libero cursus luctus. Pellentesque varius neque felis, sit amet congue tortor. Aliquam erat volutpat. Aliquam ut risus nisl.</p>\r\n<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem. Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>\r\n<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus. Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>', NULL, NULL, '[]', '', '2011-11-08 16:23:47', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:23:47', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '866', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('20', 'Duis condimentum lectus vel lacus', 'duis-condimentum-lectus-vel-lacus', '40', '1', '<p>Maecenas ullamcorper placerat nisl, et vestibulum lacus pulvinar eget. Pellentesque lacinia sem sit amet quam dignissim porta vel sed augue. Duis nec est felis. Mauris lacinia, orci nec elementum sodales, diam nunc bibendum massa, vitae egestas nibh erat id sem.</p>\r\n', '\r\n<p>Morbi pretium nisi a arcu fermentum at dignissim tortor tempus. Sed egestas purus quis dui fringilla mollis. Integer augue massa, rhoncus a aliquet ut, varius nec turpis. Etiam purus dolor, rhoncus sit amet vehicula non, ultrices sed tellus.</p>\r\n<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus. Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>\r\n<p>Sed ac dolor nunc, at venenatis massa. Donec leo ligula, tincidunt vitae posuere eget, blandit vel nunc. Fusce sit amet nulla nec libero blandit aliquam in ac diam. Nunc at rhoncus massa. Suspendisse potenti. Pellentesque dignissim risus nec urna tristique iaculis. Maecenas commodo lorem eget nisi egestas a tincidunt enim hendrerit. Praesent varius sagittis dui, in tristique dui consectetur vitae. Cras id lectus massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. In convallis ipsum id nunc vestibulum blandit. Vestibulum in convallis leo.</p>', NULL, NULL, '[]', '', '2011-11-08 16:24:28', '44', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:49:03', '43', '2011-11-08 16:24:28', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '894', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('21', 'Donec eu sapien a lectus porta ultricies', 'donec-eu-sapien-a-lectus-porta-ultricies', '40', '1', '<p>In venenatis dolor id lorem elementum sodales. In quis scelerisque velit. Quisque sed massa ut augue placerat malesuada id fermentum risus. Donec a iaculis urna. Phasellus leo justo, commodo ac accumsan non, sagittis a tellus.</p>\r\n', '\r\n<p>Duis sem est, suscipit id congue vel, bibendum eget erat. Sed eget turpis vitae arcu porttitor mollis in in mauris. Aliquam erat volutpat. Duis condimentum lectus vel lacus consequat quis consectetur erat dictum. Nullam sed nisi ut dui sagittis tempus. Maecenas auctor neque eu quam blandit a feugiat odio aliquet. Curabitur metus dui, tempor quis auctor ut, congue non turpis.</p>\r\n<p>Sed ac dolor nunc, at venenatis massa. Donec leo ligula, tincidunt vitae posuere eget, blandit vel nunc. Fusce sit amet nulla nec libero blandit aliquam in ac diam. Nunc at rhoncus massa. Suspendisse potenti. Pellentesque dignissim risus nec urna tristique iaculis. Maecenas commodo lorem eget nisi egestas a tincidunt enim hendrerit. Praesent varius sagittis dui, in tristique dui consectetur vitae. Cras id lectus massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. In convallis ipsum id nunc vestibulum blandit. Vestibulum in convallis leo.</p>\r\n<p>Mauris quis massa id libero accumsan dignissim. Pellentesque enim diam, cursus nec condimentum a, placerat vitae ipsum. In hac habitasse platea dictumst. Duis lobortis luctus leo porta volutpat. Praesent risus est, scelerisque eget condimentum vel, malesuada ut leo. Nulla facilisi. Aliquam gravida, tellus eu cursus interdum, purus magna cursus lacus, eu vestibulum urna eros eu sapien. Vestibulum luctus vehicula ultricies. Ut nunc nunc, lobortis lobortis aliquam eu, consequat at tellus. Mauris sagittis elit quis enim cursus et interdum nibh imperdiet. Proin viverra lectus nec velit semper tristique. Morbi tempus ipsum sed nisi iaculis sed eleifend ipsum euismod. Nunc cursus commodo lacus, sit amet tristique arcu sollicitudin a.</p>\r\n<p>Nulla dolor lacus, consectetur sed malesuada in, fringilla sed lorem. Maecenas malesuada ornare lorem sed porttitor. Donec eu sapien a lectus porta ultricies. Pellentesque aliquet purus sed velit vulputate rhoncus vitae a lorem. Sed id ultrices massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse potenti.</p>', NULL, NULL, '[]', '', '2011-11-08 16:25:09', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:25:09', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '1192', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('22', 'Maecenas viverra nisl gravida lectus rutrum laoreet', 'maecenas-viverra-nisl-gravida-lectus-rutrum-laoreet', '40', '1', '<p>Nulla dolor lacus, consectetur sed malesuada in, fringilla sed lorem. Maecenas malesuada ornare lorem sed porttitor. Donec eu sapien a lectus porta ultricies. Pellentesque aliquet purus sed velit vulputate rhoncus vitae a lorem. Sed id ultrices massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse potenti.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Cras sed facilisis quam. Nunc nisl nisl, scelerisque sit amet fermentum ut, hendrerit laoreet nisl. Integer quis dolor odio, in scelerisque nibh. Phasellus rutrum, elit a fringilla gravida, leo nunc congue ante, et mollis lorem mauris in enim. Ut laoreet tempor scelerisque. Nam lobortis nulla non nisi lacinia rutrum et vel enim. Vivamus sed sagittis nibh.</p>\r\n<p>Curabitur quis ipsum sapien. Mauris gravida nisi non tellus mollis sit amet iaculis erat fringilla. Phasellus vulputate orci eu nunc dictum eu elementum est fermentum. Phasellus non vulputate lorem. In in ultrices leo. Maecenas sit amet nisl metus, pellentesque iaculis tortor. Nam tristique hendrerit convallis. Aenean dolor diam, tristique quis tristique vitae, sollicitudin in velit. Aliquam tempor, lectus vitae aliquam interdum, libero justo posuere eros, nec euismod dolor neque quis leo. Sed magna massa, pellentesque sollicitudin malesuada et, mollis sed orci. Pellentesque euismod faucibus est, ac rhoncus lorem laoreet nec. In et urna et nulla tincidunt eleifend a at augue. Vestibulum sit amet accumsan nisi.</p>\r\n<p>Suspendisse nec urna vitae nisl posuere interdum. Donec id velit sit amet turpis egestas tempor. Maecenas viverra nisl gravida lectus rutrum laoreet. Suspendisse quis vulputate ipsum. Nullam magna magna, molestie a venenatis eget, blandit in purus. Donec porta orci sed leo dapibus ac scelerisque eros pretium. Praesent at tristique sem. Maecenas vitae odio turpis. Nam tempus erat vitae nunc commodo non accumsan tellus dapibus. Donec sit amet nisl et nulla condimentum porta id at libero. Etiam id orci quis magna lobortis suscipit. Quisque placerat tristique adipiscing. Nulla facilisi. Quisque ullamcorper dolor nec lacus consectetur pharetra. Cras at magna nec turpis tempus lacinia.</p>', NULL, NULL, '[]', '', '2011-11-08 16:26:02', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-08 16:26:02', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '1266', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('23', 'Suspendisse sem tortor', 'suspendisse-sem-tortor', '40', '1', '<p>Suspendisse nec urna vitae nisl posuere interdum. Donec id velit sit amet turpis egestas tempor. Maecenas viverra nisl gravida lectus rutrum laoreet. Suspendisse quis vulputate ipsum. Nullam magna magna, molestie a venenatis eget, blandit in purus. Donec porta orci sed leo dapibus ac scelerisque eros pretium.</p>\r\n', '\r\n<p>Praesent at tristique sem. Maecenas vitae odio turpis. Nam tempus erat vitae nunc commodo non accumsan tellus dapibus. Donec sit amet nisl et nulla condimentum porta id at libero. Etiam id orci quis magna lobortis suscipit. Quisque placerat tristique adipiscing. Nulla facilisi. Quisque ullamcorper dolor nec lacus consectetur pharetra. Cras at magna nec turpis tempus lacinia.</p>\r\n<p>Donec scelerisque, mauris eu luctus condimentum, neque leo venenatis lectus, sit amet dictum massa nulla vel sem. Suspendisse porttitor, eros in semper semper, massa felis mattis nulla, quis sodales nulla nisi in risus. Aliquam bibendum, massa vel molestie accumsan, est lorem varius turpis, sit amet tincidunt tortor augue vel nulla. Donec sit amet purus justo, at bibendum erat. Vestibulum massa dui, scelerisque eu auctor at, blandit sit amet ligula. Nam gravida tristique lorem, sed egestas ante tempus ut. Donec quis facilisis felis. Fusce velit lacus, porttitor vitae faucibus eu, tristique at diam. Aenean velit nisl, dictum at scelerisque at, interdum eu tortor. Vestibulum feugiat elit mi. Donec ac turpis enim.</p>\r\n<p>Maecenas vitae tortor eget justo mattis luctus vel auctor nunc. Fusce adipiscing dui mattis est rhoncus tempus. Nam eget malesuada nisi. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean interdum, diam in dapibus molestie, mauris ante rhoncus arcu, ac adipiscing sapien tortor ut ante. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus eget arcu eget est ornare convallis et id dui. Nulla ultrices fringilla lorem, id ultricies odio porttitor nec. Vivamus id neque magna, mollis porta metus. Suspendisse sem tortor, sagittis sit amet euismod at, ultrices posuere odio. Integer vulputate nisi purus, tempus consectetur nisi. Etiam ac nulla nec elit interdum hendrerit id vitae nunc. Proin feugiat nisi bibendum nibh ultricies malesuada. Nullam porta suscipit mollis. Pellentesque porta iaculis nisl sed tincidunt.</p>', NULL, NULL, '[]', '', '2011-11-08 16:26:41', '44', '', '0', '0000-00-00 00:00:00', '2011-11-09 13:49:28', '43', '2011-11-08 16:26:41', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '1387', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('24', 'Ut risus ipsum, pulvinar sed pretium quis', 'ut-risus-ipsum-pulvinar-sed-pretium-quis', '40', '1', '<p>Maecenas vitae tortor eget justo mattis luctus vel auctor nunc. Fusce adipiscing dui mattis est rhoncus tempus. Nam eget malesuada nisi. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean interdum, diam in dapibus molestie, mauris ante rhoncus arcu, ac adipiscing sapien tortor ut ante.</p>\r\n', '\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus eget arcu eget est ornare convallis et id dui. Nulla ultrices fringilla lorem, id ultricies odio porttitor nec. Vivamus id neque magna, mollis porta metus. Suspendisse sem tortor, sagittis sit amet euismod at, ultrices posuere odio. Integer vulputate nisi purus, tempus consectetur nisi. Etiam ac nulla nec elit interdum hendrerit id vitae nunc. Proin feugiat nisi bibendum nibh ultricies malesuada. Nullam porta suscipit mollis. Pellentesque porta iaculis nisl sed tincidunt.</p>\r\n<p>Curabitur sollicitudin nisi vel nulla lobortis eu bibendum sapien vestibulum. Donec laoreet viverra ligula non porta. Maecenas hendrerit velit sit amet felis rutrum ut pretium massa vestibulum. Phasellus tincidunt velit sed ligula vehicula ac placerat orci feugiat. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc et orci quis est ornare auctor eget vitae nulla. Vestibulum ornare magna ut orci imperdiet porttitor. Phasellus eu lobortis neque.</p>\r\n<p>Proin eleifend posuere neque in hendrerit. Donec tempus felis in nulla rutrum vitae elementum mauris mattis. Maecenas a leo sit amet nisl ornare vulputate et a magna. Aliquam erat volutpat. Sed accumsan purus ac arcu luctus bibendum. Suspendisse potenti. Aliquam aliquam semper metus, eu tristique libero rutrum a. Ut risus ipsum, pulvinar sed pretium quis, sodales ac augue. Cras est metus, bibendum ut ultrices sit amet, tempor quis nisl. Praesent ultricies sagittis nulla eget lacinia.</p>\r\n<p>Suspendisse vitae mauris sit amet sem tristique ornare a vel odio. Sed eu ultricies ante. Fusce tincidunt tortor a turpis iaculis a tincidunt neque facilisis. Nam bibendum odio vitae massa ornare commodo. Nullam vitae nisl orci. Nulla a elit augue. Cras eget dolor tortor, eget lacinia sapien. Sed sodales nisl in mauris malesuada sed vulputate justo consectetur.</p>', '{vimeo}8546368{/vimeo}', '{gallery}http://www.flickr.com/photos/oregonballettheatre/sets/72157625963314632/with/6264619429/{/gallery}', '[]', '', '2011-11-08 16:27:24', '44', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:55:21', '43', '2011-11-08 16:27:24', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '1628', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('25', 'Morbi adipiscing sapien non tellus', 'morbi-adipiscing-sapien-non-tellus', '5', '1', '<p>Proin eleifend posuere neque in hendrerit. Donec tempus felis in nulla rutrum vitae elementum mauris mattis. Maecenas a leo sit amet nisl ornare vulputate et a magna. Aliquam erat volutpat. Sed accumsan purus ac arcu luctus bibendum.</p>\r\n', '\r\n<p>Suspendisse potenti. Aliquam aliquam semper metus, eu tristique libero rutrum a. Ut risus ipsum, pulvinar sed pretium quis, sodales ac augue. Cras est metus, bibendum ut ultrices sit amet, tempor quis nisl. Praesent ultricies sagittis nulla eget lacinia.</p>\r\n<p>Suspendisse vitae mauris sit amet sem tristique ornare a vel odio. Sed eu ultricies ante. Fusce tincidunt tortor a turpis iaculis a tincidunt neque facilisis. Nam bibendum odio vitae massa ornare commodo. Nullam vitae nisl orci. Nulla a elit augue. Cras eget dolor tortor, eget lacinia sapien. Sed sodales nisl in mauris malesuada sed vulputate justo consectetur. Vestibulum placerat sem eu libero pretium faucibus. Fusce leo augue, rutrum mattis volutpat at, lobortis nec nunc. Sed velit mauris, ultricies vehicula feugiat in, feugiat et massa. Pellentesque vel est non elit hendrerit pharetra ut ut quam. Suspendisse vel metus non lectus ornare suscipit. Suspendisse potenti.</p>\r\n<p>Maecenas id ante diam, nec consectetur augue. Donec tempor sollicitudin felis sed tincidunt. Mauris sollicitudin ligula lacinia mauris dignissim malesuada. Nullam nibh risus, molestie et suscipit non, bibendum eget ipsum. Morbi mi risus, molestie ut semper vel, aliquam sit amet augue. Curabitur turpis orci, luctus sit amet sagittis vel, lacinia et tellus. Morbi adipiscing sapien non tellus facilisis eget fermentum mauris consequat. Nam id ante urna, sit amet eleifend arcu. Pellentesque et magna vel lacus congue convallis at vitae purus. Duis est metus, lacinia ut posuere et, suscipit quis elit. In gravida aliquet magna sit amet cursus. Etiam et neque eget neque gravida malesuada commodo a nunc. Aenean mollis, tellus a tempus feugiat, sem lacus ornare sem, vel mattis neque diam id mauris.</p>', NULL, NULL, '[]', '', '2011-11-08 16:28:16', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:19', '45', '2011-11-08 16:28:16', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '764', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('26', 'Quisque vel lacinia urna', 'quisque-vel-lacinia-urna', '5', '1', '<p>Curabitur quis libero leo, pharetra mattis eros. Praesent consequat libero eget dolor convallis vel rhoncus magna scelerisque. Donec nisl ante, elementum eget posuere a, consectetur a metus. Proin a adipiscing sapien. Suspendisse vehicula porta lectus vel semper. Nullam sapien elit, lacinia eu tristique non, posuere at mi. Morbi at turpis id urna ullamcorper ullamcorper.</p>\r\n', '\r\n<p> </p>\r\n<p>Mauris interdum molestie felis in accumsan. Pellentesque in est felis, a eleifend diam. Mauris dolor augue, ultrices eu adipiscing nec, molestie vel massa. Proin ultricies diam ac orci tincidunt at hendrerit ipsum malesuada. Integer placerat, mauris ultrices elementum aliquam, felis quam ultrices libero, ac porttitor mauris eros eget orci. Suspendisse porttitor placerat sapien, nec consequat dui eleifend non. Pellentesque ultricies lectus quis enim tristique congue. Morbi sed ante elit. Proin diam mi, vestibulum vel eleifend nec, aliquet id massa. Phasellus quis turpis tortor, eu congue sem. Suspendisse congue faucibus neque, vitae cursus dui consectetur eu. Praesent quis turpis a metus elementum mollis eu et tortor. Donec lobortis nisl vel urna convallis tincidunt. Nunc ut arcu sem, sed elementum velit.</p>\r\n<p>Mauris id tortor magna, consequat bibendum quam. Aliquam viverra, velit vitae iaculis ullamcorper, ante est euismod nisl, a auctor augue est id quam. Donec eget augue id lorem interdum pretium. Quisque vel lacinia urna. Donec dictum lorem est. Aliquam ante nulla, sodales in tincidunt quis, vulputate non magna. Aliquam erat volutpat. Maecenas pharetra luctus turpis, ut varius mi tincidunt in.</p>\r\n<p> </p>', NULL, NULL, '[]', '', '2011-11-08 16:29:07', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:00', '45', '2011-11-08 16:29:07', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '971', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('27', 'Quisque malesuada, libero in mollis pretium', 'quisque-malesuada-libero-in-mollis-pretium', '5', '1', '<p>Mauris id tortor magna, consequat bibendum quam. Aliquam viverra, velit vitae iaculis ullamcorper, ante est euismod nisl, a auctor augue est id quam. Donec eget augue id lorem interdum pretium. Quisque vel lacinia urna. Donec dictum lorem est. Aliquam ante nulla, sodales in tincidunt quis, vulputate non magna. Aliquam erat volutpat. Maecenas pharetra luctus turpis, ut varius mi tincidunt in.</p>\r\n', '\r\n<p> </p>\r\n<p>Nulla interdum tristique justo sit amet tincidunt. Vestibulum adipiscing auctor nisl, quis feugiat magna molestie id. In tincidunt consequat libero sit amet ornare. In et consectetur nibh. Curabitur libero justo, laoreet vitae sagittis sit amet, pulvinar vitae elit. Vestibulum gravida, risus non gravida suscipit, lorem lectus vestibulum velit, a tincidunt diam urna non mi. Integer ac lectus et urna fringilla blandit. Phasellus congue massa non felis vestibulum feugiat. In lobortis placerat interdum. Nam dapibus libero vel elit suscipit a semper lacus tempor. Duis vehicula vulputate rhoncus. Aenean feugiat sollicitudin sapien, non semper erat vehicula ut. Suspendisse a felis nunc. Suspendisse tristique iaculis ligula in porttitor. Proin diam ipsum, auctor ac mollis sollicitudin, ultrices ut lacus.</p>\r\n<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper. Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:37:06', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:35:45', '45', '2011-11-08 16:37:06', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '828', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('28', 'Donec a imperdiet lorem', 'donec-a-imperdiet-lorem', '5', '1', '<p>Nulla interdum tristique justo sit amet tincidunt. Vestibulum adipiscing auctor nisl, quis feugiat magna molestie id. In tincidunt consequat libero sit amet ornare. In et consectetur nibh. Curabitur libero justo, laoreet vitae sagittis sit amet, pulvinar vitae elit.</p>\r\n', '\r\n<p>Vestibulum gravida, risus non gravida suscipit, lorem lectus vestibulum velit, a tincidunt diam urna non mi. Integer ac lectus et urna fringilla blandit. Phasellus congue massa non felis vestibulum feugiat. In lobortis placerat interdum. Nam dapibus libero vel elit suscipit a semper lacus tempor. Duis vehicula vulputate rhoncus. Aenean feugiat sollicitudin sapien, non semper erat vehicula ut. Suspendisse a felis nunc. Suspendisse tristique iaculis ligula in porttitor. Proin diam ipsum, auctor ac mollis sollicitudin, ultrices ut lacus.</p>\r\n<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper. Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>\r\n<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>', NULL, NULL, '[]', '', '2011-11-08 16:37:55', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:46', '45', '2011-11-08 16:37:55', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '606', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('29', 'Vivamus tempor lobortis rutrum', 'vivamus-tempor-lobortis-rutrum', '5', '1', '<p>Proin condimentum ante at leo consectetur vehicula. Fusce feugiat metus sed erat egestas nec lobortis ipsum fringilla. Praesent elementum eleifend diam quis luctus. Vivamus a lectus ligula. Integer feugiat vehicula semper.</p>\r\n', '\r\n<p>Donec mauris augue, viverra eget convallis tempus, ornare eu diam. Nulla luctus nisl a augue dictum ac malesuada orci posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec a imperdiet lorem. Quisque malesuada, libero in mollis pretium, nunc nunc consequat turpis, et mollis neque libero sit amet purus.</p>\r\n<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>\r\n<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus. Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>', NULL, NULL, '[]', '', '2011-11-08 16:38:43', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:36', '45', '2011-11-08 16:38:43', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '770', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('30', 'Mauris nisi sapien, sodales sed bibendum in', 'mauris-nisi-sapien-sodales-sed-bibendum-in', '5', '1', '<p>Donec placerat pretium ante suscipit tincidunt. Maecenas congue nisi a purus cursus eu placerat lacus rhoncus. Morbi ac dolor porta leo aliquet tincidunt vehicula vitae libero. Duis sollicitudin, purus quis tempus tempus, elit arcu mollis nibh, id tristique nibh eros quis risus.</p>\r\n', '\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris eget velit nec nisi bibendum blandit. Suspendisse malesuada luctus iaculis. Etiam ipsum leo, molestie nec condimentum eget, interdum quis risus. Suspendisse id gravida metus. Nulla metus neque, rhoncus in ultricies sit amet, aliquet vel felis. Cras porta fringilla justo, ut blandit odio dictum ut. Fusce at sodales orci.</p>\r\n<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus. Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>\r\n<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui. Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>', '{vimeo}6622363{/vimeo}', '{gallery}http://www.flickr.com/photos/chictip/sets/72157626210569395/with/5559842544/{/gallery}', '[]', '', '2011-11-08 16:39:26', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:14', '45', '2011-11-08 16:39:26', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '577', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('31', 'Curabitur vitae leo dui, ac malesuada arcu', 'curabitur-vitae-leo-dui-ac-malesuada-arcu', '5', '1', '<p>Suspendisse vitae orci quis mauris laoreet consectetur. Proin non leo nunc. Nulla sagittis, nisl vitae porttitor ultrices, erat lorem interdum massa, luctus rhoncus metus magna non leo. Pellentesque elit mi, scelerisque hendrerit facilisis fringilla, interdum sit amet tellus.</p>\r\n', '\r\n<p>Phasellus ut sem mollis ante fringilla consectetur et interdum diam. Vivamus tempor lobortis rutrum. Donec lacus ligula, interdum nec pellentesque at, vulputate non mauris. Phasellus arcu elit, mattis vel posuere quis, facilisis ac nisl. Integer commodo commodo lorem, a eleifend massa consectetur at. Suspendisse pretium facilisis elit vitae tempus. Aenean tincidunt porta pulvinar. Mauris sodales, magna quis facilisis posuere, tellus risus elementum mi, vel mollis sem lacus sed velit. Ut ut tortor vel magna viverra tempor ut a lorem. Curabitur vitae leo dui, ac malesuada arcu.</p>\r\n<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui. Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>\r\n<p>Sed ac metus nisl, vel fringilla lorem. Curabitur at nibh felis. Aenean facilisis posuere aliquet. Nullam lobortis, ligula id sollicitudin scelerisque, turpis leo imperdiet mauris, a placerat neque mauris quis nulla. In quis lacus ac nulla faucibus euismod non non dolor. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nulla suscipit fermentum purus, ut fringilla dui facilisis vitae. Proin consequat aliquam sapien, vitae porta nunc consectetur eget. Curabitur pulvinar dignissim volutpat. Aliquam lobortis, nisl ac tempus vulputate, sapien eros molestie arcu, vel porttitor urna eros nec eros. Sed iaculis libero nec purus accumsan sagittis.</p>', NULL, NULL, '[]', '', '2011-11-08 16:40:14', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:34:03', '45', '2011-11-08 16:40:14', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '818', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('32', 'Donec ut lorem sit amet eros', 'donec-ut-lorem-sit-amet-eros', '5', '1', '<p>Cras venenatis bibendum ipsum, quis porttitor quam semper et. Aenean porta neque nec orci venenatis vehicula. Nunc hendrerit bibendum mattis. Fusce enim nisl, tempor ut interdum nec, pretium non augue. Praesent a massa augue. In sed dolor nibh. Mauris orci purus, ultrices vitae elementum vitae, sollicitudin eu dui.</p>\r\n', '\r\n<p>Mauris nisi sapien, sodales sed bibendum in, ultricies ut nisi. Vestibulum quam tellus, posuere ac fermentum at, gravida dignissim sapien. Suspendisse sollicitudin libero eget augue viverra ultricies. Pellentesque auctor est pellentesque ante aliquam in eleifend diam congue. Duis rutrum velit pretium nibh adipiscing pretium. Donec ut lorem sit amet eros dictum tincidunt eu in mauris. Aenean ut sem lacus.</p>\r\n<p>Sed ac metus nisl, vel fringilla lorem. Curabitur at nibh felis. Aenean facilisis posuere aliquet. Nullam lobortis, ligula id sollicitudin scelerisque, turpis leo imperdiet mauris, a placerat neque mauris quis nulla. In quis lacus ac nulla faucibus euismod non non dolor. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nulla suscipit fermentum purus, ut fringilla dui facilisis vitae. Proin consequat aliquam sapien, vitae porta nunc consectetur eget. Curabitur pulvinar dignissim volutpat. Aliquam lobortis, nisl ac tempus vulputate, sapien eros molestie arcu, vel porttitor urna eros nec eros. Sed iaculis libero nec purus accumsan sagittis.</p>\r\n<p>Mauris eget nibh et eros pellentesque posuere. Maecenas elementum, sem eget pharetra rhoncus, orci odio sodales sapien, pretium porta enim justo in diam. Sed pharetra nunc vel orci consectetur non varius odio elementum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi in lacus ante. Duis aliquet auctor erat at sagittis. Donec pulvinar, tortor vitae suscipit viverra, lacus sem dignissim metus, eget suscipit arcu lacus vitae quam. Aenean aliquam pharetra sapien et ullamcorper. Etiam viverra, quam in sodales volutpat, felis sem adipiscing velit, ac gravida dolor dolor non turpis.</p>\r\n<p>Nulla commodo mollis sagittis. Suspendisse non orci mauris, et dictum elit. Donec bibendum, quam nec fermentum adipiscing, arcu ligula dictum enim, vitae venenatis ipsum purus eu tellus. Aenean nec euismod nibh. Fusce convallis eros sed leo feugiat commodo. Sed accumsan facilisis rhoncus. Quisque leo mi, adipiscing at viverra at, iaculis et mi. Suspendisse potenti. Sed nec blandit risus.</p>', NULL, NULL, '[]', '', '2011-11-08 16:41:01', '44', '', '0', '0000-00-00 00:00:00', '2012-03-09 11:33:49', '45', '2011-11-08 16:41:01', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '778', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('33', 'Curabitur non erat diam', 'curabitur-non-erat-diam', '6', '1', '<p>Pellentesque consectetur, quam ut rhoncus rhoncus, massa neque gravida augue, eget imperdiet quam ligula vitae enim. Suspendisse ut neque ut nibh laoreet imperdiet. Nam id urna neque. Nam a turpis purus, ut scelerisque quam. In vulputate posuere odio, at ultrices nisl vestibulum elementum.</p>\r\n', '\r\n<p>Morbi diam sem, tincidunt quis laoreet sit amet, cursus ut quam. Ut ultricies eros ultrices neque convallis a ultricies felis consectetur. Fusce convallis felis magna, eu rutrum nulla. Phasellus ut viverra odio. Aenean at augue quis risus ultricies mollis lobortis nec felis. Vivamus vestibulum iaculis sollicitudin. Aliquam volutpat erat at dui ultricies dignissim. Praesent lacus metus, varius nec mollis non, luctus vitae nisl. Aliquam eu mauris suscipit urna dictum porttitor.</p>\r\n<p>Fusce arcu augue, mattis tincidunt egestas in, facilisis quis nisi. Nunc vel sem vitae nulla rhoncus dictum. Donec eleifend suscipit diam, at ornare ante elementum nec. Maecenas vel dolor ac dolor sodales feugiat. Nam pharetra, metus ut pellentesque lacinia, est est consequat sem, id cursus dolor nisi et orci. Duis tincidunt tincidunt volutpat. Vivamus malesuada mauris at felis mattis et fringilla mauris suscipit. In urna libero, rhoncus eget suscipit nec, egestas ac lectus. In hac habitasse platea dictumst. Maecenas sit amet est neque, vitae gravida ante.</p>\r\n<p>Aenean lobortis imperdiet tellus, imperdiet aliquam massa dictum nec. Aenean pulvinar sollicitudin magna sed facilisis. Curabitur non erat diam. Cras pretium dignissim fermentum. Ut bibendum lobortis mauris, ac imperdiet risus dictum eget. Nunc fringilla sem vel ligula mattis non iaculis mi vulputate. Duis sollicitudin fringilla hendrerit. Vivamus malesuada metus et nunc rhoncus euismod. Donec adipiscing sem fermentum augue ultricies dapibus. In tincidunt tempor tortor, in blandit eros ultricies eget.</p>', NULL, NULL, '[]', '', '2011-11-09 09:22:04', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:22:04', '0000-00-00 00:00:00', '0', '1', '1', '0', '0', '', '', '', '', '599', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('34', 'Mauris at dignissim ante', 'mauris-at-dignissim-ante', '6', '1', '<p>Aenean lobortis imperdiet tellus, imperdiet aliquam massa dictum nec. Aenean pulvinar sollicitudin magna sed facilisis. Curabitur non erat diam. Cras pretium dignissim fermentum. Ut bibendum lobortis mauris, ac imperdiet risus dictum eget.</p>\r\n', '\r\n<p>Nunc fringilla sem vel ligula mattis non iaculis mi vulputate. Duis sollicitudin fringilla hendrerit. Vivamus malesuada metus et nunc rhoncus euismod. Donec adipiscing sem fermentum augue ultricies dapibus. In tincidunt tempor tortor, in blandit eros ultricies eget.</p>\r\n<p>Mauris sem nulla, interdum ut dapibus sit amet, rhoncus eu arcu. Suspendisse ullamcorper mi ut lacus feugiat pellentesque. Nunc sed lacus tellus. Proin convallis blandit nisi at luctus. Donec est turpis, commodo et pharetra vel, lacinia eget mi. Vivamus vitae leo mi, sit amet ullamcorper massa. Ut non sem id ligula iaculis fringilla nec et nulla. Mauris commodo auctor eros eget vestibulum. Integer sit amet leo ultricies nunc dapibus accumsan. Suspendisse potenti. Donec non neque sapien. Curabitur mattis enim ut est eleifend ut egestas lectus adipiscing.</p>\r\n<p>Vestibulum ligula diam, cursus quis vulputate eu, tincidunt at lacus. Donec iaculis, neque eget pretium tempor, turpis tortor vehicula risus, vitae posuere orci lectus nec sapien. Praesent a nisi elit, sed pellentesque dolor. Mauris ac bibendum nisi. Donec imperdiet bibendum dignissim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus gravida neque sit amet diam suscipit ac mollis purus rutrum. Proin et arcu nec diam faucibus rutrum. Mauris at dignissim ante. Donec at purus vehicula est condimentum elementum. Pellentesque laoreet neque sed odio pretium in malesuada risus condimentum. Duis eu purus vitae est pretium blandit.</p>\r\n<p>Aenean ac orci a tortor ornare dapibus non a est. Sed faucibus condimentum rhoncus. Ut id velit magna. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse potenti. Nunc tincidunt felis eget sem congue varius. Vivamus pellentesque felis ac lacus tincidunt a ornare massa blandit.</p>', NULL, NULL, '[]', '', '2011-11-09 09:24:29', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:24:29', '0000-00-00 00:00:00', '0', '1', '2', '0', '0', '', '', '', '', '523', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('35', 'Integer volutpat euismod diam convallis auctor', 'integer-volutpat-euismod-diam-convallis-auctor', '6', '1', '<p>Donec tincidunt nisi et mauris dictum et mollis lectus tincidunt. Duis vitae est odio. Donec varius imperdiet risus, quis sodales lectus cursus a. Quisque laoreet tortor in turpis sollicitudin at posuere dolor consequat. Donec leo mauris, ultricies vitae tempus nec, tincidunt nec ipsum.</p>\r\n', '\r\n<p>Donec sapien felis, tincidunt at luctus sed, porta vitae leo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin massa est, porta in cursus vehicula, faucibus porta urna. Aliquam et mauris eleifend nibh facilisis scelerisque. Suspendisse et sollicitudin ipsum. Maecenas a bibendum urna. Proin consequat sapien quis lacus aliquet mollis. Cras sodales, orci eu luctus volutpat, felis augue condimentum ligula, ut pellentesque mi quam laoreet sapien. Sed ut nunc neque. Sed eu dolor porta sapien pulvinar tempus. Nullam nulla dolor, aliquet non rhoncus et, porttitor in quam.</p>\r\n<p>Duis eu lectus quis eros tristique consequat quis in metus. Mauris aliquam aliquam condimentum. Curabitur ultrices dui consequat lorem pellentesque placerat. Fusce elementum volutpat ultrices. Etiam molestie ultrices euismod. Morbi sollicitudin dapibus tristique. Ut faucibus posuere turpis at bibendum. Etiam bibendum commodo congue. Cras ullamcorper tincidunt lectus, et consectetur arcu hendrerit vel. Fusce ante est, pharetra sit amet laoreet vel, dapibus non eros. Aenean hendrerit accumsan mauris, ut laoreet risus adipiscing id. Mauris ullamcorper volutpat nunc, laoreet bibendum lacus placerat nec. Nunc at purus lorem.</p>\r\n<p>Duis suscipit iaculis tortor, sit amet sagittis purus dictum ac. Donec ut vehicula massa. Mauris nunc eros, aliquet vel lacinia vel, lobortis et augue. Proin tincidunt, lorem eu dictum tempus, magna sem imperdiet lacus, vitae ullamcorper ligula dui eget turpis. Maecenas eget urna in nisl porta rutrum. Integer hendrerit congue tellus. Integer volutpat euismod diam convallis auctor. Mauris semper mauris et magna varius adipiscing. Maecenas lacinia malesuada eleifend. Mauris dictum mattis odio vel posuere. Sed facilisis odio semper risus facilisis eget tempus mi ullamcorper.</p>', '{vimeo}31174829{/vimeo}', '{gallery}http://www.flickr.com/photos/44124451616@N01/sets/72157627872600618/with/6235207641/{/gallery}', '[]', '', '2011-11-09 09:25:54', '44', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:56:24', '43', '2011-11-09 09:25:54', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '559', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('36', 'Proin dignissim orci et tellus facilisis', 'proin-dignissim-orci-et-tellus-facilisis', '6', '1', '<p>Donec vel tortor quam. Donec non elit id purus congue luctus ut sed ante. Integer massa tortor, egestas lacinia gravida mollis, vehicula nec erat. Nulla consectetur odio id nisl sagittis blandit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n', '\r\n<p>Donec aliquam augue pellentesque tortor laoreet sodales. Aliquam elit diam, accumsan non pharetra a, vehicula vitae lorem. Fusce neque ante, dictum id volutpat eget, interdum sed sapien. Curabitur tristique velit quis dui blandit laoreet. Fusce massa velit, convallis vitae vulputate accumsan, blandit lobortis neque. Phasellus non justo quis mauris feugiat luctus. Praesent rutrum hendrerit vulputate. Phasellus sagittis tellus eget augue faucibus mollis. Mauris nunc nulla, ullamcorper ac lobortis at, sagittis eget tortor.</p>\r\n<p>Aliquam in turpis dolor, vel viverra metus. Pellentesque non tellus massa, at congue dui. Vivamus tempor, odio eu ullamcorper adipiscing, nibh dui euismod arcu, id eleifend velit metus a justo. Donec dolor nisi, feugiat sed tincidunt quis, pharetra in tellus. Quisque non risus eros, non vulputate risus. Duis non tincidunt sapien. Proin dignissim orci et tellus facilisis pulvinar. Nullam libero risus, auctor ut eleifend vitae, feugiat ac nisl. Suspendisse facilisis varius sodales. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aliquam in leo ut erat ultricies pharetra id suscipit felis. Nullam vehicula tristique dolor, vitae scelerisque risus luctus sed.</p>\r\n<p>Curabitur egestas cursus sapien, eu ultricies leo eleifend sed. Nunc eleifend est vitae diam tristique eu venenatis libero tincidunt. Duis vehicula vehicula diam, sit amet sagittis tortor molestie ac. Curabitur vitae libero eu eros bibendum vulputate at et justo. Integer porttitor orci justo, in viverra leo. Suspendisse lacinia pharetra lectus, et suscipit eros fermentum vitae. Donec sapien felis, convallis dignissim pretium a, interdum vitae ante. Aenean aliquam commodo justo non ornare. Sed pellentesque semper elementum. Sed vel mauris pharetra ipsum bibendum sollicitudin. Suspendisse metus leo, molestie eget tempus et, hendrerit et neque. Morbi a tempor sem.</p>', NULL, NULL, '[]', '', '2011-11-09 09:27:01', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:27:01', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '528', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('37', 'Praesent eu nibh ut leo euismod semper', 'praesent-eu-nibh-ut-leo-euismod-semper', '6', '1', '<p>Curabitur egestas cursus sapien, eu ultricies leo eleifend sed. Nunc eleifend est vitae diam tristique eu venenatis libero tincidunt. Duis vehicula vehicula diam, sit amet sagittis tortor molestie ac. Curabitur vitae libero eu eros bibendum vulputate at et justo.</p>\r\n', '\r\n<p>Integer porttitor orci justo, in viverra leo. Suspendisse lacinia pharetra lectus, et suscipit eros fermentum vitae. Donec sapien felis, convallis dignissim pretium a, interdum vitae ante. Aenean aliquam commodo justo non ornare. Sed pellentesque semper elementum. Sed vel mauris pharetra ipsum bibendum sollicitudin. Suspendisse metus leo, molestie eget tempus et, hendrerit et neque. Morbi a tempor sem.</p>\r\n<p>Integer commodo semper augue, ut placerat velit molestie non. Phasellus in nisi ante. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Donec consequat, massa ac rhoncus eleifend, diam quam luctus risus, a malesuada diam erat quis massa. Morbi eu tellus ac arcu luctus tempor non a mauris. Pellentesque in purus ac libero consequat aliquet in in dolor. Aliquam eget leo ante, ac sagittis metus. Nam ullamcorper, erat vel vestibulum egestas, urna libero varius turpis, non tempus purus diam eget arcu. Nam sed risus sit amet tortor rhoncus dignissim. Morbi nisi dolor, luctus eget feugiat a, adipiscing quis odio. Maecenas in lacus elit, at dictum libero. Proin dapibus augue ac erat elementum euismod in quis odio. Quisque sed est dolor, ac viverra urna. Curabitur imperdiet, neque eget bibendum porttitor, purus enim scelerisque nunc, eget pretium ante nunc et velit.</p>\r\n<p>Quisque mollis hendrerit elit, eu volutpat risus elementum in. Sed rutrum nunc non dui commodo consectetur. Praesent eu nibh ut leo euismod semper. Curabitur porta volutpat ipsum, et ullamcorper ligula sodales at. Integer quis varius est. Nam at nunc vel ligula auctor placerat. Etiam at eros vel urna porttitor egestas vel vel turpis. Praesent non varius dui. Integer id accumsan sapien. Donec sodales ipsum eu sem mollis et faucibus nisl vestibulum. Morbi facilisis euismod magna, ac tincidunt eros vehicula vel. Phasellus condimentum, risus vel sodales tincidunt, dolor lectus egestas dolor, dictum mollis nibh nunc eu tellus. Sed id tellus non odio auctor accumsan a eget quam. Sed ipsum ligula, aliquet ut fringilla eu, varius venenatis nunc. Duis euismod, est ut fringilla ornare, nisi dolor porta elit, vitae lacinia leo erat ac ante.</p>', NULL, NULL, '[]', '', '2011-11-09 09:27:46', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:27:46', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '511', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('38', 'Ut eleifend felis lacus', 'ut-eleifend-felis-lacus', '6', '1', '<p>Quisque mollis hendrerit elit, eu volutpat risus elementum in. Sed rutrum nunc non dui commodo consectetur. Praesent eu nibh ut leo euismod semper. Curabitur porta volutpat ipsum, et ullamcorper ligula sodales at. Integer quis varius est. Nam at nunc vel ligula auctor placerat.</p>\r\n', '\r\n<p>Etiam at eros vel urna porttitor egestas vel vel turpis. Praesent non varius dui. Integer id accumsan sapien. Donec sodales ipsum eu sem mollis et faucibus nisl vestibulum. Morbi facilisis euismod magna, ac tincidunt eros vehicula vel. Phasellus condimentum, risus vel sodales tincidunt, dolor lectus egestas dolor, dictum mollis nibh nunc eu tellus. Sed id tellus non odio auctor accumsan a eget quam. Sed ipsum ligula, aliquet ut fringilla eu, varius venenatis nunc. Duis euismod, est ut fringilla ornare, nisi dolor porta elit, vitae lacinia leo erat ac ante.</p>\r\n<p>In nec augue id urna elementum cursus non nec mi. Sed at orci sit amet diam ornare commodo. Nulla sit amet nisl a elit dignissim luctus venenatis vel nisl. Ut eleifend felis lacus. Sed mi massa, posuere dictum rhoncus ac, aliquet quis massa. Quisque massa neque, commodo pharetra eleifend ut, ullamcorper vitae arcu. Mauris semper hendrerit lacus nec tempor. Nulla pellentesque diam a purus gravida sollicitudin vitae et mauris. Donec purus libero, volutpat at ullamcorper vel, viverra in leo. Suspendisse commodo fermentum neque ac posuere. In ac velit lacus, eu ultricies tellus. Phasellus molestie placerat massa sed bibendum. Aliquam varius turpis pretium metus placerat non consequat leo lobortis. Etiam gravida mauris at augue dictum laoreet.</p>\r\n<p>Pellentesque condimentum nibh rutrum turpis elementum imperdiet. Nulla semper mi ac erat porttitor pretium dictum lectus euismod. Mauris pulvinar bibendum sapien non aliquam. Proin auctor iaculis dictum. Cras sodales, tellus eu posuere lacinia, odio nibh elementum eros, a laoreet lorem augue ut nibh. Duis nunc nisl, feugiat sed iaculis sit amet, bibendum vitae nisl. Fusce eget nunc at eros hendrerit sagittis. Vivamus ac risus tortor. Fusce mattis hendrerit ipsum, id porta mauris sollicitudin sed. Donec rhoncus, sapien nec venenatis varius, est dolor dictum elit, quis mollis ante ligula in leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque vehicula dapibus blandit. Praesent dignissim quam a nunc ornare gravida. Duis id mi a enim gravida adipiscing. Fusce erat nisl, malesuada id eleifend iaculis, pellentesque sed mi.</p>', NULL, NULL, '[]', '', '2011-11-09 09:28:41', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:28:41', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '527', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('39', 'Donec ultricies feugiat facilisis', 'donec-ultricies-feugiat-facilisis', '6', '1', '<p>Pellentesque condimentum nibh rutrum turpis elementum imperdiet. Nulla semper mi ac erat porttitor pretium dictum lectus euismod. Mauris pulvinar bibendum sapien non aliquam. Proin auctor iaculis dictum.</p>\r\n', '\r\n<p>Cras sodales, tellus eu posuere lacinia, odio nibh elementum eros, a laoreet lorem augue ut nibh. Duis nunc nisl, feugiat sed iaculis sit amet, bibendum vitae nisl. Fusce eget nunc at eros hendrerit sagittis. Vivamus ac risus tortor. Fusce mattis hendrerit ipsum, id porta mauris sollicitudin sed. Donec rhoncus, sapien nec venenatis varius, est dolor dictum elit, quis mollis ante ligula in leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque vehicula dapibus blandit. Praesent dignissim quam a nunc ornare gravida. Duis id mi a enim gravida adipiscing. Fusce erat nisl, malesuada id eleifend iaculis, pellentesque sed mi.</p>\r\n<p>Nam scelerisque accumsan tincidunt. Suspendisse bibendum placerat tincidunt. Nam mauris sapien, malesuada ultrices ultricies eu, ornare ac neque. Duis lacus lacus, tempor eget posuere a, facilisis sit amet augue. Pellentesque aliquam hendrerit viverra. Quisque sit amet est mauris, at ornare tortor. Proin id velit nisi. Fusce dictum lobortis cursus. Nam at quam eget nunc volutpat blandit id sit amet tellus. Donec ultricies feugiat facilisis. Mauris laoreet aliquet est, in condimentum eros aliquet eu. Proin viverra vestibulum auctor. Praesent feugiat odio quis justo aliquam accumsan. Etiam fermentum tincidunt arcu at tristique. Vestibulum pellentesque ultrices nulla.</p>\r\n<p>Mauris convallis arcu sit amet sem dignissim faucibus. Duis gravida ipsum libero. Vivamus molestie, tortor aliquet ultrices semper, orci nisl elementum magna, id vulputate lacus arcu sed elit. Suspendisse potenti. Donec eu ante sit amet orci lacinia ultrices. Pellentesque ac neque id lectus porttitor lacinia a quis urna. Nullam fermentum lobortis pulvinar. Morbi ultricies, neque sed tincidunt tristique, felis odio vestibulum erat, nec porta elit ante id velit. Duis auctor pharetra odio, et lobortis lacus commodo sed. Nulla in tellus turpis, non faucibus ipsum. Sed lacinia, velit quis feugiat fermentum, dolor lacus gravida ipsum, ac ullamcorper libero urna vel nisi. Sed ut sem sapien. Nam id nunc quam.</p>', NULL, NULL, '[]', '', '2011-11-09 09:29:27', '44', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:29:27', '0000-00-00 00:00:00', '0', '1', '9', '0', '0', '', '', '', '', '479', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('40', 'Maecenas varius orci dui, a iaculis mi', 'maecenas-varius-orci-dui-a-iaculis-mi', '6', '1', '<p>Mauris convallis arcu sit amet sem dignissim faucibus. Duis gravida ipsum libero. Vivamus molestie, tortor aliquet ultrices semper, orci nisl elementum magna, id vulputate lacus arcu sed elit. Suspendisse potenti. Donec eu ante sit amet orci lacinia ultrices.</p>\r\n', '\r\n<p>Pellentesque ac neque id lectus porttitor lacinia a quis urna. Nullam fermentum lobortis pulvinar. Morbi ultricies, neque sed tincidunt tristique, felis odio vestibulum erat, nec porta elit ante id velit. Duis auctor pharetra odio, et lobortis lacus commodo sed. Nulla in tellus turpis, non faucibus ipsum. Sed lacinia, velit quis feugiat fermentum, dolor lacus gravida ipsum, ac ullamcorper libero urna vel nisi. Sed ut sem sapien. Nam id nunc quam.</p>\r\n<p>Integer ac commodo ligula. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Ut id sollicitudin tortor. Vestibulum tortor dolor, adipiscing a ultricies vel, varius nec elit. Vivamus elementum, est ut vulputate cursus, mauris mi elementum neque, non porttitor est magna in magna. Sed eros ipsum, ultrices ut lacinia congue, interdum bibendum quam. Integer nisl augue, euismod ut luctus ut, mollis et enim. Aliquam lobortis, diam sed vehicula aliquam, ligula nunc scelerisque lorem, at tempor nulla justo a ipsum. Suspendisse a arcu dui, vel facilisis tellus.</p>\r\n<p>Nulla faucibus orci vel sem mollis in hendrerit neque suscipit. Pellentesque imperdiet dapibus tellus vitae aliquam. Maecenas varius orci dui, a iaculis mi. Pellentesque tincidunt fermentum dui, id feugiat diam congue pharetra. Sed sollicitudin nunc ut augue lobortis non ultricies mi ullamcorper. Integer et ligula sit amet justo sodales hendrerit tristique vel tortor. Mauris sed turpis leo, vel semper dolor. Etiam fringilla dolor a neque mollis eu cursus nulla consectetur. Nullam imperdiet, nulla nec laoreet euismod, sem mauris blandit nibh, sit amet bibendum odio metus at est. Suspendisse vehicula mattis elit, non vehicula risus tempus vitae. Aenean id sem et eros consectetur scelerisque. Donec ante nulla, gravida accumsan consequat eget, malesuada et est. Aliquam erat volutpat.</p>', NULL, NULL, '[]', '', '2011-11-09 09:30:15', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:30:15', '0000-00-00 00:00:00', '0', '1', '10', '0', '0', '', '', '', '', '557', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('41', 'Sed at faucibus lacus', 'sed-at-faucibus-lacus', '41', '1', '<p>Nulla faucibus orci vel sem mollis in hendrerit neque suscipit. Pellentesque imperdiet dapibus tellus vitae aliquam. Maecenas varius orci dui, a iaculis mi. Pellentesque tincidunt fermentum dui, id feugiat diam congue pharetra. Sed sollicitudin nunc ut augue lobortis non ultricies mi ullamcorper.</p>\r\n', '\r\n<p>Integer et ligula sit amet justo sodales hendrerit tristique vel tortor. Mauris sed turpis leo, vel semper dolor. Etiam fringilla dolor a neque mollis eu cursus nulla consectetur. Nullam imperdiet, nulla nec laoreet euismod, sem mauris blandit nibh, sit amet bibendum odio metus at est. Suspendisse vehicula mattis elit, non vehicula risus tempus vitae. Aenean id sem et eros consectetur scelerisque. Donec ante nulla, gravida accumsan consequat eget, malesuada et est. Aliquam erat volutpat.</p>\r\n<p>Integer ante nisi, volutpat molestie lobortis at, molestie id dui. Nunc ut posuere sem. Fusce leo turpis, semper sed posuere non, consequat eget est. Morbi ullamcorper velit eget dolor euismod egestas. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus cursus mauris nec enim tempor aliquet. Maecenas condimentum metus sit amet augue laoreet nec cursus nisi vulputate. Sed tincidunt sem ac tortor gravida at venenatis dui pellentesque.</p>\r\n<p>Vivamus nulla mi, pharetra nec pulvinar et, dictum quis nisl. Quisque varius lacus ut lectus gravida adipiscing. Nullam dapibus nibh sit amet dui rhoncus interdum. Nunc tincidunt libero at sem vehicula tempus ac et diam. Sed id dictum sapien. Nulla pellentesque fringilla ipsum, nec tristique tortor mattis id. Aliquam tempor vehicula risus quis luctus. Ut accumsan libero in neque ultricies vel vulputate leo eleifend. Sed at faucibus lacus. Aliquam commodo molestie est ac adipiscing.</p>\r\n<p>Nam convallis fermentum ligula, at cursus sem scelerisque vitae. Curabitur molestie turpis eu nibh porttitor ac ornare felis porttitor. Duis semper, magna at semper ultricies, libero turpis interdum dolor, at molestie metus quam vel ligula. Morbi at diam massa. In hac habitasse platea dictumst. Curabitur rhoncus ornare felis at luctus. Fusce varius tortor ac sem laoreet blandit. Quisque mauris risus, viverra sed semper non, pellentesque a dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin luctus orci vel enim pretium pellentesque.</p>', NULL, NULL, '[]', '', '2011-11-09 09:34:14', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:34:14', '0000-00-00 00:00:00', '0', '1', '8', '0', '0', '', '', '', '', '796', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('42', 'Praesent iaculis placerat velit quis dictum', 'praesent-iaculis-placerat-velit-quis-dictum', '41', '1', '<p>Aenean condimentum sapien a diam consequat faucibus. Suspendisse quis mi est, ut semper libero. Etiam tincidunt suscipit sagittis. Aliquam sed dui ante. Cras ornare pretium velit viverra dictum. Pellentesque tincidunt ultricies ornare. Aenean hendrerit, mi at fermentum tempor, tortor ante imperdiet quam, non bibendum lacus lorem fringilla orci. Nullam bibendum lacinia semper.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Donec feugiat accumsan vestibulum. Maecenas eget laoreet purus. Duis sem orci, elementum vel convallis et, ultricies ornare turpis. Sed pellentesque mi scelerisque velit vestibulum vitae pretium dui tempor. Mauris sit amet metus nec purus dignissim dictum a at ante. Nam nec ultrices arcu. Nullam eu elit nulla, at ornare massa. Suspendisse enim elit, dapibus in laoreet sed, adipiscing vitae lectus. Pellentesque scelerisque nisi bibendum ante sollicitudin tristique. Praesent viverra velit sed diam ullamcorper lacinia.</p>\r\n<p>Donec varius semper velit aliquet malesuada. Nullam libero lacus, interdum in tristique sit amet, congue eget lacus. Nulla ac purus non nisl lacinia feugiat. Pellentesque metus urna, elementum sed aliquam molestie, mollis quis neque. Sed pellentesque hendrerit urna non faucibus. In est orci, vestibulum vel mollis vitae, volutpat a odio. Curabitur neque dui, euismod sed tincidunt quis, sodales ac neque. Nam fringilla blandit faucibus. Nam id elit neque. Ut id consequat lacus. Phasellus ante felis, pretium quis accumsan adipiscing, tempus porttitor augue.</p>\r\n<p>Praesent iaculis placerat velit quis dictum. Mauris nec neque leo, a vehicula neque. Aliquam elit sem, pharetra ac dignissim pellentesque, ullamcorper ut magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi semper elit ut mauris tincidunt ut blandit justo scelerisque. Ut rhoncus felis in lacus fermentum quis posuere ante interdum.</p>', NULL, NULL, '[]', '', '2011-11-09 09:38:39', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:38:39', '0000-00-00 00:00:00', '0', '1', '7', '0', '0', '', '', '', '', '809', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('43', 'Etiam nec massa purus', 'etiam-nec-massa-purus', '41', '1', '<p>Praesent iaculis placerat velit quis dictum. Mauris nec neque leo, a vehicula neque. Aliquam elit sem, pharetra ac dignissim pellentesque, ullamcorper ut magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\r\n', '\r\n<p>Morbi semper elit ut mauris tincidunt ut blandit justo scelerisque. Ut rhoncus felis in lacus fermentum quis posuere ante interdum. Aliquam adipiscing velit vel tellus sollicitudin laoreet. Donec velit velit, venenatis in rhoncus dapibus, dictum vitae metus. Sed sagittis dapibus augue sit amet varius.</p>\r\n<p>Aliquam erat volutpat. Quisque dolor dolor, convallis sed hendrerit sed, luctus sit amet massa. Pellentesque congue pretium diam, non ullamcorper velit iaculis et. Sed in lorem ut dui mattis tempus sed in ligula. Cras a venenatis purus. Integer eleifend tempus ligula, vitae dignissim sapien tincidunt sit amet. Pellentesque vel elit pharetra orci ultrices ultricies ut in mauris. Vestibulum mattis diam non mauris lacinia venenatis. Ut vitae velit vel dolor consequat consectetur. Nunc in pretium augue. Proin eget ante turpis. Vestibulum nisi dolor, tempor et varius quis, interdum id nulla. Maecenas tempus sagittis est vel ultrices. Sed ornare orci congue velit laoreet at varius nibh convallis. Ut in sem vel ligula gravida porttitor.</p>\r\n<p>Duis hendrerit imperdiet mauris sed dignissim. Phasellus venenatis tortor in turpis auctor molestie. Morbi fermentum consequat dolor a egestas. Suspendisse egestas luctus libero, non volutpat felis varius et. Phasellus accumsan tincidunt nulla eu lobortis. Maecenas ipsum urna, hendrerit id aliquam id, commodo id turpis. Etiam nec massa purus. Integer tempus cursus diam nec pretium.</p>\r\n<p>Vivamus facilisis pretium fringilla. Donec et augue nibh, quis sagittis velit. Cras nec eros mauris. Vestibulum posuere massa a tellus feugiat vel lobortis est volutpat. Curabitur a odio tellus. Donec urna ipsum, porttitor eget dignissim vitae, semper quis nisi. Nunc eleifend mattis elit in pretium. Morbi sed elit sagittis quam vehicula lobortis ac a nisl. Praesent vel ipsum dolor.</p>', '{vimeo}26682269{/vimeo}', '{gallery}http://www.flickr.com/photos/lululemonathletica/sets/72157627774053516/with/6192770768/{/gallery}', '[]', '', '2011-11-09 09:39:40', '45', '', '0', '0000-00-00 00:00:00', '2011-11-15 10:56:54', '43', '2011-11-09 09:39:40', '0000-00-00 00:00:00', '0', '1', '6', '0', '0', '', '', '', '', '813', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('44', 'Nam in libero a sem mollis egestas', 'nam-in-libero-a-sem-mollis-egestas', '41', '1', '<p>Vivamus facilisis pretium fringilla. Donec et augue nibh, quis sagittis velit. Cras nec eros mauris. Vestibulum posuere massa a tellus feugiat vel lobortis est volutpat. Curabitur a odio tellus. Donec urna ipsum, porttitor eget dignissim vitae, semper quis nisi. Nunc eleifend mattis elit in pretium. Morbi sed elit sagittis quam vehicula lobortis ac a nisl. Praesent vel ipsum dolor.</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>Quisque non massa odio, eget varius ipsum. Pellentesque nunc lorem, blandit et auctor eu, commodo convallis dui. Nunc posuere elementum odio, ut adipiscing risus convallis eget. Nullam sit amet dui in orci rutrum luctus ac vitae neque. Nunc risus mauris, rutrum vitae pellentesque eget, feugiat quis leo. Praesent egestas imperdiet odio, in pretium velit sollicitudin eu. Donec eget orci et leo dictum viverra nec eu lacus. Pellentesque pellentesque sagittis euismod.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin dignissim congue mauris, scelerisque convallis nisi malesuada ac. Donec aliquet arcu sed turpis mattis lobortis. Maecenas elementum nibh et turpis auctor vehicula porttitor lacus iaculis. Nunc fermentum odio quis odio posuere condimentum. Pellentesque nec pellentesque dui. Mauris ac elit in elit porttitor convallis in quis est. In sed scelerisque augue. Donec vel metus risus, quis molestie felis. Sed vel enim ac libero accumsan porttitor nec eu urna. Pellentesque urna mauris, pharetra et viverra quis, dapibus eu turpis. Aenean facilisis, nisl sed porttitor consectetur, arcu turpis aliquet mi, in blandit enim felis eu orci. Mauris pharetra magna non libero elementum vel interdum nisi dignissim. Duis vitae lobortis tortor. In scelerisque augue nec est ultrices placerat.</p>\r\n<p>&nbsp;</p>\r\n<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar. Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu.</p>', NULL, NULL, '[]', '', '2011-11-09 09:40:23', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:40:23', '0000-00-00 00:00:00', '0', '1', '5', '0', '0', '', '', '', '', '786', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('45', 'Nam in libero a sem mollis egestas', 'nam-in-libero-a-sem-mollis-egestas', '41', '1', '<p>Quisque non massa odio, eget varius ipsum. Pellentesque nunc lorem, blandit et auctor eu, commodo convallis dui. Nunc posuere elementum odio, ut adipiscing risus convallis eget. Nullam sit amet dui in orci rutrum luctus ac vitae neque.</p>\r\n', '\r\n<p>Nunc risus mauris, rutrum vitae pellentesque eget, feugiat quis leo. Praesent egestas imperdiet odio, in pretium velit sollicitudin eu. Donec eget orci et leo dictum viverra nec eu lacus. Pellentesque pellentesque sagittis euismod.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin dignissim congue mauris, scelerisque convallis nisi malesuada ac. Donec aliquet arcu sed turpis mattis lobortis. Maecenas elementum nibh et turpis auctor vehicula porttitor lacus iaculis. Nunc fermentum odio quis odio posuere condimentum. Pellentesque nec pellentesque dui. Mauris ac elit in elit porttitor convallis in quis est. In sed scelerisque augue. Donec vel metus risus, quis molestie felis. Sed vel enim ac libero accumsan porttitor nec eu urna. Pellentesque urna mauris, pharetra et viverra quis, dapibus eu turpis. Aenean facilisis, nisl sed porttitor consectetur, arcu turpis aliquet mi, in blandit enim felis eu orci. Mauris pharetra magna non libero elementum vel interdum nisi dignissim. Duis vitae lobortis tortor. In scelerisque augue nec est ultrices placerat.</p>\r\n<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar. Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu. Suspendisse at velit vel sem dignissim ornare et vitae sem. Proin auctor massa in mauris consequat condimentum. Cras vehicula dignissim nulla ac semper. Nulla aliquet elementum nibh, sed pharetra turpis lacinia ut. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam in libero a sem mollis egestas.</p>', NULL, NULL, '[]', '', '2011-11-09 09:41:55', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:41:55', '0000-00-00 00:00:00', '0', '1', '4', '0', '0', '', '', '', '', '789', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
('46', 'Fusce sed tincidunt tortor', 'fusce-sed-tincidunt-tortor', '41', '1', '<p>Duis ut venenatis nunc. In dolor augue, pulvinar id condimentum eget, malesuada at massa. Nam mauris mauris, egestas sit amet pulvinar id, gravida sit amet lorem. Fusce viverra congue est, ut laoreet augue congue id. Suspendisse volutpat mi nec turpis suscipit ut rhoncus mauris pulvinar.</p>\r\n', '\r\n<p>Nunc metus dolor, accumsan at congue sit amet, iaculis at arcu. Suspendisse at velit vel sem dignissim ornare et vitae sem. Proin auctor massa in mauris consequat condimentum. Cras vehicula dignissim nulla ac semper. Nulla aliquet elementum nibh, sed pharetra turpis lacinia ut. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam in libero a sem mollis egestas.</p>\r\n<p>Mauris viverra nibh egestas augue pellentesque in interdum elit interdum. Mauris fringilla imperdiet orci, ac hendrerit nibh ultricies eget. Morbi ac arcu purus, sit amet facilisis tortor. In at rhoncus eros. Duis quis ante quis tortor hendrerit viverra id et urna. Vestibulum nec elit purus, vel posuere massa. Aliquam arcu ligula, convallis vel hendrerit ut, congue sit amet nisl. In hac habitasse platea dictumst. Maecenas consequat bibendum dui, et rhoncus sapien aliquet id. Phasellus quam odio, dapibus eu tempor in, auctor quis nunc. Integer ligula turpis, convallis et cursus at, elementum quis quam.</p>\r\n<p>Vestibulum venenatis pretium nisi, sed pulvinar mauris imperdiet ac. Vestibulum ultricies hendrerit tempus. Fusce nisi lacus, vulputate at luctus ut, congue ut quam. Nunc ac magna purus, ac hendrerit tortor. Nullam porttitor hendrerit ultrices. Sed aliquam posuere mattis. Integer molestie rhoncus nulla tincidunt fringilla. Nunc porttitor, felis elementum ultricies consequat, libero elit fermentum arcu, scelerisque dapibus augue arcu vitae orci. Fusce sed tincidunt tortor. Phasellus vitae sagittis ante.</p>\r\n<p>Pellentesque posuere augue consectetur sapien lobortis tincidunt. Aenean consectetur laoreet euismod. Nunc vel leo tellus. Mauris consectetur elit id magna pharetra varius. Aliquam erat volutpat. Nulla vulputate turpis nec dui molestie interdum. Ut eros lacus, commodo nec luctus quis, volutpat id elit. Nunc bibendum dignissim tempor.</p>', NULL, NULL, '[]', '', '2011-11-09 09:42:46', '45', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '2011-11-09 09:42:46', '0000-00-00 00:00:00', '0', '1', '3', '0', '0', '', '', '', '', '813', '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*');
